/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.core.processmanager.sqlprocessmanager;

import de.aristaflow.adept2.base.configuration.AbortServiceException;
import de.aristaflow.adept2.base.dbaccess.JDBCDataSource;
import de.aristaflow.adept2.base.service.InternalServiceException;
import de.aristaflow.adept2.base.service.Registry;
import de.aristaflow.adept2.base.sessionmanagement.SessionToken;
import de.aristaflow.adept2.core.checks.processmodel.ProcessTemplateCheck;
import de.aristaflow.adept2.core.processmanager.abstractimplementation.AbstractProcessManager;
import de.aristaflow.adept2.core.processmanager.storage.cachingstorage.CachingStorage;
import de.aristaflow.adept2.core.processmanager.storage.sqlstorage.atomic.SQLHelpRead;
import de.aristaflow.adept2.core.processmanager.storage.sqlstorage.atomic.SQLStorage;
import de.aristaflow.adept2.model.processmodel.Template;
import de.aristaflow.adept2.util.DataSourceException;
import java.net.URI;
import java.util.List;
import java.util.UUID;
import java.util.logging.Level;
import org.apache.commons.configuration.Configuration;

public class SQLProcessManager
extends AbstractProcessManager {
    private JDBCDataSource ds;
    private SQLHelpRead helpRead;

    public SQLProcessManager(Configuration configuration, Registry registry) {
        super(configuration, registry, new String[]{"JDBCDataSource"}, new String[0]);
    }

    @Override
    public void init(URI[] exportedURIs) throws AbortServiceException {
        long start = System.nanoTime();
        super.init(exportedURIs);
        ProcessTemplateCheck[] checks = this.getChecks(this.sessionFactory.getSessionToken(exportedURIs), new Template[0]);
        this.helpRead = new SQLHelpRead(this);
        SQLStorage sqlStorage = new SQLStorage(this.registry, this.sessionFactory, exportedURIs, checks, this.helpRead, this);
        this.templateStorage = sqlStorage.getTemplateStorage();
        this.instanceStorage = sqlStorage.getInstanceStorage();
        this.ds = sqlStorage.getDataSource();
        if (this.CACHE_SIZE > 0) {
            CachingStorage cachingStorage = new CachingStorage(this.templateStorage, this.instanceStorage, this.CACHE_SIZE);
            this.templateStorage = cachingStorage.getTemplateStorage();
            this.instanceStorage = cachingStorage.getInstanceStorage();
        }
        sqlStorage.setTemplateStorage(this.templateStorage);
        if (!this.SKIP_CHECKS) {
            sqlStorage.runChecks();
        }
        try {
            this.templateUpdateLocks = this.templateStorage.getUpdateLocks();
            this.instanceChangeLocks = this.instanceStorage.getChangeLocks();
        }
        catch (DataSourceException dse) {
            throw new InternalServiceException("Failed to restore the persistent locks from the storage.", dse);
        }
        String msg = String.format("The initialisation of the SQLProcessManager needed %,d nano seconds", System.nanoTime() - start);
        this.logger.fine(msg);
    }

    @Override
    protected List<String> findTemplatesReferencing(SessionToken session, UUID referencedTemplateID, boolean topRefs, boolean subRefs) {
        this.logMethodEntry("SQL-specific finding referencing templates", session, "method entry", referencedTemplateID, null, null, null, null);
        try {
            List<String> list = SQLHelpRead.findTemplatesReferencing(referencedTemplateID, topRefs, subRefs, true, this.ds, null);
            return list;
        }
        catch (DataSourceException e) {
            String msg = "A DataSourceException occurred while trying to find the templates referencing the template with ID '%s'. Try to find the referencing templates the recursive way.";
            msg = String.format(msg, referencedTemplateID);
            this.logger.log(Level.WARNING, msg, e);
            List<String> list = super.findTemplatesReferencing(session, referencedTemplateID, topRefs, subRefs);
            return list;
        }
        finally {
            this.logMethodExit("method exit");
        }
    }
}

