/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.core.processmanager.sqlprocessmanager;

import de.aristaflow.adept2.base.configuration.AbortServiceException;
import de.aristaflow.adept2.base.dbaccess.JDBCDataSource;
import de.aristaflow.adept2.base.service.InternalServiceException;
import de.aristaflow.adept2.base.service.Registry;
import de.aristaflow.adept2.core.checks.processmodel.ProcessTemplateCheck;
import de.aristaflow.adept2.core.processmanager.abstractimplementation.AbstractProcessManager;
import de.aristaflow.adept2.core.processmanager.storage.cachingstorage.CachingStorage;
import de.aristaflow.adept2.core.processmanager.storage.sqlstorage.SQLXMLStorage;
import de.aristaflow.adept2.model.processmodel.Template;
import de.aristaflow.adept2.util.DataSourceException;
import java.net.URI;
import org.apache.commons.configuration.Configuration;

public class SQLXMLProcessManager
extends AbstractProcessManager {
    public SQLXMLProcessManager(Configuration configuration, Registry registry) {
        super(configuration, registry, new String[]{"JDBCDataSource"}, new String[0]);
    }

    @Override
    public void init(URI[] exportedURIs) throws AbortServiceException {
        long start = System.nanoTime();
        super.init(exportedURIs);
        ProcessTemplateCheck[] checks = this.getChecks(this.sessionFactory.getSessionToken(exportedURIs), new Template[0]);
        JDBCDataSource dataSource = this.registry.getServiceOfType(this.sessionFactory.getSessionToken(this.getURIs()), "JDBCDataSource", JDBCDataSource.class);
        SQLXMLStorage sqlStorage = new SQLXMLStorage(this.registry, dataSource, checks);
        this.templateStorage = sqlStorage.getTemplateStorage();
        this.instanceStorage = sqlStorage.getInstanceStorage();
        if (this.CACHE_SIZE > 0) {
            CachingStorage cachingStorage = new CachingStorage(this.templateStorage, this.instanceStorage, this.CACHE_SIZE);
            this.templateStorage = cachingStorage.getTemplateStorage();
            this.instanceStorage = cachingStorage.getInstanceStorage();
        }
        sqlStorage.setTemplateStorage(this.templateStorage);
        if (!this.SKIP_CHECKS) {
            sqlStorage.runChecks();
        }
        try {
            this.templateUpdateLocks = this.templateStorage.getUpdateLocks();
            this.instanceChangeLocks = this.instanceStorage.getChangeLocks();
        }
        catch (DataSourceException dse) {
            throw new InternalServiceException("Failed to restore the persistent locks from the storage.", dse);
        }
        String msg = String.format("The initialisation of the SQLXMLProcessManager needed %,d nano seconds", System.nanoTime() - start);
        this.logger.fine(msg);
    }
}

