/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.core.processmanager.storage;

import de.aristaflow.adept2.base.sessionmanagement.QualifiedAgent;
import de.aristaflow.adept2.model.common.PluginData;
import de.aristaflow.adept2.model.execution.Enquiry;
import de.aristaflow.adept2.model.execution.ExecutableInstance;
import de.aristaflow.adept2.model.execution.defaultimplementation.DefaultExecutableInstance;
import de.aristaflow.adept2.model.globals.ProcessConstants;
import de.aristaflow.adept2.model.processmodel.EBPInstanceReference;
import de.aristaflow.adept2.model.processmodel.Template;
import de.aristaflow.adept2.model.processmodel.defaultimplementation.DefaultInstance;
import de.aristaflow.adept2.model.processmodel.defaultimplementation.DefaultProcessModelFactory;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.apache.commons.configuration.Configuration;

public class ExecutableProcessModelFactory
extends DefaultProcessModelFactory {
    public ExecutableProcessModelFactory(Configuration configuration) {
        super(configuration);
    }

    @Override
    public DefaultInstance createInstance(UUID id, UUID logID, String name, boolean isModified, UUID baseTemplateID, Template template, QualifiedAgent supervisorAgent, QualifiedAgent initiatorAgent, EBPInstanceReference ebpInstanceReference, long creationTime, Map<Integer, ProcessConstants.NodeState> nodeStates, Map<Integer, Integer> nodeIterations, Map<Integer, ProcessConstants.ExecutionMode> nodeExecutionModes, Map<Integer, List<UUID>> nodeLWPInstanceIDs, Map<Integer, QualifiedAgent> activityAgents, Map<String, Set<String>> pluginDataContainer, Map<String, PluginData> pluginData, Map<String, String> userAttributes) {
        if (this.createsChangeableObjects()) {
            return super.createInstance(id, logID, name, isModified, baseTemplateID, template, supervisorAgent, initiatorAgent, ebpInstanceReference, creationTime, (Map)nodeStates, (Map)nodeIterations, (Map)nodeExecutionModes, (Map)nodeLWPInstanceIDs, (Map)activityAgents, (Map)pluginDataContainer, (Map)pluginData, (Map)userAttributes);
        }
        DefaultExecutableInstance instance = new DefaultExecutableInstance(id, logID, name, baseTemplateID, template, supervisorAgent, initiatorAgent, ebpInstanceReference, creationTime);
        instance.setModified(isModified);
        for (Map.Entry<Integer, ProcessConstants.NodeState> entry : nodeStates.entrySet()) {
            instance.setNodeState(entry.getKey(), entry.getValue());
        }
        for (Map.Entry<Integer, Object> entry : nodeIterations.entrySet()) {
            instance.setNodeIteration(entry.getKey(), (Integer)entry.getValue());
        }
        for (Map.Entry<Integer, Object> entry : nodeExecutionModes.entrySet()) {
            instance.setExecutionMode(entry.getKey(), (ProcessConstants.ExecutionMode)((Object)entry.getValue()));
        }
        for (Map.Entry<Integer, Object> entry : nodeLWPInstanceIDs.entrySet()) {
            instance.setNodeLWPInstanceID(entry.getKey(), (List)entry.getValue());
        }
        for (Map.Entry<Integer, Object> entry : activityAgents.entrySet()) {
            instance.setNodeAgent(entry.getKey(), (QualifiedAgent)entry.getValue());
        }
        if (pluginDataContainer != null) {
            for (Map.Entry<Object, Object> entry : pluginDataContainer.entrySet()) {
                for (String pluginID : (Set)entry.getValue()) {
                    if (!pluginData.containsKey(pluginID)) continue;
                    instance.addSupportedPlugin((String)entry.getKey(), pluginID, pluginData.get(pluginID));
                }
            }
        }
        instance.setUserAttributes(userAttributes);
        return instance;
    }

    public ExecutableInstance createInstance(UUID instanceID, UUID logID, String instanceName, UUID baseTemplateID, Template template, QualifiedAgent supervisorAgent, QualifiedAgent initiatorAgent, EBPInstanceReference parentReference, long creationTime) {
        return new DefaultExecutableInstance(instanceID, logID, instanceName, baseTemplateID, template, supervisorAgent, initiatorAgent, parentReference, creationTime);
    }

    public ExecutableInstance createExecutableInstance(UUID instanceID, UUID logID, String instanceName, boolean modified, UUID baseTemplateID, Template template, QualifiedAgent supervisorAgent, QualifiedAgent initiatorAgent, EBPInstanceReference parentReference, long creationTime, Map<Integer, ProcessConstants.NodeState> nodeStates, Map<Integer, ProcessConstants.ExecutionMode> executionModes, Map<Integer, Integer> nodeIterations, Map<Integer, List<UUID>> nodeLWPInstanceIDs, Map<Integer, QualifiedAgent> nodePerformingAgents, Map<Integer, List<Enquiry>> currentEnquiries, Map<Integer, Enquiry> repliedEnquiries, URI[] instanceTerminationCallbackURIs, Map<Integer, URI[]> runtimeManagerURIs, Map<String, Set<String>> supportedPlugins, Map<String, PluginData> pluginData, Map<String, String> userAttributes) {
        return new DefaultExecutableInstance(instanceID, logID, instanceName, modified, baseTemplateID, template, supervisorAgent, initiatorAgent, parentReference, creationTime, nodeStates, executionModes, nodeIterations, nodeLWPInstanceIDs, nodePerformingAgents, currentEnquiries, repliedEnquiries, instanceTerminationCallbackURIs, runtimeManagerURIs, supportedPlugins, pluginData, userAttributes);
    }
}

