/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.core.processmanager.storage;

import de.aristaflow.adept2.base.sessionmanagement.QualifiedAgent;
import de.aristaflow.adept2.core.processmanager.storage.ExecutableProcessModelFactory;
import de.aristaflow.adept2.model.common.PluginData;
import de.aristaflow.adept2.model.execution.Enquiry;
import de.aristaflow.adept2.model.execution.ExecutableInstance;
import de.aristaflow.adept2.model.globals.ActivityConstants;
import de.aristaflow.adept2.model.globals.ProcessConstants;
import de.aristaflow.adept2.model.processmodel.ChangeableInstance;
import de.aristaflow.adept2.model.processmodel.EBPInstanceReference;
import de.aristaflow.adept2.model.processmodel.Instance;
import de.aristaflow.adept2.model.processmodel.InstanceStatus;
import de.aristaflow.adept2.model.processmodel.Node;
import de.aristaflow.adept2.model.processmodel.ProcessModelFactory;
import de.aristaflow.adept2.model.processmodel.Template;
import de.aristaflow.adept2.model.processmodel.TemplateStatus;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;

public class ProcessManagerStorageTools {
    protected static final ExecutableProcessModelFactory pmf = new ExecutableProcessModelFactory(null);
    protected static final ProcessModelFactory pmfChangeable = new ExecutableProcessModelFactory(null);

    @Deprecated
    public static ExecutableInstance changeableToExecutableInstance(ChangeableInstance inst) {
        return ProcessManagerStorageTools.changeableToExecutableInstance(inst, null);
    }

    public static ExecutableInstance changeableToExecutableInstance(ChangeableInstance inst, ExecutableInstance execInst) {
        Set<Node> nodes = inst.getTemplate().getNodes();
        HashMap<Integer, ProcessConstants.NodeState> nodeStates = new HashMap<Integer, ProcessConstants.NodeState>();
        for (Node node : nodes) {
            nodeStates.put(node.getID(), inst.getNodeState(node.getID()));
        }
        HashMap<Integer, Integer> nodeIterations = new HashMap<Integer, Integer>();
        for (Node node : nodes) {
            nodeIterations.put(node.getID(), inst.getNodeIteration(node.getID()));
        }
        HashMap<Integer, ProcessConstants.ExecutionMode> nodeExecutionModes = new HashMap<Integer, ProcessConstants.ExecutionMode>();
        for (Node node : nodes) {
            nodeExecutionModes.put(node.getID(), inst.getExecutionMode(node.getID()));
        }
        HashMap<Integer, List<UUID>> nodeLWPInstanceIDs = new HashMap<Integer, List<UUID>>();
        for (Node node : nodes) {
            ArrayList<UUID> list = new ArrayList<UUID>(inst.getNodeLWPInstanceID(node.getID()));
            nodeLWPInstanceIDs.put(node.getID(), list);
        }
        HashMap<Integer, QualifiedAgent> activityAgents = new HashMap<Integer, QualifiedAgent>();
        for (Node node : nodes) {
            activityAgents.put(node.getID(), inst.getPerformingAgent(node.getID()));
        }
        UUID id = inst.getID();
        UUID logID = inst.getLogID();
        String name = inst.getName();
        boolean isModified = inst.isModified();
        UUID baseTemplateID = inst.getBaseTemplateID();
        Template template = inst.getTemplate();
        QualifiedAgent supervisorAgent = inst.getSupervisorAgent();
        QualifiedAgent initiatorAgent = inst.getInitiatorAgent();
        EBPInstanceReference ebpInstanceReference = inst.getParentEBPReference();
        long creationTime = inst.getCreationTime();
        Map<String, Set<String>> supportedPlugins = inst.getSupportedPlugins();
        Map<String, PluginData> pluginData = inst.getPluginDatas();
        Map<String, String> userAttributes = inst.getUserAttributes();
        HashMap<Integer, List<Enquiry>> currentEnquiries = new HashMap<Integer, List<Enquiry>>();
        HashMap<Integer, Enquiry> repliedEnquiries = new HashMap<Integer, Enquiry>();
        HashMap<Integer, URI[]> runtimeManagerURIs = new HashMap<Integer, URI[]>();
        URI[] instanceTerminationCallbackURIs = new URI[]{};
        if (execInst != null) {
            for (Node node : nodes) {
                int nID = node.getID();
                currentEnquiries.put(nID, execInst.getCurrentEnquiries(nID));
                repliedEnquiries.put(nID, execInst.getRepliedEnquiry(nID));
                runtimeManagerURIs.put(nID, execInst.getAssignedRuntimeManager(nID));
            }
            instanceTerminationCallbackURIs = execInst.getInstanceStateListener();
        }
        ExecutableInstance ret = pmf.createExecutableInstance(id, logID, name, isModified, baseTemplateID, template, supervisorAgent, initiatorAgent, ebpInstanceReference, creationTime, nodeStates, nodeExecutionModes, nodeIterations, nodeLWPInstanceIDs, activityAgents, currentEnquiries, repliedEnquiries, instanceTerminationCallbackURIs, runtimeManagerURIs, supportedPlugins, pluginData, userAttributes);
        return ret;
    }

    public static ChangeableInstance executableToChangeableInstance(ExecutableInstance inst) {
        Set<Node> nodes = inst.getTemplate().getNodes();
        HashMap<Integer, ProcessConstants.NodeState> nodeStates = new HashMap<Integer, ProcessConstants.NodeState>();
        for (Node node : nodes) {
            nodeStates.put(node.getID(), inst.getNodeState(node.getID()));
        }
        HashMap<Integer, Integer> nodeIterations = new HashMap<Integer, Integer>();
        for (Node node : nodes) {
            nodeIterations.put(node.getID(), inst.getNodeIteration(node.getID()));
        }
        HashMap<Integer, ProcessConstants.ExecutionMode> nodeExecutionModes = new HashMap<Integer, ProcessConstants.ExecutionMode>();
        for (Node node : nodes) {
            nodeExecutionModes.put(node.getID(), inst.getExecutionMode(node.getID()));
        }
        HashMap<Integer, List<UUID>> nodeLWPInstanceIDs = new HashMap<Integer, List<UUID>>();
        for (Node node : nodes) {
            ArrayList<UUID> list = new ArrayList<UUID>(inst.getNodeLWPInstanceID(node.getID()));
            nodeLWPInstanceIDs.put(node.getID(), list);
        }
        HashMap<Integer, QualifiedAgent> activityAgents = new HashMap<Integer, QualifiedAgent>();
        for (Node node : nodes) {
            activityAgents.put(node.getID(), inst.getPerformingAgent(node.getID()));
        }
        UUID id = inst.getID();
        UUID logID = inst.getLogID();
        String name = inst.getName();
        boolean isModified = inst.isModified();
        UUID baseTemplateID = inst.getBaseTemplateID();
        Template template = inst.getTemplate();
        QualifiedAgent supervisorAgent = inst.getSupervisorAgent();
        QualifiedAgent initiatorAgent = inst.getInitiatorAgent();
        EBPInstanceReference ebpInstanceReference = inst.getParentEBPReference();
        long creationTime = inst.getCreationTime();
        Map<String, Set<String>> supportedPlugins = inst.getSupportedPlugins();
        Map<String, PluginData> pluginData = inst.getPluginDatas();
        Map<String, String> userAttributes = inst.getUserAttributes();
        pmfChangeable.setCreateChangeable(true);
        return (ChangeableInstance)pmfChangeable.createInstance(id, logID, name, isModified, baseTemplateID, template, supervisorAgent, initiatorAgent, ebpInstanceReference, creationTime, nodeStates, nodeIterations, nodeExecutionModes, nodeLWPInstanceIDs, activityAgents, supportedPlugins, pluginData, userAttributes);
    }

    public static TemplateStatus getDefaultTemplateStatus(UUID templateID) {
        pmf.setCreateChangeable(false);
        return pmf.createDefaultTemplateStatus(templateID);
    }

    public static InstanceStatus getDefaultInstanceStatus(UUID instanceID) {
        pmf.setCreateChangeable(false);
        return pmf.createInstanceStatus(instanceID, ProcessConstants.InstanceMigrationStatus.IM_MIGRATABLE, "initial instance status", ProcessConstants.InstanceExecutionStatus.IE_RUNNING, "initial instance status");
    }

    public static Template changeTemplateValues(Template template, UUID newID) {
        HashMap<Integer, ProcessModelFactory.StructuralNodeData> structuralNodeData = new HashMap<Integer, ProcessModelFactory.StructuralNodeData>();
        HashMap<Integer, List<Integer>> nodeDisabledConnectors = new HashMap<Integer, List<Integer>>();
        for (Node node : template.getNodes()) {
            int nodeID = node.getID();
            pmf.setCreateChangeable(false);
            ProcessModelFactory.StructuralNodeData snd = pmf.createStructuralNodeData(nodeID, template.getNodeType(nodeID), template.getNodeTopologicalID(nodeID), template.getNodeBranchID(nodeID), template.getNodeSplitNodeID(nodeID), template.getNodeCorrespondingBlockNodeID(nodeID));
            structuralNodeData.put(nodeID, snd);
            LinkedList<Integer> disabledConnectors = new LinkedList<Integer>();
            ActivityConstants.AccessType[] accessTypeArray = ActivityConstants.AccessType.values();
            int n = accessTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                ActivityConstants.AccessType accessType = accessTypeArray[n2];
                int[] nArray = template.getDisabledConnectors(nodeID, accessType);
                int n3 = nArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    int connector = nArray[n4];
                    disabledConnectors.add(connector);
                    ++n4;
                }
                ++n2;
            }
            nodeDisabledConnectors.put(nodeID, disabledConnectors);
        }
        pmf.setCreateChangeable(false);
        Template newTemplate = pmf.createTemplate(newID, template.getName(), template.getDescription(), template.getConfigurationDescription(), template.getConfiguration(), template.getTestConfiguration(), template.getProcessType(), template.getSupervisorAgent(), template.getVersion(), template.getParameters(ActivityConstants.AccessType.READ), template.getParameters(ActivityConstants.AccessType.WRITE), template.getDeltaLayer(), template.getNodes(), template.getDataElements(), template.getEdgeStructure(new ProcessConstants.EdgeType[0]), template.getDataEdgeStructure(), template.getConstraintEdgeStructure(), structuralNodeData, nodeDisabledConnectors, template.getStartNode().getID(), template.getEndNode().getID(), template.getInstanceNameTemplate(), template.getSupportedPlugins(), template.getPluginDatas(), template.getUserAttributes());
        return newTemplate;
    }

    public static ExecutableInstance changeInstanceValues(Instance inst, Template newTemplate) {
        Set<Node> nodes = inst.getTemplate().getNodes();
        HashMap<Integer, ProcessConstants.NodeState> nodeStates = new HashMap<Integer, ProcessConstants.NodeState>();
        for (Node node : nodes) {
            nodeStates.put(node.getID(), inst.getNodeState(node.getID()));
        }
        HashMap<Integer, Integer> nodeIterations = new HashMap<Integer, Integer>();
        for (Node node : nodes) {
            nodeIterations.put(node.getID(), inst.getNodeIteration(node.getID()));
        }
        HashMap<Integer, ProcessConstants.ExecutionMode> nodeExecutionModes = new HashMap<Integer, ProcessConstants.ExecutionMode>();
        for (Node node : nodes) {
            nodeExecutionModes.put(node.getID(), inst.getExecutionMode(node.getID()));
        }
        HashMap<Integer, Object> nodeLWPInstanceIDs = new HashMap<Integer, Object>();
        for (Node node : nodes) {
            ArrayList<UUID> list = new ArrayList<UUID>(inst.getNodeLWPInstanceID(node.getID()));
            nodeLWPInstanceIDs.put(node.getID(), list);
        }
        HashMap<Integer, QualifiedAgent> activityAgents = new HashMap<Integer, QualifiedAgent>();
        for (Node node : nodes) {
            activityAgents.put(node.getID(), inst.getPerformingAgent(node.getID()));
        }
        UUID id = inst.getID();
        UUID logID = inst.getLogID();
        String name = inst.getName();
        boolean isModified = inst.isModified();
        UUID baseTemplateID = inst.getBaseTemplateID();
        QualifiedAgent supervisorAgent = inst.getSupervisorAgent();
        QualifiedAgent initiatorAgent = inst.getInitiatorAgent();
        EBPInstanceReference ebpInstanceReference = inst.getParentEBPReference();
        long creationTime = inst.getCreationTime();
        Map<String, Set<String>> supportedPlugins = inst.getSupportedPlugins();
        Map<String, PluginData> pluginData = inst.getPluginDatas();
        Map<String, String> userAttributes = inst.getUserAttributes();
        pmf.setCreateChangeable(false);
        return (ExecutableInstance)pmf.createInstance(id, logID, name, isModified, baseTemplateID, newTemplate, supervisorAgent, initiatorAgent, ebpInstanceReference, creationTime, nodeStates, nodeIterations, nodeExecutionModes, nodeLWPInstanceIDs, activityAgents, (Map)supportedPlugins, (Map)pluginData, (Map)userAttributes);
    }

    public static ChangeableInstance changeInstanceValues(Instance inst, UUID newID, Template newTemplate) {
        Set<Node> nodes = inst.getTemplate().getNodes();
        HashMap<Integer, ProcessConstants.NodeState> nodeStates = new HashMap<Integer, ProcessConstants.NodeState>();
        for (Node node : nodes) {
            nodeStates.put(node.getID(), inst.getNodeState(node.getID()));
        }
        HashMap<Integer, Integer> nodeIterations = new HashMap<Integer, Integer>();
        for (Node node : nodes) {
            nodeIterations.put(node.getID(), inst.getNodeIteration(node.getID()));
        }
        HashMap<Integer, ProcessConstants.ExecutionMode> nodeExecutionModes = new HashMap<Integer, ProcessConstants.ExecutionMode>();
        for (Node node : nodes) {
            nodeExecutionModes.put(node.getID(), inst.getExecutionMode(node.getID()));
        }
        HashMap<Integer, Object> nodeLWPInstanceIDs = new HashMap<Integer, Object>();
        for (Node node : nodes) {
            ArrayList<UUID> list = new ArrayList<UUID>(inst.getNodeLWPInstanceID(node.getID()));
            nodeLWPInstanceIDs.put(node.getID(), list);
        }
        HashMap<Integer, QualifiedAgent> activityAgents = new HashMap<Integer, QualifiedAgent>();
        for (Node node : nodes) {
            activityAgents.put(node.getID(), inst.getPerformingAgent(node.getID()));
        }
        UUID logID = inst.getLogID();
        String name = inst.getName();
        boolean isModified = inst.isModified();
        UUID baseTemplateID = inst.getBaseTemplateID();
        QualifiedAgent supervisorAgent = inst.getSupervisorAgent();
        QualifiedAgent initiatorAgent = inst.getInitiatorAgent();
        EBPInstanceReference ebpInstanceReference = inst.getParentEBPReference();
        long creationTime = inst.getCreationTime();
        Map<String, Set<String>> supportedPlugins = inst.getSupportedPlugins();
        Map<String, PluginData> pluginData = inst.getPluginDatas();
        Map<String, String> userAttributes = inst.getUserAttributes();
        pmf.setCreateChangeable(true);
        return (ChangeableInstance)pmf.createInstance(newID, logID, name, isModified, baseTemplateID, newTemplate, supervisorAgent, initiatorAgent, ebpInstanceReference, creationTime, nodeStates, nodeIterations, nodeExecutionModes, nodeLWPInstanceIDs, activityAgents, (Map)supportedPlugins, (Map)pluginData, (Map)userAttributes);
    }

    public static InstanceStatus changeInstanceStatusValues(InstanceStatus status, UUID newInstanceID) {
        pmf.setCreateChangeable(false);
        return pmf.createInstanceStatus(newInstanceID, status.getMigrationStatus(), status.getMigrationStatusComment(), status.getExecutionStatus(), status.getExecutionStatusComment());
    }
}

