/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.core.processmanager.storage.cachingstorage;

import de.aristaflow.adept2.base.sessionmanagement.QualifiedAgent;
import de.aristaflow.adept2.core.processmanager.TemplateStatusProvider;
import de.aristaflow.adept2.core.processmanager.storage.InstanceStorage;
import de.aristaflow.adept2.core.processmanager.storage.ProcessManagerStorage;
import de.aristaflow.adept2.core.processmanager.storage.ProcessManagerStorageTools;
import de.aristaflow.adept2.core.processmanager.storage.TemplateStorage;
import de.aristaflow.adept2.model.execution.ExecutableInstance;
import de.aristaflow.adept2.model.execution.ExecutableInstancePropertyTracker;
import de.aristaflow.adept2.model.processmodel.ChangeableInstance;
import de.aristaflow.adept2.model.processmodel.EBPInstanceReference;
import de.aristaflow.adept2.model.processmodel.InstanceReference;
import de.aristaflow.adept2.model.processmodel.InstanceStatus;
import de.aristaflow.adept2.model.processmodel.Template;
import de.aristaflow.adept2.model.processmodel.TemplateReference;
import de.aristaflow.adept2.model.processmodel.TemplateStatus;
import de.aristaflow.adept2.util.Cache;
import de.aristaflow.adept2.util.DataSourceException;
import de.aristaflow.adept2.util.LoggerTools;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CachingStorage
implements ProcessManagerStorage,
TemplateStorage,
InstanceStorage {
    private final Logger logger = LoggerTools.getLogger(this);
    private final TemplateStorage templateStorage;
    private final InstanceStorage instanceStorage;
    protected final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    protected final Map<UUID, Template> templateCache;
    protected final Map<UUID, TemplateStatus> templateStatusCache;
    protected final Map<UUID, TemplateReference> templateReferenceCache;
    protected final Map<UUID, UUID> parentTemplateIDCache;
    protected final Map<UUID, ExecutableInstance> instanceCache;
    protected final Map<UUID, UUID> logicalInstanceIDCache;
    protected final Map<UUID, InstanceStatus> instanceStatusCache;
    protected final Map<UUID, InstanceReference> instanceReferenceCache;
    protected final Map<UUID, UUID> baseTemplateIDCache;

    public CachingStorage(TemplateStorage templateStorage, InstanceStorage instanceStorage, long cacheSize) {
        this.templateStorage = templateStorage;
        this.instanceStorage = instanceStorage;
        this.templateCache = Collections.synchronizedMap(new Cache(cacheSize));
        this.templateStatusCache = Collections.synchronizedMap(new Cache(cacheSize));
        this.templateReferenceCache = Collections.synchronizedMap(new Cache(cacheSize));
        this.parentTemplateIDCache = Collections.synchronizedMap(new Cache(cacheSize));
        this.instanceCache = Collections.synchronizedMap(new Cache(cacheSize));
        this.logicalInstanceIDCache = Collections.synchronizedMap(new Cache(cacheSize));
        this.instanceStatusCache = Collections.synchronizedMap(new Cache(cacheSize));
        this.instanceReferenceCache = Collections.synchronizedMap(new Cache(cacheSize));
        this.baseTemplateIDCache = Collections.synchronizedMap(new Cache(cacheSize));
    }

    @Override
    public InstanceStorage getInstanceStorage() {
        return this;
    }

    @Override
    public TemplateStorage getTemplateStorage() {
        return this;
    }

    @Override
    public void createTemplate(Template template, TemplateStatus templateStatus) throws DataSourceException {
        this.lock.writeLock().lock();
        try {
            this.templateStorage.createTemplate(template, templateStatus);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public Set<UUID> getAllTemplateIDs() throws DataSourceException {
        return this.templateStorage.getAllTemplateIDs();
    }

    @Override
    public Template getTemplate(UUID templateID) throws DataSourceException {
        Template template = this.templateCache.get(templateID);
        if (template == null) {
            template = this.templateStorage.getTemplate(templateID);
            this.templateCache.put(templateID, template);
        }
        return template;
    }

    @Override
    public TemplateReference getTemplateReference(UUID templateID, TemplateStatusProvider statusProvider) throws DataSourceException {
        this.lock.readLock().lock();
        try {
            TemplateReference templateRef = this.templateReferenceCache.get(templateID);
            if (templateRef == null) {
                this.lock.readLock().unlock();
                this.lock.writeLock().lock();
                try {
                    templateRef = this.templateReferenceCache.get(templateID);
                    if (templateRef == null) {
                        templateRef = this.templateStorage.getTemplateReference(templateID, statusProvider);
                        this.templateReferenceCache.put(templateID, templateRef);
                    }
                }
                finally {
                    this.lock.readLock().lock();
                    this.lock.writeLock().unlock();
                }
            }
            TemplateReference templateReference = templateRef;
            return templateReference;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public TemplateStatus getTemplateStatus(UUID templateID) throws DataSourceException {
        this.lock.readLock().lock();
        try {
            TemplateStatus templateStatus = this.templateStatusCache.get(templateID);
            if (templateStatus == null) {
                this.lock.readLock().unlock();
                this.lock.writeLock().lock();
                try {
                    templateStatus = this.templateStatusCache.get(templateID);
                    if (templateStatus == null) {
                        templateStatus = this.templateStorage.getTemplateStatus(templateID);
                        this.templateStatusCache.put(templateID, templateStatus);
                    }
                }
                finally {
                    this.lock.readLock().lock();
                    this.lock.writeLock().unlock();
                }
            }
            TemplateStatus templateStatus2 = templateStatus;
            return templateStatus2;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public void updateTemplateStatus(TemplateStatus templateStatus) throws DataSourceException {
        this.lock.writeLock().lock();
        try {
            this.templateStorage.updateTemplateStatus(templateStatus);
            this.templateStatusCache.remove(templateStatus.getTemplateID());
            this.templateReferenceCache.remove(templateStatus.getTemplateID());
            for (UUID instanceID : this.getInstanceIDsForTemplate(templateStatus.getTemplateID())) {
                this.instanceReferenceCache.remove(instanceID);
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public void updateEmbeddedTemplateIDs(UUID embeddedID, UUID parentID) throws DataSourceException {
        this.lock.writeLock().lock();
        try {
            this.templateStorage.updateEmbeddedTemplateIDs(embeddedID, parentID);
            this.parentTemplateIDCache.remove(embeddedID);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public UUID getParentTemplateID(UUID embeddedID) throws DataSourceException {
        this.lock.readLock().lock();
        try {
            UUID ret = this.parentTemplateIDCache.get(embeddedID);
            if (ret == null) {
                this.lock.readLock().unlock();
                this.lock.writeLock().lock();
                try {
                    ret = this.parentTemplateIDCache.get(embeddedID);
                    if (ret == null) {
                        ret = this.templateStorage.getParentTemplateID(embeddedID);
                        this.parentTemplateIDCache.put(embeddedID, ret);
                    }
                }
                finally {
                    this.lock.readLock().lock();
                    this.lock.writeLock().unlock();
                }
            }
            UUID uUID = ret;
            return uUID;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public int lockTemplateForUpdates(UUID templateID, QualifiedAgent lockingAgent) throws DataSourceException {
        this.lock.writeLock().lock();
        try {
            int n = this.templateStorage.lockTemplateForUpdates(templateID, lockingAgent);
            return n;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public int unlockTemplateForUpdates(UUID templateID) throws DataSourceException {
        this.lock.writeLock().lock();
        try {
            int n = this.templateStorage.unlockTemplateForUpdates(templateID);
            return n;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public Map<UUID, QualifiedAgent> getUpdateLocks() throws DataSourceException {
        return this.templateStorage.getUpdateLocks();
    }

    @Override
    public ExecutableInstance createInstance(UUID templateID, String instanceName, QualifiedAgent supervisorAgent, QualifiedAgent initiatorAgent, EBPInstanceReference parentActivity, long creationTime) throws DataSourceException {
        this.lock.writeLock().lock();
        try {
            ExecutableInstance instance = this.instanceStorage.createInstance(templateID, instanceName, supervisorAgent, initiatorAgent, parentActivity, creationTime);
            this.instanceCache.put(instance.getID(), instance);
            ExecutableInstance executableInstance = instance;
            return executableInstance;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public UUID getLogicalInstanceID(UUID logID) {
        this.lock.readLock().lock();
        try {
            UUID logicalID = this.logicalInstanceIDCache.get(logID);
            if (logicalID == null) {
                this.lock.readLock().unlock();
                this.lock.writeLock().lock();
                try {
                    logicalID = this.logicalInstanceIDCache.get(logID);
                    if (logicalID == null) {
                        logicalID = this.instanceStorage.getLogicalInstanceID(logID);
                        this.logicalInstanceIDCache.put(logID, logicalID);
                    }
                }
                finally {
                    this.lock.readLock().lock();
                    this.lock.writeLock().unlock();
                }
            }
            UUID uUID = logicalID;
            return uUID;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public ExecutableInstance getInstance(UUID instanceID) throws DataSourceException {
        this.lock.readLock().lock();
        try {
            ExecutableInstance instance = this.instanceCache.get(instanceID);
            if (instance == null) {
                this.lock.readLock().unlock();
                this.lock.writeLock().lock();
                try {
                    instance = this.instanceCache.get(instanceID);
                    if (instance == null) {
                        instance = this.instanceStorage.getInstance(instanceID);
                        this.instanceCache.put(instanceID, instance);
                    }
                }
                finally {
                    this.lock.readLock().lock();
                    this.lock.writeLock().unlock();
                }
            }
            ExecutableInstance executableInstance = instance;
            return executableInstance;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public InstanceReference getInstanceReference(UUID instanceID, TemplateStatusProvider statusProvider) throws DataSourceException {
        this.lock.readLock().lock();
        try {
            InstanceReference instanceRef = this.instanceReferenceCache.get(instanceID);
            if (instanceRef == null) {
                this.lock.readLock().unlock();
                this.lock.writeLock().lock();
                try {
                    instanceRef = this.instanceReferenceCache.get(instanceID);
                    if (instanceRef == null) {
                        instanceRef = this.instanceStorage.getInstanceReference(instanceID, statusProvider);
                        this.instanceReferenceCache.put(instanceID, instanceRef);
                    }
                }
                finally {
                    this.lock.readLock().lock();
                    this.lock.writeLock().unlock();
                }
            }
            InstanceReference instanceReference = instanceRef;
            return instanceReference;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public ChangeableInstance getInstanceChangeable(UUID instanceID) throws DataSourceException {
        this.lock.readLock().lock();
        try {
            ChangeableInstance changeableInstance;
            ExecutableInstance instance = this.instanceCache.get(instanceID);
            if (instance == null) {
                this.lock.readLock().unlock();
                this.lock.writeLock().lock();
                try {
                    instance = this.instanceCache.get(instanceID);
                    if (instance == null) {
                        changeableInstance = this.instanceStorage.getInstanceChangeable(instanceID);
                    }
                    changeableInstance = ProcessManagerStorageTools.executableToChangeableInstance(instance);
                }
                finally {
                    this.lock.readLock().lock();
                    this.lock.writeLock().unlock();
                }
            } else {
                changeableInstance = ProcessManagerStorageTools.executableToChangeableInstance(instance);
            }
            ChangeableInstance changeableInstance2 = changeableInstance;
            return changeableInstance2;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public Set<UUID> getInstanceIDsForTemplate(UUID templateID) {
        return this.instanceStorage.getInstanceIDsForTemplate(templateID);
    }

    @Override
    public InstanceStatus getInstanceStatus(UUID instanceID) throws DataSourceException {
        this.lock.readLock().lock();
        try {
            InstanceStatus instanceStatus = this.instanceStatusCache.get(instanceID);
            if (instanceStatus == null) {
                this.lock.readLock().unlock();
                this.lock.writeLock().lock();
                try {
                    instanceStatus = this.instanceStatusCache.get(instanceID);
                    if (instanceStatus == null) {
                        instanceStatus = this.instanceStorage.getInstanceStatus(instanceID);
                        this.instanceStatusCache.put(instanceID, instanceStatus);
                    }
                }
                finally {
                    this.lock.readLock().lock();
                    this.lock.writeLock().unlock();
                }
            }
            InstanceStatus instanceStatus2 = instanceStatus;
            return instanceStatus2;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public void updateInstance(ExecutableInstance instance) throws DataSourceException {
        this.lock.writeLock().lock();
        try {
            this.instanceStorage.updateInstance(instance);
            this.instanceCache.put(instance.getID(), instance);
            this.instanceReferenceCache.remove(instance.getID());
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public UUID updateChangeableInstance(ChangeableInstance instance) throws DataSourceException {
        this.lock.writeLock().lock();
        try {
            UUID templID = instance.getTemplate().getID();
            UUID ret = this.instanceStorage.updateChangeableInstance(instance);
            this.templateCache.remove(templID);
            this.templateReferenceCache.remove(templID);
            this.templateStatusCache.remove(templID);
            this.instanceCache.remove(instance.getID());
            this.instanceReferenceCache.remove(instance.getID());
            this.baseTemplateIDCache.remove(templID);
            UUID uUID = ret;
            return uUID;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public void updateInstanceStatus(InstanceStatus instanceStatus) throws DataSourceException {
        this.lock.writeLock().lock();
        try {
            this.instanceStorage.updateInstanceStatus(instanceStatus);
            this.instanceStatusCache.remove(instanceStatus.getInstanceID());
            this.instanceReferenceCache.remove(instanceStatus.getInstanceID());
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public int lockInstanceForChanging(UUID instanceID, QualifiedAgent lockingAgent) throws DataSourceException {
        this.lock.writeLock().lock();
        try {
            int n = this.instanceStorage.lockInstanceForChanging(instanceID, lockingAgent);
            return n;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public int unlockInstanceForChanging(UUID instanceID) throws DataSourceException {
        this.lock.writeLock().lock();
        try {
            int n = this.instanceStorage.unlockInstanceForChanging(instanceID);
            return n;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public Map<UUID, QualifiedAgent> getChangeLocks() throws DataSourceException {
        return this.instanceStorage.getChangeLocks();
    }

    @Override
    public UUID getBaseTemplateID(UUID templateID) throws DataSourceException {
        this.lock.readLock().lock();
        try {
            UUID ret = this.baseTemplateIDCache.get(templateID);
            if (ret == null) {
                this.lock.readLock().unlock();
                this.lock.writeLock().lock();
                try {
                    ret = this.baseTemplateIDCache.get(templateID);
                    if (ret == null) {
                        ret = this.templateStorage.getBaseTemplateID(templateID);
                        this.baseTemplateIDCache.put(templateID, ret);
                    }
                }
                finally {
                    this.lock.readLock().lock();
                    this.lock.writeLock().unlock();
                }
            }
            UUID uUID = ret;
            return uUID;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public void invalidateUnsavedChanges(UUID instanceID) {
        block7: {
            this.lock.readLock().lock();
            try {
                ExecutableInstancePropertyTracker propertyTracker;
                ExecutableInstance instance = this.instanceCache.get(instanceID);
                if (!(instance instanceof ExecutableInstancePropertyTracker) || (propertyTracker = (ExecutableInstancePropertyTracker)((Object)instance)).getChangedProperties().size() <= 0 && propertyTracker.getChangedNodes().size() <= 0) break block7;
                this.lock.readLock().unlock();
                this.lock.writeLock().lock();
                try {
                    instance = this.instanceCache.get(instanceID);
                    if (instance instanceof ExecutableInstancePropertyTracker && ((propertyTracker = (ExecutableInstancePropertyTracker)((Object)instance)).getChangedProperties().size() > 0 || propertyTracker.getChangedNodes().size() > 0)) {
                        this.logger.log(Level.WARNING, String.format("Discovered unsaved changes in Instance with ID %s, removing from cache. Note: attached stack trace is for tracing purpose and not a caught exception!", instanceID), new Throwable());
                        this.instanceCache.remove(instanceID);
                    }
                }
                finally {
                    this.lock.readLock().lock();
                    this.lock.writeLock().unlock();
                }
            }
            finally {
                this.lock.readLock().unlock();
            }
        }
    }
}

