/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.core.processmanager.storage.simplexmlstorage;

import de.aristaflow.adept2.base.configuration.AbortServiceException;
import de.aristaflow.adept2.base.configuration.ConfigurationException;
import de.aristaflow.adept2.base.service.AbstractADEPT2Service;
import de.aristaflow.adept2.base.service.InternalServiceException;
import de.aristaflow.adept2.base.service.Registry;
import de.aristaflow.adept2.base.service.ServiceNotKnownException;
import de.aristaflow.adept2.base.sessionmanagement.QualifiedAgent;
import de.aristaflow.adept2.base.sessionmanagement.SessionFactory;
import de.aristaflow.adept2.core.checks.processmodel.ProcessTemplateCheck;
import de.aristaflow.adept2.core.checks.processmodel.ProcessTemplateCheckRunner;
import de.aristaflow.adept2.core.processmanager.TemplateStatusProvider;
import de.aristaflow.adept2.core.processmanager.storage.ExecutableProcessModelFactory;
import de.aristaflow.adept2.core.processmanager.storage.InstanceStorage;
import de.aristaflow.adept2.core.processmanager.storage.ProcessManagerStorage;
import de.aristaflow.adept2.core.processmanager.storage.ProcessManagerStorageTools;
import de.aristaflow.adept2.core.processmanager.storage.TemplateStorage;
import de.aristaflow.adept2.model.execution.ExecutableInstance;
import de.aristaflow.adept2.model.execution.ExecutionFactory;
import de.aristaflow.adept2.model.execution.defaultimplementation.DefaultExecutableInstance;
import de.aristaflow.adept2.model.globals.ActivityConstants;
import de.aristaflow.adept2.model.processmodel.ChangeableInstance;
import de.aristaflow.adept2.model.processmodel.EBPInstanceReference;
import de.aristaflow.adept2.model.processmodel.InstanceReference;
import de.aristaflow.adept2.model.processmodel.InstanceStatus;
import de.aristaflow.adept2.model.processmodel.ProcessModelFactory;
import de.aristaflow.adept2.model.processmodel.ProcessModelParameter;
import de.aristaflow.adept2.model.processmodel.Template;
import de.aristaflow.adept2.model.processmodel.TemplateReference;
import de.aristaflow.adept2.model.processmodel.TemplateStatus;
import de.aristaflow.adept2.model.processmodel.tools.NodeRelations;
import de.aristaflow.adept2.model.processmodel.tools.ProcessElementIdentifierTools;
import de.aristaflow.adept2.model.processmodel.xml.ProcessModelXMLExport;
import de.aristaflow.adept2.model.processmodel.xml.ProcessModelXMLHelperTools;
import de.aristaflow.adept2.model.processmodel.xml.ProcessModelXMLImport;
import de.aristaflow.adept2.util.CheckReport;
import de.aristaflow.adept2.util.DataSourceException;
import de.aristaflow.adept2.util.FileSuffixFilter;
import de.aristaflow.adept2.util.NullArgumentException;
import de.aristaflow.adept2.util.UUIDTools;
import de.aristaflow.adept2.util.xml.VersionException;
import de.aristaflow.adept2.util.xml.XMLFormatException;
import de.aristaflow.adept2.util.xml.XMLHelperTools;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.URI;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.UUID;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;
import org.apache.commons.configuration.Configuration;
import org.w3c.dom.Document;

public class SimpleXMLStorage
extends AbstractADEPT2Service
implements ProcessManagerStorage,
TemplateStorage,
InstanceStorage {
    public static final String CONFIGURATION_DATA_DIR = "StorageDataDir";
    public static final String UA_TEMPLATE_UUID = "UUID";
    public static final String FILE_SUFFIX_TEMPLATE = ".template";
    public static final String FILE_SUFFIX_INSTANCE = ".instance";
    public static final String FILE_SUFFIX_TEMP = ".tmp";
    public static final String TEMPLATE_LOCK_FILE = "TmpChng.lock";
    public static final String INSTANCE_LOCK_FILE = "InstncUpdt.lock";
    public static final String EMBEDDED_TEMPLATE_FILE = "EmbdTmplt.IDs";
    public static final String BASE_TEMPLATE_ID_FILE = "BaseTmplt.IDs";
    public static final String MODIFIED_INSTANCES_FILE = "ModInst.IDs";
    private final String dataDirName;
    protected final File dataDir;
    private final Map<UUID, Set<UUID>> templateInstances = new TreeMap<UUID, Set<UUID>>();
    private final Map<UUID, UUID> logicalInstanceIDs = new HashMap<UUID, UUID>();
    protected TemplateStorage templateStorage;
    protected final ProcessModelXMLExport xmlExport = new ProcessModelXMLExport();
    protected final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    protected final URI[] processManagerURIs;

    public SimpleXMLStorage(Configuration configuration, Registry registry, SessionFactory sessionFactory, URI[] processManagerURIs) throws ConfigurationException {
        super(configuration, registry);
        this.sessionFactory = sessionFactory;
        this.processManagerURIs = (URI[])processManagerURIs.clone();
        this.dataDirName = configuration.getString(CONFIGURATION_DATA_DIR);
        if (this.dataDirName == null) {
            String message = String.format("The required configuration value '%s' is not set.", CONFIGURATION_DATA_DIR);
            this.logger.severe(message);
            throw new ConfigurationException(message);
        }
        this.dataDir = new File(this.dataDirName);
        if (!this.dataDir.exists() && !this.dataDir.mkdirs()) {
            String message = String.format("The data directory '%s' did not exist and could not be created.", this.dataDir);
            this.logger.severe(message);
            throw new ConfigurationException(message);
        }
        this.logger.info(String.format("Using '%s' as data dir.", this.dataDir));
        if (!this.dataDir.canRead() || !this.dataDir.canWrite()) {
            String message = String.format("Read / write access is required to the data dir '%s'.", this.dataDir);
            this.logger.severe(message);
            throw new ConfigurationException(message);
        }
        if (!this.dataDir.isDirectory()) {
            String message = String.format("The data dir '%s' is not a directory.", this.dataDir);
            this.logger.severe(message);
            throw new ConfigurationException(message);
        }
        Object[] tempFiles = this.dataDir.listFiles(new FileSuffixFilter(FILE_SUFFIX_TEMP));
        if (tempFiles.length > 0) {
            String tempFileString = Arrays.toString(tempFiles);
            String message = String.format("Found temporary files! This may occur in case of crashes or unclean shutdowns! Please check the following files: %s.", tempFileString);
            this.logger.severe(message);
            throw new ConfigurationException(message);
        }
    }

    public void init(ProcessTemplateCheck[] checks, boolean skipChecks) throws AbortServiceException {
        if (this.templateStorage == null) {
            this.templateStorage = this;
        }
        this.initAndCheckTemplates(checks, skipChecks);
        this.initAndCheckInstances();
    }

    protected void initAndCheckTemplates(ProcessTemplateCheck[] checks, boolean skipChecks) throws AbortServiceException {
        String msg;
        String[] strings;
        Map<UUID, QualifiedAgent> updates;
        Map<UUID, UUID> newEmbds;
        Map<UUID, UUID> embds;
        FileSuffixFilter fileNameFilter = new FileSuffixFilter(FILE_SUFFIX_TEMPLATE);
        try {
            embds = this.getEmbeddedTemplateMapping();
            newEmbds = this.getEmbeddedTemplateMapping();
            updates = this.getUpdateLocks();
        }
        catch (DataSourceException dse) {
            throw new AbortServiceException(dse);
        }
        String[] stringArray = strings = this.dataDir.list(fileNameFilter);
        int n = strings.length;
        int n2 = 0;
        while (n2 < n) {
            Template template;
            String string = stringArray[n2];
            UUID id = this.getIDFromFilename(string);
            try {
                template = this.getTemplate(id);
            }
            catch (DataSourceException e) {
                String message = String.format("Exception while retrieving '%s' from the file system.", string);
                throw new AbortServiceException(message, e);
            }
            if (!id.equals(template.getID())) {
                String msg2 = String.format("File '%s' has inconsistent file name. Expected '%s', was '%s'", string, id, template.getID());
                throw new AbortServiceException(msg2);
            }
            if (!skipChecks) {
                this.performInitChecks(string, template, checks);
            }
            this.templateInstances.put(id, new TreeSet());
            if (UUIDTools.isNegative(id)) {
                if (embds.containsKey(id)) {
                    UUID parent = embds.remove(id);
                    if (parent == null) {
                        String msg3 = "The template '%s' is an embedded template but its parent template could not be determined by the embedded template ID mapping. Aborting.";
                        msg3 = String.format(msg3, id);
                        throw new AbortServiceException(msg3);
                    }
                } else {
                    String msg4 = "The template '%s' has a negative ID but it is neither contained in the embedded template ID mapping nor in the modified template ID mapping. Aborting.";
                    msg4 = String.format(msg4, id);
                    throw new AbortServiceException(msg4);
                }
            }
            ++n2;
        }
        if (!embds.isEmpty()) {
            for (Map.Entry<UUID, UUID> embedded : embds.entrySet()) {
                msg = "The embedded template ID mapping contains the embedded template '%s' and its parent template '%s' but the embedded template cannot be retrieved from the storage. Adapting meta information by removing this mapping.";
                msg = String.format(msg, embedded.getKey(), embedded.getValue());
                this.logger.warning(msg);
                newEmbds.remove(embedded.getKey());
            }
        }
        for (Map.Entry<UUID, UUID> entry : newEmbds.entrySet()) {
            if (this.templateInstances.containsKey(entry.getValue())) continue;
            msg = "The template '%s' is an embedded template, its parent template '%s' cannot be retrieved from the storage. Aborting.";
            msg = String.format(msg, entry.getKey(), entry.getValue());
            throw new AbortServiceException(msg);
        }
        for (Map.Entry<UUID, Serializable> entry : updates.entrySet()) {
            if (this.templateInstances.containsKey(entry.getKey())) continue;
            msg = "There is an update lock on template '%s' by agent '%s' but the template cannot be retrieved from the storage. Aborting.";
            msg = String.format(msg, entry.getKey(), entry.getValue());
            throw new AbortServiceException(msg);
        }
        try {
            this.setEmbeddedTemplateMapping(newEmbds);
        }
        catch (DataSourceException dataSourceException) {
            throw new AbortServiceException(dataSourceException);
        }
    }

    protected void performInitChecks(String templateID, Template template, ProcessTemplateCheck[] checks) throws AbortServiceException {
        long start = System.nanoTime();
        URI base = ProcessElementIdentifierTools.getTemplateIdentifier(template, "localhost");
        CheckReport checkReport = new CheckReport(base);
        boolean checkSuccess = new ProcessTemplateCheckRunner(checks).performCheck(template, new NodeRelations(template), checkReport);
        if (!checkSuccess) {
            String message = String.format("The checks on template '%s' failed with the following result:\n%s.", templateID, checkReport.getSimpleReportSummary());
            throw new AbortServiceException(message);
        }
        String msg = String.format("Performed %s initial checks for template '%s' [%s] in %,d nano seconds", checks.length, template.getName(), template.getID(), System.nanoTime() - start);
        this.logger.fine(msg);
    }

    protected void initAndCheckInstances() throws AbortServiceException {
        String msg;
        String[] strings;
        Map<UUID, QualifiedAgent> changeLocks;
        Map<UUID, UUID> newBaseTemplates;
        Map<UUID, UUID> baseTemplates;
        Map<UUID, UUID> newModifieds;
        Map<UUID, UUID> modifieds;
        FileSuffixFilter fileNameFilter = new FileSuffixFilter(FILE_SUFFIX_INSTANCE);
        try {
            modifieds = this.getAdhocTemplateMapping();
            newModifieds = this.getAdhocTemplateMapping();
            baseTemplates = this.getBaseTemplateMapping();
            newBaseTemplates = this.getBaseTemplateMapping();
            changeLocks = this.getChangeLocks();
        }
        catch (DataSourceException dse) {
            throw new AbortServiceException(dse);
        }
        String[] stringArray = strings = this.dataDir.list(fileNameFilter);
        int n = strings.length;
        int n2 = 0;
        while (n2 < n) {
            ExecutableInstance instance;
            String fileName = stringArray[n2];
            UUID id = this.getIDFromFilename(fileName);
            try {
                instance = this.getInstance(id);
            }
            catch (DataSourceException e) {
                String msg2 = String.format("Exception while retrieving '%s' from the file system.", fileName);
                throw new AbortServiceException(msg2, e);
            }
            if (!id.equals(instance.getID())) {
                String msg3 = String.format("File '%s' has inconsistent file name. Expected ID '%s', was '%s'", fileName, id, instance.getID());
                throw new AbortServiceException(msg3);
            }
            this.logicalInstanceIDs.put(instance.getLogID(), instance.getID());
            UUID templateID = instance.getTemplate().getID();
            if (instance.isModified()) {
                if (modifieds.remove(templateID) == null) {
                    String msg4 = "The instance '%s' is modified but its template '%s' is not in modified template ID mapping. Aborting.";
                    msg4 = String.format(msg4, id, templateID);
                    throw new AbortServiceException(msg4);
                }
                UUID baseID = baseTemplates.remove(templateID);
                if (baseID == null) {
                    String msg5 = "The instance '%s' (template '%s') is modified but it does not have a corresponding base template in the base template ID mapping. Aborting.";
                    msg5 = String.format(msg5, id, templateID);
                    throw new AbortServiceException(msg5);
                }
                if (!instance.getBaseTemplateID().equals(baseID)) {
                    String msg6 = "The instance '%s' (template '%s') is modified, it specifies its base template as '%s' but the base template ID mapping provides '%s' as base template. Aborting.";
                    msg6 = String.format(msg6, id, templateID, instance.getBaseTemplateID(), baseID);
                    throw new AbortServiceException(msg6);
                }
                templateID = baseID;
            }
            if (!this.templateInstances.containsKey(templateID)) {
                String msg7 = "The template (or base template) '%s' of instance '%s' cannot be retrieved from the storage. Aborting.";
                msg7 = String.format(msg7, templateID, id);
                throw new AbortServiceException(msg7);
            }
            this.templateInstances.get(templateID).add(id);
            ++n2;
        }
        if (!modifieds.isEmpty()) {
            for (Map.Entry<UUID, UUID> modified : modifieds.entrySet()) {
                msg = "The modified template ID mapping contains the modified instance '%s' and its template '%s' but the modified instance cannot be retrieved from the storage. Adapting meta information by removing this mapping.";
                msg = String.format(msg, modified.getKey(), modified.getValue());
                this.logger.warning(msg);
                newModifieds.remove(modified.getKey());
            }
        }
        if (!baseTemplates.isEmpty()) {
            for (Map.Entry<UUID, UUID> baseTempl : baseTemplates.entrySet()) {
                msg = "The base template ID mapping contains the template '%1$s' and its base template '%2$s' but the template '%1$s' cannot be retrieved from the storage. Adapting meta information by removing this mapping.";
                msg = String.format(msg, baseTempl.getKey(), baseTempl.getValue());
                this.logger.warning(msg);
                newBaseTemplates.remove(baseTempl.getKey());
            }
        }
        for (Map.Entry<UUID, QualifiedAgent> lock : changeLocks.entrySet()) {
            if (this.logicalInstanceIDs.containsValue(lock.getKey())) continue;
            msg = "There is an instance change lock on instance '%s' by agent '%s' but the instance cannot be retrieved from the storage. Aborting.";
            msg = String.format(msg, lock.getKey(), lock.getValue());
            throw new AbortServiceException(msg);
        }
        try {
            this.setAdhocTemplateMapping(newModifieds);
            this.setBaseTemplateMapping(newBaseTemplates);
        }
        catch (DataSourceException dse) {
            throw new AbortServiceException(dse);
        }
    }

    protected UUID getIDFromFilename(String fileName) throws AbortServiceException {
        UUID ret;
        String idString = fileName.substring(0, fileName.lastIndexOf("."));
        try {
            ret = UUID.fromString(idString);
        }
        catch (IllegalArgumentException iae) {
            String message = String.format("File found with an invalid file name: '%s'.", fileName);
            throw new AbortServiceException(message, iae);
        }
        return ret;
    }

    @Override
    public Set<UUID> getAllTemplateIDs() {
        this.lock.readLock().lock();
        try {
            Map<UUID, UUID> baseTemplateIDs;
            HashSet<UUID> res = new HashSet<UUID>();
            res.addAll(this.templateInstances.keySet());
            try {
                baseTemplateIDs = this.getBaseTemplateMapping();
            }
            catch (DataSourceException e) {
                throw new RuntimeException(e.getMessage(), e);
            }
            res.addAll(baseTemplateIDs.keySet());
            Set<UUID> set = Collections.unmodifiableSet(res);
            return set;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public void createTemplate(Template template, TemplateStatus templateStatus) throws DataSourceException {
        this.lock.writeLock().lock();
        try {
            File file = this.getTemplateFile(template.getID());
            if (file.exists()) {
                String message = String.format("A template with ID '%s' exists already!", template.getID());
                this.logger.warning(message);
                throw new RuntimeException(message);
            }
            Template newTemplate = ProcessManagerStorageTools.changeTemplateValues(template, template.getID());
            this.writeTemplateAndStatusToFile(file, newTemplate, templateStatus);
            this.templateInstances.put(template.getID(), new TreeSet());
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public Template getTemplate(UUID templateID) throws DataSourceException {
        Template template;
        long start = System.nanoTime();
        try {
            ProcessModelFactory pmf;
            try {
                pmf = this.registry.getModelFactory("ProcessModelFactory", ProcessModelFactory.class);
                pmf.setCreateChangeable(false);
            }
            catch (ServiceNotKnownException snke) {
                String msg = "Could not retrieve process model factory for creating the template '%s'. Aborting retrieval of template.";
                throw new InternalServiceException(String.format(msg, templateID), snke);
            }
            template = this.getTemplate(templateID, pmf);
        }
        catch (Throwable throwable) {
            String msg = String.format("SimpleXMLStorage.getTemplate(%s) needed %,d nano seconds.", templateID, System.nanoTime() - start);
            this.logger.fine(msg);
            throw throwable;
        }
        String msg = String.format("SimpleXMLStorage.getTemplate(%s) needed %,d nano seconds.", templateID, System.nanoTime() - start);
        this.logger.fine(msg);
        return template;
    }

    protected Template getTemplate(UUID templateID, ProcessModelFactory pmf) throws DataSourceException {
        Template template;
        block9: {
            this.lock.readLock().lock();
            try {
                File templateFile = this.getTemplateFile(templateID);
                if (templateFile.exists()) {
                    try {
                        ProcessModelXMLImport xmlImport = new ProcessModelXMLImport(pmf);
                        template = xmlImport.getTemplateFromFile(templateFile);
                        break block9;
                    }
                    catch (VersionException e) {
                        String message = String.format("Exception while reading template file '%s'.", templateFile);
                        this.logger.log(Level.SEVERE, message, e);
                        throw new DataSourceException(message, e);
                    }
                    catch (XMLFormatException e) {
                        String message = String.format("Exception while reading template file '%s'.", templateFile);
                        this.logger.log(Level.SEVERE, message, e);
                        throw new DataSourceException(message, e);
                    }
                    catch (IOException e) {
                        String message = String.format("Exception while reading template file '%s'.", templateFile);
                        this.logger.log(Level.SEVERE, message, e);
                        throw new DataSourceException(message, e);
                    }
                }
                Map<UUID, UUID> modInstances = this.getAdhocTemplateMapping();
                if (!modInstances.containsKey(templateID)) {
                    String message = String.format("Template with ID '%s' does not exist.", templateID);
                    this.logger.warning(message);
                    throw new IllegalArgumentException(message);
                }
                template = this.getInstance(modInstances.get(templateID), false).getTemplate();
            }
            finally {
                this.lock.readLock().unlock();
            }
        }
        return template;
    }

    @Override
    public TemplateReference getTemplateReference(UUID templateID, TemplateStatusProvider statusProvider) throws DataSourceException {
        this.lock.readLock().lock();
        try {
            ProcessModelFactory pmf;
            try {
                pmf = this.registry.getModelFactory("ProcessModelFactory", ProcessModelFactory.class);
            }
            catch (ServiceNotKnownException snke) {
                String msg = "Could not retrieve process model factory for creating the reference object for template '%s'. Aborting retrievalof template reference.";
                throw new InternalServiceException(String.format(msg, templateID), snke);
            }
            Template template = this.getTemplate(templateID);
            TemplateStatus templateStatus = statusProvider.getTemplateStatus(templateID);
            HashSet<ProcessModelParameter> inputParameters = new HashSet<ProcessModelParameter>(template.getParameters(ActivityConstants.AccessType.READ));
            HashSet<ProcessModelParameter> outputParameters = new HashSet<ProcessModelParameter>(template.getParameters(ActivityConstants.AccessType.WRITE));
            TemplateReference templateReference = pmf.createTemplateReference(template.getID(), template.getProcessType(), template.getVersion(), template.getName(), template.getDescription(), template.getSupervisorAgent(), inputParameters, outputParameters, template.getSupportedPlugins(), template.getPluginDatas(), template.getUserAttributes(), templateStatus.isTopLevelUsable(), templateStatus.getUsageAsSubprocess(), templateStatus.getBuildtimeState(), templateStatus.isDerivable(), templateStatus.isOutdated(true), templateStatus.isOutdated(false), templateStatus.isInstantiable(true), templateStatus.isInstantiable(false), templateStatus.areInstancesMigratableTo(true), templateStatus.areInstancesMigratableTo(false), templateStatus.areInstancesChangeable(true), templateStatus.areInstancesChangeable(false));
            return templateReference;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public TemplateStatus getTemplateStatus(UUID templateID) throws DataSourceException {
        ProcessModelFactory pmf;
        try {
            pmf = this.registry.getModelFactory("ProcessModelFactory", ProcessModelFactory.class);
            pmf.setCreateChangeable(false);
        }
        catch (ServiceNotKnownException snke) {
            String msg = "Could not retrieve process model factory for creating the status of template '%s'. Aborting retrieval of template status.";
            throw new InternalServiceException(String.format(msg, templateID), snke);
        }
        return this.getTemplateStatus(templateID, pmf);
    }

    protected TemplateStatus getTemplateStatus(UUID templateID, ProcessModelFactory pmf) throws DataSourceException {
        TemplateStatus templateStatus;
        this.lock.readLock().lock();
        try {
            File templateFile = this.getTemplateFile(templateID);
            if (!templateFile.exists()) {
                String message = String.format("Template with ID '%s' does not exist.", templateID);
                this.logger.warning(message);
                throw new IllegalArgumentException(message);
            }
            try {
                ProcessModelXMLImport xmlImport = new ProcessModelXMLImport(pmf);
                templateStatus = xmlImport.getTemplateStatusFromTemplateFile(templateFile);
            }
            catch (VersionException e) {
                String message = String.format("Exception while reading template file '%s'.", templateFile);
                this.logger.log(Level.SEVERE, message, e);
                throw new DataSourceException(message, e);
            }
            catch (XMLFormatException e) {
                String message = String.format("Exception while reading template file '%s'.", templateFile);
                this.logger.log(Level.SEVERE, message, e);
                throw new DataSourceException(message, e);
            }
            catch (IOException e) {
                String message = String.format("Exception while reading template file '%s'.", templateFile);
                this.logger.log(Level.SEVERE, message, e);
                throw new DataSourceException(message, e);
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
        return templateStatus;
    }

    @Override
    public void updateTemplateStatus(TemplateStatus templateStatus) throws DataSourceException {
        this.lock.writeLock().lock();
        try {
            Template template = this.getTemplate(templateStatus.getTemplateID());
            File file = this.getTemplateFile(template.getID());
            this.writeTemplateAndStatusToFile(file, template, templateStatus);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public void updateEmbeddedTemplateIDs(UUID embeddedID, UUID parentID) throws DataSourceException {
        this.lock.writeLock().lock();
        try {
            Map<UUID, UUID> mapping = this.getEmbeddedTemplateMapping();
            mapping.put(embeddedID, parentID);
            this.setEmbeddedTemplateMapping(mapping);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public UUID getParentTemplateID(UUID embeddedID) throws DataSourceException {
        this.lock.readLock().lock();
        try {
            UUID ret = null;
            Map<UUID, UUID> embds = this.getEmbeddedTemplateMapping();
            if (embds != null) {
                ret = embds.get(embeddedID);
            }
            UUID uUID = ret;
            return uUID;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public int lockTemplateForUpdates(UUID templateID, QualifiedAgent lockingAgent) throws DataSourceException {
        this.lock.writeLock().lock();
        try {
            Map<UUID, ProcessModelXMLHelperTools.LockDescription> locks;
            int ret = 1;
            File file = new File(this.dataDir, TEMPLATE_LOCK_FILE);
            if (!file.exists()) {
                boolean success = file.createNewFile();
                if (!success) {
                    throw new DataSourceException("Problems while creating a new file for the template update locks!");
                }
                locks = new HashMap<UUID, ProcessModelXMLHelperTools.LockDescription>();
            } else {
                locks = ProcessModelXMLImport.getTemplateLocksFromFile(file);
            }
            if (locks.containsKey(templateID)) {
                ret = locks.get(templateID).getLockCount() + 1;
            }
            ProcessModelXMLHelperTools.LockDescription descNew = new ProcessModelXMLHelperTools.LockDescription(lockingAgent, ret);
            locks.put(templateID, descNew);
            this.xmlExport.writeTemplateLocksToFile(locks, file);
            int n = ret;
            return n;
        }
        catch (IOException e) {
            throw new DataSourceException("IOException while updating template locks!", e);
        }
        catch (XMLFormatException e) {
            throw new DataSourceException("Encountered malformed XML of template locks", e);
        }
        catch (VersionException e) {
            throw new DataSourceException("Template locks file is out of date!", e);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public int unlockTemplateForUpdates(UUID templateID) throws DataSourceException {
        this.lock.writeLock().lock();
        try {
            File file = new File(this.dataDir, TEMPLATE_LOCK_FILE);
            if (!file.exists()) {
                return 0;
            }
            Map<UUID, ProcessModelXMLHelperTools.LockDescription> locks = ProcessModelXMLImport.getTemplateLocksFromFile(file);
            if (!locks.containsKey(templateID)) {
                return 0;
            }
            int ret = locks.get(templateID).getLockCount() - 1;
            if (ret > 0) {
                ProcessModelXMLHelperTools.LockDescription descNew = new ProcessModelXMLHelperTools.LockDescription(locks.get(templateID).getAgent(), ret);
                locks.put(templateID, descNew);
            } else {
                locks.remove(templateID);
            }
            this.xmlExport.writeTemplateLocksToFile(locks, file);
            int n = ret;
            return n;
        }
        catch (IOException e) {
            throw new DataSourceException("IOException while updating template locks!", e);
        }
        catch (XMLFormatException e) {
            throw new DataSourceException("Encountered malformed XML of template locks", e);
        }
        catch (VersionException e) {
            throw new DataSourceException("Template locks file is out of date!", e);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public Map<UUID, QualifiedAgent> getUpdateLocks() throws DataSourceException {
        this.lock.readLock().lock();
        try {
            File file = new File(this.dataDir, TEMPLATE_LOCK_FILE);
            Map<UUID, ProcessModelXMLHelperTools.LockDescription> locks = !file.exists() ? new HashMap<UUID, ProcessModelXMLHelperTools.LockDescription>() : ProcessModelXMLImport.getTemplateLocksFromFile(file);
            HashMap<UUID, QualifiedAgent> ret = new HashMap<UUID, QualifiedAgent>();
            for (Map.Entry<UUID, ProcessModelXMLHelperTools.LockDescription> entry : locks.entrySet()) {
                ret.put(entry.getKey(), entry.getValue().getAgent());
            }
            HashMap<UUID, QualifiedAgent> hashMap = ret;
            return hashMap;
        }
        catch (IOException e) {
            throw new DataSourceException("IOException while getting template locks!", e);
        }
        catch (XMLFormatException e) {
            throw new DataSourceException("Encountered malformed XML of template locks", e);
        }
        catch (VersionException e) {
            throw new DataSourceException("Template locks file is out of date!", e);
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public Set<UUID> getInstanceIDsForTemplate(UUID templateID) {
        this.lock.readLock().lock();
        try {
            if (!this.templateInstances.containsKey(templateID)) {
                String message = String.format("Template with ID '%s' not known.", templateID);
                this.logger.warning(message);
                throw new IllegalArgumentException(message);
            }
            Set<UUID> set = Collections.unmodifiableSet(this.templateInstances.get(templateID));
            return set;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public UUID getLogicalInstanceID(UUID logID) {
        this.lock.readLock().lock();
        try {
            if (!this.logicalInstanceIDs.containsKey(logID)) {
                String message = String.format("Instance with logical ID '%s' not known.", logID);
                this.logger.warning(message);
                throw new IllegalArgumentException(message);
            }
            UUID uUID = this.logicalInstanceIDs.get(logID);
            return uUID;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public ExecutableInstance createInstance(UUID templateID, String instanceName, QualifiedAgent supervisorAgent, QualifiedAgent initiatorAgent, EBPInstanceReference parentActivity, long creationTime) throws DataSourceException {
        ExecutableInstance instance;
        this.lock.writeLock().lock();
        try {
            Template template = this.templateStorage.getTemplate(templateID);
            ExecutableProcessModelFactory epmf = new ExecutableProcessModelFactory(null);
            epmf.setCreateChangeable(false);
            instance = epmf.createInstance(UUIDTools.createPositiveUUID(), UUIDTools.createRandomUUID(), instanceName, templateID, template, supervisorAgent, initiatorAgent, parentActivity, creationTime);
            InstanceStatus instanceStatus = ProcessManagerStorageTools.getDefaultInstanceStatus(instance.getID());
            File file = this.getInstanceFile(instance.getID());
            this.writeExecutableInstanceAndStatusToFile(file, instance, instanceStatus, false);
            this.templateInstances.get(templateID).add(instance.getID());
            this.logicalInstanceIDs.put(instance.getLogID(), instance.getID());
        }
        finally {
            this.lock.writeLock().unlock();
        }
        return instance;
    }

    @Override
    public ExecutableInstance getInstance(UUID instanceID) throws DataSourceException {
        return this.getInstance(instanceID, false);
    }

    @Override
    public InstanceReference getInstanceReference(UUID instanceID, TemplateStatusProvider statusProvider) throws DataSourceException {
        this.lock.readLock().lock();
        try {
            ProcessModelFactory pmf;
            ExecutableInstance instance = this.getInstance(instanceID);
            InstanceStatus instanceStatus = this.getInstanceStatus(instanceID);
            TemplateReference templateRef = this.templateStorage.getTemplateReference(instance.getTemplate().getID(), statusProvider);
            UUID parentInstanceID = null;
            if (instance.getParentEBPReference() != null) {
                parentInstanceID = instance.getParentEBPReference().getInstanceID();
            }
            try {
                pmf = this.registry.getModelFactory("ProcessModelFactory", ProcessModelFactory.class);
            }
            catch (ServiceNotKnownException snke) {
                String msg = "Could not retrieve process model factory for creating the reference object for instance '%s'. Aborting retrievalof instance reference.";
                throw new InternalServiceException(String.format(msg, instanceID), snke);
            }
            InstanceReference instanceReference = pmf.createInstanceReference(instance.getID(), instance.getLogID(), instance.getName(), instance.isModified(), templateRef, instance.getSupervisorAgent(), instance.getInitiatorAgent(), instance.getCreationTime(), parentInstanceID, instanceStatus.getExecutionStatus(), instance.getSupportedPlugins(), instance.getPluginDatas(), instance.getUserAttributes());
            return instanceReference;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public ChangeableInstance getInstanceChangeable(UUID instanceID) throws DataSourceException {
        ExecutableInstance instance = this.getInstance(instanceID, true);
        return ProcessManagerStorageTools.executableToChangeableInstance(instance);
    }

    protected ExecutableInstance getInstance(UUID instanceID, boolean changeable) throws DataSourceException {
        ExecutableInstance ret;
        ExecutionFactory executionFactory;
        try {
            executionFactory = this.registry.getModelFactory("ExecutionFactory", ExecutionFactory.class);
        }
        catch (ServiceNotKnownException snke) {
            String msg = "Could not retrieve execution model factory for creating the executable instance '%s'. Aborting retrieval of executable instance.";
            throw new InternalServiceException(String.format(msg, instanceID), snke);
        }
        this.lock.readLock().lock();
        try {
            File file = this.getInstanceFile(instanceID);
            if (!file.exists()) {
                throw SimpleXMLStorage.createUnknownEntityException(instanceID);
            }
            try {
                ExecutableProcessModelFactory epmf = new ExecutableProcessModelFactory(null);
                epmf.setCreateChangeable(changeable);
                ProcessModelXMLImport xmlImport = new ProcessModelXMLImport(epmf);
                Document document = XMLHelperTools.getDocumentFromFile(file, null, null);
                boolean isModified = xmlImport.getIsModifiedFromInstanceDocument(document);
                if (isModified) {
                    ret = xmlImport.getExecutableInstanceFromFile(executionFactory, file);
                } else {
                    UUID templateID = xmlImport.getTemplateIDFromInstanceDocument(document);
                    Template template = this.templateStorage.getTemplate(templateID);
                    ret = xmlImport.getExecutableInstanceFromDocument(executionFactory, document, template);
                }
            }
            catch (VersionException e) {
                String msg = String.format("Exception while reading instance file '%s'.", file);
                this.logger.log(Level.SEVERE, msg, e);
                throw new DataSourceException(msg, e);
            }
            catch (XMLFormatException e) {
                String msg = String.format("Exception while reading instance file '%s'.", file);
                this.logger.log(Level.SEVERE, msg, e);
                throw new DataSourceException(msg, e);
            }
            catch (IOException e) {
                String msg = String.format("Exception while reading instance file '%s'.", file);
                this.logger.log(Level.SEVERE, msg, e);
                throw new DataSourceException(msg, e);
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
        return ret;
    }

    @Override
    public void updateInstance(ExecutableInstance instance) throws DataSourceException {
        this.lock.writeLock().lock();
        try {
            File file = this.getInstanceFile(instance.getID());
            if (!file.exists()) {
                String message = String.format("Instance with ID '%s' doesn't exist.", instance.getID());
                this.logger.log(Level.SEVERE, message);
                throw new IllegalArgumentException(message);
            }
            InstanceStatus instanceStatus = this.getInstanceStatus(instance.getID());
            boolean storeStructure = instance.isModified();
            this.writeExecutableInstanceAndStatusToFile(file, instance, instanceStatus, storeStructure);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public UUID updateChangeableInstance(ChangeableInstance origInstance) throws DataSourceException {
        UUID ret;
        ChangeableInstance changeableInstance = origInstance;
        ExecutableInstance executableInstance = null;
        this.lock.writeLock().lock();
        try {
            ret = changeableInstance.getID();
            File file = this.getInstanceFile(changeableInstance.getID());
            if (!file.exists()) {
                String message = String.format("Instance with ID '%s' doesn't exist.", changeableInstance.getID());
                throw new IllegalArgumentException(message);
            }
            InstanceStatus instanceStatus = this.getInstanceStatus(changeableInstance.getID());
            boolean storeStructure = changeableInstance.isModified();
            if (changeableInstance.isModified()) {
                boolean delete;
                UUID oldInstanceID = changeableInstance.getID();
                executableInstance = this.getInstance(oldInstanceID);
                UUID newInstanceID = oldInstanceID;
                changeableInstance = ProcessManagerStorageTools.changeInstanceValues(changeableInstance, newInstanceID, changeableInstance.getTemplate());
                instanceStatus = ProcessManagerStorageTools.changeInstanceStatusValues(instanceStatus, changeableInstance.getID());
                ret = changeableInstance.getID();
                this.logicalInstanceIDs.put(changeableInstance.getLogID(), newInstanceID);
                Set<UUID> instIDs = this.templateInstances.get(changeableInstance.getBaseTemplateID());
                instIDs.remove(oldInstanceID);
                instIDs.add(newInstanceID);
                file = this.getInstanceFile(oldInstanceID);
                if (file.exists() && !(delete = file.delete())) {
                    this.logger.warning(String.format("The file '%s' could not be deleted", file));
                }
                file = this.getInstanceFile(changeableInstance.getID());
                Map<UUID, UUID> baseTemplateIDs = this.getBaseTemplateMapping();
                baseTemplateIDs.put(changeableInstance.getTemplate().getID(), changeableInstance.getBaseTemplateID());
                this.setBaseTemplateMapping(baseTemplateIDs);
                Map<UUID, UUID> modInstances = this.getAdhocTemplateMapping();
                modInstances.put(changeableInstance.getTemplate().getID(), changeableInstance.getID());
                this.setAdhocTemplateMapping(modInstances);
            }
            DefaultExecutableInstance instance = executableInstance != null ? new DefaultExecutableInstance(changeableInstance, executableInstance) : new DefaultExecutableInstance(changeableInstance);
            this.writeExecutableInstanceAndStatusToFile(file, instance, instanceStatus, storeStructure);
        }
        finally {
            this.lock.writeLock().unlock();
        }
        return ret;
    }

    @Override
    public InstanceStatus getInstanceStatus(UUID instanceID) throws DataSourceException {
        InstanceStatus instanceStatus;
        this.lock.readLock().lock();
        try {
            File file = this.getInstanceFile(instanceID);
            if (!file.exists()) {
                throw SimpleXMLStorage.createUnknownEntityException(instanceID);
            }
            try {
                ProcessModelFactory pmf;
                try {
                    pmf = this.registry.getModelFactory("ProcessModelFactory", ProcessModelFactory.class);
                    pmf.setCreateChangeable(false);
                }
                catch (ServiceNotKnownException snke) {
                    String msg = "Could not retrieve process model factory for creating the status of instance '%s'. Aborting retrieval of instance status.";
                    throw new InternalServiceException(String.format(msg, instanceID), snke);
                }
                ProcessModelXMLImport xmlImport = new ProcessModelXMLImport(pmf);
                instanceStatus = xmlImport.getInstanceStatusFromInstanceFile(file);
            }
            catch (VersionException e) {
                String message = String.format("Exception while reading instance file '%s'.", file);
                this.logger.log(Level.SEVERE, message, e);
                throw new DataSourceException(message, e);
            }
            catch (XMLFormatException e) {
                String message = String.format("Exception while reading instance file '%s'.", file);
                this.logger.log(Level.SEVERE, message, e);
                throw new DataSourceException(message, e);
            }
            catch (IOException e) {
                String message = String.format("Exception while reading instance file '%s'.", file);
                this.logger.log(Level.SEVERE, message, e);
                throw new DataSourceException(message, e);
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
        return instanceStatus;
    }

    @Override
    public void updateInstanceStatus(InstanceStatus instanceStatus) throws DataSourceException {
        this.lock.writeLock().lock();
        try {
            File file = this.getInstanceFile(instanceStatus.getInstanceID());
            if (!file.exists()) {
                throw SimpleXMLStorage.createUnknownEntityException(instanceStatus.getInstanceID());
            }
            ExecutableInstance instance = this.getInstance(instanceStatus.getInstanceID());
            boolean storeStructure = false;
            if (instance.isModified()) {
                storeStructure = true;
            }
            this.writeExecutableInstanceAndStatusToFile(file, instance, instanceStatus, storeStructure);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public int lockInstanceForChanging(UUID instanceID, QualifiedAgent lockingAgent) throws DataSourceException {
        this.lock.writeLock().lock();
        try {
            Map<UUID, ProcessModelXMLHelperTools.LockDescription> locks;
            int ret = 1;
            File file = new File(this.dataDir, INSTANCE_LOCK_FILE);
            if (!file.exists()) {
                boolean success = file.createNewFile();
                if (!success) {
                    throw new DataSourceException("Problems while creating a new file for the instance change locks!");
                }
                locks = new HashMap<UUID, ProcessModelXMLHelperTools.LockDescription>();
            } else {
                locks = ProcessModelXMLImport.getInstanceLocksFromFile(file);
            }
            if (locks.containsKey(instanceID)) {
                ret = locks.get(instanceID).getLockCount() + 1;
            }
            ProcessModelXMLHelperTools.LockDescription descNew = new ProcessModelXMLHelperTools.LockDescription(lockingAgent, ret);
            locks.put(instanceID, descNew);
            this.xmlExport.writeInstanceLocksToFile(locks, file);
            int n = ret;
            return n;
        }
        catch (IOException e) {
            throw new DataSourceException("IOException while updating instance locks!", e);
        }
        catch (XMLFormatException e) {
            throw new DataSourceException("Encountered malformed XML of instance locks", e);
        }
        catch (VersionException e) {
            throw new DataSourceException("Instance locks file is out of date!", e);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public int unlockInstanceForChanging(UUID instanceID) throws DataSourceException {
        this.lock.writeLock().lock();
        try {
            File file = new File(this.dataDir, INSTANCE_LOCK_FILE);
            if (!file.exists()) {
                return 0;
            }
            Map<UUID, ProcessModelXMLHelperTools.LockDescription> locks = ProcessModelXMLImport.getInstanceLocksFromFile(file);
            if (!locks.containsKey(instanceID)) {
                return 0;
            }
            int ret = locks.get(instanceID).getLockCount() - 1;
            if (ret > 0) {
                ProcessModelXMLHelperTools.LockDescription descNew = new ProcessModelXMLHelperTools.LockDescription(locks.get(instanceID).getAgent(), ret);
                locks.put(instanceID, descNew);
            } else {
                locks.remove(instanceID);
            }
            this.xmlExport.writeInstanceLocksToFile(locks, file);
            int n = ret;
            return n;
        }
        catch (IOException e) {
            throw new DataSourceException("IOException while updating instance locks!", e);
        }
        catch (XMLFormatException e) {
            throw new DataSourceException("Encountered malformed XML of instance locks", e);
        }
        catch (VersionException e) {
            throw new DataSourceException("Instance locks file is out of date!", e);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public Map<UUID, QualifiedAgent> getChangeLocks() throws DataSourceException {
        this.lock.readLock().lock();
        try {
            File file = new File(this.dataDir, INSTANCE_LOCK_FILE);
            Map<UUID, ProcessModelXMLHelperTools.LockDescription> locks = !file.exists() ? new HashMap<UUID, ProcessModelXMLHelperTools.LockDescription>() : ProcessModelXMLImport.getInstanceLocksFromFile(file);
            HashMap<UUID, QualifiedAgent> ret = new HashMap<UUID, QualifiedAgent>();
            for (Map.Entry<UUID, ProcessModelXMLHelperTools.LockDescription> entry : locks.entrySet()) {
                ret.put(entry.getKey(), entry.getValue().getAgent());
            }
            HashMap<UUID, QualifiedAgent> hashMap = ret;
            return hashMap;
        }
        catch (IOException e) {
            throw new DataSourceException("IOException while getting instance locks!", e);
        }
        catch (XMLFormatException e) {
            throw new DataSourceException("Encountered malformed XML of instance locks", e);
        }
        catch (VersionException e) {
            throw new DataSourceException("Instance locks file is out of date!", e);
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public UUID getBaseTemplateID(UUID templateID) throws DataSourceException {
        this.lock.readLock().lock();
        try {
            UUID ret = templateID;
            Map<UUID, UUID> baseTemplateIDs = this.getBaseTemplateMapping();
            if (baseTemplateIDs.containsKey(templateID)) {
                ret = baseTemplateIDs.get(templateID);
            }
            UUID uUID = ret;
            return uUID;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    private void writeExecutableInstanceAndStatusToFile(File file, ExecutableInstance instance, InstanceStatus instanceStatus, boolean storeStructure) throws DataSourceException {
        boolean delete;
        String message;
        File tempFile = null;
        if (file.exists()) {
            tempFile = this.getInstanceTempFile(instance.getID());
            if (tempFile.exists()) {
                String message2 = String.format("Old transaction file '%s' exists for file '%s'!", tempFile, file);
                this.logger.log(Level.SEVERE, message2);
                throw new DataSourceException(message2);
            }
            boolean renameSuccess = file.renameTo(tempFile);
            if (!renameSuccess) {
                String message3 = String.format("Could not create temporary file '%s' for file '%s'!", tempFile, file);
                this.logger.log(Level.SEVERE, message3);
                throw new DataSourceException(message3);
            }
        }
        DataSourceException exception = null;
        try {
            this.xmlExport.writeExecutableInstanceAndStatusToFile(instance, instanceStatus, file, storeStructure);
        }
        catch (IOException e) {
            message = String.format("Exception while writing instance file '%s'.", file);
            this.logger.log(Level.SEVERE, message, e);
            exception = new DataSourceException(message, e);
        }
        catch (XMLFormatException e) {
            message = String.format("Exception while writing instance file '%s'.", file);
            this.logger.log(Level.SEVERE, message, e);
            exception = new DataSourceException(message, e);
        }
        if (exception != null) {
            if (tempFile != null) {
                boolean renameSuccess;
                boolean delete2 = file.delete();
                if (!delete2) {
                    this.logger.warning(String.format("The file '%s' could not be deleted", file));
                }
                if (!(renameSuccess = tempFile.renameTo(file))) {
                    this.logger.severe(String.format("Could not rollback file '%s' to '%s'", tempFile, file));
                }
            }
            throw exception;
        }
        if (tempFile != null && !(delete = tempFile.delete())) {
            this.logger.warning(String.format("The file '%s' could not be deleted", file));
        }
    }

    protected void writeTemplateAndStatusToFile(File file, Template template, TemplateStatus templateStatus) throws DataSourceException {
        boolean delete;
        String message;
        File tempFile = null;
        if (file.exists()) {
            tempFile = this.getTemplateTempFile(template.getID());
            if (tempFile.exists()) {
                String message2 = String.format("Old transaction file '%s' exists for file '%s'!", tempFile, file);
                this.logger.log(Level.SEVERE, message2);
                throw new DataSourceException(message2);
            }
            boolean renameSuccess = file.renameTo(tempFile);
            if (!renameSuccess) {
                String message3 = String.format("Could not create temporary file '%s' for file '%s'!", tempFile, file);
                this.logger.log(Level.SEVERE, message3);
                throw new DataSourceException(message3);
            }
        }
        DataSourceException exception = null;
        try {
            this.xmlExport.writeTemplateAndStatusToFile(template, templateStatus, file);
        }
        catch (IOException e) {
            message = String.format("Exception while writing instance file '%s'.", file);
            this.logger.log(Level.SEVERE, message, e);
            exception = new DataSourceException(message, e);
        }
        catch (XMLFormatException e) {
            message = String.format("Exception while writing instance file '%s'.", file);
            this.logger.log(Level.SEVERE, message, e);
            exception = new DataSourceException(message, e);
        }
        if (exception != null) {
            if (tempFile != null) {
                boolean renameSuccess;
                boolean delete2 = file.delete();
                if (!delete2) {
                    this.logger.warning(String.format("The file '%s' could not be deleted", file));
                }
                if (!(renameSuccess = tempFile.renameTo(file))) {
                    this.logger.severe(String.format("Could not rollback file '%s' to '%s'", tempFile, file));
                }
            }
            throw exception;
        }
        if (tempFile != null && !(delete = tempFile.delete())) {
            this.logger.warning(String.format("The file '%s' could not be deleted", file));
        }
    }

    @Override
    public InstanceStorage getInstanceStorage() {
        return this;
    }

    @Override
    public TemplateStorage getTemplateStorage() {
        return this;
    }

    public void setTemplateStorage(TemplateStorage templateStorage) {
        if (templateStorage == null) {
            throw new NullArgumentException("Argument templateStorage must not be null.");
        }
        if (this.templateStorage == null) {
            this.templateStorage = templateStorage;
        }
    }

    protected File getTemplateFile(UUID templateID) {
        return new File(this.dataDir, templateID + FILE_SUFFIX_TEMPLATE);
    }

    protected File getTemplateTempFile(UUID templateID) {
        return new File(this.dataDir, templateID + FILE_SUFFIX_TEMPLATE + FILE_SUFFIX_TEMP);
    }

    protected File getInstanceFile(UUID instanceID) {
        return new File(this.dataDir, instanceID + FILE_SUFFIX_INSTANCE);
    }

    protected File getInstanceTempFile(UUID instanceID) {
        return new File(this.dataDir, instanceID + FILE_SUFFIX_INSTANCE + FILE_SUFFIX_TEMP);
    }

    private Map<UUID, UUID> getEmbeddedTemplateMapping() throws DataSourceException {
        try {
            File file = new File(this.dataDir, EMBEDDED_TEMPLATE_FILE);
            Map<UUID, UUID> ret = file.exists() ? ProcessModelXMLImport.getEmbeddedTemplateMappingFromFile(file) : new HashMap<UUID, UUID>();
            return ret;
        }
        catch (IOException e) {
            throw new DataSourceException("IOException while retrieving embedded template mapping!", e);
        }
        catch (XMLFormatException e) {
            throw new DataSourceException("Encountered malformed XML of embedded template mapping", e);
        }
        catch (VersionException e) {
            throw new DataSourceException("Embedded template mapping file is out of date!", e);
        }
    }

    private void setEmbeddedTemplateMapping(Map<UUID, UUID> mapping) throws DataSourceException {
        try {
            boolean success;
            File file = new File(this.dataDir, EMBEDDED_TEMPLATE_FILE);
            if (!file.exists() && !(success = file.createNewFile())) {
                throw new DataSourceException("Problems while creating a new file for the embedded template ID mapping!");
            }
            this.xmlExport.writeEmbeddedTemplateMappingToFile(mapping, file);
        }
        catch (IOException e) {
            throw new DataSourceException("IOException while updating embedded template mapping!", e);
        }
        catch (XMLFormatException e) {
            throw new DataSourceException("Encountered malformed XML of embedded template mapping", e);
        }
    }

    private Map<UUID, UUID> getBaseTemplateMapping() throws DataSourceException {
        try {
            File file = new File(this.dataDir, BASE_TEMPLATE_ID_FILE);
            Map<UUID, UUID> res = file.exists() ? ProcessModelXMLImport.getBaseTemplateMappingFromFile(file) : new HashMap<UUID, UUID>();
            return res;
        }
        catch (IOException e) {
            throw new DataSourceException("IOException while fetching base template mapping!", e);
        }
        catch (XMLFormatException e) {
            throw new DataSourceException("Encountered malformed XML of base template mapping", e);
        }
        catch (VersionException e) {
            throw new DataSourceException("Base template mapping file is out of date!", e);
        }
    }

    private void setBaseTemplateMapping(Map<UUID, UUID> mapping) throws DataSourceException {
        try {
            boolean success;
            File file = new File(this.dataDir, BASE_TEMPLATE_ID_FILE);
            if (!file.exists() && !(success = file.createNewFile())) {
                throw new DataSourceException("Problems while creating a new file for the base template mapping!");
            }
            this.xmlExport.writeBaseTemplateMappingToFile(mapping, file);
        }
        catch (IOException e) {
            throw new DataSourceException("IOException while writing base template mapping!", e);
        }
        catch (XMLFormatException e) {
            throw new DataSourceException("XMLFormatException while writing base template ID mapping", e);
        }
    }

    private Map<UUID, UUID> getAdhocTemplateMapping() throws DataSourceException {
        try {
            File file = new File(this.dataDir, MODIFIED_INSTANCES_FILE);
            Map<UUID, UUID> res = file.exists() ? ProcessModelXMLImport.getAdhocTemplateMappingFromFile(file) : new HashMap<UUID, UUID>();
            return res;
        }
        catch (IOException e) {
            throw new DataSourceException("IOException while fetching adhoc template mapping!", e);
        }
        catch (XMLFormatException e) {
            throw new DataSourceException("Encountered malformed XML of adhoc template mapping", e);
        }
        catch (VersionException e) {
            throw new DataSourceException("Adhoc template mapping file is out of date!", e);
        }
    }

    private void setAdhocTemplateMapping(Map<UUID, UUID> mapping) throws DataSourceException {
        try {
            boolean success;
            File file = new File(this.dataDir, MODIFIED_INSTANCES_FILE);
            if (!file.exists() && !(success = file.createNewFile())) {
                throw new DataSourceException("Problems while creating a new file for the adhoc template mapping!");
            }
            this.xmlExport.writeAdhocTemplateMappingToFile(mapping, file);
        }
        catch (IOException e) {
            throw new DataSourceException("IOException while writing adhoc template mapping!", e);
        }
        catch (XMLFormatException e) {
            throw new DataSourceException("XMLFormatException while writing adhoc template ID mapping", e);
        }
    }

    protected static IllegalArgumentException createUnknownEntityException(Object id) {
        String message = String.format("The entity with the ID '%s' does not exist.", id);
        return new IllegalArgumentException(message);
    }
}

