/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.core.processmanager.storage.sqlstorage;

import de.aristaflow.adept2.base.configuration.AbortServiceException;
import de.aristaflow.adept2.base.dbaccess.ExtendedConnection;
import de.aristaflow.adept2.base.dbaccess.JDBCDataSource;
import de.aristaflow.adept2.base.dbaccess.JDBCTools;
import de.aristaflow.adept2.base.dbaccess.SQLTools;
import de.aristaflow.adept2.base.service.InternalServiceException;
import de.aristaflow.adept2.base.service.Registry;
import de.aristaflow.adept2.base.service.ServiceNotKnownException;
import de.aristaflow.adept2.base.sessionmanagement.QualifiedAgent;
import de.aristaflow.adept2.core.checks.processmodel.ProcessTemplateCheck;
import de.aristaflow.adept2.core.checks.processmodel.ProcessTemplateCheckRunner;
import de.aristaflow.adept2.core.processmanager.TemplateStatusProvider;
import de.aristaflow.adept2.core.processmanager.storage.ExecutableProcessModelFactory;
import de.aristaflow.adept2.core.processmanager.storage.InstanceStorage;
import de.aristaflow.adept2.core.processmanager.storage.ProcessManagerStorage;
import de.aristaflow.adept2.core.processmanager.storage.ProcessManagerStorageTools;
import de.aristaflow.adept2.core.processmanager.storage.TemplateStorage;
import de.aristaflow.adept2.model.execution.ExecutableInstance;
import de.aristaflow.adept2.model.execution.ExecutionFactory;
import de.aristaflow.adept2.model.globals.ActivityConstants;
import de.aristaflow.adept2.model.processmodel.ChangeableInstance;
import de.aristaflow.adept2.model.processmodel.EBPInstanceReference;
import de.aristaflow.adept2.model.processmodel.InstanceReference;
import de.aristaflow.adept2.model.processmodel.InstanceStatus;
import de.aristaflow.adept2.model.processmodel.ProcessModelFactory;
import de.aristaflow.adept2.model.processmodel.ProcessModelParameter;
import de.aristaflow.adept2.model.processmodel.Template;
import de.aristaflow.adept2.model.processmodel.TemplateReference;
import de.aristaflow.adept2.model.processmodel.TemplateStatus;
import de.aristaflow.adept2.model.processmodel.tools.NodeRelations;
import de.aristaflow.adept2.model.processmodel.tools.ProcessElementIdentifierTools;
import de.aristaflow.adept2.model.processmodel.xml.ProcessModelXMLExport;
import de.aristaflow.adept2.model.processmodel.xml.ProcessModelXMLImport;
import de.aristaflow.adept2.util.CheckReport;
import de.aristaflow.adept2.util.DataSourceException;
import de.aristaflow.adept2.util.LoggerTools;
import de.aristaflow.adept2.util.UUIDTools;
import de.aristaflow.adept2.util.xml.VersionException;
import de.aristaflow.adept2.util.xml.XMLFormatException;
import de.aristaflow.adept2.util.xml.XMLHelperTools;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.w3c.dom.Document;

public class SQLXMLStorage
implements ProcessManagerStorage,
InstanceStorage,
TemplateStorage {
    private JDBCDataSource dataSource;
    private ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    private ProcessModelXMLExport xmlExport = new ProcessModelXMLExport();
    private ProcessModelXMLImport xmlImport;
    private ProcessModelFactory pmFactory;
    private final Registry registry;
    private Logger logger = LoggerTools.getLogger(this);
    protected ProcessTemplateCheckRunner allChecks;
    private TemplateStorage templateStorage = this;

    public SQLXMLStorage(Registry registry, JDBCDataSource dataSource, ProcessTemplateCheck[] checks) throws AbortServiceException {
        this.registry = registry;
        this.dataSource = dataSource;
        ExtendedConnection con = null;
        try {
            try {
                con = dataSource.getConnection();
                if (!con.tableExists("Instance")) {
                    SQLTools.runSQLScript(con, SQLXMLStorage.class.getResourceAsStream("sqlscripts/pmxml-create.sql"));
                }
                con = JDBCTools.close(con);
            }
            catch (SQLException e) {
                throw new AbortServiceException("Could not create tables for processmanager storage.", e);
            }
            catch (IOException e) {
                throw new AbortServiceException("Could not create tables for processmanager storage.", e);
            }
        }
        finally {
            JDBCTools.closeQuietly(con);
        }
        this.pmFactory = registry.getModelFactory("ProcessModelFactory", ProcessModelFactory.class);
        this.xmlImport = new ProcessModelXMLImport(this.pmFactory);
        this.allChecks = new ProcessTemplateCheckRunner(checks);
    }

    @Override
    public InstanceStorage getInstanceStorage() {
        return this;
    }

    @Override
    public TemplateStorage getTemplateStorage() {
        return this.templateStorage;
    }

    public void runChecks() throws AbortServiceException {
        try {
            Set<UUID> ids = this.getAllTemplateIDs();
            for (UUID id : ids) {
                this.performInitChecks(this.getTemplate(id));
            }
        }
        catch (DataSourceException e) {
            String message = "DataSourceException while running checks.";
            this.logger.log(Level.SEVERE, message);
            throw new AbortServiceException(message, e);
        }
    }

    protected void performInitChecks(Template template) throws AbortServiceException {
        long start = System.nanoTime();
        URI base = ProcessElementIdentifierTools.getTemplateIdentifier(template, "localhost");
        CheckReport checkReport = new CheckReport(base);
        boolean checkSuccess = this.allChecks.performCheck(template, new NodeRelations(template), checkReport);
        if (!checkSuccess) {
            String message = String.format("The checks on template '%s' failed with the following result:\n%s.", template.getID().toString(), checkReport.getSimpleReportSummary());
            this.logger.log(Level.SEVERE, message);
            throw new AbortServiceException(message);
        }
        String msg = String.format("Performed initial checks for template '%s' [%s] in %,d nano seconds", template.getName(), template.getID(), System.nanoTime() - start);
        this.logger.fine(msg);
    }

    @Override
    public ExecutableInstance createInstance(UUID templateID, String instanceName, QualifiedAgent supervisorAgent, QualifiedAgent initiatorAgent, EBPInstanceReference parentActivity, long creationTime) throws DataSourceException {
        Template template = this.templateStorage.getTemplate(templateID);
        ExecutableProcessModelFactory epmf = new ExecutableProcessModelFactory(null);
        epmf.setCreateChangeable(false);
        ExecutableInstance instance = epmf.createInstance(UUIDTools.createPositiveUUID(), UUIDTools.createRandomUUID(), instanceName, templateID, template, supervisorAgent, initiatorAgent, parentActivity, creationTime);
        InstanceStatus instanceStatus = ProcessManagerStorageTools.getDefaultInstanceStatus(instance.getID());
        ExtendedConnection con = null;
        PreparedStatement stmt = null;
        this.lock.writeLock().lock();
        try {
            try {
                con = this.dataSource.getConnection();
                stmt = con.prepareStatement("INSERT INTO Instance (idLow, idHigh, logIDLow, logIDHigh, templateIDLow, templateIDHigh, lockingAgentID, lockingOrgPosID, lockingAgentName, lockingOrgPosName, lockCount, xmlBlob) VALUES (?, ?, ?, ?, ?, ?, NULL,NULL, NULL, NULL, 0, ?)");
                stmt.setLong(1, instance.getID().getLeastSignificantBits());
                stmt.setLong(2, instance.getID().getMostSignificantBits());
                stmt.setLong(3, instance.getLogID().getLeastSignificantBits());
                stmt.setLong(4, instance.getLogID().getMostSignificantBits());
                stmt.setLong(5, templateID.getLeastSignificantBits());
                stmt.setLong(6, templateID.getMostSignificantBits());
                Document doc = this.xmlExport.getDocumentForExecutableInstanceAndStatus(instance, instanceStatus, false);
                byte[] bytes = XMLHelperTools.getByteArrayForDocument(doc);
                ByteArrayInputStream stream = new ByteArrayInputStream(bytes);
                stmt.setBinaryStream(7, (InputStream)stream, bytes.length);
                stmt.executeUpdate();
                stmt = JDBCTools.close(stmt);
                con = JDBCTools.close(con);
            }
            catch (SQLException e) {
                throw new DataSourceException("SQL Exception thrown", e);
            }
            catch (IOException e) {
                throw new DataSourceException("IOException while creating instance", e);
            }
        }
        catch (Throwable throwable) {
            JDBCTools.closeQuietly(con, stmt);
            this.lock.writeLock().unlock();
            throw throwable;
        }
        JDBCTools.closeQuietly(con, (Statement)stmt);
        this.lock.writeLock().unlock();
        return instance;
    }

    @Override
    public Map<UUID, QualifiedAgent> getChangeLocks() throws DataSourceException {
        HashMap<UUID, QualifiedAgent> res = new HashMap<UUID, QualifiedAgent>();
        ExtendedConnection con = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        this.lock.readLock().lock();
        try {
            try {
                con = this.dataSource.getConnection();
                stmt = con.prepareStatement("SELECT idLow, idHigh, lockingAgentID, lockingAgentName, lockingOrgPosName, lockingOrgPosID FROM Instance WHERE lockCount > 0");
                rs = stmt.executeQuery();
                while (rs.next()) {
                    UUID id = new UUID(rs.getLong("idHigh"), rs.getLong("idLow"));
                    QualifiedAgent qa = new QualifiedAgent(rs.getLong("lockingAgentID"), rs.getString("lockingAgentName"), rs.getLong("lockingOrgPosID"), rs.getString("lockingOrgPosName"));
                    res.put(id, qa);
                }
                rs = JDBCTools.close(rs);
                stmt = JDBCTools.close(stmt);
                con = JDBCTools.close(con);
            }
            catch (SQLException e) {
                throw new DataSourceException("SQLException occured", e);
            }
        }
        catch (Throwable throwable) {
            JDBCTools.closeQuietly(con, stmt, rs);
            this.lock.readLock().unlock();
            throw throwable;
        }
        JDBCTools.closeQuietly(con, (Statement)stmt, rs);
        this.lock.readLock().unlock();
        return res;
    }

    @Override
    public ExecutableInstance getInstance(UUID instanceID) throws DataSourceException {
        ExecutableInstance res;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        ExtendedConnection con = null;
        this.lock.readLock().lock();
        try {
            try {
                ExecutionFactory executionFactory;
                con = this.dataSource.getConnection();
                stmt = con.prepareStatement("SELECT templateIDLow, templateIDHigh FROM Instance WHERE idLow=? AND idHigh=?");
                stmt.setLong(1, instanceID.getLeastSignificantBits());
                stmt.setLong(2, instanceID.getMostSignificantBits());
                rs = stmt.executeQuery();
                if (!rs.next()) {
                    String msg = String.format("Instance with id %s not known!", instanceID);
                    this.logger.severe(msg);
                    throw new IllegalArgumentException(msg);
                }
                UUID templateID = new UUID(rs.getLong("templateIDHigh"), rs.getLong("templateIDLow"));
                JDBCTools.close(rs);
                JDBCTools.close(stmt);
                JDBCTools.close(con);
                Template template = this.templateStorage.getTemplate(templateID);
                con = this.dataSource.getConnection();
                stmt = con.prepareStatement("SELECT xmlBlob, templateIDLow, templateIDHigh FROM Instance WHERE idLow=? AND idHigh=?");
                stmt.setLong(1, instanceID.getLeastSignificantBits());
                stmt.setLong(2, instanceID.getMostSignificantBits());
                rs = stmt.executeQuery();
                if (!rs.next()) {
                    String msg = String.format("Instance with id %s not known!", instanceID);
                    this.logger.severe(msg);
                    throw new IllegalArgumentException(msg);
                }
                InputStream stream = rs.getBinaryStream("xmlBlob");
                Document doc = XMLHelperTools.getDocumentFromStream(stream);
                try {
                    executionFactory = this.registry.getModelFactory("ExecutionFactory", ExecutionFactory.class);
                }
                catch (ServiceNotKnownException snke) {
                    String msg = "Could not retrieve execution model factory for creating  the executable instance '%s'. Aborting retrieval of  executable instance.";
                    throw new InternalServiceException(String.format(msg, instanceID), snke);
                }
                res = this.xmlImport.getExecutableInstanceFromDocument(executionFactory, doc, template);
                rs = JDBCTools.close(rs);
                stmt = JDBCTools.close(stmt);
                con = JDBCTools.close(con);
            }
            catch (SQLException e) {
                throw new DataSourceException("SQLException thrown", e);
            }
            catch (XMLFormatException e) {
                throw new DataSourceException("XMLFormatException!", e);
            }
            catch (IOException e) {
                throw new DataSourceException("IOException", e);
            }
        }
        catch (Throwable throwable) {
            JDBCTools.closeQuietly(con, stmt, rs);
            this.lock.readLock().unlock();
            throw throwable;
        }
        JDBCTools.closeQuietly(con, (Statement)stmt, rs);
        this.lock.readLock().unlock();
        return res;
    }

    @Override
    public ChangeableInstance getInstanceChangeable(UUID instanceID) throws DataSourceException {
        this.lock.readLock().lock();
        try {
            ExecutableInstance instance = this.getInstance(instanceID);
            ChangeableInstance changeableInstance = ProcessManagerStorageTools.executableToChangeableInstance(instance);
            return changeableInstance;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public Set<UUID> getInstanceIDsForTemplate(UUID templateID) {
        HashSet<UUID> res = new HashSet<UUID>();
        ExtendedConnection con = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        this.lock.readLock().lock();
        try {
            try {
                con = this.dataSource.getConnection();
                stmt = con.prepareStatement("SELECT inst.idLow,  inst.idHigh FROM Instance inst  LEFT OUTER JOIN BaseTemplateIDs base ON base.baseIDLow=? AND  base.baseIDHigh=? WHERE (inst.templateIDLow=? AND  inst.templateIDHigh=?) OR  (base.idLow=inst.templateIDLow AND  base.idHigh=inst.templateIDHigh)");
                stmt.setLong(1, templateID.getLeastSignificantBits());
                stmt.setLong(2, templateID.getMostSignificantBits());
                stmt.setLong(3, templateID.getLeastSignificantBits());
                stmt.setLong(4, templateID.getMostSignificantBits());
                rs = stmt.executeQuery();
                if (rs.next()) {
                    do {
                        UUID id = new UUID(rs.getLong("idHigh"), rs.getLong("idLow"));
                        res.add(id);
                    } while (rs.next());
                } else {
                    PreparedStatement stmtCheck = null;
                    ResultSet rs2 = null;
                    try {
                        stmtCheck = con.prepareStatement("SELECT lockCount FROM Template WHERE idLow=? AND idHigh=?");
                        stmtCheck.setLong(1, templateID.getLeastSignificantBits());
                        stmtCheck.setLong(2, templateID.getMostSignificantBits());
                        rs2 = stmtCheck.executeQuery();
                        if (!rs2.next()) {
                            String msg = String.format("Template with id %s not known!", templateID);
                            this.logger.severe(msg);
                            throw new IllegalArgumentException(msg);
                        }
                        rs2 = JDBCTools.close(rs2);
                        stmtCheck = JDBCTools.close(stmtCheck);
                    }
                    catch (Throwable throwable) {
                        JDBCTools.closeQuietly((Statement)stmtCheck, rs2);
                        throw throwable;
                    }
                    JDBCTools.closeQuietly((Statement)stmtCheck, rs2);
                }
                rs = JDBCTools.close(rs);
                stmt = JDBCTools.close(stmt);
                con = JDBCTools.close(con);
            }
            catch (SQLException e) {
                throw new RuntimeException("SQLException thrown.", e);
            }
        }
        catch (Throwable throwable) {
            JDBCTools.closeQuietly(con, stmt, rs);
            this.lock.readLock().unlock();
            throw throwable;
        }
        JDBCTools.closeQuietly(con, (Statement)stmt, rs);
        this.lock.readLock().unlock();
        return res;
    }

    @Override
    public InstanceReference getInstanceReference(UUID instanceID, TemplateStatusProvider statusProvider) throws DataSourceException {
        InstanceReference res;
        ExtendedConnection con = null;
        this.lock.readLock().lock();
        try {
            try {
                ExecutableInstance instance = this.getInstance(instanceID);
                con = this.dataSource.getConnection();
                TemplateReference tempRef = this.getTemplateReference(instance.getTemplate().getID(), statusProvider, con);
                InstanceStatus status = this.getInstanceStatus(instanceID, con);
                UUID parentInstanceID = null;
                if (instance.getParentEBPReference() != null) {
                    parentInstanceID = instance.getParentEBPReference().getInstanceID();
                }
                res = this.pmFactory.createInstanceReference(instance.getID(), instance.getLogID(), instance.getName(), instance.isModified(), tempRef, instance.getSupervisorAgent(), instance.getInitiatorAgent(), instance.getCreationTime(), parentInstanceID, status.getExecutionStatus(), instance.getSupportedPlugins(), instance.getPluginDatas(), instance.getUserAttributes());
                JDBCTools.close(con);
            }
            catch (SQLException e) {
                throw new DataSourceException("SQLException", e);
            }
        }
        catch (Throwable throwable) {
            JDBCTools.closeQuietly(con);
            this.lock.readLock().unlock();
            throw throwable;
        }
        JDBCTools.closeQuietly(con);
        this.lock.readLock().unlock();
        return res;
    }

    @Override
    public InstanceStatus getInstanceStatus(UUID instanceID) throws DataSourceException {
        return this.getInstanceStatus(instanceID, null);
    }

    private InstanceStatus getInstanceStatus(UUID instanceID, ExtendedConnection con) throws DataSourceException {
        InstanceStatus res;
        boolean ownConnection = con == null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        this.lock.readLock().lock();
        try {
            try {
                if (con == null) {
                    con = this.dataSource.getConnection();
                }
                stmt = con.prepareStatement("SELECT xmlBlob, templateIDLow, templateIDHigh FROM Instance WHERE idLow=? AND idHigh=?");
                stmt.setLong(1, instanceID.getLeastSignificantBits());
                stmt.setLong(2, instanceID.getMostSignificantBits());
                rs = stmt.executeQuery();
                if (!rs.next()) {
                    String msg = String.format("Instance with id %s not known!", instanceID);
                    this.logger.severe(msg);
                    throw new IllegalArgumentException(msg);
                }
                InputStream stream = rs.getBinaryStream("xmlBlob");
                Document doc = XMLHelperTools.getDocumentFromStream(stream);
                res = this.xmlImport.getInstanceStatusFromInstanceDocument(doc);
                rs = JDBCTools.close(rs);
                stmt = JDBCTools.close(stmt);
                if (ownConnection) {
                    con = JDBCTools.close(con);
                }
            }
            catch (SQLException e) {
                throw new DataSourceException("SQLException thrown", e);
            }
            catch (XMLFormatException e) {
                throw new DataSourceException("XMLFormatException!", e);
            }
            catch (IOException e) {
                throw new DataSourceException("IOExcepion", e);
            }
            catch (VersionException e) {
                throw new DataSourceException("VersionException", e);
            }
        }
        catch (Throwable throwable) {
            if (ownConnection) {
                JDBCTools.closeQuietly(con, (Statement)stmt, rs);
            } else {
                JDBCTools.closeQuietly((Statement)stmt, rs);
            }
            this.lock.readLock().unlock();
            throw throwable;
        }
        if (ownConnection) {
            JDBCTools.closeQuietly(con, (Statement)stmt, rs);
        } else {
            JDBCTools.closeQuietly((Statement)stmt, rs);
        }
        this.lock.readLock().unlock();
        return res;
    }

    @Override
    public UUID getLogicalInstanceID(UUID logID) {
        UUID res;
        ExtendedConnection con = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        this.lock.readLock().lock();
        try {
            try {
                con = this.dataSource.getConnection();
                stmt = con.prepareStatement("SELECT idLow, idHigh FROM Instance WHERE logIDLow=? AND logIDHigh=?");
                stmt.setLong(1, logID.getLeastSignificantBits());
                stmt.setLong(2, logID.getMostSignificantBits());
                rs = stmt.executeQuery();
                if (!rs.next()) {
                    String msg = String.format("Instance with logID %s not known!", logID);
                    this.logger.severe(msg);
                    throw new IllegalArgumentException(msg);
                }
                res = new UUID(rs.getLong("idHigh"), rs.getLong("idLow"));
                rs = JDBCTools.close(rs);
                stmt = JDBCTools.close(stmt);
                con = JDBCTools.close(con);
            }
            catch (SQLException e) {
                throw new RuntimeException("SQLException thrown.", e);
            }
        }
        catch (Throwable throwable) {
            JDBCTools.closeQuietly(con, stmt, rs);
            this.lock.readLock().unlock();
            throw throwable;
        }
        JDBCTools.closeQuietly(con, (Statement)stmt, rs);
        this.lock.readLock().unlock();
        return res;
    }

    @Override
    public int lockInstanceForChanging(UUID instanceID, QualifiedAgent lockingAgent) throws DataSourceException {
        int res;
        ExtendedConnection con = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        this.lock.writeLock().lock();
        try {
            try {
                con = this.dataSource.getConnection();
                stmt = con.prepareStatement("UPDATE Instance SET lockCount = lockCount+1,lockingAgentID=?,lockingAgentName=?,lockingOrgPosID=?,lockingOrgPosName=? WHERE idLow=? AND idHigh=? AND (lockCount=0 OR (lockingAgentID=? AND lockingOrgPosID=?))");
                stmt.setLong(1, lockingAgent.getAgentID());
                stmt.setString(2, lockingAgent.getAgentUserName());
                stmt.setLong(3, lockingAgent.getOrgPositionID());
                stmt.setString(4, lockingAgent.getOrgPositionName());
                stmt.setLong(5, instanceID.getLeastSignificantBits());
                stmt.setLong(6, instanceID.getMostSignificantBits());
                stmt.setLong(7, lockingAgent.getAgentID());
                stmt.setLong(8, lockingAgent.getOrgPositionID());
                stmt.execute();
                if (stmt.getUpdateCount() == 0) {
                    String msg = String.format("Instance with id %s already locked by someone else.", instanceID);
                    this.logger.severe(msg);
                    throw new DataSourceException(msg);
                }
                stmt = JDBCTools.close(stmt);
                stmt = con.prepareStatement("SELECT lockCount FROM Instance WHERE idLow=? AND idHigh=?");
                stmt.setLong(1, instanceID.getLeastSignificantBits());
                stmt.setLong(2, instanceID.getMostSignificantBits());
                rs = stmt.executeQuery();
                if (!rs.next()) {
                    throw new DataSourceException("Could not get new LockCount!");
                }
                res = rs.getInt("lockCount");
                rs = JDBCTools.close(rs);
                stmt = JDBCTools.close(stmt);
                con = JDBCTools.close(con);
            }
            catch (SQLException e) {
                throw new DataSourceException("SQLException occured!", e);
            }
        }
        catch (Throwable throwable) {
            JDBCTools.closeQuietly(con, stmt, rs);
            this.lock.writeLock().unlock();
            throw throwable;
        }
        JDBCTools.closeQuietly(con, (Statement)stmt, rs);
        this.lock.writeLock().unlock();
        return res;
    }

    @Override
    public int unlockInstanceForChanging(UUID instanceID) throws DataSourceException {
        int res;
        ExtendedConnection con = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        this.lock.writeLock().lock();
        try {
            try {
                con = this.dataSource.getConnection();
                stmt = con.prepareStatement("UPDATE Instance SET lockCount = lockCount-1 WHERE idLow=? AND idHigh=?");
                stmt.setLong(1, instanceID.getLeastSignificantBits());
                stmt.setLong(2, instanceID.getMostSignificantBits());
                stmt.execute();
                if (stmt.getUpdateCount() == 0) {
                    String msg = String.format("Could not unlock instance %s.", instanceID.toString());
                    this.logger.severe(msg);
                    throw new DataSourceException(msg);
                }
                stmt = JDBCTools.close(stmt);
                stmt = con.prepareStatement("SELECT lockCount FROM Instance WHERE idLow=? AND idHigh=?");
                stmt.setLong(1, instanceID.getLeastSignificantBits());
                stmt.setLong(2, instanceID.getMostSignificantBits());
                rs = stmt.executeQuery();
                if (!rs.next()) {
                    throw new DataSourceException("Could not get LockCount!");
                }
                res = rs.getInt("lockCount");
                if (res == 0) {
                    stmt = JDBCTools.close(stmt);
                    stmt = con.prepareStatement("UPDATE Instance SET lockingAgentID=NULL, lockingAgentName=NULL, lockingOrgPosID=NULL, lockingOrgPosName=NULL WHERE idLow=? AND idHigh=? AND lockCount=0");
                    stmt.setLong(1, instanceID.getLeastSignificantBits());
                    stmt.setLong(2, instanceID.getMostSignificantBits());
                    stmt.executeUpdate();
                }
                rs = JDBCTools.close(rs);
                stmt = JDBCTools.close(stmt);
                con = JDBCTools.close(con);
            }
            catch (SQLException e) {
                throw new DataSourceException("SQLException thrown", e);
            }
        }
        catch (Throwable throwable) {
            JDBCTools.closeQuietly(con, stmt, rs);
            this.lock.writeLock().unlock();
            throw throwable;
        }
        JDBCTools.closeQuietly(con, (Statement)stmt, rs);
        this.lock.writeLock().unlock();
        return res;
    }

    @Override
    public UUID updateChangeableInstance(ChangeableInstance instance) throws DataSourceException {
        UUID res = instance.getID();
        ExtendedConnection con = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        this.lock.writeLock().lock();
        try {
            try {
                if (instance.isModified()) {
                    con = this.dataSource.getConnection();
                    stmt = con.prepareStatement("SELECT xmlBlob FROM Template WHERE idLow=? AND idHigh=?");
                    stmt.setLong(1, instance.getTemplate().getID().getLeastSignificantBits());
                    stmt.setLong(2, instance.getTemplate().getID().getMostSignificantBits());
                    rs = stmt.executeQuery();
                    boolean insertTemplate = !rs.next();
                    rs = JDBCTools.close(rs);
                    stmt = JDBCTools.close(stmt);
                    if (insertTemplate) {
                        JDBCTools.close(con);
                        this.templateStorage.createTemplate(instance.getTemplate(), null);
                        con = this.dataSource.getConnection();
                        stmt = con.prepareStatement("UPDATE BaseTemplateIDs SET baseIDLow=?, baseIDHigh=? WHERE idLow=? AND idHigh=?");
                        stmt.setLong(1, instance.getBaseTemplateID().getLeastSignificantBits());
                        stmt.setLong(2, instance.getBaseTemplateID().getMostSignificantBits());
                        stmt.setLong(3, instance.getTemplate().getID().getLeastSignificantBits());
                        stmt.setLong(4, instance.getTemplate().getID().getMostSignificantBits());
                        stmt.execute();
                    } else {
                        stmt = con.prepareStatement("UPDATE Template SET xmlBlob=? WHERE idLow=? AND idHigh=?");
                        Document doc = this.xmlExport.getDocumentForTemplateAndStatus(instance.getTemplate(), null);
                        byte[] bytes = XMLHelperTools.getByteArrayForDocument(doc);
                        ByteArrayInputStream stream = new ByteArrayInputStream(bytes);
                        stmt.setBinaryStream(1, (InputStream)stream, bytes.length);
                        stmt.setLong(2, instance.getTemplate().getID().getLeastSignificantBits());
                        stmt.setLong(3, instance.getTemplate().getID().getMostSignificantBits());
                        stmt.execute();
                    }
                    JDBCTools.close(stmt);
                    UUID oldID = instance.getID();
                    InstanceStatus status = this.getInstanceStatus(oldID, con);
                    ExecutableInstance oldInstance = this.getInstance(oldID);
                    res = oldID;
                    instance = ProcessManagerStorageTools.changeInstanceValues(instance, res, instance.getTemplate());
                    status = ProcessManagerStorageTools.changeInstanceStatusValues(status, instance.getID());
                    ExecutableInstance executableInstance = ProcessManagerStorageTools.changeableToExecutableInstance(instance, oldInstance);
                    stmt = con.prepareStatement("UPDATE Instance SET idLow=?, idHigh=?, templateIDLow=?, templateIDHigh=?, xmlBlob=?  WHERE idLow=? AND idHigh=?");
                    stmt.setLong(1, instance.getID().getLeastSignificantBits());
                    stmt.setLong(2, instance.getID().getMostSignificantBits());
                    stmt.setLong(3, instance.getTemplate().getID().getLeastSignificantBits());
                    stmt.setLong(4, instance.getTemplate().getID().getMostSignificantBits());
                    Document doc = this.xmlExport.getDocumentForExecutableInstanceAndStatus(executableInstance, status, true);
                    byte[] bytes = XMLHelperTools.getByteArrayForDocument(doc);
                    ByteArrayInputStream stream = new ByteArrayInputStream(bytes);
                    stmt.setBinaryStream(5, (InputStream)stream, bytes.length);
                    stmt.setLong(6, oldID.getLeastSignificantBits());
                    stmt.setLong(7, oldID.getMostSignificantBits());
                    stmt.execute();
                    if (stmt.getUpdateCount() == 0) {
                        String msg = String.format("Instance with id %s not known!", instance.getID());
                        this.logger.severe(msg);
                        throw new IllegalArgumentException(msg);
                    }
                    stmt = JDBCTools.close(stmt);
                    con = JDBCTools.close(con);
                }
            }
            catch (SQLException e) {
                throw new DataSourceException("SQLException", e);
            }
            catch (IOException e) {
                throw new DataSourceException("IOException", e);
            }
            catch (XMLFormatException e) {
                throw new DataSourceException("XMLFormatException", e);
            }
        }
        catch (Throwable throwable) {
            JDBCTools.closeQuietly(con, stmt, rs);
            this.lock.writeLock().unlock();
            throw throwable;
        }
        JDBCTools.closeQuietly(con, stmt, rs);
        this.lock.writeLock().unlock();
        return res;
    }

    @Override
    public void updateInstance(ExecutableInstance instance) throws DataSourceException {
        ExtendedConnection con = null;
        PreparedStatement stmt = null;
        this.lock.writeLock().lock();
        try {
            try {
                con = this.dataSource.getConnection();
                InstanceStatus status = this.getInstanceStatus(instance.getID(), con);
                stmt = con.prepareStatement("UPDATE Instance SET idLow=?, idHigh=?, templateIDLow=?, templateIDHigh=?, xmlBlob=?  WHERE idLow=? AND idHigh=?");
                stmt.setLong(1, instance.getID().getLeastSignificantBits());
                stmt.setLong(2, instance.getID().getMostSignificantBits());
                stmt.setLong(3, instance.getTemplate().getID().getLeastSignificantBits());
                stmt.setLong(4, instance.getTemplate().getID().getMostSignificantBits());
                Document doc = this.xmlExport.getDocumentForExecutableInstanceAndStatus(instance, status, true);
                byte[] bytes = XMLHelperTools.getByteArrayForDocument(doc);
                ByteArrayInputStream stream = new ByteArrayInputStream(bytes);
                stmt.setBinaryStream(5, (InputStream)stream, bytes.length);
                stmt.setLong(6, instance.getID().getLeastSignificantBits());
                stmt.setLong(7, instance.getID().getMostSignificantBits());
                stmt.executeUpdate();
                stmt = JDBCTools.close(stmt);
                con = JDBCTools.close(con);
            }
            catch (SQLException e) {
                throw new DataSourceException("SQLException", e);
            }
            catch (IOException e) {
                throw new DataSourceException("IOException", e);
            }
        }
        catch (Throwable throwable) {
            JDBCTools.closeQuietly(con, stmt);
            this.lock.writeLock().unlock();
            throw throwable;
        }
        JDBCTools.closeQuietly(con, (Statement)stmt);
        this.lock.writeLock().unlock();
    }

    @Override
    public void updateInstanceStatus(InstanceStatus instanceStatus) throws DataSourceException {
        ExtendedConnection con = null;
        PreparedStatement stmt = null;
        this.lock.writeLock().lock();
        try {
            try {
                ExecutableInstance instance = this.getInstance(instanceStatus.getInstanceID());
                con = this.dataSource.getConnection();
                stmt = con.prepareStatement("UPDATE Instance SET idLow=?, idHigh=?, templateIDLow=?, templateIDHigh=?, xmlBlob=?  WHERE idLow=? AND idHigh=?");
                stmt.setLong(1, instance.getID().getLeastSignificantBits());
                stmt.setLong(2, instance.getID().getMostSignificantBits());
                stmt.setLong(3, instance.getTemplate().getID().getLeastSignificantBits());
                stmt.setLong(4, instance.getTemplate().getID().getMostSignificantBits());
                Document doc = this.xmlExport.getDocumentForExecutableInstanceAndStatus(instance, instanceStatus, true);
                byte[] bytes = XMLHelperTools.getByteArrayForDocument(doc);
                ByteArrayInputStream stream = new ByteArrayInputStream(bytes);
                stmt.setBinaryStream(5, (InputStream)stream, bytes.length);
                stmt.setLong(6, instance.getID().getLeastSignificantBits());
                stmt.setLong(7, instance.getID().getMostSignificantBits());
                stmt.executeUpdate();
                stmt = JDBCTools.close(stmt);
                con = JDBCTools.close(con);
            }
            catch (SQLException e) {
                throw new DataSourceException("SQLException", e);
            }
            catch (IOException e) {
                throw new DataSourceException("IOException", e);
            }
        }
        catch (Throwable throwable) {
            JDBCTools.closeQuietly(con, stmt);
            this.lock.writeLock().unlock();
            throw throwable;
        }
        JDBCTools.closeQuietly(con, (Statement)stmt);
        this.lock.writeLock().unlock();
    }

    @Override
    public void createTemplate(Template template, TemplateStatus templateStatus) throws DataSourceException {
        ExtendedConnection con = null;
        PreparedStatement stmt = null;
        this.lock.writeLock().lock();
        try {
            try {
                con = this.dataSource.getConnection();
                stmt = con.prepareStatement("INSERT INTO Template (idLow,idHigh,lockingAgentID,lockingAgentName,lockingOrgPosID,lockingOrgPosName,lockCount,xmlBlob) VALUES (?, ?, NULL, NULL, NULL, NULL, 0, ?)");
                stmt.setLong(1, template.getID().getLeastSignificantBits());
                stmt.setLong(2, template.getID().getMostSignificantBits());
                Document doc = this.xmlExport.getDocumentForTemplateAndStatus(template, templateStatus);
                byte[] bytes = XMLHelperTools.getByteArrayForDocument(doc);
                ByteArrayInputStream stream = new ByteArrayInputStream(bytes);
                stmt.setBinaryStream(3, (InputStream)stream, bytes.length);
                stmt.executeUpdate();
                JDBCTools.close(stmt);
                stmt = con.prepareStatement("INSERT INTO BaseTemplateIDs (idLow,idHigh,baseIDLow,baseIDHigh) VALUES (?, ?, ?, ?)");
                stmt.setLong(1, template.getID().getLeastSignificantBits());
                stmt.setLong(2, template.getID().getMostSignificantBits());
                stmt.setLong(3, template.getID().getLeastSignificantBits());
                stmt.setLong(4, template.getID().getMostSignificantBits());
                stmt.execute();
                stmt = JDBCTools.close(stmt);
                con = JDBCTools.close(con);
            }
            catch (SQLException e) {
                throw new DataSourceException("SQLException", e);
            }
            catch (XMLFormatException e) {
                throw new DataSourceException("XMLFormatException thrown", e);
            }
            catch (IOException e) {
                throw new DataSourceException("IOException", e);
            }
        }
        catch (Throwable throwable) {
            JDBCTools.closeQuietly(con, stmt);
            this.lock.writeLock().unlock();
            throw throwable;
        }
        JDBCTools.closeQuietly(con, (Statement)stmt);
        this.lock.writeLock().unlock();
    }

    @Override
    public Set<UUID> getAllTemplateIDs() throws DataSourceException {
        HashSet<UUID> res = new HashSet<UUID>();
        ExtendedConnection con = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        this.lock.readLock().lock();
        try {
            try {
                con = this.dataSource.getConnection();
                stmt = con.prepareStatement("SELECT idLow, idHigh FROM Template");
                rs = stmt.executeQuery();
                while (rs.next()) {
                    UUID id = new UUID(rs.getLong("idHigh"), rs.getLong("idLow"));
                    res.add(id);
                }
                rs = JDBCTools.close(rs);
                stmt = JDBCTools.close(stmt);
                con = JDBCTools.close(con);
            }
            catch (SQLException e) {
                throw new DataSourceException("SQLException", e);
            }
        }
        catch (Throwable throwable) {
            JDBCTools.closeQuietly(con, stmt, rs);
            this.lock.readLock().unlock();
            throw throwable;
        }
        JDBCTools.closeQuietly(con, (Statement)stmt, rs);
        this.lock.readLock().unlock();
        return res;
    }

    @Override
    public UUID getParentTemplateID(UUID embeddedID) throws DataSourceException {
        return this.getParentTemplateID(embeddedID, null);
    }

    private UUID getParentTemplateID(UUID embeddedID, ExtendedConnection con) throws DataSourceException {
        boolean ownConnection = con == null;
        UUID res = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        this.lock.readLock().lock();
        try {
            try {
                if (con == null) {
                    con = this.dataSource.getConnection();
                }
                stmt = con.prepareStatement("SELECT parentTemplateIDLow, parentTemplateIDHigh FROM EmbeddedTemplate WHERE idLow=? AND idHigh=?");
                stmt.setLong(1, embeddedID.getLeastSignificantBits());
                stmt.setLong(2, embeddedID.getMostSignificantBits());
                rs = stmt.executeQuery();
                if (rs.next()) {
                    res = new UUID(rs.getLong("parentTemplateIDHigh"), rs.getLong("parentTemplateIDLow"));
                }
                rs = JDBCTools.close(rs);
                stmt = JDBCTools.close(stmt);
                if (ownConnection) {
                    con = JDBCTools.close(con);
                }
            }
            catch (SQLException e) {
                throw new DataSourceException("SQLException", e);
            }
        }
        catch (Throwable throwable) {
            if (ownConnection) {
                JDBCTools.closeQuietly(con, (Statement)stmt, rs);
            } else {
                JDBCTools.closeQuietly((Statement)stmt, rs);
            }
            this.lock.readLock().unlock();
            throw throwable;
        }
        if (ownConnection) {
            JDBCTools.closeQuietly(con, (Statement)stmt, rs);
        } else {
            JDBCTools.closeQuietly((Statement)stmt, rs);
        }
        this.lock.readLock().unlock();
        return res;
    }

    @Override
    public Template getTemplate(UUID templateID) throws DataSourceException {
        Template template;
        long start = System.nanoTime();
        try {
            template = this.getTemplate(templateID, null);
        }
        catch (Throwable throwable) {
            String msg = String.format("SQLXMLStorage.getTemplate(%s) needed %,d nano seconds.", templateID, System.nanoTime() - start);
            this.logger.fine(msg);
            throw throwable;
        }
        String msg = String.format("SQLXMLStorage.getTemplate(%s) needed %,d nano seconds.", templateID, System.nanoTime() - start);
        this.logger.fine(msg);
        return template;
    }

    private Template getTemplate(UUID templateID, ExtendedConnection con) throws DataSourceException {
        Template res;
        boolean ownConnection = con == null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        this.lock.readLock().lock();
        try {
            try {
                if (con == null) {
                    con = this.dataSource.getConnection();
                }
                stmt = con.prepareStatement("SELECT xmlBlob FROM Template WHERE idLow=? AND idHigh=?");
                stmt.setLong(1, templateID.getLeastSignificantBits());
                stmt.setLong(2, templateID.getMostSignificantBits());
                rs = stmt.executeQuery();
                if (!rs.next()) {
                    String msg = String.format("Template with id %s not known!", templateID);
                    this.logger.severe(msg);
                    throw new IllegalArgumentException(msg);
                }
                InputStream stream = rs.getBinaryStream("xmlBlob");
                Document doc = XMLHelperTools.getDocumentFromStream(stream);
                res = this.xmlImport.getTemplateFromDocument(doc);
                rs = JDBCTools.close(rs);
                stmt = JDBCTools.close(stmt);
                if (ownConnection) {
                    con = JDBCTools.close(con);
                }
            }
            catch (SQLException e) {
                throw new DataSourceException("SQLException", e);
            }
            catch (XMLFormatException e) {
                throw new DataSourceException("XMLFormatException", e);
            }
            catch (IOException e) {
                throw new DataSourceException("IOException", e);
            }
        }
        catch (Throwable throwable) {
            if (ownConnection) {
                JDBCTools.closeQuietly(con, (Statement)stmt, rs);
            } else {
                JDBCTools.closeQuietly((Statement)stmt, rs);
            }
            this.lock.readLock().unlock();
            throw throwable;
        }
        if (ownConnection) {
            JDBCTools.closeQuietly(con, (Statement)stmt, rs);
        } else {
            JDBCTools.closeQuietly((Statement)stmt, rs);
        }
        this.lock.readLock().unlock();
        return res;
    }

    @Override
    public TemplateReference getTemplateReference(UUID templateID, TemplateStatusProvider statusProvider) throws DataSourceException {
        return this.getTemplateReference(templateID, statusProvider, null);
    }

    private TemplateReference getTemplateReference(UUID templateID, TemplateStatusProvider statusProvider, ExtendedConnection con) throws DataSourceException {
        TemplateReference res;
        boolean ownConnection = con == null;
        this.lock.readLock().lock();
        try {
            try {
                if (con == null) {
                    con = this.dataSource.getConnection();
                }
                Template template = this.getTemplate(templateID, con);
                TemplateStatus status = statusProvider.getTemplateStatus(templateID);
                HashSet<ProcessModelParameter> inputParameters = new HashSet<ProcessModelParameter>(template.getParameters(ActivityConstants.AccessType.READ));
                HashSet<ProcessModelParameter> outputParameters = new HashSet<ProcessModelParameter>(template.getParameters(ActivityConstants.AccessType.WRITE));
                res = this.pmFactory.createTemplateReference(templateID, template.getProcessType(), template.getVersion(), template.getName(), template.getDescription(), template.getSupervisorAgent(), inputParameters, outputParameters, template.getSupportedPlugins(), template.getPluginDatas(), template.getUserAttributes(), status.isTopLevelUsable(), status.getUsageAsSubprocess(), status.getBuildtimeState(), status.isDerivable(), status.isOutdated(true), status.isOutdated(false), status.isInstantiable(true), status.isInstantiable(false), status.areInstancesMigratableTo(true), status.areInstancesMigratableTo(false), status.areInstancesChangeable(true), status.areInstancesChangeable(false));
                if (ownConnection) {
                    JDBCTools.close(con);
                }
            }
            catch (SQLException e) {
                throw new DataSourceException("SQLException", e);
            }
        }
        finally {
            if (ownConnection) {
                JDBCTools.closeQuietly(con);
            }
            this.lock.readLock().unlock();
        }
        return res;
    }

    @Override
    public TemplateStatus getTemplateStatus(UUID templateID) throws DataSourceException {
        return this.getTemplateStatus(templateID, null);
    }

    private TemplateStatus getTemplateStatus(UUID templateID, ExtendedConnection con) throws DataSourceException {
        TemplateStatus res;
        boolean ownConnection = con == null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        this.lock.readLock().lock();
        try {
            try {
                if (con == null) {
                    con = this.dataSource.getConnection();
                }
                stmt = con.prepareStatement("SELECT xmlBlob FROM Template WHERE idLow=? AND idHigh=?");
                stmt.setLong(1, templateID.getLeastSignificantBits());
                stmt.setLong(2, templateID.getMostSignificantBits());
                rs = stmt.executeQuery();
                if (!rs.next()) {
                    String msg = String.format("TemplateStatus for template with id %s not known!", templateID);
                    this.logger.severe(msg);
                    throw new IllegalArgumentException(msg);
                }
                InputStream stream = rs.getBinaryStream("xmlBlob");
                Document doc = XMLHelperTools.getDocumentFromStream(stream);
                res = this.xmlImport.getTemplateStatusFromDocument(doc);
                rs = JDBCTools.close(rs);
                stmt = JDBCTools.close(stmt);
                if (ownConnection) {
                    con = JDBCTools.close(con);
                }
            }
            catch (SQLException e) {
                throw new DataSourceException("SQLException", e);
            }
            catch (XMLFormatException e) {
                throw new DataSourceException("XMLFormatException", e);
            }
            catch (IOException e) {
                throw new DataSourceException("IOException", e);
            }
        }
        catch (Throwable throwable) {
            if (ownConnection) {
                JDBCTools.closeQuietly(con, (Statement)stmt, rs);
            } else {
                JDBCTools.closeQuietly((Statement)stmt, rs);
            }
            this.lock.readLock().unlock();
            throw throwable;
        }
        if (ownConnection) {
            JDBCTools.closeQuietly(con, (Statement)stmt, rs);
        } else {
            JDBCTools.closeQuietly((Statement)stmt, rs);
        }
        this.lock.readLock().unlock();
        return res;
    }

    @Override
    public Map<UUID, QualifiedAgent> getUpdateLocks() throws DataSourceException {
        ExtendedConnection con = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        HashMap<UUID, QualifiedAgent> res = new HashMap<UUID, QualifiedAgent>();
        this.lock.readLock().lock();
        try {
            try {
                con = this.dataSource.getConnection();
                stmt = con.prepareStatement("SELECT idLow, idHigh, lockingAgentID, lockingAgentName, lockingOrgPosName, lockingOrgPosID FROM Template WHERE lockCount > 0");
                rs = stmt.executeQuery();
                while (rs.next()) {
                    UUID id = new UUID(rs.getLong("idHigh"), rs.getLong("idLow"));
                    QualifiedAgent qa = new QualifiedAgent(rs.getLong("lockingAgentID"), rs.getString("lockingAgentName"), rs.getLong("lockingOrgPosID"), rs.getString("lockingOrgPosName"));
                    res.put(id, qa);
                }
                rs = JDBCTools.close(rs);
                stmt = JDBCTools.close(stmt);
                con = JDBCTools.close(con);
            }
            catch (SQLException e) {
                throw new DataSourceException("SQLException occured", e);
            }
        }
        catch (Throwable throwable) {
            JDBCTools.closeQuietly(con, stmt, rs);
            this.lock.readLock().unlock();
            throw throwable;
        }
        JDBCTools.closeQuietly(con, (Statement)stmt, rs);
        this.lock.readLock().unlock();
        return res;
    }

    @Override
    public int lockTemplateForUpdates(UUID templateID, QualifiedAgent lockingAgent) throws DataSourceException {
        int res;
        ExtendedConnection con = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        this.lock.writeLock().lock();
        try {
            try {
                con = this.dataSource.getConnection();
                stmt = con.prepareStatement("UPDATE Template SET lockCount = lockCount+1,lockingAgentID=?,lockingAgentName=?,lockingOrgPosID=?,lockingOrgPosName=? WHERE idLow=? AND idHigh=? AND (lockCount=0 OR (lockingAgentID=? AND lockingOrgPosID=?))");
                stmt.setLong(1, lockingAgent.getAgentID());
                stmt.setString(2, lockingAgent.getAgentUserName());
                stmt.setLong(3, lockingAgent.getOrgPositionID());
                stmt.setString(4, lockingAgent.getOrgPositionName());
                stmt.setLong(5, templateID.getLeastSignificantBits());
                stmt.setLong(6, templateID.getMostSignificantBits());
                stmt.setLong(7, lockingAgent.getAgentID());
                stmt.setLong(8, lockingAgent.getOrgPositionID());
                stmt.executeUpdate();
                if (stmt.getUpdateCount() == 0) {
                    throw new DataSourceException("Template already locked by someone else.");
                }
                stmt = JDBCTools.close(stmt);
                stmt = con.prepareStatement("SELECT lockCount FROM Template WHERE idLow=? AND idHigh=?");
                stmt.setLong(1, templateID.getLeastSignificantBits());
                stmt.setLong(2, templateID.getMostSignificantBits());
                rs = stmt.executeQuery();
                if (!rs.next()) {
                    throw new DataSourceException("Could not get new LockCount!");
                }
                res = rs.getInt("lockCount");
                rs = JDBCTools.close(rs);
                stmt = JDBCTools.close(stmt);
                con = JDBCTools.close(con);
            }
            catch (SQLException e) {
                throw new DataSourceException("SQLException occured!", e);
            }
        }
        catch (Throwable throwable) {
            JDBCTools.closeQuietly(con, stmt, rs);
            this.lock.writeLock().unlock();
            throw throwable;
        }
        JDBCTools.closeQuietly(con, (Statement)stmt, rs);
        this.lock.writeLock().unlock();
        return res;
    }

    @Override
    public int unlockTemplateForUpdates(UUID templateID) throws DataSourceException {
        int res;
        ExtendedConnection con = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        this.lock.writeLock().lock();
        try {
            try {
                con = this.dataSource.getConnection();
                stmt = con.prepareStatement("UPDATE Template SET lockCount = lockCount-1 WHERE idLow=? AND idHigh=?");
                stmt.setLong(1, templateID.getLeastSignificantBits());
                stmt.setLong(2, templateID.getMostSignificantBits());
                stmt.execute();
                if (stmt.getUpdateCount() == 0) {
                    String msg = String.format("Could not unlock template %s.", templateID);
                    this.logger.severe(msg);
                    throw new DataSourceException(msg);
                }
                JDBCTools.close(stmt);
                stmt = con.prepareStatement("SELECT lockCount FROM Template WHERE idLow=? AND idHigh=?");
                stmt.setLong(1, templateID.getLeastSignificantBits());
                stmt.setLong(2, templateID.getMostSignificantBits());
                rs = stmt.executeQuery();
                if (!rs.next()) {
                    throw new DataSourceException("Could not get LockCount!");
                }
                res = rs.getInt("lockCount");
                if (res == 0) {
                    stmt = JDBCTools.close(stmt);
                    stmt = con.prepareStatement("UPDATE Template SET lockingAgentID=NULL, lockingAgentName=NULL, lockingOrgPosID=NULL, lockingOrgPosName=NULL WHERE idLow=? AND idHigh=? AND lockCount=0");
                    stmt.setLong(1, templateID.getLeastSignificantBits());
                    stmt.setLong(2, templateID.getMostSignificantBits());
                    stmt.execute();
                }
                rs = JDBCTools.close(rs);
                stmt = JDBCTools.close(stmt);
                con = JDBCTools.close(con);
            }
            catch (SQLException e) {
                throw new DataSourceException("SQLException thrown", e);
            }
        }
        catch (Throwable throwable) {
            JDBCTools.closeQuietly(con, stmt, rs);
            this.lock.writeLock().unlock();
            throw throwable;
        }
        JDBCTools.closeQuietly(con, (Statement)stmt, rs);
        this.lock.writeLock().unlock();
        return res;
    }

    @Override
    public void updateEmbeddedTemplateIDs(UUID embeddedID, UUID topLevelParentID) throws DataSourceException {
        ExtendedConnection con = null;
        PreparedStatement stmt = null;
        this.lock.writeLock().lock();
        try {
            try {
                boolean isInDatabase;
                con = this.dataSource.getConnection();
                boolean bl = isInDatabase = this.getParentTemplateID(embeddedID, con) != null;
                if (isInDatabase) {
                    stmt = con.prepareStatement("UPDATE EmbeddedTemplate SET parentTemplateIDLow=?, parentTemplateIDHigh=? WHERE idLow=? AND idHigh=?");
                    stmt.setLong(1, topLevelParentID.getLeastSignificantBits());
                    stmt.setLong(2, topLevelParentID.getMostSignificantBits());
                    stmt.setLong(3, embeddedID.getLeastSignificantBits());
                    stmt.setLong(4, embeddedID.getMostSignificantBits());
                } else {
                    stmt = con.prepareStatement("INSERT INTO EmbeddedTemplate (idLow,idHigh,parentTemplateIDLow,parentTemplateIDHigh) VALUES (?, ?, ?, ?)");
                    stmt.setLong(1, embeddedID.getLeastSignificantBits());
                    stmt.setLong(2, embeddedID.getMostSignificantBits());
                    stmt.setLong(3, topLevelParentID.getLeastSignificantBits());
                    stmt.setLong(4, topLevelParentID.getMostSignificantBits());
                }
                stmt.executeUpdate();
                stmt = JDBCTools.close(stmt);
                con = JDBCTools.close(con);
            }
            catch (SQLException e) {
                throw new DataSourceException("SQLException", e);
            }
        }
        catch (Throwable throwable) {
            JDBCTools.closeQuietly(con, stmt);
            this.lock.writeLock().unlock();
            throw throwable;
        }
        JDBCTools.closeQuietly(con, (Statement)stmt);
        this.lock.writeLock().unlock();
    }

    @Override
    public void updateTemplateStatus(TemplateStatus templateStatus) throws DataSourceException {
        ExtendedConnection con = null;
        PreparedStatement stmt = null;
        this.lock.writeLock().lock();
        try {
            try {
                con = this.dataSource.getConnection();
                UUID id = templateStatus.getTemplateID();
                Template template = this.getTemplate(id, con);
                stmt = con.prepareStatement("UPDATE Template SET xmlBlob=? WHERE idLow=? AND idHigh=?");
                Document doc = this.xmlExport.getDocumentForTemplateAndStatus(template, templateStatus);
                byte[] bytes = XMLHelperTools.getByteArrayForDocument(doc);
                ByteArrayInputStream stream = new ByteArrayInputStream(bytes);
                stmt.setBinaryStream(1, (InputStream)stream, bytes.length);
                stmt.setLong(2, id.getLeastSignificantBits());
                stmt.setLong(3, id.getMostSignificantBits());
                stmt.executeUpdate();
                stmt = JDBCTools.close(stmt);
                con = JDBCTools.close(con);
            }
            catch (SQLException e) {
                throw new DataSourceException("SQLException", e);
            }
            catch (XMLFormatException e) {
                throw new DataSourceException("XMLFormatException", e);
            }
            catch (IOException e) {
                throw new DataSourceException("IOException", e);
            }
        }
        catch (Throwable throwable) {
            JDBCTools.closeQuietly(con, stmt);
            this.lock.writeLock().unlock();
            throw throwable;
        }
        JDBCTools.closeQuietly(con, (Statement)stmt);
        this.lock.writeLock().unlock();
    }

    @Override
    public UUID getBaseTemplateID(UUID templateID) throws DataSourceException {
        ExtendedConnection con = null;
        UUID res = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        this.lock.readLock().lock();
        try {
            try {
                con = this.dataSource.getConnection();
                stmt = con.prepareStatement("SELECT baseIDLow, baseIDHigh FROM BaseTemplateIDs WHERE idLow=? AND idHigh=?");
                stmt.setLong(1, templateID.getLeastSignificantBits());
                stmt.setLong(2, templateID.getMostSignificantBits());
                rs = stmt.executeQuery();
                if (rs.next()) {
                    res = new UUID(rs.getLong("baseIDHigh"), rs.getLong("baseIDLow"));
                }
                rs = JDBCTools.close(rs);
                stmt = JDBCTools.close(stmt);
                con = JDBCTools.close(con);
            }
            catch (SQLException e) {
                throw new DataSourceException("SQLException", e);
            }
        }
        catch (Throwable throwable) {
            JDBCTools.closeQuietly(con, stmt, rs);
            this.lock.readLock().unlock();
            throw throwable;
        }
        JDBCTools.closeQuietly(con, (Statement)stmt, rs);
        this.lock.readLock().unlock();
        return res;
    }

    public void setTemplateStorage(TemplateStorage templateStorage) {
        this.templateStorage = templateStorage;
    }
}

