/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.core.processmanager.storage.sqlstorage.atomic;

import de.aristaflow.adept2.util.LoggerTools;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

public class ComplexSelectGenerator {
    private Logger logger = LoggerTools.getLogger(this);
    private List<Table> tables = new ArrayList<Table>();

    public static WhereStatement[] generateWhereStatementEquals(String[] fields) {
        WhereStatement[] res = new WhereStatement[fields.length];
        int i = 0;
        while (i < fields.length) {
            res[i] = new WhereStatement(fields[i], "=");
            ++i;
        }
        return res;
    }

    public ComplexSelectGenerator(Table table) {
        this.tables.add(table);
        table.setIndexInStatement(0);
    }

    public ComplexSelectGenerator(Table ... tables) {
        this(tables[0]);
        Table[] tab = new Table[tables.length - 1];
        int i = 1;
        while (i < tables.length) {
            tab[i - 1] = tables[i];
            ++i;
        }
        this.addJoinedTables(tab);
    }

    public void addJoinedTables(Table ... tablesToAdd) {
        Table[] tableArray = tablesToAdd;
        int n = tablesToAdd.length;
        int n2 = 0;
        while (n2 < n) {
            Table tab = tableArray[n2];
            if (tab.getJoinStatement() == null) {
                String msg = "Tables have to have JOIN clauses specified!";
                this.logger.severe(msg);
                throw new IllegalArgumentException(msg);
            }
            tab.setIndexInStatement(this.tables.size());
            this.tables.add(tab);
            ++n2;
        }
    }

    private void addWhereStatementString(StringBuilder res, WhereStatement stmt, int srcTable, Map<Integer, String> tableAlias) {
        res.append("(");
        if (stmt.getType() == 3) {
            this.addWhereStatementString(res, stmt.getWhere(), srcTable, tableAlias);
        } else {
            if (stmt.getSourceTable() != null) {
                int srcTableIndex = stmt.getSourceTable().getIndexInStatement();
                res.append(tableAlias.get(srcTableIndex));
            } else {
                res.append(tableAlias.get(srcTable));
            }
            res.append(".");
            res.append(stmt.getSourceField());
            res.append(stmt.getComparator());
            if (stmt.getType() == 2) {
                res.append("?");
            } else if (stmt.getType() == 1) {
                int destTableIndex = stmt.getDestinationTable().getIndexInStatement();
                res.append(tableAlias.get(destTableIndex));
                res.append(".");
                res.append(stmt.getDestinationField());
            }
        }
        if (stmt.getOredWith() != null) {
            res.append(" OR ");
            this.addWhereStatementString(res, stmt.getOredWith(), srcTable, tableAlias);
        } else if (stmt.getAndedWith() != null) {
            res.append(" AND ");
            this.addWhereStatementString(res, stmt.getAndedWith(), srcTable, tableAlias);
        }
        res.append(")");
    }

    public String toString() {
        if (this.tables.size() == 0) {
            String msg = "No tables specified we could SELECT from!";
            this.logger.severe(msg);
            throw new RuntimeException(msg);
        }
        StringBuilder res = new StringBuilder();
        res.append("SELECT ");
        HashMap<Integer, String> tableAlias = new HashMap<Integer, String>();
        boolean first = true;
        int i = 0;
        while (i < this.tables.size()) {
            tableAlias.put(i, "t" + i);
            for (String field : this.tables.get(i).getFields()) {
                if (!first) {
                    res.append(", ");
                }
                first = false;
                res.append((String)tableAlias.get(i));
                res.append(".");
                res.append(field);
            }
            ++i;
        }
        Table table = this.tables.get(0);
        res.append(" FROM ");
        res.append(table.getTableName());
        res.append(" ");
        res.append((String)tableAlias.get(0));
        int tableNumber = 1;
        while (tableNumber < this.tables.size()) {
            table = this.tables.get(tableNumber);
            res.append(" ");
            res.append(table.getJoinStatement());
            res.append(" ");
            res.append(table.getTableName());
            res.append(" ");
            res.append((String)tableAlias.get(tableNumber));
            if (table.getWhereStatements().size() > 0) {
                res.append(" ON ");
                int whereStatementNumber = 0;
                while (whereStatementNumber < table.getWhereStatements().size()) {
                    if (whereStatementNumber > 0) {
                        res.append(" AND ");
                    }
                    WhereStatement stmt = table.getWhereStatements().get(whereStatementNumber);
                    this.addWhereStatementString(res, stmt, tableNumber, tableAlias);
                    ++whereStatementNumber;
                }
            }
            ++tableNumber;
        }
        table = this.tables.get(0);
        if (table.getWhereStatements().size() > 0) {
            res.append(" WHERE ");
            int whereStatementNumber = 0;
            while (whereStatementNumber < table.getWhereStatements().size()) {
                if (whereStatementNumber > 0) {
                    res.append(" AND ");
                }
                WhereStatement stmt = table.getWhereStatements().get(whereStatementNumber);
                this.addWhereStatementString(res, stmt, 0, tableAlias);
                ++whereStatementNumber;
            }
        }
        return res.toString();
    }

    public static class Table {
        private String tableName;
        private String joinStatement = null;
        private List<WhereStatement> whereStatements;
        private List<String> fields;
        private int indexInStatement;

        public Table(String tableName, String[] fields) {
            this.tableName = tableName;
            this.whereStatements = new ArrayList<WhereStatement>();
            this.fields = new ArrayList<String>();
            String[] stringArray = fields;
            int n = fields.length;
            int n2 = 0;
            while (n2 < n) {
                String field = stringArray[n2];
                this.fields.add(field);
                ++n2;
            }
        }

        public Table(String tableName, String[] fields, WhereStatement ... where) {
            this(tableName, fields);
            this.addWhereStatements(where);
        }

        public Table(String joinStatement, String tableName, String[] fields, WhereStatement ... where) {
            this(tableName, fields, where);
            this.joinStatement = joinStatement;
        }

        public void addWhereStatements(WhereStatement ... where) {
            WhereStatement[] whereStatementArray = where;
            int n = where.length;
            int n2 = 0;
            while (n2 < n) {
                WhereStatement stmt = whereStatementArray[n2];
                this.whereStatements.add(stmt);
                ++n2;
            }
        }

        public String getTableName() {
            return this.tableName;
        }

        public String getJoinStatement() {
            return this.joinStatement;
        }

        public List<WhereStatement> getWhereStatements() {
            return this.whereStatements;
        }

        public List<String> getFields() {
            return this.fields;
        }

        public int getIndexInStatement() {
            return this.indexInStatement;
        }

        void setIndexInStatement(int indexInStatement) {
            this.indexInStatement = indexInStatement;
        }
    }

    public static class WhereStatement {
        private Table sourceTable;
        private String sourceField;
        private String comparator;
        private Table destinationTable = null;
        private String destinationField = null;
        private WhereStatement where = null;
        private WhereStatement oredWith = null;
        private WhereStatement andedWith = null;
        private static final int TYPE_TABLE = 1;
        private static final int TYPE_ATOMIC = 2;
        private static final int TYPE_WHERE = 3;
        private final int type;

        public WhereStatement(Table sourceTable, String sourceField, String comparator, Table destinationTable, String destinationField) {
            this.sourceTable = sourceTable;
            this.sourceField = sourceField;
            this.comparator = comparator;
            this.destinationTable = destinationTable;
            this.destinationField = destinationField;
            this.type = 1;
        }

        public WhereStatement(String sourceField, String comparator, Table destinationTable, String destinationField) {
            this.sourceTable = null;
            this.sourceField = sourceField;
            this.comparator = comparator;
            this.destinationTable = destinationTable;
            this.destinationField = destinationField;
            this.type = 1;
        }

        public WhereStatement(Table sourceTable, String sourceField, String comparator) {
            this.sourceTable = sourceTable;
            this.sourceField = sourceField;
            this.comparator = comparator;
            this.type = 2;
        }

        public WhereStatement(String sourceField, String comparator) {
            this.sourceTable = null;
            this.sourceField = sourceField;
            this.comparator = comparator;
            this.type = 2;
        }

        public WhereStatement(WhereStatement reference) {
            this.where = reference;
            this.type = 3;
        }

        public void orWith(WhereStatement stmt) {
            this.oredWith = stmt;
        }

        public void andWith(WhereStatement stmt) {
            this.andedWith = stmt;
        }

        public Table getSourceTable() {
            return this.sourceTable;
        }

        public String getSourceField() {
            return this.sourceField;
        }

        public String getComparator() {
            return this.comparator;
        }

        public Table getDestinationTable() {
            return this.destinationTable;
        }

        public String getDestinationField() {
            return this.destinationField;
        }

        public WhereStatement getOredWith() {
            return this.oredWith;
        }

        public int getType() {
            return this.type;
        }

        public WhereStatement getAndedWith() {
            return this.andedWith;
        }

        public WhereStatement getWhere() {
            return this.where;
        }
    }
}

