/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.core.processmanager.storage.sqlstorage.atomic;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class SQLHelp {
    public static String getString(ResultSet rs, int index) throws SQLException {
        String res = rs.getString(index);
        if (res == null || rs.wasNull()) {
            res = "";
        }
        return res;
    }

    public static String getString(ResultSet rs, String columnName) throws SQLException {
        String res = rs.getString(columnName);
        if (res == null || rs.wasNull()) {
            res = "";
        }
        return res;
    }

    public static class ParameterList {
        private List<Integer> types;
        private List<Object> values;

        ParameterList(int[] types, Object[] values) {
            if (types.length != values.length) {
                throw new IllegalArgumentException("Length of types and values must be equal!");
            }
            this.types = new ArrayList<Integer>();
            this.values = new ArrayList<Object>();
            int i = 0;
            while (i < types.length) {
                this.types.add(types[i]);
                this.values.add(values[i]);
                ++i;
            }
        }

        void insertParameters(PreparedStatement stmt) throws SQLException {
            int i = 0;
            while (i < this.types.size()) {
                if (this.types.get(i) == 16) {
                    stmt.setBoolean(i + 1, (Boolean)this.values.get(i));
                } else {
                    stmt.setObject(i + 1, this.values.get(i), this.types.get(i));
                }
                ++i;
            }
        }
    }

    public static class SimpleQueryGenerator {
        public static String generateInsert(String table, String[] fields) {
            StringBuilder res = new StringBuilder();
            res.append("INSERT INTO ");
            res.append(table);
            res.append(" (");
            int i = 0;
            while (i < fields.length) {
                if (i > 0) {
                    res.append(", ");
                }
                res.append(fields[i]);
                ++i;
            }
            res.append(" ) VALUES (");
            i = 0;
            while (i < fields.length) {
                if (i > 0) {
                    res.append(", ");
                }
                res.append("?");
                ++i;
            }
            res.append(")");
            return res.toString();
        }

        public static String generateUpdate(String table, String[] fields, String[] WhereFields) {
            StringBuilder res = new StringBuilder();
            res.append("UPDATE ");
            res.append(table);
            res.append(" SET ");
            int i = 0;
            while (i < fields.length) {
                if (i > 0) {
                    res.append(", ");
                }
                res.append(fields[i]);
                res.append("=?");
                ++i;
            }
            if (WhereFields.length > 0) {
                res.append(" WHERE ");
                i = 0;
                while (i < WhereFields.length) {
                    if (i > 0) {
                        res.append(" AND ");
                    }
                    res.append(WhereFields[i]);
                    res.append("=?");
                    ++i;
                }
            }
            return res.toString();
        }

        public static void generateSelect(StringBuilder res, String table, String[] fields, String[] WhereFields) {
            res.append("SELECT ");
            int i = 0;
            while (i < fields.length) {
                if (i > 0) {
                    res.append(", ");
                }
                res.append(fields[i]);
                ++i;
            }
            res.append(" FROM ");
            res.append(table);
            if (WhereFields.length > 0) {
                res.append(" WHERE ");
                i = 0;
                while (i < WhereFields.length) {
                    if (i > 0) {
                        res.append(" AND ");
                    }
                    res.append(WhereFields[i]);
                    res.append("=?");
                    ++i;
                }
            }
        }

        public static String generateSelect(String table, String[] fields, String[] WhereFields) {
            StringBuilder res = new StringBuilder(128);
            SimpleQueryGenerator.generateSelect(res, table, fields, WhereFields);
            return res.toString();
        }

        public static String generateSelectWithWhereExtension(String table, String[] fields, String[] WhereFields, String customWhere) {
            StringBuilder res = new StringBuilder(128);
            SimpleQueryGenerator.generateSelect(res, table, fields, WhereFields);
            if (customWhere != null) {
                if (WhereFields.length > 0) {
                    res.append(" AND ");
                } else {
                    res.append(" WHERE ");
                }
                res.append(customWhere);
            }
            return res.toString();
        }

        public static String generateOrderedSelect(String table, String[] fields, String[] WhereFields, String orderBy) {
            StringBuilder res = new StringBuilder();
            SimpleQueryGenerator.generateSelect(res, table, fields, WhereFields);
            res.append(" ORDER BY ");
            res.append(orderBy);
            return res.toString();
        }

        public static String generateOrderedSelect(String table, String[] fields, String[] WhereFields, String[] orderBy) {
            StringBuilder res = new StringBuilder(128);
            SimpleQueryGenerator.generateSelect(res, table, fields, WhereFields);
            if (orderBy.length > 0) {
                res.append(" ORDER BY ");
                String[] stringArray = orderBy;
                int n = orderBy.length;
                int n2 = 0;
                while (n2 < n) {
                    String orderAttr = stringArray[n2];
                    res.append(orderAttr);
                    res.append(", ");
                    ++n2;
                }
                res.delete(res.length() - 2, res.length());
            }
            return res.toString();
        }

        public static String generateOrderedSelectWithWhereExtension(String table, String[] fields, String[] WhereFields, String customWhere, String[] orderBy) {
            StringBuilder res = new StringBuilder(128);
            SimpleQueryGenerator.generateSelect(res, table, fields, WhereFields);
            if (customWhere != null) {
                if (WhereFields.length > 0) {
                    res.append(" AND ");
                } else {
                    res.append(" WHERE ");
                }
                res.append(customWhere);
            }
            if (orderBy.length > 0) {
                res.append(" ORDER BY ");
                String[] stringArray = orderBy;
                int n = orderBy.length;
                int n2 = 0;
                while (n2 < n) {
                    String orderAttr = stringArray[n2];
                    res.append(orderAttr);
                    res.append(", ");
                    ++n2;
                }
                res.delete(res.length() - 2, res.length());
            }
            return res.toString();
        }

        public static String generateDelete(String table, String[] WhereFields) {
            StringBuilder res = new StringBuilder();
            res.append("DELETE FROM ");
            res.append(table);
            if (WhereFields.length > 0) {
                res.append(" WHERE ");
                int i = 0;
                while (i < WhereFields.length) {
                    if (i > 0) {
                        res.append(" AND ");
                    }
                    res.append(WhereFields[i]);
                    res.append("=?");
                    ++i;
                }
            }
            return res.toString();
        }
    }
}

