/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.core.processmanager.storage.sqlstorage.atomic;

import de.aristaflow.adept2.base.dbaccess.ExtendedConnection;
import de.aristaflow.adept2.base.dbaccess.JDBCDataSource;
import de.aristaflow.adept2.base.dbaccess.JDBCTools;
import de.aristaflow.adept2.base.service.LogService;
import de.aristaflow.adept2.base.sessionmanagement.QualifiedAgent;
import de.aristaflow.adept2.core.processmanager.TemplateStatusProvider;
import de.aristaflow.adept2.core.processmanager.storage.TemplateStorage;
import de.aristaflow.adept2.core.processmanager.storage.sqlstorage.atomic.SQLConstants;
import de.aristaflow.adept2.core.processmanager.storage.sqlstorage.atomic.SQLHelp;
import de.aristaflow.adept2.core.processmanager.storage.sqlstorage.atomic.SQLReadConstants;
import de.aristaflow.adept2.model.common.ActivityConfiguration;
import de.aristaflow.adept2.model.common.Configuration;
import de.aristaflow.adept2.model.common.ConfigurationDescription;
import de.aristaflow.adept2.model.common.ExecutionControlProperties;
import de.aristaflow.adept2.model.common.ParameterChangePolicy;
import de.aristaflow.adept2.model.common.PluginData;
import de.aristaflow.adept2.model.common.PluginDataContainer;
import de.aristaflow.adept2.model.execution.Enquiry;
import de.aristaflow.adept2.model.execution.ExecutableInstance;
import de.aristaflow.adept2.model.execution.ExecutionFactory;
import de.aristaflow.adept2.model.globals.ActivityConstants;
import de.aristaflow.adept2.model.globals.EBPType;
import de.aristaflow.adept2.model.globals.ProcessConstants;
import de.aristaflow.adept2.model.processmodel.Activity;
import de.aristaflow.adept2.model.processmodel.DataEdge;
import de.aristaflow.adept2.model.processmodel.DataElement;
import de.aristaflow.adept2.model.processmodel.DecisionStatement;
import de.aristaflow.adept2.model.processmodel.EBPInstanceReference;
import de.aristaflow.adept2.model.processmodel.Edge;
import de.aristaflow.adept2.model.processmodel.ExecutableBusinessProcess;
import de.aristaflow.adept2.model.processmodel.InstanceReference;
import de.aristaflow.adept2.model.processmodel.InstanceStatus;
import de.aristaflow.adept2.model.processmodel.LightWeightProcess;
import de.aristaflow.adept2.model.processmodel.Node;
import de.aristaflow.adept2.model.processmodel.ProcessModelFactory;
import de.aristaflow.adept2.model.processmodel.ProcessModelParameter;
import de.aristaflow.adept2.model.processmodel.StructuredDataEdge;
import de.aristaflow.adept2.model.processmodel.StructuredEdge;
import de.aristaflow.adept2.model.processmodel.Template;
import de.aristaflow.adept2.model.processmodel.TemplateReference;
import de.aristaflow.adept2.model.processmodel.TemplateStatus;
import de.aristaflow.adept2.util.DataSourceException;
import de.aristaflow.adept2.util.LoggerTools;
import de.aristaflow.adept2.util.StringTools;
import de.aristaflow.adept2.util.UUIDTools;
import de.aristaflow.adept2.util.types.Pair;
import java.net.URI;
import java.net.URISyntaxException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.UUID;
import java.util.logging.Logger;

public class SQLHelpRead {
    private static Logger logger = LoggerTools.getLogger(SQLHelpRead.class);
    private static LogService logService;

    public SQLHelpRead(LogService logService) {
        if (logService != null) {
            logger = logService.getLogger();
            SQLHelpRead.logService = logService;
        }
    }

    public static List<DataElement> getDataElements(UUID templateID, JDBCDataSource dataSource, ExtendedConnection con, ProcessModelFactory factory) throws DataSourceException {
        logger.finer("SQLHelpRead.getDataElements() entry");
        ArrayList<DataElement> res = new ArrayList<DataElement>();
        boolean ownConnection = con == null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        PreparedStatement stmtUa = null;
        ResultSet rsUa = null;
        try {
            try {
                if (ownConnection) {
                    con = dataSource.getConnection();
                }
                stmt = con.prepareStatement(SQLReadConstants.SQL_TPL_DATA_ELEMENTS);
                stmt.setLong(1, templateID.getMostSignificantBits());
                stmt.setLong(2, templateID.getLeastSignificantBits());
                rs = stmt.executeQuery();
                stmtUa = con.prepareStatement(SQLReadConstants.SQL_TPL_DATA_ELEMENTS_UA);
                stmtUa.setLong(1, templateID.getMostSignificantBits());
                stmtUa.setLong(2, templateID.getLeastSignificantBits());
                rsUa = stmtUa.executeQuery();
                boolean more = rs.next();
                boolean moreUa = rsUa.next();
                while (more) {
                    int idUa;
                    int id = rs.getInt(SQLConstants.COL_DATAELEMENT_ALL[0]);
                    String name = SQLHelp.getString(rs, SQLConstants.COL_DATAELEMENT_ALL[9]);
                    ProcessConstants.AdeptDataType dataType = ProcessConstants.AdeptDataType.valueOf(rs.getInt(SQLConstants.COL_DATAELEMENT_ALL[3]));
                    String description = SQLHelp.getString(rs, SQLConstants.COL_DATAELEMENT_ALL[4]);
                    String udtName = dataType == ProcessConstants.AdeptDataType.USERDEFINED ? SQLHelp.getString(rs, SQLConstants.COL_DATAELEMENT_ALL[11]) : null;
                    UUID iconID = null;
                    rs.getLong(SQLConstants.COL_DATAELEMENT_ALL[5]);
                    if (!rs.wasNull()) {
                        iconID = new UUID(rs.getLong(SQLConstants.COL_DATAELEMENT_ALL[5]), rs.getLong(SQLConstants.COL_DATAELEMENT_ALL[6]));
                    }
                    UUID identifierID = new UUID(rs.getLong(SQLConstants.COL_DATAELEMENT_ALL[7]), rs.getLong(SQLConstants.COL_DATAELEMENT_ALL[8]));
                    boolean isPublic = rs.getBoolean(SQLConstants.COL_DATAELEMENT_ALL[10]);
                    boolean isVirtual = rs.getBoolean(SQLConstants.COL_DATAELEMENT_ALL[12]);
                    HashMap<String, Set<String>> supportedPlugins = null;
                    HashMap rawPluginData = null;
                    HashMap<String, String> userAttributes = null;
                    if (moreUa && id == (idUa = rsUa.getInt(SQLConstants.COL_DATAELEMENTUSERATTRIBUTES_PARENT_ID[0]))) {
                        userAttributes = new HashMap<String, String>();
                        do {
                            String uaKey = rsUa.getString(SQLConstants.COL_DATAELEMENTUSERATTRIBUTES_ALL[3]);
                            String uaValue = SQLHelp.getString(rsUa, SQLConstants.COL_DATAELEMENTUSERATTRIBUTES_ALL[4]);
                            userAttributes.put(uaKey, uaValue);
                            moreUa = rsUa.next();
                            if (!moreUa) continue;
                            idUa = rsUa.getInt(SQLConstants.COL_DATAELEMENTUSERATTRIBUTES_PARENT_ID[0]);
                        } while (moreUa && id == idUa);
                    }
                    int newID = id;
                    do {
                        String dataKey;
                        if ((dataKey = rs.getString(SQLConstants.COL_DATAELEMENTPLUGINS_ALL[0])) != null) {
                            if (supportedPlugins == null || rawPluginData == null) {
                                supportedPlugins = new HashMap<String, Set<String>>();
                                rawPluginData = new HashMap();
                            }
                            String extensionPointID = SQLHelp.getString(rs, SQLConstants.COL_DATAELEMENTPLUGINS_ALL[3]);
                            String pluginID = SQLHelp.getString(rs, SQLConstants.COL_DATAELEMENTPLUGINS_ALL[2]);
                            if (!supportedPlugins.containsKey(extensionPointID)) {
                                supportedPlugins.put(extensionPointID, new HashSet());
                            }
                            ((Set)supportedPlugins.get(extensionPointID)).add(pluginID);
                            if (!rawPluginData.containsKey(pluginID)) {
                                rawPluginData.put(pluginID, new HashMap());
                            }
                            ((Map)rawPluginData.get(pluginID)).put(dataKey, SQLHelp.getString(rs, SQLConstants.COL_DATAELEMENTPLUGINS_ALL[1]));
                        }
                        if (!(more = rs.next())) continue;
                        newID = rs.getInt(SQLConstants.COL_DATAELEMENT_ALL[0]);
                    } while (more && newID == id);
                    HashMap<String, PluginData> pluginData = null;
                    if (rawPluginData != null) {
                        pluginData = new HashMap<String, PluginData>();
                        for (Map.Entry dat : rawPluginData.entrySet()) {
                            pluginData.put((String)dat.getKey(), factory.createPluginData((String)dat.getKey(), (Map)dat.getValue()));
                        }
                    }
                    res.add(factory.createDataElement(id, name, dataType, description, udtName, iconID, identifierID, isPublic, isVirtual, supportedPlugins, pluginData, userAttributes));
                }
                rsUa = JDBCTools.close(rsUa);
                stmtUa = JDBCTools.close(stmtUa);
                rs = JDBCTools.close(rs);
                stmt = JDBCTools.close(stmt);
                if (ownConnection) {
                    con = JDBCTools.close(con);
                }
            }
            catch (SQLException e) {
                throw new DataSourceException("SQLException", e);
            }
        }
        catch (Throwable throwable) {
            JDBCTools.closeQuietly(stmtUa, rsUa);
            if (ownConnection) {
                JDBCTools.closeQuietly(con, (Statement)stmt, rs);
            } else {
                JDBCTools.closeQuietly((Statement)stmt, rs);
            }
            throw throwable;
        }
        JDBCTools.closeQuietly((Statement)stmtUa, rsUa);
        if (ownConnection) {
            JDBCTools.closeQuietly(con, (Statement)stmt, rs);
        } else {
            JDBCTools.closeQuietly((Statement)stmt, rs);
        }
        logger.finer("SQLHelpRead.getDataElements() exit");
        return res;
    }

    public static Set<StructuredEdge> getStructuredEdges(UUID templateID, JDBCDataSource dataSource, ExtendedConnection con, ProcessModelFactory factory) throws DataSourceException {
        logger.finer("SQLHelpRead.getStructuredEdges() entry");
        HashSet<StructuredEdge> res = new HashSet<StructuredEdge>();
        boolean ownConnection = con == null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            try {
                if (ownConnection) {
                    con = dataSource.getConnection();
                }
                stmt = con.prepareStatement(SQLReadConstants.SQL_TPL_STRUCTURED_EDGES);
                stmt.setLong(1, templateID.getMostSignificantBits());
                stmt.setLong(2, templateID.getLeastSignificantBits());
                rs = stmt.executeQuery();
                boolean more = rs.next();
                while (more) {
                    int startNodeID = rs.getInt(SQLConstants.COL_EDGE_ALL[2]);
                    int endNodeID = rs.getInt(SQLConstants.COL_EDGE_ALL[3]);
                    int edgeCode = rs.getInt(SQLConstants.COL_EDGE_ALL[4]);
                    ProcessConstants.EdgeType edgeType = ProcessConstants.EdgeType.valueOf(rs.getInt(SQLConstants.COL_EDGE_ALL[5]));
                    HashMap<String, String> userAttributes = null;
                    int newStartNodeID = startNodeID;
                    int newEndNodeID = endNodeID;
                    do {
                        String uaKey;
                        if ((uaKey = rs.getString(SQLConstants.COL_EDGEUSERATTRIBUTES_ALL[4])) != null) {
                            if (userAttributes == null) {
                                userAttributes = new HashMap<String, String>();
                            }
                            String uaValue = SQLHelp.getString(rs, SQLConstants.COL_EDGEUSERATTRIBUTES_ALL[5]);
                            userAttributes.put(uaKey, uaValue);
                        }
                        if (!(more = rs.next())) continue;
                        newStartNodeID = rs.getInt(SQLConstants.COL_EDGE_ALL[2]);
                        newEndNodeID = rs.getInt(SQLConstants.COL_EDGE_ALL[3]);
                    } while (more && newStartNodeID == startNodeID && newEndNodeID == endNodeID);
                    Edge edge = factory.createEdge(edgeType, edgeCode, userAttributes);
                    res.add(factory.createStructuredEdge(edge, startNodeID, endNodeID));
                }
                rs = JDBCTools.close(rs);
                stmt = JDBCTools.close(stmt);
                if (ownConnection) {
                    con = JDBCTools.close(con);
                }
            }
            catch (SQLException e) {
                throw new DataSourceException("SQLException", e);
            }
        }
        catch (Throwable throwable) {
            if (ownConnection) {
                JDBCTools.closeQuietly(con, (Statement)stmt, rs);
            } else {
                JDBCTools.closeQuietly((Statement)stmt, rs);
            }
            throw throwable;
        }
        if (ownConnection) {
            JDBCTools.closeQuietly(con, (Statement)stmt, rs);
        } else {
            JDBCTools.closeQuietly((Statement)stmt, rs);
        }
        logger.finer("SQLHelpRead.getStructuredEdges() exit");
        return res;
    }

    public static Set<StructuredDataEdge> getStructuredDataEdges(UUID templateID, Map<Integer, Node> nodeIDNodeMapping, Map<Integer, List<Integer>> disabledConnectors, Map<Integer, Integer> nextConnectorID, JDBCDataSource dataSource, ExtendedConnection con, ProcessModelFactory factory) throws DataSourceException {
        logger.finer("SQLHelpRead.getStructuredDataEdges() entry");
        HashSet<StructuredDataEdge> res = new HashSet<StructuredDataEdge>();
        boolean ownConnection = con == null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            try {
                if (ownConnection) {
                    con = dataSource.getConnection();
                }
                stmt = con.prepareStatement(SQLReadConstants.SQL_TPL_DATA_EDGES);
                stmt.setLong(1, templateID.getMostSignificantBits());
                stmt.setLong(2, templateID.getLeastSignificantBits());
                rs = stmt.executeQuery();
                boolean more = rs.next();
                while (more) {
                    int nodeID = rs.getInt(SQLConstants.COL_DATAEDGE_ALL[2]);
                    int dataElementID = rs.getInt(SQLConstants.COL_DATAEDGE_ALL[3]);
                    ActivityConstants.AccessType accessType = ActivityConstants.AccessType.valueOf(rs.getInt(SQLConstants.COL_DATAEDGE_ALL[4]));
                    boolean isOptional = rs.getBoolean(SQLConstants.COL_DATAEDGE_ALL[6]);
                    boolean connectorDisabled = rs.getBoolean(SQLConstants.COL_DATAEDGE_ALL[5]);
                    String parameterName = rs.getString(SQLConstants.COL_DATAEDGE_ALL[7]);
                    HashMap<String, String> userAttributes = null;
                    int newNodeID = nodeID;
                    int newDataElementID = dataElementID;
                    ActivityConstants.AccessType newAccessType = accessType;
                    do {
                        String uaKey;
                        if ((uaKey = rs.getString(SQLConstants.COL_DATAEDGEUSERATTRIBUTES_ALL[5])) != null) {
                            if (userAttributes == null) {
                                userAttributes = new HashMap<String, String>();
                            }
                            String uaValue = SQLHelp.getString(rs, SQLConstants.COL_DATAEDGEUSERATTRIBUTES_ALL[6]);
                            userAttributes.put(uaKey, uaValue);
                        }
                        if (!(more = rs.next())) continue;
                        newNodeID = rs.getInt(SQLConstants.COL_DATAEDGE_ALL[2]);
                        newDataElementID = rs.getInt(SQLConstants.COL_DATAEDGE_ALL[3]);
                        newAccessType = ActivityConstants.AccessType.valueOf(rs.getInt(SQLConstants.COL_DATAEDGE_ALL[4]));
                    } while (more && newNodeID == nodeID && newDataElementID == dataElementID && newAccessType == accessType);
                    Node node = nodeIDNodeMapping.get(nodeID);
                    int connectorID = parameterName == null ? Integer.MIN_VALUE : node.getConnector(parameterName, accessType);
                    if (connectorID == Integer.MIN_VALUE) {
                        connectorID = nextConnectorID.get(nodeID);
                        nextConnectorID.put(nodeID, connectorID + 1);
                        if (connectorDisabled) {
                            List<Integer> dis = disabledConnectors.get(nodeID);
                            if (dis == null) {
                                dis = new ArrayList<Integer>();
                                disabledConnectors.put(nodeID, dis);
                            }
                            dis.add(connectorID);
                        }
                    } else if (disabledConnectors.containsKey(nodeID) && connectorDisabled != disabledConnectors.get(nodeID).contains(connectorID)) {
                        String msg = String.format("Inconsistent connector mapping of DataEdge (node %s, dataElement %s) and parameter %s of template %s!", nodeID, dataElementID, parameterName, templateID);
                        logger.severe(msg);
                        throw new DataSourceException(msg);
                    }
                    DataEdge dataEdge = factory.createDataEdge(accessType, isOptional, userAttributes);
                    res.add(factory.createStructuredDataEdge(dataEdge, nodeID, connectorID, dataElementID));
                }
                rs = JDBCTools.close(rs);
                stmt = JDBCTools.close(stmt);
                if (ownConnection) {
                    con = JDBCTools.close(con);
                }
            }
            catch (SQLException e) {
                throw new DataSourceException("SQLException", e);
            }
        }
        catch (Throwable throwable) {
            if (ownConnection) {
                JDBCTools.closeQuietly(con, (Statement)stmt, rs);
            } else {
                JDBCTools.closeQuietly((Statement)stmt, rs);
            }
            throw throwable;
        }
        if (ownConnection) {
            JDBCTools.closeQuietly(con, (Statement)stmt, rs);
        } else {
            JDBCTools.closeQuietly((Statement)stmt, rs);
        }
        logger.finer("SQLHelpRead.getStructuredDataEdges() exit");
        return res;
    }

    public static Activity getActivity(UUID templateID, int nodeID, Map<ActivityConstants.AccessType, Set<ProcessModelParameter>> parameters, PluginDataContainer pluginData, ExecutionControlProperties ecp, Map<String, String> userAttributes, JDBCDataSource dataSource, ExtendedConnection con, ProcessModelFactory factory) throws DataSourceException {
        Activity res;
        logger.finer("SQLHelpRead.getActivity() entry");
        boolean ownConnection = con == null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            try {
                if (ownConnection) {
                    con = dataSource.getConnection();
                }
                HashMap<String, String> confValues = new HashMap<String, String>();
                HashMap<String, String> confFromParameter = new HashMap<String, String>();
                HashMap<String, String> confFromConf = new HashMap<String, String>();
                HashMap<String, String> testConfValues = new HashMap<String, String>();
                HashMap<String, String> testConfFromParameter = new HashMap<String, String>();
                HashMap<String, String> testConfFromConf = new HashMap<String, String>();
                HashSet<String> confFixed = new HashSet<String>();
                HashSet<String> testConfFixed = new HashSet<String>();
                stmt = con.prepareStatement(SQLReadConstants.SQL_TPL_EBP_CONFIGURATION);
                stmt.setInt(1, nodeID);
                stmt.setLong(2, templateID.getMostSignificantBits());
                stmt.setLong(3, templateID.getLeastSignificantBits());
                rs = stmt.executeQuery();
                while (rs.next()) {
                    int type = rs.getInt(4);
                    switch (type) {
                        case 1: {
                            confValues.put(SQLHelp.getString(rs, 5), SQLHelp.getString(rs, 6));
                            break;
                        }
                        case 3: {
                            confFromConf.put(SQLHelp.getString(rs, 5), SQLHelp.getString(rs, 6));
                            break;
                        }
                        case 2: {
                            confFromParameter.put(SQLHelp.getString(rs, 5), SQLHelp.getString(rs, 6));
                            break;
                        }
                        case 4: {
                            testConfValues.put(SQLHelp.getString(rs, 5), SQLHelp.getString(rs, 6));
                            break;
                        }
                        case 6: {
                            testConfFromConf.put(SQLHelp.getString(rs, 5), SQLHelp.getString(rs, 6));
                            break;
                        }
                        case 5: {
                            testConfFromParameter.put(SQLHelp.getString(rs, 5), SQLHelp.getString(rs, 6));
                            break;
                        }
                        default: {
                            String msg = String.format("Unexpected configuration type '%d' found!", type);
                            logger.info(msg);
                        }
                    }
                    if (!rs.getBoolean(7)) continue;
                    if (type == 3 || type == 2 || type == 1) {
                        confFixed.add(SQLHelp.getString(rs, 5));
                        continue;
                    }
                    testConfFixed.add(SQLHelp.getString(rs, 5));
                }
                rs = JDBCTools.close(rs);
                stmt = JDBCTools.close(stmt);
                ActivityConfiguration configuration = factory.createActivityConfiguration(confValues, confFromParameter, confFromConf, confFixed);
                ActivityConfiguration testConfiguration = factory.createActivityConfiguration(testConfValues, testConfFromParameter, testConfFromConf, testConfFixed);
                HashMap classPathTemp = new HashMap();
                stmt = con.prepareStatement(SQLReadConstants.SQL_TPL_ACTIVITY_CLASSPATH);
                stmt.setInt(1, nodeID);
                stmt.setLong(2, templateID.getMostSignificantBits());
                stmt.setLong(3, templateID.getLeastSignificantBits());
                rs = stmt.executeQuery();
                while (rs.next()) {
                    ActivityConstants.ActivityModelEntityType amet = ActivityConstants.ActivityModelEntityType.valueOf((byte)rs.getInt(5));
                    if (!classPathTemp.containsKey((Object)amet)) {
                        classPathTemp.put(amet, new TreeMap());
                    }
                    ((SortedMap)classPathTemp.get((Object)amet)).put(rs.getInt(6), SQLHelp.getString(rs, 4));
                }
                rs = JDBCTools.close(rs);
                stmt = JDBCTools.close(stmt);
                HashMap<ActivityConstants.ActivityModelEntityType, List<String>> separatedClassPath = new HashMap<ActivityConstants.ActivityModelEntityType, List<String>>();
                ActivityConstants.ActivityModelEntityType[] activityModelEntityTypeArray = ActivityConstants.ActivityModelEntityType.values();
                int n = activityModelEntityTypeArray.length;
                int n2 = 0;
                while (n2 < n) {
                    ActivityConstants.ActivityModelEntityType amet = activityModelEntityTypeArray[n2];
                    separatedClassPath.put(amet, new ArrayList());
                    ++n2;
                }
                for (Map.Entry entry : classPathTemp.entrySet()) {
                    for (Map.Entry entry2 : ((SortedMap)entry.getValue()).entrySet()) {
                        ((List)separatedClassPath.get(entry.getKey())).add((String)entry2.getValue());
                    }
                }
                HashMap<ActivityConstants.LocallyOverrideableActivityAttribute, ActivityConstants.ActivityModelEntityType> attributeOrigins = new HashMap<ActivityConstants.LocallyOverrideableActivityAttribute, ActivityConstants.ActivityModelEntityType>();
                stmt = con.prepareStatement(SQLReadConstants.SQL_TPL_ACTIVITY_ATTRIBUTE_ORIGINS);
                stmt.setInt(1, nodeID);
                stmt.setLong(2, templateID.getMostSignificantBits());
                stmt.setLong(3, templateID.getLeastSignificantBits());
                rs = stmt.executeQuery();
                while (rs.next()) {
                    attributeOrigins.put(ActivityConstants.LocallyOverrideableActivityAttribute.valueOf((byte)rs.getInt(4)), ActivityConstants.ActivityModelEntityType.valueOf((byte)rs.getInt(5)));
                }
                rs = JDBCTools.close(rs);
                stmt = JDBCTools.close(stmt);
                stmt = con.prepareStatement(SQLReadConstants.SQL_TPL_ACTIVITY);
                stmt.setInt(1, nodeID);
                stmt.setLong(2, templateID.getMostSignificantBits());
                stmt.setLong(3, templateID.getLeastSignificantBits());
                rs = stmt.executeQuery();
                if (!rs.next()) {
                    String msg = String.format("Could not find Activity-EBP of node %s of template %s.", nodeID, templateID);
                    logger.severe(msg);
                    throw new DataSourceException(msg);
                }
                UUID iconID = null;
                rs.getLong(11);
                if (!rs.wasNull()) {
                    iconID = new UUID(rs.getLong(11), rs.getLong(12));
                }
                res = factory.createActivity(new UUID(rs.getLong(4), rs.getLong(5)), SQLHelp.getString(rs, 9), SQLHelp.getString(rs, 16), rs.getString(7), SQLHelp.getString(rs, 6), SQLHelp.getString(rs, 8), SQLHelp.getString(rs, 13), separatedClassPath, rs.getBoolean(15), rs.getBytes(20), SQLHelp.getString(rs, 10), ecp, rs.getBoolean(19), rs.getBoolean(18), iconID, attributeOrigins, configuration, testConfiguration, ParameterChangePolicy.valueOf(rs.getByte(17)), parameters.get((Object)ActivityConstants.AccessType.READ), parameters.get((Object)ActivityConstants.AccessType.WRITE), pluginData, userAttributes);
                if (rs.getBoolean(14)) {
                    rs = JDBCTools.close(rs);
                    stmt = JDBCTools.close(stmt);
                    stmt = con.prepareStatement(SQLReadConstants.SQL_TPL_FIND_DECISION_PARAMETER);
                    stmt.setInt(1, nodeID);
                    stmt.setLong(2, templateID.getMostSignificantBits());
                    stmt.setLong(3, templateID.getLeastSignificantBits());
                    stmt.setBoolean(4, true);
                    rs = stmt.executeQuery();
                    if (!rs.next()) {
                        String string = String.format("Could not find decision parameter of decision activity on node %s in template %s.", nodeID, templateID);
                        logger.severe(string);
                        throw new DataSourceException(string);
                    }
                    ActivityConstants.AccessType accessType = ActivityConstants.AccessType.valueOf(rs.getInt(1));
                    if (accessType != ActivityConstants.AccessType.WRITE) {
                        String msg = String.format("The decision parameter of the decision activity of node %s of template %s is no output parameter!", nodeID, templateID);
                        logger.severe(msg);
                        throw new DataSourceException(msg);
                    }
                    String decisionParameterName = SQLHelp.getString(rs, 2);
                    rs = JDBCTools.close(rs);
                    stmt = JDBCTools.close(stmt);
                    ProcessModelParameter decisionParameter = null;
                    for (ProcessModelParameter param : parameters.get((Object)ActivityConstants.AccessType.WRITE)) {
                        if (!param.getName().equals(decisionParameterName)) continue;
                        decisionParameter = param;
                        break;
                    }
                    if (decisionParameter == null) {
                        String msg = String.format("Could not find instance of decision parameter of node %s of template %s !", nodeID, templateID);
                        logger.severe(msg);
                        throw new DataSourceException(msg);
                    }
                    HashMap<Long, Collection<DecisionStatement>> decisionMapping = new HashMap<Long, Collection<DecisionStatement>>();
                    stmt = con.prepareStatement(SQLReadConstants.SQL_TPL_DECISION_ACTIVITY_STATEMENT);
                    stmt.setInt(1, nodeID);
                    stmt.setLong(2, templateID.getMostSignificantBits());
                    stmt.setLong(3, templateID.getLeastSignificantBits());
                    rs = stmt.executeQuery();
                    while (rs.next()) {
                        long edgeCode = rs.getLong(7);
                        if (!decisionMapping.containsKey(edgeCode)) {
                            decisionMapping.put(edgeCode, new ArrayList());
                        }
                        DecisionStatement stat = factory.createDecisionStatement(SQLHelp.getString(rs, 5), SQLHelp.getString(rs, 6), rs.getLong(4));
                        ((Collection)decisionMapping.get(edgeCode)).add(stat);
                    }
                    res = factory.createDecisionActivity(res, decisionParameter, decisionMapping);
                }
                rs = JDBCTools.close(rs);
                stmt = JDBCTools.close(stmt);
                if (ownConnection) {
                    con = JDBCTools.close(con);
                }
            }
            catch (SQLException e) {
                throw new DataSourceException("SQLException", e);
            }
        }
        catch (Throwable throwable) {
            if (ownConnection) {
                JDBCTools.closeQuietly(con, stmt, rs);
            } else {
                JDBCTools.closeQuietly(stmt, rs);
            }
            throw throwable;
        }
        if (ownConnection) {
            JDBCTools.closeQuietly(con, (Statement)stmt, rs);
        } else {
            JDBCTools.closeQuietly((Statement)stmt, rs);
        }
        logger.finer("SQLHelpRead.getActivity() exit");
        return res;
    }

    public static ExecutableBusinessProcess getSubprocess(UUID topLevelTemplateID, UUID templateID, int nodeID, Map<ActivityConstants.AccessType, Set<ProcessModelParameter>> parameters, PluginDataContainer pluginData, ExecutionControlProperties ecp, Map<String, String> userAttributes, JDBCDataSource dataSource, ExtendedConnection con, ProcessModelFactory factory) throws DataSourceException {
        ExecutableBusinessProcess res;
        logger.finer("SQLHelpRead.getSubprocess() entry");
        boolean ownConnection = con == null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        PreparedStatement stmtUA = null;
        ResultSet rsUA = null;
        try {
            try {
                if (ownConnection) {
                    con = dataSource.getConnection();
                }
                HashMap<String, String> confValues = new HashMap<String, String>();
                HashSet<String> confFixed = new HashSet<String>();
                HashMap<String, String> testConfValues = new HashMap<String, String>();
                HashSet<String> testConfFixed = new HashSet<String>();
                stmt = con.prepareStatement(SQLReadConstants.SQL_TPL_EBP_CONFIGURATION);
                stmt.setInt(1, nodeID);
                stmt.setLong(2, templateID.getMostSignificantBits());
                stmt.setLong(3, templateID.getLeastSignificantBits());
                rs = stmt.executeQuery();
                while (rs.next()) {
                    int type = rs.getInt(4);
                    if (type == 1) {
                        confValues.put(SQLHelp.getString(rs, 5), SQLHelp.getString(rs, 6));
                        if (!rs.getBoolean(7)) continue;
                        confFixed.add(SQLHelp.getString(rs, 5));
                        continue;
                    }
                    if (type != 4) continue;
                    testConfValues.put(SQLHelp.getString(rs, 5), SQLHelp.getString(rs, 6));
                    if (!rs.getBoolean(7)) continue;
                    testConfFixed.add(SQLHelp.getString(rs, 5));
                }
                rs = JDBCTools.close(rs);
                stmt = JDBCTools.close(stmt);
                Configuration configuration = factory.createConfiguration(confValues, confFixed);
                Configuration testConfiguration = factory.createConfiguration(testConfValues, testConfFixed);
                stmt = con.prepareStatement(SQLReadConstants.SQL_TPL_SUBPROCESS);
                stmt.setInt(1, nodeID);
                stmt.setLong(2, templateID.getMostSignificantBits());
                stmt.setLong(3, templateID.getLeastSignificantBits());
                rs = stmt.executeQuery();
                if (!rs.next()) {
                    String msg = String.format("Could not find Subprocess-EBP of node %s of template %s.", nodeID, templateID);
                    logger.severe(msg);
                    throw new DataSourceException(msg);
                }
                boolean isVarPar = rs.getBoolean(6);
                UUID referencedID = new UUID(rs.getLong(4), rs.getLong(5));
                int type = rs.getInt(7);
                rs = JDBCTools.close(rs);
                stmt = JDBCTools.close(stmt);
                Map<String, String> lwpUserAttributes = userAttributes;
                PluginDataContainer lwpPluginDataContainer = pluginData;
                if (isVarPar) {
                    lwpUserAttributes = new HashMap<String, String>();
                    stmtUA = con.prepareStatement(SQLReadConstants.SQL_TPL_EBP_UAS);
                    stmtUA.setInt(1, nodeID);
                    stmtUA.setLong(2, templateID.getMostSignificantBits());
                    stmtUA.setLong(3, templateID.getLeastSignificantBits());
                    stmtUA.setBoolean(4, true);
                    rsUA = stmtUA.executeQuery();
                    while (rsUA.next()) {
                        lwpUserAttributes.put(SQLHelp.getString(rsUA, 5), SQLHelp.getString(rsUA, 6));
                    }
                    rsUA = JDBCTools.close(rsUA);
                    stmtUA = JDBCTools.close(stmtUA);
                    HashMap<String, Set<String>> lwpSupportedPlugins = new HashMap<String, Set<String>>();
                    HashMap lwpPluginData = new HashMap();
                    stmt = con.prepareStatement(SQLReadConstants.SQL_TPL_EBP_PLUGINS);
                    stmt.setInt(1, nodeID);
                    stmt.setLong(2, templateID.getMostSignificantBits());
                    stmt.setLong(3, templateID.getLeastSignificantBits());
                    stmt.setBoolean(4, true);
                    rs = stmt.executeQuery();
                    while (rs.next()) {
                        String extensionPointID = SQLHelp.getString(rs, 5);
                        String pluginID = SQLHelp.getString(rs, 4);
                        if (!lwpSupportedPlugins.containsKey(extensionPointID)) {
                            lwpSupportedPlugins.put(extensionPointID, new HashSet());
                        }
                        ((Set)lwpSupportedPlugins.get(extensionPointID)).add(pluginID);
                        if (!lwpPluginData.containsKey(pluginID)) {
                            lwpPluginData.put(pluginID, new HashMap());
                        }
                        ((Map)lwpPluginData.get(pluginID)).put(SQLHelp.getString(rs, 6), SQLHelp.getString(rs, 7));
                    }
                    rs = JDBCTools.close(rs);
                    stmt = JDBCTools.close(stmt);
                    HashMap<String, PluginData> lwpRealPluginData = new HashMap<String, PluginData>();
                    for (Map.Entry pdEntry : lwpPluginData.entrySet()) {
                        lwpRealPluginData.put((String)pdEntry.getKey(), factory.createPluginData((String)pdEntry.getKey(), (Map)pdEntry.getValue()));
                    }
                    lwpPluginDataContainer = factory.createPluginDataContainer(lwpSupportedPlugins, lwpRealPluginData);
                }
                if (type == 3) {
                    Template embedded = SQLHelpRead.getTemplate(topLevelTemplateID, referencedID, true, dataSource, con, factory);
                    res = factory.createEmbeddedProcess(embedded, topLevelTemplateID, referencedID, configuration, testConfiguration, ecp, lwpPluginDataContainer, lwpUserAttributes);
                } else {
                    res = factory.createReferencedProcess(referencedID, type == 2, configuration, testConfiguration, ecp, parameters.get((Object)ActivityConstants.AccessType.READ), parameters.get((Object)ActivityConstants.AccessType.WRITE), lwpPluginDataContainer, lwpUserAttributes);
                }
                if (isVarPar) {
                    HashSet<ProcessModelParameter> varParInputParams = new HashSet<ProcessModelParameter>();
                    HashSet<ProcessModelParameter> indexedInputParams = new HashSet<ProcessModelParameter>();
                    HashSet<ProcessModelParameter> varParOutputParams = new HashSet<ProcessModelParameter>();
                    HashMap<ActivityConstants.AccessType, Map<ProcessModelParameter, Boolean>> indexedParameters = new HashMap<ActivityConstants.AccessType, Map<ProcessModelParameter, Boolean>>();
                    indexedParameters.put(ActivityConstants.AccessType.READ, new HashMap());
                    indexedParameters.put(ActivityConstants.AccessType.WRITE, new HashMap());
                    SQLHelpRead.getParameters(templateID, nodeID, null, indexedParameters, dataSource, con, factory);
                    for (Map.Entry paramsEntry : indexedParameters.entrySet()) {
                        ActivityConstants.AccessType accessType = (ActivityConstants.AccessType)((Object)paramsEntry.getKey());
                        for (Map.Entry paramEntry : ((Map)paramsEntry.getValue()).entrySet()) {
                            ProcessModelParameter param = (ProcessModelParameter)paramEntry.getKey();
                            if (accessType == ActivityConstants.AccessType.READ) {
                                varParInputParams.add(param);
                                indexedInputParams.add(param);
                                continue;
                            }
                            varParOutputParams.add(param);
                        }
                    }
                    HashSet<String> namesOfVarParInputParameters = new HashSet<String>();
                    for (ProcessModelParameter param : varParInputParams) {
                        namesOfVarParInputParameters.add(param.getName());
                    }
                    for (ProcessModelParameter param : parameters.get((Object)ActivityConstants.AccessType.READ)) {
                        if (namesOfVarParInputParameters.contains(param.getName())) continue;
                        varParInputParams.add(param);
                    }
                    res = factory.createVariableParallelismEBP((LightWeightProcess)res, (Set<ProcessModelParameter>)indexedInputParams, configuration, testConfiguration, ecp, (Set<ProcessModelParameter>)varParInputParams, (Set<ProcessModelParameter>)varParOutputParams, pluginData, userAttributes);
                }
                if (ownConnection) {
                    con = JDBCTools.close(con);
                }
            }
            catch (SQLException e) {
                throw new DataSourceException("SQLException", e);
            }
        }
        catch (Throwable throwable) {
            JDBCTools.closeQuietly(stmtUA, rsUA);
            if (ownConnection) {
                JDBCTools.closeQuietly(con, stmt, rs);
            } else {
                JDBCTools.closeQuietly(stmt, rs);
            }
            throw throwable;
        }
        JDBCTools.closeQuietly((Statement)stmtUA, rsUA);
        if (ownConnection) {
            JDBCTools.closeQuietly(con, (Statement)stmt, rs);
        } else {
            JDBCTools.closeQuietly((Statement)stmt, rs);
        }
        logger.finer("SQLHelpRead.getSubprocess() exit");
        return res;
    }

    public static List<String> findTemplatesReferencing(UUID ownID, boolean topRefs, boolean subRefs, boolean respectOutdated, JDBCDataSource dataSource, ExtendedConnection con) throws DataSourceException {
        logger.finer("SQLHelpRead.findTemplatesReferencing() entry");
        LinkedList<String> res = new LinkedList<String>();
        boolean ownConnection = con == null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            try {
                String type;
                if (ownConnection) {
                    con = dataSource.getConnection();
                }
                StringBuilder sb = new StringBuilder();
                sb.append("SELECT t.IDHIGH, t.IDLOW, t.NAME, t.VERSION FROM ");
                sb.append("PMSubProcess");
                sb.append(" s JOIN ");
                sb.append("PMTemplate");
                sb.append(" t ON s.TEMPLATEIDHIGH = t.IDHIGH AND s.TEMPLATEIDLOW = t.IDLOW ");
                if (respectOutdated) {
                    sb.append("LEFT OUTER JOIN ");
                    sb.append("PMTemplateStatus");
                    sb.append(" st ON st.TEMPLATEIDHIGH = t.IDHIGH AND st.TEMPLATEIDLOW = t.IDLOW ");
                    sb.append("WHERE s.REFERENCEDTEMPLATEIDHIGH = ? AND s.REFERENCEDTEMPLATEIDLOW = ? ");
                    sb.append("AND (st.TLOUTDATED = ? OR st.SPOUTDATED = ? OR st.TLOUTDATED IS NULL OR st.SPOUTDATED IS NULL)");
                } else {
                    sb.append("WHERE s.REFERENCEDTEMPLATEIDHIGH = ? AND s.REFERENCEDTEMPLATEIDLOW = ?");
                }
                if (topRefs && subRefs) {
                    type = " AND (s.TYPE = %d OR s.TYPE = %d OR s.TYPE = %d)";
                    type = String.format(type, 1, 2, 3);
                    sb.append(type);
                } else if (topRefs && !subRefs) {
                    type = " AND s.TYPE = %d";
                    type = String.format(type, 2);
                    sb.append(type);
                } else if (!topRefs && subRefs) {
                    type = " AND (s.TYPE = %d OR s.TYPE = %d)";
                    type = String.format(type, 1, 3);
                    sb.append(type);
                }
                stmt = con.prepareStatement(sb.toString());
                stmt.setLong(1, ownID.getMostSignificantBits());
                stmt.setLong(2, ownID.getLeastSignificantBits());
                if (respectOutdated) {
                    stmt.setBoolean(3, false);
                    stmt.setBoolean(4, false);
                }
                rs = stmt.executeQuery();
                while (rs.next()) {
                    UUID id = new UUID(rs.getLong("IDHIGH"), rs.getLong("IDLOW"));
                    String name = rs.getString("NAME");
                    String version = rs.getString("VERSION");
                    StringBuilder msg = new StringBuilder();
                    msg.append("- ");
                    msg.append(name);
                    msg.append(" v");
                    if (version != null && version.length() > 0) {
                        msg.append(version);
                    } else {
                        msg.append("0");
                    }
                    msg.append(" [");
                    msg.append(id);
                    msg.append("]");
                    if (UUIDTools.isNegative(id)) {
                        msg.append(" (embedded/modified)");
                    }
                    res.add(msg.toString());
                }
                rs = JDBCTools.close(rs);
                stmt = JDBCTools.close(stmt);
                if (ownConnection) {
                    con = JDBCTools.close(con);
                }
            }
            catch (SQLException e) {
                throw new DataSourceException("SQLException", e);
            }
        }
        catch (Throwable throwable) {
            if (ownConnection) {
                JDBCTools.closeQuietly(con, stmt, rs);
            } else {
                JDBCTools.closeQuietly(stmt, rs);
            }
            throw throwable;
        }
        if (ownConnection) {
            JDBCTools.closeQuietly(con, (Statement)stmt, rs);
        } else {
            JDBCTools.closeQuietly((Statement)stmt, rs);
        }
        logger.finer("SQLHelpRead.findTemplateReferencing() exit");
        return res;
    }

    public static UUID getParentTemplateID(UUID embeddedID, JDBCDataSource dataSource, ExtendedConnection con) throws DataSourceException {
        UUID res;
        logger.finer("SQLHelpRead.getParentTemplateID() entry");
        boolean ownConnection = con == null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            try {
                if (ownConnection) {
                    con = dataSource.getConnection();
                }
                boolean foundAParent = true;
                res = embeddedID;
                while (foundAParent) {
                    stmt = con.prepareStatement(SQLReadConstants.SQL_TPL_PARENT_TEMPLATE_ID);
                    stmt.setLong(1, res.getMostSignificantBits());
                    stmt.setLong(2, res.getLeastSignificantBits());
                    stmt.setInt(3, 3);
                    rs = stmt.executeQuery();
                    if (rs.next()) {
                        res = new UUID(rs.getLong(2), rs.getLong(3));
                        foundAParent = true;
                    } else {
                        foundAParent = false;
                        if (res.equals(embeddedID)) {
                            res = null;
                        }
                    }
                    rs = JDBCTools.close(rs);
                    stmt = JDBCTools.close(stmt);
                }
                if (ownConnection) {
                    con = JDBCTools.close(con);
                }
            }
            catch (SQLException e) {
                throw new DataSourceException("SQLException", e);
            }
        }
        catch (Throwable throwable) {
            if (ownConnection) {
                JDBCTools.closeQuietly(con, stmt, rs);
            } else {
                JDBCTools.closeQuietly(stmt, rs);
            }
            throw throwable;
        }
        if (ownConnection) {
            JDBCTools.closeQuietly(con, (Statement)stmt, rs);
        } else {
            JDBCTools.closeQuietly((Statement)stmt, rs);
        }
        logger.finer("SQLHelpRead.getParentTemplateID() exit");
        return res;
    }

    public static ExecutableBusinessProcess getEBP(UUID topLevelTemplateID, UUID templateID, int nodeID, List<Pair<ActivityConstants.AccessType, ProcessModelParameter>> connectorMapping, List<Integer> disabledConnectors, JDBCDataSource dataSource, ExtendedConnection con, ProcessModelFactory factory) throws DataSourceException {
        logger.finer("SQLHelpRead.getEBP() entry");
        ExecutableBusinessProcess res = null;
        boolean ownConnection = con == null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            try {
                if (ownConnection) {
                    con = dataSource.getConnection();
                }
                HashMap<ActivityConstants.AccessType, Set<ProcessModelParameter>> parameters = new HashMap<ActivityConstants.AccessType, Set<ProcessModelParameter>>();
                HashMap<ActivityConstants.AccessType, Map<ProcessModelParameter, Boolean>> retrievedParameters = new HashMap<ActivityConstants.AccessType, Map<ProcessModelParameter, Boolean>>();
                retrievedParameters.put(ActivityConstants.AccessType.READ, new HashMap());
                retrievedParameters.put(ActivityConstants.AccessType.WRITE, new HashMap());
                SQLHelpRead.getParameters(templateID, nodeID, retrievedParameters, null, dataSource, con, factory);
                for (Map.Entry paramsEntry : retrievedParameters.entrySet()) {
                    ActivityConstants.AccessType accessType = (ActivityConstants.AccessType)((Object)paramsEntry.getKey());
                    HashSet<ProcessModelParameter> params = new HashSet<ProcessModelParameter>();
                    parameters.put(accessType, params);
                    for (Map.Entry paramEntry : ((Map)paramsEntry.getValue()).entrySet()) {
                        params.add((ProcessModelParameter)paramEntry.getKey());
                        connectorMapping.add(new Pair<ActivityConstants.AccessType, ProcessModelParameter>(accessType, (ProcessModelParameter)paramEntry.getKey()));
                        if (!((Boolean)paramEntry.getValue()).booleanValue()) continue;
                        int connectorID = connectorMapping.size();
                        disabledConnectors.add(connectorID);
                    }
                }
                HashMap<String, String> userAttributes = new HashMap<String, String>();
                stmt = con.prepareStatement(SQLReadConstants.SQL_TPL_EBP_UAS);
                stmt.setInt(1, nodeID);
                stmt.setLong(2, templateID.getMostSignificantBits());
                stmt.setLong(3, templateID.getLeastSignificantBits());
                stmt.setBoolean(4, false);
                rs = stmt.executeQuery();
                while (rs.next()) {
                    userAttributes.put(SQLHelp.getString(rs, 5), SQLHelp.getString(rs, 6));
                }
                rs = JDBCTools.close(rs);
                stmt = JDBCTools.close(stmt);
                HashMap<String, Set<String>> supportedPlugins = new HashMap<String, Set<String>>();
                HashMap pluginData = new HashMap();
                stmt = con.prepareStatement(SQLReadConstants.SQL_TPL_EBP_PLUGINS);
                stmt.setInt(1, nodeID);
                stmt.setLong(2, templateID.getMostSignificantBits());
                stmt.setLong(3, templateID.getLeastSignificantBits());
                stmt.setBoolean(4, false);
                rs = stmt.executeQuery();
                while (rs.next()) {
                    String extensionPointID = SQLHelp.getString(rs, 5);
                    String pluginID = SQLHelp.getString(rs, 4);
                    if (!supportedPlugins.containsKey(extensionPointID)) {
                        supportedPlugins.put(extensionPointID, new HashSet());
                    }
                    ((Set)supportedPlugins.get(extensionPointID)).add(pluginID);
                    String dataKey = SQLHelp.getString(rs, 6);
                    if (rs.wasNull()) continue;
                    if (!pluginData.containsKey(pluginID)) {
                        pluginData.put(pluginID, new HashMap());
                    }
                    ((Map)pluginData.get(pluginID)).put(dataKey, SQLHelp.getString(rs, 7));
                }
                rs = JDBCTools.close(rs);
                stmt = JDBCTools.close(stmt);
                HashMap<String, PluginData> realPluginData = new HashMap<String, PluginData>();
                for (Map.Entry dat : pluginData.entrySet()) {
                    realPluginData.put((String)dat.getKey(), factory.createPluginData((String)dat.getKey(), (Map)dat.getValue()));
                }
                PluginDataContainer pluginDataContainer = factory.createPluginDataContainer(supportedPlugins, realPluginData);
                stmt = con.prepareStatement(SQLReadConstants.SQL_TPL_EBP);
                stmt.setInt(1, nodeID);
                stmt.setLong(2, templateID.getMostSignificantBits());
                stmt.setLong(3, templateID.getLeastSignificantBits());
                rs = stmt.executeQuery();
                if (rs.next()) {
                    ExecutionControlProperties ecp = new ExecutionControlProperties(rs.getBoolean(5), rs.getBoolean(6), rs.getBoolean(4));
                    int type = rs.getInt(7);
                    if (type == 2) {
                        res = SQLHelpRead.getSubprocess(topLevelTemplateID, templateID, nodeID, parameters, pluginDataContainer, ecp, userAttributes, dataSource, con, factory);
                    } else if (type == 1) {
                        res = SQLHelpRead.getActivity(templateID, nodeID, parameters, pluginDataContainer, ecp, userAttributes, dataSource, con, factory);
                    }
                } else {
                    res = null;
                }
                rs = JDBCTools.close(rs);
                stmt = JDBCTools.close(stmt);
                if (ownConnection) {
                    con = JDBCTools.close(con);
                }
            }
            catch (SQLException e) {
                throw new DataSourceException("SQLException", e);
            }
        }
        catch (Throwable throwable) {
            if (ownConnection) {
                JDBCTools.closeQuietly(con, stmt, rs);
            } else {
                JDBCTools.closeQuietly(stmt, rs);
            }
            throw throwable;
        }
        if (ownConnection) {
            JDBCTools.closeQuietly(con, (Statement)stmt, rs);
        } else {
            JDBCTools.closeQuietly((Statement)stmt, rs);
        }
        logger.finer("SQLHelpRead.getEBP() exit");
        return res;
    }

    public static void getParameters(UUID templateID, int nodeID, Map<ActivityConstants.AccessType, Map<ProcessModelParameter, Boolean>> parameters, Map<ActivityConstants.AccessType, Map<ProcessModelParameter, Boolean>> indexedParameters, JDBCDataSource dataSource, ExtendedConnection con, ProcessModelFactory factory) throws DataSourceException {
        logger.finer("SQLHelpRead.getParameters() entry");
        boolean ownConnection = con == null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        PreparedStatement stmtPd = null;
        ResultSet rsPd = null;
        PreparedStatement stmtUa = null;
        ResultSet rsUa = null;
        HashSet<Integer> requestedAccessTypes = new HashSet<Integer>(4);
        if (parameters != null) {
            for (ActivityConstants.AccessType accessType : parameters.keySet()) {
                requestedAccessTypes.add(accessType.getCode());
            }
        }
        if (indexedParameters != null) {
            for (ActivityConstants.AccessType accessType : indexedParameters.keySet()) {
                requestedAccessTypes.add(accessType.getCode());
            }
        }
        try {
            try {
                if (ownConnection) {
                    con = dataSource.getConnection();
                }
                stmt = con.prepareStatement(String.format(SQLReadConstants.SQL_TPL_PARAMETERS, StringTools.join(", ", requestedAccessTypes.toArray())));
                stmt.setLong(1, templateID.getMostSignificantBits());
                stmt.setLong(2, templateID.getLeastSignificantBits());
                stmt.setInt(3, nodeID);
                rs = stmt.executeQuery();
                stmtPd = con.prepareStatement(String.format(SQLReadConstants.SQL_TPL_PARAMETER_PLUGINS, StringTools.join(", ", requestedAccessTypes.toArray())));
                stmtPd.setLong(1, templateID.getMostSignificantBits());
                stmtPd.setLong(2, templateID.getLeastSignificantBits());
                stmtPd.setInt(3, nodeID);
                rsPd = stmtPd.executeQuery();
                stmtUa = con.prepareStatement(String.format(SQLReadConstants.SQL_TPL_PARAMETER_UAS, StringTools.join(", ", requestedAccessTypes.toArray())));
                stmtUa.setLong(1, templateID.getMostSignificantBits());
                stmtUa.setLong(2, templateID.getLeastSignificantBits());
                stmtUa.setInt(3, nodeID);
                rsUa = stmtUa.executeQuery();
                boolean more = rs.next();
                boolean morePd = rsPd.next();
                boolean moreUa = rsUa.next();
                while (more) {
                    Map<ProcessModelParameter, Boolean> params;
                    ActivityConstants.AccessType accessType = ActivityConstants.AccessType.valueOf(rs.getInt(SQLConstants.COL_PROCESSMODELPARAMETER_ALL[0]));
                    boolean isIndexed = rs.getBoolean(SQLConstants.COL_PROCESSMODELPARAMETER_ALL[2]);
                    String name = SQLHelp.getString(rs, SQLConstants.COL_PROCESSMODELPARAMETER_ALL[1]);
                    String description = SQLHelp.getString(rs, SQLConstants.COL_PROCESSMODELPARAMETER_ALL[9]);
                    ProcessConstants.AdeptDataType dataType = ProcessConstants.AdeptDataType.valueOf(rs.getInt(SQLConstants.COL_PROCESSMODELPARAMETER_ALL[7]));
                    String udtName = dataType == ProcessConstants.AdeptDataType.USERDEFINED ? SQLHelp.getString(rs, SQLConstants.COL_PROCESSMODELPARAMETER_ALL[16]) : null;
                    UUID identifierID = new UUID(rs.getLong(SQLConstants.COL_PROCESSMODELPARAMETER_ALL[10]), rs.getLong(SQLConstants.COL_PROCESSMODELPARAMETER_ALL[11]));
                    boolean isOptional = rs.getBoolean(SQLConstants.COL_PROCESSMODELPARAMETER_ALL[14]);
                    boolean isVirtual = rs.getBoolean(SQLConstants.COL_PROCESSMODELPARAMETER_ALL[15]);
                    boolean isFailure = rs.getBoolean(SQLConstants.COL_PROCESSMODELPARAMETER_ALL[13]);
                    String defaultValue = rs.getString(SQLConstants.COL_PROCESSMODELPARAMETER_ALL[8]);
                    HashMap<String, String> confValues = null;
                    HashMap<String, String> confFromParameter = null;
                    HashMap<String, String> confFromConf = null;
                    HashSet<String> confFixed = null;
                    HashMap<String, Set<String>> supportedPlugins = null;
                    HashMap rawPluginData = null;
                    HashMap<String, String> userAttributes = null;
                    boolean connectorDisabled = rs.getBoolean(SQLConstants.COL_PROCESSMODELPARAMETER_ALL[6]);
                    if (morePd) {
                        ActivityConstants.AccessType accessTypePd = ActivityConstants.AccessType.valueOf(rsPd.getInt(SQLConstants.COL_PARAMETERPLUGINS_PARENT_ID[0]));
                        String namePd = SQLHelp.getString(rsPd, SQLConstants.COL_PARAMETERPLUGINS_PARENT_ID[1]);
                        boolean isIndexedPd = rsPd.getBoolean(SQLConstants.COL_PARAMETERPLUGINS_PARENT_ID[2]);
                        if (accessType == accessTypePd && name.equals(namePd) && isIndexed == isIndexedPd) {
                            supportedPlugins = new HashMap<String, Set<String>>();
                            rawPluginData = new HashMap();
                            do {
                                String dataKey = SQLHelp.getString(rsPd, SQLConstants.COL_PARAMETERPLUGINS_ALL[0]);
                                String dataValue = SQLHelp.getString(rsPd, SQLConstants.COL_PARAMETERPLUGINS_ALL[1]);
                                String pluginID = SQLHelp.getString(rsPd, SQLConstants.COL_PARAMETERPLUGINS_ALL[2]);
                                String extensionPointID = SQLHelp.getString(rsPd, SQLConstants.COL_PARAMETERPLUGINS_ALL[3]);
                                if (!supportedPlugins.containsKey(extensionPointID)) {
                                    supportedPlugins.put(extensionPointID, new HashSet());
                                }
                                ((Set)supportedPlugins.get(extensionPointID)).add(pluginID);
                                if (!rawPluginData.containsKey(pluginID)) {
                                    rawPluginData.put(pluginID, new HashMap());
                                }
                                ((Map)rawPluginData.get(pluginID)).put(dataKey, dataValue);
                                morePd = rsPd.next();
                                if (!morePd) continue;
                                accessTypePd = ActivityConstants.AccessType.valueOf(rsPd.getInt(SQLConstants.COL_PARAMETERPLUGINS_PARENT_ID[0]));
                                namePd = SQLHelp.getString(rsPd, SQLConstants.COL_PARAMETERPLUGINS_PARENT_ID[1]);
                                isIndexedPd = rsPd.getBoolean(SQLConstants.COL_PARAMETERPLUGINS_PARENT_ID[2]);
                            } while (morePd && accessType == accessTypePd && name.equals(namePd) && isIndexed == isIndexedPd);
                        }
                    }
                    if (moreUa) {
                        ActivityConstants.AccessType accessTypeUa = ActivityConstants.AccessType.valueOf(rsUa.getInt(SQLConstants.COL_PARAMETERUA_PARENT_ID[3]));
                        String nameUa = SQLHelp.getString(rsUa, SQLConstants.COL_PARAMETERUA_PARENT_ID[4]);
                        boolean isIndexedUa = rsUa.getBoolean(SQLConstants.COL_PARAMETERUA_PARENT_ID[5]);
                        if (accessType == accessTypeUa && name.equals(nameUa) && isIndexed == isIndexedUa) {
                            userAttributes = new HashMap<String, String>();
                            do {
                                String uaKey = rsUa.getString(SQLConstants.COL_PARAMETERUA_ALL[6]);
                                String uaValue = SQLHelp.getString(rsUa, SQLConstants.COL_PARAMETERUA_ALL[7]);
                                userAttributes.put(uaKey, uaValue);
                                moreUa = rsUa.next();
                                if (!moreUa) continue;
                                accessTypeUa = ActivityConstants.AccessType.valueOf(rsUa.getInt(SQLConstants.COL_PARAMETERUA_PARENT_ID[3]));
                                nameUa = SQLHelp.getString(rsUa, SQLConstants.COL_PARAMETERUA_PARENT_ID[4]);
                                isIndexedUa = rsUa.getBoolean(SQLConstants.COL_PARAMETERUA_PARENT_ID[5]);
                            } while (moreUa && accessType == accessTypeUa && name.equals(nameUa) && isIndexed == isIndexedUa);
                        }
                    }
                    ActivityConstants.AccessType newAccessType = accessType;
                    String newName = name;
                    boolean newIsIndexed = isIndexed;
                    do {
                        int type = rs.getInt(SQLConstants.COL_PARAMETERCONFIGURATION_ALL[6]);
                        if (!rs.wasNull()) {
                            if (confValues == null || confFromParameter == null || confFromConf == null || confFixed == null) {
                                confValues = new HashMap<String, String>();
                                confFromParameter = new HashMap<String, String>();
                                confFromConf = new HashMap<String, String>();
                                confFixed = new HashSet<String>();
                            }
                            String confKey = SQLHelp.getString(rs, SQLConstants.COL_PARAMETERCONFIGURATION_ALL[7]);
                            String confValue = SQLHelp.getString(rs, SQLConstants.COL_PARAMETERCONFIGURATION_ALL[8]);
                            switch (type) {
                                case 1: {
                                    confValues.put(confKey, confValue);
                                    break;
                                }
                                case 3: {
                                    confFromConf.put(confKey, confValue);
                                    break;
                                }
                                case 2: {
                                    confFromParameter.put(confKey, confValue);
                                    break;
                                }
                                default: {
                                    String msg = String.format("Unexpected configuration type '%d' found!", type);
                                    logger.info(msg);
                                }
                            }
                            if (rs.getBoolean(SQLConstants.COL_PARAMETERCONFIGURATION_ALL[9])) {
                                confFixed.add(confKey);
                            }
                        }
                        if (!(more = rs.next())) continue;
                        newAccessType = ActivityConstants.AccessType.valueOf(rs.getInt(SQLConstants.COL_PROCESSMODELPARAMETER_ALL[0]));
                        newName = SQLHelp.getString(rs, SQLConstants.COL_PROCESSMODELPARAMETER_ALL[1]);
                        newIsIndexed = rs.getBoolean(SQLConstants.COL_PROCESSMODELPARAMETER_ALL[2]);
                    } while (more && newAccessType == accessType && newName.equals(name) && newIsIndexed == isIndexed);
                    ActivityConfiguration configuration = null;
                    if (confValues != null) {
                        configuration = factory.createActivityConfiguration(confValues, confFromParameter, confFromConf, confFixed);
                    }
                    PluginDataContainer pdc = null;
                    if (rawPluginData != null) {
                        HashMap<String, PluginData> pluginData = null;
                        pluginData = new HashMap<String, PluginData>();
                        for (Map.Entry dat : rawPluginData.entrySet()) {
                            pluginData.put((String)dat.getKey(), factory.createPluginData((String)dat.getKey(), (Map)dat.getValue()));
                        }
                        pdc = factory.createPluginDataContainer(supportedPlugins, pluginData);
                    }
                    ProcessModelParameter param = factory.createProcessModelParameter(name, description, dataType, udtName, identifierID, isOptional, isVirtual, isFailure, defaultValue, configuration, pdc, userAttributes);
                    if (isIndexed) {
                        if (indexedParameters == null || (params = indexedParameters.get((Object)accessType)) == null) continue;
                        params.put(param, connectorDisabled);
                        continue;
                    }
                    if (parameters == null || (params = parameters.get((Object)accessType)) == null) continue;
                    params.put(param, connectorDisabled);
                }
                rsUa = JDBCTools.close(rsUa);
                stmtUa = JDBCTools.close(stmtUa);
                rsPd = JDBCTools.close(rsPd);
                stmtPd = JDBCTools.close(stmtPd);
                rs = JDBCTools.close(rs);
                stmt = JDBCTools.close(stmt);
                if (ownConnection) {
                    con = JDBCTools.close(con);
                }
            }
            catch (SQLException e) {
                throw new DataSourceException("SQLException", e);
            }
        }
        catch (Throwable throwable) {
            JDBCTools.closeQuietly(stmtUa, rsUa);
            JDBCTools.closeQuietly(stmtPd, rsPd);
            if (ownConnection) {
                JDBCTools.closeQuietly(con, stmt, rs);
            } else {
                JDBCTools.closeQuietly(stmt, rs);
            }
            throw throwable;
        }
        JDBCTools.closeQuietly((Statement)stmtUa, rsUa);
        JDBCTools.closeQuietly((Statement)stmtPd, rsPd);
        if (ownConnection) {
            JDBCTools.closeQuietly(con, (Statement)stmt, rs);
        } else {
            JDBCTools.closeQuietly((Statement)stmt, rs);
        }
        logger.finer("SQLHelpRead.getParameters() exit");
    }

    public static void getNodes(UUID topLevelTemplateID, UUID templateID, Map<Integer, Node> nodes, Map<Integer, ProcessModelFactory.StructuralNodeData> structuralNodeData, int startNodeID, int endNodeID, Map<Integer, List<Integer>> disabledConnectors, JDBCDataSource dataSource, ExtendedConnection con, ProcessModelFactory factory) throws DataSourceException {
        logger.finer("SQLHelpRead.getNodes() entry");
        boolean ownConnection = con == null;
        PreparedStatement stmt = null;
        PreparedStatement stmtUa = null;
        ResultSet rs = null;
        ResultSet rsUa = null;
        try {
            try {
                if (ownConnection) {
                    con = dataSource.getConnection();
                }
                stmt = con.prepareStatement(SQLReadConstants.SQL_TPL_NODES);
                stmt.setLong(1, templateID.getMostSignificantBits());
                stmt.setLong(2, templateID.getLeastSignificantBits());
                rs = stmt.executeQuery();
                stmtUa = con.prepareStatement(SQLReadConstants.SQL_TPL_NODE_UAS);
                stmtUa.setLong(1, templateID.getMostSignificantBits());
                stmtUa.setLong(2, templateID.getLeastSignificantBits());
                rsUa = stmtUa.executeQuery();
                boolean more = rs.next();
                boolean moreUa = rsUa.next();
                while (more) {
                    int nodeIDUa;
                    int nodeID = rs.getInt(SQLConstants.COL_NODE_ALL[2]);
                    String name = SQLHelp.getString(rs, SQLConstants.COL_NODE_ALL[9]);
                    String description = SQLHelp.getString(rs, SQLConstants.COL_NODE_ALL[8]);
                    String staffAssignmentRule = SQLHelp.getString(rs, SQLConstants.COL_NODE_ALL[11]);
                    ExecutableBusinessProcess ebp = null;
                    boolean autoStart = rs.getBoolean(SQLConstants.COL_NODE_ALL[5]);
                    UUID iconID = null;
                    rs.getLong(SQLConstants.COL_NODE_ALL[3]);
                    if (!rs.wasNull()) {
                        iconID = new UUID(rs.getLong(SQLConstants.COL_NODE_ALL[3]), rs.getLong(SQLConstants.COL_NODE_ALL[4]));
                    }
                    HashMap<String, Set<String>> supportedPlugins = null;
                    HashMap rawPluginData = null;
                    HashMap<String, String> userAttributes = null;
                    ProcessConstants.NodeType nodeType = ProcessConstants.NodeType.valueOf(rs.getInt(SQLConstants.COL_NODE_ALL[12]));
                    int topologicalID = rs.getInt(SQLConstants.COL_NODE_ALL[13]);
                    int branchID = rs.getInt(SQLConstants.COL_NODE_ALL[6]);
                    int splitNodeID = rs.getInt(SQLConstants.COL_NODE_ALL[10]);
                    int correspondingBlockNodeID = rs.getInt(SQLConstants.COL_NODE_ALL[7]);
                    if (moreUa && nodeID == (nodeIDUa = rsUa.getInt(SQLConstants.COL_NODEUSERATTRIBUTES_PARENT_ID[0]))) {
                        userAttributes = new HashMap<String, String>();
                        do {
                            String uaKey = rsUa.getString(SQLConstants.COL_NODEUSERATTRIBUTES_ALL[3]);
                            String string = SQLHelp.getString(rsUa, SQLConstants.COL_NODEUSERATTRIBUTES_ALL[4]);
                            userAttributes.put(uaKey, string);
                            moreUa = rsUa.next();
                            if (!moreUa) continue;
                            nodeIDUa = rsUa.getInt(SQLConstants.COL_NODEUSERATTRIBUTES_PARENT_ID[0]);
                        } while (moreUa && nodeID == nodeIDUa);
                    }
                    int newNodeID = nodeID;
                    do {
                        String dataKey;
                        if ((dataKey = rs.getString(SQLConstants.COL_NODEPLUGINS_ALL[0])) != null) {
                            if (supportedPlugins == null || rawPluginData == null) {
                                supportedPlugins = new HashMap<String, Set<String>>();
                                rawPluginData = new HashMap();
                            }
                            String string = SQLHelp.getString(rs, SQLConstants.COL_NODEPLUGINS_ALL[3]);
                            String pluginID = SQLHelp.getString(rs, SQLConstants.COL_NODEPLUGINS_ALL[2]);
                            if (!supportedPlugins.containsKey(string)) {
                                supportedPlugins.put(string, new HashSet());
                            }
                            ((Set)supportedPlugins.get(string)).add(pluginID);
                            if (!rawPluginData.containsKey(pluginID)) {
                                rawPluginData.put(pluginID, new HashMap());
                            }
                            ((Map)rawPluginData.get(pluginID)).put(dataKey, SQLHelp.getString(rs, SQLConstants.COL_NODEPLUGINS_ALL[1]));
                        }
                        if (!(more = rs.next())) continue;
                        newNodeID = rs.getInt(SQLConstants.COL_NODE_ALL[2]);
                    } while (more && newNodeID == nodeID);
                    HashMap<String, PluginData> pluginData = null;
                    if (rawPluginData != null) {
                        pluginData = new HashMap<String, PluginData>();
                        for (Map.Entry entry : rawPluginData.entrySet()) {
                            pluginData.put((String)entry.getKey(), factory.createPluginData((String)entry.getKey(), (Map)entry.getValue()));
                        }
                    }
                    ArrayList<Pair<ActivityConstants.AccessType, ProcessModelParameter>> arrayList = new ArrayList<Pair<ActivityConstants.AccessType, ProcessModelParameter>>();
                    HashMap<ActivityConstants.AccessType, Set<ProcessModelParameter>> parameters = new HashMap<ActivityConstants.AccessType, Set<ProcessModelParameter>>();
                    HashMap<ActivityConstants.AccessType, Map<ProcessModelParameter, Boolean>> retrievedParameters = new HashMap<ActivityConstants.AccessType, Map<ProcessModelParameter, Boolean>>();
                    retrievedParameters.put(ActivityConstants.AccessType.SYSTEM_READ, new HashMap());
                    retrievedParameters.put(ActivityConstants.AccessType.SYSTEM_WRITE, new HashMap());
                    SQLHelpRead.getParameters(templateID, nodeID, retrievedParameters, null, dataSource, con, factory);
                    for (Map.Entry paramsEntry : retrievedParameters.entrySet()) {
                        ActivityConstants.AccessType accessType = (ActivityConstants.AccessType)((Object)paramsEntry.getKey());
                        HashSet<ProcessModelParameter> params = new HashSet<ProcessModelParameter>();
                        parameters.put(accessType, params);
                        for (Map.Entry paramEntry : ((Map)paramsEntry.getValue()).entrySet()) {
                            params.add((ProcessModelParameter)paramEntry.getKey());
                            arrayList.add(new Pair<ActivityConstants.AccessType, ProcessModelParameter>(accessType, (ProcessModelParameter)paramEntry.getKey()));
                            if (!((Boolean)paramEntry.getValue()).booleanValue()) continue;
                            int connectorID = arrayList.size();
                            disabledConnectors.get(nodeID).add(connectorID);
                        }
                    }
                    if (nodeID != startNodeID && nodeID != endNodeID) {
                        List<Integer> dis = disabledConnectors.get(nodeID);
                        if (dis == null) {
                            dis = new ArrayList<Integer>();
                        }
                        ebp = SQLHelpRead.getEBP(topLevelTemplateID, templateID, nodeID, arrayList, dis, dataSource, con, factory);
                        if (dis.size() > 0) {
                            disabledConnectors.put(nodeID, dis);
                        }
                    }
                    HashMap<ActivityConstants.AccessType, Map<String, Integer>> resultingConnectorMapping = new HashMap<ActivityConstants.AccessType, Map<String, Integer>>();
                    int i = 0;
                    while (i < arrayList.size()) {
                        int connectorID = i + 1;
                        ActivityConstants.AccessType access = (ActivityConstants.AccessType)((Object)((Pair)arrayList.get(i)).getFirst());
                        ProcessModelParameter param = (ProcessModelParameter)((Pair)arrayList.get(i)).getSecond();
                        if (!resultingConnectorMapping.containsKey((Object)access)) {
                            resultingConnectorMapping.put(access, new HashMap());
                        }
                        ((Map)resultingConnectorMapping.get((Object)access)).put(param.getName(), connectorID);
                        ++i;
                    }
                    nodes.put(nodeID, factory.createNode(nodeID, name, description, staffAssignmentRule, ebp, autoStart, iconID, resultingConnectorMapping, parameters, supportedPlugins, pluginData, userAttributes));
                    structuralNodeData.put(nodeID, factory.createStructuralNodeData(nodeID, nodeType, topologicalID, branchID, splitNodeID, correspondingBlockNodeID));
                }
                rsUa = JDBCTools.close(rsUa);
                stmtUa = JDBCTools.close(stmtUa);
                rs = JDBCTools.close(rs);
                stmt = JDBCTools.close(stmt);
                if (ownConnection) {
                    con = JDBCTools.close(con);
                }
            }
            catch (SQLException e) {
                throw new DataSourceException("SQLException", e);
            }
        }
        catch (Throwable throwable) {
            JDBCTools.closeQuietly(stmtUa, rsUa);
            if (ownConnection) {
                JDBCTools.closeQuietly(con, (Statement)stmt, rs);
            } else {
                JDBCTools.closeQuietly((Statement)stmt, rs);
            }
            throw throwable;
        }
        JDBCTools.closeQuietly((Statement)stmtUa, rsUa);
        if (ownConnection) {
            JDBCTools.closeQuietly(con, (Statement)stmt, rs);
        } else {
            JDBCTools.closeQuietly((Statement)stmt, rs);
        }
        logger.finer("SQLHelpRead.getNodes() exit");
    }

    public static boolean templateExists(UUID templateID, JDBCDataSource dataSource, ExtendedConnection con) throws DataSourceException {
        boolean ret;
        logger.finer("SQLHelpRead.templateExists() entry");
        boolean ownConnection = con == null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            try {
                if (ownConnection) {
                    con = dataSource.getConnection();
                }
                stmt = con.prepareStatement(SQLReadConstants.SQL_TPL_TEMPLATE_EXISTS);
                stmt.setLong(1, templateID.getMostSignificantBits());
                stmt.setLong(2, templateID.getLeastSignificantBits());
                rs = stmt.executeQuery();
                ret = rs.next();
                rs = JDBCTools.close(rs);
                stmt = JDBCTools.close(stmt);
            }
            catch (SQLException e) {
                throw new DataSourceException("SQLException", e);
            }
        }
        catch (Throwable throwable) {
            if (ownConnection) {
                JDBCTools.closeQuietly(con, (Statement)stmt, rs);
            } else {
                JDBCTools.closeQuietly((Statement)stmt, rs);
            }
            throw throwable;
        }
        if (ownConnection) {
            JDBCTools.closeQuietly(con, (Statement)stmt, rs);
        } else {
            JDBCTools.closeQuietly((Statement)stmt, rs);
        }
        logger.finer("SQLHelpRead.templateExists() exit");
        return ret;
    }

    public static Template getTemplate(UUID templateID, JDBCDataSource dataSource, ExtendedConnection con, ProcessModelFactory factory) throws DataSourceException {
        return SQLHelpRead.getTemplate(templateID, templateID, false, dataSource, con, factory);
    }

    public static Template getTemplate(UUID topLevelTemplateID, UUID templateID, boolean embedded, JDBCDataSource dataSource, ExtendedConnection con, ProcessModelFactory factory) throws DataSourceException {
        Template res;
        logger.finer("SQLHelpRead.getTemplate() entry");
        boolean ownConnection = con == null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        PreparedStatement stmtInner = null;
        ResultSet rsInner = null;
        UUID effectiveID = embedded ? topLevelTemplateID : templateID;
        try {
            try {
                if (ownConnection) {
                    con = dataSource.getConnection();
                }
                HashMap<Integer, ProcessModelFactory.StructuralNodeData> structuralNodeData = new HashMap<Integer, ProcessModelFactory.StructuralNodeData>();
                HashSet<Node> nodes = new HashSet<Node>();
                HashMap<Integer, Node> nodeIDNodeMapping = new HashMap<Integer, Node>();
                HashMap<Integer, List<Integer>> disabledConnectors = new HashMap<Integer, List<Integer>>();
                HashMap<Integer, Integer> nextConnectorID = new HashMap<Integer, Integer>();
                stmt = con.prepareStatement(SQLReadConstants.SQL_TPL_TEMPLATE);
                stmt.setLong(1, templateID.getMostSignificantBits());
                stmt.setLong(2, templateID.getLeastSignificantBits());
                rs = stmt.executeQuery();
                if (!rs.next()) {
                    String msg = String.format("Template %s not found!", templateID);
                    throw new IllegalArgumentException(msg);
                }
                String tplName = SQLHelp.getString(rs, 5);
                String tplDescription = SQLHelp.getString(rs, 3);
                String processType = SQLHelp.getString(rs, 6);
                QualifiedAgent supervisor = new QualifiedAgent(rs.getInt(7), SQLHelp.getString(rs, 8), rs.getInt(9), SQLHelp.getString(rs, 10));
                String tplVersion = SQLHelp.getString(rs, 11);
                int startNodeID = rs.getInt(12);
                int endNodeID = rs.getInt(13);
                String instanceNameTemplate = rs.getString(4);
                rs = JDBCTools.close(rs);
                stmt = JDBCTools.close(stmt);
                SQLHelpRead.getNodes(effectiveID, templateID, nodeIDNodeMapping, structuralNodeData, startNodeID, endNodeID, disabledConnectors, dataSource, con, factory);
                nodes.addAll(nodeIDNodeMapping.values());
                int maxID = 0;
                for (Node node : nodeIDNodeMapping.values()) {
                    ActivityConstants.AccessType[] accessTypeArray = ActivityConstants.AccessType.values();
                    int n = accessTypeArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        ActivityConstants.AccessType a = accessTypeArray[n2];
                        for (Map.Entry<String, Integer> mapping : node.getConnectorMapping(a).entrySet()) {
                            if (mapping.getValue() <= maxID) continue;
                            maxID = mapping.getValue();
                        }
                        ++n2;
                    }
                    nextConnectorID.put(node.getID(), maxID + 1);
                }
                List<DataElement> dataElements = SQLHelpRead.getDataElements(templateID, dataSource, con, factory);
                Set<StructuredEdge> edges = SQLHelpRead.getStructuredEdges(templateID, dataSource, con, factory);
                Set<StructuredDataEdge> dataEdges = SQLHelpRead.getStructuredDataEdges(templateID, nodeIDNodeMapping, disabledConnectors, nextConnectorID, dataSource, con, factory);
                HashMap<String, String> userAttributes = new HashMap<String, String>();
                stmt = con.prepareStatement(SQLReadConstants.SQL_TPL_TEMPLATE_UAS);
                stmt.setLong(1, templateID.getMostSignificantBits());
                stmt.setLong(2, templateID.getLeastSignificantBits());
                rs = stmt.executeQuery();
                while (rs.next()) {
                    userAttributes.put(SQLHelp.getString(rs, 3), SQLHelp.getString(rs, 4));
                }
                rs = JDBCTools.close(rs);
                stmt = JDBCTools.close(stmt);
                HashMap<String, Set<String>> supportedPlugins = new HashMap<String, Set<String>>();
                HashMap pluginData = new HashMap();
                stmt = con.prepareStatement(SQLReadConstants.SQL_TPL_TEMPLATE_PLUGINS);
                stmt.setLong(1, templateID.getMostSignificantBits());
                stmt.setLong(2, templateID.getLeastSignificantBits());
                rs = stmt.executeQuery();
                while (rs.next()) {
                    String extensionPointID = SQLHelp.getString(rs, 4);
                    String pluginID = SQLHelp.getString(rs, 3);
                    if (!supportedPlugins.containsKey(extensionPointID)) {
                        supportedPlugins.put(extensionPointID, new HashSet());
                    }
                    ((Set)supportedPlugins.get(extensionPointID)).add(pluginID);
                    String dataKey = SQLHelp.getString(rs, 1);
                    if (rs.wasNull()) continue;
                    if (!pluginData.containsKey(pluginID)) {
                        pluginData.put(pluginID, new HashMap());
                    }
                    ((Map)pluginData.get(pluginID)).put(dataKey, SQLHelp.getString(rs, 2));
                }
                rs = JDBCTools.close(rs);
                stmt = JDBCTools.close(stmt);
                HashMap<String, PluginData> realPluginData = new HashMap<String, PluginData>();
                for (Map.Entry dat : pluginData.entrySet()) {
                    realPluginData.put((String)dat.getKey(), factory.createPluginData((String)dat.getKey(), (Map)dat.getValue()));
                }
                HashMap<String, String> confValue = new HashMap<String, String>();
                HashSet<String> confFixed = new HashSet<String>();
                HashMap<String, String> testConfValue = new HashMap<String, String>();
                HashSet<String> testConfFixed = new HashSet<String>();
                stmt = con.prepareStatement(SQLReadConstants.SQL_TPL_TEMPLATE_CONFIGURATION);
                stmt.setLong(1, templateID.getMostSignificantBits());
                stmt.setLong(2, templateID.getLeastSignificantBits());
                rs = stmt.executeQuery();
                block14: while (rs.next()) {
                    int type = rs.getInt(3);
                    switch (type) {
                        case 1: {
                            confValue.put(SQLHelp.getString(rs, 4), SQLHelp.getString(rs, 5));
                            if (!rs.getBoolean(6)) continue block14;
                            confFixed.add(SQLHelp.getString(rs, 4));
                            break;
                        }
                        case 4: {
                            testConfValue.put(SQLHelp.getString(rs, 4), SQLHelp.getString(rs, 5));
                            if (!rs.getBoolean(6)) continue block14;
                            testConfFixed.add(SQLHelp.getString(rs, 4));
                            break;
                        }
                        default: {
                            String msg = String.format("Unexpected configuration type '%d' found!", type);
                            logger.info(msg);
                        }
                    }
                }
                rs = JDBCTools.close(rs);
                stmt = JDBCTools.close(stmt);
                Configuration configuration = factory.createConfiguration(confValue, confFixed);
                Configuration testConfiguration = factory.createConfiguration(testConfValue, testConfFixed);
                HashMap<String, ConfigurationDescription.ConfigurationEntry> confDescEntries = new HashMap<String, ConfigurationDescription.ConfigurationEntry>();
                stmt = con.prepareStatement(SQLReadConstants.SQL_TPL_TEMPLATE_CONFIG_DESCRIPTION);
                stmt.setLong(1, templateID.getMostSignificantBits());
                stmt.setLong(2, templateID.getLeastSignificantBits());
                rs = stmt.executeQuery();
                while (rs.next()) {
                    String entryName = SQLHelp.getString(rs, 3);
                    HashMap<String, String> confDescUA = new HashMap<String, String>();
                    stmtInner = con.prepareStatement(SQLReadConstants.SQL_TPL_TEMPLATE_CONFIG_DESCRIPTION_UAS);
                    stmtInner.setLong(1, templateID.getMostSignificantBits());
                    stmtInner.setLong(2, templateID.getLeastSignificantBits());
                    stmtInner.setString(3, entryName);
                    rsInner = stmt.executeQuery();
                    while (rsInner.next()) {
                        confDescUA.put(SQLHelp.getString(rsInner, 4), SQLHelp.getString(rsInner, 5));
                    }
                    rsInner = JDBCTools.close(rsInner);
                    stmtInner = JDBCTools.close(stmtInner);
                    ArrayList<String> restrictions = new ArrayList<String>();
                    stmtInner = con.prepareStatement(SQLReadConstants.SQL_TPL_TEMPLATE_CONFIG_DESCRIPTION_RESTRICTIONS);
                    stmtInner.setLong(1, templateID.getMostSignificantBits());
                    stmtInner.setLong(2, templateID.getLeastSignificantBits());
                    stmtInner.setString(3, entryName);
                    rsInner = stmtInner.executeQuery();
                    while (rsInner.next()) {
                        restrictions.add(SQLHelp.getString(rsInner, 4));
                    }
                    rsInner = JDBCTools.close(rsInner);
                    stmtInner = JDBCTools.close(stmtInner);
                    HashMap<String, Set<String>> supportedPluginsConfDesc = new HashMap<String, Set<String>>();
                    HashMap pluginDatasConfDesc = new HashMap();
                    stmtInner = con.prepareStatement(SQLReadConstants.SQL_TPL_TEMPLATE_CONFIG_DESCRIPTION_PLUGINS);
                    stmtInner.setLong(1, templateID.getMostSignificantBits());
                    stmtInner.setLong(2, templateID.getLeastSignificantBits());
                    stmtInner.setString(3, entryName);
                    rsInner = stmtInner.executeQuery();
                    while (rsInner.next()) {
                        String extensionPointID = SQLHelp.getString(rsInner, 5);
                        String pluginID = SQLHelp.getString(rsInner, 4);
                        if (!supportedPluginsConfDesc.containsKey(extensionPointID)) {
                            supportedPluginsConfDesc.put(extensionPointID, new HashSet());
                        }
                        ((Set)supportedPluginsConfDesc.get(extensionPointID)).add(pluginID);
                        if (!pluginDatasConfDesc.containsKey(pluginID)) {
                            pluginDatasConfDesc.put(pluginID, new HashMap());
                        }
                        ((Map)pluginDatasConfDesc.get(pluginID)).put(SQLHelp.getString(rsInner, 6), SQLHelp.getString(rsInner, 7));
                    }
                    HashMap<String, PluginData> realPluginDataConfDesc = new HashMap<String, PluginData>();
                    for (Map.Entry entry : pluginDatasConfDesc.entrySet()) {
                        realPluginDataConfDesc.put((String)entry.getKey(), factory.createPluginData((String)entry.getKey(), (Map)entry.getValue()));
                    }
                    rsInner = JDBCTools.close(rsInner);
                    stmtInner = JDBCTools.close(stmtInner);
                    ConfigurationDescription.ConfigurationEntry confEntry = factory.createConfigurationEntry(entryName, SQLHelp.getString(rs, 4), ProcessConstants.AdeptDataType.valueOf(rs.getInt(5)), rs.getBoolean(6), restrictions.toArray(new String[restrictions.size()]), factory.createPluginDataContainer(supportedPluginsConfDesc, realPluginData), confDescUA);
                    confDescEntries.put(entryName, confEntry);
                }
                rs = JDBCTools.close(rs);
                stmt = JDBCTools.close(stmt);
                ConfigurationDescription configurationDescription = factory.createConfigurationDescription(confDescEntries);
                HashSet<ProcessModelParameter> inputParameters = new HashSet<ProcessModelParameter>();
                HashSet<ProcessModelParameter> outputParameters = new HashSet<ProcessModelParameter>();
                HashMap<ActivityConstants.AccessType, Map<ProcessModelParameter, Boolean>> reqParams = new HashMap<ActivityConstants.AccessType, Map<ProcessModelParameter, Boolean>>();
                HashMap inputParams = new HashMap();
                reqParams.put(ActivityConstants.AccessType.READ, inputParams);
                SQLHelpRead.getParameters(templateID, startNodeID, reqParams, null, dataSource, con, factory);
                inputParameters.addAll(inputParams.keySet());
                reqParams.clear();
                HashMap outputParams = new HashMap();
                reqParams.put(ActivityConstants.AccessType.WRITE, outputParams);
                SQLHelpRead.getParameters(templateID, endNodeID, reqParams, null, dataSource, con, factory);
                outputParameters.addAll(outputParams.keySet());
                res = factory.createTemplate(effectiveID, tplName, tplDescription, configurationDescription, configuration, testConfiguration, processType, supervisor, tplVersion, inputParameters, outputParameters, null, nodes, dataElements, edges, dataEdges, null, structuralNodeData, disabledConnectors, startNodeID, endNodeID, instanceNameTemplate, supportedPlugins, realPluginData, userAttributes);
                if (ownConnection) {
                    con = JDBCTools.close(con);
                }
            }
            catch (SQLException e) {
                throw new DataSourceException("SQLException", e);
            }
        }
        catch (Throwable throwable) {
            if (ownConnection) {
                JDBCTools.closeQuietly(con, stmt, rs);
            } else {
                JDBCTools.closeQuietly(stmt, rs);
            }
            JDBCTools.closeQuietly(stmtInner, rsInner);
            throw throwable;
        }
        if (ownConnection) {
            JDBCTools.closeQuietly(con, (Statement)stmt, rs);
        } else {
            JDBCTools.closeQuietly((Statement)stmt, rs);
        }
        JDBCTools.closeQuietly((Statement)stmtInner, rsInner);
        logger.finer("SQLHelpRead.getTemplate() exit");
        return res;
    }

    public static TemplateStatus getTemplateStatus(UUID templateID, JDBCDataSource dataSource, ExtendedConnection con, ProcessModelFactory factory) throws DataSourceException {
        TemplateStatus res;
        logger.finer("SQLHelpRead.getTemplateStatus() entry");
        boolean ownConnection = con == null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            try {
                if (ownConnection) {
                    con = dataSource.getConnection();
                }
                stmt = con.prepareStatement(SQLReadConstants.SQL_TEMPLATE_STATUS);
                stmt.setLong(1, templateID.getMostSignificantBits());
                stmt.setLong(2, templateID.getLeastSignificantBits());
                rs = stmt.executeQuery();
                if (!rs.next()) {
                    String msg = String.format("TemplateStatus for template %s not found!", templateID);
                    logger.severe(msg);
                    throw new IllegalArgumentException(msg);
                }
                res = factory.createTemplateStatus(templateID, ProcessConstants.TemplateBuildtimeState.valueOf(rs.getInt(3)), ProcessConstants.TemplateUsage.valueOf(rs.getInt(4)), rs.getBoolean(5), rs.getBoolean(6), SQLHelp.getString(rs, 7), rs.getBoolean(8), SQLHelp.getString(rs, 16), rs.getBoolean(9), SQLHelp.getString(rs, 17), rs.getBoolean(10), SQLHelp.getString(rs, 18), rs.getBoolean(11), SQLHelp.getString(rs, 19), rs.getBoolean(12), SQLHelp.getString(rs, 20), rs.getBoolean(13), SQLHelp.getString(rs, 21), rs.getBoolean(14), SQLHelp.getString(rs, 22), rs.getBoolean(15), SQLHelp.getString(rs, 23), SQLHelp.getString(rs, 24));
                rs = JDBCTools.close(rs);
                stmt = JDBCTools.close(stmt);
                if (ownConnection) {
                    con = JDBCTools.close(con);
                }
            }
            catch (SQLException e) {
                throw new DataSourceException("SQLException", e);
            }
        }
        catch (Throwable throwable) {
            if (ownConnection) {
                JDBCTools.closeQuietly(con, (Statement)stmt, rs);
            } else {
                JDBCTools.closeQuietly((Statement)stmt, rs);
            }
            throw throwable;
        }
        if (ownConnection) {
            JDBCTools.closeQuietly(con, (Statement)stmt, rs);
        } else {
            JDBCTools.closeQuietly((Statement)stmt, rs);
        }
        logger.finer("SQLHelpRead.getTemplateStatus() exit");
        return res;
    }

    public static TemplateReference getTemplateReference(UUID templateID, TemplateStatus status, JDBCDataSource dataSource, ExtendedConnection con, ProcessModelFactory factory) throws DataSourceException {
        TemplateReference res;
        logger.finer("SQLHelpRead.getTemplateReference() entry");
        boolean ownConnection = con == null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        Statement stmt2 = null;
        ResultSet rs2 = null;
        try {
            try {
                if (ownConnection) {
                    con = dataSource.getConnection();
                }
                HashMap<String, Set<String>> supportedPlugins = new HashMap<String, Set<String>>();
                HashMap pluginData = new HashMap();
                stmt = con.prepareStatement(SQLReadConstants.SQL_TPL_TEMPLATE_PLUGINS);
                stmt.setLong(1, templateID.getMostSignificantBits());
                stmt.setLong(2, templateID.getLeastSignificantBits());
                rs = stmt.executeQuery();
                while (rs.next()) {
                    String extensionPointID = SQLHelp.getString(rs, 4);
                    String pluginID = SQLHelp.getString(rs, 3);
                    if (!supportedPlugins.containsKey(extensionPointID)) {
                        supportedPlugins.put(extensionPointID, new HashSet());
                    }
                    ((Set)supportedPlugins.get(extensionPointID)).add(pluginID);
                    String dataKey = SQLHelp.getString(rs, 1);
                    if (rs.wasNull()) continue;
                    if (!pluginData.containsKey(pluginID)) {
                        pluginData.put(pluginID, new HashMap());
                    }
                    ((Map)pluginData.get(pluginID)).put(dataKey, SQLHelp.getString(rs, 2));
                }
                rs = JDBCTools.close(rs);
                stmt = JDBCTools.close(stmt);
                HashMap<String, PluginData> realPluginData = new HashMap<String, PluginData>();
                for (Map.Entry dat : pluginData.entrySet()) {
                    realPluginData.put((String)dat.getKey(), factory.createPluginData((String)dat.getKey(), (Map)dat.getValue()));
                }
                HashMap<String, String> userAttributes = new HashMap<String, String>();
                stmt = con.prepareStatement(SQLReadConstants.SQL_TPL_TEMPLATE_UAS);
                stmt.setLong(1, templateID.getMostSignificantBits());
                stmt.setLong(2, templateID.getLeastSignificantBits());
                rs = stmt.executeQuery();
                while (rs.next()) {
                    userAttributes.put(SQLHelp.getString(rs, 3), SQLHelp.getString(rs, 4));
                }
                rs = JDBCTools.close(rs);
                stmt = JDBCTools.close(stmt);
                stmt = con.prepareStatement(SQLReadConstants.SQL_TPL_TEMPLATE);
                stmt.setLong(1, templateID.getMostSignificantBits());
                stmt.setLong(2, templateID.getLeastSignificantBits());
                rs = stmt.executeQuery();
                if (!rs.next()) {
                    String msg = String.format("Template %s not found!", templateID);
                    logger.severe(msg);
                    throw new IllegalArgumentException(msg);
                }
                int startNodeID = rs.getInt(12);
                int endNodeID = rs.getInt(13);
                HashSet<ProcessModelParameter> inputParameters = new HashSet<ProcessModelParameter>();
                HashSet<ProcessModelParameter> outputParameters = new HashSet<ProcessModelParameter>();
                HashMap<ActivityConstants.AccessType, Map<ProcessModelParameter, Boolean>> reqParams = new HashMap<ActivityConstants.AccessType, Map<ProcessModelParameter, Boolean>>();
                HashMap inputParams = new HashMap();
                reqParams.put(ActivityConstants.AccessType.READ, inputParams);
                SQLHelpRead.getParameters(templateID, startNodeID, reqParams, null, dataSource, con, factory);
                inputParameters.addAll(inputParams.keySet());
                reqParams.clear();
                HashMap outputParams = new HashMap();
                reqParams.put(ActivityConstants.AccessType.WRITE, outputParams);
                SQLHelpRead.getParameters(templateID, endNodeID, reqParams, null, dataSource, con, factory);
                outputParameters.addAll(outputParams.keySet());
                res = factory.createTemplateReference(templateID, SQLHelp.getString(rs, 6), SQLHelp.getString(rs, 11), SQLHelp.getString(rs, 5), SQLHelp.getString(rs, 3), new QualifiedAgent(rs.getLong(7), SQLHelp.getString(rs, 8), rs.getLong(9), SQLHelp.getString(rs, 10)), inputParameters, outputParameters, supportedPlugins, realPluginData, userAttributes, status.isTopLevelUsable(), status.getUsageAsSubprocess(), status.getBuildtimeState(), status.isDerivable(), status.isOutdated(true), status.isOutdated(false), status.isInstantiable(true), status.isInstantiable(false), status.areInstancesMigratableTo(true), status.areInstancesMigratableTo(false), status.areInstancesChangeable(true), status.areInstancesChangeable(false));
                rs = JDBCTools.close(rs);
                stmt = JDBCTools.close(stmt);
                if (ownConnection) {
                    con = JDBCTools.close(con);
                }
            }
            catch (SQLException e) {
                throw new DataSourceException("SQLException", e);
            }
        }
        catch (Throwable throwable) {
            if (ownConnection) {
                JDBCTools.closeQuietly(con, stmt, rs);
            } else {
                JDBCTools.closeQuietly(stmt, rs);
            }
            JDBCTools.closeQuietly(stmt2, rs2);
            throw throwable;
        }
        if (ownConnection) {
            JDBCTools.closeQuietly(con, (Statement)stmt, rs);
        } else {
            JDBCTools.closeQuietly((Statement)stmt, rs);
        }
        JDBCTools.closeQuietly(stmt2, rs2);
        logger.finer("SQLHelpRead.getTemplateReference() exit");
        return res;
    }

    public static ExecutableInstance getInstance(UUID instanceID, TemplateStorage templateStorage, JDBCDataSource dataSource, ProcessModelFactory factory, ExecutionFactory executionFactory) throws DataSourceException {
        ExecutableInstance res;
        logger.finer("SQLHelpRead.getInstance() entry");
        PreparedStatement stmt = null;
        PreparedStatement stmtEnquiryQA = null;
        ResultSet rs = null;
        ResultSet rsEnquiryQA = null;
        ExtendedConnection con = null;
        String msg = null;
        try {
            try {
                con = dataSource.getConnection();
                stmt = con.prepareStatement(SQLReadConstants.SQL_INST_GET_LOG_ID);
                stmt.setLong(1, instanceID.getMostSignificantBits());
                stmt.setLong(2, instanceID.getLeastSignificantBits());
                rs = stmt.executeQuery();
                if (!rs.next()) {
                    msg = String.format("Instance with ID %s not known!", instanceID);
                    logger.severe(msg);
                    throw new IllegalArgumentException(msg);
                }
                UUID instanceLogID = new UUID(rs.getLong(1), rs.getLong(2));
                rs = JDBCTools.close(rs);
                stmt = JDBCTools.close(stmt);
                logger.finest("Instance exists and retrieved log ID.");
                stmt = con.prepareStatement(SQLReadConstants.SQL_INST_FIND_TEMPLATE_ID);
                stmt.setLong(1, instanceID.getMostSignificantBits());
                stmt.setLong(2, instanceID.getLeastSignificantBits());
                rs = stmt.executeQuery();
                rs.next();
                UUID templateID = new UUID(rs.getLong(1), rs.getLong(2));
                rs = JDBCTools.close(rs);
                stmt = JDBCTools.close(stmt);
                JDBCTools.close(con);
                logger.finest("Retrieved template ID.");
                Template template = templateStorage.getTemplate(templateID);
                logger.finest("Retrieved template.");
                con = dataSource.getConnection();
                stmt = con.prepareStatement(SQLReadConstants.SQL_INST_INSTANCE_DATA);
                stmt.setLong(1, instanceLogID.getMostSignificantBits());
                stmt.setLong(2, instanceLogID.getLeastSignificantBits());
                rs = stmt.executeQuery();
                rs.next();
                rs.getLong(16);
                UUID baseTemplateID = rs.wasNull() ? null : new UUID(rs.getLong(16), rs.getLong(17));
                long creationTime = rs.getLong(11);
                if (rs.wasNull()) {
                    creationTime = 0L;
                }
                String instanceName = SQLHelp.getString(rs, 10);
                boolean isModified = rs.getBoolean(9);
                QualifiedAgent supervisorAgent = new QualifiedAgent(rs.getLong(12), SQLHelp.getString(rs, 13), rs.getLong(14), SQLHelp.getString(rs, 15));
                QualifiedAgent initiatorAgent = new QualifiedAgent(rs.getLong(5), SQLHelp.getString(rs, 6), rs.getLong(7), SQLHelp.getString(rs, 8));
                rs = JDBCTools.close(rs);
                stmt = JDBCTools.close(stmt);
                logger.finest("Retrieved and created complete instance.");
                HashMap<String, String> userAttributes = new HashMap<String, String>();
                stmt = con.prepareStatement(SQLReadConstants.SQL_INST_USER_ATTRIBUTES);
                stmt.setLong(1, instanceLogID.getMostSignificantBits());
                stmt.setLong(2, instanceLogID.getLeastSignificantBits());
                rs = stmt.executeQuery();
                while (rs.next()) {
                    userAttributes.put(SQLHelp.getString(rs, 3), SQLHelp.getString(rs, 4));
                }
                rs = JDBCTools.close(rs);
                stmt = JDBCTools.close(stmt);
                logger.finest("Retrieved user attributes.");
                HashMap<String, Set<String>> supportedPlugins = new HashMap<String, Set<String>>();
                HashMap pluginData = new HashMap();
                stmt = con.prepareStatement(SQLReadConstants.SQL_INST_PLUGIN_DATA);
                stmt.setLong(1, instanceLogID.getMostSignificantBits());
                stmt.setLong(2, instanceLogID.getLeastSignificantBits());
                rs = stmt.executeQuery();
                while (rs.next()) {
                    String extensionPointID = SQLHelp.getString(rs, 4);
                    String pluginID = SQLHelp.getString(rs, 3);
                    if (!supportedPlugins.containsKey(extensionPointID)) {
                        supportedPlugins.put(extensionPointID, new HashSet());
                    }
                    ((Set)supportedPlugins.get(extensionPointID)).add(pluginID);
                    String dataKey = SQLHelp.getString(rs, 1);
                    if (rs.wasNull()) continue;
                    if (!pluginData.containsKey(pluginID)) {
                        pluginData.put(pluginID, new HashMap());
                    }
                    ((Map)pluginData.get(pluginID)).put(dataKey, SQLHelp.getString(rs, 2));
                }
                rs = JDBCTools.close(rs);
                stmt = JDBCTools.close(stmt);
                HashMap<String, PluginData> realPluginData = new HashMap<String, PluginData>();
                for (Map.Entry dat : pluginData.entrySet()) {
                    realPluginData.put((String)dat.getKey(), factory.createPluginData((String)dat.getKey(), (Map)dat.getValue()));
                }
                logger.finest("Retrieved plugins.");
                ArrayList<URI> instanceTerminationCallbackURIs = new ArrayList<URI>();
                stmt = con.prepareStatement(SQLReadConstants.SQL_INST_CALLBACK_URIS);
                stmt.setLong(1, instanceLogID.getMostSignificantBits());
                stmt.setLong(2, instanceLogID.getLeastSignificantBits());
                rs = stmt.executeQuery();
                while (rs.next()) {
                    instanceTerminationCallbackURIs.add(new URI(SQLHelp.getString(rs, 3)));
                }
                rs = JDBCTools.close(rs);
                stmt = JDBCTools.close(stmt);
                URI[] finalInstanceTerminationCallbackURIs = instanceTerminationCallbackURIs.toArray(new URI[instanceTerminationCallbackURIs.size()]);
                if (finalInstanceTerminationCallbackURIs.length == 0) {
                    finalInstanceTerminationCallbackURIs = null;
                }
                logger.finest("Retrieved instance termination callbacks.");
                EBPInstanceReference parentEBPInstanceReference = SQLHelpRead.getParentEBPInstanceReference(instanceLogID, dataSource, con, factory);
                HashMap<Integer, ProcessConstants.NodeState> nodeStates = new HashMap<Integer, ProcessConstants.NodeState>();
                HashMap<Integer, ProcessConstants.ExecutionMode> executionModes = new HashMap<Integer, ProcessConstants.ExecutionMode>();
                HashMap<Integer, Integer> nodeIterations = new HashMap<Integer, Integer>();
                HashMap<Integer, List<UUID>> nodeLWPInstanceIDs = new HashMap<Integer, List<UUID>>();
                HashMap<Integer, QualifiedAgent> nodePerformingAgents = new HashMap<Integer, QualifiedAgent>();
                HashMap<Integer, List<Enquiry>> currentEnquiries = new HashMap<Integer, List<Enquiry>>();
                HashMap<Integer, Enquiry> repliedEnquiries = new HashMap<Integer, Enquiry>();
                HashMap runtimeManagerURIs = new HashMap();
                HashMap<Integer, URI[]> finalRuntimeManagerURIs = new HashMap<Integer, URI[]>();
                stmt = con.prepareStatement("SELECT  nid.InstanceLogIDHigh, nid.InstanceLogIDLow, nid.NodeID, nid.Iteration, nid.ExecutionMode,  nid.State, nid.AgentID, nid.AgentName, nid.OrgPosID, nid.OrgPosName,  runUri.URI, enq.EnquiryIndex, enq.Question, enq.Reply,  lwp.ListIndex, lwp.ChildInstanceIDHigh, lwp.ChildInstanceIDLow FROM PMNodeInstanceData nid   LEFT OUTER JOIN PMNIDRunManURIs runUri     ON nid.InstanceLogIDHigh=runUri.InstanceLogIDHigh     AND nid.InstanceLogIDLow=runUri.InstanceLogIDLow     AND nid.NodeID=runUri.NodeID   LEFT OUTER JOIN PMLWPInstance lwp     ON nid.InstanceLogIDHigh=lwp.InstanceLogIDHigh     AND nid.InstanceLogIDLow=lwp.InstanceLogIDLow     AND nid.NodeID=lwp.NodeID   LEFT OUTER JOIN PMEnquiry enq     ON nid.InstanceLogIDHigh=enq.InstanceLogIDHigh     AND nid.InstanceLogIDLow=enq.InstanceLogIDLow      AND nid.NodeID=enq.NodeID WHERE nid.InstanceLogIDHigh=? AND nid.InstanceLogIDLow=? ORDER BY nid.NodeID, runUri.URI, EnquiryIndex, ListIndex ASC");
                stmt.setLong(1, instanceLogID.getMostSignificantBits());
                stmt.setLong(2, instanceLogID.getLeastSignificantBits());
                rs = stmt.executeQuery();
                if (logService != null) {
                    msg = "SQLHelpRead.getInstance(%s), node %d, iteration %d";
                }
                int previousNodeID = Integer.MIN_VALUE;
                int previousEnquiryIndex = Integer.MIN_VALUE;
                int previousLWPIndex = Integer.MIN_VALUE;
                boolean enquiriesCompleted = false;
                boolean lwpCompleted = false;
                while (rs.next()) {
                    String uriStr;
                    int nodeID = rs.getInt(3);
                    if (nodeID != previousNodeID) {
                        previousNodeID = nodeID;
                        previousEnquiryIndex = Integer.MIN_VALUE;
                        previousLWPIndex = Integer.MIN_VALUE;
                        enquiriesCompleted = false;
                        lwpCompleted = false;
                        int iteration = rs.getInt(4);
                        if (!rs.wasNull()) {
                            nodeIterations.put(nodeID, iteration);
                        }
                        int executionMode = rs.getInt(5);
                        if (!rs.wasNull()) {
                            executionModes.put(nodeID, ProcessConstants.ExecutionMode.valueOf(executionMode));
                        }
                        int state = rs.getInt(6);
                        if (!rs.wasNull()) {
                            nodeStates.put(nodeID, ProcessConstants.NodeState.valueOf(state));
                        }
                        int agentID = rs.getInt(7);
                        if (!rs.wasNull()) {
                            nodePerformingAgents.put(nodeID, new QualifiedAgent(agentID, SQLHelp.getString(rs, 8), rs.getLong(9), SQLHelp.getString(rs, 10)));
                        }
                        if (logService != null) {
                            logService.changeLogContext(String.format(msg, instanceID, nodeID, iteration));
                        }
                    }
                    if ((uriStr = rs.getString(11)) != null && uriStr.length() > 0) {
                        URI uri = new URI(uriStr);
                        ArrayList<URI> uris = (ArrayList<URI>)runtimeManagerURIs.get(nodeID);
                        if (!runtimeManagerURIs.containsKey(nodeID)) {
                            uris = new ArrayList<URI>();
                            runtimeManagerURIs.put(nodeID, uris);
                        }
                        if (!uris.contains(uri)) {
                            uris.add(uri);
                            if (previousEnquiryIndex != Integer.MIN_VALUE) {
                                enquiriesCompleted = true;
                            }
                        }
                    }
                    int enquiryIndex = rs.getInt(12);
                    if (rs.wasNull()) {
                        enquiryIndex = Integer.MIN_VALUE;
                    }
                    if (enquiryIndex != Integer.MIN_VALUE && enquiryIndex != previousEnquiryIndex && !enquiriesCompleted) {
                        Enquiry enquiry;
                        previousEnquiryIndex = enquiryIndex;
                        if (previousLWPIndex != Integer.MIN_VALUE) {
                            lwpCompleted = true;
                        }
                        String enquiryQuestion = SQLHelp.getString(rs, 13);
                        String enquiryReply = SQLHelp.getString(rs, 14);
                        QualifiedAgent originator = null;
                        QualifiedAgent replier = null;
                        HashSet<QualifiedAgent> recipients = new HashSet<QualifiedAgent>();
                        stmtEnquiryQA = con.prepareStatement(SQLReadConstants.SQL_INST_ENQURIRY_QAS);
                        stmtEnquiryQA.setLong(1, instanceLogID.getMostSignificantBits());
                        stmtEnquiryQA.setLong(2, instanceLogID.getLeastSignificantBits());
                        stmtEnquiryQA.setInt(3, nodeID);
                        stmtEnquiryQA.setInt(4, enquiryIndex);
                        rsEnquiryQA = stmtEnquiryQA.executeQuery();
                        while (rsEnquiryQA.next()) {
                            int type = rsEnquiryQA.getInt(7);
                            QualifiedAgent qa = new QualifiedAgent(rsEnquiryQA.getLong(5), SQLHelp.getString(rsEnquiryQA, 8), rsEnquiryQA.getLong(6), SQLHelp.getString(rsEnquiryQA, 9));
                            if (type == 1) {
                                originator = qa;
                                continue;
                            }
                            if (type == 3) {
                                replier = qa;
                                continue;
                            }
                            recipients.add(qa);
                        }
                        rsEnquiryQA = JDBCTools.close(rsEnquiryQA);
                        stmtEnquiryQA = JDBCTools.close(stmtEnquiryQA);
                        if (originator == null) {
                            msg = "Originator of Enquiry %s (%s) of node %s of instance %s (LogID %s) not found!";
                            msg = String.format(msg, enquiryIndex, enquiryQuestion, nodeID, instanceID, instanceLogID);
                            logger.severe(msg);
                            throw new DataSourceException(msg);
                        }
                        if (replier == null) {
                            enquiry = executionFactory.createEnquiry(originator, recipients, enquiryQuestion);
                            if (!currentEnquiries.containsKey(nodeID)) {
                                currentEnquiries.put(nodeID, new ArrayList());
                            }
                            ((List)currentEnquiries.get(nodeID)).add(enquiry);
                        } else {
                            enquiry = executionFactory.createEnquiry(originator, recipients, enquiryQuestion, enquiryReply, replier);
                            repliedEnquiries.put(nodeID, enquiry);
                        }
                    }
                    logger.finest("Retrieved enquiries.");
                    int lwpIndex = rs.getInt(15);
                    if (rs.wasNull()) {
                        lwpIndex = Integer.MIN_VALUE;
                    }
                    if (lwpIndex != Integer.MIN_VALUE && lwpIndex != previousLWPIndex && !lwpCompleted) {
                        UUID lwpID;
                        previousLWPIndex = lwpIndex;
                        ArrayList<UUID> lwpIDs = (ArrayList<UUID>)nodeLWPInstanceIDs.get(nodeID);
                        if (lwpIDs == null) {
                            lwpIDs = new ArrayList<UUID>();
                            nodeLWPInstanceIDs.put(nodeID, lwpIDs);
                        }
                        if (!lwpIDs.contains(lwpID = new UUID(rs.getLong(16), rs.getLong(17)))) {
                            lwpIDs.add(lwpID);
                        }
                    }
                    logger.finest("Retrieved LWP instance IDs.");
                }
                rs = JDBCTools.close(rs);
                stmt = JDBCTools.close(stmt);
                if (logService != null) {
                    logService.revertLogContextChanges();
                }
                logger.finest("Retrieved nodes.");
                for (Map.Entry e : runtimeManagerURIs.entrySet()) {
                    finalRuntimeManagerURIs.put((Integer)e.getKey(), ((List)e.getValue()).toArray(new URI[((List)e.getValue()).size()]));
                }
                res = executionFactory.createExecutableInstance(instanceID, instanceLogID, instanceName, isModified, baseTemplateID, template, supervisorAgent, initiatorAgent, parentEBPInstanceReference, creationTime, nodeStates, executionModes, nodeIterations, nodeLWPInstanceIDs, nodePerformingAgents, currentEnquiries, repliedEnquiries, finalInstanceTerminationCallbackURIs, finalRuntimeManagerURIs, supportedPlugins, realPluginData, userAttributes);
                con = JDBCTools.close(con);
            }
            catch (SQLException e) {
                throw new DataSourceException("SQLException", e);
            }
            catch (URISyntaxException e) {
                throw new DataSourceException("URISyntaxException", e);
            }
        }
        catch (Throwable throwable) {
            JDBCTools.closeQuietly(stmtEnquiryQA, rsEnquiryQA);
            JDBCTools.closeQuietly(con, (Statement)stmt, rs);
            throw throwable;
        }
        JDBCTools.closeQuietly(stmtEnquiryQA, rsEnquiryQA);
        JDBCTools.closeQuietly(con, (Statement)stmt, rs);
        logger.finer("SQLHelpRead.Instance() exit");
        return res;
    }

    public static EBPInstanceReference getParentEBPInstanceReference(UUID instanceLogID, JDBCDataSource dataSource, ExtendedConnection con, ProcessModelFactory factory) throws DataSourceException {
        EBPInstanceReference res;
        logger.finer("SQLHelpRead.getParentEBPInstanceReference() entry");
        boolean ownConnection = con == null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        PreparedStatement stmtInner = null;
        ResultSet rsInner = null;
        try {
            try {
                if (ownConnection) {
                    con = dataSource.getConnection();
                }
                ArrayList<URI> runtimeURIs = new ArrayList<URI>();
                stmt = con.prepareStatement(SQLReadConstants.SQL_INST_PARENT_EBP_RUNTIME_URLS);
                stmt.setLong(1, instanceLogID.getMostSignificantBits());
                stmt.setLong(2, instanceLogID.getLeastSignificantBits());
                rs = stmt.executeQuery();
                while (rs.next()) {
                    runtimeURIs.add(new URI(SQLHelp.getString(rs, 3)));
                }
                rs = JDBCTools.close(rs);
                stmt = JDBCTools.close(stmt);
                ArrayList<URI> executionURIs = new ArrayList<URI>();
                stmt = con.prepareStatement(SQLReadConstants.SQL_INST_PARENT_EBP_EXECUTION_URLS);
                stmt.setLong(1, instanceLogID.getMostSignificantBits());
                stmt.setLong(2, instanceLogID.getLeastSignificantBits());
                rs = stmt.executeQuery();
                while (rs.next()) {
                    executionURIs.add(new URI(SQLHelp.getString(rs, 3)));
                }
                rs = JDBCTools.close(rs);
                stmt = JDBCTools.close(stmt);
                stmt = con.prepareStatement(SQLReadConstants.SQL_INST_PARENT_EBP);
                stmt.setLong(1, instanceLogID.getMostSignificantBits());
                stmt.setLong(2, instanceLogID.getLeastSignificantBits());
                rs = stmt.executeQuery();
                if (rs.next()) {
                    UUID referencedInstanceID = new UUID(rs.getLong(7), rs.getLong(8));
                    stmtInner = con.prepareStatement(SQLReadConstants.SQL_INST_PARENT_EBP_BASE_TEMPLATE_ID);
                    stmtInner.setLong(1, referencedInstanceID.getMostSignificantBits());
                    stmtInner.setLong(2, referencedInstanceID.getLeastSignificantBits());
                    rsInner = stmtInner.executeQuery();
                    rsInner.next();
                    UUID baseTemplateID = new UUID(rsInner.getLong(1), rsInner.getLong(2));
                    rsInner = JDBCTools.close(rsInner);
                    stmtInner = JDBCTools.close(stmtInner);
                    res = runtimeURIs.size() > 0 ? factory.createEBPInstanceReference(EBPType.valueOf(rs.getByte(3)), referencedInstanceID, baseTemplateID, rs.getInt(6), rs.getInt(4), rs.getBoolean(5), executionURIs.toArray(new URI[executionURIs.size()]), runtimeURIs.toArray(new URI[runtimeURIs.size()])) : factory.createEBPInstanceReference(EBPType.valueOf(rs.getByte(3)), referencedInstanceID, baseTemplateID, rs.getInt(6), rs.getInt(4), rs.getBoolean(5), executionURIs.toArray(new URI[executionURIs.size()]));
                } else {
                    res = null;
                }
                rs = JDBCTools.close(rs);
                stmt = JDBCTools.close(stmt);
                if (ownConnection) {
                    con = JDBCTools.close(con);
                }
            }
            catch (SQLException e) {
                throw new DataSourceException("SQLException", e);
            }
            catch (URISyntaxException e) {
                throw new DataSourceException("URISyntaxException", e);
            }
        }
        catch (Throwable throwable) {
            JDBCTools.closeQuietly(stmtInner, rsInner);
            if (ownConnection) {
                JDBCTools.closeQuietly(con, (Statement)stmt, rs);
            } else {
                JDBCTools.closeQuietly(stmt, rs);
            }
            throw throwable;
        }
        JDBCTools.closeQuietly((Statement)stmtInner, rsInner);
        if (ownConnection) {
            JDBCTools.closeQuietly(con, (Statement)stmt, rs);
        } else {
            JDBCTools.closeQuietly((Statement)stmt, rs);
        }
        logger.finer("SQLHelpRead.getParentEBPInstanceReference() exit");
        return res;
    }

    public static InstanceStatus getInstanceStatus(UUID instanceID, JDBCDataSource dataSource, ExtendedConnection con, ProcessModelFactory factory) throws DataSourceException {
        InstanceStatus res;
        logger.finer("SQLHelpRead.getInstanceStatus() entry");
        boolean ownConnection = con == null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            try {
                if (ownConnection) {
                    con = dataSource.getConnection();
                }
                stmt = con.prepareStatement(SQLReadConstants.SQL_INSTANCE_STATUS);
                stmt.setLong(1, instanceID.getMostSignificantBits());
                stmt.setLong(2, instanceID.getLeastSignificantBits());
                rs = stmt.executeQuery();
                if (!rs.next()) {
                    String msg = String.format("InstanceStatus for instance %s not found!", instanceID);
                    throw new IllegalArgumentException(msg);
                }
                res = factory.createInstanceStatus(instanceID, ProcessConstants.InstanceMigrationStatus.valueOf(rs.getInt(3)), SQLHelp.getString(rs, 4), ProcessConstants.InstanceExecutionStatus.valueOf(rs.getInt(5)), SQLHelp.getString(rs, 6));
                rs = JDBCTools.close(rs);
                stmt = JDBCTools.close(stmt);
                if (ownConnection) {
                    con = JDBCTools.close(con);
                }
            }
            catch (SQLException e) {
                throw new DataSourceException("SQLException", e);
            }
        }
        catch (Throwable throwable) {
            if (ownConnection) {
                JDBCTools.closeQuietly(con, (Statement)stmt, rs);
            } else {
                JDBCTools.closeQuietly((Statement)stmt, rs);
            }
            throw throwable;
        }
        if (ownConnection) {
            JDBCTools.closeQuietly(con, (Statement)stmt, rs);
        } else {
            JDBCTools.closeQuietly((Statement)stmt, rs);
        }
        logger.finer("SQLHelpRead.getInstanceStatus() exit");
        return res;
    }

    public static InstanceReference getInstanceReference(UUID instanceID, TemplateStorage templateStorage, TemplateStatusProvider statusProvider, JDBCDataSource dataSource, ProcessModelFactory factory) throws DataSourceException {
        InstanceReference res;
        logger.finer("SQLHelpRead.getInstanceReference() entry");
        PreparedStatement stmt = null;
        ResultSet rs = null;
        ExtendedConnection con = null;
        try {
            try {
                con = dataSource.getConnection();
                stmt = con.prepareStatement(SQLReadConstants.SQL_INST_GET_LOG_ID);
                stmt.setLong(1, instanceID.getMostSignificantBits());
                stmt.setLong(2, instanceID.getLeastSignificantBits());
                rs = stmt.executeQuery();
                if (!rs.next()) {
                    String msg = String.format("Instance with id %s not found!", instanceID);
                    throw new IllegalArgumentException(msg);
                }
                UUID instanceLogID = new UUID(rs.getLong(1), rs.getLong(2));
                rs = JDBCTools.close(rs);
                stmt = JDBCTools.close(stmt);
                stmt = con.prepareStatement(SQLReadConstants.SQL_INST_FIND_TEMPLATE_ID);
                stmt.setLong(1, instanceID.getMostSignificantBits());
                stmt.setLong(2, instanceID.getLeastSignificantBits());
                rs = stmt.executeQuery();
                rs.next();
                UUID templateID = new UUID(rs.getLong(1), rs.getLong(2));
                rs = JDBCTools.close(rs);
                stmt = JDBCTools.close(stmt);
                con = JDBCTools.close(con);
                TemplateReference templateReference = templateStorage.getTemplateReference(templateID, statusProvider);
                con = dataSource.getConnection();
                HashMap<String, Set<String>> supportedPlugins = new HashMap<String, Set<String>>();
                HashMap pluginData = new HashMap();
                stmt = con.prepareStatement(SQLReadConstants.SQL_INST_PLUGIN_DATA);
                stmt.setLong(1, instanceLogID.getMostSignificantBits());
                stmt.setLong(2, instanceLogID.getLeastSignificantBits());
                rs = stmt.executeQuery();
                while (rs.next()) {
                    String extensionPointID = SQLHelp.getString(rs, 4);
                    String pluginID = SQLHelp.getString(rs, 3);
                    if (!supportedPlugins.containsKey(extensionPointID)) {
                        supportedPlugins.put(extensionPointID, new HashSet());
                    }
                    ((Set)supportedPlugins.get(extensionPointID)).add(pluginID);
                    String dataKey = SQLHelp.getString(rs, 1);
                    if (rs.wasNull()) continue;
                    if (!pluginData.containsKey(pluginID)) {
                        pluginData.put(pluginID, new HashMap());
                    }
                    ((Map)pluginData.get(pluginID)).put(dataKey, SQLHelp.getString(rs, 2));
                }
                rs = JDBCTools.close(rs);
                stmt = JDBCTools.close(stmt);
                HashMap<String, PluginData> realPluginData = new HashMap<String, PluginData>();
                for (Map.Entry dat : pluginData.entrySet()) {
                    realPluginData.put((String)dat.getKey(), factory.createPluginData((String)dat.getKey(), (Map)dat.getValue()));
                }
                HashMap<String, String> userAttributes = new HashMap<String, String>();
                stmt = con.prepareStatement(SQLReadConstants.SQL_INST_USER_ATTRIBUTES);
                stmt.setLong(1, instanceLogID.getMostSignificantBits());
                stmt.setLong(2, instanceLogID.getLeastSignificantBits());
                rs = stmt.executeQuery();
                while (rs.next()) {
                    userAttributes.put(SQLHelp.getString(rs, 3), SQLHelp.getString(rs, 4));
                }
                rs = JDBCTools.close(rs);
                stmt = JDBCTools.close(stmt);
                stmt = con.prepareStatement(SQLReadConstants.SQL_INSTANCE_REFERENCE);
                stmt.setLong(1, instanceID.getMostSignificantBits());
                stmt.setLong(2, instanceID.getLeastSignificantBits());
                rs = stmt.executeQuery();
                if (!rs.next()) {
                    String msg = String.format("Instance with ID %s not found!", instanceID);
                    throw new IllegalArgumentException(msg);
                }
                int statusOffset = SQLConstants.COL_INSTANCE_ALL.length;
                int parentOffset = statusOffset + SQLConstants.COL_INSTANCESTATUS_ALL.length;
                UUID parentInstanceID = null;
                rs.getLong(parentOffset + 7);
                if (!rs.wasNull()) {
                    parentInstanceID = new UUID(rs.getLong(parentOffset + 7), rs.getLong(parentOffset + 8));
                }
                int executionStatus = rs.getInt(statusOffset + 5);
                if (rs.wasNull()) {
                    String msg = String.format("InstanceStatus with ID %s not found!", instanceID);
                    throw new IllegalArgumentException(msg);
                }
                res = factory.createInstanceReference(new UUID(rs.getLong(3), rs.getLong(4)), new UUID(rs.getLong(1), rs.getLong(2)), SQLHelp.getString(rs, 10), rs.getBoolean(9), templateReference, new QualifiedAgent(rs.getLong(12), SQLHelp.getString(rs, 13), rs.getLong(14), SQLHelp.getString(rs, 15)), new QualifiedAgent(rs.getLong(5), SQLHelp.getString(rs, 6), rs.getLong(7), SQLHelp.getString(rs, 8)), rs.getLong(11), parentInstanceID, ProcessConstants.InstanceExecutionStatus.valueOf(executionStatus), supportedPlugins, realPluginData, userAttributes);
                rs = JDBCTools.close(rs);
                stmt = JDBCTools.close(stmt);
                con = JDBCTools.close(con);
            }
            catch (SQLException e) {
                throw new DataSourceException("SQLException", e);
            }
        }
        catch (Throwable throwable) {
            JDBCTools.closeQuietly(con, stmt, rs);
            throw throwable;
        }
        JDBCTools.closeQuietly(con, (Statement)stmt, rs);
        logger.finer("SQLHelpRead.getInstanceReference() exit");
        return res;
    }
}

