/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.core.processmanager.storage.sqlstorage.atomic;

import de.aristaflow.adept2.base.dbaccess.ExtendedConnection;
import de.aristaflow.adept2.base.dbaccess.JDBCDataSource;
import de.aristaflow.adept2.base.dbaccess.JDBCTools;
import de.aristaflow.adept2.base.sessionmanagement.QualifiedAgent;
import de.aristaflow.adept2.core.processmanager.storage.TemplateStorage;
import de.aristaflow.adept2.core.processmanager.storage.sqlstorage.atomic.ComplexSelectGenerator;
import de.aristaflow.adept2.core.processmanager.storage.sqlstorage.atomic.SQLConstants;
import de.aristaflow.adept2.core.processmanager.storage.sqlstorage.atomic.SQLHelp;
import de.aristaflow.adept2.core.processmanager.storage.sqlstorage.atomic.SQLWriteConstants;
import de.aristaflow.adept2.model.common.ConfigurationDescription;
import de.aristaflow.adept2.model.common.PluginData;
import de.aristaflow.adept2.model.execution.Enquiry;
import de.aristaflow.adept2.model.execution.ExecutableInstance;
import de.aristaflow.adept2.model.execution.ExecutableInstancePropertyTracker;
import de.aristaflow.adept2.model.globals.ActivityConstants;
import de.aristaflow.adept2.model.globals.ProcessConstants;
import de.aristaflow.adept2.model.processmodel.Activity;
import de.aristaflow.adept2.model.processmodel.DataElement;
import de.aristaflow.adept2.model.processmodel.DecisionActivity;
import de.aristaflow.adept2.model.processmodel.EBPInstanceReference;
import de.aristaflow.adept2.model.processmodel.EmbeddedProcess;
import de.aristaflow.adept2.model.processmodel.ExecutableBusinessProcess;
import de.aristaflow.adept2.model.processmodel.InstanceStatus;
import de.aristaflow.adept2.model.processmodel.LightWeightProcess;
import de.aristaflow.adept2.model.processmodel.Node;
import de.aristaflow.adept2.model.processmodel.ProcessModelParameter;
import de.aristaflow.adept2.model.processmodel.ReferencedProcess;
import de.aristaflow.adept2.model.processmodel.StructuredDataEdge;
import de.aristaflow.adept2.model.processmodel.StructuredEdge;
import de.aristaflow.adept2.model.processmodel.Template;
import de.aristaflow.adept2.model.processmodel.TemplateStatus;
import de.aristaflow.adept2.model.processmodel.VariableParallelismEBP;
import de.aristaflow.adept2.util.DataSourceException;
import de.aristaflow.adept2.util.LoggerTools;
import de.aristaflow.adept2.util.StringTools;
import de.aristaflow.adept2.util.types.Pair;
import de.aristaflow.adept2.util.types.Triple;
import java.net.URI;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.logging.Logger;

public class SQLHelpWrite {
    private static Logger logger = LoggerTools.getLogger(SQLHelpWrite.class);

    public SQLHelpWrite(Logger logger) {
        SQLHelpWrite.logger = logger;
    }

    private static boolean entryExists(ExtendedConnection con, String table, String[] fields, SQLHelp.ParameterList values) throws SQLException {
        boolean res;
        logger.finest("SQLHelpWrite.entryExists() entry");
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            stmt = con.prepareStatement(SQLHelp.SimpleQueryGenerator.generateSelect(table, fields, fields));
            values.insertParameters(stmt);
            rs = stmt.executeQuery();
            res = rs.next();
            rs = JDBCTools.close(rs);
            stmt = JDBCTools.close(stmt);
        }
        catch (Throwable throwable) {
            JDBCTools.closeQuietly(stmt, rs);
            throw throwable;
        }
        JDBCTools.closeQuietly((Statement)stmt, rs);
        logger.finest("SQLHelpWrite.entryExists() exit");
        return res;
    }

    public static boolean insertOrUpdateSubProcess(JDBCDataSource dataSource, Template template, Node node, ExecutableBusinessProcess ebp, Map<String, ProcessModelParameter> indexedInputParameters, ExtendedConnection con, boolean doCommit) throws DataSourceException {
        logger.finer("SQLHelpWrite.insertOrUpdateSubProcess() entry");
        boolean ownConnection = con == null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        boolean isVarPar = false;
        try {
            try {
                String value;
                String msg;
                LightWeightProcess lwp;
                if (ownConnection) {
                    con = dataSource.getConnection();
                }
                con.setAutoCommit(false);
                boolean insert = !SQLHelpWrite.entryExists(con, "PMSubProcess", SQLConstants.COL_SUBPROCESS_PK, new SQLHelp.ParameterList(new int[]{4, -5, -5}, new Object[]{node.getID(), template.getID().getMostSignificantBits(), template.getID().getLeastSignificantBits()}));
                stmt = insert ? con.prepareStatement(SQLHelp.SimpleQueryGenerator.generateInsert("PMSubProcess", SQLConstants.COL_SUBPROCESS_ALL)) : con.prepareStatement(SQLHelp.SimpleQueryGenerator.generateUpdate("PMSubProcess", SQLConstants.COL_SUBPROCESS_ALL, SQLConstants.COL_SUBPROCESS_PK));
                if (ebp instanceof LightWeightProcess) {
                    lwp = (LightWeightProcess)ebp;
                } else if (ebp instanceof VariableParallelismEBP) {
                    VariableParallelismEBP varPar = (VariableParallelismEBP)ebp;
                    lwp = varPar.getLightWeightProcess();
                    isVarPar = true;
                    for (ProcessModelParameter processModelParameter : varPar.getIndexedInputParameters()) {
                        indexedInputParameters.put(processModelParameter.getName(), processModelParameter);
                    }
                } else {
                    String msg2 = String.format("Format of SubProcess unknown!", new Object[0]);
                    logger.severe(msg2);
                    throw new DataSourceException(msg2);
                }
                stmt.setInt(1, node.getID());
                stmt.setLong(2, template.getID().getMostSignificantBits());
                stmt.setLong(3, template.getID().getLeastSignificantBits());
                if (lwp instanceof EmbeddedProcess) {
                    EmbeddedProcess ep = (EmbeddedProcess)lwp;
                    stmt.setLong(4, ep.getTemplateID().getMostSignificantBits());
                    stmt.setLong(5, ep.getTemplateID().getLeastSignificantBits());
                    stmt.setBoolean(6, isVarPar);
                    stmt.setInt(7, 3);
                } else if (lwp instanceof ReferencedProcess) {
                    ReferencedProcess rp = (ReferencedProcess)lwp;
                    stmt.setLong(4, rp.getTemplateID().getMostSignificantBits());
                    stmt.setLong(5, rp.getTemplateID().getLeastSignificantBits());
                    stmt.setBoolean(6, isVarPar);
                    if (rp.fork()) {
                        stmt.setInt(7, 2);
                    } else {
                        stmt.setInt(7, 1);
                    }
                } else {
                    msg = String.format("Format of SubProcess unknown!", new Object[0]);
                    logger.severe(msg);
                    throw new DataSourceException(msg);
                }
                if (!insert) {
                    stmt.setInt(8, node.getID());
                    stmt.setLong(9, template.getID().getMostSignificantBits());
                    stmt.setLong(10, template.getID().getLeastSignificantBits());
                }
                stmt.execute();
                if (stmt.getUpdateCount() == 0) {
                    msg = String.format("%s of SubProcess (ActivityTypeID: %s) of node %s of template (%s) failed.", insert ? "Insert" : "Update", "LWP", node.getID(), template.getID());
                    logger.severe(msg);
                    throw new DataSourceException(msg);
                }
                stmt = JDBCTools.close(stmt);
                if (isVarPar) {
                    stmt = con.prepareStatement(SQLHelp.SimpleQueryGenerator.generateSelect("PMEBPUserAttributes", SQLConstants.COL_EBPUSERATTRIBUTES_ID, SQLConstants.COL_EBPUSERATTRIBUTES_PARENT_ID));
                    stmt.setInt(1, node.getID());
                    stmt.setLong(2, template.getID().getMostSignificantBits());
                    stmt.setLong(3, template.getID().getLeastSignificantBits());
                    stmt.setBoolean(4, true);
                    rs = stmt.executeQuery();
                    HashSet<String> lwpUAsToDelete = new HashSet<String>();
                    while (rs.next()) {
                        lwpUAsToDelete.add(SQLHelp.getString(rs, 1));
                    }
                    rs = JDBCTools.close(rs);
                    stmt = JDBCTools.close(stmt);
                    for (Map.Entry<String, String> entry : lwp.getUserAttributes().entrySet()) {
                        boolean bl = !lwpUAsToDelete.remove(entry.getKey());
                        stmt = bl ? con.prepareStatement(SQLHelp.SimpleQueryGenerator.generateInsert("PMEBPUserAttributes", SQLConstants.COL_EBPUSERATTRIBUTES_ALL)) : con.prepareStatement(SQLHelp.SimpleQueryGenerator.generateUpdate("PMEBPUserAttributes", SQLConstants.COL_EBPUSERATTRIBUTES_ALL, SQLConstants.COL_EBPUSERATTRIBUTES_PK));
                        stmt.setInt(1, node.getID());
                        stmt.setLong(2, template.getID().getMostSignificantBits());
                        stmt.setLong(3, template.getID().getLeastSignificantBits());
                        stmt.setBoolean(4, true);
                        stmt.setString(5, entry.getKey());
                        stmt.setString(6, entry.getValue());
                        if (!bl) {
                            stmt.setInt(7, node.getID());
                            stmt.setLong(8, template.getID().getMostSignificantBits());
                            stmt.setLong(9, template.getID().getLeastSignificantBits());
                            stmt.setBoolean(10, true);
                            stmt.setString(11, entry.getKey());
                        }
                        stmt.execute();
                        if (stmt.getUpdateCount() == 0) {
                            String msg3 = String.format("%s of userAttribute %s of EBP (ActivityTypeID: %s) of node %s of template (%s) failed.", bl ? "Insert" : "Update", entry.getKey(), "LWP", node.getID(), template.getID());
                            logger.severe(msg3);
                            throw new DataSourceException(msg3);
                        }
                        stmt = JDBCTools.close(stmt);
                    }
                    for (String string : lwpUAsToDelete) {
                        stmt = con.prepareStatement(SQLHelp.SimpleQueryGenerator.generateDelete("PMEBPUserAttributes", SQLConstants.COL_EBPUSERATTRIBUTES_PK));
                        stmt.setInt(1, node.getID());
                        stmt.setLong(2, template.getID().getMostSignificantBits());
                        stmt.setLong(3, template.getID().getLeastSignificantBits());
                        stmt.setBoolean(4, true);
                        stmt.setString(5, string);
                        stmt.execute();
                        if (stmt.getUpdateCount() == 0) {
                            String string2 = String.format("Deletion of UserAttribute %s of EBP (ActivityTypeID: %s) of node %s of template (%s) failed.", string, "LWP", node.getID(), template.getID());
                            logger.severe(string2);
                            throw new DataSourceException(string2);
                        }
                        stmt = JDBCTools.close(stmt);
                    }
                    stmt = con.prepareStatement(SQLHelp.SimpleQueryGenerator.generateSelect("PMEBPPlugins", SQLConstants.COL_EBPPLUGINS_ID, SQLConstants.COL_EBPPLUGINS_PARENT_ID));
                    stmt.setInt(1, node.getID());
                    stmt.setLong(2, template.getID().getMostSignificantBits());
                    stmt.setLong(3, template.getID().getLeastSignificantBits());
                    stmt.setBoolean(4, true);
                    rs = stmt.executeQuery();
                    HashSet<Triple<String, String, String>> hashSet = new HashSet<Triple<String, String, String>>();
                    while (rs.next()) {
                        Triple<String, String, String> triple = new Triple<String, String, String>(SQLHelp.getString(rs, 1), SQLHelp.getString(rs, 2), SQLHelp.getString(rs, 3));
                        hashSet.add(triple);
                    }
                    rs = JDBCTools.close(rs);
                    stmt = JDBCTools.close(stmt);
                    for (Map.Entry<String, Set<String>> entry : lwp.getSupportedPlugins().entrySet()) {
                        for (String pluginID : entry.getValue()) {
                            Map<String, String> dataMap;
                            PluginData data = lwp.getPluginData(pluginID);
                            if (data != null) {
                                dataMap = data.getPluginData();
                            } else {
                                dataMap = new HashMap<String, String>();
                                dataMap.put(null, null);
                            }
                            for (Map.Entry<String, String> dataRow : dataMap.entrySet()) {
                                Triple<String, String, String> t = new Triple<String, String, String>(dataRow.getKey(), pluginID, entry.getKey());
                                boolean insertPlugin = !hashSet.remove(t);
                                stmt = insertPlugin ? con.prepareStatement(SQLHelp.SimpleQueryGenerator.generateInsert("PMEBPPlugins", SQLConstants.COL_EBPPLUGINS_ALL)) : con.prepareStatement(SQLHelp.SimpleQueryGenerator.generateUpdate("PMEBPPlugins", SQLConstants.COL_EBPPLUGINS_ALL, SQLConstants.COL_EBPPLUGINS_PK));
                                stmt.setInt(1, node.getID());
                                stmt.setLong(2, template.getID().getMostSignificantBits());
                                stmt.setLong(3, template.getID().getLeastSignificantBits());
                                stmt.setString(4, pluginID);
                                stmt.setString(5, entry.getKey());
                                stmt.setString(6, dataRow.getKey());
                                stmt.setString(7, dataRow.getValue());
                                stmt.setBoolean(8, true);
                                if (!insertPlugin) {
                                    stmt.setInt(9, node.getID());
                                    stmt.setLong(10, template.getID().getMostSignificantBits());
                                    stmt.setLong(11, template.getID().getLeastSignificantBits());
                                    stmt.setString(12, pluginID);
                                    stmt.setString(13, entry.getKey());
                                    stmt.setString(14, dataRow.getKey());
                                    stmt.setBoolean(15, true);
                                }
                                stmt.execute();
                                if (stmt.getUpdateCount() == 0) {
                                    String msg5 = String.format("%s of plugin data %s of ebp of node (%s) of template %s failed.", insertPlugin ? "Insert" : "Update", null, node.getID(), template.getID());
                                    logger.severe(msg5);
                                    throw new DataSourceException(msg5);
                                }
                                stmt = JDBCTools.close(stmt);
                            }
                        }
                    }
                    for (Triple triple : hashSet) {
                        stmt = con.prepareStatement(SQLHelp.SimpleQueryGenerator.generateDelete("PMEBPPlugins", SQLConstants.COL_EBPPLUGINS_PK));
                        stmt.setInt(1, node.getID());
                        stmt.setLong(2, template.getID().getMostSignificantBits());
                        stmt.setLong(3, template.getID().getLeastSignificantBits());
                        stmt.setString(4, (String)triple.getSecond());
                        stmt.setString(5, (String)triple.getThird());
                        stmt.setString(6, (String)triple.getFirst());
                        stmt.setBoolean(7, true);
                        stmt.execute();
                        if (stmt.getUpdateCount() == 0) {
                            String msg6 = String.format("Deletion of plugin data %s of plugin %s (ExtensionPointID: %s) of ebp of node %s of template %s failed.", triple.getFirst(), triple.getSecond(), triple.getThird(), node.getID(), template.getID());
                            logger.severe(msg6);
                            throw new DataSourceException(msg6);
                        }
                        stmt = JDBCTools.close(stmt);
                    }
                }
                HashMap configurationsToDelete = new HashMap();
                stmt = con.prepareStatement(SQLHelp.SimpleQueryGenerator.generateSelect("PMEBPConfiguration", SQLConstants.COL_EBPCONFIGURATION_ID, SQLConstants.COL_EBPCONFIGURATION_PARENT_ID));
                stmt.setInt(1, node.getID());
                stmt.setLong(2, template.getID().getMostSignificantBits());
                stmt.setLong(3, template.getID().getLeastSignificantBits());
                rs = stmt.executeQuery();
                while (rs.next()) {
                    if (!configurationsToDelete.containsKey(rs.getInt(1))) {
                        configurationsToDelete.put(rs.getInt(1), new HashSet());
                    }
                    ((Set)configurationsToDelete.get(rs.getInt(1))).add(SQLHelp.getString(rs, 2));
                }
                rs = JDBCTools.close(rs);
                stmt = JDBCTools.close(stmt);
                HashMap hashMap = new HashMap();
                HashMap hashMap2 = new HashMap();
                for (String string : lwp.getConfiguration().getAllEntries()) {
                    value = lwp.getConfiguration().getString(string);
                    int type = 1;
                    if (!hashMap.containsKey(type)) {
                        hashMap.put(type, new HashMap());
                    }
                    ((Map)hashMap.get(type)).put(string, value);
                    if (!hashMap2.containsKey(type)) {
                        hashMap2.put(type, new HashSet());
                    }
                    if (!lwp.getConfiguration().isFixed(string)) continue;
                    ((Set)hashMap2.get(type)).add(string);
                }
                for (String string : lwp.getTestConfiguration().getAllEntries()) {
                    value = lwp.getTestConfiguration().getString(string);
                    int type = 4;
                    if (!hashMap.containsKey(type)) {
                        hashMap.put(type, new HashMap());
                    }
                    ((Map)hashMap.get(type)).put(string, value);
                    if (!hashMap2.containsKey(type)) {
                        hashMap2.put(type, new HashSet());
                    }
                    if (!lwp.getTestConfiguration().isFixed(string)) continue;
                    ((Set)hashMap2.get(type)).add(string);
                }
                for (Map.Entry entry : hashMap.entrySet()) {
                    for (Map.Entry data : ((Map)entry.getValue()).entrySet()) {
                        if (configurationsToDelete.containsKey(entry.getKey()) && ((Set)configurationsToDelete.get(entry.getKey())).contains(data.getKey())) {
                            ((Set)configurationsToDelete.get(entry.getKey())).remove(data.getKey());
                        }
                        boolean insertConf = !SQLHelpWrite.entryExists(con, "PMEBPConfiguration", SQLConstants.COL_EBPCONFIGURATION_PK, new SQLHelp.ParameterList(new int[]{4, -5, -5, 4, 12}, new Object[]{node.getID(), template.getID().getMostSignificantBits(), template.getID().getLeastSignificantBits(), entry.getKey(), data.getKey()}));
                        stmt = insertConf ? con.prepareStatement(SQLHelp.SimpleQueryGenerator.generateInsert("PMEBPConfiguration", SQLConstants.COL_EBPCONFIGURATION_ALL)) : con.prepareStatement(SQLHelp.SimpleQueryGenerator.generateUpdate("PMEBPConfiguration", SQLConstants.COL_EBPCONFIGURATION_ALL, SQLConstants.COL_EBPCONFIGURATION_PK));
                        stmt.setInt(1, node.getID());
                        stmt.setLong(2, template.getID().getMostSignificantBits());
                        stmt.setLong(3, template.getID().getLeastSignificantBits());
                        stmt.setInt(4, (Integer)entry.getKey());
                        stmt.setString(5, (String)data.getKey());
                        stmt.setString(6, (String)data.getValue());
                        stmt.setBoolean(7, ((Set)hashMap2.get(entry.getKey())).contains(data.getKey()));
                        if (!insertConf) {
                            stmt.setInt(8, node.getID());
                            stmt.setLong(9, template.getID().getMostSignificantBits());
                            stmt.setLong(10, template.getID().getLeastSignificantBits());
                            stmt.setInt(11, (Integer)entry.getKey());
                            stmt.setString(12, (String)data.getKey());
                        }
                        stmt.execute();
                        if (stmt.getUpdateCount() == 0) {
                            String msg7 = String.format("%s of Configuration %s (Type: %s)of ebp of node %s of template (%s) failed.", insertConf ? "Insert" : "Update", data.getKey(), ((Integer)entry.getKey()).toString(), node.getID(), template.getID());
                            logger.severe(msg7);
                            throw new DataSourceException(msg7);
                        }
                        stmt = JDBCTools.close(stmt);
                    }
                }
                for (Map.Entry entry : configurationsToDelete.entrySet()) {
                    for (String dataKey : (Set)entry.getValue()) {
                        stmt = con.prepareStatement(SQLHelp.SimpleQueryGenerator.generateDelete("PMEBPConfiguration", SQLConstants.COL_EBPCONFIGURATION_PK));
                        stmt.setInt(1, node.getID());
                        stmt.setLong(2, template.getID().getMostSignificantBits());
                        stmt.setLong(3, template.getID().getLeastSignificantBits());
                        stmt.setInt(4, (Integer)entry.getKey());
                        stmt.setString(5, dataKey);
                        stmt.execute();
                        if (stmt.getUpdateCount() != 0) continue;
                        String msg8 = String.format("Deletion of Configuration %s (Type %s) of ebp of node %s of template %s failed.", dataKey, ((Integer)entry.getKey()).toString(), node.getID(), template.getID());
                        logger.severe(msg8);
                        throw new DataSourceException(msg8);
                    }
                    stmt = JDBCTools.close(stmt);
                }
                if (ownConnection) {
                    con = JDBCTools.close(con);
                } else if (doCommit) {
                    con = JDBCTools.commit(con);
                }
            }
            catch (SQLException e) {
                throw new DataSourceException("SQLException", e);
            }
        }
        catch (Throwable throwable) {
            if (doCommit) {
                JDBCTools.rollbackQuietly(con);
            }
            if (ownConnection) {
                JDBCTools.closeQuietly(con, stmt, rs);
            } else {
                JDBCTools.closeQuietly(stmt, rs);
            }
            throw throwable;
        }
        if (doCommit) {
            JDBCTools.rollbackQuietly(con);
        }
        if (ownConnection) {
            JDBCTools.closeQuietly(con, (Statement)stmt, rs);
        } else {
            JDBCTools.closeQuietly((Statement)stmt, rs);
        }
        logger.finer("SQLHelpWrite.insertOrUpdateSubProcess() exit");
        return isVarPar;
    }

    public static void insertOrUpdateActivity(JDBCDataSource dataSource, Template template, Node node, ExecutableBusinessProcess ebp, Activity activity, ExtendedConnection con, boolean doCommit) throws DataSourceException {
        logger.finer("SQLHelpWrite.insertOrUpdateActivity() entry");
        boolean ownConnection = con == null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            try {
                String msg;
                Iterator<Object> value;
                if (ownConnection) {
                    con = dataSource.getConnection();
                }
                con.setAutoCommit(false);
                boolean insert = !SQLHelpWrite.entryExists(con, "PMActivity", SQLConstants.COL_ACTIVITY_PK, new SQLHelp.ParameterList(new int[]{4, -5, -5}, new Object[]{node.getID(), template.getID().getMostSignificantBits(), template.getID().getLeastSignificantBits()}));
                stmt = insert ? con.prepareStatement(SQLHelp.SimpleQueryGenerator.generateInsert("PMActivity", SQLConstants.COL_ACTIVITY_ALL)) : con.prepareStatement(SQLHelp.SimpleQueryGenerator.generateUpdate("PMActivity", SQLConstants.COL_ACTIVITY_ALL, SQLConstants.COL_ACTIVITY_PK));
                stmt.setInt(1, node.getID());
                stmt.setLong(2, template.getID().getMostSignificantBits());
                stmt.setLong(3, template.getID().getLeastSignificantBits());
                stmt.setLong(4, activity.getID().getMostSignificantBits());
                stmt.setLong(5, activity.getID().getLeastSignificantBits());
                stmt.setString(6, activity.getActivityName());
                stmt.setString(7, activity.getConfigurationName());
                stmt.setString(8, activity.getDescription());
                stmt.setString(9, activity.getExecutableComponentName());
                stmt.setString(10, activity.getGUIContextID());
                if (activity.getIconID() != null) {
                    stmt.setLong(11, activity.getIconID().getMostSignificantBits());
                    stmt.setLong(12, activity.getIconID().getLeastSignificantBits());
                } else {
                    stmt.setNull(11, -5);
                    stmt.setNull(12, -5);
                }
                stmt.setString(13, activity.getImplementationClass());
                boolean isDecisionActivity = activity instanceof DecisionActivity;
                stmt.setBoolean(14, isDecisionActivity);
                stmt.setBoolean(15, activity.isSingleton());
                stmt.setString(16, activity.getOperationName());
                stmt.setInt(17, activity.getParameterChangePolicy().getCode());
                stmt.setBoolean(18, activity.supportsTestExecution());
                stmt.setBoolean(19, activity.supportsViewOnly());
                stmt.setBytes(20, activity.getSystemComponent());
                if (!insert) {
                    stmt.setInt(21, node.getID());
                    stmt.setLong(22, template.getID().getMostSignificantBits());
                    stmt.setLong(23, template.getID().getLeastSignificantBits());
                }
                stmt.execute();
                if (stmt.getUpdateCount() == 0) {
                    String msg2 = String.format("%s of Activity (ActivityTypeID: %s, ActivityTemplateVersionID: %s) of node %s of template (%s) failed.", insert ? "Insert" : "Update", activity.getExecutableComponentName(), activity.getID(), node.getID(), template.getID());
                    logger.severe(msg2);
                    throw new DataSourceException(msg2);
                }
                stmt = JDBCTools.close(stmt);
                HashMap configurationsToDelete = new HashMap();
                stmt = con.prepareStatement(SQLHelp.SimpleQueryGenerator.generateSelect("PMEBPConfiguration", SQLConstants.COL_EBPCONFIGURATION_ID, SQLConstants.COL_EBPCONFIGURATION_PARENT_ID));
                stmt.setInt(1, node.getID());
                stmt.setLong(2, template.getID().getMostSignificantBits());
                stmt.setLong(3, template.getID().getLeastSignificantBits());
                rs = stmt.executeQuery();
                while (rs.next()) {
                    if (!configurationsToDelete.containsKey(rs.getInt(1))) {
                        configurationsToDelete.put(rs.getInt(1), new HashSet());
                    }
                    ((Set)configurationsToDelete.get(rs.getInt(1))).add(SQLHelp.getString(rs, 2));
                }
                rs = JDBCTools.close(rs);
                stmt = JDBCTools.close(stmt);
                HashMap confValues = new HashMap();
                HashMap fixedConfValues = new HashMap();
                for (String string : activity.getConfiguration().getAllEntries()) {
                    int n;
                    if (activity.getConfiguration().fromInputParameter(string) != null) {
                        value = activity.getConfiguration().fromInputParameter(string);
                        n = 2;
                    } else if (activity.getConfiguration().fromProcessConfiguration(string) != null) {
                        value = activity.getConfiguration().fromProcessConfiguration(string);
                        n = 3;
                    } else {
                        value = activity.getConfiguration().getString(string);
                        n = 1;
                    }
                    if (!confValues.containsKey(n)) {
                        confValues.put(n, new HashMap());
                    }
                    ((Map)confValues.get(n)).put(string, value);
                    if (!fixedConfValues.containsKey(n)) {
                        fixedConfValues.put(n, new HashSet());
                    }
                    if (!activity.getConfiguration().isFixed(string)) continue;
                    ((Set)fixedConfValues.get(n)).add(string);
                }
                for (String string : activity.getTestConfiguration().getAllEntries()) {
                    int n;
                    if (activity.getTestConfiguration().fromInputParameter(string) != null) {
                        value = activity.getTestConfiguration().fromInputParameter(string);
                        n = 5;
                    } else if (activity.getTestConfiguration().fromProcessConfiguration(string) != null) {
                        value = activity.getTestConfiguration().fromProcessConfiguration(string);
                        n = 6;
                    } else {
                        value = activity.getTestConfiguration().getString(string);
                        n = 4;
                    }
                    if (!confValues.containsKey(n)) {
                        confValues.put(n, new HashMap());
                    }
                    ((Map)confValues.get(n)).put(string, value);
                    if (!fixedConfValues.containsKey(n)) {
                        fixedConfValues.put(n, new HashSet());
                    }
                    if (!activity.getConfiguration().isFixed(string)) continue;
                    ((Set)fixedConfValues.get(n)).add(string);
                }
                for (Map.Entry entry : confValues.entrySet()) {
                    for (Map.Entry entry2 : ((Map)entry.getValue()).entrySet()) {
                        if (configurationsToDelete.containsKey(entry.getKey()) && ((Set)configurationsToDelete.get(entry.getKey())).contains(entry2.getKey())) {
                            ((Set)configurationsToDelete.get(entry.getKey())).remove(entry2.getKey());
                        }
                        boolean insertConf = !SQLHelpWrite.entryExists(con, "PMEBPConfiguration", SQLConstants.COL_EBPCONFIGURATION_PK, new SQLHelp.ParameterList(new int[]{4, -5, -5, 4, 12}, new Object[]{node.getID(), template.getID().getMostSignificantBits(), template.getID().getLeastSignificantBits(), entry.getKey(), entry2.getKey()}));
                        stmt = insertConf ? con.prepareStatement(SQLHelp.SimpleQueryGenerator.generateInsert("PMEBPConfiguration", SQLConstants.COL_EBPCONFIGURATION_ALL)) : con.prepareStatement(SQLHelp.SimpleQueryGenerator.generateUpdate("PMEBPConfiguration", SQLConstants.COL_EBPCONFIGURATION_ALL, SQLConstants.COL_EBPCONFIGURATION_PK));
                        stmt.setInt(1, node.getID());
                        stmt.setLong(2, template.getID().getMostSignificantBits());
                        stmt.setLong(3, template.getID().getLeastSignificantBits());
                        stmt.setInt(4, (Integer)entry.getKey());
                        stmt.setString(5, (String)entry2.getKey());
                        stmt.setString(6, (String)entry2.getValue());
                        stmt.setBoolean(7, ((Set)fixedConfValues.get(entry.getKey())).contains(entry2.getKey()));
                        if (!insertConf) {
                            stmt.setInt(8, node.getID());
                            stmt.setLong(9, template.getID().getMostSignificantBits());
                            stmt.setLong(10, template.getID().getLeastSignificantBits());
                            stmt.setInt(11, (Integer)entry.getKey());
                            stmt.setString(12, (String)entry2.getKey());
                        }
                        stmt.execute();
                        if (stmt.getUpdateCount() == 0) {
                            String msg3 = String.format("%s of ActivityConfiguration %s (Type: %s)of Activity (ActivityTypeID: %s, ActivityTemplateVersionID: %s) of node %s of template (%s) failed.", insertConf ? "Insert" : "Update", entry2.getKey(), ((Integer)entry.getKey()).toString(), activity.getExecutableComponentName(), activity.getID(), node.getID(), template.getID());
                            logger.severe(msg3);
                            throw new DataSourceException(msg3);
                        }
                        stmt = JDBCTools.close(stmt);
                    }
                }
                for (Map.Entry entry : configurationsToDelete.entrySet()) {
                    for (String string : (Set)entry.getValue()) {
                        stmt = con.prepareStatement(SQLHelp.SimpleQueryGenerator.generateDelete("PMEBPConfiguration", SQLConstants.COL_EBPCONFIGURATION_PK));
                        stmt.setInt(1, node.getID());
                        stmt.setLong(2, template.getID().getMostSignificantBits());
                        stmt.setLong(3, template.getID().getLeastSignificantBits());
                        stmt.setInt(4, (Integer)entry.getKey());
                        stmt.setString(5, string);
                        stmt.execute();
                        if (stmt.getUpdateCount() == 0) {
                            String msg4 = String.format("Deletion of ActivityConfiguration %s (Type %s) of Activity (ActivityTypeID: %s, ActivityTemplateVersionID: %s) of node %s of template %s failed.", string, ((Integer)entry.getKey()).toString(), activity.getExecutableComponentName(), activity.getID(), node.getID(), template.getID());
                            logger.severe(msg4);
                            throw new DataSourceException(msg4);
                        }
                        stmt = JDBCTools.close(stmt);
                    }
                }
                HashSet<Long> hashSet = new HashSet<Long>();
                stmt = con.prepareStatement(SQLHelp.SimpleQueryGenerator.generateSelect("PMDecisionActivityStatement", SQLConstants.COL_DECISIONACTIVITYSTATEMENT_ID, SQLConstants.COL_DECISIONACTIVITYSTATEMENT_PARENT_ID));
                stmt.setInt(1, node.getID());
                stmt.setLong(2, template.getID().getMostSignificantBits());
                stmt.setLong(3, template.getID().getLeastSignificantBits());
                rs = stmt.executeQuery();
                while (rs.next()) {
                    hashSet.add(rs.getLong(1));
                }
                rs = JDBCTools.close(rs);
                stmt = JDBCTools.close(stmt);
                if (isDecisionActivity) {
                    if (!(activity instanceof DecisionActivity)) {
                        throw new RuntimeException("DecisionActivity expected, but was none.");
                    }
                    DecisionActivity decisionActivity = (DecisionActivity)activity;
                    long[] lArray = decisionActivity.getDecisionIDs();
                    int msg3 = lArray.length;
                    int msg4 = 0;
                    while (msg4 < msg3) {
                        long l = lArray[msg4];
                        boolean insertDecision = !hashSet.remove(l);
                        stmt = insertDecision ? con.prepareStatement(SQLHelp.SimpleQueryGenerator.generateInsert("PMDecisionActivityStatement", SQLConstants.COL_DECISIONACTIVITYSTATEMENT_ALL)) : con.prepareStatement(SQLHelp.SimpleQueryGenerator.generateUpdate("PMDecisionActivityStatement", SQLConstants.COL_DECISIONACTIVITYSTATEMENT_ALL, SQLConstants.COL_DECISIONACTIVITYSTATEMENT_PK));
                        stmt.setInt(1, node.getID());
                        stmt.setLong(2, template.getID().getMostSignificantBits());
                        stmt.setLong(3, template.getID().getLeastSignificantBits());
                        stmt.setLong(4, l);
                        stmt.setString(5, decisionActivity.getDecisionLabel(l));
                        stmt.setString(6, decisionActivity.getDecisionStatement(l).getDecisionStatement());
                        stmt.setLong(7, decisionActivity.getEdgeCode(l));
                        if (!insertDecision) {
                            stmt.setInt(8, node.getID());
                            stmt.setLong(9, template.getID().getMostSignificantBits());
                            stmt.setLong(10, template.getID().getLeastSignificantBits());
                            stmt.setLong(11, l);
                        }
                        stmt.execute();
                        if (stmt.getUpdateCount() == 0) {
                            String msg5 = String.format("%s of DecisionActivityStatement #%sof Activity (ActivityTypeID: %s, ActivityTemplateVersionID: %s) of node %s of template (%s) failed.", insert ? "Insert" : "Update", l, activity.getExecutableComponentName(), activity.getID(), node.getID(), template.getID());
                            logger.severe(msg5);
                            throw new DataSourceException(msg5);
                        }
                        stmt = JDBCTools.close(stmt);
                        ++msg4;
                    }
                }
                value = hashSet.iterator();
                while (value.hasNext()) {
                    long decisionID = (Long)value.next();
                    stmt = con.prepareStatement(SQLHelp.SimpleQueryGenerator.generateDelete("PMDecisionActivityStatement", SQLConstants.COL_DECISIONACTIVITYSTATEMENT_PK));
                    stmt.setInt(1, node.getID());
                    stmt.setLong(2, template.getID().getMostSignificantBits());
                    stmt.setLong(3, template.getID().getLeastSignificantBits());
                    stmt.setLong(4, decisionID);
                    stmt.execute();
                    if (stmt.getUpdateCount() == 0) {
                        String msg6 = String.format("Deletion of DecisionActivityStatement #%s of Activity (ActivityTypeID: %s, ActivityTemplateVersionID: %s) of node %s of template %s failed.", decisionID, activity.getExecutableComponentName(), activity.getID(), node.getID(), template.getID());
                        logger.severe(msg6);
                        throw new DataSourceException(msg6);
                    }
                    stmt = JDBCTools.close(stmt);
                }
                HashMap classPathToDelete = new HashMap();
                stmt = con.prepareStatement(SQLHelp.SimpleQueryGenerator.generateSelect("PMActivityClassPath", SQLConstants.COL_ACTIVITYCLASSPATH_PK, SQLConstants.COL_ACTIVITYCLASSPATH_PARENT_ID));
                stmt.setInt(1, node.getID());
                stmt.setLong(2, template.getID().getMostSignificantBits());
                stmt.setLong(3, template.getID().getLeastSignificantBits());
                rs = stmt.executeQuery();
                while (rs.next()) {
                    ActivityConstants.ActivityModelEntityType activityModelEntityType = ActivityConstants.ActivityModelEntityType.valueOf((byte)rs.getInt(5));
                    if (!classPathToDelete.containsKey((Object)activityModelEntityType)) {
                        classPathToDelete.put(activityModelEntityType, new ArrayList());
                    }
                    ((List)classPathToDelete.get((Object)activityModelEntityType)).add(SQLHelp.getString(rs, 4));
                }
                rs = JDBCTools.close(rs);
                stmt = JDBCTools.close(stmt);
                for (Map.Entry entry : activity.getSeparatedClassPaths().entrySet()) {
                    int index = 0;
                    while (index < ((List)entry.getValue()).size()) {
                        String classPath = (String)((List)entry.getValue()).get(index);
                        if (classPathToDelete.containsKey(entry.getKey())) {
                            ((List)classPathToDelete.get(entry.getKey())).remove(classPath);
                        }
                        boolean insertCP = !SQLHelpWrite.entryExists(con, "PMActivityClassPath", SQLConstants.COL_ACTIVITYCLASSPATH_PK, new SQLHelp.ParameterList(new int[]{4, -5, -5, 12, 4}, new Object[]{node.getID(), template.getID().getMostSignificantBits(), template.getID().getLeastSignificantBits(), classPath, (int)((ActivityConstants.ActivityModelEntityType)((Object)entry.getKey())).getCode()}));
                        stmt = insertCP ? con.prepareStatement(SQLHelp.SimpleQueryGenerator.generateInsert("PMActivityClassPath", SQLConstants.COL_ACTIVITYCLASSPATH_ALL)) : con.prepareStatement(SQLHelp.SimpleQueryGenerator.generateUpdate("PMActivityClassPath", SQLConstants.COL_ACTIVITYCLASSPATH_ALL, SQLConstants.COL_ACTIVITYCLASSPATH_PK));
                        stmt.setInt(1, node.getID());
                        stmt.setLong(2, template.getID().getMostSignificantBits());
                        stmt.setLong(3, template.getID().getLeastSignificantBits());
                        stmt.setString(4, classPath);
                        stmt.setInt(5, ((ActivityConstants.ActivityModelEntityType)((Object)entry.getKey())).getCode());
                        stmt.setInt(6, index);
                        if (!insertCP) {
                            stmt.setInt(7, node.getID());
                            stmt.setLong(8, template.getID().getMostSignificantBits());
                            stmt.setLong(9, template.getID().getLeastSignificantBits());
                            stmt.setString(10, classPath);
                            stmt.setInt(11, ((ActivityConstants.ActivityModelEntityType)((Object)entry.getKey())).getCode());
                        }
                        stmt.execute();
                        if (stmt.getUpdateCount() == 0) {
                            String msg7 = String.format("%s of ClassPath '%s' of Activity (ECName: %s, ActivityTemplateVersionID: %s) of node %s of template (%s) failed.", insert ? "Insert" : "Update", classPath, activity.getExecutableComponentName(), activity.getID(), node.getID(), template.getID());
                            logger.severe(msg7);
                            throw new DataSourceException(msg7);
                        }
                        stmt = JDBCTools.close(stmt);
                        ++index;
                    }
                }
                for (Map.Entry entry : classPathToDelete.entrySet()) {
                    for (String classPath : (List)entry.getValue()) {
                        stmt = con.prepareStatement(SQLHelp.SimpleQueryGenerator.generateDelete("PMActivityClassPath", SQLConstants.COL_ACTIVITYCLASSPATH_PK));
                        stmt.setInt(1, node.getID());
                        stmt.setLong(2, template.getID().getMostSignificantBits());
                        stmt.setLong(3, template.getID().getLeastSignificantBits());
                        stmt.setString(4, classPath);
                        stmt.setInt(5, ((ActivityConstants.ActivityModelEntityType)((Object)entry.getKey())).getCode());
                        stmt.execute();
                        if (stmt.getUpdateCount() == 0) {
                            msg = String.format("Deletion of ClassPath '%s' of Activity (ECName: %s, ActivityTemplateVersionID: %s) of node %s of template (%s) failed.", classPath, activity.getExecutableComponentName(), activity.getID(), node.getID(), template.getID());
                            logger.severe(msg);
                            throw new DataSourceException(msg);
                        }
                        stmt = JDBCTools.close(stmt);
                    }
                }
                HashSet<ActivityConstants.LocallyOverrideableActivityAttribute> hashSet2 = new HashSet<ActivityConstants.LocallyOverrideableActivityAttribute>();
                stmt = con.prepareStatement(SQLHelp.SimpleQueryGenerator.generateSelect("PMActivityAttributeOrigins", SQLConstants.COL_ACTIVITYATTRIBUTEORIGINS_PK, SQLConstants.COL_ACTIVITYATTRIBUTEORIGINS_PARENT_ID));
                stmt.setInt(1, node.getID());
                stmt.setLong(2, template.getID().getMostSignificantBits());
                stmt.setLong(3, template.getID().getLeastSignificantBits());
                rs = stmt.executeQuery();
                while (rs.next()) {
                    hashSet2.add(ActivityConstants.LocallyOverrideableActivityAttribute.valueOf((byte)rs.getInt(4)));
                }
                rs = JDBCTools.close(rs);
                stmt = JDBCTools.close(stmt);
                for (Map.Entry<ActivityConstants.LocallyOverrideableActivityAttribute, ActivityConstants.ActivityModelEntityType> entry : activity.getAttributeOrigins().entrySet()) {
                    boolean insertOrigin = !hashSet2.remove((Object)entry.getKey());
                    stmt = insertOrigin ? con.prepareStatement(SQLHelp.SimpleQueryGenerator.generateInsert("PMActivityAttributeOrigins", SQLConstants.COL_ACTIVITYATTRIBUTEORIGINS_ALL)) : con.prepareStatement(SQLHelp.SimpleQueryGenerator.generateUpdate("PMActivityAttributeOrigins", SQLConstants.COL_ACTIVITYATTRIBUTEORIGINS_ALL, SQLConstants.COL_ACTIVITYATTRIBUTEORIGINS_PK));
                    stmt.setInt(1, node.getID());
                    stmt.setLong(2, template.getID().getMostSignificantBits());
                    stmt.setLong(3, template.getID().getLeastSignificantBits());
                    stmt.setInt(4, entry.getKey().getCode());
                    stmt.setInt(5, entry.getValue().getCode());
                    if (!insertOrigin) {
                        stmt.setInt(6, node.getID());
                        stmt.setLong(7, template.getID().getMostSignificantBits());
                        stmt.setLong(8, template.getID().getLeastSignificantBits());
                        stmt.setInt(9, entry.getKey().getCode());
                    }
                    stmt.execute();
                    if (stmt.getUpdateCount() == 0) {
                        msg = String.format("%s of attribute origin of attribute '%s' of Activity (ECName: %s, ActivityTemplateVersionID: %s) of node %s of template (%s) failed.", insert ? "Insert" : "Update", entry.getKey().toString(), activity.getExecutableComponentName(), activity.getID(), node.getID(), template.getID());
                        logger.severe(msg);
                        throw new DataSourceException(msg);
                    }
                    stmt = JDBCTools.close(stmt);
                }
                for (ActivityConstants.LocallyOverrideableActivityAttribute attribute : hashSet2) {
                    stmt = con.prepareStatement(SQLHelp.SimpleQueryGenerator.generateDelete("PMActivityAttributeOrigins", SQLConstants.COL_ACTIVITYATTRIBUTEORIGINS_PK));
                    stmt.setInt(1, node.getID());
                    stmt.setLong(2, template.getID().getMostSignificantBits());
                    stmt.setLong(3, template.getID().getLeastSignificantBits());
                    stmt.setInt(4, attribute.getCode());
                    stmt.execute();
                    if (stmt.getUpdateCount() == 0) {
                        String msg8 = String.format("Deletion of attribute origin of attribute '%s' of Activity (ECName: %s, ActivityTemplateVersionID: %s) of node %s of template (%s) failed.", attribute.toString(), activity.getExecutableComponentName(), activity.getID(), node.getID(), template.getID());
                        logger.severe(msg8);
                        throw new DataSourceException(msg8);
                    }
                    stmt = JDBCTools.close(stmt);
                }
                if (ownConnection) {
                    con = JDBCTools.close(con);
                } else if (doCommit) {
                    con = JDBCTools.commit(con);
                }
            }
            catch (SQLException e) {
                throw new DataSourceException("SQLException", e);
            }
        }
        catch (Throwable throwable) {
            if (doCommit) {
                JDBCTools.rollbackQuietly(con);
            }
            if (ownConnection) {
                JDBCTools.closeQuietly(con, stmt, rs);
            } else {
                JDBCTools.closeQuietly(stmt, rs);
            }
            throw throwable;
        }
        if (doCommit) {
            JDBCTools.rollbackQuietly(con);
        }
        if (ownConnection) {
            JDBCTools.closeQuietly(con, (Statement)stmt, rs);
        } else {
            JDBCTools.closeQuietly((Statement)stmt, rs);
        }
        logger.finer("SQLHelpWrite.insertOrUpdateActivity() exit");
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void insertOrUpdateEBP(JDBCDataSource dataSource, Template template, Node node, ExecutableBusinessProcess ebp, ExtendedConnection con, boolean doCommit) throws DataSourceException {
        logger.finer("SQLHelpWrite.insertOrUpdateEBP() entry");
        boolean ownConnection = con == null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            try {
                int dataMap;
                ActivityConstants.AccessType[] t;
                if (ownConnection) {
                    con = dataSource.getConnection();
                }
                con.setAutoCommit(false);
                boolean insert = !SQLHelpWrite.entryExists(con, "PMExecutableBusinessProcess", SQLConstants.COL_EXECUTABLEBUSINESSPROCESS_PK, new SQLHelp.ParameterList(new int[]{4, -5, -5}, new Object[]{node.getID(), template.getID().getMostSignificantBits(), template.getID().getLeastSignificantBits()}));
                stmt = insert ? con.prepareStatement(SQLHelp.SimpleQueryGenerator.generateInsert("PMExecutableBusinessProcess", SQLConstants.COL_EXECUTABLEBUSINESSPROCESS_ALL)) : con.prepareStatement(SQLHelp.SimpleQueryGenerator.generateUpdate("PMExecutableBusinessProcess", SQLConstants.COL_EXECUTABLEBUSINESSPROCESS_ALL, SQLConstants.COL_EXECUTABLEBUSINESSPROCESS_PK));
                stmt.setInt(1, node.getID());
                stmt.setLong(2, template.getID().getMostSignificantBits());
                stmt.setLong(3, template.getID().getLeastSignificantBits());
                stmt.setBoolean(4, ebp.getExecutionControlProperties().isClosable());
                stmt.setBoolean(5, ebp.getExecutionControlProperties().isSuspensible());
                stmt.setBoolean(6, ebp.getExecutionControlProperties().isResettable());
                if (ebp instanceof Activity) {
                    stmt.setInt(7, 1);
                } else {
                    stmt.setInt(7, 2);
                }
                if (!insert) {
                    stmt.setInt(8, node.getID());
                    stmt.setLong(9, template.getID().getMostSignificantBits());
                    stmt.setLong(10, template.getID().getLeastSignificantBits());
                }
                stmt.execute();
                if (stmt.getUpdateCount() == 0) {
                    String msg = String.format("%s of EBP (Type: %s) of node %s of template (%s) failed.", new Object[]{insert ? "Insert" : "Update", ebp.getType(), node.getID(), template.getID()});
                    logger.severe(msg);
                    throw new DataSourceException(msg);
                }
                stmt = JDBCTools.close(stmt);
                stmt = con.prepareStatement(SQLHelp.SimpleQueryGenerator.generateSelect("PMEBPUserAttributes", SQLConstants.COL_EBPUSERATTRIBUTES_ID, SQLConstants.COL_EBPUSERATTRIBUTES_PARENT_ID));
                stmt.setInt(1, node.getID());
                stmt.setLong(2, template.getID().getMostSignificantBits());
                stmt.setLong(3, template.getID().getLeastSignificantBits());
                stmt.setBoolean(4, false);
                rs = stmt.executeQuery();
                HashSet<String> userAttributesToDelete = new HashSet<String>();
                while (rs.next()) {
                    userAttributesToDelete.add(SQLHelp.getString(rs, 1));
                }
                rs = JDBCTools.close(rs);
                stmt = JDBCTools.close(stmt);
                for (Map.Entry<String, String> entry : ebp.getUserAttributes().entrySet()) {
                    boolean insertUA = !userAttributesToDelete.remove(entry.getKey());
                    stmt = insertUA ? con.prepareStatement(SQLHelp.SimpleQueryGenerator.generateInsert("PMEBPUserAttributes", SQLConstants.COL_EBPUSERATTRIBUTES_ALL)) : con.prepareStatement(SQLHelp.SimpleQueryGenerator.generateUpdate("PMEBPUserAttributes", SQLConstants.COL_EBPUSERATTRIBUTES_ALL, SQLConstants.COL_EBPUSERATTRIBUTES_PK));
                    stmt.setInt(1, node.getID());
                    stmt.setLong(2, template.getID().getMostSignificantBits());
                    stmt.setLong(3, template.getID().getLeastSignificantBits());
                    stmt.setBoolean(4, false);
                    stmt.setString(5, entry.getKey());
                    stmt.setString(6, entry.getValue());
                    if (!insertUA) {
                        stmt.setInt(7, node.getID());
                        stmt.setLong(8, template.getID().getMostSignificantBits());
                        stmt.setLong(9, template.getID().getLeastSignificantBits());
                        stmt.setBoolean(10, false);
                        stmt.setString(11, entry.getKey());
                    }
                    stmt.execute();
                    if (stmt.getUpdateCount() == 0) {
                        String msg = String.format("%s of userAttribute %s of EBP (Type: %s) of node %s of template (%s) failed.", new Object[]{insertUA ? "Insert" : "Update", entry.getKey(), ebp.getType(), node.getID(), template.getID()});
                        logger.severe(msg);
                        throw new DataSourceException(msg);
                    }
                    stmt = JDBCTools.close(stmt);
                }
                for (String string : userAttributesToDelete) {
                    stmt = con.prepareStatement(SQLHelp.SimpleQueryGenerator.generateDelete("PMEBPUserAttributes", SQLConstants.COL_EBPUSERATTRIBUTES_PK));
                    stmt.setInt(1, node.getID());
                    stmt.setLong(2, template.getID().getMostSignificantBits());
                    stmt.setLong(3, template.getID().getLeastSignificantBits());
                    stmt.setBoolean(4, false);
                    stmt.setString(5, string);
                    stmt.execute();
                    if (stmt.getUpdateCount() == 0) {
                        String msg = String.format("Deletion of UserAttribute %s of EBP (Type: %s) of node %s of template (%s) failed.", new Object[]{string, ebp.getType(), node.getID(), template.getID()});
                        logger.severe(msg);
                        throw new DataSourceException(msg);
                    }
                    stmt = JDBCTools.close(stmt);
                }
                stmt = con.prepareStatement(SQLHelp.SimpleQueryGenerator.generateSelect("PMEBPPlugins", SQLConstants.COL_EBPPLUGINS_ID, SQLConstants.COL_EBPPLUGINS_PARENT_ID));
                stmt.setInt(1, node.getID());
                stmt.setLong(2, template.getID().getMostSignificantBits());
                stmt.setLong(3, template.getID().getLeastSignificantBits());
                stmt.setBoolean(4, false);
                rs = stmt.executeQuery();
                HashSet<Triple<String, String, String>> hashSet = new HashSet<Triple<String, String, String>>();
                while (rs.next()) {
                    Triple<String, String, String> triple = new Triple<String, String, String>(SQLHelp.getString(rs, 1), SQLHelp.getString(rs, 2), SQLHelp.getString(rs, 3));
                    hashSet.add(triple);
                }
                rs = JDBCTools.close(rs);
                stmt = JDBCTools.close(stmt);
                for (Map.Entry<String, Set<String>> entry : ebp.getSupportedPlugins().entrySet()) {
                    for (String pluginID : entry.getValue()) {
                        Map<String, String> dataMap2;
                        PluginData pluginData = ebp.getPluginData(pluginID);
                        if (pluginData != null) {
                            dataMap2 = pluginData.getPluginData();
                        } else {
                            dataMap2 = new HashMap<String, String>();
                            dataMap2.put(null, null);
                        }
                        for (Map.Entry<String, String> entry2 : dataMap2.entrySet()) {
                            t = new Triple(entry2.getKey(), pluginID, entry.getKey());
                            boolean insertPlugin = !hashSet.remove(t);
                            stmt = insertPlugin ? con.prepareStatement(SQLHelp.SimpleQueryGenerator.generateInsert("PMEBPPlugins", SQLConstants.COL_EBPPLUGINS_ALL)) : con.prepareStatement(SQLHelp.SimpleQueryGenerator.generateUpdate("PMEBPPlugins", SQLConstants.COL_EBPPLUGINS_ALL, SQLConstants.COL_EBPPLUGINS_PK));
                            stmt.setInt(1, node.getID());
                            stmt.setLong(2, template.getID().getMostSignificantBits());
                            stmt.setLong(3, template.getID().getLeastSignificantBits());
                            stmt.setString(4, pluginID);
                            stmt.setString(5, entry.getKey());
                            stmt.setString(6, entry2.getKey());
                            stmt.setString(7, entry2.getValue());
                            stmt.setBoolean(8, false);
                            if (!insertPlugin) {
                                stmt.setInt(9, node.getID());
                                stmt.setLong(10, template.getID().getMostSignificantBits());
                                stmt.setLong(11, template.getID().getLeastSignificantBits());
                                stmt.setString(12, pluginID);
                                stmt.setString(13, entry.getKey());
                                stmt.setString(14, entry2.getKey());
                                stmt.setBoolean(15, false);
                            }
                            stmt.execute();
                            if (stmt.getUpdateCount() == 0) {
                                String msg = String.format("%s of plugin data %s of ebp of node (%s) of template %s failed.", insertPlugin ? "Insert" : "Update", null, node.getID(), template.getID());
                                logger.severe(msg);
                                throw new DataSourceException(msg);
                            }
                            stmt = JDBCTools.close(stmt);
                        }
                    }
                }
                for (Triple triple : hashSet) {
                    stmt = con.prepareStatement(SQLHelp.SimpleQueryGenerator.generateDelete("PMEBPPlugins", SQLConstants.COL_EBPPLUGINS_PK));
                    stmt.setInt(1, node.getID());
                    stmt.setLong(2, template.getID().getMostSignificantBits());
                    stmt.setLong(3, template.getID().getLeastSignificantBits());
                    stmt.setString(4, (String)triple.getSecond());
                    stmt.setString(5, (String)triple.getThird());
                    stmt.setString(6, (String)triple.getFirst());
                    stmt.setBoolean(7, false);
                    stmt.execute();
                    if (stmt.getUpdateCount() == 0) {
                        String msg = String.format("Deletion of plugin data %s of plugin %s (ExtensionPointID: %s) of ebp of node %s of template %s failed.", triple.getFirst(), triple.getSecond(), triple.getThird(), node.getID(), template.getID());
                        logger.severe(msg);
                        throw new DataSourceException(msg);
                    }
                    stmt = JDBCTools.close(stmt);
                }
                HashMap<String, ProcessModelParameter> hashMap = new HashMap<String, ProcessModelParameter>();
                HashMap parametersToBeStored = new HashMap();
                boolean isVarPar = false;
                if (ebp instanceof Activity) {
                    void var16_35;
                    stmt = con.prepareStatement(SQLHelp.SimpleQueryGenerator.generateDelete("PMSubProcess", SQLConstants.COL_SUBPROCESS_PK));
                    stmt.setInt(1, node.getID());
                    stmt.setLong(2, template.getID().getMostSignificantBits());
                    stmt.setLong(3, template.getID().getLeastSignificantBits());
                    stmt.execute();
                    stmt = JDBCTools.close(stmt);
                    SQLHelpWrite.insertOrUpdateActivity(dataSource, template, node, ebp, (Activity)ebp, con, false);
                    ActivityConstants.AccessType[] accessTypeArray = ActivityConstants.AccessType.activityRelatedValues();
                    dataMap = accessTypeArray.length;
                    boolean bl = false;
                    while (var16_35 < dataMap) {
                        ActivityConstants.AccessType access = accessTypeArray[var16_35];
                        if (!parametersToBeStored.containsKey((Object)access)) {
                            parametersToBeStored.put(access, new HashSet());
                        }
                        ((Set)parametersToBeStored.get((Object)access)).addAll(ebp.getParameters(access));
                        ++var16_35;
                    }
                } else {
                    LightWeightProcess lwp;
                    stmt = con.prepareStatement(SQLHelp.SimpleQueryGenerator.generateDelete("PMActivity", SQLConstants.COL_ACTIVITY_PK));
                    stmt.setInt(1, node.getID());
                    stmt.setLong(2, template.getID().getMostSignificantBits());
                    stmt.setLong(3, template.getID().getLeastSignificantBits());
                    stmt.execute();
                    stmt = JDBCTools.close(stmt);
                    isVarPar = SQLHelpWrite.insertOrUpdateSubProcess(dataSource, template, node, ebp, hashMap, con, false);
                    if (isVarPar) {
                        if (!(ebp instanceof VariableParallelismEBP)) throw new RuntimeException("Expected a VarPar but it is none!");
                        lwp = ((VariableParallelismEBP)ebp).getLightWeightProcess();
                    } else {
                        if (!(ebp instanceof LightWeightProcess)) throw new RuntimeException("EBP type not known!");
                        lwp = (LightWeightProcess)ebp;
                    }
                    ActivityConstants.AccessType[] accessTypeArray = ActivityConstants.AccessType.activityRelatedValues();
                    int n = accessTypeArray.length;
                    dataMap = 0;
                    while (dataMap < n) {
                        ActivityConstants.AccessType accessType = accessTypeArray[dataMap];
                        if (!parametersToBeStored.containsKey((Object)accessType)) {
                            parametersToBeStored.put(accessType, new HashSet());
                        }
                        ((Set)parametersToBeStored.get((Object)accessType)).addAll(lwp.getParameters(accessType));
                        ++dataMap;
                    }
                }
                stmt = con.prepareStatement(SQLHelp.SimpleQueryGenerator.generateSelect("PMProcessModelParameter", SQLConstants.COL_PROCESSMODELPARAMETER_KEY, SQLConstants.COL_PROCESSMODELPARAMETER_PARENT_ID));
                stmt.setInt(1, node.getID());
                stmt.setLong(2, template.getID().getMostSignificantBits());
                stmt.setLong(3, template.getID().getLeastSignificantBits());
                rs = stmt.executeQuery();
                HashSet<Triple<Integer, String, Boolean>> parametersToDelete = new HashSet<Triple<Integer, String, Boolean>>();
                block14: while (rs.next()) {
                    void var18_53;
                    ActivityConstants.AccessType accessType = ActivityConstants.AccessType.valueOf(rs.getInt(1));
                    t = ActivityConstants.AccessType.activityRelatedValues();
                    int n = t.length;
                    boolean bl = false;
                    while (var18_53 < n) {
                        ActivityConstants.AccessType ebpRelated = t[var18_53];
                        if (accessType == ebpRelated) {
                            Triple<Integer, String, Boolean> p = new Triple<Integer, String, Boolean>(rs.getInt(1), SQLHelp.getString(rs, 2), rs.getBoolean(3));
                            parametersToDelete.add(p);
                            continue block14;
                        }
                        ++var18_53;
                    }
                }
                rs = JDBCTools.close(rs);
                stmt = JDBCTools.close(stmt);
                ActivityConstants.AccessType[] accessTypeArray = ActivityConstants.AccessType.activityRelatedValues();
                int n = accessTypeArray.length;
                int n2 = 0;
                while (n2 < n) {
                    ActivityConstants.AccessType accessType = accessTypeArray[n2];
                    for (ProcessModelParameter param : (Set)parametersToBeStored.get((Object)accessType)) {
                        Triple<Integer, String, Boolean> t2 = new Triple<Integer, String, Boolean>(accessType.getCode(), param.getName(), false);
                        parametersToDelete.remove(t2);
                        boolean isDecisionParameter = false;
                        if (ebp instanceof DecisionActivity) {
                            ProcessModelParameter decisionParameter = ((DecisionActivity)ebp).getDecisionParameter();
                            if ((accessType == ActivityConstants.AccessType.SYSTEM_WRITE || accessType == ActivityConstants.AccessType.WRITE) && decisionParameter.getName().equals(param.getName())) {
                                isDecisionParameter = true;
                            }
                        }
                        boolean isIndexed = hashMap.keySet().contains(param.getName());
                        SQLHelpWrite.insertOrUpdateParameter(dataSource, param, accessType, isDecisionParameter, false, template, node, con, false);
                        if (!isIndexed) continue;
                        t2 = new Triple<Integer, String, Boolean>(accessType.getCode(), param.getName(), true);
                        parametersToDelete.remove(t2);
                        SQLHelpWrite.insertOrUpdateParameter(dataSource, (ProcessModelParameter)hashMap.get(param.getName()), accessType, false, true, template, node, con, false);
                    }
                    ++n2;
                }
                if (isVarPar) {
                    if (!(ebp instanceof VariableParallelismEBP)) {
                        throw new RuntimeException("Expected a VarPar but it is none!");
                    }
                    for (ProcessModelParameter processModelParameter : ((VariableParallelismEBP)ebp).getParameters(ActivityConstants.AccessType.WRITE)) {
                        Triple<Integer, String, Boolean> triple = new Triple<Integer, String, Boolean>(ActivityConstants.AccessType.WRITE.getCode(), processModelParameter.getName(), true);
                        parametersToDelete.remove(triple);
                        SQLHelpWrite.insertOrUpdateParameter(dataSource, processModelParameter, ActivityConstants.AccessType.WRITE, false, true, template, node, con, false);
                    }
                }
                for (Triple triple : parametersToDelete) {
                    stmt = con.prepareStatement(SQLHelp.SimpleQueryGenerator.generateDelete("PMDataEdge", SQLConstants.COL_DATAEDGE_PARAM_ID));
                    stmt.setLong(1, template.getID().getMostSignificantBits());
                    stmt.setLong(2, template.getID().getLeastSignificantBits());
                    stmt.setInt(3, node.getID());
                    stmt.setInt(4, (Integer)triple.getFirst());
                    stmt.setString(5, (String)triple.getSecond());
                    stmt.execute();
                    stmt = JDBCTools.close(stmt);
                    stmt = con.prepareStatement(SQLHelp.SimpleQueryGenerator.generateDelete("PMProcessModelParameter", SQLConstants.COL_PROCESSMODELPARAMETER_PK));
                    stmt.setInt(1, (Integer)triple.getFirst());
                    stmt.setString(2, (String)triple.getSecond());
                    stmt.setBoolean(3, (Boolean)triple.getThird());
                    stmt.setInt(4, node.getID());
                    stmt.setLong(5, template.getID().getMostSignificantBits());
                    stmt.setLong(6, template.getID().getLeastSignificantBits());
                    stmt.execute();
                    if (stmt.getUpdateCount() == 0) {
                        String string = String.format("Deletion of parameter %s (Type: %s, AccessType: %s, IsIndexed: %s) of node %s of template %s failed.", triple.getSecond(), "EBP", triple.getFirst(), triple.getThird(), node.getID(), template.getID());
                        logger.severe(string);
                        throw new DataSourceException(string);
                    }
                    stmt = JDBCTools.close(stmt);
                }
                if (ownConnection) {
                    con = JDBCTools.close(con);
                } else if (doCommit) {
                    con = JDBCTools.commit(con);
                }
            }
            catch (SQLException e) {
                throw new DataSourceException("SQLException", e);
            }
        }
        catch (Throwable throwable) {
            if (doCommit) {
                JDBCTools.rollbackQuietly(con);
            }
            if (ownConnection) {
                JDBCTools.closeQuietly(con, stmt, rs);
                throw throwable;
            } else {
                JDBCTools.closeQuietly(stmt, rs);
            }
            throw throwable;
        }
        if (doCommit) {
            JDBCTools.rollbackQuietly(con);
        }
        if (ownConnection) {
            JDBCTools.closeQuietly(con, (Statement)stmt, rs);
        } else {
            JDBCTools.closeQuietly((Statement)stmt, rs);
        }
        logger.finer("SQLHelpWrite.insertOrUpdateEBP() exit");
    }

    public static void insertOrUpdateParameter(JDBCDataSource dataSource, ProcessModelParameter parameter, ActivityConstants.AccessType accessType, boolean isDecisionParameter, boolean isIndexed, Template template, Node node, ExtendedConnection con, boolean doCommit) throws DataSourceException {
        logger.finer("SQLHelpWrite.insertOrUpdateParameter() entry");
        boolean ownConnection = con == null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            try {
                if (ownConnection) {
                    con = dataSource.getConnection();
                }
                con.setAutoCommit(false);
                boolean insert = !SQLHelpWrite.entryExists(con, "PMProcessModelParameter", SQLConstants.COL_PROCESSMODELPARAMETER_PK, new SQLHelp.ParameterList(new int[]{4, 12, 16, 4, -5, -5}, new Object[]{accessType.getCode(), parameter.getName(), isIndexed, node.getID(), template.getID().getMostSignificantBits(), template.getID().getLeastSignificantBits()}));
                stmt = insert ? con.prepareStatement(SQLHelp.SimpleQueryGenerator.generateInsert("PMProcessModelParameter", SQLConstants.COL_PROCESSMODELPARAMETER_ALL)) : con.prepareStatement(SQLHelp.SimpleQueryGenerator.generateUpdate("PMProcessModelParameter", SQLConstants.COL_PROCESSMODELPARAMETER_ALL, SQLConstants.COL_PROCESSMODELPARAMETER_PK));
                stmt.setInt(1, accessType.getCode());
                stmt.setString(2, parameter.getName());
                stmt.setBoolean(3, isIndexed);
                stmt.setInt(4, node.getID());
                stmt.setLong(5, template.getID().getMostSignificantBits());
                stmt.setLong(6, template.getID().getLeastSignificantBits());
                boolean connectorDisabled = false;
                Map<String, Integer> connectorMapping = node.getConnectorMapping(accessType);
                if (connectorMapping.containsKey(parameter.getName())) {
                    int connectorID = connectorMapping.get(parameter.getName());
                    int[] object = template.getDisabledConnectors(node.getID(), accessType);
                    int n = object.length;
                    int n2 = 0;
                    while (n2 < n) {
                        int disabledCon = object[n2];
                        if (connectorID == disabledCon) {
                            connectorDisabled = true;
                            break;
                        }
                        ++n2;
                    }
                }
                stmt.setBoolean(7, connectorDisabled);
                stmt.setInt(8, parameter.getDataType().getCode());
                stmt.setString(9, parameter.getDefaultValue());
                stmt.setString(10, parameter.getDescription());
                stmt.setLong(11, parameter.getIdentifierID().getMostSignificantBits());
                stmt.setLong(12, parameter.getIdentifierID().getLeastSignificantBits());
                stmt.setBoolean(13, isDecisionParameter);
                stmt.setBoolean(14, parameter.isFailure());
                stmt.setBoolean(15, parameter.isOptional());
                stmt.setBoolean(16, parameter.isVirtual());
                stmt.setString(17, parameter.getUDTName());
                if (!insert) {
                    stmt.setInt(18, accessType.getCode());
                    stmt.setString(19, parameter.getName());
                    stmt.setBoolean(20, isIndexed);
                    stmt.setInt(21, node.getID());
                    stmt.setLong(22, template.getID().getMostSignificantBits());
                    stmt.setLong(23, template.getID().getLeastSignificantBits());
                }
                stmt.execute();
                if (stmt.getUpdateCount() == 0) {
                    String msg = String.format("%s of parameter %s (AccessType: %s, IsIndexed %s) of node %s of template (%s) failed.", new Object[]{insert ? "Insert" : "Update", parameter.getName(), accessType, isIndexed, node.getID(), template.getID()});
                    logger.severe(msg);
                    throw new DataSourceException(msg);
                }
                stmt = JDBCTools.close(stmt);
                HashMap configurationsToDelete = new HashMap();
                stmt = con.prepareStatement(SQLHelp.SimpleQueryGenerator.generateSelect("PMParameterConfiguration", SQLConstants.COL_PARAMETERCONFIGURATION_ID, SQLConstants.COL_PARAMETERCONFIGURATION_PARENT_ID));
                stmt.setInt(1, node.getID());
                stmt.setLong(2, template.getID().getMostSignificantBits());
                stmt.setLong(3, template.getID().getLeastSignificantBits());
                stmt.setInt(4, accessType.getCode());
                stmt.setString(5, parameter.getName());
                stmt.setBoolean(6, isIndexed);
                rs = stmt.executeQuery();
                while (rs.next()) {
                    if (!configurationsToDelete.containsKey(rs.getInt(1))) {
                        configurationsToDelete.put(rs.getInt(1), new HashSet());
                    }
                    ((Set)configurationsToDelete.get(rs.getInt(1))).add(SQLHelp.getString(rs, 2));
                }
                rs = JDBCTools.close(rs);
                stmt = JDBCTools.close(stmt);
                HashMap confValues = new HashMap();
                HashMap fixedConfValues = new HashMap();
                for (String string : parameter.getConfiguration().getAllEntries()) {
                    int n;
                    Iterator value;
                    if (parameter.getConfiguration().fromInputParameter(string) != null) {
                        value = parameter.getConfiguration().fromInputParameter(string);
                        n = 2;
                    } else if (parameter.getConfiguration().fromProcessConfiguration(string) != null) {
                        value = parameter.getConfiguration().fromProcessConfiguration(string);
                        n = 3;
                    } else {
                        value = parameter.getConfiguration().getString(string);
                        n = 1;
                    }
                    if (!confValues.containsKey(n)) {
                        confValues.put(n, new HashMap());
                    }
                    ((Map)confValues.get(n)).put(string, value);
                    if (!fixedConfValues.containsKey(n)) {
                        fixedConfValues.put(n, new HashSet());
                    }
                    if (!parameter.getConfiguration().isFixed(string)) continue;
                    ((Set)fixedConfValues.get(n)).add(string);
                }
                for (Map.Entry entry : confValues.entrySet()) {
                    for (Map.Entry entry2 : ((Map)entry.getValue()).entrySet()) {
                        if (configurationsToDelete.containsKey(entry.getKey()) && ((Set)configurationsToDelete.get(entry.getKey())).contains(entry2.getKey())) {
                            ((Set)configurationsToDelete.get(entry.getKey())).remove(entry2.getKey());
                        }
                        boolean insertConf = !SQLHelpWrite.entryExists(con, "PMParameterConfiguration", SQLConstants.COL_PARAMETERCONFIGURATION_PK, new SQLHelp.ParameterList(new int[]{4, 12, 16, 4, -5, -5, 4, 12}, new Object[]{accessType.getCode(), parameter.getName(), isIndexed, node.getID(), template.getID().getMostSignificantBits(), template.getID().getLeastSignificantBits(), entry.getKey(), entry2.getKey()}));
                        stmt = insertConf ? con.prepareStatement(SQLHelp.SimpleQueryGenerator.generateInsert("PMParameterConfiguration", SQLConstants.COL_PARAMETERCONFIGURATION_ALL)) : con.prepareStatement(SQLHelp.SimpleQueryGenerator.generateUpdate("PMParameterConfiguration", SQLConstants.COL_PARAMETERCONFIGURATION_ALL, SQLConstants.COL_PARAMETERCONFIGURATION_PK));
                        stmt.setInt(1, accessType.getCode());
                        stmt.setString(2, parameter.getName());
                        stmt.setBoolean(3, isIndexed);
                        stmt.setInt(4, node.getID());
                        stmt.setLong(5, template.getID().getMostSignificantBits());
                        stmt.setLong(6, template.getID().getLeastSignificantBits());
                        stmt.setInt(7, (Integer)entry.getKey());
                        stmt.setString(8, (String)entry2.getKey());
                        stmt.setString(9, (String)entry2.getValue());
                        stmt.setBoolean(10, ((Set)fixedConfValues.get(entry.getKey())).contains(entry2.getKey()));
                        if (!insertConf) {
                            stmt.setInt(11, accessType.getCode());
                            stmt.setString(12, parameter.getName());
                            stmt.setBoolean(13, isIndexed);
                            stmt.setInt(14, node.getID());
                            stmt.setLong(15, template.getID().getMostSignificantBits());
                            stmt.setLong(16, template.getID().getLeastSignificantBits());
                            stmt.setInt(17, (Integer)entry.getKey());
                            stmt.setString(18, (String)entry2.getKey());
                        }
                        stmt.execute();
                        if (stmt.getUpdateCount() == 0) {
                            String msg = String.format("%s of Configuration %s (Type: %s)of Parameter %s (AccessType: %s, IsIndexed %s) of node %s of template (%s) failed.", new Object[]{insertConf ? "Insert" : "Update", entry2.getKey(), ((Integer)entry.getKey()).toString(), parameter.getName(), accessType, isIndexed, node.getID(), template.getID()});
                            logger.severe(msg);
                            throw new DataSourceException(msg);
                        }
                        stmt = JDBCTools.close(stmt);
                    }
                }
                for (Map.Entry entry : configurationsToDelete.entrySet()) {
                    for (String string : (Set)entry.getValue()) {
                        stmt = con.prepareStatement(SQLHelp.SimpleQueryGenerator.generateDelete("PMParameterConfiguration", SQLConstants.COL_PARAMETERCONFIGURATION_PK));
                        stmt.setInt(1, accessType.getCode());
                        stmt.setString(2, parameter.getName());
                        stmt.setBoolean(3, isIndexed);
                        stmt.setInt(4, node.getID());
                        stmt.setLong(5, template.getID().getMostSignificantBits());
                        stmt.setLong(6, template.getID().getLeastSignificantBits());
                        stmt.setInt(7, (Integer)entry.getKey());
                        stmt.setString(8, string);
                        stmt.execute();
                        if (stmt.getUpdateCount() == 0) {
                            String msg = String.format("Deletion of Configuration %s (Type: %s)of Parameter %s (AccessType: %s, IsIndexed %s) of node %s of template (%s) failed.", new Object[]{string, ((Integer)entry.getKey()).toString(), parameter.getName(), accessType, isIndexed, node.getID(), template.getID()});
                            logger.severe(msg);
                            throw new DataSourceException(msg);
                        }
                        stmt = JDBCTools.close(stmt);
                    }
                }
                stmt = con.prepareStatement(SQLHelp.SimpleQueryGenerator.generateSelect("PMParameterPlugins", SQLConstants.COL_PARAMETERPLUGINS_ID, SQLConstants.COL_PARAMETERPLUGINS_PARENT_ID));
                stmt.setInt(1, accessType.getCode());
                stmt.setString(2, parameter.getName());
                stmt.setBoolean(3, isIndexed);
                stmt.setInt(4, node.getID());
                stmt.setLong(5, template.getID().getMostSignificantBits());
                stmt.setLong(6, template.getID().getLeastSignificantBits());
                rs = stmt.executeQuery();
                HashSet<Triple<String, String, String>> hashSet = new HashSet<Triple<String, String, String>>();
                while (rs.next()) {
                    Triple<String, String, String> triple = new Triple<String, String, String>(SQLHelp.getString(rs, 1), SQLHelp.getString(rs, 2), SQLHelp.getString(rs, 3));
                    hashSet.add(triple);
                }
                rs = JDBCTools.close(rs);
                stmt = JDBCTools.close(stmt);
                for (Map.Entry<String, Set<String>> entry : parameter.getSupportedPlugins().entrySet()) {
                    for (String pluginID : entry.getValue()) {
                        Map<String, String> dataMap;
                        PluginData data = parameter.getPluginData(pluginID);
                        if (data != null) {
                            dataMap = data.getPluginData();
                        } else {
                            dataMap = new HashMap<String, String>();
                            dataMap.put(null, null);
                        }
                        for (Map.Entry<String, String> dataRow : dataMap.entrySet()) {
                            Triple<String, String, String> t = new Triple<String, String, String>(dataRow.getKey(), pluginID, entry.getKey());
                            boolean insertPlugin = !hashSet.remove(t);
                            stmt = insertPlugin ? con.prepareStatement(SQLHelp.SimpleQueryGenerator.generateInsert("PMParameterPlugins", SQLConstants.COL_PARAMETERPLUGINS_ALL)) : con.prepareStatement(SQLHelp.SimpleQueryGenerator.generateUpdate("PMParameterPlugins", SQLConstants.COL_PARAMETERPLUGINS_ALL, SQLConstants.COL_PARAMETERPLUGINS_PK));
                            stmt.setString(1, dataRow.getKey());
                            stmt.setString(2, dataRow.getValue());
                            stmt.setString(3, pluginID);
                            stmt.setString(4, entry.getKey());
                            stmt.setInt(5, accessType.getCode());
                            stmt.setString(6, parameter.getName());
                            stmt.setBoolean(7, isIndexed);
                            stmt.setInt(8, node.getID());
                            stmt.setLong(9, template.getID().getMostSignificantBits());
                            stmt.setLong(10, template.getID().getLeastSignificantBits());
                            if (!insertPlugin) {
                                stmt.setString(11, dataRow.getKey());
                                stmt.setString(12, pluginID);
                                stmt.setString(13, entry.getKey());
                                stmt.setInt(14, accessType.getCode());
                                stmt.setString(15, parameter.getName());
                                stmt.setBoolean(16, isIndexed);
                                stmt.setInt(17, node.getID());
                                stmt.setLong(18, template.getID().getMostSignificantBits());
                                stmt.setLong(19, template.getID().getLeastSignificantBits());
                            }
                            stmt.execute();
                            if (stmt.getUpdateCount() == 0) {
                                String msg = String.format("%s of plugin data %s of parameter %s of node %s of template %s failed.", insertPlugin ? "Insert" : "Update", dataRow.getKey(), parameter.getName(), node.getID(), template.getID());
                                logger.severe(msg);
                                throw new DataSourceException(msg);
                            }
                            stmt = JDBCTools.close(stmt);
                        }
                    }
                }
                for (Triple triple : hashSet) {
                    stmt = con.prepareStatement(SQLHelp.SimpleQueryGenerator.generateDelete("PMParameterPlugins", SQLConstants.COL_PARAMETERPLUGINS_PK));
                    stmt.setString(1, (String)triple.getFirst());
                    stmt.setString(2, (String)triple.getSecond());
                    stmt.setString(3, (String)triple.getThird());
                    stmt.setInt(4, accessType.getCode());
                    stmt.setString(5, parameter.getName());
                    stmt.setInt(6, node.getID());
                    stmt.setLong(7, template.getID().getMostSignificantBits());
                    stmt.setLong(8, template.getID().getLeastSignificantBits());
                    stmt.execute();
                    if (stmt.getUpdateCount() == 0) {
                        String msg = String.format("Deletion of plugin data %s of plugin %s (ExtensionPointID: %s) of parameter %s of node %s of template %s failed.", triple.getFirst(), triple.getSecond(), triple.getThird(), parameter.getName(), node.getID(), template.getID());
                        logger.severe(msg);
                        throw new DataSourceException(msg);
                    }
                    stmt = JDBCTools.close(stmt);
                }
                stmt = con.prepareStatement(SQLHelp.SimpleQueryGenerator.generateSelect("PMParameterUserAttributes", SQLConstants.COL_PARAMETERUA_PK, SQLConstants.COL_PARAMETERUA_PARENT_ID));
                stmt.setInt(1, node.getID());
                stmt.setLong(2, template.getID().getMostSignificantBits());
                stmt.setLong(3, template.getID().getLeastSignificantBits());
                stmt.setInt(4, accessType.getCode());
                stmt.setString(5, parameter.getName());
                stmt.setBoolean(6, isIndexed);
                rs = stmt.executeQuery();
                HashSet<String> hashSet2 = new HashSet<String>();
                while (rs.next()) {
                    hashSet2.add(SQLHelp.getString(rs, 7));
                }
                rs = JDBCTools.close(rs);
                stmt = JDBCTools.close(stmt);
                for (Map.Entry<String, String> entry : parameter.getUserAttributes().entrySet()) {
                    boolean insertUA = !hashSet2.remove(entry.getKey());
                    stmt = insertUA ? con.prepareStatement(SQLHelp.SimpleQueryGenerator.generateInsert("PMParameterUserAttributes", SQLConstants.COL_PARAMETERUA_ALL)) : con.prepareStatement(SQLHelp.SimpleQueryGenerator.generateUpdate("PMParameterUserAttributes", SQLConstants.COL_PARAMETERUA_ALL, SQLConstants.COL_PARAMETERUA_PK));
                    stmt.setInt(1, accessType.getCode());
                    stmt.setString(2, parameter.getName());
                    stmt.setBoolean(3, isIndexed);
                    stmt.setInt(4, node.getID());
                    stmt.setLong(5, template.getID().getMostSignificantBits());
                    stmt.setLong(6, template.getID().getLeastSignificantBits());
                    stmt.setString(7, entry.getKey());
                    stmt.setString(8, entry.getValue());
                    if (!insertUA) {
                        stmt.setInt(9, accessType.getCode());
                        stmt.setString(10, parameter.getName());
                        stmt.setBoolean(11, isIndexed);
                        stmt.setInt(12, node.getID());
                        stmt.setLong(13, template.getID().getMostSignificantBits());
                        stmt.setLong(14, template.getID().getLeastSignificantBits());
                        stmt.setString(15, entry.getKey());
                    }
                    stmt.execute();
                    if (stmt.getUpdateCount() == 0) {
                        String msg = String.format("%s of parameter %s of node %s of template (%s) user attribute %s failed.", insertUA ? "Insert" : "Update", parameter.getName(), node.getID(), template.getID(), entry.getKey());
                        logger.severe(msg);
                        throw new DataSourceException(msg);
                    }
                    stmt = JDBCTools.close(stmt);
                }
                for (String string : hashSet2) {
                    stmt = con.prepareStatement(SQLHelp.SimpleQueryGenerator.generateDelete("PMParameterUserAttributes", SQLConstants.COL_PARAMETERUA_PK));
                    stmt.setInt(1, accessType.getCode());
                    stmt.setString(2, parameter.getName());
                    stmt.setBoolean(3, isIndexed);
                    stmt.setInt(4, node.getID());
                    stmt.setLong(5, template.getID().getMostSignificantBits());
                    stmt.setLong(6, template.getID().getLeastSignificantBits());
                    stmt.setString(7, string);
                    stmt.execute();
                    if (stmt.getUpdateCount() == 0) {
                        String msg = String.format("Deletion of parameter %s of node %s of template (%s) user attribute %s failed.", parameter.getName(), node.getID(), template.getID(), string);
                        logger.severe(msg);
                        throw new DataSourceException(msg);
                    }
                    stmt = JDBCTools.close(stmt);
                }
                if (ownConnection) {
                    con = JDBCTools.close(con);
                } else if (doCommit) {
                    con = JDBCTools.commit(con);
                }
            }
            catch (SQLException e) {
                throw new DataSourceException("SQLException", e);
            }
        }
        catch (Throwable throwable) {
            if (doCommit) {
                JDBCTools.rollbackQuietly(con);
            }
            if (ownConnection) {
                JDBCTools.closeQuietly(con, stmt, rs);
            } else {
                JDBCTools.closeQuietly(stmt, rs);
            }
            throw throwable;
        }
        if (doCommit) {
            JDBCTools.rollbackQuietly(con);
        }
        if (ownConnection) {
            JDBCTools.closeQuietly(con, (Statement)stmt, rs);
        } else {
            JDBCTools.closeQuietly((Statement)stmt, rs);
        }
        logger.finer("SQLHelpWrite.insertOrUpdateParameter() exit");
    }

    /*
     * WARNING - void declaration
     */
    public static void insertOrUpdateNode(JDBCDataSource dataSource, Template template, Node node, ExtendedConnection con, boolean doCommit) throws DataSourceException {
        logger.finer("SQLHelpWrite.insertOrUpdateNode() entry");
        boolean ownConnection = con == null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            try {
                void var12_29;
                int msg32;
                if (ownConnection) {
                    con = dataSource.getConnection();
                }
                con.setAutoCommit(false);
                boolean insert = !SQLHelpWrite.entryExists(con, "PMNode", SQLConstants.COL_NODE_PK, new SQLHelp.ParameterList(new int[]{-5, -5, 4}, new Object[]{template.getID().getMostSignificantBits(), template.getID().getLeastSignificantBits(), node.getID()}));
                stmt = insert ? con.prepareStatement(SQLHelp.SimpleQueryGenerator.generateInsert("PMNode", SQLConstants.COL_NODE_ALL)) : con.prepareStatement(SQLHelp.SimpleQueryGenerator.generateUpdate("PMNode", SQLConstants.COL_NODE_ALL, SQLConstants.COL_NODE_PK));
                stmt.setLong(1, template.getID().getMostSignificantBits());
                stmt.setLong(2, template.getID().getLeastSignificantBits());
                stmt.setInt(3, node.getID());
                if (node.getIconID() != null) {
                    stmt.setLong(4, node.getIconID().getMostSignificantBits());
                    stmt.setLong(5, node.getIconID().getLeastSignificantBits());
                } else {
                    stmt.setNull(4, -5);
                    stmt.setNull(5, -5);
                }
                stmt.setBoolean(6, node.isAutoStartEnabled());
                stmt.setInt(7, template.getNodeBranchID(node.getID()));
                stmt.setInt(8, template.getNodeCorrespondingBlockNodeID(node.getID()));
                stmt.setString(9, node.getDescription());
                stmt.setString(10, node.getName());
                stmt.setInt(11, template.getNodeSplitNodeID(node.getID()));
                stmt.setString(12, node.getStaffAssignmentRule());
                stmt.setInt(13, template.getNodeType(node.getID()).getCode());
                stmt.setInt(14, template.getNodeTopologicalID(node.getID()));
                if (!insert) {
                    stmt.setLong(15, template.getID().getMostSignificantBits());
                    stmt.setLong(16, template.getID().getLeastSignificantBits());
                    stmt.setInt(17, node.getID());
                }
                stmt.execute();
                if (stmt.getUpdateCount() == 0) {
                    String msg2 = String.format("%s of node %s of template (%s) failed.", insert ? "Insert" : "Update", node.getID(), template.getID());
                    logger.severe(msg2);
                    throw new DataSourceException(msg2);
                }
                stmt = JDBCTools.close(stmt);
                stmt = con.prepareStatement(SQLHelp.SimpleQueryGenerator.generateSelect("PMNodeUserAttributes", SQLConstants.COL_NODEUSERATTRIBUTES_KEY, SQLConstants.COL_NODEUSERATTRIBUTES_PARENT_ID));
                stmt.setInt(1, node.getID());
                stmt.setLong(2, template.getID().getMostSignificantBits());
                stmt.setLong(3, template.getID().getLeastSignificantBits());
                rs = stmt.executeQuery();
                HashSet<String> userAttributesToDelete = new HashSet<String>();
                while (rs.next()) {
                    userAttributesToDelete.add(SQLHelp.getString(rs, 1));
                }
                rs = JDBCTools.close(rs);
                stmt = JDBCTools.close(stmt);
                for (Map.Entry<String, String> entry : node.getUserAttributes().entrySet()) {
                    boolean bl = !userAttributesToDelete.remove(entry.getKey());
                    stmt = bl ? con.prepareStatement(SQLHelp.SimpleQueryGenerator.generateInsert("PMNodeUserAttributes", SQLConstants.COL_NODEUSERATTRIBUTES_ALL)) : con.prepareStatement(SQLHelp.SimpleQueryGenerator.generateUpdate("PMNodeUserAttributes", SQLConstants.COL_NODEUSERATTRIBUTES_ALL, SQLConstants.COL_NODEUSERATTRIBUTES_PK));
                    stmt.setInt(1, node.getID());
                    stmt.setLong(2, template.getID().getMostSignificantBits());
                    stmt.setLong(3, template.getID().getLeastSignificantBits());
                    stmt.setString(4, entry.getKey());
                    stmt.setString(5, entry.getValue());
                    if (!bl) {
                        stmt.setInt(6, node.getID());
                        stmt.setLong(7, template.getID().getMostSignificantBits());
                        stmt.setLong(8, template.getID().getLeastSignificantBits());
                        stmt.setString(9, entry.getKey());
                    }
                    stmt.execute();
                    if (stmt.getUpdateCount() == 0) {
                        String msg32 = String.format("%s of node (%s) of template %s user attribute %s failed.", bl ? "Insert" : "Update", node.getID(), template.getID(), entry.getKey());
                        logger.severe(msg32);
                        throw new DataSourceException(msg32);
                    }
                    stmt = JDBCTools.close(stmt);
                }
                for (String string : userAttributesToDelete) {
                    stmt = con.prepareStatement(SQLHelp.SimpleQueryGenerator.generateDelete("PMNodeUserAttributes", SQLConstants.COL_NODEUSERATTRIBUTES_PK));
                    stmt.setInt(1, node.getID());
                    stmt.setLong(2, template.getID().getMostSignificantBits());
                    stmt.setLong(3, template.getID().getLeastSignificantBits());
                    stmt.setString(4, string);
                    stmt.execute();
                    if (stmt.getUpdateCount() == 0) {
                        String string2 = String.format("Deletion of user attribute %s of node %s of template %s failed.", string, node.getID(), template.getID());
                        logger.severe(string2);
                        throw new DataSourceException(string2);
                    }
                    stmt = JDBCTools.close(stmt);
                }
                stmt = con.prepareStatement(SQLHelp.SimpleQueryGenerator.generateSelect("PMProcessModelParameter", SQLConstants.COL_PROCESSMODELPARAMETER_KEY, SQLConstants.COL_PROCESSMODELPARAMETER_PARENT_ID));
                stmt.setInt(1, node.getID());
                stmt.setLong(2, template.getID().getMostSignificantBits());
                stmt.setLong(3, template.getID().getLeastSignificantBits());
                rs = stmt.executeQuery();
                HashSet<Object> hashSet = new HashSet<Object>();
                block7: while (rs.next()) {
                    ActivityConstants.AccessType accessType = ActivityConstants.AccessType.valueOf(rs.getInt(1));
                    ActivityConstants.AccessType[] accessTypeArray = ActivityConstants.AccessType.systemRelatedValues();
                    int n = accessTypeArray.length;
                    msg32 = 0;
                    while (msg32 < n) {
                        ActivityConstants.AccessType accessType2 = accessTypeArray[msg32];
                        if (accessType == accessType2) {
                            Triple<Integer, String, Boolean> t = new Triple<Integer, String, Boolean>(rs.getInt(1), SQLHelp.getString(rs, 2), rs.getBoolean(3));
                            hashSet.add(t);
                            continue block7;
                        }
                        ++msg32;
                    }
                }
                rs = JDBCTools.close(rs);
                stmt = JDBCTools.close(stmt);
                ActivityConstants.AccessType[] accessTypeArray = ActivityConstants.AccessType.systemRelatedValues();
                msg32 = accessTypeArray.length;
                boolean bl = false;
                while (var12_29 < msg32) {
                    ActivityConstants.AccessType accessType = accessTypeArray[var12_29];
                    for (ProcessModelParameter param : node.getSystemParameters(accessType)) {
                        Triple<Integer, String, Boolean> t = new Triple<Integer, String, Boolean>(accessType.getCode(), param.getName(), false);
                        hashSet.remove(t);
                        SQLHelpWrite.insertOrUpdateParameter(dataSource, param, accessType, false, false, template, node, con, false);
                    }
                    ++var12_29;
                }
                for (Triple triple : hashSet) {
                    stmt = con.prepareStatement(SQLHelp.SimpleQueryGenerator.generateDelete("PMDataEdge", SQLConstants.COL_DATAEDGE_PARAM_ID));
                    stmt.setLong(1, template.getID().getMostSignificantBits());
                    stmt.setLong(2, template.getID().getLeastSignificantBits());
                    stmt.setInt(3, node.getID());
                    stmt.setInt(4, (Integer)triple.getFirst());
                    stmt.setString(5, (String)triple.getSecond());
                    stmt.execute();
                    stmt = JDBCTools.close(stmt);
                    stmt = con.prepareStatement(SQLHelp.SimpleQueryGenerator.generateDelete("PMProcessModelParameter", SQLConstants.COL_PROCESSMODELPARAMETER_PK));
                    stmt.setInt(1, (Integer)triple.getFirst());
                    stmt.setString(2, (String)triple.getSecond());
                    stmt.setBoolean(3, (Boolean)triple.getThird());
                    stmt.setInt(4, node.getID());
                    stmt.setLong(5, template.getID().getMostSignificantBits());
                    stmt.setLong(6, template.getID().getLeastSignificantBits());
                    stmt.execute();
                    if (stmt.getUpdateCount() == 0) {
                        String msg5 = String.format("Deletion of parameter %s (Type: %s, AccessType: %s, isIndexed %s) of node %s of template %s failed.", triple.getSecond(), "Node", triple.getFirst(), triple.getThird(), node.getID(), template.getID());
                        logger.severe(msg5);
                        throw new DataSourceException(msg5);
                    }
                    stmt = JDBCTools.close(stmt);
                }
                stmt = con.prepareStatement(SQLHelp.SimpleQueryGenerator.generateSelect("PMNodePlugins", SQLConstants.COL_NODEPLUGINS_ID, SQLConstants.COL_NODEPLUGINS_PARENT_ID));
                stmt.setInt(1, node.getID());
                stmt.setLong(2, template.getID().getMostSignificantBits());
                stmt.setLong(3, template.getID().getLeastSignificantBits());
                rs = stmt.executeQuery();
                HashSet<Triple<String, String, String>> hashSet2 = new HashSet<Triple<String, String, String>>();
                while (rs.next()) {
                    Triple<String, String, String> triple = new Triple<String, String, String>(SQLHelp.getString(rs, 1), SQLHelp.getString(rs, 2), SQLHelp.getString(rs, 3));
                    hashSet2.add(triple);
                }
                rs = JDBCTools.close(rs);
                stmt = JDBCTools.close(stmt);
                for (Map.Entry<String, Set<String>> entry : node.getSupportedPlugins().entrySet()) {
                    for (String pluginID : entry.getValue()) {
                        Map<String, String> dataMap;
                        PluginData data = node.getPluginData(pluginID);
                        if (data != null) {
                            dataMap = data.getPluginData();
                        } else {
                            dataMap = new HashMap<String, String>();
                            dataMap.put(null, null);
                        }
                        for (Map.Entry<String, String> dataRow : dataMap.entrySet()) {
                            Triple<String, String, String> t = new Triple<String, String, String>(dataRow.getKey(), pluginID, entry.getKey());
                            boolean insertPlugin = !hashSet2.remove(t);
                            stmt = insertPlugin ? con.prepareStatement(SQLHelp.SimpleQueryGenerator.generateInsert("PMNodePlugins", SQLConstants.COL_NODEPLUGINS_ALL)) : con.prepareStatement(SQLHelp.SimpleQueryGenerator.generateUpdate("PMNodePlugins", SQLConstants.COL_NODEPLUGINS_ALL, SQLConstants.COL_NODEPLUGINS_PK));
                            stmt.setString(1, dataRow.getKey());
                            stmt.setString(2, dataRow.getValue());
                            stmt.setString(3, pluginID);
                            stmt.setString(4, entry.getKey());
                            stmt.setInt(5, node.getID());
                            stmt.setLong(6, template.getID().getMostSignificantBits());
                            stmt.setLong(7, template.getID().getLeastSignificantBits());
                            if (!insertPlugin) {
                                stmt.setString(8, dataRow.getKey());
                                stmt.setString(9, pluginID);
                                stmt.setString(10, entry.getKey());
                                stmt.setInt(11, node.getID());
                                stmt.setLong(12, template.getID().getMostSignificantBits());
                                stmt.setLong(13, template.getID().getLeastSignificantBits());
                            }
                            stmt.execute();
                            if (stmt.getUpdateCount() == 0) {
                                String msg6 = String.format("%s of plugin data %s of node (%s) of template %s failed.", insertPlugin ? "Insert" : "Update", null, node.getID(), template.getID());
                                logger.severe(msg6);
                                throw new DataSourceException(msg6);
                            }
                            stmt = JDBCTools.close(stmt);
                        }
                    }
                }
                for (Triple triple : hashSet2) {
                    stmt = con.prepareStatement(SQLHelp.SimpleQueryGenerator.generateDelete("PMNodePlugins", SQLConstants.COL_NODEPLUGINS_PK));
                    stmt.setString(1, (String)triple.getFirst());
                    stmt.setString(2, (String)triple.getSecond());
                    stmt.setString(3, (String)triple.getThird());
                    stmt.setInt(4, node.getID());
                    stmt.setLong(5, template.getID().getMostSignificantBits());
                    stmt.setLong(6, template.getID().getLeastSignificantBits());
                    stmt.execute();
                    if (stmt.getUpdateCount() == 0) {
                        String msg7 = String.format("Deletion of plugin data %s of plugin %s (ExtensionPointID: %s) of node %s of template %s failed.", triple.getFirst(), triple.getSecond(), triple.getThird(), node.getID(), template.getID());
                        logger.severe(msg7);
                        throw new DataSourceException(msg7);
                    }
                    stmt = JDBCTools.close(stmt);
                }
                if (node.getExecutableBusinessProcess() != null) {
                    SQLHelpWrite.insertOrUpdateEBP(dataSource, template, node, node.getExecutableBusinessProcess(), con, false);
                } else {
                    stmt = con.prepareStatement(SQLHelp.SimpleQueryGenerator.generateDelete("PMExecutableBusinessProcess", SQLConstants.COL_EXECUTABLEBUSINESSPROCESS_PK));
                    stmt.setInt(1, node.getID());
                    stmt.setLong(2, template.getID().getMostSignificantBits());
                    stmt.setLong(3, template.getID().getLeastSignificantBits());
                    stmt.execute();
                    stmt = JDBCTools.close(stmt);
                }
                if (ownConnection) {
                    con = JDBCTools.close(con);
                } else if (doCommit) {
                    con = JDBCTools.commit(con);
                }
            }
            catch (SQLException e) {
                throw new DataSourceException("SQLException", e);
            }
        }
        catch (Throwable throwable) {
            if (doCommit) {
                JDBCTools.rollbackQuietly(con);
            }
            if (ownConnection) {
                JDBCTools.closeQuietly(con, stmt, rs);
            } else {
                JDBCTools.closeQuietly(stmt, rs);
            }
            throw throwable;
        }
        if (doCommit) {
            JDBCTools.rollbackQuietly(con);
        }
        if (ownConnection) {
            JDBCTools.closeQuietly(con, (Statement)stmt, rs);
        } else {
            JDBCTools.closeQuietly((Statement)stmt, rs);
        }
        logger.finer("SQLHelpWrite.insertOrUpdateNode() exit");
    }

    public static void insertOrUpdateDataEdge(JDBCDataSource dataSource, Template template, StructuredDataEdge edge, ExtendedConnection con, boolean doCommit) throws DataSourceException {
        logger.finer("SQLHelpWrite.insertOrUpdateDataEdge() entry");
        boolean ownConnection = con == null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            try {
                if (ownConnection) {
                    con = dataSource.getConnection();
                }
                con.setAutoCommit(false);
                boolean insert = !SQLHelpWrite.entryExists(con, "PMDataEdge", SQLConstants.COL_DATAEDGE_PK, new SQLHelp.ParameterList(new int[]{-5, -5, 4, 4, 4}, new Object[]{template.getID().getMostSignificantBits(), template.getID().getLeastSignificantBits(), edge.getNodeID(), edge.getDataElementID(), edge.getDataEdgeType().getCode()}));
                stmt = insert ? con.prepareStatement(SQLHelp.SimpleQueryGenerator.generateInsert("PMDataEdge", SQLConstants.COL_DATAEDGE_ALL)) : con.prepareStatement(SQLHelp.SimpleQueryGenerator.generateUpdate("PMDataEdge", SQLConstants.COL_DATAEDGE_ALL, SQLConstants.COL_DATAEDGE_PK));
                stmt.setLong(1, template.getID().getMostSignificantBits());
                stmt.setLong(2, template.getID().getLeastSignificantBits());
                stmt.setInt(3, edge.getNodeID());
                stmt.setInt(4, edge.getDataElementID());
                stmt.setInt(5, edge.getDataEdgeType().getCode());
                int[] disabledConnectors = template.getDisabledConnectors(edge.getNodeID(), edge.getDataEdgeType());
                boolean disabledFound = false;
                int[] nArray = disabledConnectors;
                int n = disabledConnectors.length;
                int n2 = 0;
                while (n2 < n) {
                    int disabledConnector = nArray[n2];
                    if (disabledConnector == edge.getConnectorID()) {
                        disabledFound = true;
                        break;
                    }
                    ++n2;
                }
                stmt.setBoolean(6, disabledFound);
                stmt.setBoolean(7, edge.getDataEdge().isOptional());
                Node node = template.getNode(edge.getNodeID());
                Map<String, Integer> parameterConnectors = node.getConnectorMapping(edge.getDataEdgeType());
                String mappedParameterName = null;
                for (Map.Entry<String, Integer> paramMapping : parameterConnectors.entrySet()) {
                    if (!paramMapping.getValue().equals(edge.getConnectorID())) continue;
                    mappedParameterName = paramMapping.getKey();
                    break;
                }
                if (mappedParameterName == null) {
                    stmt.setNull(8, 12);
                } else {
                    stmt.setString(8, mappedParameterName);
                }
                stmt.setBoolean(9, false);
                if (!insert) {
                    stmt.setLong(10, template.getID().getMostSignificantBits());
                    stmt.setLong(11, template.getID().getLeastSignificantBits());
                    stmt.setInt(12, edge.getNodeID());
                    stmt.setInt(13, edge.getDataElementID());
                    stmt.setInt(14, edge.getDataEdgeType().getCode());
                }
                stmt.execute();
                if (stmt.getUpdateCount() == 0) {
                    String msg = String.format("%s of DataEdge (node %s, DataElement %s, Parameter %s, AccessType %s) of template (%s) failed.", new Object[]{insert ? "Insert" : "Update", node.getName(), edge.getDataElementID(), mappedParameterName, edge.getDataEdgeType(), template.getID()});
                    logger.severe(msg);
                    throw new DataSourceException(msg);
                }
                stmt = JDBCTools.close(stmt);
                stmt = con.prepareStatement(SQLHelp.SimpleQueryGenerator.generateSelect("PMDataEdgeUserAttributes", SQLConstants.COL_DATAEDGEUSERATTRIBUTES_ID, SQLConstants.COL_DATAEDGEUSERATTRIBUTES_PARENT_ID));
                stmt.setLong(1, template.getID().getMostSignificantBits());
                stmt.setLong(2, template.getID().getLeastSignificantBits());
                stmt.setInt(3, edge.getNodeID());
                stmt.setInt(4, edge.getDataElementID());
                stmt.setInt(5, edge.getDataEdgeType().getCode());
                rs = stmt.executeQuery();
                HashSet<String> userAttributesToDelete = new HashSet<String>();
                while (rs.next()) {
                    userAttributesToDelete.add(SQLHelp.getString(rs, 1));
                }
                rs = JDBCTools.close(rs);
                stmt = JDBCTools.close(stmt);
                for (Map.Entry<String, String> entry : edge.getDataEdge().getUserAttributes().entrySet()) {
                    boolean insertUA = !userAttributesToDelete.remove(entry.getKey());
                    stmt = insertUA ? con.prepareStatement(SQLHelp.SimpleQueryGenerator.generateInsert("PMDataEdgeUserAttributes", SQLConstants.COL_DATAEDGEUSERATTRIBUTES_ALL)) : con.prepareStatement(SQLHelp.SimpleQueryGenerator.generateUpdate("PMDataEdgeUserAttributes", SQLConstants.COL_DATAEDGEUSERATTRIBUTES_ALL, SQLConstants.COL_DATAEDGEUSERATTRIBUTES_PK));
                    stmt.setLong(1, template.getID().getMostSignificantBits());
                    stmt.setLong(2, template.getID().getLeastSignificantBits());
                    stmt.setInt(3, edge.getNodeID());
                    stmt.setInt(4, edge.getDataElementID());
                    stmt.setInt(5, edge.getDataEdgeType().getCode());
                    stmt.setString(6, entry.getKey());
                    stmt.setString(7, entry.getValue());
                    if (!insertUA) {
                        stmt.setLong(8, template.getID().getMostSignificantBits());
                        stmt.setLong(9, template.getID().getLeastSignificantBits());
                        stmt.setInt(10, edge.getNodeID());
                        stmt.setInt(11, edge.getDataElementID());
                        stmt.setInt(12, edge.getDataEdgeType().getCode());
                        stmt.setString(13, entry.getKey());
                    }
                    stmt.execute();
                    if (stmt.getUpdateCount() == 0) {
                        String msg = String.format("%s of UserAttribute %s of DataEdge (node %s, DataElement %s, Parameter %s) of template (%s) failed.", insert ? "Insert" : "Update", entry.getKey(), node.getName(), edge.getDataElementID(), mappedParameterName, template.getID());
                        logger.severe(msg);
                        throw new DataSourceException(msg);
                    }
                    stmt = JDBCTools.close(stmt);
                }
                for (String string : userAttributesToDelete) {
                    stmt = con.prepareStatement(SQLHelp.SimpleQueryGenerator.generateDelete("PMDataEdgeUserAttributes", SQLConstants.COL_DATAEDGEUSERATTRIBUTES_PK));
                    stmt.setLong(1, template.getID().getMostSignificantBits());
                    stmt.setLong(2, template.getID().getLeastSignificantBits());
                    stmt.setInt(3, edge.getNodeID());
                    stmt.setInt(4, edge.getDataElementID());
                    stmt.setInt(5, edge.getDataEdgeType().getCode());
                    stmt.setString(6, string);
                    stmt.execute();
                    if (stmt.getUpdateCount() == 0) {
                        String msg = String.format("Deletion of user attribute %s of DataEdge (node %s, DataElement %s, Parameter %s) of template (%s) failed.", string, node.getName(), edge.getDataElementID(), mappedParameterName, template.getID());
                        logger.severe(msg);
                        throw new DataSourceException(msg);
                    }
                    stmt = JDBCTools.close(stmt);
                }
                if (ownConnection) {
                    con = JDBCTools.close(con);
                } else if (doCommit) {
                    con = JDBCTools.commit(con);
                }
            }
            catch (SQLException e) {
                throw new DataSourceException("SQLException", e);
            }
        }
        catch (Throwable throwable) {
            if (ownConnection || doCommit) {
                JDBCTools.rollbackQuietly(con);
            }
            if (ownConnection) {
                JDBCTools.closeQuietly(con, stmt, rs);
            } else {
                JDBCTools.closeQuietly(stmt, rs);
            }
            throw throwable;
        }
        if (ownConnection || doCommit) {
            JDBCTools.rollbackQuietly(con);
        }
        if (ownConnection) {
            JDBCTools.closeQuietly(con, (Statement)stmt, rs);
        } else {
            JDBCTools.closeQuietly((Statement)stmt, rs);
        }
        logger.finer("SQLHelpWrite.insertOrUpdateDataEdge() exit");
    }

    public static void insertOrUpdateEdge(JDBCDataSource dataSource, Template template, StructuredEdge edge, ExtendedConnection con, boolean doCommit) throws DataSourceException {
        logger.finer("SQLHelpWrite.insertOrUpdateEdge() entry");
        boolean ownConnection = con == null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            try {
                if (ownConnection) {
                    con = dataSource.getConnection();
                }
                con.setAutoCommit(false);
                boolean insert = !SQLHelpWrite.entryExists(con, "PMEdge", SQLConstants.COL_EDGE_PK, new SQLHelp.ParameterList(new int[]{-5, -5, 4, 4}, new Object[]{template.getID().getMostSignificantBits(), template.getID().getLeastSignificantBits(), edge.getSourceNodeID(), edge.getDestinationNodeID()}));
                stmt = insert ? con.prepareStatement(SQLHelp.SimpleQueryGenerator.generateInsert("PMEdge", SQLConstants.COL_EDGE_ALL)) : con.prepareStatement(SQLHelp.SimpleQueryGenerator.generateUpdate("PMEdge", SQLConstants.COL_EDGE_ALL, SQLConstants.COL_EDGE_PK));
                stmt.setLong(1, template.getID().getMostSignificantBits());
                stmt.setLong(2, template.getID().getLeastSignificantBits());
                stmt.setInt(3, edge.getSourceNodeID());
                stmt.setInt(4, edge.getDestinationNodeID());
                stmt.setLong(5, edge.getEdge().getEdgeCode());
                stmt.setInt(6, edge.getEdgeType().getCode());
                if (!insert) {
                    stmt.setLong(7, template.getID().getMostSignificantBits());
                    stmt.setLong(8, template.getID().getLeastSignificantBits());
                    stmt.setInt(9, edge.getSourceNodeID());
                    stmt.setInt(10, edge.getDestinationNodeID());
                }
                stmt.execute();
                if (stmt.getUpdateCount() == 0) {
                    String msg = String.format("%s of Edge (StartNode: %s, EndNode: %s) of template (%s) failed.", insert ? "Insert" : "Update", edge.getSourceNodeID(), edge.getDestinationNodeID(), template.getID());
                    logger.severe(msg);
                    throw new DataSourceException(msg);
                }
                stmt = JDBCTools.close(stmt);
                stmt = con.prepareStatement(SQLHelp.SimpleQueryGenerator.generateSelect("PMEdgeUserAttributes", SQLConstants.COL_EDGEUSERATTRIBUTES_ID, SQLConstants.COL_EDGEUSERATTRIBUTES_PARENT_ID));
                stmt.setLong(1, template.getID().getMostSignificantBits());
                stmt.setLong(2, template.getID().getLeastSignificantBits());
                stmt.setInt(3, edge.getSourceNodeID());
                stmt.setInt(4, edge.getDestinationNodeID());
                rs = stmt.executeQuery();
                HashSet<String> userAttributesToDelete = new HashSet<String>();
                while (rs.next()) {
                    userAttributesToDelete.add(SQLHelp.getString(rs, 1));
                }
                rs = JDBCTools.close(rs);
                stmt = JDBCTools.close(stmt);
                for (Map.Entry<String, String> entry : edge.getEdge().getUserAttributes().entrySet()) {
                    boolean insertUA = !userAttributesToDelete.remove(entry.getKey());
                    stmt = insertUA ? con.prepareStatement(SQLHelp.SimpleQueryGenerator.generateInsert("PMEdgeUserAttributes", SQLConstants.COL_EDGEUSERATTRIBUTES_ALL)) : con.prepareStatement(SQLHelp.SimpleQueryGenerator.generateUpdate("PMEdgeUserAttributes", SQLConstants.COL_EDGEUSERATTRIBUTES_ALL, SQLConstants.COL_EDGEUSERATTRIBUTES_PK));
                    stmt.setLong(1, template.getID().getMostSignificantBits());
                    stmt.setLong(2, template.getID().getLeastSignificantBits());
                    stmt.setInt(3, edge.getSourceNodeID());
                    stmt.setInt(4, edge.getDestinationNodeID());
                    stmt.setString(5, entry.getKey());
                    stmt.setString(6, entry.getValue());
                    if (!insertUA) {
                        stmt.setLong(7, template.getID().getMostSignificantBits());
                        stmt.setLong(8, template.getID().getLeastSignificantBits());
                        stmt.setInt(9, edge.getSourceNodeID());
                        stmt.setInt(10, edge.getDestinationNodeID());
                        stmt.setString(11, entry.getKey());
                    }
                    stmt.execute();
                    if (stmt.getUpdateCount() == 0) {
                        String msg = String.format("%s of UserAttribute %s of Edge (StartNode: %s, EndNode: %s) of template (%s) failed.", insert ? "Insert" : "Update", entry.getKey(), edge.getSourceNodeID(), edge.getDestinationNodeID(), template.getID());
                        logger.severe(msg);
                        throw new DataSourceException(msg);
                    }
                    stmt = JDBCTools.close(stmt);
                }
                for (String string : userAttributesToDelete) {
                    stmt = con.prepareStatement(SQLHelp.SimpleQueryGenerator.generateDelete("PMEdgeUserAttributes", SQLConstants.COL_EDGEUSERATTRIBUTES_PK));
                    stmt.setLong(1, template.getID().getMostSignificantBits());
                    stmt.setLong(2, template.getID().getLeastSignificantBits());
                    stmt.setInt(3, edge.getSourceNodeID());
                    stmt.setInt(4, edge.getDestinationNodeID());
                    stmt.setString(5, string);
                    stmt.execute();
                    if (stmt.getUpdateCount() == 0) {
                        String msg = String.format("Deletion of UserAttribute %s of Edge (StartNode: %s, EndNode: %s) of template (%s) failed.", string, edge.getSourceNodeID(), edge.getDestinationNodeID(), template.getID());
                        logger.severe(msg);
                        throw new DataSourceException(msg);
                    }
                    stmt = JDBCTools.close(stmt);
                }
                if (ownConnection) {
                    con = JDBCTools.close(con);
                } else if (doCommit) {
                    con = JDBCTools.commit(con);
                }
            }
            catch (SQLException e) {
                throw new DataSourceException("SQLException", e);
            }
        }
        catch (Throwable throwable) {
            if (ownConnection || doCommit) {
                JDBCTools.rollbackQuietly(con);
            }
            if (ownConnection) {
                JDBCTools.closeQuietly(con, stmt, rs);
            } else {
                JDBCTools.closeQuietly(stmt, rs);
            }
            throw throwable;
        }
        if (ownConnection || doCommit) {
            JDBCTools.rollbackQuietly(con);
        }
        if (ownConnection) {
            JDBCTools.closeQuietly(con, (Statement)stmt, rs);
        } else {
            JDBCTools.closeQuietly((Statement)stmt, rs);
        }
        logger.finer("SQLHelpWrite.insertOrUpdateEdge() exit");
    }

    public static void insertOrUpdateDataElement(JDBCDataSource dataSource, Template template, DataElement dataElement, ExtendedConnection con, boolean doCommit) throws DataSourceException {
        logger.finer("SQLHelpWrite.insertOrUpdateDataElement() entry");
        boolean ownConnection = con == null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            try {
                if (ownConnection) {
                    con = dataSource.getConnection();
                }
                con.setAutoCommit(false);
                boolean insert = !SQLHelpWrite.entryExists(con, "PMDataElement", SQLConstants.COL_DATAELEMENT_PK, new SQLHelp.ParameterList(new int[]{4, -5, -5}, new Object[]{dataElement.getID(), template.getID().getMostSignificantBits(), template.getID().getLeastSignificantBits()}));
                stmt = insert ? con.prepareStatement(SQLHelp.SimpleQueryGenerator.generateInsert("PMDataElement", SQLConstants.COL_DATAELEMENT_ALL)) : con.prepareStatement(SQLHelp.SimpleQueryGenerator.generateUpdate("PMDataElement", SQLConstants.COL_DATAELEMENT_ALL, SQLConstants.COL_DATAELEMENT_PK));
                stmt.setInt(1, dataElement.getID());
                stmt.setLong(2, template.getID().getMostSignificantBits());
                stmt.setLong(3, template.getID().getLeastSignificantBits());
                stmt.setInt(4, dataElement.getDataType().getCode());
                stmt.setString(5, dataElement.getDescription());
                if (dataElement.getIconID() != null) {
                    stmt.setLong(6, dataElement.getIconID().getMostSignificantBits());
                    stmt.setLong(7, dataElement.getIconID().getLeastSignificantBits());
                } else {
                    stmt.setNull(6, -5);
                    stmt.setNull(7, -5);
                }
                stmt.setLong(8, dataElement.getIdentifierID().getMostSignificantBits());
                stmt.setLong(9, dataElement.getIdentifierID().getLeastSignificantBits());
                stmt.setString(10, dataElement.getName());
                stmt.setBoolean(11, dataElement.isPublic());
                stmt.setString(12, dataElement.getUDTName());
                stmt.setBoolean(13, dataElement.isVirtual());
                if (!insert) {
                    stmt.setInt(14, dataElement.getID());
                    stmt.setLong(15, template.getID().getMostSignificantBits());
                    stmt.setLong(16, template.getID().getLeastSignificantBits());
                }
                stmt.execute();
                if (stmt.getUpdateCount() == 0) {
                    String msg = String.format("%s of DataElement %s of template (%s) failed.", insert ? "Insert" : "Update", dataElement.getName(), template.getID());
                    logger.severe(msg);
                    throw new DataSourceException(msg);
                }
                stmt = JDBCTools.close(stmt);
                stmt = con.prepareStatement(SQLHelp.SimpleQueryGenerator.generateSelect("PMDataElementUserAttributes", SQLConstants.COL_DATAELEMENTUSERATTRIBUTES_ID, SQLConstants.COL_DATAELEMENTUSERATTRIBUTES_PARENT_ID));
                stmt.setInt(1, dataElement.getID());
                stmt.setLong(2, template.getID().getMostSignificantBits());
                stmt.setLong(3, template.getID().getLeastSignificantBits());
                rs = stmt.executeQuery();
                HashSet<String> userAttributesToDelete = new HashSet<String>();
                while (rs.next()) {
                    userAttributesToDelete.add(SQLHelp.getString(rs, 1));
                }
                rs = JDBCTools.close(rs);
                stmt = JDBCTools.close(stmt);
                for (Map.Entry<String, String> entry : dataElement.getUserAttributes().entrySet()) {
                    boolean insertUA = !userAttributesToDelete.remove(entry.getKey());
                    stmt = insertUA ? con.prepareStatement(SQLHelp.SimpleQueryGenerator.generateInsert("PMDataElementUserAttributes", SQLConstants.COL_DATAELEMENTUSERATTRIBUTES_ALL)) : con.prepareStatement(SQLHelp.SimpleQueryGenerator.generateUpdate("PMDataElementUserAttributes", SQLConstants.COL_DATAELEMENTUSERATTRIBUTES_ALL, SQLConstants.COL_DATAELEMENTUSERATTRIBUTES_PK));
                    stmt.setInt(1, dataElement.getID());
                    stmt.setLong(2, template.getID().getMostSignificantBits());
                    stmt.setLong(3, template.getID().getLeastSignificantBits());
                    stmt.setString(4, entry.getKey());
                    stmt.setString(5, entry.getValue());
                    if (!insertUA) {
                        stmt.setInt(6, dataElement.getID());
                        stmt.setLong(7, template.getID().getMostSignificantBits());
                        stmt.setLong(8, template.getID().getLeastSignificantBits());
                        stmt.setString(9, entry.getKey());
                    }
                    stmt.execute();
                    if (stmt.getUpdateCount() == 0) {
                        String msg = String.format("%s of UserAttribue %s of DataElement %s of template %s failed.", insertUA ? "Insert" : "Update", entry.getKey(), dataElement.getName(), template.getID());
                        logger.severe(msg);
                        throw new DataSourceException(msg);
                    }
                    stmt = JDBCTools.close(stmt);
                }
                for (String string : userAttributesToDelete) {
                    stmt = con.prepareStatement(SQLHelp.SimpleQueryGenerator.generateDelete("PMDataElementUserAttributes", SQLConstants.COL_DATAELEMENTUSERATTRIBUTES_PK));
                    stmt.setInt(1, dataElement.getID());
                    stmt.setLong(2, template.getID().getMostSignificantBits());
                    stmt.setLong(3, template.getID().getLeastSignificantBits());
                    stmt.setString(4, string);
                    stmt.execute();
                    if (stmt.getUpdateCount() == 0) {
                        String msg = String.format("Deletion of UserAttribue %s of DataElement %s of template %s failed.", string, dataElement.getName(), template.getID());
                        logger.severe(msg);
                        throw new DataSourceException(msg);
                    }
                    stmt = JDBCTools.close(stmt);
                }
                stmt = con.prepareStatement(SQLHelp.SimpleQueryGenerator.generateSelect("PMDataElementPlugins", SQLConstants.COL_DATAELEMENTPLUGINS_ID, SQLConstants.COL_DATAELEMENTPLUGINS_PARENT_ID));
                stmt.setInt(1, dataElement.getID());
                stmt.setLong(2, template.getID().getMostSignificantBits());
                stmt.setLong(3, template.getID().getLeastSignificantBits());
                rs = stmt.executeQuery();
                HashSet<Triple<String, String, String>> hashSet = new HashSet<Triple<String, String, String>>();
                while (rs.next()) {
                    Triple<String, String, String> triple = new Triple<String, String, String>(SQLHelp.getString(rs, 1), SQLHelp.getString(rs, 2), SQLHelp.getString(rs, 3));
                    hashSet.add(triple);
                }
                rs = JDBCTools.close(rs);
                stmt = JDBCTools.close(stmt);
                for (Map.Entry<String, Set<String>> entry : dataElement.getSupportedPlugins().entrySet()) {
                    for (String pluginID : entry.getValue()) {
                        Map<String, String> dataMap;
                        PluginData data = dataElement.getPluginData(pluginID);
                        if (data != null) {
                            dataMap = data.getPluginData();
                        } else {
                            dataMap = new HashMap<String, String>();
                            dataMap.put(null, null);
                        }
                        for (Map.Entry<String, String> dataRow : dataMap.entrySet()) {
                            Triple<String, String, String> t = new Triple<String, String, String>(dataRow.getKey(), pluginID, entry.getKey());
                            boolean insertPlugin = !hashSet.remove(t);
                            stmt = insertPlugin ? con.prepareStatement(SQLHelp.SimpleQueryGenerator.generateInsert("PMDataElementPlugins", SQLConstants.COL_DATAELEMENTPLUGINS_ALL)) : con.prepareStatement(SQLHelp.SimpleQueryGenerator.generateUpdate("PMDataElementPlugins", SQLConstants.COL_DATAELEMENTPLUGINS_ALL, SQLConstants.COL_DATAELEMENTPLUGINS_PK));
                            stmt.setString(1, dataRow.getKey());
                            stmt.setString(2, dataRow.getValue());
                            stmt.setString(3, pluginID);
                            stmt.setString(4, entry.getKey());
                            stmt.setInt(5, dataElement.getID());
                            stmt.setLong(6, template.getID().getMostSignificantBits());
                            stmt.setLong(7, template.getID().getLeastSignificantBits());
                            if (!insertPlugin) {
                                stmt.setString(8, dataRow.getKey());
                                stmt.setString(9, pluginID);
                                stmt.setString(10, entry.getKey());
                                stmt.setInt(11, dataElement.getID());
                                stmt.setLong(12, template.getID().getMostSignificantBits());
                                stmt.setLong(13, template.getID().getLeastSignificantBits());
                            }
                            stmt.execute();
                            if (stmt.getUpdateCount() == 0) {
                                String msg = String.format("%s of plugin data %s of dataElement %s of template %s failed.", insertPlugin ? "Insert" : "Update", dataRow.getKey(), dataElement.getID(), template.getID());
                                logger.severe(msg);
                                throw new DataSourceException(msg);
                            }
                            stmt = JDBCTools.close(stmt);
                        }
                    }
                }
                for (Triple triple : hashSet) {
                    stmt = con.prepareStatement(SQLHelp.SimpleQueryGenerator.generateDelete("PMDataElementPlugins", SQLConstants.COL_DATAELEMENTPLUGINS_PK));
                    stmt.setString(1, (String)triple.getFirst());
                    stmt.setString(2, (String)triple.getSecond());
                    stmt.setString(3, (String)triple.getThird());
                    stmt.setInt(4, dataElement.getID());
                    stmt.setLong(5, template.getID().getMostSignificantBits());
                    stmt.setLong(6, template.getID().getLeastSignificantBits());
                    stmt.execute();
                    if (stmt.getUpdateCount() == 0) {
                        String msg = String.format("Deletion of plugin data %s of plugin %s (ExtensionPointID: %s) of dataElement %s of template %s failed.", triple.getFirst(), triple.getSecond(), triple.getThird(), dataElement.getID(), template.getID());
                        logger.severe(msg);
                        throw new DataSourceException(msg);
                    }
                    stmt = JDBCTools.close(stmt);
                }
                if (ownConnection) {
                    con = JDBCTools.close(con);
                } else if (doCommit) {
                    con = JDBCTools.commit(con);
                }
            }
            catch (SQLException e) {
                throw new DataSourceException("SQLException", e);
            }
        }
        catch (Throwable throwable) {
            if (ownConnection || doCommit) {
                JDBCTools.rollbackQuietly(con);
            }
            if (ownConnection) {
                JDBCTools.closeQuietly(con, stmt, rs);
            } else {
                JDBCTools.closeQuietly(stmt, rs);
            }
            throw throwable;
        }
        if (ownConnection || doCommit) {
            JDBCTools.rollbackQuietly(con);
        }
        if (ownConnection) {
            JDBCTools.closeQuietly(con, (Statement)stmt, rs);
        } else {
            JDBCTools.closeQuietly((Statement)stmt, rs);
        }
        logger.finer("SQLHelpWrite.insertOrUpdateDataElement() exit");
    }

    /*
     * WARNING - void declaration
     */
    public static void insertOrUpdateTemplate(JDBCDataSource dataSource, Template template, ExtendedConnection con, boolean doCommit) throws DataSourceException {
        logger.finer("SQLHelpWrite.insertOrUpdateTemplate() entry");
        boolean ownConnection = con == null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            try {
                String value;
                void var21_52;
                int n;
                String msg;
                Object msg2;
                if (ownConnection) {
                    con = dataSource.getConnection();
                }
                con.setAutoCommit(false);
                boolean insert = !SQLHelpWrite.entryExists(con, "PMTemplate", SQLConstants.COL_TEMPLATE_PK, new SQLHelp.ParameterList(new int[]{-5, -5}, new Object[]{template.getID().getMostSignificantBits(), template.getID().getLeastSignificantBits()}));
                stmt = insert ? con.prepareStatement(SQLHelp.SimpleQueryGenerator.generateInsert("PMTemplate", SQLConstants.COL_TEMPLATE_ALL)) : con.prepareStatement(SQLHelp.SimpleQueryGenerator.generateUpdate("PMTemplate", SQLConstants.COL_TEMPLATE_ALL, SQLConstants.COL_TEMPLATE_PK));
                stmt.setLong(1, template.getID().getMostSignificantBits());
                stmt.setLong(2, template.getID().getLeastSignificantBits());
                stmt.setString(3, template.getDescription());
                stmt.setString(4, template.getInstanceNameTemplate());
                stmt.setString(5, template.getName());
                stmt.setString(6, template.getProcessType());
                stmt.setLong(7, template.getSupervisorAgent().getAgentID());
                stmt.setString(8, template.getSupervisorAgent().getAgentUserName());
                stmt.setLong(9, template.getSupervisorAgent().getOrgPositionID());
                stmt.setString(10, template.getSupervisorAgent().getOrgPositionName());
                stmt.setString(11, template.getVersion());
                stmt.setInt(12, template.getStartNode().getID());
                stmt.setInt(13, template.getEndNode().getID());
                if (!insert) {
                    stmt.setLong(14, template.getID().getMostSignificantBits());
                    stmt.setLong(15, template.getID().getLeastSignificantBits());
                }
                stmt.execute();
                if (stmt.getUpdateCount() == 0) {
                    String msg3 = String.format("%s of template %s failed.", insert ? "Insert" : "Update", template.getID());
                    logger.severe(msg3);
                    throw new DataSourceException(msg3);
                }
                stmt = JDBCTools.close(stmt);
                stmt = con.prepareStatement(SQLHelp.SimpleQueryGenerator.generateSelect("PMTemplateUserAttributes", SQLConstants.COL_TEMPLATEUSERATTRIBUTES_ID, SQLConstants.COL_TEMPLATEUSERATTRIBUTES_PARENT_ID));
                stmt.setLong(1, template.getID().getMostSignificantBits());
                stmt.setLong(2, template.getID().getLeastSignificantBits());
                rs = stmt.executeQuery();
                HashSet<String> userAttributesToDelete = new HashSet<String>();
                while (rs.next()) {
                    userAttributesToDelete.add(SQLHelp.getString(rs, 1));
                }
                rs = JDBCTools.close(rs);
                stmt = JDBCTools.close(stmt);
                for (Map.Entry<String, String> entry : template.getUserAttributes().entrySet()) {
                    boolean insertUA = !userAttributesToDelete.remove(entry.getKey());
                    stmt = insertUA ? con.prepareStatement(SQLHelp.SimpleQueryGenerator.generateInsert("PMTemplateUserAttributes", SQLConstants.COL_TEMPLATEUSERATTRIBUTES_ALL)) : con.prepareStatement(SQLHelp.SimpleQueryGenerator.generateUpdate("PMTemplateUserAttributes", SQLConstants.COL_TEMPLATEUSERATTRIBUTES_ALL, SQLConstants.COL_TEMPLATEUSERATTRIBUTES_PK));
                    stmt.setLong(1, template.getID().getMostSignificantBits());
                    stmt.setLong(2, template.getID().getLeastSignificantBits());
                    stmt.setString(3, entry.getKey());
                    stmt.setString(4, entry.getValue());
                    if (!insertUA) {
                        stmt.setLong(5, template.getID().getMostSignificantBits());
                        stmt.setLong(6, template.getID().getLeastSignificantBits());
                        stmt.setString(7, entry.getKey());
                    }
                    stmt.execute();
                    if (stmt.getUpdateCount() == 0) {
                        String string = String.format("%s of template (%s) user attribute %s failed.", insertUA ? "Insert" : "Update", template.getID(), entry.getKey());
                        logger.severe(string);
                        throw new DataSourceException(string);
                    }
                    stmt = JDBCTools.close(stmt);
                }
                for (String string : userAttributesToDelete) {
                    stmt = con.prepareStatement(SQLHelp.SimpleQueryGenerator.generateDelete("PMTemplateUserAttributes", SQLConstants.COL_TEMPLATEUSERATTRIBUTES_PK));
                    stmt.setLong(1, template.getID().getMostSignificantBits());
                    stmt.setLong(2, template.getID().getLeastSignificantBits());
                    stmt.setString(3, string);
                    stmt.execute();
                    if (stmt.getUpdateCount() == 0) {
                        String msg5 = String.format("Deletion of user attribute %s of template (%s) failed.", string, template.getID());
                        logger.severe(msg5);
                        throw new DataSourceException(msg5);
                    }
                    stmt = JDBCTools.close(stmt);
                }
                stmt = con.prepareStatement(SQLHelp.SimpleQueryGenerator.generateSelect("PMNode", SQLConstants.COL_NODE_ID, SQLConstants.COL_NODE_PARENT_ID));
                stmt.setLong(1, template.getID().getMostSignificantBits());
                stmt.setLong(2, template.getID().getLeastSignificantBits());
                rs = stmt.executeQuery();
                HashSet<Integer> hashSet = new HashSet<Integer>();
                while (rs.next()) {
                    hashSet.add(rs.getInt(1));
                }
                rs = JDBCTools.close(rs);
                stmt = JDBCTools.close(stmt);
                for (Node n2 : template.getNodes()) {
                    hashSet.remove(n2.getID());
                    SQLHelpWrite.insertOrUpdateNode(dataSource, template, n2, con, false);
                }
                HashSet<Integer> dataElementsToDelete = new HashSet<Integer>();
                stmt = con.prepareStatement(SQLHelp.SimpleQueryGenerator.generateSelect("PMDataElement", SQLConstants.COL_DATAELEMENT_ID, SQLConstants.COL_DATAELEMENT_PARENT_ID));
                stmt.setLong(1, template.getID().getMostSignificantBits());
                stmt.setLong(2, template.getID().getLeastSignificantBits());
                rs = stmt.executeQuery();
                while (rs.next()) {
                    dataElementsToDelete.add(rs.getInt(1));
                }
                rs = JDBCTools.close(rs);
                stmt = JDBCTools.close(stmt);
                for (DataElement de : template.getDataElements()) {
                    dataElementsToDelete.remove(de.getID());
                    SQLHelpWrite.insertOrUpdateDataElement(dataSource, template, de, con, false);
                }
                HashSet<Triple<Integer, Integer, Integer>> dataEdgeToDelete = new HashSet<Triple<Integer, Integer, Integer>>();
                stmt = con.prepareStatement(SQLHelp.SimpleQueryGenerator.generateSelect("PMDataEdge", SQLConstants.COL_DATAEDGE_ID, SQLConstants.COL_DATAEDGE_PARENT_ID));
                stmt.setLong(1, template.getID().getMostSignificantBits());
                stmt.setLong(2, template.getID().getLeastSignificantBits());
                rs = stmt.executeQuery();
                while (rs.next()) {
                    dataEdgeToDelete.add(new Triple<Integer, Integer, Integer>(rs.getInt(1), rs.getInt(2), rs.getInt(3)));
                }
                rs = JDBCTools.close(rs);
                stmt = JDBCTools.close(stmt);
                for (StructuredDataEdge structuredDataEdge : template.getDataEdgeStructure()) {
                    Triple<Integer, Integer, Integer> p = new Triple<Integer, Integer, Integer>(structuredDataEdge.getNodeID(), structuredDataEdge.getDataElementID(), structuredDataEdge.getDataEdgeType().getCode());
                    dataEdgeToDelete.remove(p);
                    SQLHelpWrite.insertOrUpdateDataEdge(dataSource, template, structuredDataEdge, con, false);
                }
                for (Triple triple : dataEdgeToDelete) {
                    stmt = con.prepareStatement(SQLHelp.SimpleQueryGenerator.generateDelete("PMDataEdge", SQLConstants.COL_DATAEDGE_PK));
                    stmt.setLong(1, template.getID().getMostSignificantBits());
                    stmt.setLong(2, template.getID().getLeastSignificantBits());
                    stmt.setInt(3, (Integer)triple.getFirst());
                    stmt.setInt(4, (Integer)triple.getSecond());
                    stmt.setInt(5, (Integer)triple.getThird());
                    stmt.execute();
                    if (stmt.getUpdateCount() == 0) {
                        msg2 = String.format("Deletion of DataEdge from node #%s to dataElement #%s of template (%s) failed.", triple.getFirst(), triple.getSecond(), template.getID());
                        logger.severe((String)msg2);
                        throw new DataSourceException((String)msg2);
                    }
                    stmt = JDBCTools.close(stmt);
                }
                HashSet<Pair<Integer, Integer>> hashSet2 = new HashSet<Pair<Integer, Integer>>();
                stmt = con.prepareStatement(SQLHelp.SimpleQueryGenerator.generateSelect("PMEdge", SQLConstants.COL_EDGE_ID, SQLConstants.COL_EDGE_PARENT_ID));
                stmt.setLong(1, template.getID().getMostSignificantBits());
                stmt.setLong(2, template.getID().getLeastSignificantBits());
                rs = stmt.executeQuery();
                while (rs.next()) {
                    hashSet2.add(new Pair<Integer, Integer>(rs.getInt(1), rs.getInt(2)));
                }
                rs = JDBCTools.close(rs);
                stmt = JDBCTools.close(stmt);
                for (StructuredEdge structuredEdge : template.getEdgeStructure(ProcessConstants.EdgeType.values())) {
                    Pair<Integer, Integer> p = new Pair<Integer, Integer>(structuredEdge.getSourceNodeID(), structuredEdge.getDestinationNodeID());
                    hashSet2.remove(p);
                    SQLHelpWrite.insertOrUpdateEdge(dataSource, template, structuredEdge, con, false);
                }
                for (Pair pair : hashSet2) {
                    stmt = con.prepareStatement(SQLHelp.SimpleQueryGenerator.generateDelete("PMEdge", SQLConstants.COL_EDGE_PK));
                    stmt.setLong(1, template.getID().getMostSignificantBits());
                    stmt.setLong(2, template.getID().getLeastSignificantBits());
                    stmt.setInt(3, (Integer)pair.getFirst());
                    stmt.setInt(4, (Integer)pair.getSecond());
                    stmt.execute();
                    if (stmt.getUpdateCount() == 0) {
                        msg = String.format("Deletion of Edge (StartNode: %s, EndNode: %s) of template (%s) failed.", pair.getFirst(), pair.getSecond(), template.getID());
                        logger.severe(msg);
                        throw new DataSourceException(msg);
                    }
                    stmt = JDBCTools.close(stmt);
                }
                if (hashSet.size() > 0) {
                    stmt = con.prepareStatement(SQLHelp.SimpleQueryGenerator.generateDelete("PMProcessModelParameter", SQLConstants.COL_PROCESSMODELPARAMETER_PARENT_ID));
                    for (Integer n2 : hashSet) {
                        stmt.setInt(1, n2);
                        stmt.setLong(2, template.getID().getMostSignificantBits());
                        stmt.setLong(3, template.getID().getLeastSignificantBits());
                        stmt.execute();
                    }
                    stmt = JDBCTools.close(stmt);
                }
                for (Integer n3 : hashSet) {
                    stmt = con.prepareStatement(SQLHelp.SimpleQueryGenerator.generateDelete("PMNode", SQLConstants.COL_NODE_PK));
                    stmt.setLong(1, template.getID().getMostSignificantBits());
                    stmt.setLong(2, template.getID().getLeastSignificantBits());
                    stmt.setInt(3, n3);
                    stmt.execute();
                    if (stmt.getUpdateCount() == 0) {
                        msg = String.format("Deletion of node %s of template (%s) failed.", n3, template.getID());
                        logger.severe(msg);
                        throw new DataSourceException(msg);
                    }
                    stmt = JDBCTools.close(stmt);
                }
                msg2 = dataElementsToDelete.iterator();
                while (msg2.hasNext()) {
                    int n4 = (Integer)msg2.next();
                    stmt = con.prepareStatement(SQLHelp.SimpleQueryGenerator.generateDelete("PMDataElement", SQLConstants.COL_DATAELEMENT_PK));
                    stmt.setInt(1, n4);
                    stmt.setLong(2, template.getID().getMostSignificantBits());
                    stmt.setLong(3, template.getID().getLeastSignificantBits());
                    stmt.execute();
                    if (stmt.getUpdateCount() == 0) {
                        msg = String.format("Deletion of DataElement #%s of template (%s) failed.", n4, template.getID());
                        logger.severe(msg);
                        throw new DataSourceException(msg);
                    }
                    stmt = JDBCTools.close(stmt);
                }
                HashSet<Object> hashSet3 = new HashSet<Object>();
                con.commit();
                ComplexSelectGenerator.Table tabTemplate = new ComplexSelectGenerator.Table("PMTemplate", new String[0], ComplexSelectGenerator.generateWhereStatementEquals(SQLConstants.COL_TEMPLATE_PK));
                ComplexSelectGenerator.Table tabParam = new ComplexSelectGenerator.Table("INNER JOIN", "PMProcessModelParameter", SQLConstants.COL_PROCESSMODELPARAMETER_PK, new ComplexSelectGenerator.WhereStatement[0]);
                ComplexSelectGenerator.WhereStatement joinOnNodeID = new ComplexSelectGenerator.WhereStatement(tabTemplate, SQLConstants.COL_TEMPLATE_ALL[11], "=", tabParam, SQLConstants.COL_PROCESSMODELPARAMETER_PK[3]);
                joinOnNodeID.orWith(new ComplexSelectGenerator.WhereStatement(tabTemplate, SQLConstants.COL_TEMPLATE_ALL[12], "=", tabParam, SQLConstants.COL_PROCESSMODELPARAMETER_PK[3]));
                ComplexSelectGenerator.WhereStatement joinOnTemplateID = new ComplexSelectGenerator.WhereStatement(tabTemplate, SQLConstants.COL_TEMPLATE_ALL[0], "=", tabParam, SQLConstants.COL_PROCESSMODELPARAMETER_PK[4]);
                joinOnTemplateID.andWith(new ComplexSelectGenerator.WhereStatement(tabTemplate, SQLConstants.COL_TEMPLATE_ALL[1], "=", tabParam, SQLConstants.COL_PROCESSMODELPARAMETER_PK[5]));
                ComplexSelectGenerator.WhereStatement joinOn = new ComplexSelectGenerator.WhereStatement(joinOnTemplateID);
                joinOn.andWith(joinOnNodeID);
                tabParam.addWhereStatements(joinOn);
                ComplexSelectGenerator select = new ComplexSelectGenerator(tabTemplate, tabParam);
                stmt = con.prepareStatement(select.toString());
                stmt.setLong(1, template.getID().getMostSignificantBits());
                stmt.setLong(2, template.getID().getLeastSignificantBits());
                rs = stmt.executeQuery();
                while (rs.next()) {
                    ActivityConstants.AccessType accessType = ActivityConstants.AccessType.valueOf(rs.getInt(1));
                    ActivityConstants.AccessType[] accessTypeArray = ActivityConstants.AccessType.activityRelatedValues();
                    int n5 = accessTypeArray.length;
                    n = 0;
                    while (n < n5) {
                        ActivityConstants.AccessType accessType2 = accessTypeArray[n];
                        if (accessType.equals((Object)accessType2)) {
                            Triple<ActivityConstants.AccessType, Integer, String> t = new Triple<ActivityConstants.AccessType, Integer, String>(accessType, rs.getInt(4), SQLHelp.getString(rs, 2));
                            hashSet3.add(t);
                        }
                        ++n;
                    }
                }
                rs = JDBCTools.close(rs);
                stmt = JDBCTools.close(stmt);
                ActivityConstants.AccessType[] accessTypeArray = ActivityConstants.AccessType.activityRelatedValues();
                n = accessTypeArray.length;
                boolean bl = false;
                while (var21_52 < n) {
                    ActivityConstants.AccessType accessType = accessTypeArray[var21_52];
                    for (ProcessModelParameter processModelParameter : template.getParameters(accessType)) {
                        Node node = accessType == ActivityConstants.AccessType.READ ? template.getStartNode() : template.getEndNode();
                        int n6 = node.getID();
                        SQLHelpWrite.insertOrUpdateParameter(dataSource, processModelParameter, accessType, false, false, template, node, con, false);
                        Triple<ActivityConstants.AccessType, Integer, String> t = new Triple<ActivityConstants.AccessType, Integer, String>(accessType, n6, processModelParameter.getName());
                        hashSet3.remove(t);
                    }
                    ++var21_52;
                }
                for (Triple triple : hashSet3) {
                    stmt = con.prepareStatement(SQLHelp.SimpleQueryGenerator.generateDelete("PMProcessModelParameter", SQLConstants.COL_PROCESSMODELPARAMETER_PK));
                    stmt.setInt(1, ((ActivityConstants.AccessType)((Object)triple.getFirst())).getCode());
                    stmt.setString(2, (String)triple.getThird());
                    stmt.setBoolean(3, false);
                    stmt.setInt(4, (Integer)triple.getSecond());
                    stmt.setLong(5, template.getID().getMostSignificantBits());
                    stmt.setLong(6, template.getID().getLeastSignificantBits());
                    stmt.execute();
                    if (stmt.getUpdateCount() == 0) {
                        String msg6 = String.format("Deletion of template parameter %s (AccessType %s, Node %s) of template %s failed.", triple.getThird(), triple.getFirst(), triple.getSecond(), template.getID());
                        logger.severe(msg6);
                        throw new DataSourceException(msg6);
                    }
                    stmt = JDBCTools.close(stmt);
                }
                stmt = con.prepareStatement(SQLHelp.SimpleQueryGenerator.generateSelect("PMTemplatePlugins", SQLConstants.COL_TEMPLATEPLUGINS_ID, SQLConstants.COL_TEMPLATEPLUGINS_PARENT_ID));
                stmt.setLong(1, template.getID().getMostSignificantBits());
                stmt.setLong(2, template.getID().getLeastSignificantBits());
                rs = stmt.executeQuery();
                HashSet<Triple<String, String, String>> hashSet4 = new HashSet<Triple<String, String, String>>();
                while (rs.next()) {
                    Triple<String, String, String> triple = new Triple<String, String, String>(SQLHelp.getString(rs, 1), SQLHelp.getString(rs, 2), SQLHelp.getString(rs, 3));
                    hashSet4.add(triple);
                }
                rs = JDBCTools.close(rs);
                stmt = JDBCTools.close(stmt);
                for (Map.Entry<String, Set<String>> entry : template.getSupportedPlugins().entrySet()) {
                    for (String pluginID : entry.getValue()) {
                        Map<String, String> dataMap;
                        PluginData data = template.getPluginData(pluginID);
                        if (data != null) {
                            dataMap = data.getPluginData();
                        } else {
                            dataMap = new HashMap<String, String>();
                            dataMap.put(null, null);
                        }
                        for (Map.Entry entry2 : dataMap.entrySet()) {
                            Triple<String, String, String> t = new Triple<String, String, String>((String)entry2.getKey(), pluginID, entry.getKey());
                            boolean bl2 = !hashSet4.remove(t);
                            stmt = bl2 ? con.prepareStatement(SQLHelp.SimpleQueryGenerator.generateInsert("PMTemplatePlugins", SQLConstants.COL_TEMPLATEPLUGINS_ALL)) : con.prepareStatement(SQLHelp.SimpleQueryGenerator.generateUpdate("PMTemplatePlugins", SQLConstants.COL_TEMPLATEPLUGINS_ALL, SQLConstants.COL_TEMPLATEPLUGINS_PK));
                            stmt.setString(1, (String)entry2.getKey());
                            stmt.setString(2, (String)entry2.getValue());
                            stmt.setString(3, pluginID);
                            stmt.setString(4, entry.getKey());
                            stmt.setLong(5, template.getID().getMostSignificantBits());
                            stmt.setLong(6, template.getID().getLeastSignificantBits());
                            if (!bl2) {
                                stmt.setString(7, (String)entry2.getKey());
                                stmt.setString(8, pluginID);
                                stmt.setString(9, entry.getKey());
                                stmt.setLong(10, template.getID().getMostSignificantBits());
                                stmt.setLong(11, template.getID().getLeastSignificantBits());
                            }
                            stmt.execute();
                            if (stmt.getUpdateCount() == 0) {
                                String string = String.format("%s of plugin data %s of template %s failed.", bl2 ? "Insert" : "Update", entry2.getKey(), template.getID());
                                logger.severe(string);
                                throw new DataSourceException(string);
                            }
                            stmt = JDBCTools.close(stmt);
                        }
                    }
                }
                for (Triple triple : hashSet4) {
                    stmt = con.prepareStatement(SQLHelp.SimpleQueryGenerator.generateDelete("PMTemplatePlugins", SQLConstants.COL_TEMPLATEPLUGINS_PK));
                    stmt.setString(1, (String)triple.getFirst());
                    stmt.setString(2, (String)triple.getSecond());
                    stmt.setString(3, (String)triple.getThird());
                    stmt.setLong(4, template.getID().getMostSignificantBits());
                    stmt.setLong(5, template.getID().getLeastSignificantBits());
                    stmt.execute();
                    if (stmt.getUpdateCount() == 0) {
                        String msg8 = String.format("Deletion of plugin data %s of plugin %s (ExtensionPointID: %s) of template %s failed.", triple.getFirst(), triple.getSecond(), triple.getThird(), template.getID());
                        logger.severe(msg8);
                        throw new DataSourceException(msg8);
                    }
                    stmt = JDBCTools.close(stmt);
                }
                HashMap hashMap = new HashMap();
                stmt = con.prepareStatement(SQLHelp.SimpleQueryGenerator.generateSelect("PMTemplateConfiguration", SQLConstants.COL_TEMPLATECONFIGURATION_ID, SQLConstants.COL_TEMPLATECONFIGURATION_PARENT_ID));
                stmt.setLong(1, template.getID().getMostSignificantBits());
                stmt.setLong(2, template.getID().getLeastSignificantBits());
                rs = stmt.executeQuery();
                while (rs.next()) {
                    if (!hashMap.containsKey(rs.getInt(1))) {
                        hashMap.put(rs.getInt(1), new HashSet());
                    }
                    ((Set)hashMap.get(rs.getInt(1))).add(SQLHelp.getString(rs, 2));
                }
                rs = JDBCTools.close(rs);
                stmt = JDBCTools.close(stmt);
                HashMap confValues = new HashMap();
                HashMap fixedConfValues = new HashMap();
                for (String string : template.getConfiguration().getAllEntries()) {
                    value = template.getConfiguration().getString(string);
                    int n7 = 1;
                    if (!confValues.containsKey(n7)) {
                        confValues.put(n7, new HashMap());
                    }
                    ((Map)confValues.get(n7)).put(string, value);
                    if (!fixedConfValues.containsKey(n7)) {
                        fixedConfValues.put(n7, new HashSet());
                    }
                    if (!template.getConfiguration().isFixed(string)) continue;
                    ((Set)fixedConfValues.get(n7)).add(string);
                }
                for (String string : template.getTestConfiguration().getAllEntries()) {
                    value = template.getTestConfiguration().getString(string);
                    int n8 = 4;
                    if (!confValues.containsKey(n8)) {
                        confValues.put(n8, new HashMap());
                    }
                    ((Map)confValues.get(n8)).put(string, value);
                    if (!fixedConfValues.containsKey(n8)) {
                        fixedConfValues.put(n8, new HashSet());
                    }
                    if (!template.getTestConfiguration().isFixed(string)) continue;
                    ((Set)fixedConfValues.get(n8)).add(string);
                }
                for (Map.Entry entry : confValues.entrySet()) {
                    for (Map.Entry data : ((Map)entry.getValue()).entrySet()) {
                        if (hashMap.containsKey(entry.getKey()) && ((Set)hashMap.get(entry.getKey())).contains(data.getKey())) {
                            ((Set)hashMap.get(entry.getKey())).remove(data.getKey());
                        }
                        boolean insertConf = !SQLHelpWrite.entryExists(con, "PMTemplateConfiguration", SQLConstants.COL_TEMPLATECONFIGURATION_PK, new SQLHelp.ParameterList(new int[]{-5, -5, 4, 12}, new Object[]{template.getID().getMostSignificantBits(), template.getID().getLeastSignificantBits(), entry.getKey(), data.getKey()}));
                        stmt = insertConf ? con.prepareStatement(SQLHelp.SimpleQueryGenerator.generateInsert("PMTemplateConfiguration", SQLConstants.COL_TEMPLATECONFIGURATION_ALL)) : con.prepareStatement(SQLHelp.SimpleQueryGenerator.generateUpdate("PMTemplateConfiguration", SQLConstants.COL_TEMPLATECONFIGURATION_ALL, SQLConstants.COL_TEMPLATECONFIGURATION_PK));
                        stmt.setLong(1, template.getID().getMostSignificantBits());
                        stmt.setLong(2, template.getID().getLeastSignificantBits());
                        stmt.setInt(3, (Integer)entry.getKey());
                        stmt.setString(4, (String)data.getKey());
                        stmt.setString(5, (String)data.getValue());
                        stmt.setBoolean(6, ((Set)fixedConfValues.get(entry.getKey())).contains(data.getKey()));
                        if (!insertConf) {
                            stmt.setLong(7, template.getID().getMostSignificantBits());
                            stmt.setLong(8, template.getID().getLeastSignificantBits());
                            stmt.setInt(9, (Integer)entry.getKey());
                            stmt.setString(10, (String)data.getKey());
                        }
                        stmt.execute();
                        if (stmt.getUpdateCount() == 0) {
                            String msg9 = String.format("%s of Configuration %s (Type: %s)of template (%s) failed.", insertConf ? "Insert" : "Update", data.getKey(), ((Integer)entry.getKey()).toString(), template.getID());
                            logger.severe(msg9);
                            throw new DataSourceException(msg9);
                        }
                        stmt = JDBCTools.close(stmt);
                    }
                }
                for (Map.Entry entry : hashMap.entrySet()) {
                    for (String dataKey : (Set)entry.getValue()) {
                        stmt = con.prepareStatement(SQLHelp.SimpleQueryGenerator.generateDelete("PMTemplateConfiguration", SQLConstants.COL_TEMPLATECONFIGURATION_PK));
                        stmt.setLong(1, template.getID().getMostSignificantBits());
                        stmt.setLong(2, template.getID().getLeastSignificantBits());
                        stmt.setInt(3, (Integer)entry.getKey());
                        stmt.setString(4, dataKey);
                        stmt.execute();
                        if (stmt.getUpdateCount() == 0) {
                            String msg10 = String.format("Deletion of Configuration %s (Type %s) of template %s failed.", dataKey, ((Integer)entry.getKey()).toString(), template.getID());
                            logger.severe(msg10);
                            throw new DataSourceException(msg10);
                        }
                        stmt = JDBCTools.close(stmt);
                    }
                }
                HashSet<String> hashSet5 = new HashSet<String>();
                stmt = con.prepareStatement(SQLHelp.SimpleQueryGenerator.generateSelect("PMTemplateConfDescription", SQLConstants.COL_TEMPLATECONFIGURATIONDESCRIPTION_ID, SQLConstants.COL_TEMPLATECONFIGURATIONDESCRIPTION_PARENT_ID));
                stmt.setLong(1, template.getID().getMostSignificantBits());
                stmt.setLong(2, template.getID().getLeastSignificantBits());
                rs = stmt.executeQuery();
                while (rs.next()) {
                    hashSet5.add(SQLHelp.getString(rs, 1));
                }
                rs = JDBCTools.close(rs);
                stmt = JDBCTools.close(stmt);
                for (Map.Entry<String, ConfigurationDescription.ConfigurationEntry> confDescEntry : template.getConfigurationDescription().getEntries().entrySet()) {
                    void var30_98;
                    boolean bl3 = !hashSet5.remove(confDescEntry.getKey());
                    stmt = bl3 ? con.prepareStatement(SQLHelp.SimpleQueryGenerator.generateInsert("PMTemplateConfDescription", SQLConstants.COL_TEMPLATECONFIGURATIONDESCRIPTION_ALL)) : con.prepareStatement(SQLHelp.SimpleQueryGenerator.generateUpdate("PMTemplateConfDescription", SQLConstants.COL_TEMPLATECONFIGURATIONDESCRIPTION_ALL, SQLConstants.COL_TEMPLATECONFIGURATIONDESCRIPTION_PK));
                    stmt.setLong(1, template.getID().getMostSignificantBits());
                    stmt.setLong(2, template.getID().getLeastSignificantBits());
                    stmt.setString(3, confDescEntry.getValue().getName());
                    stmt.setString(4, confDescEntry.getValue().getDescription());
                    stmt.setInt(5, confDescEntry.getValue().getDataType().getCode());
                    stmt.setBoolean(6, confDescEntry.getValue().isOptional());
                    if (!bl3) {
                        stmt.setLong(7, template.getID().getMostSignificantBits());
                        stmt.setLong(8, template.getID().getLeastSignificantBits());
                        stmt.setString(9, confDescEntry.getValue().getName());
                    }
                    stmt.execute();
                    if (stmt.getUpdateCount() == 0) {
                        String msg11 = String.format("%s of ConfigurationDescription %sof template (%s) failed.", bl3 ? "Insert" : "Update", confDescEntry.getKey(), template.getID());
                        logger.severe(msg11);
                        throw new DataSourceException(msg11);
                    }
                    stmt = JDBCTools.close(stmt);
                    HashSet<String> restrictionsToDelete = new HashSet<String>();
                    if (!bl3) {
                        stmt = con.prepareStatement(SQLHelp.SimpleQueryGenerator.generateSelect("PMTemplateConfDescRestriction", SQLConstants.COL_TEMPLATECONFIGURATIONDESCRIPTIONRESTRICTION_ALL, SQLConstants.COL_TEMPLATECONFIGURATIONDESCRIPTIONRESTRICTION_PARENT_ID));
                        stmt.setLong(1, template.getID().getMostSignificantBits());
                        stmt.setLong(2, template.getID().getLeastSignificantBits());
                        rs = stmt.executeQuery();
                        while (rs.next()) {
                            restrictionsToDelete.add(SQLHelp.getString(rs, 4));
                        }
                        rs = JDBCTools.close(rs);
                        stmt = JDBCTools.close(stmt);
                    }
                    String[] stringArray = confDescEntry.getValue().getRestrictions();
                    int n9 = stringArray.length;
                    boolean bl4 = false;
                    while (var30_98 < n9) {
                        boolean insertRestriction;
                        String restriction = stringArray[var30_98];
                        boolean bl5 = insertRestriction = !restrictionsToDelete.remove(restriction);
                        if (insertRestriction) {
                            stmt = con.prepareStatement(SQLHelp.SimpleQueryGenerator.generateInsert("PMTemplateConfDescRestriction", SQLConstants.COL_TEMPLATECONFIGURATIONDESCRIPTIONRESTRICTION_ALL));
                            stmt.setLong(1, template.getID().getMostSignificantBits());
                            stmt.setLong(2, template.getID().getLeastSignificantBits());
                            stmt.setString(3, confDescEntry.getKey());
                            stmt.setString(4, restriction);
                            stmt.execute();
                            if (stmt.getUpdateCount() == 0) {
                                String msg12 = String.format("%s of ConfigurationDescription restriction %s of ConfDesc %sof template (%s) failed.", insertRestriction ? "Insert" : "Update", restriction, confDescEntry.getKey(), template.getID());
                                logger.severe(msg12);
                                throw new DataSourceException(msg12);
                            }
                            stmt = JDBCTools.close(stmt);
                        }
                        ++var30_98;
                    }
                    for (String restriction : restrictionsToDelete) {
                        stmt = con.prepareStatement(SQLHelp.SimpleQueryGenerator.generateDelete("PMTemplateConfDescRestriction", SQLConstants.COL_TEMPLATECONFIGURATIONDESCRIPTIONRESTRICTION_PK));
                        stmt.setLong(1, template.getID().getMostSignificantBits());
                        stmt.setLong(2, template.getID().getLeastSignificantBits());
                        stmt.setString(3, confDescEntry.getKey());
                        stmt.setString(4, restriction);
                        stmt.execute();
                        if (stmt.getUpdateCount() == 0) {
                            String string = String.format("Deletion of ConfigurationDescription restriction %s of ConfDesc %sof template (%s) failed.", restriction, confDescEntry.getKey(), template.getID());
                            logger.severe(string);
                            throw new DataSourceException(string);
                        }
                        stmt = JDBCTools.close(stmt);
                    }
                    stmt = con.prepareStatement(SQLHelp.SimpleQueryGenerator.generateSelect("PMTemplateConfDescUA", SQLConstants.COL_TEMPLATECONFIGURATIONDESCRIPTIONUA_PK, SQLConstants.COL_TEMPLATECONFIGURATIONDESCRIPTIONUA_PARENT_ID));
                    stmt.setLong(1, template.getID().getMostSignificantBits());
                    stmt.setLong(2, template.getID().getLeastSignificantBits());
                    stmt.setString(3, confDescEntry.getKey());
                    rs = stmt.executeQuery();
                    HashSet<String> userAttributesToDeleteConfDesc = new HashSet<String>();
                    while (rs.next()) {
                        userAttributesToDeleteConfDesc.add(SQLHelp.getString(rs, 4));
                    }
                    rs = JDBCTools.close(rs);
                    stmt = JDBCTools.close(stmt);
                    for (Map.Entry<String, String> entry : confDescEntry.getValue().getUserAttributes().entrySet()) {
                        boolean insertUA = !userAttributesToDeleteConfDesc.remove(entry.getKey());
                        stmt = insertUA ? con.prepareStatement(SQLHelp.SimpleQueryGenerator.generateInsert("PMTemplateConfDescUA", SQLConstants.COL_TEMPLATECONFIGURATIONDESCRIPTIONUA_ALL)) : con.prepareStatement(SQLHelp.SimpleQueryGenerator.generateUpdate("PMTemplateConfDescUA", SQLConstants.COL_TEMPLATECONFIGURATIONDESCRIPTIONUA_ALL, SQLConstants.COL_TEMPLATECONFIGURATIONDESCRIPTIONUA_PK));
                        stmt.setLong(1, template.getID().getMostSignificantBits());
                        stmt.setLong(2, template.getID().getLeastSignificantBits());
                        stmt.setString(3, confDescEntry.getKey());
                        stmt.setString(4, entry.getKey());
                        stmt.setString(5, entry.getValue());
                        if (!insertUA) {
                            stmt.setLong(6, template.getID().getMostSignificantBits());
                            stmt.setLong(7, template.getID().getLeastSignificantBits());
                            stmt.setString(8, confDescEntry.getKey());
                            stmt.setString(9, entry.getKey());
                        }
                        stmt.execute();
                        if (stmt.getUpdateCount() == 0) {
                            String msg14 = String.format("%s of ConfDesc %s of template %s user attribute %s failed.", insertUA ? "Insert" : "Update", confDescEntry.getKey(), template.getID(), entry.getKey());
                            logger.severe(msg14);
                            throw new DataSourceException(msg14);
                        }
                        stmt = JDBCTools.close(stmt);
                    }
                    for (String string : userAttributesToDeleteConfDesc) {
                        stmt = con.prepareStatement(SQLHelp.SimpleQueryGenerator.generateDelete("PMTemplateConfDescUA", SQLConstants.COL_TEMPLATECONFIGURATIONDESCRIPTIONUA_PK));
                        stmt.setLong(1, template.getID().getMostSignificantBits());
                        stmt.setLong(2, template.getID().getLeastSignificantBits());
                        stmt.setString(3, confDescEntry.getKey());
                        stmt.setString(4, string);
                        stmt.execute();
                        if (stmt.getUpdateCount() == 0) {
                            String msg15 = String.format("Deletion of user attribute %s of ConfDesc %s of template %s failed.", string, confDescEntry.getKey(), template.getID());
                            logger.severe(msg15);
                            throw new DataSourceException(msg15);
                        }
                        stmt = JDBCTools.close(stmt);
                    }
                    stmt = con.prepareStatement(SQLHelp.SimpleQueryGenerator.generateSelect("PMTemplateConfDescPlugins", SQLConstants.COL_TEMPLATECONFIGURATIONDESCRIPTIONPLUGINS_PK, SQLConstants.COL_TEMPLATECONFIGURATIONDESCRIPTIONPLUGINS_PARENT_ID));
                    stmt.setLong(1, template.getID().getMostSignificantBits());
                    stmt.setLong(2, template.getID().getLeastSignificantBits());
                    stmt.setString(3, confDescEntry.getKey());
                    rs = stmt.executeQuery();
                    HashSet<Triple<String, String, String>> hashSet6 = new HashSet<Triple<String, String, String>>();
                    while (rs.next()) {
                        Triple<String, String, String> triple = new Triple<String, String, String>(SQLHelp.getString(rs, 1), SQLHelp.getString(rs, 2), SQLHelp.getString(rs, 3));
                        hashSet6.add(triple);
                    }
                    rs = JDBCTools.close(rs);
                    stmt = JDBCTools.close(stmt);
                    for (Map.Entry entry : confDescEntry.getValue().getSupportedPlugins().entrySet()) {
                        for (String pluginID : (Set)entry.getValue()) {
                            Map<String, String> dataMap;
                            PluginData data = confDescEntry.getValue().getPluginData(pluginID);
                            if (data != null) {
                                dataMap = data.getPluginData();
                            } else {
                                dataMap = new HashMap<String, String>();
                                dataMap.put(null, null);
                            }
                            for (Map.Entry<String, String> dataRow : dataMap.entrySet()) {
                                Triple<String, String, String> t = new Triple<String, String, String>(dataRow.getKey(), pluginID, (String)entry.getKey());
                                boolean insertPlugin2 = !hashSet6.remove(t);
                                stmt = insertPlugin2 ? con.prepareStatement(SQLHelp.SimpleQueryGenerator.generateInsert("PMTemplateConfDescPlugins", SQLConstants.COL_TEMPLATECONFIGURATIONDESCRIPTIONPLUGINS_ALL)) : con.prepareStatement(SQLHelp.SimpleQueryGenerator.generateUpdate("PMTemplateConfDescPlugins", SQLConstants.COL_TEMPLATECONFIGURATIONDESCRIPTIONPLUGINS_ALL, SQLConstants.COL_TEMPLATECONFIGURATIONDESCRIPTIONPLUGINS_PK));
                                stmt.setLong(1, template.getID().getMostSignificantBits());
                                stmt.setLong(2, template.getID().getLeastSignificantBits());
                                stmt.setString(3, confDescEntry.getKey());
                                stmt.setString(4, pluginID);
                                stmt.setString(5, (String)entry.getKey());
                                stmt.setString(6, dataRow.getKey());
                                stmt.setString(7, dataRow.getValue());
                                if (!insertPlugin2) {
                                    stmt.setLong(8, template.getID().getMostSignificantBits());
                                    stmt.setLong(9, template.getID().getLeastSignificantBits());
                                    stmt.setString(10, confDescEntry.getKey());
                                    stmt.setString(11, pluginID);
                                    stmt.setString(12, (String)entry.getKey());
                                    stmt.setString(13, dataRow.getKey());
                                }
                                stmt.execute();
                                if (stmt.getUpdateCount() == 0) {
                                    String msg16 = String.format("%s of plugin data %s of ConfDesc %s of template %s failed.", insertPlugin2 ? "Insert" : "Update", dataRow.getKey(), confDescEntry.getKey(), template.getID());
                                    logger.severe(msg16);
                                    throw new DataSourceException(msg16);
                                }
                                stmt = JDBCTools.close(stmt);
                            }
                        }
                    }
                    for (Triple triple : hashSet6) {
                        stmt = con.prepareStatement(SQLHelp.SimpleQueryGenerator.generateDelete("PMTemplateConfDescPlugins", SQLConstants.COL_TEMPLATECONFIGURATIONDESCRIPTIONPLUGINS_PK));
                        stmt.setLong(1, template.getID().getMostSignificantBits());
                        stmt.setLong(2, template.getID().getLeastSignificantBits());
                        stmt.setString(3, confDescEntry.getKey());
                        stmt.setString(4, (String)triple.getSecond());
                        stmt.setString(5, (String)triple.getThird());
                        stmt.setString(6, (String)triple.getFirst());
                        stmt.execute();
                        if (stmt.getUpdateCount() == 0) {
                            String msg17 = String.format("Deletion of plugin data %s of plugin %s (ExtensionPointID: %s) of ConfDesc %s of template %s failed.", triple.getFirst(), triple.getSecond(), triple.getThird(), confDescEntry.getKey(), template.getID());
                            logger.severe(msg17);
                            throw new DataSourceException(msg17);
                        }
                        stmt = JDBCTools.close(stmt);
                    }
                }
                for (String confDesc : hashSet5) {
                    stmt = con.prepareStatement(SQLHelp.SimpleQueryGenerator.generateDelete("PMTemplateConfDescription", SQLConstants.COL_TEMPLATECONFIGURATIONDESCRIPTION_PK));
                    stmt.setLong(1, template.getID().getMostSignificantBits());
                    stmt.setLong(2, template.getID().getLeastSignificantBits());
                    stmt.setString(3, confDesc);
                    stmt.execute();
                    if (stmt.getUpdateCount() == 0) {
                        String string = String.format("Deletion of ConfDesc %s of template %s failed.", confDesc, template.getID());
                        logger.severe(string);
                        throw new DataSourceException(string);
                    }
                    stmt = JDBCTools.close(stmt);
                }
                if (ownConnection) {
                    con = JDBCTools.close(con);
                } else if (doCommit) {
                    con = JDBCTools.commit(con);
                }
            }
            catch (SQLException e) {
                throw new DataSourceException("SQLException", e);
            }
        }
        catch (Throwable throwable) {
            if (ownConnection || doCommit) {
                JDBCTools.rollbackQuietly(con);
            }
            if (ownConnection) {
                JDBCTools.closeQuietly(con, stmt, rs);
            } else {
                JDBCTools.closeQuietly(stmt, rs);
            }
            throw throwable;
        }
        if (ownConnection || doCommit) {
            JDBCTools.rollbackQuietly(con);
        }
        if (ownConnection) {
            JDBCTools.closeQuietly(con, (Statement)stmt, rs);
        } else {
            JDBCTools.closeQuietly((Statement)stmt, rs);
        }
        logger.finer("SQLHelpWrite.insertOrUpdateTemplate() exit");
    }

    public static void insertOrUpdateTemplateStatus(JDBCDataSource dataSource, TemplateStatus templateStatus, ExtendedConnection con, boolean doCommit) throws DataSourceException {
        logger.finer("SQLHelpWrite.insertOrUpdateTemplateStatus() entry");
        boolean ownConnection = con == null;
        PreparedStatement stmt = null;
        try {
            try {
                if (ownConnection) {
                    con = dataSource.getConnection();
                }
                con.setAutoCommit(false);
                boolean insert = !SQLHelpWrite.entryExists(con, "PMTemplateStatus", SQLConstants.COL_TEMPLATESTATUS_PK, new SQLHelp.ParameterList(new int[]{-5, -5}, new Object[]{templateStatus.getTemplateID().getMostSignificantBits(), templateStatus.getTemplateID().getLeastSignificantBits()}));
                stmt = insert ? con.prepareStatement(SQLHelp.SimpleQueryGenerator.generateInsert("PMTemplateStatus", SQLConstants.COL_TEMPLATESTATUS_ALL)) : con.prepareStatement(SQLHelp.SimpleQueryGenerator.generateUpdate("PMTemplateStatus", SQLConstants.COL_TEMPLATESTATUS_ALL, SQLConstants.COL_TEMPLATESTATUS_PK));
                stmt.setLong(1, templateStatus.getTemplateID().getMostSignificantBits());
                stmt.setLong(2, templateStatus.getTemplateID().getLeastSignificantBits());
                stmt.setLong(3, templateStatus.getBuildtimeState().getCode());
                stmt.setLong(4, templateStatus.getUsageAsSubprocess().getCode());
                stmt.setBoolean(5, templateStatus.isTopLevelUsable());
                stmt.setBoolean(6, templateStatus.isDerivable());
                stmt.setString(7, templateStatus.getDerivableComment());
                stmt.setBoolean(8, templateStatus.isOutdated(false));
                stmt.setBoolean(9, templateStatus.isOutdated(true));
                stmt.setBoolean(10, templateStatus.isInstantiable(false));
                stmt.setBoolean(11, templateStatus.isInstantiable(true));
                stmt.setBoolean(12, templateStatus.areInstancesMigratableTo(false));
                stmt.setBoolean(13, templateStatus.areInstancesMigratableTo(true));
                stmt.setBoolean(14, templateStatus.areInstancesChangeable(false));
                stmt.setBoolean(15, templateStatus.areInstancesChangeable(true));
                stmt.setString(16, templateStatus.getOutdatedComment(false));
                stmt.setString(17, templateStatus.getOutdatedComment(true));
                stmt.setString(18, templateStatus.getInstantiableComment(false));
                stmt.setString(19, templateStatus.getInstantiableComment(true));
                stmt.setString(20, templateStatus.getInstancesMigratableToComment(false));
                stmt.setString(21, templateStatus.getInstancesMigratableToComment(true));
                stmt.setString(22, templateStatus.getInstancesChangeableComment(false));
                stmt.setString(23, templateStatus.getInstancesChangeableComment(true));
                stmt.setString(24, templateStatus.getStarterRule());
                if (!insert) {
                    stmt.setLong(25, templateStatus.getTemplateID().getMostSignificantBits());
                    stmt.setLong(26, templateStatus.getTemplateID().getLeastSignificantBits());
                }
                stmt.execute();
                if (stmt.getUpdateCount() == 0) {
                    String msg = String.format("%s of template status %s failed.", insert ? "Insert" : "Update", templateStatus.getTemplateID());
                    logger.severe(msg);
                    throw new DataSourceException(msg);
                }
                stmt = JDBCTools.close(stmt);
                if (ownConnection) {
                    con = JDBCTools.close(con);
                } else if (doCommit) {
                    con = JDBCTools.commit(con);
                }
            }
            catch (SQLException e) {
                throw new DataSourceException("SQLException", e);
            }
        }
        catch (Throwable throwable) {
            if (ownConnection || doCommit) {
                JDBCTools.rollbackQuietly(con);
            }
            if (ownConnection) {
                JDBCTools.closeQuietly(con, stmt);
            } else {
                JDBCTools.closeQuietly(stmt);
            }
            throw throwable;
        }
        if (ownConnection || doCommit) {
            JDBCTools.rollbackQuietly(con);
        }
        if (ownConnection) {
            JDBCTools.closeQuietly(con, (Statement)stmt);
        } else {
            JDBCTools.closeQuietly((Statement)stmt);
        }
        logger.finer("SQLHelpWrite.insertOrUpdateTemplateStatus() exit");
    }

    public static void insertOrUpdateInstance(JDBCDataSource dataSource, ExecutableInstance instance, TemplateStorage templateStorage, boolean storeTemplate) throws DataSourceException {
        logger.finer("SQLHelpWrite.insertOrUpdateInstance() entry");
        ExtendedConnection con = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        PreparedStatement insertStmt = null;
        PreparedStatement updateStmt = null;
        PreparedStatement deleteStmt = null;
        try {
            try {
                int insertPlugin;
                Object data;
                if (storeTemplate && instance.isModified()) {
                    Set<UUID> allTemplateIDs = templateStorage.getAllTemplateIDs();
                    if (allTemplateIDs.contains(instance.getTemplate().getID())) {
                        SQLHelpWrite.insertOrUpdateTemplate(dataSource, instance.getTemplate(), null, false);
                    } else {
                        templateStorage.createTemplate(instance.getTemplate(), null);
                    }
                }
                con = dataSource.getConnection();
                con.setAutoCommit(false);
                boolean insertInstance = !SQLHelpWrite.entryExists(con, "PMInstance", SQLConstants.COL_INSTANCE_PK, new SQLHelp.ParameterList(new int[]{-5, -5}, new Object[]{instance.getLogID().getMostSignificantBits(), instance.getLogID().getLeastSignificantBits()}));
                UUID oldInstanceID = null;
                if (!insertInstance) {
                    stmt = con.prepareStatement(SQLWriteConstants.SQL_INST_FIND);
                    stmt.setLong(1, instance.getLogID().getMostSignificantBits());
                    stmt.setLong(2, instance.getLogID().getLeastSignificantBits());
                    rs = stmt.executeQuery();
                    rs.next();
                    oldInstanceID = new UUID(rs.getLong(3), rs.getLong(4));
                    rs = JDBCTools.close(rs);
                    stmt = JDBCTools.close(stmt);
                }
                ExecutableInstancePropertyTracker tracker = null;
                if (!storeTemplate && !insertInstance && instance instanceof ExecutableInstancePropertyTracker) {
                    tracker = (ExecutableInstancePropertyTracker)((Object)instance);
                }
                if (tracker != null && tracker.getChangedProperties().contains((Object)ExecutableInstancePropertyTracker.ExecutableInstanceProperty.INSTANCE_NAME)) {
                    stmt = con.prepareStatement(SQLWriteConstants.SQL_INST_NAME_UPDATE);
                    stmt.setString(1, instance.getName());
                    stmt.setLong(2, instance.getLogID().getMostSignificantBits());
                    stmt.setLong(3, instance.getLogID().getLeastSignificantBits());
                    stmt.execute();
                    if (stmt.getUpdateCount() == 0) {
                        String msg = String.format("%s of instance with id %s (logID %s)failed.", insertInstance ? "Insert" : "Update", instance.getID(), instance.getLogID());
                        logger.severe(msg);
                        throw new DataSourceException(msg);
                    }
                    stmt = JDBCTools.close(stmt);
                } else if (tracker == null) {
                    stmt = insertInstance ? con.prepareStatement(SQLWriteConstants.SQL_INST_INSERT) : con.prepareStatement(SQLWriteConstants.SQL_INST_UPDATE);
                    stmt.setLong(1, instance.getLogID().getMostSignificantBits());
                    stmt.setLong(2, instance.getLogID().getLeastSignificantBits());
                    stmt.setLong(3, instance.getID().getMostSignificantBits());
                    stmt.setLong(4, instance.getID().getLeastSignificantBits());
                    stmt.setLong(5, instance.getInitiatorAgent().getAgentID());
                    stmt.setString(6, instance.getInitiatorAgent().getAgentUserName());
                    stmt.setLong(7, instance.getInitiatorAgent().getOrgPositionID());
                    stmt.setString(8, instance.getInitiatorAgent().getOrgPositionName());
                    stmt.setBoolean(9, instance.isModified());
                    stmt.setString(10, instance.getName());
                    stmt.setLong(11, instance.getCreationTime());
                    stmt.setLong(12, instance.getSupervisorAgent().getAgentID());
                    stmt.setString(13, instance.getSupervisorAgent().getAgentUserName());
                    stmt.setLong(14, instance.getSupervisorAgent().getOrgPositionID());
                    stmt.setString(15, instance.getSupervisorAgent().getOrgPositionName());
                    if (instance.getBaseTemplateID() == null) {
                        stmt.setNull(16, -5);
                        stmt.setNull(17, -5);
                    } else {
                        stmt.setLong(16, instance.getBaseTemplateID().getMostSignificantBits());
                        stmt.setLong(17, instance.getBaseTemplateID().getLeastSignificantBits());
                    }
                    stmt.setLong(18, instance.getTemplate().getID().getMostSignificantBits());
                    stmt.setLong(19, instance.getTemplate().getID().getLeastSignificantBits());
                    if (!insertInstance) {
                        stmt.setLong(20, instance.getLogID().getMostSignificantBits());
                        stmt.setLong(21, instance.getLogID().getLeastSignificantBits());
                    }
                    stmt.execute();
                    if (stmt.getUpdateCount() == 0) {
                        String msg = String.format("%s of basic instance data with id %s (logID %s)had an update count of 0. Trying to continue.", insertInstance ? "Insert" : "Update", instance.getID(), instance.getLogID());
                        logger.severe(msg);
                    }
                    stmt = JDBCTools.close(stmt);
                }
                if (tracker == null || tracker.getChangedProperties().contains((Object)ExecutableInstancePropertyTracker.ExecutableInstanceProperty.USER_ATTRIBUTES)) {
                    stmt = con.prepareStatement(SQLWriteConstants.SQL_INST_FIND_UA);
                    stmt.setLong(1, instance.getLogID().getMostSignificantBits());
                    stmt.setLong(2, instance.getLogID().getLeastSignificantBits());
                    rs = stmt.executeQuery();
                    HashSet<String> userAttributesToDelete = new HashSet<String>();
                    while (rs.next()) {
                        userAttributesToDelete.add(SQLHelp.getString(rs, 1));
                    }
                    rs = JDBCTools.close(rs);
                    stmt = JDBCTools.close(stmt);
                    for (Map.Entry<String, String> entry : instance.getUserAttributes().entrySet()) {
                        boolean insertUA;
                        boolean bl = insertUA = !userAttributesToDelete.remove(entry.getKey());
                        if (insertUA) {
                            if (insertStmt == null) {
                                insertStmt = con.prepareStatement(SQLWriteConstants.SQL_INST_INSERT_UA);
                            }
                            stmt = insertStmt;
                        } else {
                            if (updateStmt == null) {
                                updateStmt = con.prepareStatement(SQLWriteConstants.SQL_INST_UPDATE_UA);
                            }
                            stmt = updateStmt;
                        }
                        stmt.setLong(1, instance.getLogID().getMostSignificantBits());
                        stmt.setLong(2, instance.getLogID().getLeastSignificantBits());
                        stmt.setString(3, entry.getKey());
                        stmt.setString(4, entry.getValue());
                        if (!insertUA) {
                            stmt.setLong(5, instance.getLogID().getMostSignificantBits());
                            stmt.setLong(6, instance.getLogID().getLeastSignificantBits());
                            stmt.setString(7, entry.getKey());
                        }
                        stmt.execute();
                        if (stmt.getUpdateCount() != 0) continue;
                        String msg = String.format("%s of UserAttribute %s of instance %s (LogID %s) failed.", insertUA ? "Insert" : "Update", entry.getKey(), instance.getID(), instance.getLogID());
                        logger.severe(msg);
                        throw new DataSourceException(msg);
                    }
                    insertStmt = JDBCTools.close(insertStmt);
                    updateStmt = JDBCTools.close(updateStmt);
                    if (!userAttributesToDelete.isEmpty()) {
                        stmt = con.prepareStatement(SQLWriteConstants.SQL_INST_DELETE_UA);
                        for (String string : userAttributesToDelete) {
                            stmt.setLong(1, instance.getLogID().getMostSignificantBits());
                            stmt.setLong(2, instance.getLogID().getLeastSignificantBits());
                            stmt.setString(3, string);
                            stmt.execute();
                            if (stmt.getUpdateCount() != 0) continue;
                            String msg = String.format("Deletion of user attribute %s of instance %s (LogID %s) failed.", string, instance.getID(), instance.getLogID());
                            logger.severe(msg);
                            throw new DataSourceException(msg);
                        }
                        stmt = JDBCTools.close(stmt);
                    }
                }
                if (tracker == null || tracker.getChangedProperties().contains((Object)ExecutableInstancePropertyTracker.ExecutableInstanceProperty.PLUGIN_DATA)) {
                    stmt = con.prepareStatement(SQLWriteConstants.SQL_INST_FIND_PLUGINS);
                    stmt.setLong(1, instance.getLogID().getMostSignificantBits());
                    stmt.setLong(2, instance.getLogID().getLeastSignificantBits());
                    rs = stmt.executeQuery();
                    HashSet<Triple<String, String, String>> pluginsToDelete = new HashSet<Triple<String, String, String>>();
                    while (rs.next()) {
                        Triple<String, String, String> triple = new Triple<String, String, String>(SQLHelp.getString(rs, 1), SQLHelp.getString(rs, 2), SQLHelp.getString(rs, 3));
                        pluginsToDelete.add(triple);
                    }
                    rs = JDBCTools.close(rs);
                    stmt = JDBCTools.close(stmt);
                    for (Map.Entry<String, Set<String>> entry : instance.getSupportedPlugins().entrySet()) {
                        for (String pluginID : entry.getValue()) {
                            Map<String, String> dataMap;
                            data = instance.getPluginData(pluginID);
                            if (data != null) {
                                dataMap = data.getPluginData();
                            } else {
                                dataMap = new HashMap<String, String>();
                                dataMap.put(null, null);
                            }
                            for (Map.Entry<String, String> dataRow : dataMap.entrySet()) {
                                Triple<String, String, String> t = new Triple<String, String, String>(dataRow.getKey(), pluginID, entry.getKey());
                                int n = insertPlugin = pluginsToDelete.remove(t) ? 0 : 1;
                                if (insertPlugin != 0) {
                                    if (insertStmt == null) {
                                        insertStmt = con.prepareStatement(SQLWriteConstants.SQL_INST_INSERT_PLUGINS);
                                    }
                                    stmt = insertStmt;
                                } else {
                                    if (updateStmt == null) {
                                        updateStmt = con.prepareStatement(SQLWriteConstants.SQL_INST_UPDATE_PLUGINS);
                                    }
                                    stmt = updateStmt;
                                }
                                stmt.setString(1, dataRow.getKey());
                                stmt.setString(2, dataRow.getValue());
                                stmt.setString(3, pluginID);
                                stmt.setString(4, entry.getKey());
                                stmt.setLong(5, instance.getLogID().getMostSignificantBits());
                                stmt.setLong(6, instance.getLogID().getLeastSignificantBits());
                                if (insertPlugin == 0) {
                                    stmt.setString(7, dataRow.getKey());
                                    stmt.setString(8, pluginID);
                                    stmt.setString(9, entry.getKey());
                                    stmt.setLong(10, instance.getLogID().getMostSignificantBits());
                                    stmt.setLong(11, instance.getLogID().getLeastSignificantBits());
                                }
                                stmt.execute();
                                if (stmt.getUpdateCount() != 0) continue;
                                String msg = String.format("%s of plugin data %s of instance %s failed!", insertPlugin != 0 ? "Insert" : "Update", dataRow.getKey(), instance.getID());
                                logger.severe(msg);
                                throw new DataSourceException(msg);
                            }
                        }
                    }
                    insertStmt = JDBCTools.close(insertStmt);
                    updateStmt = JDBCTools.close(updateStmt);
                    if (!pluginsToDelete.isEmpty()) {
                        stmt = con.prepareStatement(SQLWriteConstants.SQL_INST_DEL_PLUGINS);
                        for (Triple triple : pluginsToDelete) {
                            stmt.setString(1, (String)triple.getFirst());
                            stmt.setString(2, (String)triple.getSecond());
                            stmt.setString(3, (String)triple.getThird());
                            stmt.setLong(4, instance.getLogID().getMostSignificantBits());
                            stmt.setLong(5, instance.getLogID().getLeastSignificantBits());
                            stmt.execute();
                            if (stmt.getUpdateCount() != 0) continue;
                            String msg2 = String.format("Deletion of plugin data %s of plugin %s (ExtensionPointID: %s) of instance %s failed.", triple.getFirst(), triple.getSecond(), triple.getThird(), instance.getLogID());
                            logger.severe(msg2);
                            throw new DataSourceException(msg2);
                        }
                        stmt = JDBCTools.close(stmt);
                    }
                }
                if (tracker == null || tracker.getChangedProperties().contains((Object)ExecutableInstancePropertyTracker.ExecutableInstanceProperty.INSTANCE_STATE_LISTENER)) {
                    HashSet<String> urisToDelete = new HashSet<String>();
                    stmt = con.prepareStatement(SQLWriteConstants.SQL_INST_CALLBACK_URIS_FIND);
                    stmt.setLong(1, instance.getLogID().getMostSignificantBits());
                    stmt.setLong(2, instance.getLogID().getLeastSignificantBits());
                    rs = stmt.executeQuery();
                    while (rs.next()) {
                        urisToDelete.add(SQLHelp.getString(rs, 1));
                    }
                    rs = JDBCTools.close(rs);
                    stmt = JDBCTools.close(stmt);
                    URI[] uRIArray = instance.getInstanceStateListener();
                    if (uRIArray != null && uRIArray.length > 0) {
                        stmt = con.prepareStatement(SQLWriteConstants.SQL_INST_CALLBACK_URIS_INSERT);
                        data = uRIArray;
                        int msg = uRIArray.length;
                        int msg2 = 0;
                        while (msg2 < msg) {
                            boolean insertURI;
                            URI uRI = data[msg2];
                            boolean bl = insertURI = !urisToDelete.remove(uRI.toString());
                            if (insertURI) {
                                stmt.setLong(1, instance.getLogID().getMostSignificantBits());
                                stmt.setLong(2, instance.getLogID().getLeastSignificantBits());
                                stmt.setString(3, uRI.toString());
                                stmt.execute();
                                if (stmt.getUpdateCount() == 0) {
                                    String msg3 = String.format("Insert of Instance termination callback %s of instance %s (LogID %s) failed.", uRI, instance.getID(), instance.getLogID());
                                    logger.severe(msg3);
                                    throw new DataSourceException(msg3);
                                }
                            }
                            ++msg2;
                        }
                        stmt = JDBCTools.close(stmt);
                    }
                    if (!urisToDelete.isEmpty()) {
                        stmt = con.prepareStatement(SQLWriteConstants.SQL_INST_CALLBACK_URIS_DELETE);
                        for (String string : urisToDelete) {
                            stmt.setLong(1, instance.getLogID().getMostSignificantBits());
                            stmt.setLong(2, instance.getLogID().getLeastSignificantBits());
                            stmt.setString(3, string);
                            stmt.execute();
                            if (stmt.getUpdateCount() != 0) continue;
                            String msg = String.format("Deletion of Instance termination callback %s of instance %s (LogID %s) failed.", string, instance.getID(), instance.getLogID());
                            logger.severe(msg);
                            throw new DataSourceException(msg);
                        }
                        stmt = JDBCTools.close(stmt);
                    }
                }
                if (tracker == null) {
                    SQLHelpWrite.insertOrUpdateEBPInstanceReference(dataSource, instance, con, false);
                }
                boolean isDerby = con.getMetaData().getDatabaseProductName().contains("Derby");
                if (tracker != null) {
                    Set<Integer> set = tracker.getChangedNodes();
                    if (set.size() > 0) {
                        String string = String.format(SQLWriteConstants.SQL_INST_NODE_FIND_IN, StringTools.join(", ", set.toArray()));
                        stmt = isDerby ? con.prepareStatement(string, 1004, 1008) : con.prepareStatement(string, 1005, 1008);
                        stmt.setLong(1, instance.getLogID().getMostSignificantBits());
                        stmt.setLong(2, instance.getLogID().getLeastSignificantBits());
                        rs = stmt.executeQuery();
                        while (rs.next()) {
                            int nodeID = rs.getInt(SQLConstants.COL_NODEINSTANCEDATA_PK[2]);
                            Set<ExecutableInstancePropertyTracker.ExecutableInstanceNodeProperty> changedProperties = tracker.getChangedNodeProperties(nodeID);
                            if (changedProperties == null || !SQLHelpWrite.writeNodeInstanceData(rs, false, instance, nodeID)) continue;
                            rs.updateRow();
                        }
                        rs = JDBCTools.close(rs);
                        stmt = JDBCTools.close(stmt);
                    }
                } else {
                    HashSet<Integer> hashSet = new HashSet<Integer>();
                    for (Node node : instance.getTemplate().getNodes()) {
                        hashSet.add(node.getID());
                    }
                    stmt = isDerby ? con.prepareStatement(SQLWriteConstants.SQL_INST_NODE_FIND, 1004, 1008) : con.prepareStatement(SQLWriteConstants.SQL_INST_NODE_FIND, 1005, 1008);
                    stmt.setLong(1, instance.getLogID().getMostSignificantBits());
                    stmt.setLong(2, instance.getLogID().getLeastSignificantBits());
                    rs = stmt.executeQuery();
                    while (rs.next()) {
                        int n = rs.getInt(SQLConstants.COL_NODEINSTANCEDATA_PK[2]);
                        boolean nodeStillExists = hashSet.remove(n);
                        if (!nodeStillExists) {
                            rs.deleteRow();
                            continue;
                        }
                        if (!SQLHelpWrite.writeNodeInstanceData(rs, false, instance, n)) continue;
                        rs.updateRow();
                    }
                    Iterator nodeStillExists = hashSet.iterator();
                    while (nodeStillExists.hasNext()) {
                        int n = (Integer)nodeStillExists.next();
                        rs.moveToInsertRow();
                        rs.updateLong(SQLConstants.COL_NODEINSTANCEDATA_PK[0], instance.getLogID().getMostSignificantBits());
                        rs.updateLong(SQLConstants.COL_NODEINSTANCEDATA_PK[1], instance.getLogID().getLeastSignificantBits());
                        rs.updateInt(SQLConstants.COL_NODEINSTANCEDATA_PK[2], n);
                        SQLHelpWrite.writeNodeInstanceData(rs, true, instance, n);
                        rs.insertRow();
                    }
                    rs.moveToCurrentRow();
                    rs = JDBCTools.close(rs);
                    stmt = JDBCTools.close(stmt);
                }
                if (tracker != null) {
                    HashSet<Integer> hashSet = new HashSet<Integer>();
                    for (Node node : instance.getTemplate().getNodes()) {
                        Set<ExecutableInstancePropertyTracker.ExecutableInstanceNodeProperty> props = tracker.getChangedNodeProperties(node.getID());
                        if (props == null || !props.contains((Object)ExecutableInstancePropertyTracker.ExecutableInstanceNodeProperty.ASSIGNED_RUNTIME_MANAGER)) continue;
                        hashSet.add(node.getID());
                    }
                    if (hashSet.size() > 0) {
                        String string = String.format(SQLWriteConstants.SQL_INST_NODE_RUNTIME_URIS_FIND_IN_NODES, StringTools.join(", ", hashSet.toArray()));
                        stmt = isDerby ? con.prepareStatement(string, 1004, 1008) : con.prepareStatement(string, 1005, 1008);
                        stmt.setLong(1, instance.getLogID().getMostSignificantBits());
                        stmt.setLong(2, instance.getLogID().getLeastSignificantBits());
                        rs = stmt.executeQuery();
                        boolean isUpdatable = rs.getConcurrency() == 1008;
                        boolean more = rs.next();
                        while (more) {
                            int nodeID = rs.getInt(SQLConstants.COL_NODEINSTANCEDATARUNTIMEMANAGERURIS_ALL[2]);
                            hashSet.remove(nodeID);
                            HashSet<URI> rtmUris = new HashSet<URI>();
                            URI[] uris = instance.getAssignedRuntimeManager(nodeID);
                            if (uris != null) {
                                URI[] uRIArray = instance.getAssignedRuntimeManager(nodeID);
                                insertPlugin = uRIArray.length;
                                int t = 0;
                                while (t < insertPlugin) {
                                    URI uri = uRIArray[t];
                                    rtmUris.add(uri);
                                    ++t;
                                }
                            }
                            int nextNodeID = Integer.MIN_VALUE;
                            do {
                                boolean delete = false;
                                URI uri3 = URI.create(rs.getString(SQLConstants.COL_NODEINSTANCEDATARUNTIMEMANAGERURIS_ALL[3]));
                                if (!rtmUris.remove(uri3)) {
                                    delete = true;
                                }
                                if (delete) {
                                    if (isUpdatable) {
                                        rs.deleteRow();
                                    } else {
                                        if (deleteStmt == null) {
                                            deleteStmt = con.prepareStatement(SQLWriteConstants.SQL_INST_NODE_RUNTIME_URIS_DELETE);
                                        }
                                        deleteStmt.setLong(1, instance.getLogID().getMostSignificantBits());
                                        deleteStmt.setLong(2, instance.getLogID().getLeastSignificantBits());
                                        deleteStmt.setInt(3, nodeID);
                                        deleteStmt.setString(4, rs.getString(SQLConstants.COL_NODEINSTANCEDATARUNTIMEMANAGERURIS_ALL[3]));
                                        deleteStmt.executeUpdate();
                                    }
                                }
                                if (!(more = rs.next()) || (nextNodeID = rs.getInt(SQLConstants.COL_NODEINSTANCEDATARUNTIMEMANAGERURIS_ALL[2])) >= nodeID) continue;
                                more = false;
                            } while (more && nextNodeID == nodeID);
                            insertStmt = SQLHelpWrite.insertRemainingRTMURIs(instance, con, rs, insertStmt, isUpdatable, nodeID, rtmUris);
                            if (!isUpdatable) continue;
                            rs.moveToCurrentRow();
                        }
                        Iterator rtmUris = hashSet.iterator();
                        while (rtmUris.hasNext()) {
                            int nodeID = (Integer)rtmUris.next();
                            HashSet<URI> rtmUris2 = new HashSet<URI>();
                            URI[] uris2 = instance.getAssignedRuntimeManager(nodeID);
                            if (uris2 != null) {
                                URI[] uRIArray = instance.getAssignedRuntimeManager(nodeID);
                                int n = uRIArray.length;
                                int uri3 = 0;
                                while (uri3 < n) {
                                    URI uri2 = uRIArray[uri3];
                                    rtmUris2.add(uri2);
                                    ++uri3;
                                }
                            }
                            insertStmt = SQLHelpWrite.insertRemainingRTMURIs(instance, con, rs, insertStmt, isUpdatable, nodeID, rtmUris2);
                        }
                        insertStmt = JDBCTools.close(insertStmt);
                        deleteStmt = JDBCTools.close(deleteStmt);
                        rs = JDBCTools.close(rs);
                        stmt = JDBCTools.close(stmt);
                    }
                } else {
                    URI uri;
                    Object rtmUris;
                    HashSet<Integer> hashSet = new HashSet<Integer>();
                    for (Node node : instance.getTemplate().getNodes()) {
                        hashSet.add(node.getID());
                    }
                    stmt = isDerby ? con.prepareStatement(SQLWriteConstants.SQL_INST_NODE_RUNTIME_URIS_FIND, 1004, 1008) : con.prepareStatement(SQLWriteConstants.SQL_INST_NODE_RUNTIME_URIS_FIND, 1005, 1008);
                    stmt.setLong(1, instance.getLogID().getMostSignificantBits());
                    stmt.setLong(2, instance.getLogID().getLeastSignificantBits());
                    rs = stmt.executeQuery();
                    boolean bl = rs.getConcurrency() == 1008;
                    boolean more = rs.next();
                    while (more) {
                        int nodeID = rs.getInt(SQLConstants.COL_NODEINSTANCEDATARUNTIMEMANAGERURIS_ALL[2]);
                        rtmUris = new HashSet();
                        URI[] uris = instance.getAssignedRuntimeManager(nodeID);
                        if (uris != null) {
                            URI[] uri3 = instance.getAssignedRuntimeManager(nodeID);
                            int uri2 = uri3.length;
                            int uris2 = 0;
                            while (uris2 < uri2) {
                                uri = uri3[uris2];
                                rtmUris.add(uri);
                                ++uris2;
                            }
                        }
                        boolean nodeStillExists = hashSet.contains(nodeID);
                        int nextNodeID = Integer.MIN_VALUE;
                        do {
                            boolean delete = false;
                            if (!nodeStillExists) {
                                delete = true;
                            } else {
                                URI uri4 = URI.create(rs.getString(SQLConstants.COL_NODEINSTANCEDATARUNTIMEMANAGERURIS_ALL[3]));
                                if (!rtmUris.remove(uri4)) {
                                    delete = true;
                                }
                            }
                            if (delete) {
                                if (bl) {
                                    rs.deleteRow();
                                } else {
                                    if (deleteStmt == null) {
                                        deleteStmt = con.prepareStatement(SQLWriteConstants.SQL_INST_NODE_RUNTIME_URIS_DELETE);
                                    }
                                    deleteStmt.setLong(1, instance.getLogID().getMostSignificantBits());
                                    deleteStmt.setLong(2, instance.getLogID().getLeastSignificantBits());
                                    deleteStmt.setInt(3, nodeID);
                                    deleteStmt.setString(4, rs.getString(SQLConstants.COL_NODEINSTANCEDATARUNTIMEMANAGERURIS_ALL[3]));
                                    deleteStmt.executeUpdate();
                                }
                            }
                            if (!(more = rs.next()) || (nextNodeID = rs.getInt(SQLConstants.COL_NODEINSTANCEDATARUNTIMEMANAGERURIS_ALL[2])) >= nodeID) continue;
                            more = false;
                        } while (more && nextNodeID == nodeID);
                        insertStmt = SQLHelpWrite.insertRemainingRTMURIs(instance, con, rs, insertStmt, bl, nodeID, (Set<URI>)rtmUris);
                        if (bl) {
                            rs.moveToCurrentRow();
                        }
                        hashSet.remove(nodeID);
                    }
                    rtmUris = hashSet.iterator();
                    while (rtmUris.hasNext()) {
                        int nodeID = (Integer)rtmUris.next();
                        URI[] uris = instance.getAssignedRuntimeManager(nodeID);
                        if (uris == null) continue;
                        URI[] uri4 = uris;
                        int delete = uris.length;
                        int nextNodeID = 0;
                        while (nextNodeID < delete) {
                            uri = uri4[nextNodeID];
                            if (bl) {
                                rs.moveToInsertRow();
                                rs.updateLong(SQLConstants.COL_NODEINSTANCEDATARUNTIMEMANAGERURIS_ALL[0], instance.getLogID().getMostSignificantBits());
                                rs.updateLong(SQLConstants.COL_NODEINSTANCEDATARUNTIMEMANAGERURIS_ALL[1], instance.getLogID().getLeastSignificantBits());
                                rs.updateInt(SQLConstants.COL_NODEINSTANCEDATARUNTIMEMANAGERURIS_ALL[2], nodeID);
                                rs.updateString(SQLConstants.COL_NODEINSTANCEDATARUNTIMEMANAGERURIS_ALL[3], uri.toString());
                                rs.insertRow();
                            } else {
                                if (insertStmt == null) {
                                    insertStmt = con.prepareStatement(SQLWriteConstants.SQL_INST_NODE_RUNTIME_URIS_INSERT);
                                }
                                insertStmt.setLong(1, instance.getLogID().getMostSignificantBits());
                                insertStmt.setLong(2, instance.getLogID().getLeastSignificantBits());
                                insertStmt.setInt(3, nodeID);
                                insertStmt.setString(4, uri.toString());
                                insertStmt.executeUpdate();
                            }
                            ++nextNodeID;
                        }
                        if (!bl) continue;
                        rs.moveToCurrentRow();
                    }
                    insertStmt = JDBCTools.close(insertStmt);
                    deleteStmt = JDBCTools.close(deleteStmt);
                    rs = JDBCTools.close(rs);
                    stmt = JDBCTools.close(stmt);
                }
                SQLHelpWrite.insertOrUpdateEnquiries(con, instance, tracker);
                boolean bl = SQLHelpWrite.canSkipUpdateForNodeInstanceProperty(tracker, ExecutableInstancePropertyTracker.ExecutableInstanceNodeProperty.LWP_INSTANCE_ID);
                if (!bl) {
                    List<UUID> nodeLWPInstanceIDs;
                    HashSet<Integer> hashSet = new HashSet<Integer>();
                    for (Node node : instance.getTemplate().getNodes()) {
                        hashSet.add(node.getID());
                    }
                    stmt = isDerby ? con.prepareStatement(SQLWriteConstants.SQL_INST_LWP_FIND, 1004, 1008) : con.prepareStatement(SQLWriteConstants.SQL_INST_LWP_FIND, 1005, 1008);
                    stmt.setLong(1, instance.getLogID().getMostSignificantBits());
                    stmt.setLong(2, instance.getLogID().getLeastSignificantBits());
                    rs = stmt.executeQuery();
                    boolean isUpdatable = rs.getConcurrency() == 1008;
                    boolean more = rs.next();
                    while (more) {
                        int nodeID = rs.getInt(SQLConstants.COL_LWPINSTANCE_ALL[2]);
                        int listIndex = 0;
                        nodeLWPInstanceIDs = instance.getNodeLWPInstanceID(nodeID);
                        boolean nodeStillExists = hashSet.contains(nodeID);
                        int nextNodeID = Integer.MIN_VALUE;
                        do {
                            if (!nodeStillExists) {
                                if (isUpdatable) {
                                    rs.deleteRow();
                                } else {
                                    if (deleteStmt == null) {
                                        deleteStmt = con.prepareStatement(SQLWriteConstants.SQL_INST_LWP_DELETE);
                                    }
                                    deleteStmt.setLong(1, instance.getLogID().getMostSignificantBits());
                                    deleteStmt.setLong(2, instance.getLogID().getLeastSignificantBits());
                                    deleteStmt.setInt(3, nodeID);
                                    deleteStmt.setInt(4, rs.getInt(SQLConstants.COL_LWPINSTANCE_ALL[3]));
                                    deleteStmt.executeUpdate();
                                }
                            } else if (listIndex >= nodeLWPInstanceIDs.size()) {
                                if (isUpdatable) {
                                    rs.deleteRow();
                                } else {
                                    if (deleteStmt == null) {
                                        deleteStmt = con.prepareStatement(SQLWriteConstants.SQL_INST_LWP_DELETE);
                                    }
                                    deleteStmt.setLong(1, instance.getLogID().getMostSignificantBits());
                                    deleteStmt.setLong(2, instance.getLogID().getLeastSignificantBits());
                                    deleteStmt.setInt(3, nodeID);
                                    deleteStmt.setInt(4, rs.getInt(SQLConstants.COL_LWPINSTANCE_ALL[3]));
                                    deleteStmt.executeUpdate();
                                }
                            } else if (isUpdatable) {
                                if (SQLHelpWrite.writeLWPInstance(rs, false, instance, nodeID, listIndex)) {
                                    rs.updateRow();
                                }
                            } else {
                                if (updateStmt == null) {
                                    updateStmt = con.prepareStatement(SQLWriteConstants.SQL_INST_LWP_UPDATE);
                                }
                                updateStmt.setInt(1, listIndex);
                                UUID lwpInstanceID = instance.getNodeLWPInstanceID(nodeID).get(listIndex);
                                updateStmt.setLong(2, lwpInstanceID.getMostSignificantBits());
                                updateStmt.setLong(3, lwpInstanceID.getLeastSignificantBits());
                                updateStmt.setLong(4, instance.getLogID().getMostSignificantBits());
                                updateStmt.setLong(5, instance.getLogID().getLeastSignificantBits());
                                updateStmt.setInt(6, nodeID);
                                updateStmt.setInt(7, rs.getInt(SQLConstants.COL_LWPINSTANCE_ALL[3]));
                                updateStmt.executeUpdate();
                            }
                            ++listIndex;
                            more = rs.next();
                            if (!more || (nextNodeID = rs.getInt(SQLConstants.COL_LWPINSTANCE_ALL[2])) >= nodeID) continue;
                            more = false;
                        } while (more && nextNodeID == nodeID);
                        while (listIndex < nodeLWPInstanceIDs.size()) {
                            if (isUpdatable) {
                                rs.moveToInsertRow();
                                rs.updateLong(SQLConstants.COL_LWPINSTANCE_ALL[0], instance.getLogID().getMostSignificantBits());
                                rs.updateLong(SQLConstants.COL_LWPINSTANCE_ALL[1], instance.getLogID().getLeastSignificantBits());
                                rs.updateInt(SQLConstants.COL_LWPINSTANCE_ALL[2], nodeID);
                                SQLHelpWrite.writeLWPInstance(rs, true, instance, nodeID, listIndex);
                                rs.insertRow();
                            } else {
                                if (insertStmt == null) {
                                    insertStmt = con.prepareStatement(SQLWriteConstants.SQL_INST_LWP_INSERT);
                                }
                                insertStmt.setLong(1, instance.getLogID().getMostSignificantBits());
                                insertStmt.setLong(2, instance.getLogID().getLeastSignificantBits());
                                insertStmt.setInt(3, nodeID);
                                insertStmt.setInt(4, listIndex);
                                UUID lwpInstanceID = instance.getNodeLWPInstanceID(nodeID).get(listIndex);
                                insertStmt.setLong(5, lwpInstanceID.getMostSignificantBits());
                                insertStmt.setLong(6, lwpInstanceID.getLeastSignificantBits());
                                insertStmt.executeUpdate();
                            }
                            ++listIndex;
                        }
                        if (isUpdatable) {
                            rs.moveToCurrentRow();
                        }
                        hashSet.remove(nodeID);
                    }
                    Iterator iterator = hashSet.iterator();
                    while (iterator.hasNext()) {
                        int nodeID = (Integer)iterator.next();
                        nodeLWPInstanceIDs = instance.getNodeLWPInstanceID(nodeID);
                        int listIndex = 0;
                        while (listIndex < nodeLWPInstanceIDs.size()) {
                            if (isUpdatable) {
                                rs.moveToInsertRow();
                                rs.updateLong(SQLConstants.COL_LWPINSTANCE_ALL[0], instance.getLogID().getMostSignificantBits());
                                rs.updateLong(SQLConstants.COL_LWPINSTANCE_ALL[1], instance.getLogID().getLeastSignificantBits());
                                rs.updateInt(SQLConstants.COL_LWPINSTANCE_ALL[2], nodeID);
                                SQLHelpWrite.writeLWPInstance(rs, true, instance, nodeID, listIndex);
                                rs.insertRow();
                            } else {
                                if (insertStmt == null) {
                                    insertStmt = con.prepareStatement(SQLWriteConstants.SQL_INST_LWP_INSERT);
                                }
                                insertStmt.setLong(1, instance.getLogID().getMostSignificantBits());
                                insertStmt.setLong(2, instance.getLogID().getLeastSignificantBits());
                                insertStmt.setLong(3, nodeID);
                                insertStmt.setLong(4, listIndex);
                                UUID lwpInstanceID = instance.getNodeLWPInstanceID(nodeID).get(listIndex);
                                insertStmt.setLong(5, lwpInstanceID.getMostSignificantBits());
                                insertStmt.setLong(6, lwpInstanceID.getLeastSignificantBits());
                                insertStmt.executeUpdate();
                            }
                            ++listIndex;
                        }
                        if (!isUpdatable) continue;
                        rs.moveToCurrentRow();
                    }
                    insertStmt = JDBCTools.close(insertStmt);
                    updateStmt = JDBCTools.close(updateStmt);
                    deleteStmt = JDBCTools.close(deleteStmt);
                    rs = JDBCTools.close(rs);
                    stmt = JDBCTools.close(stmt);
                }
                if (!insertInstance && !oldInstanceID.equals(instance.getID())) {
                    stmt = con.prepareStatement(SQLWriteConstants.SQL_INST_STATUS_UPDATE);
                    stmt.setLong(1, instance.getID().getMostSignificantBits());
                    stmt.setLong(2, instance.getID().getLeastSignificantBits());
                    stmt.setLong(3, oldInstanceID.getMostSignificantBits());
                    stmt.setLong(4, oldInstanceID.getLeastSignificantBits());
                    stmt.execute();
                    stmt = JDBCTools.close(stmt);
                    stmt = con.prepareStatement(SQLWriteConstants.SQL_INST_LOCK_UPDATE);
                    stmt.setLong(1, instance.getID().getMostSignificantBits());
                    stmt.setLong(2, instance.getID().getLeastSignificantBits());
                    stmt.setLong(3, oldInstanceID.getMostSignificantBits());
                    stmt.setLong(4, oldInstanceID.getLeastSignificantBits());
                    stmt.execute();
                    stmt = JDBCTools.close(stmt);
                }
                con = JDBCTools.close(con);
            }
            catch (SQLException e) {
                throw new DataSourceException("SQLException", e);
            }
        }
        catch (Throwable throwable) {
            JDBCTools.closeQuietly(insertStmt, updateStmt, deleteStmt);
            JDBCTools.closeQuietly(con, stmt, rs);
            throw throwable;
        }
        JDBCTools.closeQuietly(insertStmt, updateStmt, deleteStmt);
        JDBCTools.closeQuietly(con, (Statement)stmt, rs);
        logger.finer("SQLHelpWrite.insertOrUpdateInstance() exit");
    }

    private static PreparedStatement insertRemainingRTMURIs(ExecutableInstance instance, ExtendedConnection con, ResultSet rs, PreparedStatement insertStmt, boolean isUpdatable, int nodeID, Set<URI> rtmUris) throws SQLException {
        for (URI uri : rtmUris) {
            if (isUpdatable) {
                rs.moveToInsertRow();
                rs.updateLong(SQLConstants.COL_NODEINSTANCEDATARUNTIMEMANAGERURIS_ALL[0], instance.getLogID().getMostSignificantBits());
                rs.updateLong(SQLConstants.COL_NODEINSTANCEDATARUNTIMEMANAGERURIS_ALL[1], instance.getLogID().getLeastSignificantBits());
                rs.updateInt(SQLConstants.COL_NODEINSTANCEDATARUNTIMEMANAGERURIS_ALL[2], nodeID);
                rs.updateString(SQLConstants.COL_NODEINSTANCEDATARUNTIMEMANAGERURIS_ALL[3], uri.toString());
                rs.insertRow();
                continue;
            }
            if (insertStmt == null) {
                insertStmt = con.prepareStatement(SQLWriteConstants.SQL_INST_NODE_RUNTIME_URIS_INSERT);
            }
            insertStmt.setLong(1, instance.getLogID().getMostSignificantBits());
            insertStmt.setLong(2, instance.getLogID().getLeastSignificantBits());
            insertStmt.setInt(3, nodeID);
            insertStmt.setString(4, uri.toString());
            insertStmt.executeUpdate();
        }
        return insertStmt;
    }

    private static boolean canSkipUpdateForNodeInstanceProperty(ExecutableInstancePropertyTracker tracker, ExecutableInstancePropertyTracker.ExecutableInstanceNodeProperty prop) {
        boolean skipUpdate;
        logger.finest("SQLHelpWrite.canSkipUpdateForNodeInstanceProperty() entry");
        if (tracker != null) {
            skipUpdate = true;
            for (int nodeID : tracker.getChangedNodes()) {
                Set<ExecutableInstancePropertyTracker.ExecutableInstanceNodeProperty> nodeProperties = tracker.getChangedNodeProperties(nodeID);
                if (nodeProperties == null || !nodeProperties.contains((Object)prop)) continue;
                skipUpdate = false;
                break;
            }
        } else {
            skipUpdate = false;
        }
        logger.finest("SQLHelpWrite.canSkipUpdateForNodeInstanceProperty() exit");
        return skipUpdate;
    }

    private static boolean writeNodeInstanceData(ResultSet rs, boolean insert, ExecutableInstance instance, int nodeID) throws SQLException {
        QualifiedAgent agent;
        ProcessConstants.ExecutionMode em;
        logger.finest("SQLHelpWrite.writeNodeInstanceData() entry");
        boolean changed = false;
        try {
            int nodeIteration = instance.getNodeIteration(nodeID);
            if (insert || rs.getInt(SQLConstants.COL_NODEINSTANCEDATA_ALL[3]) != nodeIteration) {
                rs.updateInt(SQLConstants.COL_NODEINSTANCEDATA_ALL[3], nodeIteration);
                changed = true;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            rs.updateNull(SQLConstants.COL_NODEINSTANCEDATA_ALL[3]);
            changed = true;
        }
        if ((em = instance.getExecutionMode(nodeID)) != null) {
            if (insert || rs.getInt(SQLConstants.COL_NODEINSTANCEDATA_ALL[4]) != em.getCode()) {
                rs.updateInt(SQLConstants.COL_NODEINSTANCEDATA_ALL[4], em.getCode());
                changed = true;
            }
        } else {
            if (instance.getNodeState(nodeID) == ProcessConstants.NodeState.NS_COMPLETED) {
                logger.warning("Setting execution mode to null even though node completed!");
            }
            rs.updateNull(SQLConstants.COL_NODEINSTANCEDATA_ALL[4]);
            changed = true;
        }
        try {
            ProcessConstants.NodeState nodeState = instance.getNodeState(nodeID);
            if (insert || rs.getInt(SQLConstants.COL_NODEINSTANCEDATA_ALL[5]) != nodeState.getCode()) {
                rs.updateInt(SQLConstants.COL_NODEINSTANCEDATA_ALL[5], nodeState.getCode());
                changed = true;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            rs.updateNull(SQLConstants.COL_NODEINSTANCEDATA_ALL[5]);
            changed = true;
        }
        try {
            agent = instance.getPerformingAgent(nodeID);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            agent = null;
        }
        if (agent != null) {
            if (insert || rs.getLong(SQLConstants.COL_NODEINSTANCEDATA_ALL[6]) != agent.getAgentID()) {
                rs.updateLong(SQLConstants.COL_NODEINSTANCEDATA_ALL[6], agent.getAgentID());
                changed = true;
            }
            if (insert || !StringTools.equal(rs.getString(SQLConstants.COL_NODEINSTANCEDATA_ALL[7]), agent.getAgentUserName())) {
                rs.updateString(SQLConstants.COL_NODEINSTANCEDATA_ALL[7], agent.getAgentUserName());
                changed = true;
            }
            if (insert || rs.getLong(SQLConstants.COL_NODEINSTANCEDATA_ALL[8]) != agent.getOrgPositionID()) {
                rs.updateLong(SQLConstants.COL_NODEINSTANCEDATA_ALL[8], agent.getOrgPositionID());
                changed = true;
            }
            if (insert || !StringTools.equal(rs.getString(SQLConstants.COL_NODEINSTANCEDATA_ALL[9]), agent.getOrgPositionName())) {
                rs.updateString(SQLConstants.COL_NODEINSTANCEDATA_ALL[9], agent.getOrgPositionName());
                changed = true;
            }
        } else {
            if (instance.getNodeState(nodeID) == ProcessConstants.NodeState.NS_COMPLETED) {
                logger.warning("Setting agent to null even though node completed!");
            }
            rs.updateNull(SQLConstants.COL_NODEINSTANCEDATA_ALL[6]);
            rs.updateNull(SQLConstants.COL_NODEINSTANCEDATA_ALL[7]);
            rs.updateNull(SQLConstants.COL_NODEINSTANCEDATA_ALL[8]);
            rs.updateNull(SQLConstants.COL_NODEINSTANCEDATA_ALL[9]);
            changed = true;
        }
        logger.finest("SQLHelpWrite.writeNodeInstanceData() exit");
        return changed;
    }

    private static boolean writeLWPInstance(ResultSet rs, boolean insert, ExecutableInstance instance, int nodeID, int listIndex) throws SQLException {
        logger.finest("SQLHelpWrite.writeLWPInstance() entry");
        boolean changed = false;
        if (insert || rs.getInt(SQLConstants.COL_LWPINSTANCE_ALL[3]) != listIndex || rs.wasNull()) {
            rs.updateInt(SQLConstants.COL_LWPINSTANCE_ALL[3], listIndex);
            changed = true;
        }
        UUID lwpInstanceID = instance.getNodeLWPInstanceID(nodeID).get(listIndex);
        if (insert || rs.getLong(SQLConstants.COL_LWPINSTANCE_ALL[4]) != lwpInstanceID.getMostSignificantBits() || rs.wasNull()) {
            rs.updateLong(SQLConstants.COL_LWPINSTANCE_ALL[4], lwpInstanceID.getMostSignificantBits());
            changed = true;
        }
        if (insert || rs.getLong(SQLConstants.COL_LWPINSTANCE_ALL[5]) != lwpInstanceID.getLeastSignificantBits() || rs.wasNull()) {
            rs.updateLong(SQLConstants.COL_LWPINSTANCE_ALL[5], lwpInstanceID.getLeastSignificantBits());
            changed = true;
        }
        logger.finest("SQLHelpWrite.writeLWPInstance() exit");
        return changed;
    }

    /*
     * WARNING - void declaration
     */
    public static void insertOrUpdateEBPInstanceReference(JDBCDataSource dataSource, ExecutableInstance instance, ExtendedConnection con, boolean doCommit) throws DataSourceException {
        EBPInstanceReference ref;
        ResultSet rs;
        PreparedStatement stmt;
        boolean ownConnection;
        block34: {
            block35: {
                logger.finer("SQLHelpWrite.insertOrUpdateEBPInstanceReference() entry");
                ownConnection = con == null;
                stmt = null;
                rs = null;
                if (ownConnection) {
                    con = dataSource.getConnection();
                }
                con.setAutoCommit(false);
                ref = instance.getParentEBPReference();
                if (ref != null) break block34;
                stmt = con.prepareStatement(SQLWriteConstants.SQL_INST_PARENT_EBP_DELETE);
                stmt.setLong(1, instance.getLogID().getMostSignificantBits());
                stmt.setLong(2, instance.getLogID().getLeastSignificantBits());
                stmt.execute();
                stmt = JDBCTools.close(stmt);
                if (ownConnection) {
                    con = JDBCTools.close(con);
                } else if (doCommit) {
                    con = JDBCTools.commit(con);
                }
                if (!ownConnection && !doCommit) break block35;
                JDBCTools.rollbackQuietly(con);
            }
            if (ownConnection) {
                JDBCTools.closeQuietly(con, (Statement)stmt, rs);
            } else {
                JDBCTools.closeQuietly((Statement)stmt, rs);
            }
            return;
        }
        try {
            try {
                void var11_19;
                boolean insert = !SQLHelpWrite.entryExists(con, "PMParentEBPInstanceReference", SQLConstants.COL_PARENTEBPINSTANCEREFERENCE_PK, new SQLHelp.ParameterList(new int[]{-5, -5}, new Object[]{instance.getLogID().getMostSignificantBits(), instance.getLogID().getLeastSignificantBits()}));
                stmt = insert ? con.prepareStatement(SQLWriteConstants.SQL_INST_PARENT_EBP_INSERT) : con.prepareStatement(SQLWriteConstants.SQL_INST_PARENT_EBP_UPDATE);
                stmt.setLong(1, instance.getLogID().getMostSignificantBits());
                stmt.setLong(2, instance.getLogID().getLeastSignificantBits());
                stmt.setInt(3, ref.getType().getCode());
                stmt.setInt(4, ref.getNodeIteration());
                stmt.setBoolean(5, ref.isActivity());
                stmt.setInt(6, ref.getNodeID());
                stmt.setLong(7, ref.getInstanceID().getMostSignificantBits());
                stmt.setLong(8, ref.getInstanceID().getLeastSignificantBits());
                if (!insert) {
                    stmt.setLong(9, instance.getLogID().getMostSignificantBits());
                    stmt.setLong(10, instance.getLogID().getLeastSignificantBits());
                }
                stmt.execute();
                if (stmt.getUpdateCount() == 0) {
                    String msg = String.format("%s of EBPInstanceReference of Instance %s (LogID %s) failed.", insert ? "Insert" : "Update", instance.getID(), instance.getLogID());
                    logger.severe(msg);
                    throw new DataSourceException(msg);
                }
                stmt = JDBCTools.close(stmt);
                HashSet<String> runtimeURIsToDelete = new HashSet<String>();
                stmt = con.prepareStatement(SQLWriteConstants.SQL_INST_EBP_INST_REF_RUNTIME_URIS_FIND);
                stmt.setLong(1, instance.getLogID().getMostSignificantBits());
                stmt.setLong(2, instance.getLogID().getLeastSignificantBits());
                rs = stmt.executeQuery();
                while (rs.next()) {
                    runtimeURIsToDelete.add(SQLHelp.getString(rs, 1));
                }
                rs = JDBCTools.close(rs);
                stmt = JDBCTools.close(stmt);
                URI[] uRIArray = ref.getRuntimeManagerURIs();
                int n = uRIArray.length;
                boolean n2 = false;
                while (var11_19 < n) {
                    boolean insertURI;
                    URI uRI = uRIArray[var11_19];
                    boolean bl = insertURI = !runtimeURIsToDelete.remove(uRI.toString());
                    if (insertURI) {
                        stmt = con.prepareStatement(SQLWriteConstants.SQL_INST_EBP_INST_REF_RUNTIME_URIS_INSERT);
                        stmt.setLong(1, instance.getLogID().getMostSignificantBits());
                        stmt.setLong(2, instance.getLogID().getLeastSignificantBits());
                        stmt.setString(3, uRI.toString());
                        stmt.execute();
                        if (stmt.getUpdateCount() == 0) {
                            String msg = String.format("Insert of Runtime Manager URI %s of EBPInstanceReference of instance %s (LogID %s) failed.", uRI, instance.getID(), instance.getLogID());
                            logger.severe(msg);
                            throw new DataSourceException(msg);
                        }
                        stmt = JDBCTools.close(stmt);
                    }
                    ++var11_19;
                }
                for (String string : runtimeURIsToDelete) {
                    stmt = con.prepareStatement(SQLWriteConstants.SQL_INST_EBP_INST_REF_RUNTIME_URIS_DELETE);
                    stmt.setLong(1, instance.getLogID().getMostSignificantBits());
                    stmt.setLong(2, instance.getLogID().getLeastSignificantBits());
                    stmt.setString(3, string);
                    stmt.execute();
                    if (stmt.getUpdateCount() == 0) {
                        String msg = String.format("Deletion of Runtime Manager URI %s of EBPInstanceReference of instance %s (LogID %s) failed.", string, instance.getID(), instance.getLogID());
                        logger.severe(msg);
                        throw new DataSourceException(msg);
                    }
                    stmt = JDBCTools.close(stmt);
                }
                HashSet<String> hashSet = new HashSet<String>();
                stmt = con.prepareStatement(SQLWriteConstants.SQL_INST_EBP_INST_REF_EXECMAN_URIS_FIND);
                stmt.setLong(1, instance.getLogID().getMostSignificantBits());
                stmt.setLong(2, instance.getLogID().getLeastSignificantBits());
                rs = stmt.executeQuery();
                while (rs.next()) {
                    hashSet.add(SQLHelp.getString(rs, 1));
                }
                rs = JDBCTools.close(rs);
                stmt = JDBCTools.close(stmt);
                URI[] uRIArray2 = ref.getExecutionManagerURIs();
                int n3 = uRIArray2.length;
                n = 0;
                while (n < n3) {
                    boolean insertURI;
                    URI uRI = uRIArray2[n];
                    boolean bl = insertURI = !hashSet.remove(uRI.toString());
                    if (insertURI) {
                        stmt = con.prepareStatement(SQLWriteConstants.SQL_INST_EBP_INST_REF_EXECMAN_URIS_INSERT);
                        stmt.setLong(1, instance.getLogID().getMostSignificantBits());
                        stmt.setLong(2, instance.getLogID().getLeastSignificantBits());
                        stmt.setString(3, uRI.toString());
                        stmt.execute();
                        if (stmt.getUpdateCount() == 0) {
                            String msg = String.format("Insert of Execution Manager URI %s of EBPInstanceReference of instance %s (LogID %s) failed.", uRI, instance.getID(), instance.getLogID());
                            logger.severe(msg);
                            throw new DataSourceException(msg);
                        }
                        stmt = JDBCTools.close(stmt);
                    }
                    ++n;
                }
                for (String string : hashSet) {
                    stmt = con.prepareStatement(SQLWriteConstants.SQL_INST_EBP_INST_REF_EXECMAN_URIS_DELETE);
                    stmt.setLong(1, instance.getLogID().getMostSignificantBits());
                    stmt.setLong(2, instance.getLogID().getLeastSignificantBits());
                    stmt.setString(3, string);
                    stmt.execute();
                    if (stmt.getUpdateCount() == 0) {
                        String msg = String.format("Deletion of Execution Manager URI %s of EBPInstanceReference of instance %s (LogID %s) failed.", string, instance.getID(), instance.getLogID());
                        logger.severe(msg);
                        throw new DataSourceException(msg);
                    }
                    stmt = JDBCTools.close(stmt);
                }
                if (ownConnection) {
                    con = JDBCTools.close(con);
                } else if (doCommit) {
                    con = JDBCTools.commit(con);
                }
            }
            catch (SQLException e) {
                throw new DataSourceException("SQLException", e);
            }
        }
        catch (Throwable throwable) {
            if (ownConnection || doCommit) {
                JDBCTools.rollbackQuietly(con);
            }
            if (ownConnection) {
                JDBCTools.closeQuietly(con, stmt, rs);
            } else {
                JDBCTools.closeQuietly(stmt, rs);
            }
            throw throwable;
        }
        if (ownConnection || doCommit) {
            JDBCTools.rollbackQuietly(con);
        }
        if (ownConnection) {
            JDBCTools.closeQuietly(con, (Statement)stmt, rs);
        } else {
            JDBCTools.closeQuietly((Statement)stmt, rs);
        }
        logger.finer("SQLHelpWrite.insertOrUpdateEBPInstanceReference() exit");
    }

    private static void insertOrUpdateEnquiries(ExtendedConnection con, ExecutableInstance instance, ExecutableInstancePropertyTracker tracker) throws DataSourceException {
        logger.finest("SQLHelpWrite.insertOrUpdateEnquiries() entry");
        boolean enquiryUpdateSkip = SQLHelpWrite.canSkipUpdateForNodeInstanceProperty(tracker, ExecutableInstancePropertyTracker.ExecutableInstanceNodeProperty.ENQUIRIES);
        if (enquiryUpdateSkip) {
            return;
        }
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            try {
                HashMap<Integer, HashSet<Integer>> enquiriesToDelete = new HashMap<Integer, HashSet<Integer>>();
                stmt = con.prepareStatement(SQLWriteConstants.SQL_INST_ENQUIRIES_FIND);
                stmt.setLong(1, instance.getLogID().getMostSignificantBits());
                stmt.setLong(2, instance.getLogID().getLeastSignificantBits());
                rs = stmt.executeQuery();
                while (rs.next()) {
                    int n = rs.getInt(SQLConstants.COL_ENQUIRY_PK[2]);
                    int index = rs.getInt(SQLConstants.COL_ENQUIRY_PK[3]);
                    HashSet<Integer> indices = (HashSet<Integer>)enquiriesToDelete.get(n);
                    if (indices == null) {
                        indices = new HashSet<Integer>();
                        enquiriesToDelete.put(n, indices);
                    }
                    indices.add(index);
                }
                rs = JDBCTools.close(rs);
                stmt = JDBCTools.close(stmt);
                for (Node node : instance.getTemplate().getNodes()) {
                    int nodeID = node.getID();
                    Set enqIndicesToDelete = (Set)enquiriesToDelete.get(nodeID);
                    if (enqIndicesToDelete == null) {
                        enqIndicesToDelete = Collections.emptySet();
                    }
                    ArrayList<Enquiry> enquiries = new ArrayList<Enquiry>();
                    enquiries.addAll(instance.getCurrentEnquiries(nodeID));
                    int repliedIdx = -1;
                    if (instance.getRepliedEnquiry(nodeID) != null) {
                        enquiries.add(instance.getRepliedEnquiry(nodeID));
                        repliedIdx = enquiries.size() - 1;
                    }
                    int enquiryIndex = 0;
                    while (enquiryIndex < enquiries.size()) {
                        boolean insertEnquiry = !enqIndicesToDelete.remove(enquiryIndex);
                        stmt = insertEnquiry ? con.prepareStatement(SQLWriteConstants.SQL_INST_ENQUIRIES_INSERT) : con.prepareStatement(SQLWriteConstants.SQL_INST_ENQURIRIES_UPDATE);
                        Enquiry enquiry = (Enquiry)enquiries.get(enquiryIndex);
                        stmt.setLong(1, instance.getLogID().getMostSignificantBits());
                        stmt.setLong(2, instance.getLogID().getLeastSignificantBits());
                        stmt.setInt(3, nodeID);
                        stmt.setInt(4, enquiryIndex);
                        stmt.setString(5, enquiry.getQuestion());
                        if (repliedIdx == enquiryIndex) {
                            stmt.setString(6, enquiry.getReply());
                        } else {
                            stmt.setNull(6, 2005);
                        }
                        if (!insertEnquiry) {
                            stmt.setLong(7, instance.getLogID().getMostSignificantBits());
                            stmt.setLong(8, instance.getLogID().getLeastSignificantBits());
                            stmt.setInt(9, nodeID);
                            stmt.setInt(10, enquiryIndex);
                        }
                        stmt.execute();
                        if (stmt.getUpdateCount() == 0) {
                            String msg = String.format("%s of Enquiry at index %s (%s) of node %s of instance %s (LogID %s) failed.", insertEnquiry ? "Insert" : "Update", enquiryIndex, enquiry.getQuestion(), nodeID, instance.getID(), instance.getLogID());
                            logger.severe(msg);
                            throw new DataSourceException(msg);
                        }
                        stmt = JDBCTools.close(stmt);
                        HashSet<Triple<Long, Long, Integer>> enquiryQAsToDelete = new HashSet<Triple<Long, Long, Integer>>();
                        stmt = con.prepareStatement(SQLWriteConstants.SQL_INST_ENQUIRY_QUAS_FIND);
                        stmt.setLong(1, instance.getLogID().getMostSignificantBits());
                        stmt.setLong(2, instance.getLogID().getLeastSignificantBits());
                        stmt.setInt(3, nodeID);
                        stmt.setInt(4, enquiryIndex);
                        rs = stmt.executeQuery();
                        while (rs.next()) {
                            enquiryQAsToDelete.add(new Triple<Long, Long, Integer>(rs.getLong(1), rs.getLong(2), rs.getInt(3)));
                        }
                        rs = JDBCTools.close(rs);
                        stmt = JDBCTools.close(stmt);
                        ArrayList<Pair<Integer, QualifiedAgent>> qasToInsert = new ArrayList<Pair<Integer, QualifiedAgent>>();
                        qasToInsert.add(new Pair<Integer, QualifiedAgent>(1, enquiry.getOriginator()));
                        if (enquiry.getReplier() != null) {
                            qasToInsert.add(new Pair<Integer, QualifiedAgent>(3, enquiry.getReplier()));
                        }
                        for (QualifiedAgent qualifiedAgent : enquiry.getRecipients()) {
                            qasToInsert.add(new Pair<Integer, QualifiedAgent>(2, qualifiedAgent));
                        }
                        for (Pair pair : qasToInsert) {
                            boolean insertQA = !enquiryQAsToDelete.remove(new Triple<Long, Long, Integer>(((QualifiedAgent)pair.getSecond()).getAgentID(), ((QualifiedAgent)pair.getSecond()).getOrgPositionID(), (Integer)pair.getFirst()));
                            stmt = insertQA ? con.prepareStatement(SQLWriteConstants.SQL_INST_ENQUIRY_QUAS_INSERT) : con.prepareStatement(SQLWriteConstants.SQL_INST_ENQUIRY_QUAS_UPDATE);
                            stmt.setLong(1, instance.getLogID().getMostSignificantBits());
                            stmt.setLong(2, instance.getLogID().getLeastSignificantBits());
                            stmt.setInt(3, nodeID);
                            stmt.setInt(4, enquiryIndex);
                            stmt.setLong(5, ((QualifiedAgent)pair.getSecond()).getAgentID());
                            stmt.setLong(6, ((QualifiedAgent)pair.getSecond()).getOrgPositionID());
                            stmt.setInt(7, (Integer)pair.getFirst());
                            stmt.setString(8, ((QualifiedAgent)pair.getSecond()).getAgentUserName());
                            stmt.setString(9, ((QualifiedAgent)pair.getSecond()).getOrgPositionName());
                            if (!insertQA) {
                                stmt.setLong(10, instance.getLogID().getMostSignificantBits());
                                stmt.setLong(11, instance.getLogID().getLeastSignificantBits());
                                stmt.setInt(12, nodeID);
                                stmt.setInt(13, enquiryIndex);
                                stmt.setLong(14, ((QualifiedAgent)pair.getSecond()).getAgentID());
                                stmt.setLong(15, ((QualifiedAgent)pair.getSecond()).getOrgPositionID());
                                stmt.setInt(16, (Integer)pair.getFirst());
                            }
                            stmt.execute();
                            if (stmt.getUpdateCount() == 0) {
                                String msg = String.format("%s of Enquiry QA %s (type %s) of enquiry at pos %s (%s) of node %s of instance %s (LogID %s) failed.", insertQA ? "Insert" : "Update", ((QualifiedAgent)pair.getSecond()).getAgentUserName(), pair.getFirst(), enquiryIndex, enquiry.getQuestion(), nodeID, instance.getID(), instance.getLogID());
                                logger.severe(msg);
                                throw new DataSourceException(msg);
                            }
                            stmt = JDBCTools.close(stmt);
                        }
                        for (Triple triple : enquiryQAsToDelete) {
                            stmt = con.prepareStatement(SQLWriteConstants.SQL_INST_ENQUIRY_QUAS_DELETE);
                            stmt.setLong(1, instance.getLogID().getMostSignificantBits());
                            stmt.setLong(2, instance.getLogID().getLeastSignificantBits());
                            stmt.setInt(3, nodeID);
                            stmt.setInt(4, enquiryIndex);
                            stmt.setLong(5, (Long)triple.getFirst());
                            stmt.setLong(6, (Long)triple.getSecond());
                            stmt.setInt(7, (Integer)triple.getThird());
                            stmt.execute();
                            if (stmt.getUpdateCount() == 0) {
                                String msg = String.format("Deletion of Enquiry QA (agent %s orgPos %s type %s) of enquiry at pos %s (%s) of node %s of instance %s (LogID %s) failed.", triple.getFirst(), triple.getSecond(), triple.getThird(), enquiryIndex, enquiry.getQuestion(), nodeID, instance.getID(), instance.getLogID());
                                logger.severe(msg);
                                throw new DataSourceException(msg);
                            }
                            stmt = JDBCTools.close(stmt);
                        }
                        ++enquiryIndex;
                    }
                }
                for (Map.Entry entry : enquiriesToDelete.entrySet()) {
                    Iterator iterator = ((Set)entry.getValue()).iterator();
                    while (iterator.hasNext()) {
                        int enquiryIndex = (Integer)iterator.next();
                        if (stmt == null) {
                            stmt = con.prepareStatement(SQLWriteConstants.SQL_INST_ENQUIRY_DELETE);
                            stmt.setLong(1, instance.getLogID().getMostSignificantBits());
                            stmt.setLong(2, instance.getLogID().getLeastSignificantBits());
                        }
                        stmt.setInt(3, (Integer)entry.getKey());
                        stmt.setInt(4, enquiryIndex);
                        stmt.executeUpdate();
                    }
                }
                stmt = JDBCTools.close(stmt);
            }
            catch (SQLException e) {
                throw new DataSourceException("SQLException", e);
            }
        }
        catch (Throwable throwable) {
            JDBCTools.closeQuietly(stmt, rs);
            throw throwable;
        }
        JDBCTools.closeQuietly((Statement)stmt, rs);
        logger.finest("SQLHelpWrite.insertOrUpdateEnquiries() exit");
    }

    public static void insertOrUpdateInstanceStatus(JDBCDataSource dataSource, InstanceStatus instanceStatus, ExtendedConnection con, boolean doCommit) throws DataSourceException {
        logger.finer("SQLHelpWrite.insertOrUpdateInstanceStatus() entry");
        boolean ownConnection = con == null;
        PreparedStatement stmt = null;
        try {
            try {
                if (ownConnection) {
                    con = dataSource.getConnection();
                }
                con.setAutoCommit(false);
                boolean insert = !SQLHelpWrite.entryExists(con, "PMInstanceStatus", SQLConstants.COL_INSTANCESTATUS_PK, new SQLHelp.ParameterList(new int[]{-5, -5}, new Object[]{instanceStatus.getInstanceID().getMostSignificantBits(), instanceStatus.getInstanceID().getLeastSignificantBits()}));
                stmt = insert ? con.prepareStatement(SQLWriteConstants.SQL_INSTANCE_STATUS_INSERT) : con.prepareStatement(SQLWriteConstants.SQL_INSTANCE_STATUS_UPDATE);
                stmt.setLong(1, instanceStatus.getInstanceID().getMostSignificantBits());
                stmt.setLong(2, instanceStatus.getInstanceID().getLeastSignificantBits());
                stmt.setInt(3, instanceStatus.getMigrationStatus().getCode());
                stmt.setString(4, instanceStatus.getMigrationStatusComment());
                stmt.setInt(5, instanceStatus.getExecutionStatus().getCode());
                stmt.setString(6, instanceStatus.getExecutionStatusComment());
                if (!insert) {
                    stmt.setLong(7, instanceStatus.getInstanceID().getMostSignificantBits());
                    stmt.setLong(8, instanceStatus.getInstanceID().getLeastSignificantBits());
                }
                stmt.execute();
                if (stmt.getUpdateCount() == 0) {
                    String msg = String.format("%s of InstanceStatus of instance %s failed.", insert ? "Insert" : "Update", instanceStatus.getInstanceID());
                    logger.severe(msg);
                    throw new DataSourceException(msg);
                }
                stmt = JDBCTools.close(stmt);
                if (ownConnection) {
                    con = JDBCTools.close(con);
                } else if (doCommit) {
                    con = JDBCTools.commit(con);
                }
            }
            catch (SQLException e) {
                throw new DataSourceException("SQLException", e);
            }
        }
        catch (Throwable throwable) {
            if (ownConnection || doCommit) {
                JDBCTools.rollbackQuietly(con);
            }
            if (ownConnection) {
                JDBCTools.closeQuietly(con, stmt);
            } else {
                JDBCTools.closeQuietly(stmt);
            }
            throw throwable;
        }
        if (ownConnection || doCommit) {
            JDBCTools.rollbackQuietly(con);
        }
        if (ownConnection) {
            JDBCTools.closeQuietly(con, (Statement)stmt);
        } else {
            JDBCTools.closeQuietly((Statement)stmt);
        }
        logger.finer("SQLHelpWrite.insertOrUpdateInstanceStatus() exit");
    }

    public static void deleteTemplate(JDBCDataSource dataSource, UUID templateID, ExtendedConnection con, boolean doCommit) throws DataSourceException {
        logger.finer("SQLHelpWrite.deleteTemplate() entry");
        boolean ownConnection = con == null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            try {
                if (ownConnection) {
                    con = dataSource.getConnection();
                }
                con.setAutoCommit(false);
                stmt = con.prepareStatement(SQLHelp.SimpleQueryGenerator.generateSelect("PMSubProcess", SQLConstants.COL_SUBPROCESS_PK, SQLConstants.COL_SUBPROCESS_REFERENCED_ID));
                stmt.setLong(1, templateID.getMostSignificantBits());
                stmt.setLong(2, templateID.getLeastSignificantBits());
                rs = stmt.executeQuery();
                while (rs.next()) {
                    SQLHelpWrite.deleteTemplate(dataSource, new UUID(rs.getLong(2), rs.getLong(3)), con, false);
                }
                rs = JDBCTools.close(rs);
                stmt = JDBCTools.close(stmt);
                stmt = con.prepareStatement(SQLHelp.SimpleQueryGenerator.generateSelect("PMSubProcess", SQLConstants.COL_SUBPROCESS_REFERENCED_ID, SQLConstants.COL_SUBPROCESS_TEMPLATE_ID_TYPE));
                stmt.setLong(1, templateID.getMostSignificantBits());
                stmt.setLong(2, templateID.getLeastSignificantBits());
                stmt.setInt(3, 3);
                rs = stmt.executeQuery();
                while (rs.next()) {
                    SQLHelpWrite.deleteTemplate(dataSource, new UUID(rs.getLong(1), rs.getLong(2)), con, false);
                }
                rs = JDBCTools.close(rs);
                stmt = JDBCTools.close(stmt);
                stmt = con.prepareStatement(SQLHelp.SimpleQueryGenerator.generateDelete("PMDataEdge", SQLConstants.COL_DATAEDGE_PARENT_ID));
                stmt.setLong(1, templateID.getMostSignificantBits());
                stmt.setLong(2, templateID.getLeastSignificantBits());
                stmt.execute();
                stmt = JDBCTools.close(stmt);
                stmt = con.prepareStatement(SQLHelp.SimpleQueryGenerator.generateDelete("PMEdge", SQLConstants.COL_EDGE_PARENT_ID));
                stmt.setLong(1, templateID.getMostSignificantBits());
                stmt.setLong(2, templateID.getLeastSignificantBits());
                stmt.execute();
                stmt = JDBCTools.close(stmt);
                stmt = con.prepareStatement(SQLHelp.SimpleQueryGenerator.generateDelete("PMProcessModelParameter", SQLConstants.COL_PROCESSMODELPARAMETER_TEMPLATE_ID));
                stmt.setLong(1, templateID.getMostSignificantBits());
                stmt.setLong(2, templateID.getLeastSignificantBits());
                stmt.execute();
                stmt = JDBCTools.close(stmt);
                stmt = con.prepareStatement(SQLHelp.SimpleQueryGenerator.generateDelete("PMTemplate", SQLConstants.COL_TEMPLATE_PK));
                stmt.setLong(1, templateID.getMostSignificantBits());
                stmt.setLong(2, templateID.getLeastSignificantBits());
                stmt.execute();
                if (stmt.getUpdateCount() == 0) {
                    String msg = String.format("Deletion of template %s failed.", templateID);
                    logger.severe(msg);
                    throw new DataSourceException(msg);
                }
                stmt = JDBCTools.close(stmt);
                if (ownConnection) {
                    con = JDBCTools.close(con);
                } else if (doCommit) {
                    con = JDBCTools.commit(con);
                }
            }
            catch (SQLException e) {
                throw new DataSourceException("SQLException", e);
            }
        }
        catch (Throwable throwable) {
            if (ownConnection || doCommit) {
                JDBCTools.rollbackQuietly(con);
            }
            if (ownConnection) {
                JDBCTools.closeQuietly(con, stmt, rs);
            } else {
                JDBCTools.closeQuietly(stmt, rs);
            }
            throw throwable;
        }
        if (ownConnection || doCommit) {
            JDBCTools.rollbackQuietly(con);
        }
        if (ownConnection) {
            JDBCTools.closeQuietly(con, (Statement)stmt, rs);
        } else {
            JDBCTools.closeQuietly((Statement)stmt, rs);
        }
        logger.finer("SQLHelpWrite.deleteTemplate() exit");
    }

    public static boolean deleteInstance(JDBCDataSource dataSource, UUID instanceID, ExtendedConnection con, boolean doCommit) throws DataSourceException {
        ResultSet rs;
        PreparedStatement stmt;
        boolean ownConnection;
        block24: {
            block25: {
                logger.finer("SQLHelpWrite.deleteInstance() entry");
                ownConnection = con == null;
                stmt = null;
                rs = null;
                if (ownConnection) {
                    con = dataSource.getConnection();
                }
                con.setAutoCommit(false);
                stmt = con.prepareStatement(SQLHelp.SimpleQueryGenerator.generateSelect("PMInstance", SQLConstants.COL_INSTANCE_PK, SQLConstants.COL_INSTANCE_ID));
                stmt.setLong(1, instanceID.getMostSignificantBits());
                stmt.setLong(2, instanceID.getLeastSignificantBits());
                rs = stmt.executeQuery();
                if (rs.next()) break block24;
                rs = JDBCTools.close(rs);
                stmt = JDBCTools.close(stmt);
                if (ownConnection) {
                    con = JDBCTools.close(con);
                } else if (doCommit) {
                    con = JDBCTools.commit(con);
                }
                if (!ownConnection && !doCommit) break block25;
                JDBCTools.rollbackQuietly(con);
            }
            if (ownConnection) {
                JDBCTools.closeQuietly(con, (Statement)stmt, rs);
            } else {
                JDBCTools.closeQuietly((Statement)stmt, rs);
            }
            return false;
        }
        try {
            try {
                UUID instanceLogID = new UUID(rs.getLong(1), rs.getLong(2));
                rs = JDBCTools.close(rs);
                stmt = JDBCTools.close(stmt);
                ArrayList<Integer> nodeIDs = new ArrayList<Integer>();
                stmt = con.prepareStatement(SQLHelp.SimpleQueryGenerator.generateSelect("PMNodeInstanceData", SQLConstants.COL_NODEINSTANCEDATA_PK, SQLConstants.COL_NODEINSTANCEDATA_PARENT_ID));
                stmt.setLong(1, instanceLogID.getMostSignificantBits());
                stmt.setLong(2, instanceLogID.getLeastSignificantBits());
                rs = stmt.executeQuery();
                while (rs.next()) {
                    nodeIDs.add(rs.getInt(3));
                }
                rs = JDBCTools.close(rs);
                stmt = JDBCTools.close(stmt);
                Iterator iterator = nodeIDs.iterator();
                while (iterator.hasNext()) {
                    int nodeID = (Integer)iterator.next();
                    stmt = con.prepareStatement(SQLHelp.SimpleQueryGenerator.generateSelect("PMLWPInstance", SQLConstants.COL_LWPINSTANCE_ALL, SQLConstants.COL_LWPINSTANCE_PARENT_ID));
                    stmt.setLong(1, instanceLogID.getMostSignificantBits());
                    stmt.setLong(2, instanceLogID.getLeastSignificantBits());
                    stmt.setInt(3, nodeID);
                    rs = stmt.executeQuery();
                    while (rs.next()) {
                        SQLHelpWrite.deleteInstance(dataSource, new UUID(rs.getLong(5), rs.getLong(6)), con, false);
                    }
                    rs = JDBCTools.close(rs);
                    stmt = JDBCTools.close(stmt);
                }
                stmt = con.prepareStatement(SQLHelp.SimpleQueryGenerator.generateDelete("PMInstance", SQLConstants.COL_INSTANCE_PK));
                stmt.setLong(1, instanceLogID.getMostSignificantBits());
                stmt.setLong(2, instanceLogID.getLeastSignificantBits());
                stmt.execute();
                if (stmt.getUpdateCount() == 0) {
                    String msg = String.format("Deletion of instance %s (LogID %s) failed.", instanceID, instanceLogID);
                    logger.severe(msg);
                    throw new DataSourceException(msg);
                }
                stmt = JDBCTools.close(stmt);
                stmt = con.prepareStatement(SQLHelp.SimpleQueryGenerator.generateDelete("PMInstanceStatus", SQLConstants.COL_INSTANCESTATUS_PK));
                stmt.setLong(1, instanceID.getMostSignificantBits());
                stmt.setLong(2, instanceID.getLeastSignificantBits());
                stmt.execute();
                stmt = JDBCTools.close(stmt);
                stmt = con.prepareStatement(SQLHelp.SimpleQueryGenerator.generateDelete("PMInstanceLocks", SQLConstants.COL_INSTANCELOCKS_PK));
                stmt.setLong(1, instanceID.getMostSignificantBits());
                stmt.setLong(2, instanceID.getLeastSignificantBits());
                stmt.execute();
                stmt = JDBCTools.close(stmt);
                if (ownConnection) {
                    con = JDBCTools.close(con);
                } else if (doCommit) {
                    con = JDBCTools.commit(con);
                }
            }
            catch (SQLException e) {
                throw new DataSourceException("SQLException", e);
            }
        }
        catch (Throwable throwable) {
            if (ownConnection || doCommit) {
                JDBCTools.rollbackQuietly(con);
            }
            if (ownConnection) {
                JDBCTools.closeQuietly(con, (Statement)stmt, rs);
            } else {
                JDBCTools.closeQuietly(stmt, rs);
            }
            throw throwable;
        }
        if (ownConnection || doCommit) {
            JDBCTools.rollbackQuietly(con);
        }
        if (ownConnection) {
            JDBCTools.closeQuietly(con, (Statement)stmt, rs);
        } else {
            JDBCTools.closeQuietly((Statement)stmt, rs);
        }
        logger.finer("SQLHelpWrite.deleteInstance() exit");
        return true;
    }
}

