/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.core.processmanager.storage.sqlstorage.atomic;

import de.aristaflow.adept2.base.dbaccess.ExtendedConnection;
import de.aristaflow.adept2.base.dbaccess.JDBCDataSource;
import de.aristaflow.adept2.base.dbaccess.JDBCTools;
import de.aristaflow.adept2.base.service.LogService;
import de.aristaflow.adept2.base.sessionmanagement.QualifiedAgent;
import de.aristaflow.adept2.core.processmanager.TemplateStatusProvider;
import de.aristaflow.adept2.core.processmanager.storage.ExecutableProcessModelFactory;
import de.aristaflow.adept2.core.processmanager.storage.InstanceStorage;
import de.aristaflow.adept2.core.processmanager.storage.ProcessManagerStorageTools;
import de.aristaflow.adept2.core.processmanager.storage.TemplateStorage;
import de.aristaflow.adept2.core.processmanager.storage.sqlstorage.atomic.ComplexSelectGenerator;
import de.aristaflow.adept2.core.processmanager.storage.sqlstorage.atomic.SQLConstants;
import de.aristaflow.adept2.core.processmanager.storage.sqlstorage.atomic.SQLHelp;
import de.aristaflow.adept2.core.processmanager.storage.sqlstorage.atomic.SQLHelpRead;
import de.aristaflow.adept2.core.processmanager.storage.sqlstorage.atomic.SQLHelpWrite;
import de.aristaflow.adept2.model.execution.ExecutableInstance;
import de.aristaflow.adept2.model.execution.ExecutionFactory;
import de.aristaflow.adept2.model.processmodel.ChangeableInstance;
import de.aristaflow.adept2.model.processmodel.EBPInstanceReference;
import de.aristaflow.adept2.model.processmodel.InstanceReference;
import de.aristaflow.adept2.model.processmodel.InstanceStatus;
import de.aristaflow.adept2.model.processmodel.ProcessModelFactory;
import de.aristaflow.adept2.model.processmodel.Template;
import de.aristaflow.adept2.util.DataSourceException;
import de.aristaflow.adept2.util.UUIDTools;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Logger;

public class SQLInstanceStorage
implements InstanceStorage {
    private final Logger logger;
    private final LogService logService;
    private JDBCDataSource dataSource;
    private ReentrantReadWriteLock lock;
    private ProcessModelFactory pmFactory;
    private ExecutionFactory executionFactory;
    private TemplateStorage templateStorage;
    private final SQLHelpRead helpRead;
    private final SQLHelpWrite helpWrite;

    public SQLInstanceStorage(JDBCDataSource dataSource, ReentrantReadWriteLock lock, ProcessModelFactory pmFactory, ExecutionFactory executionFactory, TemplateStorage templateStorage, SQLHelpRead helpRead, SQLHelpWrite helpWrite, LogService logService) {
        this.logger = logService.getLogger();
        this.logService = logService;
        this.dataSource = dataSource;
        this.lock = lock;
        this.pmFactory = pmFactory;
        this.executionFactory = executionFactory;
        this.templateStorage = templateStorage;
        this.helpRead = helpRead;
        this.helpWrite = helpWrite;
    }

    @Override
    public ExecutableInstance createInstance(UUID templateID, String instanceName, QualifiedAgent supervisorAgent, QualifiedAgent initiatorAgent, EBPInstanceReference parentActivity, long creationTime) throws DataSourceException {
        this.logService.logMethodEntry("SQLInstanceStorage.createInstance()", null, "method entry", templateID, null, null, null, parentActivity);
        try {
            ExecutableInstance instance;
            this.lock.writeLock().lock();
            try {
                Template template = this.templateStorage.getTemplate(templateID);
                ExecutableProcessModelFactory epmf = new ExecutableProcessModelFactory(null);
                epmf.setCreateChangeable(false);
                instance = epmf.createInstance(UUIDTools.createPositiveUUID(), UUIDTools.createRandomUUID(), instanceName, templateID, template, supervisorAgent, initiatorAgent, parentActivity, creationTime);
                InstanceStatus instanceStatus = ProcessManagerStorageTools.getDefaultInstanceStatus(instance.getID());
                SQLHelpWrite.insertOrUpdateInstance(this.dataSource, instance, this.templateStorage, false);
                SQLHelpWrite.insertOrUpdateInstanceStatus(this.dataSource, instanceStatus, null, true);
            }
            finally {
                this.lock.writeLock().unlock();
            }
            ExecutableInstance executableInstance = instance;
            return executableInstance;
        }
        finally {
            this.logService.logMethodExit("method exit");
        }
    }

    @Override
    public Map<UUID, QualifiedAgent> getChangeLocks() throws DataSourceException {
        HashMap<UUID, QualifiedAgent> res = new HashMap<UUID, QualifiedAgent>();
        ExtendedConnection con = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        this.logService.logMethodEntry("SQLInstanceStorage.getChangeLocks", null, "method entry");
        try {
            this.lock.readLock().lock();
            try {
                try {
                    con = this.dataSource.getConnection();
                    stmt = con.prepareStatement(SQLHelp.SimpleQueryGenerator.generateSelect("PMInstanceLocks", SQLConstants.COL_INSTANCELOCKS_ALL, new String[0]));
                    rs = stmt.executeQuery();
                    while (rs.next()) {
                        UUID id = new UUID(rs.getLong(1), rs.getLong(2));
                        QualifiedAgent qa = new QualifiedAgent(rs.getLong(3), rs.getString(4), rs.getLong(5), rs.getString(6));
                        res.put(id, qa);
                    }
                    rs = JDBCTools.close(rs);
                    stmt = JDBCTools.close(stmt);
                    con = JDBCTools.close(con);
                }
                catch (SQLException e) {
                    throw new DataSourceException("SQLException", e);
                }
            }
            catch (Throwable throwable) {
                JDBCTools.closeQuietly(con, stmt, rs);
                this.lock.readLock().unlock();
                throw throwable;
            }
            JDBCTools.closeQuietly(con, (Statement)stmt, rs);
            this.lock.readLock().unlock();
            HashMap<UUID, QualifiedAgent> hashMap = res;
            return hashMap;
        }
        finally {
            this.logService.logMethodExit("method exit");
        }
    }

    @Override
    public ExecutableInstance getInstance(UUID instanceID) throws DataSourceException {
        this.logService.logMethodEntry("SQLInstanceStorage.getInstance()", null, "method entry", null, null, null, instanceID, null);
        try {
            ExecutableInstance instance;
            this.lock.readLock().lock();
            try {
                instance = SQLHelpRead.getInstance(instanceID, this.templateStorage, this.dataSource, this.pmFactory, this.executionFactory);
            }
            finally {
                this.lock.readLock().unlock();
            }
            ExecutableInstance executableInstance = instance;
            return executableInstance;
        }
        finally {
            this.logService.logMethodExit("method exit");
        }
    }

    @Override
    public Set<UUID> getInstanceIDsForTemplate(UUID templateID) {
        HashSet<UUID> res = new HashSet<UUID>();
        ExtendedConnection con = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        this.logService.logMethodEntry("SQLInstanceStorage.getInstanceIDsForTemplate()", null, "method entry", templateID, null, null, null, null);
        try {
            this.lock.readLock().lock();
            try {
                try {
                    con = this.dataSource.getConnection();
                    stmt = con.prepareStatement(SQLHelp.SimpleQueryGenerator.generateSelect("PMTemplate", SQLConstants.COL_TEMPLATE_PK, SQLConstants.COL_TEMPLATE_PK));
                    stmt.setLong(1, templateID.getMostSignificantBits());
                    stmt.setLong(2, templateID.getLeastSignificantBits());
                    rs = stmt.executeQuery();
                    if (!rs.next()) {
                        String msg = String.format("Template %s does not exist!", templateID);
                        this.logger.severe(msg);
                        throw new IllegalArgumentException(msg);
                    }
                    JDBCTools.close(rs);
                    ComplexSelectGenerator.Table tabInstance = new ComplexSelectGenerator.Table("PMInstance", SQLConstants.COL_INSTANCE_ID);
                    ComplexSelectGenerator.WhereStatement whereTemplateID = new ComplexSelectGenerator.WhereStatement(SQLConstants.COL_INSTANCE_TEMPLATE_ID[0], "=");
                    whereTemplateID.andWith(new ComplexSelectGenerator.WhereStatement(SQLConstants.COL_INSTANCE_TEMPLATE_ID[1], "="));
                    ComplexSelectGenerator.WhereStatement whereOldTemplateID = new ComplexSelectGenerator.WhereStatement(SQLConstants.COL_INSTANCE_BASE_TEMPLATE_ID[0], "=");
                    whereOldTemplateID.andWith(new ComplexSelectGenerator.WhereStatement(SQLConstants.COL_INSTANCE_BASE_TEMPLATE_ID[1], "="));
                    ComplexSelectGenerator.WhereStatement where = new ComplexSelectGenerator.WhereStatement(whereTemplateID);
                    where.orWith(whereOldTemplateID);
                    tabInstance.addWhereStatements(where);
                    ComplexSelectGenerator select = new ComplexSelectGenerator(tabInstance);
                    JDBCTools.close(stmt);
                    stmt = con.prepareStatement(select.toString());
                    stmt.setLong(1, templateID.getMostSignificantBits());
                    stmt.setLong(2, templateID.getLeastSignificantBits());
                    stmt.setLong(3, templateID.getMostSignificantBits());
                    stmt.setLong(4, templateID.getLeastSignificantBits());
                    rs = stmt.executeQuery();
                    while (rs.next()) {
                        res.add(new UUID(rs.getLong(1), rs.getLong(2)));
                    }
                    rs = JDBCTools.close(rs);
                    stmt = JDBCTools.close(stmt);
                    con = JDBCTools.close(con);
                }
                catch (SQLException e) {
                    throw new RuntimeException("SQLException", e);
                }
            }
            catch (Throwable throwable) {
                JDBCTools.closeQuietly(con, stmt, rs);
                this.lock.readLock().unlock();
                throw throwable;
            }
            JDBCTools.closeQuietly(con, (Statement)stmt, rs);
            this.lock.readLock().unlock();
            HashSet<UUID> hashSet = res;
            return hashSet;
        }
        finally {
            this.logService.logMethodExit("method exit");
        }
    }

    @Override
    public InstanceReference getInstanceReference(UUID instanceID, TemplateStatusProvider statusProvider) throws DataSourceException {
        this.logService.logMethodEntry("SQLInstanceStorage.getInstanceReference()", null, "method entry", null, null, null, instanceID, null);
        try {
            this.lock.readLock().lock();
            try {
                InstanceReference instanceReference = SQLHelpRead.getInstanceReference(instanceID, this.templateStorage, statusProvider, this.dataSource, this.pmFactory);
                this.lock.readLock().unlock();
                return instanceReference;
            }
            catch (Throwable throwable) {
                this.lock.readLock().unlock();
                throw throwable;
            }
        }
        finally {
            this.logService.logMethodExit("method exit");
        }
    }

    @Override
    public InstanceStatus getInstanceStatus(UUID instanceID) throws DataSourceException {
        this.logService.logMethodEntry("SQLInstanceStorage.getInstanceStatus()", null, "method entry", null, null, null, instanceID, null);
        try {
            this.lock.readLock().lock();
            try {
                InstanceStatus instanceStatus = SQLHelpRead.getInstanceStatus(instanceID, this.dataSource, null, this.pmFactory);
                this.lock.readLock().unlock();
                return instanceStatus;
            }
            catch (Throwable throwable) {
                this.lock.readLock().unlock();
                throw throwable;
            }
        }
        finally {
            this.logService.logMethodExit("method exit");
        }
    }

    @Override
    public UUID getLogicalInstanceID(UUID logID) {
        ExtendedConnection con = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        this.logService.logMethodEntry("SQLInstanceStorage.getLogicalInstanceID()", null, "method entry", null, null, null, logID, null);
        try {
            UUID res;
            this.lock.readLock().lock();
            try {
                try {
                    con = this.dataSource.getConnection();
                    stmt = con.prepareStatement(SQLHelp.SimpleQueryGenerator.generateSelect("PMInstance", SQLConstants.COL_INSTANCE_ID, SQLConstants.COL_INSTANCE_PK));
                    stmt.setLong(1, logID.getMostSignificantBits());
                    stmt.setLong(2, logID.getLeastSignificantBits());
                    rs = stmt.executeQuery();
                    if (!rs.next()) {
                        String msg = String.format("Instance with LogID %s not found!", logID);
                        throw new IllegalAccessError(msg);
                    }
                    res = new UUID(rs.getLong(1), rs.getLong(2));
                    rs = JDBCTools.close(rs);
                    stmt = JDBCTools.close(stmt);
                    con = JDBCTools.close(con);
                }
                catch (SQLException e) {
                    throw new RuntimeException("SQLException", e);
                }
            }
            catch (Throwable throwable) {
                JDBCTools.closeQuietly(con, stmt, rs);
                this.lock.readLock().unlock();
                throw throwable;
            }
            JDBCTools.closeQuietly(con, (Statement)stmt, rs);
            this.lock.readLock().unlock();
            UUID uUID = res;
            return uUID;
        }
        finally {
            this.logService.logMethodExit("method exit");
        }
    }

    @Override
    public int lockInstanceForChanging(UUID instanceID, QualifiedAgent lockingAgent) throws DataSourceException {
        ExtendedConnection con = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        String msg = "SQLInstanceStorage.lockInstanceForChanging() for %s";
        this.logService.logMethodEntry(String.format(msg, lockingAgent), null, "method entry", null, null, null, instanceID, null);
        try {
            int res;
            this.lock.writeLock().lock();
            try {
                try {
                    con = this.dataSource.getConnection();
                    con.setAutoCommit(false);
                    stmt = con.prepareStatement(SQLHelp.SimpleQueryGenerator.generateSelect("PMInstanceLocks", SQLConstants.COL_INSTANCELOCKS_ALL, SQLConstants.COL_INSTANCELOCKS_PK));
                    stmt.setLong(1, instanceID.getMostSignificantBits());
                    stmt.setLong(2, instanceID.getLeastSignificantBits());
                    rs = stmt.executeQuery();
                    if (rs.next()) {
                        int newLockCount;
                        if (lockingAgent.getAgentID() != rs.getLong(3) || lockingAgent.getOrgPositionID() != rs.getLong(5)) {
                            msg = String.format("Instance %s already locked by someone else!", instanceID);
                            this.logger.severe(msg);
                            throw new DataSourceException(msg);
                        }
                        res = newLockCount = rs.getInt(7) + 1;
                        JDBCTools.close(rs);
                        JDBCTools.close(stmt);
                        stmt = con.prepareStatement(SQLHelp.SimpleQueryGenerator.generateUpdate("PMInstanceLocks", SQLConstants.COL_INSTANCELOCKS_LOCKCOUNT, SQLConstants.COL_INSTANCELOCKS_PK));
                        stmt.setInt(1, newLockCount);
                        stmt.setLong(2, instanceID.getMostSignificantBits());
                        stmt.setLong(3, instanceID.getLeastSignificantBits());
                        stmt.execute();
                        if (stmt.getUpdateCount() == 0) {
                            msg = String.format("Update of LockCount of instance %s failed.", instanceID);
                            this.logger.severe(msg);
                            throw new DataSourceException(msg);
                        }
                    } else {
                        JDBCTools.close(rs);
                        JDBCTools.close(stmt);
                        stmt = con.prepareStatement(SQLHelp.SimpleQueryGenerator.generateInsert("PMInstanceLocks", SQLConstants.COL_INSTANCELOCKS_ALL));
                        stmt.setLong(1, instanceID.getMostSignificantBits());
                        stmt.setLong(2, instanceID.getLeastSignificantBits());
                        stmt.setLong(3, lockingAgent.getAgentID());
                        stmt.setString(4, lockingAgent.getAgentUserName());
                        stmt.setLong(5, lockingAgent.getOrgPositionID());
                        stmt.setString(6, lockingAgent.getOrgPositionName());
                        stmt.setInt(7, 1);
                        res = 1;
                        stmt.execute();
                        if (stmt.getUpdateCount() == 0) {
                            msg = String.format("Insert of LockCount of instance %s failed.", instanceID);
                            this.logger.severe(msg);
                            throw new DataSourceException(msg);
                        }
                    }
                    msg = String.format("Locked instance %s. New lock count = %s.", instanceID, res);
                    this.logger.finer(msg);
                    stmt = JDBCTools.close(stmt);
                    con = JDBCTools.close(con);
                }
                catch (SQLException e) {
                    throw new DataSourceException("SQLException", e);
                }
            }
            catch (Throwable throwable) {
                JDBCTools.closeQuietly(con, stmt, rs);
                this.lock.writeLock().unlock();
                throw throwable;
            }
            JDBCTools.closeQuietly(con, (Statement)stmt, rs);
            this.lock.writeLock().unlock();
            int n = res;
            return n;
        }
        finally {
            this.logService.logMethodExit("method exit");
        }
    }

    @Override
    public int unlockInstanceForChanging(UUID instanceID) throws DataSourceException {
        ExtendedConnection con = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        this.logService.logMethodEntry("SQLInstanceStorage.unlockInstanceForChanging()", null, "method entry", null, null, null, instanceID, null);
        try {
            int res;
            this.lock.writeLock().lock();
            try {
                try {
                    con = this.dataSource.getConnection();
                    con.setAutoCommit(false);
                    stmt = con.prepareStatement(SQLHelp.SimpleQueryGenerator.generateSelect("PMInstanceLocks", SQLConstants.COL_INSTANCELOCKS_ALL, SQLConstants.COL_INSTANCELOCKS_PK));
                    stmt.setLong(1, instanceID.getMostSignificantBits());
                    stmt.setLong(2, instanceID.getLeastSignificantBits());
                    rs = stmt.executeQuery();
                    if (!rs.next()) {
                        String msg = String.format("Instance %s not locked!", instanceID);
                        this.logger.severe(msg);
                        throw new DataSourceException(msg);
                    }
                    res = rs.getInt(7) - 1;
                    if (res == 0) {
                        JDBCTools.close(rs);
                        JDBCTools.close(stmt);
                        stmt = con.prepareStatement(SQLHelp.SimpleQueryGenerator.generateDelete("PMInstanceLocks", SQLConstants.COL_INSTANCELOCKS_PK));
                        stmt.setLong(1, instanceID.getMostSignificantBits());
                        stmt.setLong(2, instanceID.getLeastSignificantBits());
                        stmt.execute();
                        if (stmt.getUpdateCount() == 0) {
                            String msg = String.format("Deletion of lock of instance %s failed.", instanceID);
                            this.logger.severe(msg);
                            throw new DataSourceException(msg);
                        }
                    } else {
                        JDBCTools.close(rs);
                        JDBCTools.close(stmt);
                        stmt = con.prepareStatement(SQLHelp.SimpleQueryGenerator.generateUpdate("PMInstanceLocks", SQLConstants.COL_INSTANCELOCKS_LOCKCOUNT, SQLConstants.COL_INSTANCELOCKS_PK));
                        stmt.setInt(1, res);
                        stmt.setLong(2, instanceID.getMostSignificantBits());
                        stmt.setLong(3, instanceID.getLeastSignificantBits());
                        stmt.execute();
                        if (stmt.getUpdateCount() == 0) {
                            String msg = String.format("Update of lock of instance %s failed.", instanceID);
                            this.logger.severe(msg);
                            throw new DataSourceException(msg);
                        }
                    }
                    String msg = String.format("Unlocked instance %s. New lock count = %s.", instanceID, res);
                    this.logger.finer(msg);
                    stmt = JDBCTools.close(stmt);
                    con = JDBCTools.close(con);
                }
                catch (SQLException e) {
                    throw new DataSourceException("SQLException", e);
                }
            }
            catch (Throwable throwable) {
                JDBCTools.closeQuietly(con, stmt, rs);
                this.lock.writeLock().unlock();
                throw throwable;
            }
            JDBCTools.closeQuietly(con, (Statement)stmt, rs);
            this.lock.writeLock().unlock();
            int n = res;
            return n;
        }
        finally {
            this.logService.logMethodExit("method exit");
        }
    }

    @Override
    public void updateInstance(ExecutableInstance instance) throws DataSourceException {
        this.logService.logMethodEntry("SQLInstanceStorage.updateInstance()", null, "method entry", instance.getTemplate().getID(), instance.getBaseTemplateID(), null, instance.getID(), null);
        try {
            this.lock.writeLock().lock();
            try {
                SQLHelpWrite.insertOrUpdateInstance(this.dataSource, instance, this.templateStorage, false);
            }
            finally {
                this.lock.writeLock().unlock();
            }
        }
        finally {
            this.logService.logMethodExit("method exit");
        }
    }

    @Override
    public void updateInstanceStatus(InstanceStatus instanceStatus) throws DataSourceException {
        PreparedStatement stmt = null;
        ExtendedConnection con = null;
        ResultSet rs = null;
        this.logService.logMethodEntry("SQLInstanceStorage.updateInstanceStatus()", null, "method entry", null, null, null, instanceStatus.getInstanceID(), null);
        try {
            this.lock.writeLock().lock();
            try {
                try {
                    con = this.dataSource.getConnection();
                    stmt = con.prepareStatement(SQLHelp.SimpleQueryGenerator.generateSelect("PMInstance", SQLConstants.COL_INSTANCE_PK, SQLConstants.COL_INSTANCE_ID));
                    stmt.setLong(1, instanceStatus.getInstanceID().getMostSignificantBits());
                    stmt.setLong(2, instanceStatus.getInstanceID().getLeastSignificantBits());
                    rs = stmt.executeQuery();
                    if (!rs.next()) {
                        String msg = String.format("Instance %s does not exist!", instanceStatus.getInstanceID());
                        this.logger.severe(msg);
                        throw new IllegalArgumentException(msg);
                    }
                    SQLHelpWrite.insertOrUpdateInstanceStatus(this.dataSource, instanceStatus, con, true);
                    rs = JDBCTools.close(rs);
                    stmt = JDBCTools.close(stmt);
                    con = JDBCTools.close(con);
                }
                catch (SQLException e) {
                    this.logger.severe(e.getMessage());
                    throw new DataSourceException(e);
                }
            }
            catch (Throwable throwable) {
                JDBCTools.closeQuietly(con, stmt, rs);
                this.lock.writeLock().unlock();
                throw throwable;
            }
            JDBCTools.closeQuietly(con, (Statement)stmt, rs);
            this.lock.writeLock().unlock();
        }
        finally {
            this.logService.logMethodExit("method exit");
        }
    }

    @Override
    public ChangeableInstance getInstanceChangeable(UUID instanceID) throws DataSourceException {
        this.logService.logMethodEntry("SQLInstanceStorage.getInstanceChangeable()", null, "method entry", null, null, null, instanceID, null);
        try {
            this.lock.readLock().lock();
            try {
                ExecutableInstance exec = this.getInstance(instanceID);
                ChangeableInstance changeableInstance = ProcessManagerStorageTools.executableToChangeableInstance(exec);
                this.lock.readLock().unlock();
                return changeableInstance;
            }
            catch (Throwable throwable) {
                this.lock.readLock().unlock();
                throw throwable;
            }
        }
        finally {
            this.logService.logMethodExit("method exit");
        }
    }

    @Override
    public UUID updateChangeableInstance(ChangeableInstance instance) throws DataSourceException {
        UUID res = instance.getID();
        ExtendedConnection con = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        this.logService.logMethodEntry("SQLInstanceStorage.updateChangeableInstance()", null, "method entry", instance.getTemplate().getID(), instance.getBaseTemplateID(), null, instance.getID(), null);
        try {
            this.lock.writeLock().lock();
            try {
                try {
                    con = this.dataSource.getConnection();
                    stmt = con.prepareStatement(SQLHelp.SimpleQueryGenerator.generateSelect("PMInstance", SQLConstants.COL_INSTANCE_ID, SQLConstants.COL_INSTANCE_PK));
                    stmt.setLong(1, instance.getLogID().getMostSignificantBits());
                    stmt.setLong(2, instance.getLogID().getLeastSignificantBits());
                    rs = stmt.executeQuery();
                    if (!rs.next()) {
                        String msg = String.format("Instance with LogID %s does not exist!", instance.getLogID());
                        throw new IllegalArgumentException(msg);
                    }
                    rs = JDBCTools.close(rs);
                    stmt = JDBCTools.close(stmt);
                    con = JDBCTools.close(con);
                    if (instance.isModified()) {
                        UUID oldID = instance.getID();
                        ExecutableInstance oldInstance = this.getInstance(oldID);
                        res = oldID;
                        instance = ProcessManagerStorageTools.changeInstanceValues(instance, res, instance.getTemplate());
                        ExecutableInstance exec = ProcessManagerStorageTools.changeableToExecutableInstance(instance, oldInstance);
                        SQLHelpWrite.insertOrUpdateInstance(this.dataSource, exec, this.templateStorage, true);
                    }
                }
                catch (SQLException e) {
                    throw new DataSourceException("SQLException", e);
                }
            }
            catch (Throwable throwable) {
                JDBCTools.closeQuietly(con, stmt, rs);
                this.lock.writeLock().unlock();
                throw throwable;
            }
            JDBCTools.closeQuietly(con, (Statement)stmt, rs);
            this.lock.writeLock().unlock();
            UUID uUID = res;
            return uUID;
        }
        finally {
            this.logService.logMethodExit("method exit");
        }
    }

    public void removeInstanceData(UUID instanceID) throws DataSourceException {
        this.logService.logMethodEntry("SQLInstanceStorage.removeInstanceData()", null, "method entry", null, null, null, instanceID, null);
        try {
            this.lock.writeLock().lock();
            try {
                if (!SQLHelpWrite.deleteInstance(this.dataSource, instanceID, null, false)) {
                    String msg = String.format("Instance with id %s not found!", instanceID);
                    this.logger.severe(msg);
                    throw new IllegalArgumentException(msg);
                }
            }
            finally {
                this.lock.writeLock().unlock();
            }
        }
        finally {
            this.logService.logMethodExit("method exit");
        }
    }

    public TemplateStorage getTemplateStorage() {
        return this.templateStorage;
    }

    public void setTemplateStorage(TemplateStorage templateStorage) {
        this.templateStorage = templateStorage;
    }
}

