/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.core.processmanager.storage.sqlstorage.atomic;

import de.aristaflow.adept2.base.configuration.AbortServiceException;
import de.aristaflow.adept2.base.dbaccess.ExtendedConnection;
import de.aristaflow.adept2.base.dbaccess.JDBCDataSource;
import de.aristaflow.adept2.base.dbaccess.JDBCTools;
import de.aristaflow.adept2.base.dbaccess.SQLTools;
import de.aristaflow.adept2.base.service.LogService;
import de.aristaflow.adept2.base.service.Registry;
import de.aristaflow.adept2.base.sessionmanagement.SessionFactory;
import de.aristaflow.adept2.base.sessionmanagement.SessionToken;
import de.aristaflow.adept2.core.checks.processmodel.ProcessTemplateCheck;
import de.aristaflow.adept2.core.checks.processmodel.ProcessTemplateCheckRunner;
import de.aristaflow.adept2.core.processmanager.storage.InstanceStorage;
import de.aristaflow.adept2.core.processmanager.storage.ProcessManagerStorage;
import de.aristaflow.adept2.core.processmanager.storage.TemplateStorage;
import de.aristaflow.adept2.core.processmanager.storage.sqlstorage.atomic.SQLHelpRead;
import de.aristaflow.adept2.core.processmanager.storage.sqlstorage.atomic.SQLHelpWrite;
import de.aristaflow.adept2.core.processmanager.storage.sqlstorage.atomic.SQLInstanceStorage;
import de.aristaflow.adept2.core.processmanager.storage.sqlstorage.atomic.SQLTemplateStorage;
import de.aristaflow.adept2.model.execution.ExecutionFactory;
import de.aristaflow.adept2.model.processmodel.ProcessModelFactory;
import de.aristaflow.adept2.model.processmodel.Template;
import de.aristaflow.adept2.model.processmodel.tools.NodeRelations;
import de.aristaflow.adept2.model.processmodel.tools.ProcessElementIdentifierTools;
import de.aristaflow.adept2.util.CheckReport;
import de.aristaflow.adept2.util.DataSourceException;
import java.io.IOException;
import java.net.URI;
import java.sql.SQLException;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SQLStorage
implements ProcessManagerStorage {
    private final LogService logService;
    private final Logger logger;
    private final JDBCDataSource dataSource;
    private final ProcessTemplateCheckRunner allChecks;
    private TemplateStorage templateStorage;
    private final InstanceStorage instanceStorage;

    public SQLStorage(Registry registry, SessionFactory sessionFactory, URI[] processManagerURIs, ProcessTemplateCheck[] checks, SQLHelpRead helpRead, LogService logService) throws AbortServiceException {
        this.logger = logService.getLogger();
        this.logService = logService;
        SessionToken session = sessionFactory.getSessionToken(processManagerURIs);
        this.dataSource = registry.getServiceOfType(session, "JDBCDataSource", JDBCDataSource.class);
        ExtendedConnection con = null;
        try {
            try {
                con = this.dataSource.getConnection();
                if (!con.tableExists("PMTemplate")) {
                    SQLTools.runSQLScript(con, SQLStorage.class.getResourceAsStream("sqlscripts/pm-create.sql"));
                }
                con = JDBCTools.close(con);
            }
            catch (SQLException e) {
                throw new AbortServiceException("Could not create tables for processmanager storage.", e);
            }
            catch (IOException e) {
                throw new AbortServiceException("Could not create tables for processmanager storage.", e);
            }
        }
        catch (Throwable throwable) {
            JDBCTools.closeQuietly(con);
            throw throwable;
        }
        JDBCTools.closeQuietly(con);
        ProcessModelFactory pmFactory = registry.getModelFactory("ProcessModelFactory", ProcessModelFactory.class);
        ExecutionFactory executionFactory = registry.getModelFactory("ExecutionFactory", ExecutionFactory.class);
        ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
        SQLHelpWrite helpWrite = new SQLHelpWrite(this.logger);
        this.templateStorage = new SQLTemplateStorage(this.dataSource, lock, pmFactory, helpRead, helpWrite, logService);
        this.instanceStorage = new SQLInstanceStorage(this.dataSource, lock, pmFactory, executionFactory, this.templateStorage, helpRead, helpWrite, logService);
        this.allChecks = new ProcessTemplateCheckRunner(checks);
    }

    public void runChecks() throws InitialisationException {
        try {
            Set<UUID> ids = this.templateStorage.getAllTemplateIDs();
            for (UUID id : ids) {
                this.performInitChecks(this.templateStorage.getTemplate(id));
            }
        }
        catch (DataSourceException e) {
            String message = "DataSourceException while running checks.";
            this.logger.log(Level.SEVERE, message);
            throw new InitialisationException(message, e);
        }
    }

    protected void performInitChecks(Template template) throws InitialisationException {
        long start = System.nanoTime();
        URI base = ProcessElementIdentifierTools.getTemplateIdentifier(template, "localhost");
        CheckReport checkReport = new CheckReport(base);
        boolean checkSuccess = this.allChecks.performCheck(template, new NodeRelations(template), checkReport);
        if (!checkSuccess) {
            String message = String.format("The checks on template '%s' failed with the following result:\n%s.", template.getID().toString(), checkReport.getSimpleReportSummary());
            this.logger.log(Level.SEVERE, message);
            throw new InitialisationException(message);
        }
        String msg = String.format("Performed initial checks for template '%s' [%s] in %,d nano seconds", template.getName(), template.getID(), System.nanoTime() - start);
        this.logger.fine(msg);
    }

    @Override
    public InstanceStorage getInstanceStorage() {
        return this.instanceStorage;
    }

    @Override
    public TemplateStorage getTemplateStorage() {
        return this.templateStorage;
    }

    public JDBCDataSource getDataSource() {
        return this.dataSource;
    }

    public void setTemplateStorage(TemplateStorage templateStorage) {
        this.templateStorage = templateStorage;
        ((SQLInstanceStorage)this.instanceStorage).setTemplateStorage(templateStorage);
    }

    public static class InitialisationException
    extends RuntimeException {
        private static final long serialVersionUID = -6887533159084268783L;

        public InitialisationException(String message, Throwable cause) {
            super(message, cause);
        }

        public InitialisationException(String message) {
            super(message);
        }
    }
}

