/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.core.processmanager.storage.sqlstorage.atomic;

import de.aristaflow.adept2.base.dbaccess.ExtendedConnection;
import de.aristaflow.adept2.base.dbaccess.JDBCDataSource;
import de.aristaflow.adept2.base.dbaccess.JDBCTools;
import de.aristaflow.adept2.base.service.LogService;
import de.aristaflow.adept2.base.sessionmanagement.QualifiedAgent;
import de.aristaflow.adept2.core.processmanager.TemplateStatusProvider;
import de.aristaflow.adept2.core.processmanager.storage.TemplateStorage;
import de.aristaflow.adept2.core.processmanager.storage.sqlstorage.atomic.SQLConstants;
import de.aristaflow.adept2.core.processmanager.storage.sqlstorage.atomic.SQLHelp;
import de.aristaflow.adept2.core.processmanager.storage.sqlstorage.atomic.SQLHelpRead;
import de.aristaflow.adept2.core.processmanager.storage.sqlstorage.atomic.SQLHelpWrite;
import de.aristaflow.adept2.model.processmodel.ProcessModelFactory;
import de.aristaflow.adept2.model.processmodel.Template;
import de.aristaflow.adept2.model.processmodel.TemplateReference;
import de.aristaflow.adept2.model.processmodel.TemplateStatus;
import de.aristaflow.adept2.util.DataSourceException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Logger;

public class SQLTemplateStorage
implements TemplateStorage {
    private final Logger logger;
    private final LogService logService;
    private JDBCDataSource dataSource;
    private ReentrantReadWriteLock lock;
    private ProcessModelFactory pmFactory;
    private final SQLHelpRead helpRead;
    private final SQLHelpWrite helpWrite;

    public SQLTemplateStorage(JDBCDataSource dataSource, ReentrantReadWriteLock lock, ProcessModelFactory pmFactory, SQLHelpRead helpRead, SQLHelpWrite helpWrite, LogService logService) {
        this.logger = logService.getLogger();
        this.logService = logService;
        this.dataSource = dataSource;
        this.lock = lock;
        this.pmFactory = pmFactory;
        this.helpRead = helpRead;
        this.helpWrite = helpWrite;
    }

    @Override
    public void createTemplate(Template template, TemplateStatus templateStatus) throws DataSourceException {
        this.logService.logMethodEntry("SQLTemplateStorage.createTemplate()", null, "method entry", template.getID(), null, null, null, null);
        try {
            this.lock.writeLock().lock();
            try {
                SQLHelpWrite.insertOrUpdateTemplate(this.dataSource, template, null, true);
                if (templateStatus != null) {
                    SQLHelpWrite.insertOrUpdateTemplateStatus(this.dataSource, templateStatus, null, true);
                }
            }
            finally {
                this.lock.writeLock().unlock();
            }
        }
        finally {
            this.logService.logMethodExit("method exit");
        }
    }

    @Override
    public Set<UUID> getAllTemplateIDs() throws DataSourceException {
        HashSet<UUID> res = new HashSet<UUID>();
        PreparedStatement stmt = null;
        ExtendedConnection con = null;
        ResultSet rs = null;
        this.logService.logMethodEntry("SQLTemplateStorage.getAllTemplateIDs", null, "method entry");
        try {
            this.lock.readLock().lock();
            try {
                try {
                    con = this.dataSource.getConnection();
                    stmt = con.prepareStatement(SQLHelp.SimpleQueryGenerator.generateSelect("PMTemplate", SQLConstants.COL_TEMPLATE_PK, new String[0]));
                    rs = stmt.executeQuery();
                    while (rs.next()) {
                        res.add(new UUID(rs.getLong(1), rs.getLong(2)));
                    }
                    rs = JDBCTools.close(rs);
                    stmt = JDBCTools.close(stmt);
                    con = JDBCTools.close(con);
                }
                catch (SQLException e) {
                    String msg = "SQLException";
                    this.logger.severe(msg);
                    throw new DataSourceException(msg, e);
                }
            }
            catch (Throwable throwable) {
                JDBCTools.closeQuietly(con, stmt, rs);
                this.lock.readLock().unlock();
                throw throwable;
            }
            JDBCTools.closeQuietly(con, (Statement)stmt, rs);
            this.lock.readLock().unlock();
            HashSet<UUID> hashSet = res;
            return hashSet;
        }
        finally {
            this.logService.logMethodExit("method exit");
        }
    }

    @Override
    public UUID getParentTemplateID(UUID embeddedID) throws DataSourceException {
        this.logService.logMethodEntry("SQLTemplateStorage.getParentTemplateID()", null, "method entry", null, null, embeddedID, null, null);
        try {
            this.lock.readLock().lock();
            try {
                UUID uUID = SQLHelpRead.getParentTemplateID(embeddedID, this.dataSource, null);
                this.lock.readLock().unlock();
                return uUID;
            }
            catch (Throwable throwable) {
                this.lock.readLock().unlock();
                throw throwable;
            }
        }
        finally {
            this.logService.logMethodExit("method exit");
        }
    }

    @Override
    public Template getTemplate(UUID templateID) throws DataSourceException {
        this.logService.logMethodEntry("SQLTemplateStorage.getTemplate()", null, "method entry", templateID, null, null, null, null);
        try {
            this.lock.readLock().lock();
            try {
                Template template = SQLHelpRead.getTemplate(templateID, this.dataSource, null, this.pmFactory);
                this.lock.readLock().unlock();
                return template;
            }
            catch (Throwable throwable) {
                this.lock.readLock().unlock();
                throw throwable;
            }
        }
        finally {
            this.logService.logMethodExit("method exit");
        }
    }

    @Override
    public TemplateReference getTemplateReference(UUID templateID, TemplateStatusProvider statusProvider) throws DataSourceException {
        this.logService.logMethodEntry("SQLTemplateStorage.getTemplateReference()", null, "method entry", templateID, null, null, null, null);
        try {
            this.lock.readLock().lock();
            try {
                TemplateStatus templateStatus = statusProvider.getTemplateStatus(templateID);
                TemplateReference templateReference = SQLHelpRead.getTemplateReference(templateID, templateStatus, this.dataSource, null, this.pmFactory);
                this.lock.readLock().unlock();
                return templateReference;
            }
            catch (Throwable throwable) {
                this.lock.readLock().unlock();
                throw throwable;
            }
        }
        finally {
            this.logService.logMethodExit("method exit");
        }
    }

    @Override
    public TemplateStatus getTemplateStatus(UUID templateID) throws DataSourceException {
        this.logService.logMethodEntry("SQLTemplateStorage.getTemplateStatus()", null, "method entry", templateID, null, null, null, null);
        try {
            this.lock.readLock().lock();
            try {
                TemplateStatus templateStatus = SQLHelpRead.getTemplateStatus(templateID, this.dataSource, null, this.pmFactory);
                this.lock.readLock().unlock();
                return templateStatus;
            }
            catch (Throwable throwable) {
                this.lock.readLock().unlock();
                throw throwable;
            }
        }
        finally {
            this.logService.logMethodExit("method exit");
        }
    }

    @Override
    public Map<UUID, QualifiedAgent> getUpdateLocks() throws DataSourceException {
        HashMap<UUID, QualifiedAgent> res = new HashMap<UUID, QualifiedAgent>();
        ExtendedConnection con = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        this.logService.logMethodEntry("SQLTemplateStorage.getUpdateLocks", null, "method entry");
        try {
            this.lock.readLock().lock();
            try {
                try {
                    con = this.dataSource.getConnection();
                    stmt = con.prepareStatement(SQLHelp.SimpleQueryGenerator.generateSelect("PMTemplateLocks", SQLConstants.COL_TEMPLATELOCKS_ALL, new String[0]));
                    rs = stmt.executeQuery();
                    while (rs.next()) {
                        UUID id = new UUID(rs.getLong(1), rs.getLong(2));
                        QualifiedAgent qa = new QualifiedAgent(rs.getLong(3), rs.getString(4), rs.getLong(5), rs.getString(6));
                        res.put(id, qa);
                    }
                    rs = JDBCTools.close(rs);
                    stmt = JDBCTools.close(stmt);
                    con = JDBCTools.close(con);
                }
                catch (SQLException e) {
                    throw new DataSourceException("SQLException", e);
                }
            }
            catch (Throwable throwable) {
                JDBCTools.closeQuietly(con, stmt, rs);
                this.lock.readLock().unlock();
                throw throwable;
            }
            JDBCTools.closeQuietly(con, (Statement)stmt, rs);
            this.lock.readLock().unlock();
            HashMap<UUID, QualifiedAgent> hashMap = res;
            return hashMap;
        }
        finally {
            this.logService.logMethodExit("method exit");
        }
    }

    @Override
    public int lockTemplateForUpdates(UUID templateID, QualifiedAgent lockingAgent) throws DataSourceException {
        ExtendedConnection con = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        String msg = "SQLTemplateStorage.lockTemplateForUpdates() for %s";
        this.logService.logMethodEntry(String.format(msg, lockingAgent), null, "method entry", templateID, null, null, null, null);
        try {
            int res;
            this.lock.writeLock().lock();
            try {
                try {
                    con = this.dataSource.getConnection();
                    if (!SQLHelpRead.templateExists(templateID, this.dataSource, con)) {
                        msg = String.format("Template %s not found!", templateID);
                        throw new IllegalArgumentException(msg);
                    }
                    stmt = con.prepareStatement(SQLHelp.SimpleQueryGenerator.generateSelect("PMTemplateLocks", SQLConstants.COL_TEMPLATELOCKS_ALL, SQLConstants.COL_TEMPLATELOCKS_PK));
                    stmt.setLong(1, templateID.getMostSignificantBits());
                    stmt.setLong(2, templateID.getLeastSignificantBits());
                    rs = stmt.executeQuery();
                    if (rs.next()) {
                        int newLockCount;
                        if (lockingAgent.getAgentID() != rs.getLong(3) || lockingAgent.getOrgPositionID() != rs.getLong(5)) {
                            msg = String.format("Template %s already locked by someone else!", templateID);
                            this.logger.severe(msg);
                            throw new DataSourceException(msg);
                        }
                        res = newLockCount = rs.getInt(7) + 1;
                        JDBCTools.close(rs);
                        JDBCTools.close(stmt);
                        stmt = con.prepareStatement(SQLHelp.SimpleQueryGenerator.generateUpdate("PMTemplateLocks", SQLConstants.COL_TEMPLATELOCKS_LOCKCOUNT, SQLConstants.COL_TEMPLATELOCKS_PK));
                        stmt.setInt(1, newLockCount);
                        stmt.setLong(2, templateID.getMostSignificantBits());
                        stmt.setLong(3, templateID.getLeastSignificantBits());
                        stmt.execute();
                        if (stmt.getUpdateCount() == 0) {
                            msg = String.format("Update of LockCount of template %s failed.", templateID);
                            this.logger.severe(msg);
                            throw new DataSourceException(msg);
                        }
                    } else {
                        JDBCTools.close(rs);
                        JDBCTools.close(stmt);
                        stmt = con.prepareStatement(SQLHelp.SimpleQueryGenerator.generateInsert("PMTemplateLocks", SQLConstants.COL_TEMPLATELOCKS_ALL));
                        stmt.setLong(1, templateID.getMostSignificantBits());
                        stmt.setLong(2, templateID.getLeastSignificantBits());
                        stmt.setLong(3, lockingAgent.getAgentID());
                        stmt.setString(4, lockingAgent.getAgentUserName());
                        stmt.setLong(5, lockingAgent.getOrgPositionID());
                        stmt.setString(6, lockingAgent.getOrgPositionName());
                        stmt.setInt(7, 1);
                        res = 1;
                        stmt.execute();
                        if (stmt.getUpdateCount() == 0) {
                            msg = String.format("Insert of LockCount of template %s failed.", templateID);
                            this.logger.severe(msg);
                            throw new DataSourceException(msg);
                        }
                    }
                    stmt = JDBCTools.close(stmt);
                    con = JDBCTools.close(con);
                }
                catch (SQLException e) {
                    throw new DataSourceException("SQLException", e);
                }
            }
            catch (Throwable throwable) {
                JDBCTools.closeQuietly(con, stmt, rs);
                this.lock.writeLock().unlock();
                throw throwable;
            }
            JDBCTools.closeQuietly(con, (Statement)stmt, rs);
            this.lock.writeLock().unlock();
            int n = res;
            return n;
        }
        finally {
            this.logService.logMethodExit("method exit");
        }
    }

    @Override
    public int unlockTemplateForUpdates(UUID templateID) throws DataSourceException {
        ExtendedConnection con = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        this.logService.logMethodEntry("SQLTemplateStorage.unlockTemplateForUpdates()", null, "method entry", templateID, null, null, null, null);
        try {
            int res;
            this.lock.writeLock().lock();
            try {
                try {
                    con = this.dataSource.getConnection();
                    stmt = con.prepareStatement(SQLHelp.SimpleQueryGenerator.generateSelect("PMTemplateLocks", SQLConstants.COL_TEMPLATELOCKS_ALL, SQLConstants.COL_TEMPLATELOCKS_PK));
                    stmt.setLong(1, templateID.getMostSignificantBits());
                    stmt.setLong(2, templateID.getLeastSignificantBits());
                    rs = stmt.executeQuery();
                    if (!rs.next()) {
                        String msg = String.format("Template %s not locked!", templateID);
                        this.logger.severe(msg);
                        throw new DataSourceException(msg);
                    }
                    res = rs.getInt(7) - 1;
                    if (res == 0) {
                        JDBCTools.close(rs);
                        JDBCTools.close(stmt);
                        stmt = con.prepareStatement(SQLHelp.SimpleQueryGenerator.generateDelete("PMTemplateLocks", SQLConstants.COL_TEMPLATELOCKS_PK));
                        stmt.setLong(1, templateID.getMostSignificantBits());
                        stmt.setLong(2, templateID.getLeastSignificantBits());
                        stmt.execute();
                        if (stmt.getUpdateCount() == 0) {
                            String msg = String.format("Deletion of lock of template %s failed.", templateID);
                            this.logger.severe(msg);
                            throw new DataSourceException(msg);
                        }
                    } else {
                        JDBCTools.close(rs);
                        JDBCTools.close(stmt);
                        stmt = con.prepareStatement(SQLHelp.SimpleQueryGenerator.generateUpdate("PMTemplateLocks", SQLConstants.COL_TEMPLATELOCKS_LOCKCOUNT, SQLConstants.COL_TEMPLATELOCKS_PK));
                        stmt.setInt(1, res);
                        stmt.setLong(2, templateID.getMostSignificantBits());
                        stmt.setLong(3, templateID.getLeastSignificantBits());
                        stmt.execute();
                        if (stmt.getUpdateCount() == 0) {
                            String msg = String.format("Update of lock of template %s failed.", templateID);
                            this.logger.severe(msg);
                            throw new DataSourceException(msg);
                        }
                    }
                    stmt = JDBCTools.close(stmt);
                    con = JDBCTools.close(con);
                }
                catch (SQLException e) {
                    throw new DataSourceException("SQLException", e);
                }
            }
            catch (Throwable throwable) {
                JDBCTools.closeQuietly(con, stmt, rs);
                this.lock.writeLock().unlock();
                throw throwable;
            }
            JDBCTools.closeQuietly(con, (Statement)stmt, rs);
            this.lock.writeLock().unlock();
            int n = res;
            return n;
        }
        finally {
            this.logService.logMethodExit("method exit");
        }
    }

    @Override
    public void updateEmbeddedTemplateIDs(UUID embeddedID, UUID topLevelParentID) throws DataSourceException {
    }

    @Override
    public void updateTemplateStatus(TemplateStatus templateStatus) throws DataSourceException {
        PreparedStatement stmt = null;
        ExtendedConnection con = null;
        ResultSet rs = null;
        this.logService.logMethodEntry("SQLTemplateStorage.updateTemplateStatus()", null, "method entry", templateStatus.getTemplateID(), null, null, null, null);
        try {
            this.lock.writeLock().lock();
            try {
                try {
                    con = this.dataSource.getConnection();
                    stmt = con.prepareStatement(SQLHelp.SimpleQueryGenerator.generateSelect("PMTemplate", SQLConstants.COL_TEMPLATE_PK, SQLConstants.COL_TEMPLATE_PK));
                    stmt.setLong(1, templateStatus.getTemplateID().getMostSignificantBits());
                    stmt.setLong(2, templateStatus.getTemplateID().getLeastSignificantBits());
                    rs = stmt.executeQuery();
                    if (!rs.next()) {
                        String msg = String.format("Template %s does not exist!", templateStatus.getTemplateID());
                        this.logger.severe(msg);
                        throw new IllegalArgumentException(msg);
                    }
                    SQLHelpWrite.insertOrUpdateTemplateStatus(this.dataSource, templateStatus, con, false);
                    rs = JDBCTools.close(rs);
                    stmt = JDBCTools.close(stmt);
                    con = JDBCTools.close(con);
                }
                catch (SQLException e) {
                    this.logger.severe(e.getMessage());
                    throw new DataSourceException(e);
                }
            }
            catch (Throwable throwable) {
                JDBCTools.closeQuietly(con, stmt, rs);
                this.lock.writeLock().unlock();
                throw throwable;
            }
            JDBCTools.closeQuietly(con, (Statement)stmt, rs);
            this.lock.writeLock().unlock();
        }
        finally {
            this.logService.logMethodExit("method exit");
        }
    }

    public void removeTemplateData(UUID templateID) throws DataSourceException {
        this.logService.logMethodEntry("SQLTemplateStorage.removeTemplateData()", null, "method entry", templateID, null, null, null, null);
        try {
            this.lock.writeLock().lock();
            try {
                SQLHelpWrite.deleteTemplate(this.dataSource, templateID, null, true);
            }
            finally {
                this.lock.writeLock().unlock();
            }
        }
        finally {
            this.logService.logMethodExit("method exit");
        }
    }

    @Override
    public UUID getBaseTemplateID(UUID templateID) throws DataSourceException {
        ExtendedConnection con = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        this.logService.logMethodEntry("SQLTemplateStorage.getBaseTemplateID()", null, "method entry", templateID, null, null, null, null);
        try {
            UUID res;
            this.lock.readLock().lock();
            try {
                try {
                    con = this.dataSource.getConnection();
                    stmt = con.prepareStatement(SQLHelp.SimpleQueryGenerator.generateSelect("PMInstance", SQLConstants.COL_INSTANCE_BASE_TEMPLATE_ID, SQLConstants.COL_INSTANCE_TEMPLATE_ID));
                    stmt.setLong(1, templateID.getMostSignificantBits());
                    stmt.setLong(2, templateID.getLeastSignificantBits());
                    rs = stmt.executeQuery();
                    res = !rs.next() ? null : new UUID(rs.getLong(1), rs.getLong(2));
                    rs = JDBCTools.close(rs);
                    stmt = JDBCTools.close(stmt);
                    con = JDBCTools.close(con);
                }
                catch (SQLException e) {
                    throw new DataSourceException("SQLException", e);
                }
            }
            catch (Throwable throwable) {
                JDBCTools.closeQuietly(con, stmt, rs);
                this.lock.readLock().unlock();
                throw throwable;
            }
            JDBCTools.closeQuietly(con, (Statement)stmt, rs);
            this.lock.readLock().unlock();
            UUID uUID = res;
            return uUID;
        }
        finally {
            this.logService.logMethodExit("method exit");
        }
    }
}

