/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.core.processmanager.storage.transientstorage;

import de.aristaflow.adept2.base.sessionmanagement.QualifiedAgent;
import de.aristaflow.adept2.core.processmanager.TemplateStatusProvider;
import de.aristaflow.adept2.core.processmanager.storage.ExecutableProcessModelFactory;
import de.aristaflow.adept2.core.processmanager.storage.InstanceStorage;
import de.aristaflow.adept2.core.processmanager.storage.ProcessManagerStorage;
import de.aristaflow.adept2.core.processmanager.storage.ProcessManagerStorageTools;
import de.aristaflow.adept2.core.processmanager.storage.TemplateStorage;
import de.aristaflow.adept2.model.execution.ExecutableInstance;
import de.aristaflow.adept2.model.execution.defaultimplementation.DefaultExecutableInstance;
import de.aristaflow.adept2.model.globals.ActivityConstants;
import de.aristaflow.adept2.model.processmodel.ChangeableInstance;
import de.aristaflow.adept2.model.processmodel.EBPInstanceReference;
import de.aristaflow.adept2.model.processmodel.InstanceReference;
import de.aristaflow.adept2.model.processmodel.InstanceStatus;
import de.aristaflow.adept2.model.processmodel.ProcessModelParameter;
import de.aristaflow.adept2.model.processmodel.Template;
import de.aristaflow.adept2.model.processmodel.TemplateReference;
import de.aristaflow.adept2.model.processmodel.TemplateStatus;
import de.aristaflow.adept2.util.DataSourceException;
import de.aristaflow.adept2.util.LoggerTools;
import de.aristaflow.adept2.util.UUIDTools;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.UUID;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Logger;

public class TransientStorage
implements ProcessManagerStorage,
TemplateStorage,
InstanceStorage {
    public static final String UA_TEMPLATE_UUID = "UUID";
    protected final Logger logger;
    protected final ExecutableProcessModelFactory pmf;
    protected Map<UUID, Template> templates = new TreeMap<UUID, Template>();
    protected Map<UUID, TemplateStatus> allTemplateStatus = new TreeMap<UUID, TemplateStatus>();
    protected Map<UUID, Set<UUID>> instancesOf = new TreeMap<UUID, Set<UUID>>();
    protected Map<UUID, UUID> parentTemplates = new HashMap<UUID, UUID>();
    protected Map<UUID, QualifiedAgent> templateUpdateLocks = new HashMap<UUID, QualifiedAgent>();
    protected Map<UUID, Integer> templateUpdateLockCount = new HashMap<UUID, Integer>();
    protected Map<UUID, QualifiedAgent> instanceChangeLocks = new HashMap<UUID, QualifiedAgent>();
    protected Map<UUID, Integer> instanceChangeLockCount = new HashMap<UUID, Integer>();
    protected Map<UUID, ExecutableInstance> instances = new HashMap<UUID, ExecutableInstance>();
    protected final Map<UUID, UUID> logicalInstanceIDs = new HashMap<UUID, UUID>();
    protected Map<UUID, InstanceStatus> allInstanceStatus = new TreeMap<UUID, InstanceStatus>();
    protected Map<UUID, UUID> baseTemplateIDs = new HashMap<UUID, UUID>();
    protected ReentrantReadWriteLock lock = new ReentrantReadWriteLock();

    public TransientStorage() {
        this.logger = LoggerTools.getLogger(this);
        this.pmf = new ExecutableProcessModelFactory(null);
    }

    @Override
    public InstanceStorage getInstanceStorage() {
        return this;
    }

    @Override
    public TemplateStorage getTemplateStorage() {
        return this;
    }

    @Override
    public void createTemplate(Template template, TemplateStatus templateStatus) throws DataSourceException {
        this.lock.writeLock().lock();
        try {
            this.pmf.setCreateChangeable(false);
            this.templates.put(template.getID(), this.pmf.cloneTemplate(template));
            this.baseTemplateIDs.put(template.getID(), template.getID());
            if (templateStatus != null) {
                this.allTemplateStatus.put(template.getID(), templateStatus);
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public Set<UUID> getAllTemplateIDs() {
        this.lock.readLock().lock();
        try {
            Set<UUID> set = Collections.unmodifiableSet(this.templates.keySet());
            return set;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public Template getTemplate(UUID templateID) throws DataSourceException {
        Template template;
        long start = System.nanoTime();
        this.lock.readLock().lock();
        try {
            if (!this.templates.containsKey(templateID)) {
                throw new IllegalArgumentException(String.format("Template with ID '%1$s' does not exist!", templateID));
            }
            template = this.templates.get(templateID);
            this.lock.readLock().unlock();
        }
        catch (Throwable throwable) {
            this.lock.readLock().unlock();
            String msg = String.format("TransientStorage.getTemplate(%s) needed %,d nano seconds.", templateID, System.nanoTime() - start);
            this.logger.fine(msg);
            throw throwable;
        }
        String msg = String.format("TransientStorage.getTemplate(%s) needed %,d nano seconds.", templateID, System.nanoTime() - start);
        this.logger.fine(msg);
        return template;
    }

    @Override
    public TemplateReference getTemplateReference(UUID templateID, TemplateStatusProvider statusProvider) throws DataSourceException {
        this.lock.readLock().lock();
        try {
            Template template = this.getTemplate(templateID);
            TemplateStatus templateStatus = statusProvider.getTemplateStatus(template.getID());
            HashSet<ProcessModelParameter> inputParameters = new HashSet<ProcessModelParameter>(template.getParameters(ActivityConstants.AccessType.READ));
            HashSet<ProcessModelParameter> outputParameters = new HashSet<ProcessModelParameter>(template.getParameters(ActivityConstants.AccessType.WRITE));
            TemplateReference templateReference = this.pmf.createTemplateReference(template.getID(), template.getProcessType(), template.getVersion(), template.getName(), template.getDescription(), template.getSupervisorAgent(), inputParameters, outputParameters, template.getSupportedPlugins(), template.getPluginDatas(), template.getUserAttributes(), templateStatus.isTopLevelUsable(), templateStatus.getUsageAsSubprocess(), templateStatus.getBuildtimeState(), templateStatus.isDerivable(), templateStatus.isOutdated(true), templateStatus.isOutdated(false), templateStatus.isInstantiable(true), templateStatus.isInstantiable(false), templateStatus.areInstancesMigratableTo(true), templateStatus.areInstancesMigratableTo(false), templateStatus.areInstancesChangeable(true), templateStatus.areInstancesChangeable(false));
            return templateReference;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public TemplateStatus getTemplateStatus(UUID templateID) throws DataSourceException {
        this.lock.readLock().lock();
        try {
            if (!this.allTemplateStatus.containsKey(templateID)) {
                throw new IllegalArgumentException(String.format("Template with ID '%s' does not exist.", templateID));
            }
            TemplateStatus templateStatus = this.allTemplateStatus.get(templateID);
            return templateStatus;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public void updateTemplateStatus(TemplateStatus templateStatus) throws DataSourceException {
        this.lock.writeLock().lock();
        try {
            if (!this.allTemplateStatus.containsKey(templateStatus.getTemplateID())) {
                throw new IllegalArgumentException(String.format("Template with ID '%s' does not exist.", templateStatus.getTemplateID()));
            }
            this.allTemplateStatus.put(templateStatus.getTemplateID(), templateStatus);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public void updateEmbeddedTemplateIDs(UUID embeddedID, UUID parentID) throws DataSourceException {
        this.lock.writeLock().lock();
        try {
            this.parentTemplates.put(embeddedID, parentID);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public UUID getParentTemplateID(UUID embeddedID) throws DataSourceException {
        this.lock.readLock().lock();
        try {
            UUID uUID = this.parentTemplates.get(embeddedID);
            return uUID;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public int lockTemplateForUpdates(UUID templateID, QualifiedAgent lockingAgent) throws DataSourceException {
        int ret = 1;
        this.lock.writeLock().lock();
        try {
            if (this.templateUpdateLocks.containsKey(templateID)) {
                ret = this.templateUpdateLockCount.get(templateID);
                ++ret;
            }
            this.templateUpdateLocks.put(templateID, lockingAgent);
            this.templateUpdateLockCount.put(templateID, ret);
            int n = ret;
            return n;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public int unlockTemplateForUpdates(UUID templateID) throws DataSourceException {
        this.lock.writeLock().lock();
        try {
            int ret = this.templateUpdateLockCount.get(templateID);
            if (--ret > 0) {
                this.templateUpdateLockCount.put(templateID, ret);
            } else {
                this.templateUpdateLockCount.remove(templateID);
                this.templateUpdateLocks.remove(templateID);
            }
            int n = ret;
            return n;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public Map<UUID, QualifiedAgent> getUpdateLocks() throws DataSourceException {
        this.lock.readLock().lock();
        try {
            HashMap<UUID, QualifiedAgent> result;
            HashMap<UUID, QualifiedAgent> hashMap = result = new HashMap<UUID, QualifiedAgent>(this.templateUpdateLocks);
            return hashMap;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public ExecutableInstance createInstance(UUID templateID, String instanceName, QualifiedAgent supervisorAgent, QualifiedAgent initiatorAgent, EBPInstanceReference parentActivity, long creationTime) throws DataSourceException {
        ExecutableInstance instance;
        this.lock.writeLock().lock();
        try {
            Template template = this.getTemplate(templateID);
            this.pmf.setCreateChangeable(false);
            instance = this.pmf.createInstance(UUIDTools.createPositiveUUID(), UUIDTools.createRandomUUID(), instanceName, templateID, template, supervisorAgent, initiatorAgent, parentActivity, creationTime);
            Set<UUID> instanceSet = this.instancesOf.get(templateID);
            if (instanceSet == null) {
                instanceSet = new TreeSet<UUID>();
                this.instancesOf.put(templateID, instanceSet);
            }
            instanceSet.add(instance.getID());
            this.instances.put(instance.getID(), instance);
            this.logicalInstanceIDs.put(instance.getLogID(), instance.getID());
            InstanceStatus defaultIS = ProcessManagerStorageTools.getDefaultInstanceStatus(instance.getID());
            this.allInstanceStatus.put(instance.getID(), defaultIS);
        }
        finally {
            this.lock.writeLock().unlock();
        }
        return instance;
    }

    @Override
    public UUID getLogicalInstanceID(UUID logID) {
        this.lock.readLock().lock();
        try {
            if (!this.logicalInstanceIDs.containsKey(logID)) {
                String message = String.format("Instance with logical ID '%s' not known.", logID);
                this.logger.warning(message);
                throw new IllegalArgumentException(message);
            }
            UUID uUID = this.logicalInstanceIDs.get(logID);
            return uUID;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public ExecutableInstance getInstance(UUID instanceID) throws DataSourceException {
        this.lock.readLock().lock();
        try {
            if (!this.instances.containsKey(instanceID)) {
                throw new IllegalArgumentException(String.format("Instance with ID '%1$s' does not exist!", instanceID));
            }
            ExecutableInstance executableInstance = this.instances.get(instanceID);
            return executableInstance;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public InstanceReference getInstanceReference(UUID instanceID, TemplateStatusProvider statusProvider) throws DataSourceException {
        this.lock.readLock().lock();
        try {
            ExecutableInstance instance = this.getInstance(instanceID);
            InstanceStatus instanceStatus = this.getInstanceStatus(instanceID);
            TemplateReference templateRef = this.getTemplateReference(instance.getTemplate().getID(), statusProvider);
            UUID parentInstanceID = null;
            if (instance.getParentEBPReference() != null) {
                parentInstanceID = instance.getParentEBPReference().getInstanceID();
            }
            InstanceReference instanceReference = this.pmf.createInstanceReference(instance.getID(), instance.getLogID(), instance.getName(), instance.isModified(), templateRef, instance.getSupervisorAgent(), instance.getInitiatorAgent(), instance.getCreationTime(), parentInstanceID, instanceStatus.getExecutionStatus(), instance.getSupportedPlugins(), instance.getPluginDatas(), instance.getUserAttributes());
            return instanceReference;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public ChangeableInstance getInstanceChangeable(UUID instanceID) throws DataSourceException {
        ChangeableInstance changeable;
        this.lock.readLock().lock();
        try {
            if (!this.instances.containsKey(instanceID)) {
                throw new IllegalArgumentException(String.format("Instance with ID '%1$s' does not exist!", instanceID));
            }
            ExecutableInstance exec = this.instances.get(instanceID);
            changeable = ProcessManagerStorageTools.executableToChangeableInstance(exec);
        }
        finally {
            this.lock.readLock().unlock();
        }
        return changeable;
    }

    @Override
    public Set<UUID> getInstanceIDsForTemplate(UUID templateID) {
        this.lock.readLock().lock();
        try {
            if (!this.templates.containsKey(templateID)) {
                throw new IllegalArgumentException(String.format("Template with ID '%1$s' does not exist!", templateID));
            }
            if (!this.instancesOf.containsKey(templateID)) {
                Set<UUID> set = Collections.unmodifiableSet(new HashSet());
                return set;
            }
            Set<UUID> set = Collections.unmodifiableSet(this.instancesOf.get(templateID));
            return set;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public void updateInstance(ExecutableInstance instance) throws DataSourceException {
        this.lock.writeLock().lock();
        try {
            if (!this.instances.containsKey(instance.getID())) {
                String message = String.format("Instance object with ID '%s' not known", instance.getID());
                this.logger.warning(message);
                throw new IllegalArgumentException(message);
            }
            this.instances.put(instance.getID(), instance);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public UUID updateChangeableInstance(ChangeableInstance origInstance) throws DataSourceException {
        UUID newInstanceID;
        ChangeableInstance instance = origInstance;
        this.lock.writeLock().lock();
        try {
            UUID oldInstanceID;
            if (!this.instances.containsKey(instance.getID())) {
                String message = String.format("Instance object with ID '%s' not known", instance.getID());
                this.logger.warning(message);
                throw new IllegalArgumentException(message);
            }
            UUID baseTemplateID = instance.getBaseTemplateID();
            newInstanceID = oldInstanceID = instance.getID();
            instance = ProcessManagerStorageTools.changeInstanceValues(instance, newInstanceID, instance.getTemplate());
            newInstanceID = instance.getID();
            DefaultExecutableInstance execNew = new DefaultExecutableInstance(instance, this.getInstance(oldInstanceID));
            InstanceStatus status = this.getInstanceStatus(oldInstanceID);
            status = ProcessManagerStorageTools.changeInstanceStatusValues(status, newInstanceID);
            this.instances.remove(oldInstanceID);
            this.instances.put(newInstanceID, execNew);
            this.instancesOf.get(baseTemplateID).remove(oldInstanceID);
            this.instancesOf.get(baseTemplateID).add(newInstanceID);
            this.allInstanceStatus.remove(oldInstanceID);
            this.allInstanceStatus.put(newInstanceID, status);
            if (instance.isModified()) {
                this.baseTemplateIDs.put(instance.getTemplate().getID(), instance.getBaseTemplateID());
                this.templates.put(instance.getTemplate().getID(), instance.getTemplate());
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
        return newInstanceID;
    }

    @Override
    public InstanceStatus getInstanceStatus(UUID instanceID) throws DataSourceException {
        this.lock.readLock().lock();
        try {
            if (!this.allInstanceStatus.containsKey(instanceID)) {
                throw new IllegalArgumentException(String.format("Instance with ID '%s' does not exist.", instanceID));
            }
            InstanceStatus instanceStatus = this.allInstanceStatus.get(instanceID);
            return instanceStatus;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public void updateInstanceStatus(InstanceStatus instanceStatus) throws DataSourceException {
        this.lock.writeLock().lock();
        try {
            if (!this.allInstanceStatus.containsKey(instanceStatus.getInstanceID())) {
                throw new IllegalArgumentException(String.format("Instance with ID '%s' does not exist.", instanceStatus.getInstanceID()));
            }
            this.allInstanceStatus.put(instanceStatus.getInstanceID(), instanceStatus);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public int lockInstanceForChanging(UUID instanceID, QualifiedAgent lockingAgent) throws DataSourceException {
        int ret = 1;
        this.lock.writeLock().lock();
        try {
            if (this.instanceChangeLocks.containsKey(instanceID)) {
                ret = this.instanceChangeLockCount.get(instanceID);
                ++ret;
            }
            this.instanceChangeLocks.put(instanceID, lockingAgent);
            this.instanceChangeLockCount.put(instanceID, ret);
            int n = ret;
            return n;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public int unlockInstanceForChanging(UUID instanceID) throws DataSourceException {
        this.lock.writeLock().lock();
        try {
            int ret = this.instanceChangeLockCount.get(instanceID);
            if (--ret > 0) {
                this.instanceChangeLockCount.put(instanceID, ret);
            } else {
                this.instanceChangeLockCount.remove(instanceID);
                this.instanceChangeLocks.remove(instanceID);
            }
            int n = ret;
            return n;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public Map<UUID, QualifiedAgent> getChangeLocks() throws DataSourceException {
        this.lock.readLock().lock();
        try {
            HashMap<UUID, QualifiedAgent> result;
            HashMap<UUID, QualifiedAgent> hashMap = result = new HashMap<UUID, QualifiedAgent>(this.instanceChangeLocks);
            return hashMap;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public UUID getBaseTemplateID(UUID templateID) throws DataSourceException {
        if (!this.baseTemplateIDs.containsKey(templateID)) {
            return null;
        }
        return this.baseTemplateIDs.get(templateID);
    }
}

