/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.core.processmanager.xmlfileprocessmanager;

import de.aristaflow.adept2.base.configuration.AbortServiceException;
import de.aristaflow.adept2.base.service.InternalServiceException;
import de.aristaflow.adept2.base.service.Registry;
import de.aristaflow.adept2.core.checks.processmodel.ProcessTemplateCheck;
import de.aristaflow.adept2.core.processmanager.abstractimplementation.AbstractProcessManager;
import de.aristaflow.adept2.core.processmanager.storage.cachingstorage.CachingStorage;
import de.aristaflow.adept2.core.processmanager.storage.simplexmlstorage.SimpleXMLStorage;
import de.aristaflow.adept2.model.processmodel.Template;
import de.aristaflow.adept2.util.DataSourceException;
import java.net.URI;
import org.apache.commons.configuration.Configuration;

public class XMLFileProcessManager
extends AbstractProcessManager {
    protected final Configuration configuration;

    public XMLFileProcessManager(Configuration configuration, Registry registry) {
        super(configuration, registry);
        this.configuration = configuration;
    }

    @Override
    public void init(URI[] exportedURIs) throws AbortServiceException {
        long start = System.nanoTime();
        super.init(exportedURIs);
        ProcessTemplateCheck[] checks = this.getChecks(this.sessionFactory.getSessionToken(exportedURIs), new Template[0]);
        SimpleXMLStorage pms = new SimpleXMLStorage(this.configuration, this.registry, this.sessionFactory, exportedURIs);
        this.templateStorage = pms.getTemplateStorage();
        this.instanceStorage = pms.getInstanceStorage();
        if (this.CACHE_SIZE > 0) {
            CachingStorage cachingStorage = new CachingStorage(this.templateStorage, this.instanceStorage, this.CACHE_SIZE);
            this.templateStorage = cachingStorage.getTemplateStorage();
            this.instanceStorage = cachingStorage.getInstanceStorage();
        }
        pms.setTemplateStorage(this.templateStorage);
        pms.init(checks, this.SKIP_CHECKS);
        try {
            this.templateUpdateLocks = this.templateStorage.getUpdateLocks();
            this.instanceChangeLocks = this.instanceStorage.getChangeLocks();
        }
        catch (DataSourceException dse) {
            throw new InternalServiceException("Failed to restore the persistent locks from the storage.", dse);
        }
        String msg = String.format("The initialisation of the XMLFileProcessManager needed %,d nano seconds", System.nanoTime() - start);
        this.logger.fine(msg);
    }
}

