/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.core.processrepository.abstractimplementation;

import de.aristaflow.adept2.base.configuration.AbortServiceException;
import de.aristaflow.adept2.base.configuration.ConfigurationDescription;
import de.aristaflow.adept2.base.configuration.Property;
import de.aristaflow.adept2.base.security.AuthenticationException;
import de.aristaflow.adept2.base.service.AbstractADEPT2Service;
import de.aristaflow.adept2.base.service.InternalServiceException;
import de.aristaflow.adept2.base.service.Registry;
import de.aristaflow.adept2.base.service.ServiceAccessControlException;
import de.aristaflow.adept2.base.service.ServiceNotKnownException;
import de.aristaflow.adept2.base.sessionmanagement.QualifiedAgent;
import de.aristaflow.adept2.base.sessionmanagement.SecurityTokenIntegrityException;
import de.aristaflow.adept2.base.sessionmanagement.SessionToken;
import de.aristaflow.adept2.core.orgmodelmanager.OrgModelManager;
import de.aristaflow.adept2.core.processrepository.DataTypeManager;
import de.aristaflow.adept2.core.processrepository.ProcessRepository;
import de.aristaflow.adept2.core.processrepository.ProcessTemplateManager;
import de.aristaflow.adept2.core.processrepository.abstractimplementation.DefaultProcessTemplateManager;
import de.aristaflow.adept2.core.processrepository.storage.DataTypeStorage;
import de.aristaflow.adept2.core.processrepository.storage.ProcessTemplateStorage;
import de.aristaflow.adept2.core.processrepository.storage.ProcessTypeStorage;
import de.aristaflow.adept2.model.filter.AttributeFactory;
import de.aristaflow.adept2.model.filter.ComparisonFilter;
import de.aristaflow.adept2.model.filter.ComparisonOperator;
import de.aristaflow.adept2.model.filter.ContainsFilter;
import de.aristaflow.adept2.model.filter.FilterFactory;
import de.aristaflow.adept2.model.globals.ProcessConstants;
import de.aristaflow.adept2.model.processmodel.Activity;
import de.aristaflow.adept2.model.processmodel.ChangeableTemplate;
import de.aristaflow.adept2.model.processmodel.ProcessModelFactory;
import de.aristaflow.adept2.model.processmodel.ProcessType;
import de.aristaflow.adept2.model.processmodel.ReferencedProcess;
import de.aristaflow.adept2.model.processmodel.Template;
import de.aristaflow.adept2.model.processmodel.TemplateProxy;
import de.aristaflow.adept2.model.processmodel.TemplateStatus;
import de.aristaflow.adept2.util.DataSourceException;
import java.net.URI;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.logging.Level;
import org.apache.commons.configuration.Configuration;

@ConfigurationDescription(properties={@Property(name="UniqueName", isRequired=true, description="The unique repository name."), @Property(name="CacheSize", type=Property.Type.LONG, defaultValue="250", description="Specifies the size for the cache to use. If this value is 0 or less, no caching will be used. Whether caching applies and how the size is used(for instance the size specifies the whole cache or the size per cached object type) depends on the used storage implementation.")})
public abstract class AbstractProcessRepository
extends AbstractADEPT2Service
implements ProcessRepository {
    protected static final String MSG_DATA_SOURCE = "Data source exception while %s.";
    public static final String CFG_UNIQUE_NAME = "UniqueName";
    public static final String CONF_CACHE_SIZE = "CacheSize";
    protected final long CACHE_SIZE;
    protected DataTypeManager dataTypeManager;
    protected DefaultProcessTemplateManager processTemplateManager;
    protected final String uniqueName;
    protected ProcessModelFactory pmf;
    protected Configuration configuration;

    protected AbstractProcessRepository(Configuration configuration, Registry registry) {
        super(configuration, registry, new String[]{"OrgModelManager", "ProcessChecks"}, new String[0]);
        this.CACHE_SIZE = configuration.getLong(CONF_CACHE_SIZE);
        this.uniqueName = configuration.getString(CFG_UNIQUE_NAME);
        this.configuration = configuration;
    }

    @Override
    public void init(URI[] myURIs) throws AbortServiceException {
        super.init(myURIs);
        try {
            this.sessionFactory = this.registry.getSecurityManager().authenticatePrivileged(-2L, -2L, "password");
        }
        catch (AuthenticationException ae) {
            throw new InternalServiceException("Failed to authenticate at the security manager due to wrongauthentication data. Check the configuration of this ProcessRepository.", ae);
        }
        catch (DataSourceException dse) {
            throw new InternalServiceException("Failed to authenticate at the security manager due to unavailability of the data.", dse);
        }
        this.pmf = this.registry.getModelFactory("ProcessModelFactory", ProcessModelFactory.class);
        OrgModelManager omm = this.registry.getServiceOfType(this.sessionFactory.getSessionToken(myURIs), "OrgModelManager", OrgModelManager.class);
        this.processTemplateManager = new DefaultProcessTemplateManager(this.registry, this.getSessionFactory(), this, omm);
        this.processTemplateManager.init();
    }

    @Override
    public void start() throws AbortServiceException {
        this.processTemplateManager.start();
        super.start();
        super.signalStart();
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.processTemplateManager.shutdown();
    }

    @Override
    public void emergencyShutdown() {
        super.emergencyShutdown();
        this.processTemplateManager.emergencyShutdown();
    }

    protected abstract ProcessTypeStorage getTypeStorage();

    protected abstract DataTypeStorage getDataTypeStorage();

    protected abstract ProcessTemplateStorage getTemplateStorage();

    @Override
    public Set<ProcessType> getAllProcessTypes(SessionToken session) {
        super.sessionActive(session);
        try {
            Set<ProcessType> set = this.getTypeStorage().getAllProcessTypes();
            return set;
        }
        catch (DataSourceException e) {
            String message = String.format(MSG_DATA_SOURCE, "retrieving all types");
            this.logger.log(Level.SEVERE, message, e);
            throw new InternalServiceException(message, e);
        }
        finally {
            super.sessionFinished(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ProcessType createProcessType(SessionToken session, String newProcessType) {
        super.sessionActive(session);
        try {
            ProcessType ret;
            UUID templateID;
            ChangeableTemplate rootTemplate;
            ProcessModelFactory processModelFactory = this.pmf;
            synchronized (processModelFactory) {
                this.pmf.setCreateChangeable(true);
                rootTemplate = (ChangeableTemplate)this.pmf.createNullTemplate(this.getAgentForSession(session));
                rootTemplate.setName(newProcessType);
                templateID = rootTemplate.getID();
                this.pmf.setCreateChangeable(false);
            }
            for (ProcessType type : this.getAllProcessTypes(session)) {
                if (!type.getName().equals(newProcessType)) continue;
                String msg = String.format("Cannot create process type '%s' since it already exists!", newProcessType);
                throw new IllegalArgumentException(msg);
            }
            this.getTemplateStorage().createTemplate(rootTemplate, this.getInitialStatus(templateID), null, newProcessType);
            ProcessType processType = ret = this.getTypeStorage().createProcessType(newProcessType, templateID);
            return processType;
        }
        catch (DataSourceException e) {
            String message = String.format(MSG_DATA_SOURCE, "creating a new process type");
            this.logger.log(Level.SEVERE, message, e);
            throw new InternalServiceException(message, e);
        }
        finally {
            super.sessionFinished(session);
        }
    }

    @Override
    public Set<TemplateProxy> findUsageOfActivityTemplate(SessionToken session, UUID activityTemplateVersionID) {
        FilterFactory filterFac;
        try {
            filterFac = this.registry.getModelFactory("FilterFactory", FilterFactory.class);
        }
        catch (ServiceNotKnownException snke) {
            String msg = "Could not retrieve filter factory for filtering process templates to find the usage of activity template '%s'. Aborting search.";
            throw new InternalServiceException(String.format(msg, activityTemplateVersionID), snke);
        }
        AttributeFactory afTempl = filterFac.createAttributeFactory(Template.class);
        AttributeFactory afNode = afTempl.getFactoryForCollectionAttribute("getNodes");
        afNode.goDownAndCast("getExecutableBusinessProcess", Activity.class);
        ComparisonFilter nodeFilter = filterFac.createComparisonFilter(afNode.selectAttribute("getActivityTemplateVersionID"), ComparisonOperator.EQUALS, activityTemplateVersionID);
        ContainsFilter templateFilter = filterFac.createContainsAnyFilter(afTempl.selectAttribute("getNodes"), nodeFilter);
        Map<Template, TemplateProxy> allTemplates = this.getAllAvailableTemplates(session);
        HashSet<TemplateProxy> ret = new HashSet<TemplateProxy>();
        for (Map.Entry<Template, TemplateProxy> entry : allTemplates.entrySet()) {
            if (!templateFilter.matches(entry.getKey())) continue;
            ret.add(entry.getValue());
        }
        return ret;
    }

    @Override
    public Set<TemplateProxy> findUsageOfProcessTemplate(SessionToken session, UUID processTemplateID) {
        FilterFactory filterFac;
        try {
            filterFac = this.registry.getModelFactory("FilterFactory", FilterFactory.class);
        }
        catch (ServiceNotKnownException snke) {
            String msg = "Could not retrieve filter factory for filtering process templates to find the usage of process template '%s'. Aborting search.";
            throw new InternalServiceException(String.format(msg, processTemplateID), snke);
        }
        AttributeFactory afTempl = filterFac.createAttributeFactory(Template.class);
        AttributeFactory afNode = afTempl.getFactoryForCollectionAttribute("getNodes");
        afNode.goDownAndCast("getExecutableBusinessProcess", ReferencedProcess.class);
        ComparisonFilter nodeFilter = filterFac.createComparisonFilter(afNode.selectAttribute("getTemplateID"), ComparisonOperator.EQUALS, processTemplateID);
        ContainsFilter templateFilter = filterFac.createContainsAnyFilter(afTempl.selectAttribute("getNodes"), nodeFilter);
        Map<Template, TemplateProxy> allTemplates = this.getAllAvailableTemplates(session);
        HashSet<TemplateProxy> ret = new HashSet<TemplateProxy>();
        for (Map.Entry<Template, TemplateProxy> entry : allTemplates.entrySet()) {
            if (!templateFilter.matches(entry.getKey())) continue;
            ret.add(entry.getValue());
        }
        return ret;
    }

    @Override
    public String getUniqueRepositoryName() {
        return this.uniqueName;
    }

    @Override
    public ProcessTemplateManager getTemplateManager() {
        return this.processTemplateManager;
    }

    @Override
    public DataTypeManager getDataTypeManager() {
        return this.dataTypeManager;
    }

    protected QualifiedAgent getAgentForSession(SessionToken session) {
        super.sessionActive(session);
        try {
            QualifiedAgent qualifiedAgent = this.sessionFactory.checkAndGetTopLevelAgent(session);
            return qualifiedAgent;
        }
        catch (SecurityTokenIntegrityException e) {
            throw new ServiceAccessControlException("The agent could not be retrieved from the session token!", e);
        }
        finally {
            super.sessionFinished(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected TemplateStatus getInitialStatus(UUID templateID) {
        boolean topLevelUsage = true;
        boolean derivable = false;
        String derivableComment = "";
        boolean tlOutdated = false;
        String tlOutdatedComment = "";
        boolean spOutdated = false;
        String spOutdatedComment = "";
        boolean tlInstantiable = false;
        String tlInstantiableComment = "";
        boolean spInstantiable = false;
        String spInstantiableComment = "";
        boolean tlInstancesMigratableTo = false;
        String tlInstancesMigratableComment = "";
        boolean spInstancesMigratableTo = false;
        String spInstancesMigratableComment = "";
        boolean tlInstancesChangeable = false;
        String tlInstancesChangeableComment = "";
        boolean spInstancesChangeable = false;
        String spInstancesChangeableComment = "";
        String starterRule = "Agent(username='supervisor')";
        ProcessModelFactory processModelFactory = this.pmf;
        synchronized (processModelFactory) {
            return this.pmf.createTemplateStatus(templateID, ProcessConstants.TemplateBuildtimeState.VALID, ProcessConstants.TemplateUsage.NO_SUBPROCESS, topLevelUsage, derivable, derivableComment, tlOutdated, tlOutdatedComment, spOutdated, spOutdatedComment, tlInstantiable, tlInstantiableComment, spInstantiable, spInstantiableComment, tlInstancesMigratableTo, tlInstancesMigratableComment, spInstancesMigratableTo, spInstancesMigratableComment, tlInstancesChangeable, tlInstancesChangeableComment, spInstancesChangeable, spInstancesChangeableComment, starterRule);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected TemplateStatus getValidStatus(TemplateStatus status) {
        ProcessModelFactory processModelFactory = this.pmf;
        synchronized (processModelFactory) {
            return this.pmf.createTemplateStatus(status.getTemplateID(), ProcessConstants.TemplateBuildtimeState.VALID, status.getUsageAsSubprocess(), status.isTopLevelUsable(), status.isDerivable(), status.getDerivableComment(), status.isOutdated(false), status.getOutdatedComment(false), status.isOutdated(true), status.getOutdatedComment(true), status.isInstantiable(false), status.getInstantiableComment(false), status.isInstantiable(true), status.getInstantiableComment(true), status.areInstancesMigratableTo(false), status.getInstancesMigratableToComment(false), status.areInstancesMigratableTo(true), status.getInstancesMigratableToComment(true), status.areInstancesChangeable(false), status.getInstancesChangeableComment(false), status.areInstancesChangeable(true), status.getInstancesChangeableComment(true), status.getStarterRule());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected TemplateStatus getReleaseStatus(TemplateStatus status) {
        ProcessModelFactory processModelFactory = this.pmf;
        synchronized (processModelFactory) {
            return this.pmf.createTemplateStatus(status.getTemplateID(), ProcessConstants.TemplateBuildtimeState.RELEASED, status.getUsageAsSubprocess(), status.isTopLevelUsable(), status.isDerivable(), status.getDerivableComment(), status.isOutdated(false), status.getOutdatedComment(false), status.isOutdated(true), status.getOutdatedComment(true), status.isInstantiable(false), status.getInstantiableComment(false), status.isInstantiable(true), status.getInstantiableComment(true), status.areInstancesMigratableTo(false), status.getInstancesMigratableToComment(false), status.areInstancesMigratableTo(true), status.getInstancesMigratableToComment(true), status.areInstancesChangeable(false), status.getInstancesChangeableComment(false), status.areInstancesChangeable(true), status.getInstancesChangeableComment(true), status.getStarterRule());
        }
    }

    protected Map<Template, TemplateProxy> getAllAvailableTemplates(SessionToken session) {
        HashMap<Template, TemplateProxy> ret = new HashMap<Template, TemplateProxy>();
        Set<ProcessType> processTypes = this.getAllProcessTypes(session);
        HashSet<TemplateProxy> templateProxies = new HashSet<TemplateProxy>();
        for (ProcessType processType : processTypes) {
            TemplateProxy current = processType.getRootTemplate();
            templateProxies.add(current);
            this.addChildren(session, current, templateProxies);
        }
        for (TemplateProxy templateProxy : templateProxies) {
            ret.put(this.getTemplateManager().getTemplate(session, templateProxy.getID()), templateProxy);
        }
        return ret;
    }

    private void addChildren(SessionToken session, TemplateProxy parent, Collection<TemplateProxy> templateProxies) {
        List<UUID> childTemplates = parent.getChildTemplateIDs();
        for (UUID childTemplate : childTemplates) {
            TemplateProxy current = this.getTemplateManager().getTemplateProxy(session, childTemplate);
            templateProxies.add(current);
            this.addChildren(session, current, templateProxies);
        }
    }
}

