/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.core.processrepository.abstractimplementation;

import de.aristaflow.adept2.base.service.ADEPT2ServiceException;
import de.aristaflow.adept2.base.service.AbstractSubService;
import de.aristaflow.adept2.base.service.InternalServiceException;
import de.aristaflow.adept2.base.service.Registry;
import de.aristaflow.adept2.base.service.ServiceAccessControlException;
import de.aristaflow.adept2.base.service.ServiceNotKnownException;
import de.aristaflow.adept2.base.sessionmanagement.QualifiedAgent;
import de.aristaflow.adept2.base.sessionmanagement.SecurityTokenIntegrityException;
import de.aristaflow.adept2.base.sessionmanagement.SessionFactory;
import de.aristaflow.adept2.base.sessionmanagement.SessionToken;
import de.aristaflow.adept2.core.checks.processmodel.ProcessCheckService;
import de.aristaflow.adept2.core.checks.processmodel.ProcessTemplateCheck;
import de.aristaflow.adept2.core.orgmodelmanager.OrgModelManager;
import de.aristaflow.adept2.core.processmanager.ProcessManager;
import de.aristaflow.adept2.core.processmanager.TemplateManager;
import de.aristaflow.adept2.core.processrepository.ProcessTemplateManager;
import de.aristaflow.adept2.core.processrepository.abstractimplementation.AbstractProcessRepository;
import de.aristaflow.adept2.model.globals.ProcessConstants;
import de.aristaflow.adept2.model.processmodel.ChangeableTemplate;
import de.aristaflow.adept2.model.processmodel.EmbeddedProcess;
import de.aristaflow.adept2.model.processmodel.ExecutableBusinessProcess;
import de.aristaflow.adept2.model.processmodel.InvalidTemplateStateException;
import de.aristaflow.adept2.model.processmodel.Node;
import de.aristaflow.adept2.model.processmodel.ReferencedProcess;
import de.aristaflow.adept2.model.processmodel.Template;
import de.aristaflow.adept2.model.processmodel.TemplateDeltaLayer;
import de.aristaflow.adept2.model.processmodel.TemplateProxy;
import de.aristaflow.adept2.model.processmodel.TemplateStatus;
import de.aristaflow.adept2.model.processmodel.VariableParallelismEBP;
import de.aristaflow.adept2.model.processmodel.tools.NodeRelations;
import de.aristaflow.adept2.util.ArgChecks;
import de.aristaflow.adept2.util.CheckReport;
import de.aristaflow.adept2.util.DataSourceException;
import de.aristaflow.adept2.util.LockException;
import de.aristaflow.adept2.util.UUIDTools;
import de.aristaflow.adept2.util.locking.AcquireLockException;
import de.aristaflow.adept2.util.locking.ReleaseLockException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.logging.Level;
import org.w3c.dom.Document;

public class DefaultProcessTemplateManager
extends AbstractSubService
implements ProcessTemplateManager {
    protected final Registry registry;
    protected SessionFactory sessionFactory;
    protected final AbstractProcessRepository repository;
    protected OrgModelManager omm;
    protected final Object intermediateTemplateLock;
    protected Map<UUID, QualifiedAgent> templateLocks;

    protected DefaultProcessTemplateManager(Registry registry, SessionFactory sessionFactory, AbstractProcessRepository repository, OrgModelManager omm) {
        super(repository);
        this.registry = registry;
        this.sessionFactory = sessionFactory;
        this.repository = repository;
        this.omm = omm;
        this.intermediateTemplateLock = new Object();
    }

    @Override
    public void start() {
        try {
            this.templateLocks = this.repository.getTemplateStorage().getTemplateLocks();
        }
        catch (DataSourceException dse) {
            throw new InternalServiceException("Failed to restore the persistent locks from the storage.", dse);
        }
    }

    @Override
    public TemplateProxy getTemplateProxy(SessionToken session, UUID templateID) {
        super.sessionActive(session);
        try {
            TemplateProxy templateProxy = this.repository.getTemplateStorage().getTemplateProxy(templateID);
            return templateProxy;
        }
        catch (DataSourceException dse) {
            String msg = String.format("Failed when accessing the template storage for retrieval of template proxy for %s.", templateID);
            this.logger.severe(msg);
            throw new InternalServiceException(msg, dse);
        }
        finally {
            super.sessionFinished(session);
        }
    }

    @Override
    public Template getTemplate(SessionToken session, UUID templateID) {
        super.sessionActive(session);
        try {
            Template template = this.repository.getTemplateStorage().getTemplate(templateID);
            return template;
        }
        catch (DataSourceException dse) {
            String msg = String.format("Failed when accessing the template storage for retrieval of template %s.", templateID);
            this.logger.severe(msg);
            throw new InternalServiceException(msg, dse);
        }
        finally {
            super.sessionFinished(session);
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public ChangeableTemplate getAndLockTemplate(SessionToken session, UUID templateID) throws InvalidTemplateStateException, LockException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [5[CATCHBLOCK]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public CheckReport storeTemplate(SessionToken session, Template newProcessTemplate, boolean checkValidity, Document history, TemplateDeltaLayer structuralChanges) throws ReleaseLockException {
        super.sessionActive(session);
        try {
            if (!this.hasTemplateLock(session, newProcessTemplate.getID())) {
                throw new ReleaseLockException((Object)newProcessTemplate.getID(), false, (Object)session, "TemplateLock");
            }
            boolean valid = false;
            CheckReport ret = null;
            if (checkValidity) {
                URI base = this.getURIs()[0];
                ret = new CheckReport(base);
                valid = this.checkProcessTemplate(newProcessTemplate, ret);
            }
            this.repository.getTemplateStorage().updateTemplate(newProcessTemplate, history, structuralChanges, valid ? ProcessConstants.TemplateBuildtimeState.VALID : ProcessConstants.TemplateBuildtimeState.IN_CONSTRUCTION);
            CheckReport checkReport = ret;
            return checkReport;
        }
        catch (ServiceNotKnownException snke) {
            String msg = String.format("Could not retrieve the check service for checking template '%s'. Cannot store an unchecked template.", newProcessTemplate.getID());
            this.logger.severe(msg);
            throw new InternalServiceException(msg, snke);
        }
        catch (DataSourceException dse) {
            String msg = String.format("Failed when accessing the template storage for updating template '%s'.", newProcessTemplate.getID());
            this.logger.severe(msg);
            throw new InternalServiceException(msg, dse);
        }
        finally {
            super.sessionFinished(session);
        }
    }

    @Override
    public void unlockTemplate(SessionToken session, UUID templateID) throws LockException {
        super.sessionActive(session);
        try {
            this.internalUnlockTemplate(session, templateID);
        }
        finally {
            super.sessionFinished(session);
        }
    }

    @Override
    public CheckReport validateTemplate(SessionToken session, UUID templateID) throws LockException {
        super.sessionActive(session);
        try {
            TemplateStatus status;
            SessionToken subSession = this.sessionFactory.getChildSession(session, this.getURIs());
            Template template = this.getTemplate(subSession, templateID);
            URI base = this.getURIs()[0];
            CheckReport ret = new CheckReport(base);
            boolean valid = this.checkProcessTemplate(template, ret);
            if (valid && (status = this.getTemplateStatus(subSession = this.sessionFactory.getChildSession(session, this.getURIs()), templateID)).getBuildtimeState() == ProcessConstants.TemplateBuildtimeState.IN_CONSTRUCTION) {
                status = this.getAndLockTemplateStatus(subSession, templateID);
                try {
                    try {
                        subSession = this.sessionFactory.getChildSession(session, this.getURIs());
                        status = this.repository.getValidStatus(status);
                        this.setTemplateStatus(subSession, status);
                    }
                    catch (InvalidTemplateStateException invalidTemplateStateException) {
                        String msg = "InvalidTemplateStateException while saving the new generated template status!";
                        this.logger.severe(msg);
                        throw new RuntimeException(msg);
                    }
                }
                finally {
                    this.unlockTemplateStatus(session, templateID);
                }
            }
            CheckReport checkReport = ret;
            return checkReport;
        }
        catch (ServiceNotKnownException snke) {
            String msg = String.format("Could not retrieve the check service for validating template '%s'. Aborting validation.", templateID);
            this.logger.severe(msg);
            throw new InternalServiceException(msg, snke);
        }
        finally {
            super.sessionFinished(session);
        }
    }

    /*
     * Loose catch block
     */
    @Override
    public ChangeableTemplate deriveNewChildTemplate(SessionToken session, UUID parentTemplateID) throws InvalidTemplateStateException, LockException {
        super.sessionActive(session);
        try {
            this.lockTemplate(session, parentTemplateID);
            try {
                TemplateStatus parentStatus = this.repository.getTemplateStorage().getTemplateStatus(parentTemplateID);
                if (parentStatus.getBuildtimeState() != ProcessConstants.TemplateBuildtimeState.RELEASED) {
                    String msg = String.format("Cannot derive a child template from parent template %s since the parent is not yet released!", parentTemplateID);
                    throw new InvalidTemplateStateException(msg);
                }
                if (!parentStatus.isDerivable()) {
                    String msg = String.format("Cannot derive a child template from parent template %s since the parent is not derivable!", parentTemplateID);
                    throw new InvalidTemplateStateException(msg);
                }
                ChangeableTemplate ret = this.repository.getTemplateStorage().getChangeableTemplate(parentTemplateID);
                ret.updateID(UUIDTools.createPositiveUUID());
                TemplateStatus initialStatus = this.repository.getInitialStatus(ret.getID());
                this.repository.getTemplateStorage().createTemplate(ret, initialStatus, parentTemplateID, ret.getProcessType());
                try {
                    this.lockTemplate(session, ret.getID());
                }
                catch (AcquireLockException ale) {
                    String msg = String.format("Severe failure when acquiring lock for the newly created (child) template '%1$s'.", ret.getID());
                    this.logger.log(Level.SEVERE, msg, ale);
                    throw new InternalServiceException(msg, ale);
                }
                ChangeableTemplate changeableTemplate = this.repository.getTemplateStorage().getChangeableTemplate(ret.getID());
                return changeableTemplate;
            }
            catch (DataSourceException dse) {
                String msg = String.format("Failed when accessing the template storage for creating a new child template of parent template %s.", parentTemplateID);
                this.logger.severe(msg);
                throw new InternalServiceException(msg, dse);
            }
            finally {
                this.internalUnlockTemplate(session, parentTemplateID);
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            super.sessionFinished(session);
        }
    }

    @Override
    public void release(SessionToken session, UUID templateID) throws InvalidTemplateStateException, LockException {
        super.sessionActive(session);
        try {
            TemplateStatus status = this.getAndLockTemplateStatus(session, templateID);
            switch (status.getBuildtimeState()) {
                case VALID: {
                    break;
                }
                case RELEASED: {
                    String msg = String.format("Cannot release template %s since it is already released!", templateID);
                    throw new InvalidTemplateStateException(msg);
                }
                case IN_CONSTRUCTION: {
                    String msg = String.format("Cannot release template %s since it is not valid.", templateID);
                    throw new InvalidTemplateStateException(msg);
                }
            }
            this.getAndLockTemplate(session, templateID);
            try {
                TemplateStatus newStatus = this.repository.getReleaseStatus(status);
                this.setTemplateStatus(session, newStatus);
            }
            finally {
                this.unlockTemplate(session, templateID);
            }
        }
        finally {
            super.sessionFinished(session);
        }
    }

    @Override
    public void deployProcessTemplate(SessionToken session, UUID templateID, Set<URI[]> processManagerURIs) throws InvalidTemplateStateException, LockException {
        super.sessionActive(session);
        try {
            this.lockTemplate(session, templateID);
            try {
                try {
                    Template template = this.repository.getTemplateStorage().getTemplate(templateID);
                    TemplateStatus status = this.repository.getTemplateStorage().getTemplateStatus(templateID);
                    ArrayList<ProcessManager> processManagers = new ArrayList<ProcessManager>(processManagerURIs.size());
                    for (Object[] objectArray : processManagerURIs) {
                        try {
                            processManagers.add(this.registry.getService(session, (URI[])objectArray, ProcessManager.class));
                        }
                        catch (ServiceNotKnownException e) {
                            String msg = String.format("Caught a ServiceNotKnownException when trying to access the given process manager at '%s'.", Arrays.toString(objectArray));
                            throw new IllegalArgumentException(msg, e);
                        }
                        catch (ADEPT2ServiceException e) {
                            String msg = String.format("Caught an ADEPT2ServiceException when trying to access the given process manager at '%s'.", Arrays.toString(objectArray));
                            throw new IllegalArgumentException(msg, e);
                        }
                    }
                    Set<URI[]> set = this.repository.getTemplateStorage().getDeploymentProcessManagerURIs(templateID);
                    String msg = "";
                    for (ProcessManager processManager : processManagers) {
                        CheckReport checkReport = processManager.getTemplateManager().storeNewTemplate(session, template, status);
                        if (checkReport.getCheckResult() == CheckReport.ResultType.FAILURE) {
                            msg = String.valueOf(msg) + String.format("The process manager manager at '%s' declined the upload of the template. Check report:\n%s\n", Arrays.toString(processManager.getURIs()), checkReport.getReportSummary());
                            continue;
                        }
                        set.add(processManager.getURIs());
                    }
                    this.repository.getTemplateStorage().setDeploymentProcessManagerURIs(templateID, set);
                    if (!msg.equals("")) {
                        throw new InternalServiceException(msg);
                    }
                }
                catch (DataSourceException dse) {
                    String msg = String.format("Failed when accessing the template storage for storing deployed process manager URIs for template %s.", templateID);
                    this.logger.severe(msg);
                    throw new InternalServiceException(msg, dse);
                }
            }
            finally {
                this.internalUnlockTemplate(session, templateID);
            }
        }
        finally {
            super.sessionFinished(session);
        }
    }

    @Override
    public TemplateStatus getTemplateStatus(SessionToken session, UUID templateID) {
        super.sessionActive(session);
        try {
            TemplateStatus templateStatus = this.repository.getTemplateStorage().getTemplateStatus(templateID);
            return templateStatus;
        }
        catch (DataSourceException dse) {
            String msg = String.format("Failed when accessing the template storage for retrieving the template status of '%s'.", templateID);
            this.logger.severe(msg);
            throw new InternalServiceException(msg, dse);
        }
        finally {
            super.sessionFinished(session);
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public TemplateStatus getAndLockTemplateStatus(SessionToken session, UUID templateID) throws AcquireLockException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [5[CATCHBLOCK]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private boolean findTemplatesReferencingRecursive(SessionToken session, Template template, UUID referencedTemplateID, boolean topRefs, boolean subRefs) {
        boolean subOutdated;
        TemplateStatus status = this.repository.getTemplateManager().getTemplateStatus(session, template.getID());
        boolean topOutdated = !status.isTopLevelUsable() || status.isOutdated(false);
        boolean bl = subOutdated = status.getUsageAsSubprocess() == ProcessConstants.TemplateUsage.NO_SUBPROCESS || status.isOutdated(true);
        if (!topOutdated || !subOutdated) {
            for (Node n : template.getNodes()) {
                boolean fork;
                ExecutableBusinessProcess ebp = n.getExecutableBusinessProcess();
                if (ebp instanceof VariableParallelismEBP) {
                    ebp = ((VariableParallelismEBP)ebp).getLightWeightProcess();
                }
                if (!(ebp instanceof EmbeddedProcess ? this.findTemplatesReferencingRecursive(session, ((EmbeddedProcess)ebp).getTemplate(), referencedTemplateID, topRefs, subRefs) : ebp instanceof ReferencedProcess && ((ReferencedProcess)ebp).getTemplateID().equals(referencedTemplateID) && ((fork = ((ReferencedProcess)ebp).fork()) && topRefs || !fork && subRefs))) continue;
                return true;
            }
        }
        return false;
    }

    private List<Template> findTemplatesReferencing(SessionToken session, UUID templateID, boolean topRefs, boolean subRefs) {
        Map<Template, TemplateProxy> templates = this.repository.getAllAvailableTemplates(session);
        ArrayList<Template> ret = new ArrayList<Template>();
        for (Template template : templates.keySet()) {
            if (!this.findTemplatesReferencingRecursive(session, template, templateID, topRefs, subRefs)) continue;
            ret.add(template);
        }
        return ret;
    }

    @Override
    public void setTemplateStatus(SessionToken session, TemplateStatus templateStatus) throws ReleaseLockException, InvalidTemplateStateException {
        super.sessionActive(session);
        try {
            try {
                List<Template> references;
                boolean topChanged;
                if (!this.hasTemplateLock(session, templateStatus.getTemplateID())) {
                    throw new ReleaseLockException((Object)templateStatus.getTemplateID(), false, (Object)session, "TemplateStatusLock");
                }
                TemplateStatus oldStatus = this.getTemplateStatus(session, templateStatus.getTemplateID());
                boolean usageChanged = (oldStatus.getUsageAsSubprocess() == ProcessConstants.TemplateUsage.AS_REFERENCE || oldStatus.getUsageAsSubprocess() == ProcessConstants.TemplateUsage.COPY_OR_REFERENCE) && templateStatus.getUsageAsSubprocess() != ProcessConstants.TemplateUsage.AS_REFERENCE && templateStatus.getUsageAsSubprocess() != ProcessConstants.TemplateUsage.COPY_OR_REFERENCE;
                boolean topUsageChanged = oldStatus.isTopLevelUsable() && !templateStatus.isTopLevelUsable();
                boolean outdatedChanged = !oldStatus.isOutdated(true) && templateStatus.isOutdated(true);
                boolean topOutdatedChanged = !oldStatus.isOutdated(false) && templateStatus.isOutdated(false);
                boolean instantiableChanged = oldStatus.isInstantiable(true) && !templateStatus.isInstantiable(true);
                boolean topInstantiableChanged = oldStatus.isInstantiable(false) && !templateStatus.isInstantiable(false);
                boolean subChanged = usageChanged || outdatedChanged || instantiableChanged;
                boolean bl = topChanged = topUsageChanged || topOutdatedChanged || topInstantiableChanged;
                if ((subChanged || topChanged) && (references = this.findTemplatesReferencing(session, templateStatus.getTemplateID(), topChanged, subChanged)).size() > 0) {
                    StringBuilder msg = new StringBuilder();
                    boolean first = true;
                    for (Template template : references) {
                        if (!first) {
                            msg.append("\n");
                        }
                        msg.append("- ");
                        msg.append(template.getName());
                        msg.append(" v");
                        if (template.getVersion().length() > 0) {
                            msg.append(template.getVersion());
                        } else {
                            msg.append("0");
                        }
                        msg.append(" [");
                        msg.append(template.getID());
                        msg.append("]");
                        first = false;
                    }
                    String message = String.format("The template status of template %s may not be changed in this manner because the template is referenced by other templates:\n%s", templateStatus.getTemplateID(), msg.toString());
                    throw new InvalidTemplateStateException(message);
                }
                this.repository.getTemplateStorage().updateTemplateStatus(templateStatus);
                TemplateStatus newStatus = this.getTemplateStatus(session, templateStatus.getTemplateID());
                this.notifyProcessManagers(session, newStatus);
            }
            catch (DataSourceException dse) {
                String msg = String.format("Failed when accessing the template storage for updating template status of '%1$s'.", templateStatus.getTemplateID());
                this.logger.severe(msg);
                throw new InternalServiceException(msg, dse);
            }
        }
        finally {
            super.sessionFinished(session);
        }
    }

    @Override
    public void setAndUnlockTemplateStatus(SessionToken session, TemplateStatus templateStatus) throws ReleaseLockException, InvalidTemplateStateException {
        ArgChecks.checkForNull(session, "session");
        ArgChecks.checkForNull(templateStatus, "templateStatus");
        super.sessionActive(session);
        try {
            this.setTemplateStatus(session, templateStatus);
            this.internalUnlockTemplate(session, templateStatus.getTemplateID());
        }
        finally {
            super.sessionFinished(session);
        }
    }

    @Override
    public void unlockTemplateStatus(SessionToken session, UUID templateID) throws ReleaseLockException {
        super.sessionActive(session);
        try {
            this.internalUnlockTemplate(session, templateID);
        }
        finally {
            super.sessionFinished(session);
        }
    }

    @Override
    public TemplateDeltaLayer retrieveTemplateDeltaLayer(SessionToken session, UUID processTemplateID) {
        throw new UnsupportedOperationException("Not yet implemented!");
    }

    @Override
    public TemplateDeltaLayer retrieveTemplateDeltaLayer(SessionToken session, UUID processTemplateID, UUID ancestorTemplateID) {
        throw new UnsupportedOperationException("Not yet implemented!");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void lockTemplate(SessionToken session, UUID templateID) throws AcquireLockException {
        super.sessionActive(session);
        try {
            try {
                Object object = this.intermediateTemplateLock;
                synchronized (object) {
                    QualifiedAgent requestingAgent = this.sessionFactory.checkAndGetTopLevelAgent(session);
                    if (this.templateLocks.containsKey(templateID) && !this.hasTemplateLock(session, templateID)) {
                        throw new AcquireLockException((Object)templateID, this.templateLocks.get(templateID), (Object)requestingAgent, "TemplateLock");
                    }
                    try {
                        this.repository.getTemplateStorage().lockTemplate(templateID, requestingAgent);
                        this.templateLocks.put(templateID, requestingAgent);
                        String msg = String.format("Template '%1$s' locked for '%2$s'.", templateID, requestingAgent);
                        this.logger.fine(msg);
                    }
                    catch (DataSourceException dse) {
                        String msg = String.format("Failed to lock template '%1$s' for '%2$s'.", templateID, requestingAgent);
                        this.logger.severe(msg);
                        throw new InternalServiceException(msg, dse);
                    }
                }
            }
            catch (SecurityTokenIntegrityException stie) {
                String msg = String.format("Failed to verify the session token when locking template '%1$s'.", templateID);
                this.logger.severe(msg);
                throw new ServiceAccessControlException(msg, stie);
            }
        }
        finally {
            super.sessionFinished(session);
        }
    }

    /*
     * Exception decompiling
     */
    protected boolean hasTemplateLock(SessionToken session, UUID templateID) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 5[MONITOR]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void internalUnlockTemplate(SessionToken session, UUID templateID) throws ReleaseLockException {
        super.sessionActive(session);
        try {
            try {
                Object object = this.intermediateTemplateLock;
                synchronized (object) {
                    if (!this.templateLocks.containsKey(templateID)) {
                        String msg = String.format("Template '%1$s' has no lock, unlocking impossible.", templateID);
                        this.logger.severe(msg);
                        throw new ReleaseLockException((Object)templateID, false, (Object)session, "TemplateLock");
                    }
                    QualifiedAgent lockingAgent = this.templateLocks.get(templateID);
                    QualifiedAgent requestingAgent = this.sessionFactory.checkAndGetTopLevelAgent(session);
                    if (!requestingAgent.equals(lockingAgent)) {
                        String msg = String.format("'1%s' has not locked template '%2$s'. Refusing unlock.", requestingAgent, templateID);
                        this.logger.severe(msg);
                        throw new ReleaseLockException((Object)templateID, lockingAgent, (Object)session, "TemplateLock");
                    }
                    try {
                        int locksRemaining = this.repository.getTemplateStorage().unlockTemplate(templateID);
                        if (locksRemaining == 0) {
                            this.templateLocks.remove(templateID);
                        }
                        String msg = String.format("Template '%s' unlocked for '%s'. New LockCount %s.", templateID, requestingAgent, locksRemaining);
                        this.logger.fine(msg);
                    }
                    catch (DataSourceException dse) {
                        String msg = String.format("Failed to unlock template '%1$s' for '%2$s'.", templateID, requestingAgent);
                        this.logger.severe(msg);
                        throw new InternalServiceException(msg, dse);
                    }
                }
            }
            catch (SecurityTokenIntegrityException stie) {
                String msg = String.format("Failed to verify the session token when unlocking template '%1$s'.", templateID);
                this.logger.severe(msg);
                throw new ServiceAccessControlException(msg, stie);
            }
        }
        finally {
            super.sessionFinished(session);
        }
    }

    protected void notifyProcessManagers(SessionToken session, TemplateStatus newStatus) {
        ProcessManager[] processManagers = this.getProcessManagers(session, newStatus.getTemplateID());
        HashSet<URI[]> pmURIsToRemove = new HashSet<URI[]>();
        ProcessManager[] processManagerArray = processManagers;
        int n = processManagers.length;
        int n2 = 0;
        while (n2 < n) {
            block25: {
                ProcessManager processManager = processManagerArray[n2];
                if (processManager != null) {
                    String msg;
                    TemplateManager templateManager = processManager.getTemplateManager();
                    SessionToken subSession = this.sessionFactory.getChildSession(session, this.getURIs());
                    try {
                        templateManager.getAndLockTemplateStatus(subSession, newStatus.getTemplateID());
                        try {
                            templateManager.setTemplateStatus(subSession, newStatus);
                        }
                        catch (InvalidTemplateStateException e) {
                            msg = "Unable to notify process manager '%s' for status synchronisation, because new template status is invalid!";
                            msg = String.format(msg, Arrays.toString(processManager.getURIs()));
                            this.logger.log(Level.SEVERE, msg, e);
                            try {
                                templateManager.unlockTemplateStatus(subSession, newStatus.getTemplateID());
                            }
                            catch (LockException e2) {
                                msg = "Unable to unlock the template status, for template %s on process manager %s maybe locking it failed, before.";
                                msg = String.format(msg, newStatus.getTemplateID(), Arrays.toString(processManager.getURIs()));
                                this.logger.log(Level.INFO, msg, e2);
                            }
                            break block25;
                        }
                        catch (IllegalArgumentException e) {
                            try {
                                msg = "Unable to notify process manager '%s' for status synchronisation, because the template does not exist (any more). Will later try to remove the PM from the 'deployed process managers'.";
                                msg = String.format(msg, Arrays.toString(processManager.getURIs()));
                                this.logger.log(Level.INFO, msg, e);
                                pmURIsToRemove.add(processManager.getURIs());
                            }
                            catch (Throwable throwable) {
                                try {
                                    templateManager.unlockTemplateStatus(subSession, newStatus.getTemplateID());
                                }
                                catch (LockException e3) {
                                    msg = "Unable to unlock the template status, for template %s on process manager %s maybe locking it failed, before.";
                                    msg = String.format(msg, newStatus.getTemplateID(), Arrays.toString(processManager.getURIs()));
                                    this.logger.log(Level.INFO, msg, e3);
                                }
                                throw throwable;
                            }
                            try {
                                templateManager.unlockTemplateStatus(subSession, newStatus.getTemplateID());
                            }
                            catch (LockException e4) {
                                msg = "Unable to unlock the template status, for template %s on process manager %s maybe locking it failed, before.";
                                msg = String.format(msg, newStatus.getTemplateID(), Arrays.toString(processManager.getURIs()));
                                this.logger.log(Level.INFO, msg, e4);
                            }
                            break block25;
                        }
                        try {
                            templateManager.unlockTemplateStatus(subSession, newStatus.getTemplateID());
                        }
                        catch (LockException e) {
                            msg = "Unable to unlock the template status, for template %s on process manager %s maybe locking it failed, before.";
                            msg = String.format(msg, newStatus.getTemplateID(), Arrays.toString(processManager.getURIs()));
                            this.logger.log(Level.INFO, msg, e);
                        }
                    }
                    catch (LockException e) {
                        msg = "Unable to access process manager '%s' for status synchronisation.";
                        msg = String.format(msg, Arrays.toString(processManager.getURIs()));
                        this.logger.log(Level.SEVERE, msg, e);
                    }
                }
            }
            ++n2;
        }
        UUID templateID = newStatus.getTemplateID();
        HashSet<URI[]> serviceURIs = null;
        boolean somethingChanged = false;
        try {
            Set<URI[]> originalURIs = this.repository.getTemplateStorage().getDeploymentProcessManagerURIs(templateID);
            serviceURIs = new HashSet<URI[]>(originalURIs);
            Iterator i = serviceURIs.iterator();
            block19: while (i.hasNext()) {
                URI[] origURIs = (URI[])i.next();
                for (URI[] removeURIs : pmURIsToRemove) {
                    List<URI> removeURIList = Arrays.asList(removeURIs);
                    URI[] uRIArray = origURIs;
                    int n3 = origURIs.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        URI uri = uRIArray[n4];
                        if (removeURIList.contains(uri)) {
                            i.remove();
                            somethingChanged = true;
                            continue block19;
                        }
                        ++n4;
                    }
                }
            }
            if (somethingChanged) {
                this.repository.getTemplateStorage().setDeploymentProcessManagerURIs(templateID, serviceURIs);
            }
        }
        catch (DataSourceException e) {
            String message = String.format("Unable to store new 'deployed process manager URIs' after removing process managers from the list which do not know the template with ID %s any more! New set is: %s.", templateID, serviceURIs);
            this.logger.log(Level.SEVERE, message, e);
        }
    }

    protected ProcessManager[] getProcessManagers(SessionToken session, UUID templateID) {
        Set<URI[]> processManagerURIs;
        try {
            processManagerURIs = this.repository.getTemplateStorage().getDeploymentProcessManagerURIs(templateID);
        }
        catch (DataSourceException e) {
            String message = String.format("Unable to retrieve the PM service URIs for template '%s' from the storage.", templateID);
            this.logger.log(Level.SEVERE, message, e);
            throw new InternalServiceException(message, e);
        }
        ProcessManager[] processManagers = new ProcessManager[processManagerURIs.size()];
        int i = 0;
        for (Object[] objectArray : processManagerURIs) {
            String message;
            try {
                processManagers[i] = this.registry.getService(session, (URI[])objectArray, ProcessManager.class);
            }
            catch (ServiceNotKnownException e) {
                message = String.format("Unable to access process manager '%s' for status synchronisation.", Arrays.toString(objectArray));
                this.logger.log(Level.SEVERE, message, e);
            }
            catch (ADEPT2ServiceException e) {
                message = String.format("Unable to access process manager '%s' for status synchronisation", Arrays.toString(objectArray));
                this.logger.log(Level.SEVERE, message, e);
            }
            ++i;
        }
        return processManagers;
    }

    protected boolean checkProcessTemplate(Template template, CheckReport checkReport) throws ServiceNotKnownException {
        this.logger.fine("Running checks on the template with ID " + template.getID());
        ProcessTemplateCheck allChecks = this.registry.getServiceOfType(this.sessionFactory.getSessionToken(this.getURIs()), "ProcessChecks", ProcessCheckService.class).getExecutionProductionChecks();
        boolean allOK = allChecks.performCheck(template, new NodeRelations(template), checkReport);
        String message = String.format("Running the checks on the template with ID '%s' failed. Summary: %s", template.getID(), checkReport.getSimpleReportSummary());
        this.logger.info(message);
        return allOK;
    }
}

