/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.core.processrepository.storage.cachingstorage;

import de.aristaflow.adept2.base.sessionmanagement.QualifiedAgent;
import de.aristaflow.adept2.core.processmanager.TemplateStatusProvider;
import de.aristaflow.adept2.core.processrepository.storage.ProcessTemplateStorage;
import de.aristaflow.adept2.core.processrepository.storage.ProcessTypeStorage;
import de.aristaflow.adept2.model.globals.ProcessConstants;
import de.aristaflow.adept2.model.processmodel.ChangeableTemplate;
import de.aristaflow.adept2.model.processmodel.ProcessType;
import de.aristaflow.adept2.model.processmodel.Template;
import de.aristaflow.adept2.model.processmodel.TemplateDeltaLayer;
import de.aristaflow.adept2.model.processmodel.TemplateProxy;
import de.aristaflow.adept2.model.processmodel.TemplateReference;
import de.aristaflow.adept2.model.processmodel.TemplateStatus;
import de.aristaflow.adept2.util.Cache;
import de.aristaflow.adept2.util.DataSourceException;
import java.net.URI;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.w3c.dom.Document;

public class CachingProcessTemplateStorage
implements ProcessTemplateStorage,
ProcessTypeStorage,
TemplateStatusProvider {
    protected final ProcessTemplateStorage templateStorage;
    protected final ProcessTypeStorage typeStorage;
    protected final ReentrantReadWriteLock lock;
    protected final Map<UUID, Template> templateCache;
    protected final Map<UUID, TemplateStatus> templateStatusCache;
    protected final Map<UUID, TemplateReference> templateReferenceCache;
    protected final Map<UUID, TemplateProxy> templateProxyCache;
    protected final Map<UUID, Set<URI[]>> pmURICache;
    protected volatile Set<ProcessType> processTypeCache;

    public CachingProcessTemplateStorage(ProcessTemplateStorage templateStorage, ProcessTypeStorage typeStorage, long cacheSize) {
        this.templateStorage = templateStorage;
        this.typeStorage = typeStorage;
        this.lock = new ReentrantReadWriteLock();
        this.templateCache = Collections.synchronizedMap(new Cache(cacheSize));
        this.templateStatusCache = Collections.synchronizedMap(new Cache(cacheSize));
        this.templateReferenceCache = Collections.synchronizedMap(new Cache(cacheSize));
        this.templateProxyCache = Collections.synchronizedMap(new Cache(cacheSize));
        this.pmURICache = Collections.synchronizedMap(new Cache(cacheSize));
    }

    @Override
    public Template getTemplate(UUID templateID) throws DataSourceException {
        this.lock.readLock().lock();
        try {
            Template template = this.templateCache.get(templateID);
            if (template == null) {
                this.lock.readLock().unlock();
                this.lock.writeLock().lock();
                try {
                    template = this.templateCache.get(templateID);
                    if (template == null) {
                        template = this.templateStorage.getTemplate(templateID);
                        this.templateCache.put(templateID, template);
                    }
                }
                finally {
                    this.lock.readLock().lock();
                    this.lock.writeLock().unlock();
                }
            }
            Template template2 = template;
            return template2;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public ChangeableTemplate getChangeableTemplate(UUID templateID) throws DataSourceException {
        return this.templateStorage.getChangeableTemplate(templateID);
    }

    @Override
    public TemplateProxy getTemplateProxy(UUID templateID) throws DataSourceException {
        this.lock.readLock().lock();
        try {
            TemplateProxy proxy = this.templateProxyCache.get(templateID);
            if (proxy == null) {
                this.lock.readLock().unlock();
                this.lock.writeLock().lock();
                try {
                    proxy = this.templateProxyCache.get(templateID);
                    if (proxy == null) {
                        proxy = this.templateStorage.getTemplateProxy(templateID);
                        this.templateProxyCache.put(templateID, proxy);
                    }
                }
                finally {
                    this.lock.readLock().lock();
                    this.lock.writeLock().unlock();
                }
            }
            TemplateProxy templateProxy = proxy;
            return templateProxy;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public void createTemplate(Template template, TemplateStatus templateStatus, UUID parentTemplateID, String processType) throws DataSourceException {
        this.lock.writeLock().lock();
        try {
            this.templateStorage.createTemplate(template, templateStatus, parentTemplateID, processType);
            this.templateProxyCache.remove(parentTemplateID);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public TemplateStatus getTemplateStatus(UUID templateID) throws DataSourceException {
        this.lock.readLock().lock();
        try {
            TemplateStatus templateStatus = this.templateStatusCache.get(templateID);
            if (templateStatus == null) {
                this.lock.readLock().unlock();
                this.lock.writeLock().lock();
                try {
                    templateStatus = this.templateStatusCache.get(templateID);
                    if (templateStatus == null) {
                        templateStatus = this.templateStorage.getTemplateStatus(templateID);
                        this.templateStatusCache.put(templateID, templateStatus);
                    }
                }
                finally {
                    this.lock.readLock().lock();
                    this.lock.writeLock().unlock();
                }
            }
            TemplateStatus templateStatus2 = templateStatus;
            return templateStatus2;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public void updateTemplate(Template newProcessTemplate, Document history, TemplateDeltaLayer structuralChanges, ProcessConstants.TemplateBuildtimeState newState) throws DataSourceException {
        this.lock.writeLock().lock();
        try {
            this.templateStorage.updateTemplate(newProcessTemplate, history, structuralChanges, newState);
            UUID templateID = newProcessTemplate.getID();
            this.templateCache.remove(templateID);
            this.templateStatusCache.remove(templateID);
            this.templateReferenceCache.remove(templateID);
            this.templateProxyCache.remove(templateID);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public void updateTemplateStatus(TemplateStatus templateStatus) throws DataSourceException {
        this.lock.writeLock().lock();
        try {
            this.templateStorage.updateTemplateStatus(templateStatus);
            UUID templateID = templateStatus.getTemplateID();
            this.templateStatusCache.remove(templateID);
            this.templateReferenceCache.remove(templateID);
            this.templateProxyCache.remove(templateID);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public Set<URI[]> getDeploymentProcessManagerURIs(UUID templateID) throws DataSourceException {
        this.lock.readLock().lock();
        try {
            Set<URI[]> pmURIs = this.pmURICache.get(templateID);
            if (pmURIs == null) {
                this.lock.readLock().unlock();
                this.lock.writeLock().lock();
                try {
                    pmURIs = this.pmURICache.get(templateID);
                    if (pmURIs == null) {
                        pmURIs = this.templateStorage.getDeploymentProcessManagerURIs(templateID);
                        this.pmURICache.put(templateID, pmURIs);
                    }
                }
                finally {
                    this.lock.readLock().lock();
                    this.lock.writeLock().unlock();
                }
            }
            Set<URI[]> set = pmURIs;
            return set;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public void setDeploymentProcessManagerURIs(UUID templateID, Set<URI[]> serviceURIs) throws DataSourceException {
        this.lock.writeLock().lock();
        try {
            this.templateStorage.setDeploymentProcessManagerURIs(templateID, serviceURIs);
            this.pmURICache.remove(templateID);
            this.templateProxyCache.remove(templateID);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public int lockTemplate(UUID templateID, QualifiedAgent requestingAgent) throws DataSourceException {
        this.lock.writeLock().lock();
        try {
            this.templateProxyCache.remove(templateID);
            int n = this.templateStorage.lockTemplate(templateID, requestingAgent);
            return n;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public int unlockTemplate(UUID templateID) throws DataSourceException {
        this.lock.writeLock().lock();
        try {
            this.templateProxyCache.remove(templateID);
            int n = this.templateStorage.unlockTemplate(templateID);
            return n;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public Map<UUID, QualifiedAgent> getTemplateLocks() throws DataSourceException {
        return this.templateStorage.getTemplateLocks();
    }

    @Override
    public Set<ProcessType> getAllProcessTypes() throws DataSourceException {
        this.lock.readLock().lock();
        try {
            if (this.processTypeCache == null) {
                this.lock.readLock().unlock();
                this.lock.writeLock().lock();
                try {
                    if (this.processTypeCache == null) {
                        this.processTypeCache = Collections.unmodifiableSet(this.typeStorage.getAllProcessTypes());
                    }
                }
                finally {
                    this.lock.readLock().lock();
                    this.lock.writeLock().unlock();
                }
            }
            Set<ProcessType> set = this.processTypeCache;
            return set;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public ProcessType createProcessType(String newProcessType, UUID newTemplateID) throws DataSourceException {
        this.lock.writeLock().lock();
        try {
            ProcessType processType = this.typeStorage.createProcessType(newProcessType, newTemplateID);
            this.processTypeCache = null;
            ProcessType processType2 = processType;
            return processType2;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }
}

