/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.core.processrepository.storage.simplexmlstorage;

import de.aristaflow.adept2.base.configuration.AbortServiceException;
import de.aristaflow.adept2.base.configuration.ConfigurationException;
import de.aristaflow.adept2.base.service.InternalServiceException;
import de.aristaflow.adept2.base.service.Registry;
import de.aristaflow.adept2.base.service.ServiceNotKnownException;
import de.aristaflow.adept2.base.sessionmanagement.QualifiedAgent;
import de.aristaflow.adept2.base.sessionmanagement.SessionFactory;
import de.aristaflow.adept2.core.checks.processmodel.ProcessTemplateCheck;
import de.aristaflow.adept2.core.processmanager.TemplateStatusProvider;
import de.aristaflow.adept2.core.processmanager.storage.simplexmlstorage.SimpleXMLStorage;
import de.aristaflow.adept2.core.processrepository.abstractimplementation.RepositoryTemplateWrapper;
import de.aristaflow.adept2.core.processrepository.storage.ProcessTemplateStorage;
import de.aristaflow.adept2.core.processrepository.storage.ProcessTypeStorage;
import de.aristaflow.adept2.model.globals.ProcessConstants;
import de.aristaflow.adept2.model.processmodel.ChangeableTemplate;
import de.aristaflow.adept2.model.processmodel.ProcessModelFactory;
import de.aristaflow.adept2.model.processmodel.ProcessType;
import de.aristaflow.adept2.model.processmodel.Template;
import de.aristaflow.adept2.model.processmodel.TemplateDeltaLayer;
import de.aristaflow.adept2.model.processmodel.TemplateProxy;
import de.aristaflow.adept2.model.processmodel.TemplateReference;
import de.aristaflow.adept2.model.processmodel.TemplateStatus;
import de.aristaflow.adept2.model.processmodel.defaultimplementation.DefaultProcessType;
import de.aristaflow.adept2.model.processmodel.defaultimplementation.DefaultTemplateProxy;
import de.aristaflow.adept2.model.processmodel.tools.ProcessModelTools;
import de.aristaflow.adept2.model.processmodel.xml.ProcessModelXMLHelperTools;
import de.aristaflow.adept2.model.processmodel.xml.ProcessModelXMLImport;
import de.aristaflow.adept2.util.DataSourceException;
import de.aristaflow.adept2.util.xml.VersionException;
import de.aristaflow.adept2.util.xml.XMLFormatException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.logging.Level;
import org.apache.commons.configuration.Configuration;
import org.w3c.dom.Document;

public class XMLFileProcessTemplateStorage
extends SimpleXMLStorage
implements ProcessTemplateStorage,
ProcessTypeStorage,
TemplateStatusProvider {
    public static final String PROCESS_TYPE_FILE = "Types.data";
    public static final String TEMPLATE_INFORMATION_FILE = "Templates.data";

    public XMLFileProcessTemplateStorage(Configuration configuration, Registry registry, SessionFactory sessionFactory, URI[] processManagerURIs) throws ConfigurationException {
        super(configuration, registry, sessionFactory, processManagerURIs);
    }

    @Override
    public TemplateStatus getTemplateStatus(UUID templateID) throws DataSourceException {
        return super.getTemplateStatus(templateID);
    }

    @Override
    public ChangeableTemplate getChangeableTemplate(UUID templateID) throws DataSourceException {
        ProcessModelFactory pmf;
        try {
            pmf = this.registry.getModelFactory("ProcessModelFactory", ProcessModelFactory.class);
            pmf.setCreateChangeable(true);
        }
        catch (ServiceNotKnownException snke) {
            String msg = "Could not retrieve process model factory for creating the changeable template '%s'. Aborting retrieval of template.";
            throw new InternalServiceException(String.format(msg, templateID), snke);
        }
        Template ret = this.getTemplate(templateID, pmf);
        return (ChangeableTemplate)ProcessModelTools.cloneTemplate(ret, pmf);
    }

    @Override
    public TemplateProxy getTemplateProxy(UUID templateID) throws DataSourceException {
        this.lock.readLock().lock();
        try {
            TemplateReference tr = super.getTemplateReference(templateID, this);
            Map<UUID, ProcessModelXMLHelperTools.TemplateInformation> templateInformation = this.getTemplateInformation();
            UUID parent = null;
            ArrayList<UUID> children = null;
            HashSet<URI[]> deployedPMs = null;
            long creationTime = 0L;
            long modificationTime = 0L;
            String version = null;
            if (templateInformation.containsKey(templateID)) {
                parent = templateInformation.get((Object)templateID).parentTemplateID;
                children = templateInformation.get((Object)templateID).childTemplateIDs;
                deployedPMs = templateInformation.get((Object)templateID).deployedProcessManagers;
                creationTime = templateInformation.get((Object)templateID).creationTime;
                modificationTime = templateInformation.get((Object)templateID).modificationTime;
                version = templateInformation.get((Object)templateID).internalVersion;
            }
            QualifiedAgent lockingAgent = null;
            Map<UUID, QualifiedAgent> locks = this.getUpdateLocks();
            if (locks.containsKey(templateID)) {
                lockingAgent = locks.get(templateID);
            }
            DefaultTemplateProxy defaultTemplateProxy = new DefaultTemplateProxy(tr, parent, children, deployedPMs, creationTime, modificationTime, version, lockingAgent);
            return defaultTemplateProxy;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public void createTemplate(Template template, TemplateStatus templateStatus, UUID parentTemplateID, String processType) throws DataSourceException {
        this.lock.writeLock().lock();
        try {
            String internalVersion;
            if (parentTemplateID != null) {
                TemplateProxy parent = this.getTemplateProxy(parentTemplateID);
                String parentVersion = parent.getInternalVersion();
                int lastDot = parentVersion.lastIndexOf(46);
                if (parent.getChildTemplateIDs().size() == 0) {
                    String major = "";
                    if (lastDot > -1) {
                        major = parentVersion.substring(0, lastDot);
                    }
                    int minor = Integer.valueOf(parentVersion.substring(lastDot + 1, parentVersion.length()));
                    internalVersion = String.format("%s%s%d", major, lastDot == -1 ? "" : ".", ++minor);
                } else {
                    internalVersion = String.format("%s.%d.0", parentVersion, parent.getChildTemplateIDs().size() - 1);
                }
            } else {
                internalVersion = "1";
            }
            RepositoryTemplateWrapper newTemplate = new RepositoryTemplateWrapper(template, internalVersion, processType);
            super.createTemplate(newTemplate, templateStatus);
            ProcessModelXMLHelperTools.TemplateInformation information = new ProcessModelXMLHelperTools.TemplateInformation(parentTemplateID, System.currentTimeMillis(), System.currentTimeMillis(), internalVersion);
            Map<UUID, ProcessModelXMLHelperTools.TemplateInformation> templateInformation = this.getTemplateInformation();
            templateInformation.put(newTemplate.getID(), information);
            if (parentTemplateID != null) {
                information = templateInformation.get(parentTemplateID);
                information.childTemplateIDs.add(newTemplate.getID());
                templateInformation.put(parentTemplateID, information);
            }
            this.setTemplateInformations(templateInformation);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public void updateTemplate(Template newProcessTemplate, Document history, TemplateDeltaLayer structuralChanges, ProcessConstants.TemplateBuildtimeState newState) throws DataSourceException {
        this.lock.writeLock().lock();
        try {
            ProcessModelFactory pmf;
            File file = this.getTemplateFile(newProcessTemplate.getID());
            if (!file.exists()) {
                String message = String.format("Template with ID '%s' doesn't exist.", newProcessTemplate.getID());
                this.logger.log(Level.SEVERE, message);
                throw new IllegalArgumentException(message);
            }
            try {
                pmf = this.registry.getModelFactory("ProcessModelFactory", ProcessModelFactory.class);
                pmf.setCreateChangeable(false);
            }
            catch (ServiceNotKnownException snke) {
                String msg = "Could not retrieve process model factory for creating the status of template '%s'. Aborting updating of template (and its status).";
                throw new InternalServiceException(String.format(msg, newProcessTemplate.getID()), snke);
            }
            TemplateStatus oldStatus = this.getTemplateStatus(newProcessTemplate.getID(), pmf);
            TemplateStatus newStatus = ProcessModelTools.updateTemplateStatus(oldStatus, newState, pmf);
            Template oldTemplate = this.getTemplate(newProcessTemplate.getID());
            RepositoryTemplateWrapper myTemplate = new RepositoryTemplateWrapper(newProcessTemplate, oldTemplate.getVersion(), oldTemplate.getProcessType());
            this.writeTemplateAndStatusToFile(file, myTemplate, newStatus);
            Map<UUID, ProcessModelXMLHelperTools.TemplateInformation> templateInformation = this.getTemplateInformation();
            templateInformation.get((Object)myTemplate.getID()).modificationTime = System.currentTimeMillis();
            this.setTemplateInformations(templateInformation);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public Set<URI[]> getDeploymentProcessManagerURIs(UUID templateID) throws DataSourceException {
        this.lock.readLock().lock();
        try {
            Map<UUID, ProcessModelXMLHelperTools.TemplateInformation> templateInformation = this.getTemplateInformation();
            HashSet<Object> ret = templateInformation.containsKey(templateID) ? templateInformation.get((Object)templateID).deployedProcessManagers : new HashSet(0);
            HashSet<URI[]> hashSet = ret;
            return hashSet;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public void setDeploymentProcessManagerURIs(UUID templateID, Set<URI[]> serviceURIs) throws DataSourceException {
        this.lock.readLock().lock();
        try {
            Map<UUID, ProcessModelXMLHelperTools.TemplateInformation> templateInformation = this.getTemplateInformation();
            if (templateInformation.containsKey(templateID)) {
                ProcessModelXMLHelperTools.TemplateInformation currentInformation = templateInformation.get(templateID);
                currentInformation.deployedProcessManagers.clear();
                currentInformation.deployedProcessManagers.addAll(serviceURIs);
                templateInformation.put(templateID, currentInformation);
                this.setTemplateInformations(templateInformation);
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public int lockTemplate(UUID templateID, QualifiedAgent requestingAgent) throws DataSourceException {
        return this.lockTemplateForUpdates(templateID, requestingAgent);
    }

    @Override
    public int unlockTemplate(UUID templateID) throws DataSourceException {
        return this.unlockTemplateForUpdates(templateID);
    }

    @Override
    public Map<UUID, QualifiedAgent> getTemplateLocks() throws DataSourceException {
        return this.getUpdateLocks();
    }

    @Override
    public Set<ProcessType> getAllProcessTypes() throws DataSourceException {
        this.lock.readLock().lock();
        try {
            HashSet<ProcessType> res = new HashSet<ProcessType>();
            File file = new File(this.dataDir, PROCESS_TYPE_FILE);
            Set<ProcessModelXMLHelperTools.SerialisableProcessType> serialisable = !file.exists() ? new HashSet<ProcessModelXMLHelperTools.SerialisableProcessType>() : ProcessModelXMLImport.getProcessTypesFromFile(file);
            for (ProcessModelXMLHelperTools.SerialisableProcessType ser : serialisable) {
                res.add(new DefaultProcessType(ser.typeName, this.getTemplateProxy(ser.rootID)));
            }
            HashSet<ProcessType> hashSet = res;
            return hashSet;
        }
        catch (IOException e) {
            throw new DataSourceException("IOException while fetching base template mapping!", e);
        }
        catch (XMLFormatException e) {
            throw new DataSourceException("Encountered malformed XML of base template mapping", e);
        }
        catch (VersionException e) {
            throw new DataSourceException("Base template mapping file is out of date!", e);
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public ProcessType createProcessType(String newProcessType, UUID rootID) throws DataSourceException {
        this.lock.readLock().lock();
        try {
            File file = new File(this.dataDir, PROCESS_TYPE_FILE);
            Set<ProcessModelXMLHelperTools.SerialisableProcessType> serialisable = !file.exists() ? new HashSet<ProcessModelXMLHelperTools.SerialisableProcessType>() : ProcessModelXMLImport.getProcessTypesFromFile(file);
            serialisable.add(new ProcessModelXMLHelperTools.SerialisableProcessType(newProcessType, rootID));
            this.xmlExport.writeProcessTypesToFile(serialisable, file);
            DefaultProcessType defaultProcessType = new DefaultProcessType(newProcessType, this.getTemplateProxy(rootID));
            return defaultProcessType;
        }
        catch (FileNotFoundException e) {
            throw new DataSourceException("FileNotFoundException while adding ProcessType!", e);
        }
        catch (XMLFormatException e) {
            throw new DataSourceException("XMLFormatException while adding ProcessType!", e);
        }
        catch (IOException e) {
            throw new DataSourceException("IOException while adding ProcessType!", e);
        }
        catch (VersionException e) {
            throw new DataSourceException("Outdated XML version while adding ProcessType!", e);
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    protected void performInitChecks(String fileName, Template template, ProcessTemplateCheck[] checks) throws AbortServiceException {
        try {
            TemplateStatus status = this.getTemplateStatus(template.getID());
            if (status.getBuildtimeState() == ProcessConstants.TemplateBuildtimeState.VALID || status.getBuildtimeState() == ProcessConstants.TemplateBuildtimeState.RELEASED) {
                super.performInitChecks(fileName, template, checks);
            }
        }
        catch (DataSourceException e) {
            throw new AbortServiceException("Unable to receive status of file " + fileName, e);
        }
    }

    @Override
    protected void initAndCheckInstances() {
    }

    private Map<UUID, ProcessModelXMLHelperTools.TemplateInformation> getTemplateInformation() throws DataSourceException {
        try {
            File file = new File(this.dataDir, TEMPLATE_INFORMATION_FILE);
            Map<UUID, ProcessModelXMLHelperTools.TemplateInformation> res = !file.exists() ? new HashMap<UUID, ProcessModelXMLHelperTools.TemplateInformation>() : ProcessModelXMLImport.getTemplateInformationsFromFile(file);
            return res;
        }
        catch (IOException e) {
            throw new DataSourceException("IOException while fetching template informations!", e);
        }
        catch (XMLFormatException e) {
            throw new DataSourceException("Encountered malformed XML of template informations", e);
        }
        catch (VersionException e) {
            throw new DataSourceException("template informations file is out of date!", e);
        }
    }

    private void setTemplateInformations(Map<UUID, ProcessModelXMLHelperTools.TemplateInformation> mapping) throws DataSourceException {
        try {
            boolean success;
            File file = new File(this.dataDir, TEMPLATE_INFORMATION_FILE);
            if (!file.exists() && !(success = file.createNewFile())) {
                throw new DataSourceException("Problems while creating a new file for the template ID mapping");
            }
            this.xmlExport.writeTemplateInformationsToFile(mapping, file);
        }
        catch (IOException e) {
            throw new DataSourceException("IOException while writing base template ID mapping!", e);
        }
        catch (XMLFormatException e) {
            throw new DataSourceException("XMLFormatException while writing base template ID mapping", e);
        }
    }
}

