/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.core.processrepository.xmlfilerepository;

import de.aristaflow.adept2.base.configuration.AbortServiceException;
import de.aristaflow.adept2.base.service.Registry;
import de.aristaflow.adept2.core.processrepository.abstractimplementation.AbstractProcessRepository;
import de.aristaflow.adept2.core.processrepository.storage.DataTypeStorage;
import de.aristaflow.adept2.core.processrepository.storage.ProcessTemplateStorage;
import de.aristaflow.adept2.core.processrepository.storage.ProcessTypeStorage;
import de.aristaflow.adept2.core.processrepository.storage.cachingstorage.CachingProcessTemplateStorage;
import de.aristaflow.adept2.core.processrepository.storage.simplexmlstorage.XMLFileProcessTemplateStorage;
import java.net.URI;
import org.apache.commons.configuration.Configuration;

public class XMLFileProcessRepository
extends AbstractProcessRepository {
    private final Configuration configuration;
    private ProcessTemplateStorage templateStorage;
    private ProcessTypeStorage typeStorage;

    public XMLFileProcessRepository(Configuration configuration, Registry registry) {
        super(configuration, registry);
        this.configuration = configuration;
    }

    @Override
    public void init(URI[] myURIs) throws AbortServiceException {
        super.init(myURIs);
        XMLFileProcessTemplateStorage fileStorage = new XMLFileProcessTemplateStorage(this.configuration, this.registry, this.sessionFactory, myURIs);
        CachingProcessTemplateStorage storage = new CachingProcessTemplateStorage(fileStorage, fileStorage, this.CACHE_SIZE);
        fileStorage.init(myURIs);
        this.templateStorage = storage;
        this.typeStorage = storage;
    }

    @Override
    public DataTypeStorage getDataTypeStorage() {
        throw new UnsupportedOperationException("Not yet implemented!");
    }

    @Override
    public ProcessTemplateStorage getTemplateStorage() {
        return this.templateStorage;
    }

    @Override
    public ProcessTypeStorage getTypeStorage() {
        return this.typeStorage;
    }
}

