/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.core.registry;

import de.aristaflow.adept2.base.configuration.AbortServiceException;
import de.aristaflow.adept2.base.configuration.ConfigurationDescription;
import de.aristaflow.adept2.base.configuration.ConfigurationException;
import de.aristaflow.adept2.base.configuration.ConfigurationManager;
import de.aristaflow.adept2.base.configuration.Property;
import de.aristaflow.adept2.base.registry.BootstrapRegistry;
import de.aristaflow.adept2.base.registry.FileConfigurationManager;
import de.aristaflow.adept2.base.service.ServiceNotKnownException;
import de.aristaflow.adept2.core.orgmodelmanager.OrgModelManager;
import java.util.logging.Level;
import org.apache.commons.configuration.Configuration;

@ConfigurationDescription(properties={@Property(name="SecurityManager", type=Property.Type.STRING, defaultValue="OrgModelManager", description="The security manager (instance of organisational model manager) to use for authentication.")})
public final class ServerBootstrap
extends BootstrapRegistry {
    private static final String INSTANCE_NAME = "ServerBootstrapRegistry";

    protected ServerBootstrap() throws ConfigurationException {
        super(ServerBootstrap.getRootConfigurationManager().getRootConfiguration(), INSTANCE_NAME);
    }

    protected ServerBootstrap(Configuration rootConfiguration) throws ConfigurationException {
        super(rootConfiguration, INSTANCE_NAME);
    }

    public static ServerBootstrap load() throws AbortServiceException {
        ServerBootstrap ret = new ServerBootstrap();
        ret.bootstrap();
        return ret;
    }

    public static ServerBootstrap load(Configuration rootConfiguration) throws AbortServiceException {
        rootConfigurationManager = FileConfigurationManager.initialiseConfigurationManager(rootConfiguration);
        ServerBootstrap ret = new ServerBootstrap(rootConfigurationManager.getRootConfiguration());
        ret.bootstrap();
        return ret;
    }

    @Deprecated
    public static synchronized ServerBootstrap load(ConfigurationManager confMgr) throws AbortServiceException {
        if (rootConfigurationManager != confMgr) {
            String msg = "Cannot bootstrap with another configuration manager than the already created root configuration manager. Please provide the root configuration manager which is the first created configuration manager.";
            throw new AbortServiceException(msg);
        }
        ServerBootstrap ret = new ServerBootstrap();
        ret.bootstrap();
        return ret;
    }

    @Deprecated
    public static ConfigurationManager getConfigurationManager() throws ConfigurationException {
        return BootstrapRegistry.getRootConfigurationManager();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void terminate() {
        Class<BootstrapRegistry> clazz = BootstrapRegistry.class;
        synchronized (BootstrapRegistry.class) {
            if (bootstrapRegistry != null) {
                bootstrapRegistry.shutdown();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    @Override
    public void prepareSecurityManager() throws ServiceNotKnownException {
        String simpleServiceName = this.configuration.getString("SecurityManager");
        String securityManagerServiceName = ServerBootstrap.getHierarchicalInstanceName("OrgModelManager", simpleServiceName);
        try {
            this.securityManager = this.getService(this.sessionFactory.getSessionToken(this.getURIs()), securityManagerServiceName, OrgModelManager.class).getSecurityManager();
        }
        catch (ServiceNotKnownException snke) {
            String msg = "The security manager could not be prepared but it is crucial for running the server. Aborting start!";
            this.logger.log(Level.SEVERE, msg, snke);
            throw snke;
        }
    }
}

