/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.core.runtimemanager;

import de.aristaflow.adept2.core.runtimemanager.DoPrivileged;
import de.aristaflow.adept2.core.runtimemanager.URLClassLoader;
import de.aristaflow.adept2.model.runtimeenvironment.GUIContext;
import de.aristaflow.adept2.util.ArrayTools;
import java.net.URL;
import java.util.Arrays;

public class ComponentClassLoader
extends URLClassLoader {
    static final String statForbiddenPackage = "de.aristaflow";
    protected String[] forbiddenPackages;
    static final String[] statSharedAdeptPackages = new String[]{"de.aristaflow.adept2.model", "de.aristaflow.adept2.extensions.generatedforms", "de.aristaflow.adept2.extensions.generatedforms2", "de.aristaflow.adept2.extensions.testexecutionenvironment", "de.aristaflow.adept2.extensions.testexecutionenvironment2", "de.aristaflow.adept2.extensions.datatypes", "de.aristaflow.adept2.util"};
    protected String[] sharedAdeptPackages;
    static String[] statSharedAdeptClasses = new String[]{"de.aristaflow.adept2.base.sessionmanagement.ClientSessionFactory", "de.aristaflow.adept2.base.sessionmanagement.QualifiedAgent", "de.aristaflow.adept2.base.sessionmanagement.RichAgent", "de.aristaflow.adept2.base.sessionmanagement.SessionToken", "de.aristaflow.adept2.base.sessionmanagement.SignedSecurityToken", "de.aristaflow.adept2.base.sessionmanagement.SecurityTokenIntegrityException", "de.aristaflow.adept2.core.runtimemanager.executionenvironments.NullExecution", "de.aristaflow.adept2.core.runtimemanager.executionenvironments.ExecutionEnvironment"};
    protected String[] sharedAdeptClasses;
    protected static String[] statSharedAdeptClassesExceptions = new String[]{"de.aristaflow.adept2.model.runtimeenvironment.RuntimeEnvironmentFactory"};
    protected String[] sharedAdeptClassesExceptions;
    protected final ClassLoader adeptClassLoader;

    public ComponentClassLoader(URL[] urls, ClassLoader adeptLoader, String[] addForbiddenPackages, String[] addSharedPackages, String[] addSharedClasses, String[] addSharedClassesExceptions) {
        super(urls);
        this.adeptClassLoader = adeptLoader;
        this.logger.finer(String.format("Created a component classloader with classpath: '%s'.", Arrays.toString(urls)));
        this.forbiddenPackages = ArrayTools.join({statForbiddenPackage}, addForbiddenPackages);
        this.sharedAdeptPackages = ArrayTools.join(statSharedAdeptPackages, addSharedPackages);
        this.sharedAdeptClasses = ArrayTools.join(statSharedAdeptClasses, addSharedClasses);
        this.sharedAdeptClassesExceptions = ArrayTools.join(statSharedAdeptClassesExceptions, addSharedClassesExceptions);
    }

    @Override
    protected synchronized Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        String msg;
        ClassLoader loader;
        Class<?> c = this.findLoadedClass(name);
        if (c == null) {
            if (this.isSharedClass(name)) {
                try {
                    c = this.adeptClassLoader.loadClass(name);
                }
                catch (ClassNotFoundException classNotFoundException) {}
            }
            if (c != null) {
                loader = DoPrivileged.getClassLoader(c);
                if (loader == null) {
                    this.logger.finest(String.format("Class '%1$s' was loaded by the SystemClassLoader!", name));
                } else if (loader.equals(this.adeptClassLoader)) {
                    msg = String.format("Class '%1$s' was loaded directly by the ADEPT-ClassLoader '%2$s'.", name, loader);
                    this.logger.finer(msg);
                } else {
                    msg = String.format("Class '%1$s' was loaded by the ClassLoader '%2$s'.", name, loader);
                    this.logger.fine(msg);
                }
            }
        }
        if (c == null) {
            c = this.findClass(name);
            loader = DoPrivileged.getClassLoader(c);
            if (loader == null) {
                String loaderIsNullMessage = String.format("At this time of the loading process the Class '%1$s' must not be loaded by the system loader any more.", name);
                this.logger.severe(loaderIsNullMessage);
                assert (false) : loaderIsNullMessage;
            } else if (loader.equals(this)) {
                msg = String.format("Class '%1$s' was loaded directly by the  ComponentClassLoader '%2$s'.", name, loader);
                this.logger.fine(msg);
            } else {
                String loaderIsNotThisClassLoaderErrorMessage = String.format("Class '%s' shouldn't be loaded by the ClassLoader '%s'. Should be loaded with this one: %s", name, loader, this);
                this.logger.severe(loaderIsNotThisClassLoaderErrorMessage);
                assert (false) : loaderIsNotThisClassLoaderErrorMessage;
            }
        }
        if (resolve) {
            this.resolveClass(c);
        }
        return c;
    }

    protected boolean isSharedClass(String name) {
        boolean ret = true;
        boolean forbPack = false;
        String[] stringArray = this.forbiddenPackages;
        int n = this.forbiddenPackages.length;
        int n2 = 0;
        while (n2 < n) {
            String forbiddenPackage = stringArray[n2];
            if (name.startsWith(forbiddenPackage)) {
                forbPack = true;
                break;
            }
            ++n2;
        }
        if (forbPack) {
            ret = false;
            stringArray = this.sharedAdeptClasses;
            n = this.sharedAdeptClasses.length;
            n2 = 0;
            while (n2 < n) {
                String sharedClass = stringArray[n2];
                if (name.equals(sharedClass)) {
                    ret = true;
                    break;
                }
                ++n2;
            }
            if (!ret) {
                stringArray = this.sharedAdeptPackages;
                n = this.sharedAdeptPackages.length;
                n2 = 0;
                block4: while (n2 < n) {
                    String sharedPackage = stringArray[n2];
                    if (name.startsWith(sharedPackage)) {
                        String[] stringArray2 = this.sharedAdeptClassesExceptions;
                        int n3 = this.sharedAdeptClassesExceptions.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            String notSharedClass = stringArray2[n4];
                            if (name.equals(notSharedClass)) {
                                ret = false;
                                break block4;
                            }
                            ++n4;
                        }
                        ret = true;
                        break;
                    }
                    ++n2;
                }
            }
            if (!ret) {
                int index = name.indexOf(36);
                String tlClassName = name;
                if (index >= 0) {
                    tlClassName = name.substring(0, index);
                }
                try {
                    Class<?> c = this.adeptClassLoader.loadClass(tlClassName);
                    ret = GUIContext.class.isAssignableFrom(c);
                }
                catch (ClassNotFoundException classNotFoundException) {}
            }
        }
        return ret;
    }
}

