/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.core.runtimemanager;

import de.aristaflow.adept2.core.runtimemanager.ComponentClassLoader;
import de.aristaflow.adept2.core.runtimemanager.URLClassLoader;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;

public class DoPrivileged {
    public static ClassLoader getClassLoader(final Class<?> cls) {
        PrivilegedAction<ClassLoader> pa = new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                return cls.getClassLoader();
            }
        };
        return AccessController.doPrivileged(pa);
    }

    public static URLClassLoader getURLClassloader(URL[] urlClassPaths) {
        URLClassLoaderPrivilegedAction pa = new URLClassLoaderPrivilegedAction(urlClassPaths);
        return AccessController.doPrivileged(pa);
    }

    public static URLClassLoader getComponentClassloader(URL[] urlClassPaths, String[] forbiddenPackages, String[] sharedPackages, String[] sharedClasses, String[] sharedClassesExceptions) {
        ComponentClassLoaderPrivilegedAction pa = new ComponentClassLoaderPrivilegedAction(urlClassPaths, forbiddenPackages, sharedPackages, sharedClasses, sharedClassesExceptions);
        return AccessController.doPrivileged(pa);
    }

    private static class ComponentClassLoaderPrivilegedAction
    extends URLClassLoaderPrivilegedAction {
        protected final String[] addForbiddenPackages;
        protected final String[] addSharedPackages;
        protected final String[] addSharedClasses;
        protected final String[] addSharedClassesExceptions;

        ComponentClassLoaderPrivilegedAction(URL[] urlClassPaths, String[] forbiddenPackages, String[] sharedPackages, String[] sharedClasses, String[] sharedClassesExceptions) {
            super(urlClassPaths);
            this.addForbiddenPackages = forbiddenPackages;
            this.addSharedPackages = sharedPackages;
            this.addSharedClasses = sharedClasses;
            this.addSharedClassesExceptions = sharedClassesExceptions;
        }

        @Override
        public URLClassLoader run() {
            return new ComponentClassLoader(this.urlClassPaths, this.getClass().getClassLoader(), this.addForbiddenPackages, this.addSharedPackages, this.addSharedClasses, this.addSharedClassesExceptions);
        }
    }

    private static class URLClassLoaderPrivilegedAction
    implements PrivilegedAction<URLClassLoader> {
        protected final URL[] urlClassPaths;

        URLClassLoaderPrivilegedAction(URL[] urlClassPaths) {
            this.urlClassPaths = urlClassPaths;
        }

        @Override
        public URLClassLoader run() {
            return new URLClassLoader(this.urlClassPaths, this.getClass().getClassLoader());
        }
    }
}

