/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.core.runtimemanager;

import de.aristaflow.adept2.base.configuration.AbortServiceException;
import de.aristaflow.adept2.base.configuration.ConfigurationDescription;
import de.aristaflow.adept2.base.configuration.ConfigurationException;
import de.aristaflow.adept2.base.configuration.ConfigurationManager;
import de.aristaflow.adept2.base.configuration.IllegalConfigurationDescriptionException;
import de.aristaflow.adept2.base.configuration.Property;
import de.aristaflow.adept2.base.configuration.SystemProperties;
import de.aristaflow.adept2.base.registry.AbstractRegistry;
import de.aristaflow.adept2.base.service.AbstractADEPT2Service;
import de.aristaflow.adept2.base.service.Registry;
import de.aristaflow.adept2.base.service.ServiceNotKnownException;
import de.aristaflow.adept2.base.sessionmanagement.RichAgent;
import de.aristaflow.adept2.base.sessionmanagement.SessionToken;
import de.aristaflow.adept2.core.globalprovider.GlobalConfiguration;
import de.aristaflow.adept2.core.globalprovider.GlobalProvider;
import de.aristaflow.adept2.core.runtimemanager.DoPrivileged;
import de.aristaflow.adept2.core.runtimemanager.URLClassLoader;
import de.aristaflow.adept2.model.common.ActivityConfiguration;
import de.aristaflow.adept2.model.common.Configuration;
import de.aristaflow.adept2.model.common.ExecutionControlProperties;
import de.aristaflow.adept2.model.common.MergingConfiguration;
import de.aristaflow.adept2.model.common.i18n.LocalisationResolver;
import de.aristaflow.adept2.model.execution.ActivityInstance;
import de.aristaflow.adept2.model.execution.DecisionActivityInstance;
import de.aristaflow.adept2.model.execution.ExecutionFactory;
import de.aristaflow.adept2.model.globals.ActivityConstants;
import de.aristaflow.adept2.model.processmodel.DecisionStatement;
import de.aristaflow.adept2.model.runtimeenvironment.ExecutableComponent;
import de.aristaflow.adept2.util.locking.ReentrantLock;
import de.aristaflow.adept2.util.locking.ThreadLock;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.regex.Pattern;
import org.apache.commons.configuration.ConversionException;

@ConfigurationDescription(properties={@Property(name="LogActivityConfigurations", type=Property.Type.BOOLEAN, defaultValue="false", description="Whether to log the overriding activity configurations (default: false). They will be logged with FINE."), @Property(name="TestEnv.ImplementationClass", isRequired=true, description="The implementation class for the test execution environment."), @Property(name="TestEnv.ClassPath", isRequired=true, description="The (complete) classpath of the test execution environment as List<String>."), @Property(name="TestEnv.Singleton", type=Property.Type.BOOLEAN, defaultValue="false", description="Whether the test execution environment is singleton (default: false)."), @Property(name="TestEnv.SystemComponent", defaultValue="", defaultNull=true, description="The system component signature of the test execution environment (default:\"\")."), @Property(name="TestEnv.GUIContextID", defaultValue="", description="The ID of the GUI context for the test execution environment (default:\"\")."), @Property(name="TestEnv.ExecutionControlProperties", defaultValue="false, false, false", description="The execution control properties for the test execution environment (default: false, false, false)."), @Property(name="TestEnv.SupportsViewOnly", type=Property.Type.BOOLEAN, defaultValue="false", description="Whether the test execution environment supports the view only mode (default: false)."), @Property(name="TestEnv.IconID", defaultValue="", description="The icon for the test execution environment (default:\"\").")})
public class RuntimeRegistry
extends AbstractADEPT2Service {
    protected static final String TEST_ENVIRONMENT_PREFIX = "TestEnv";
    private static final String TEST_ENVIRONMENT_CONFIGURATION = "Configuration";
    protected static final String CONF_LOG_ACTIVITY_CONFIGURATIONS = "LogActivityConfigurations";
    protected static final String CONF_CLASSLOADER_FORBIDDEN_PACKAGES = "ForbiddenPackages";
    protected static final String CONF_CLASSLOADER_SHARED_PACKAGES = "SharedPackages";
    protected static final String CONF_CLASSLOADER_SHARED_CLASSES = "SharedClasses";
    protected static final String CONF_CLASSLOADER_SHARED_CLASSES_EXCEPTIONS = "SharedClassesExceptions";
    private static final String LOCAL_ACTIVITY_ATTRIBUTE_OVERRIDE = "ActivityOverride";
    private static final String LOCAL_ACTIVITY_ATTRIBUTE_TEST_OVERRIDE = "ActivityTestOverride";
    private static final String LOCAL_ACTIVITY_CONFIGURATION = "ActivityConfiguration";
    private static final String LOCAL_ACTIVITY_TEST_CONFIGURATION = "ActivityTestConfiguration";
    protected static final String ACTIVITY_ATTRIBUTE_IMPLEMENTATION_CLASS = "ImplementationClass";
    protected static final String ACTIVITY_ATTRIBUTE_CLASSPATH = "ClassPath";
    protected static final String ACTIVITY_ATTRIBUTE_SINGLETON = "Singleton";
    protected static final String ACTIVITY_ATTRIBUTE_SYSTEM_COMPONENT = "SystemComponent";
    protected static final String ACTIVITY_ATTRIBUTE_GUI_CONTEXT_ID = "GUIContextID";
    protected static final String ACTIVITY_ATTRIBUTE_EXECUTION_CONTROL_PROPERTIES = "ExecutionControlProperties";
    protected static final String ACTIVITY_ATTRIBUTE_SUPPORTS_VIEW_ONLY = "SupportsViewOnly";
    protected static final String ACTIVITY_ATTRIBUTE_SUPPORTS_TEST_EXECUTION = "SupportsTestExecution";
    protected static final String ACTIVITY_ATTRIBUTE_ICON_ID = "IconID";
    private static final FileFilter CLASS_PATH_ENTRY_FILTER = new FileFilter(){

        @Override
        public boolean accept(File pathname) {
            String name = pathname.getName().toLowerCase();
            return pathname.isDirectory() || name.endsWith(".jar") || name.endsWith(".zip") || name.endsWith(".dll") || name.endsWith(".so");
        }
    };
    protected final String[] classloaderForbiddenPackages;
    protected final String[] classloaderSharedPackages;
    protected final String[] classloaderSharedClasses;
    protected final String[] classloaderSharedAdeptClassesExceptions;
    private final UUID testID = new UUID(81985529216486895L, 0L);
    private final String testImplementationClass;
    private final Map<ActivityConstants.ActivityModelEntityType, List<String>> testClassPath;
    private final boolean testSingleton;
    private final byte[] testSystemComponent;
    private final String testGuiContextID;
    private final ExecutionControlProperties testEcp;
    private final boolean testSupportsViewOnly;
    private final UUID testIconID;
    private final org.apache.commons.configuration.Configuration testEnvCommonsConfiguration;
    private ActivityConfiguration testEnvConfiguration;
    protected final boolean LOG_ACTIVITY_CONFIGURATIONS;
    private final org.apache.commons.configuration.Configuration activityConfigurations;
    private final org.apache.commons.configuration.Configuration testConfigurations;
    private final org.apache.commons.configuration.Configuration activityOverrides;
    private final org.apache.commons.configuration.Configuration activityTestOverrides;
    private GlobalConfiguration gcProvider;
    private final Map<ActivityName, ExecutableComponent> singletons;
    private final Map<ActivityName, ThreadLock> singletonCreationLock;
    private final Map<ActivityName, AtomicInteger> singletonCreationLockWaiters;

    private void logConfiguration(String prefix, org.apache.commons.configuration.Configuration configuration) {
        if (this.LOG_ACTIVITY_CONFIGURATIONS) {
            StringBuilder log = new StringBuilder("Configuration ");
            log.append(prefix);
            log.append(":\n");
            if (configuration.isEmpty()) {
                log.append("The configuration is empty.");
            } else {
                Iterator keys = configuration.getKeys();
                while (keys.hasNext()) {
                    String key = (String)keys.next();
                    log.append(key);
                    log.append(" = ");
                    log.append(configuration.getString(key));
                    log.append('\n');
                }
            }
            this.logger.fine(log.toString());
        }
    }

    private void logConfiguration(String prefix, Configuration configuration) {
        if (this.LOG_ACTIVITY_CONFIGURATIONS) {
            StringBuilder log = new StringBuilder("Configuration ");
            log.append(prefix);
            log.append(":\n");
            if (configuration.getAllEntries().size() < 1) {
                log.append("The configuration is empty.");
            } else {
                for (String key : configuration.getAllEntries()) {
                    log.append(key);
                    log.append(" = ");
                    log.append(configuration.getString(key));
                    log.append('\n');
                }
            }
            this.logger.fine(log.toString());
        }
    }

    private void addConfiguration(org.apache.commons.configuration.Configuration baseConf, String confPrfx, String confName, MergingConfiguration targetConf, ExecutionFactory factory) {
        org.apache.commons.configuration.Configuration configuration = baseConf.subset(confPrfx);
        if (!configuration.isEmpty()) {
            Configuration entityConfiguration = factory.createConfigurationWrapper(configuration, confName);
            targetConf.addFirst(entityConfiguration);
        }
        this.logConfiguration(confName, configuration);
    }

    public RuntimeRegistry(org.apache.commons.configuration.Configuration configuration, Registry registry) throws ConfigurationException {
        super(configuration, registry, new String[0], new String[]{"GlobalProvider"});
        ConfigurationManager<?> confMgr = ConfigurationManager.create(configuration);
        this.LOG_ACTIVITY_CONFIGURATIONS = configuration.getBoolean(CONF_LOG_ACTIVITY_CONFIGURATIONS);
        this.activityConfigurations = confMgr.getConfiguration(LOCAL_ACTIVITY_CONFIGURATION, LOCAL_ACTIVITY_CONFIGURATION);
        this.logConfiguration(LOCAL_ACTIVITY_CONFIGURATION, this.activityConfigurations);
        this.testConfigurations = confMgr.getConfiguration(LOCAL_ACTIVITY_TEST_CONFIGURATION, LOCAL_ACTIVITY_TEST_CONFIGURATION);
        this.logConfiguration(LOCAL_ACTIVITY_TEST_CONFIGURATION, this.testConfigurations);
        this.activityOverrides = confMgr.getConfiguration(LOCAL_ACTIVITY_ATTRIBUTE_OVERRIDE, LOCAL_ACTIVITY_ATTRIBUTE_OVERRIDE);
        this.logConfiguration(LOCAL_ACTIVITY_ATTRIBUTE_OVERRIDE, this.activityOverrides);
        this.activityTestOverrides = confMgr.getConfiguration(LOCAL_ACTIVITY_ATTRIBUTE_TEST_OVERRIDE, LOCAL_ACTIVITY_ATTRIBUTE_TEST_OVERRIDE);
        this.logConfiguration(LOCAL_ACTIVITY_ATTRIBUTE_TEST_OVERRIDE, this.activityTestOverrides);
        this.singletons = new HashMap<ActivityName, ExecutableComponent>();
        this.singletonCreationLock = new HashMap<ActivityName, ThreadLock>();
        this.singletonCreationLockWaiters = new HashMap<ActivityName, AtomicInteger>();
        this.classloaderForbiddenPackages = configuration.getStringArray(CONF_CLASSLOADER_FORBIDDEN_PACKAGES);
        this.classloaderSharedPackages = configuration.getStringArray(CONF_CLASSLOADER_SHARED_PACKAGES);
        this.classloaderSharedClasses = configuration.getStringArray(CONF_CLASSLOADER_SHARED_CLASSES);
        this.classloaderSharedAdeptClassesExceptions = configuration.getStringArray(CONF_CLASSLOADER_SHARED_CLASSES_EXCEPTIONS);
        org.apache.commons.configuration.Configuration testEnvConf = configuration.subset(TEST_ENVIRONMENT_PREFIX);
        try {
            this.testImplementationClass = testEnvConf.getString(ACTIVITY_ATTRIBUTE_IMPLEMENTATION_CLASS);
        }
        catch (ConversionException ce) {
            String msg = "Could not parse the value for the implementation class of the test activity. Please verify the type (String).";
            throw new ConfigurationException(msg, ce);
        }
        try {
            List classPath = testEnvConf.getList(ACTIVITY_ATTRIBUTE_CLASSPATH);
            this.splitClasspath(classPath);
            this.testClassPath = new HashMap<ActivityConstants.ActivityModelEntityType, List<String>>(3);
            ActivityConstants.ActivityModelEntityType[] activityModelEntityTypeArray = ActivityConstants.ActivityModelEntityType.values();
            int n = activityModelEntityTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                ActivityConstants.ActivityModelEntityType type = activityModelEntityTypeArray[n2];
                List emptyList = Collections.emptyList();
                this.testClassPath.put(type, emptyList);
                ++n2;
            }
            this.testClassPath.put(ActivityConstants.ActivityModelEntityType.ATD, classPath);
        }
        catch (ConversionException ce) {
            String msg = "Could not parse the value for the class path of the test activity. Please verify the type (List<String>).";
            throw new ConfigurationException(msg, ce);
        }
        try {
            this.testSingleton = testEnvConf.getBoolean(ACTIVITY_ATTRIBUTE_SINGLETON);
        }
        catch (ConversionException ce) {
            String msg = "Could not parse the value for the singleton flag of the test activity. Please verify the type (boolean).";
            throw new ConfigurationException(msg, ce);
        }
        try {
            List ovSystemComponent = testEnvConf.getList(ACTIVITY_ATTRIBUTE_SYSTEM_COMPONENT);
            this.testSystemComponent = new byte[ovSystemComponent.size()];
            int i = 0;
            while (i < this.testSystemComponent.length) {
                this.testSystemComponent[i] = Byte.parseByte((String)ovSystemComponent.get(i));
                ++i;
            }
        }
        catch (ConversionException ce) {
            String msg = "Could not parse the (list) value for the system component attribute of the test activity. Please verify the type (List<Byte>).";
            throw new ConfigurationException(msg, ce);
        }
        try {
            this.testGuiContextID = testEnvConf.getString(ACTIVITY_ATTRIBUTE_GUI_CONTEXT_ID);
        }
        catch (ConversionException ce) {
            String msg = "Could not parse the value for the GUI context ID of the test activity. Please verify the type (String).";
            throw new ConfigurationException(msg, ce);
        }
        try {
            List ovECP = testEnvConf.getList(ACTIVITY_ATTRIBUTE_EXECUTION_CONTROL_PROPERTIES);
            this.testEcp = new ExecutionControlProperties(Boolean.parseBoolean((String)ovECP.get(0)), Boolean.parseBoolean((String)ovECP.get(1)), Boolean.parseBoolean((String)ovECP.get(2)));
        }
        catch (ConversionException ce) {
            String msg = "Could not parse the value for the execution control properties of the test activity. Please verify the type (List<Boolean>), size 3.";
            throw new ConfigurationException(msg, ce);
        }
        try {
            this.testSupportsViewOnly = testEnvConf.getBoolean(ACTIVITY_ATTRIBUTE_SUPPORTS_VIEW_ONLY);
        }
        catch (ConversionException ce) {
            String msg = "Could not parse the value for the supports view only flag of the test activity. Please verify the type (boolean).";
            throw new ConfigurationException(msg, ce);
        }
        try {
            String iconID = testEnvConf.getString(ACTIVITY_ATTRIBUTE_ICON_ID);
            this.testIconID = iconID != null && iconID.length() > 0 ? UUID.fromString(iconID) : null;
        }
        catch (ConversionException ce) {
            String msg = "Could not parse the value for the icon ID of the test activity. Please verify the type (UUID as String).";
            throw new ConfigurationException(msg, ce);
        }
        catch (IllegalArgumentException iae) {
            String msg = "Could not parse the (UUID) value for the icon ID of the test activity. Please verify that the string is a valid UUID.";
            throw new ConfigurationException(msg, iae);
        }
        this.testEnvCommonsConfiguration = testEnvConf.subset(TEST_ENVIRONMENT_CONFIGURATION);
    }

    @Override
    public void init(URI[] myURIs) throws AbortServiceException {
        super.init(myURIs, -2, -2, "password");
    }

    @Override
    public void start() throws AbortServiceException {
        this.gcProvider = this.registry.getServiceOfType(this.sessionFactory.getSessionToken(this.getURIs()), "GlobalProvider", GlobalProvider.class).getGlobalConfiguration();
        ExecutionFactory factory = this.registry.getModelFactory("ExecutionFactory", ExecutionFactory.class);
        Configuration configuration = factory.createConfigurationWrapper(this.testEnvCommonsConfiguration, "Local Configuration for TEST-Environment");
        this.testEnvConfiguration = factory.createActivityConfiguration(configuration);
        super.start();
    }

    public ActivityInstance getOverridenActivityInstance(SessionToken session, ActivityInstance activity, boolean test) {
        super.sessionActive(session);
        try {
            ActivityInstance activityInstance = this.getConfiguredActivityInstance(session, activity, test);
            return activityInstance;
        }
        finally {
            super.sessionFinished(session);
        }
    }

    public ExecutableComponent getComponent(SessionToken session, ActivityInstance activity, RichAgent richAgent) throws ConfigurationException {
        super.sessionActive(session);
        try {
            ExecutableComponent executableComponent = this.loadComponent(activity, richAgent);
            return executableComponent;
        }
        finally {
            super.sessionFinished(session);
        }
    }

    @Deprecated
    public ExecutableComponent getComponent(SessionToken session, ActivityInstance activity) throws ConfigurationException {
        return this.getComponent(session, activity, null);
    }

    public ExecutableComponent getTestComponent(SessionToken session, ActivityInstance activity, boolean replace, RichAgent richAgent) throws ConfigurationException {
        super.sessionActive(session);
        try {
            ExecutableComponent ret;
            if (replace) {
                ret = this.loadComponent(this.getTestActivityInstance(activity), richAgent);
            } else {
                ActivityInstance[] activities = new ActivityInstance[]{activity, this.getTestActivityInstance(activity)};
                ret = this.loadWrappingComponent(activities, null);
            }
            ExecutableComponent executableComponent = ret;
            return executableComponent;
        }
        finally {
            super.sessionFinished(session);
        }
    }

    @Deprecated
    public ExecutableComponent getTestComponent(SessionToken session, ActivityInstance activity, boolean replace) throws ConfigurationException, InterruptedException {
        return this.getTestComponent(session, activity, replace, null);
    }

    private void splitClasspath(List<String> classPath) {
        int i = 0;
        while (i < classPath.size()) {
            String[] cpPart = classPath.get(i).split(Pattern.quote(";"));
            classPath.set(i, cpPart[0].trim());
            int j = 1;
            while (j < cpPart.length) {
                classPath.add(++i, cpPart[j].trim());
                ++j;
            }
            ++i;
        }
    }

    private ActivityInstance getConfiguredActivityInstance(SessionToken session, ActivityInstance activity, boolean test) {
        Configuration entityConfiguration;
        ExecutionFactory factory;
        try {
            factory = this.registry.getModelFactory("ExecutionFactory", ExecutionFactory.class);
        }
        catch (ServiceNotKnownException snke) {
            this.logger.log(Level.SEVERE, "Could not retrieve the execution factory. This is a severe problem since it could be retrieved before.", snke);
            return null;
        }
        ActivityInstance ovActivity = this.overrideActivityInstanceAttributes(activity, test);
        ActivityName names = new ActivityName(ovActivity);
        MergingConfiguration mergingConfiguration = factory.createMergingConfiguration(ovActivity.getConfiguration());
        if (names.confName != null) {
            entityConfiguration = this.gcProvider.getConfiguration(session, names.confName);
            if (entityConfiguration != null) {
                mergingConfiguration.addFirst(entityConfiguration);
                this.logConfiguration("namespace global", entityConfiguration);
            }
            if (test && (entityConfiguration = this.gcProvider.getTestConfiguration(session, names.confName)) != null) {
                mergingConfiguration.addFirst(entityConfiguration);
            }
            this.addConfiguration(this.activityConfigurations, names.confNamePrfx, "Namespace of LocalConfiguration", mergingConfiguration, factory);
            if (test) {
                this.addConfiguration(this.testConfigurations, names.confNamePrfx, "Test of Namespace of LocalConfiguration", mergingConfiguration, factory);
            }
        }
        if (names.confName != null) {
            entityConfiguration = this.gcProvider.getConfiguration(session, names.confName, names.ecName);
            if (entityConfiguration != null) {
                mergingConfiguration.addFirst(entityConfiguration);
                this.logConfiguration("ecd global", entityConfiguration);
            }
            if (test && (entityConfiguration = this.gcProvider.getTestConfiguration(session, names.confName, names.ecName)) != null) {
                mergingConfiguration.addFirst(entityConfiguration);
            }
        }
        this.addConfiguration(this.activityConfigurations, names.confECPrfx, "ExecutableComponentDescription of Namespace of LocalConfiguration", mergingConfiguration, factory);
        if (test) {
            this.addConfiguration(this.testConfigurations, names.confECPrfx, "Test of ExecutableComponentDescription of Namespace of LocalConfiguration", mergingConfiguration, factory);
        }
        if (names.confName != null) {
            entityConfiguration = this.gcProvider.getConfiguration(session, names.confName, names.ecName, names.operationName);
            if (entityConfiguration != null) {
                mergingConfiguration.addFirst(entityConfiguration);
                this.logConfiguration("operation global", entityConfiguration);
            }
            if (test && (entityConfiguration = this.gcProvider.getTestConfiguration(session, names.confName, names.ecName, names.operationName)) != null) {
                mergingConfiguration.addFirst(entityConfiguration);
            }
        }
        this.addConfiguration(this.activityConfigurations, names.confOpPrfx, "Operation of Namespace of LocalConfiguration", mergingConfiguration, factory);
        if (test) {
            this.addConfiguration(this.testConfigurations, names.confOpPrfx, "Test of Operation of Namespace of LocalConfiguration", mergingConfiguration, factory);
        }
        if (names.confName != null) {
            entityConfiguration = this.gcProvider.getConfiguration(session, names.confName, names.ecName, names.operationName, names.activityName);
            if (entityConfiguration != null) {
                mergingConfiguration.addFirst(entityConfiguration);
                this.logConfiguration("activity global", entityConfiguration);
            }
            if (test && (entityConfiguration = this.gcProvider.getTestConfiguration(session, names.confName, names.ecName, names.operationName, names.activityName)) != null) {
                mergingConfiguration.addFirst(entityConfiguration);
            }
        }
        this.addConfiguration(this.activityConfigurations, names.confActPrfx, "Activity of Namespace of LocalConfiguration", mergingConfiguration, factory);
        if (test) {
            this.addConfiguration(this.testConfigurations, names.confActPrfx, "Test of Activity of Namespace of LocalConfiguration", mergingConfiguration, factory);
        }
        this.logConfiguration("MergedConfiguration", mergingConfiguration.getMergedConfiguration());
        ActivityInstance ret = factory.createActivityInstance(ovActivity.getID(), ovActivity.getProcessTemplateName(), ovActivity.getProcessInstanceName(), ovActivity.getProcessInstanceLogID(), names.ecName, names.operationName, names.confName, names.activityName, ovActivity.getName(), ovActivity.getDescription(), ovActivity.getImplementationClass(), ovActivity.getSeparatedClassPaths(), ovActivity.isSingleton(), ovActivity.getSystemComponent(), ovActivity.getGUIContextID(), ovActivity.getExecutionControlProperties(), ovActivity.supportsViewOnly(), ovActivity.getIconID(), ovActivity.getAttributeOrigins(), factory.createActivityConfiguration(mergingConfiguration.getMergedConfiguration()), ovActivity.getParameters(ActivityConstants.AccessType.READ), ovActivity.getParameters(ActivityConstants.AccessType.WRITE), ovActivity.getAttachedDataContext(), ovActivity, ovActivity.getUserAttributes());
        if (activity instanceof DecisionActivityInstance) {
            DecisionActivityInstance dai = (DecisionActivityInstance)activity;
            ret = factory.createDecisionActivityInstance(ret, dai.getDecisionParameter(), new ArrayList<DecisionStatement>(dai.getAllDecisionStatements()));
        }
        return ret;
    }

    private ActivityInstance overrideActivityInstanceAttributes(ActivityInstance activity, boolean test) {
        String prefixedKey;
        String msg;
        String[] overridePrfxs;
        ExecutionFactory factory;
        try {
            factory = this.registry.getModelFactory("ExecutionFactory", ExecutionFactory.class);
        }
        catch (ServiceNotKnownException snke) {
            this.logger.log(Level.SEVERE, "Could not retrieve the execution factory. This is a severe problem since it could be retrieved before.", snke);
            return null;
        }
        ActivityName names = new ActivityName(activity);
        HashMap<ActivityConstants.LocallyOverrideableActivityAttribute, ActivityConstants.ActivityModelEntityType> attributeOrigins = new HashMap<ActivityConstants.LocallyOverrideableActivityAttribute, ActivityConstants.ActivityModelEntityType>(activity.getAttributeOrigins());
        String implementationClass = activity.getImplementationClass();
        Map<ActivityConstants.ActivityModelEntityType, List<String>> classPath = activity.getSeparatedClassPaths();
        boolean isSingleton = activity.isSingleton();
        byte[] systemComponent = activity.getSystemComponent();
        String guiContextID = activity.getGUIContextID();
        ExecutionControlProperties ecp = activity.getExecutionControlProperties();
        boolean supportsViewOnly = activity.supportsViewOnly();
        UUID iconID = activity.getIconID();
        String key = ACTIVITY_ATTRIBUTE_IMPLEMENTATION_CLASS;
        switch ((ActivityConstants.ActivityModelEntityType)((Object)attributeOrigins.get((Object)ActivityConstants.LocallyOverrideableActivityAttribute.IMPLEMENTATION_CLASS))) {
            case ECD: {
                overridePrfxs = names.ovrdECPrfxs;
                break;
            }
            case OPERATION: {
                overridePrfxs = names.ovrdOpPrfxs;
                break;
            }
            case ATD: {
                overridePrfxs = names.ovrdActPrfxs;
                break;
            }
            default: {
                overridePrfxs = new String[]{};
            }
        }
        String[] stringArray = overridePrfxs;
        int n = overridePrfxs.length;
        int n2 = 0;
        while (n2 < n) {
            String prefix = stringArray[n2];
            String prefixedKey2 = String.format("%1$s.%2$s", prefix, key);
            if (test && this.activityTestOverrides.containsKey(prefixedKey2)) {
                try {
                    implementationClass = this.activityTestOverrides.getString(prefixedKey2);
                    attributeOrigins.put(ActivityConstants.LocallyOverrideableActivityAttribute.IMPLEMENTATION_CLASS, names.getOverridingType(prefix));
                    break;
                }
                catch (ConversionException ce) {
                    msg = "Could not parse the value for test overriding the implementation class of activity '%s' although the corresponding key '%s' exists in the configuration. Please verify the type (String). Overriding does not apply on this level, that is either a higher level entity (possibly non-test) override or the normal value '%s' will be used.";
                    this.logger.log(Level.WARNING, String.format(msg, names, prefixedKey2, implementationClass), ce);
                }
            } else if (this.activityOverrides.containsKey(prefixedKey2)) {
                try {
                    implementationClass = this.activityOverrides.getString(prefixedKey2);
                    attributeOrigins.put(ActivityConstants.LocallyOverrideableActivityAttribute.IMPLEMENTATION_CLASS, names.getOverridingType(prefix));
                    break;
                }
                catch (ConversionException ce) {
                    msg = "Could not parse the value for overriding the implementation class of activity '%s' although the corresponding key '%s' exists in the configuration. Please verify the type (String). Overriding does not apply on this level, that is either a higher level entity override or the normal value '%s' will be used.";
                    this.logger.log(Level.WARNING, String.format(msg, names, prefixedKey2, implementationClass), ce);
                }
            }
            ++n2;
        }
        key = ACTIVITY_ATTRIBUTE_CLASSPATH;
        ActivityConstants.ActivityModelEntityType currentType = ActivityConstants.ActivityModelEntityType.ECD;
        List<String> oldClassPath = classPath.get((Object)currentType);
        ConfigurationManager.replaceVariables(oldClassPath);
        String cpPrefixedKey = String.format("%1$s.%2$s", names.ovrdECPrfx, key);
        if (this.activityOverrides.containsKey(cpPrefixedKey)) {
            try {
                List newClassPath = this.activityOverrides.getList(cpPrefixedKey);
                this.splitClasspath(newClassPath);
                if (oldClassPath.size() == 0 && newClassPath.size() > 0) {
                    oldClassPath = new ArrayList<String>(newClassPath.size());
                    classPath.put(currentType, oldClassPath);
                }
                int i = newClassPath.size();
                while (i > 0) {
                    oldClassPath.add(0, (String)newClassPath.get(--i));
                }
            }
            catch (ConversionException ce) {
                msg = "Could not parse the (list) value for overriding the class path of activity '%s' (%s-level) although the corresponding key '%s'exists in the configuration. Please verify the type (List<String>). Overriding does not apply on this level, that is either the test override will apply yet or the normal value '%s' will be used for this level.";
                this.logger.log(Level.WARNING, String.format(msg, new Object[]{names, currentType, cpPrefixedKey, oldClassPath}), ce);
            }
        }
        if (test && this.activityTestOverrides.containsKey(cpPrefixedKey)) {
            try {
                List newClassPath = this.activityTestOverrides.getList(cpPrefixedKey);
                this.splitClasspath(newClassPath);
                if (oldClassPath.size() == 0 && newClassPath.size() > 0) {
                    oldClassPath = new ArrayList<String>(newClassPath.size());
                    classPath.put(currentType, oldClassPath);
                }
                int i = newClassPath.size();
                while (i > 0) {
                    oldClassPath.add(0, (String)newClassPath.get(--i));
                }
            }
            catch (ConversionException ce) {
                msg = "Could not parse the (list) value for test overriding the class path of activity '%s' (%s-level) although the corresponding key '%s' exists in the configuration. Please verify the type (List<String>). Overriding does not apply on this level, that is the normal value '%s' will be used.";
                this.logger.log(Level.WARNING, String.format(msg, new Object[]{names, currentType, cpPrefixedKey, oldClassPath}), ce);
            }
        }
        currentType = ActivityConstants.ActivityModelEntityType.OPERATION;
        oldClassPath = classPath.get((Object)currentType);
        ConfigurationManager.replaceVariables(oldClassPath);
        cpPrefixedKey = String.format("%1$s.%2$s", names.ovrdOpPrfx, key);
        if (this.activityOverrides.containsKey(cpPrefixedKey)) {
            try {
                List newClassPath = this.activityOverrides.getList(cpPrefixedKey);
                this.splitClasspath(newClassPath);
                if (oldClassPath.size() == 0 && newClassPath.size() > 0) {
                    oldClassPath = new ArrayList<String>(newClassPath.size());
                    classPath.put(currentType, oldClassPath);
                }
                int i = newClassPath.size();
                while (i > 0) {
                    oldClassPath.add(0, (String)newClassPath.get(--i));
                }
            }
            catch (ConversionException ce) {
                msg = "Could not parse the (list) value for overriding the class path of activity '%s' (%s-level) although the corresponding key '%s'exists in the configuration. Please verify the type (List<String>). Overriding does not apply on this level, that is either the test override will apply yet or the normal value '%s' will be used for this level.";
                this.logger.log(Level.WARNING, String.format(msg, new Object[]{names, currentType, cpPrefixedKey, oldClassPath}), ce);
            }
        }
        if (test && this.activityTestOverrides.containsKey(cpPrefixedKey)) {
            try {
                List newClassPath = this.activityTestOverrides.getList(cpPrefixedKey);
                this.splitClasspath(newClassPath);
                if (oldClassPath.size() == 0 && newClassPath.size() > 0) {
                    oldClassPath = new ArrayList<String>(newClassPath.size());
                    classPath.put(currentType, oldClassPath);
                }
                int i = newClassPath.size();
                while (i > 0) {
                    oldClassPath.add(0, (String)newClassPath.get(--i));
                }
            }
            catch (ConversionException ce) {
                msg = "Could not parse the (list) value for test overriding the class path of activity '%s' (%s-level) although the corresponding key '%s' exists in the configuration. Please verify the type (List<String>). Overriding does not apply on this level, that is the normal value '%s' will be used.";
                this.logger.log(Level.WARNING, String.format(msg, new Object[]{names, currentType, cpPrefixedKey, oldClassPath}), ce);
            }
        }
        currentType = ActivityConstants.ActivityModelEntityType.ATD;
        oldClassPath = classPath.get((Object)currentType);
        ConfigurationManager.replaceVariables(oldClassPath);
        cpPrefixedKey = String.format("%1$s.%2$s", names.ovrdActPrfx, key);
        if (this.activityOverrides.containsKey(cpPrefixedKey)) {
            try {
                List newClassPath = this.activityOverrides.getList(cpPrefixedKey);
                this.splitClasspath(newClassPath);
                if (oldClassPath.size() == 0 && newClassPath.size() > 0) {
                    oldClassPath = new ArrayList<String>(newClassPath.size());
                    classPath.put(currentType, oldClassPath);
                }
                int i = newClassPath.size();
                while (i > 0) {
                    oldClassPath.add(0, (String)newClassPath.get(--i));
                }
            }
            catch (ConversionException ce) {
                msg = "Could not parse the (list) value for overriding the class path of activity '%s' (%s-level) although the corresponding key '%s'exists in the configuration. Please verify the type (List<String>). Overriding does not apply on this level, that is either the test override will apply yet or the normal value '%s' will be used for this level.";
                this.logger.log(Level.WARNING, String.format(msg, new Object[]{names, currentType, cpPrefixedKey, oldClassPath}), ce);
            }
        }
        if (test && this.activityTestOverrides.containsKey(cpPrefixedKey)) {
            try {
                List newClassPath = this.activityTestOverrides.getList(cpPrefixedKey);
                this.splitClasspath(newClassPath);
                if (oldClassPath.size() == 0 && newClassPath.size() > 0) {
                    oldClassPath = new ArrayList<String>(newClassPath.size());
                    classPath.put(currentType, oldClassPath);
                }
                int i = newClassPath.size();
                while (i > 0) {
                    oldClassPath.add(0, (String)newClassPath.get(--i));
                }
            }
            catch (ConversionException ce) {
                msg = "Could not parse the (list) value for test overriding the class path of activity '%s' (%s-level) although the corresponding key '%s' exists in the configuration. Please verify the type (List<String>). Overriding does not apply on this level, that is the normal value '%s' will be used.";
                this.logger.log(Level.WARNING, String.format(msg, new Object[]{names, currentType, cpPrefixedKey, oldClassPath}), ce);
            }
        }
        key = ACTIVITY_ATTRIBUTE_SINGLETON;
        switch ((ActivityConstants.ActivityModelEntityType)((Object)attributeOrigins.get((Object)ActivityConstants.LocallyOverrideableActivityAttribute.IS_SINGLETON))) {
            case ECD: {
                overridePrfxs = names.ovrdECPrfxs;
                break;
            }
            case OPERATION: {
                overridePrfxs = names.ovrdOpPrfxs;
                break;
            }
            case ATD: {
                overridePrfxs = names.ovrdActPrfxs;
                break;
            }
            default: {
                overridePrfxs = new String[]{};
            }
        }
        String[] stringArray2 = overridePrfxs;
        int n3 = overridePrfxs.length;
        int n4 = 0;
        while (n4 < n3) {
            String prefix = stringArray2[n4];
            prefixedKey = String.format("%1$s.%2$s", prefix, key);
            if (test && this.activityTestOverrides.containsKey(prefixedKey)) {
                try {
                    isSingleton = this.activityTestOverrides.getBoolean(prefixedKey);
                    attributeOrigins.put(ActivityConstants.LocallyOverrideableActivityAttribute.IS_SINGLETON, names.getOverridingType(prefix));
                    break;
                }
                catch (ConversionException ce) {
                    msg = "Could not parse the value for test overriding the singleton flag of activity '%s' although the corresponding key '%s' exists in the configuration. Please verify the type (boolean). Overriding does not apply on this level, that is either a higher level entity (possibly non-test) override or the normal value '%s' will be used.";
                    this.logger.log(Level.WARNING, String.format(msg, names, prefixedKey, isSingleton), ce);
                }
            } else if (this.activityOverrides.containsKey(prefixedKey)) {
                try {
                    isSingleton = this.activityOverrides.getBoolean(prefixedKey);
                    attributeOrigins.put(ActivityConstants.LocallyOverrideableActivityAttribute.IS_SINGLETON, names.getOverridingType(prefix));
                    break;
                }
                catch (ConversionException ce) {
                    msg = "Could not parse the value for overriding the singleton flag of activity '%s' although the corresponding key '%s' exists in the configuration. Please verify the type (boolean). Overriding does not apply on this level, that is either a higher level entity override or the normal value '%s' will be used.";
                    this.logger.log(Level.WARNING, String.format(msg, names, prefixedKey, isSingleton), ce);
                }
            }
            ++n4;
        }
        key = ACTIVITY_ATTRIBUTE_SYSTEM_COMPONENT;
        switch ((ActivityConstants.ActivityModelEntityType)((Object)attributeOrigins.get((Object)ActivityConstants.LocallyOverrideableActivityAttribute.SYSTEM_COMPONENT))) {
            case ECD: {
                overridePrfxs = names.ovrdECPrfxs;
                break;
            }
            case OPERATION: {
                overridePrfxs = names.ovrdOpPrfxs;
                break;
            }
            case ATD: {
                overridePrfxs = names.ovrdActPrfxs;
                break;
            }
            default: {
                overridePrfxs = new String[]{};
            }
        }
        stringArray2 = overridePrfxs;
        n3 = overridePrfxs.length;
        n4 = 0;
        while (n4 < n3) {
            block127: {
                byte[] newSystemComponent;
                List ovSystemComponent;
                String prefix = stringArray2[n4];
                prefixedKey = String.format("%1$s.%2$s", prefix, key);
                if (test && this.activityTestOverrides.containsKey(prefixedKey)) {
                    try {
                        ovSystemComponent = this.activityTestOverrides.getList(prefixedKey);
                        newSystemComponent = new byte[ovSystemComponent.size()];
                        int i = 0;
                        while (i < newSystemComponent.length) {
                            newSystemComponent[i] = Byte.parseByte((String)ovSystemComponent.get(i));
                            ++i;
                        }
                        systemComponent = newSystemComponent;
                        attributeOrigins.put(ActivityConstants.LocallyOverrideableActivityAttribute.SYSTEM_COMPONENT, names.getOverridingType(prefix));
                        break;
                    }
                    catch (ConversionException ce) {
                        msg = "Could not parse the (list) value for test overriding the system component attribute of activity '%s' although the corresponding key '%s' exists in the configuration. Please verify the type (List<Byte>). Overriding does not apply on this level, that is either a higher level entity (possibly non-test) override or the normal value '%s' will be used.";
                        this.logger.log(Level.WARNING, String.format(msg, names, prefixedKey, Arrays.toString(systemComponent)), ce);
                        break block127;
                    }
                    catch (NumberFormatException nfe) {
                        msg = "Could not parse the (byte) value for test overriding the system component attribute of activity '%s' although the corresponding key '%s' exists in the configuration. Please verify the type (List<Byte>). Overriding does not apply on this level, that is either a higher level entity (possibly non-test) override or the normal value '%s' will be used.";
                        this.logger.log(Level.WARNING, String.format(msg, names, prefixedKey, Arrays.toString(systemComponent)), nfe);
                        break block127;
                    }
                }
                if (this.activityOverrides.containsKey(prefixedKey)) {
                    try {
                        ovSystemComponent = this.activityOverrides.getList(prefixedKey);
                        newSystemComponent = new byte[ovSystemComponent.size()];
                        int i = 0;
                        while (i < newSystemComponent.length) {
                            newSystemComponent[i] = Byte.parseByte((String)ovSystemComponent.get(i));
                            ++i;
                        }
                        systemComponent = newSystemComponent;
                        attributeOrigins.put(ActivityConstants.LocallyOverrideableActivityAttribute.SYSTEM_COMPONENT, names.getOverridingType(prefix));
                        break;
                    }
                    catch (ConversionException ce) {
                        msg = "Could not parse the (list) value for overriding the system component attribute of activity '%s' although the corresponding key '%s' exists in the configuration. Please verify the type (List<Byte>). Overriding does not apply on this level, that is either a higher level entity override or the normal value '%s' will be used.";
                        this.logger.log(Level.WARNING, String.format(msg, names, prefixedKey, Arrays.toString(systemComponent)), ce);
                    }
                    catch (NumberFormatException nfe) {
                        msg = "Could not parse the (byte) value for overriding the system component attribute of activity '%s' although the corresponding key '%s' exists in the configuration. Please verify the type (List<Byte>). Overriding does not apply on this level, that is either a higher level entity override or the normal value '%s' will be used.";
                        this.logger.log(Level.WARNING, String.format(msg, names, prefixedKey, Arrays.toString(systemComponent)), nfe);
                    }
                }
            }
            ++n4;
        }
        key = ACTIVITY_ATTRIBUTE_GUI_CONTEXT_ID;
        switch ((ActivityConstants.ActivityModelEntityType)((Object)attributeOrigins.get((Object)ActivityConstants.LocallyOverrideableActivityAttribute.GUI_CONTEXT_ID))) {
            case ECD: {
                overridePrfxs = names.ovrdECPrfxs;
                break;
            }
            case OPERATION: {
                overridePrfxs = names.ovrdOpPrfxs;
                break;
            }
            case ATD: {
                overridePrfxs = names.ovrdActPrfxs;
                break;
            }
            default: {
                overridePrfxs = new String[]{};
            }
        }
        stringArray2 = overridePrfxs;
        n3 = overridePrfxs.length;
        n4 = 0;
        while (n4 < n3) {
            String prefix = stringArray2[n4];
            prefixedKey = String.format("%1$s.%2$s", prefix, key);
            if (test && this.activityTestOverrides.containsKey(prefixedKey)) {
                try {
                    guiContextID = this.activityTestOverrides.getString(prefixedKey);
                    attributeOrigins.put(ActivityConstants.LocallyOverrideableActivityAttribute.GUI_CONTEXT_ID, names.getOverridingType(prefix));
                    break;
                }
                catch (ConversionException ce) {
                    msg = "Could not parse the value for test overriding the GUI context ID of activity '%s' although the corresponding key '%s' exists in the configuration. Please verify the type (String). Overriding does not apply on this level, that is either a higher level entity (possibly non-test) override or the normal value '%s' will be used.";
                    this.logger.log(Level.WARNING, String.format(msg, names, prefixedKey, guiContextID), ce);
                }
            } else if (this.activityOverrides.containsKey(prefixedKey)) {
                try {
                    guiContextID = this.activityOverrides.getString(prefixedKey);
                    attributeOrigins.put(ActivityConstants.LocallyOverrideableActivityAttribute.GUI_CONTEXT_ID, names.getOverridingType(prefix));
                    break;
                }
                catch (ConversionException ce) {
                    msg = "Could not parse the value for overriding the GUI context ID of activity '%s' although the corresponding key '%s' exists in the configuration. Please verify the type (String). Overriding does not apply on this level, that is either a higher level entity override or the normal value '%s' will be used.";
                    this.logger.log(Level.WARNING, String.format(msg, names, prefixedKey, guiContextID), ce);
                }
            }
            ++n4;
        }
        key = ACTIVITY_ATTRIBUTE_EXECUTION_CONTROL_PROPERTIES;
        switch ((ActivityConstants.ActivityModelEntityType)((Object)attributeOrigins.get((Object)ActivityConstants.LocallyOverrideableActivityAttribute.EXECUTION_CONTROL_PROPERTIES))) {
            case ECD: {
                overridePrfxs = names.ovrdECPrfxs;
                break;
            }
            case OPERATION: {
                overridePrfxs = names.ovrdOpPrfxs;
                break;
            }
            case ATD: {
                overridePrfxs = names.ovrdActPrfxs;
                break;
            }
            default: {
                overridePrfxs = new String[]{};
            }
        }
        stringArray2 = overridePrfxs;
        n3 = overridePrfxs.length;
        n4 = 0;
        while (n4 < n3) {
            List ovECP;
            String prefix = stringArray2[n4];
            prefixedKey = String.format("%1$s.%2$s", prefix, key);
            if (test && this.activityTestOverrides.containsKey(prefixedKey)) {
                try {
                    ovECP = this.activityTestOverrides.getList(prefixedKey);
                    ecp = new ExecutionControlProperties(Boolean.parseBoolean((String)ovECP.get(0)), Boolean.parseBoolean((String)ovECP.get(1)), Boolean.parseBoolean((String)ovECP.get(2)));
                    attributeOrigins.put(ActivityConstants.LocallyOverrideableActivityAttribute.EXECUTION_CONTROL_PROPERTIES, names.getOverridingType(prefix));
                    break;
                }
                catch (ConversionException ce) {
                    msg = "Could not parse the value for test overriding the execution control properties of activity '%s' although the corresponding key '%s' exists in the configuration. Please verify the type (List<Boolean>), size 3. Overriding does not apply on this level, that is either a higher level entity (possibly non-test) override or the normal value '%s' will be used.";
                    this.logger.log(Level.WARNING, String.format(msg, names, prefixedKey, ecp), ce);
                }
            } else if (this.activityOverrides.containsKey(prefixedKey)) {
                try {
                    ovECP = this.activityOverrides.getList(prefixedKey);
                    ecp = new ExecutionControlProperties(Boolean.parseBoolean((String)ovECP.get(0)), Boolean.parseBoolean((String)ovECP.get(1)), Boolean.parseBoolean((String)ovECP.get(2)));
                    attributeOrigins.put(ActivityConstants.LocallyOverrideableActivityAttribute.EXECUTION_CONTROL_PROPERTIES, names.getOverridingType(prefix));
                    break;
                }
                catch (ConversionException ce) {
                    msg = "Could not parse the value for overriding the execution control properties of activity '%s' although the corresponding key '%s' exists in the configuration. Please verify the type (List<Boolean>), size 3. Overriding does not apply on this level, that is either a higher level entity override or the normal value '%s' will be used.";
                    this.logger.log(Level.WARNING, String.format(msg, names, prefixedKey, ecp), ce);
                }
            }
            ++n4;
        }
        key = ACTIVITY_ATTRIBUTE_SUPPORTS_VIEW_ONLY;
        switch ((ActivityConstants.ActivityModelEntityType)((Object)attributeOrigins.get((Object)ActivityConstants.LocallyOverrideableActivityAttribute.SUPPORTS_VIEW_ONLY))) {
            case ECD: {
                overridePrfxs = names.ovrdECPrfxs;
                break;
            }
            case OPERATION: {
                overridePrfxs = names.ovrdOpPrfxs;
                break;
            }
            case ATD: {
                overridePrfxs = names.ovrdActPrfxs;
                break;
            }
            default: {
                overridePrfxs = new String[]{};
            }
        }
        stringArray2 = overridePrfxs;
        n3 = overridePrfxs.length;
        n4 = 0;
        while (n4 < n3) {
            String prefix = stringArray2[n4];
            prefixedKey = String.format("%1$s.%2$s", prefix, key);
            if (test && this.activityTestOverrides.containsKey(prefixedKey)) {
                try {
                    supportsViewOnly = this.activityTestOverrides.getBoolean(prefixedKey);
                    attributeOrigins.put(ActivityConstants.LocallyOverrideableActivityAttribute.SUPPORTS_VIEW_ONLY, names.getOverridingType(prefix));
                    break;
                }
                catch (ConversionException ce) {
                    msg = "Could not parse the value for test overriding the supports view only flag of activity '%s' although the corresponding key '%s' exists in the configuration. Please verify the type (boolean). Overriding does not apply on this level, that is either a higher level entity (possibly non-test) override or the normal value '%s' will be used.";
                    this.logger.log(Level.WARNING, String.format(msg, names, prefixedKey, supportsViewOnly), ce);
                }
            } else if (this.activityOverrides.containsKey(prefixedKey)) {
                try {
                    supportsViewOnly = this.activityOverrides.getBoolean(prefixedKey);
                    attributeOrigins.put(ActivityConstants.LocallyOverrideableActivityAttribute.SUPPORTS_VIEW_ONLY, names.getOverridingType(prefix));
                    break;
                }
                catch (ConversionException ce) {
                    msg = "Could not parse the value for overriding the supports view only flag of activity '%s' although the corresponding key '%s' exists in the configuration. Please verify the type (boolean). Overriding does not apply on this level, that is either a higher level entity override or the normal value '%s' will be used.";
                    this.logger.log(Level.WARNING, String.format(msg, names, prefixedKey, supportsViewOnly), ce);
                }
            }
            ++n4;
        }
        key = ACTIVITY_ATTRIBUTE_ICON_ID;
        switch ((ActivityConstants.ActivityModelEntityType)((Object)attributeOrigins.get((Object)ActivityConstants.LocallyOverrideableActivityAttribute.ICON_ID))) {
            case ECD: {
                overridePrfxs = names.ovrdECPrfxs;
                break;
            }
            case OPERATION: {
                overridePrfxs = names.ovrdOpPrfxs;
                break;
            }
            case ATD: {
                overridePrfxs = names.ovrdActPrfxs;
                break;
            }
            default: {
                overridePrfxs = new String[]{};
            }
        }
        stringArray2 = overridePrfxs;
        n3 = overridePrfxs.length;
        n4 = 0;
        while (n4 < n3) {
            block128: {
                String prefix = stringArray2[n4];
                prefixedKey = String.format("%1$s.%2$s", prefix, key);
                if (test && this.activityTestOverrides.containsKey(prefixedKey)) {
                    try {
                        iconID = UUID.fromString(this.activityTestOverrides.getString(prefixedKey));
                        attributeOrigins.put(ActivityConstants.LocallyOverrideableActivityAttribute.ICON_ID, names.getOverridingType(prefix));
                        break;
                    }
                    catch (ConversionException ce) {
                        msg = "Could not parse the value for test overriding the icon ID of activity '%s' although the corresponding key '%s' exists in the configuration. Please verify the type (UUID as String). Overriding does not apply on this level, that is either a higher level entity (possibly non-test) override or the normal value '%s' will be used.";
                        this.logger.log(Level.WARNING, String.format(msg, names, prefixedKey, iconID), ce);
                        break block128;
                    }
                    catch (IllegalArgumentException iae) {
                        msg = "Could not parse the (UUID) value for test overriding the icon ID of activity '%s' although the corresponding key '%s' exists in the configuration. Please verify that the string is a valid UUID. Overriding does not apply, that is the normal value '%s' will be used.";
                        this.logger.log(Level.WARNING, String.format(msg, names, prefixedKey, iconID), iae);
                        break block128;
                    }
                }
                if (this.activityOverrides.containsKey(prefixedKey)) {
                    try {
                        iconID = UUID.fromString(this.activityOverrides.getString(prefixedKey));
                        attributeOrigins.put(ActivityConstants.LocallyOverrideableActivityAttribute.ICON_ID, names.getOverridingType(prefix));
                        break;
                    }
                    catch (ConversionException ce) {
                        msg = "Could not parse the value for overriding the icon ID of activity '%s' although the corresponding key '%s' exists in the configuration. Please verify the type (UUID as String). Overriding does not apply on this level, that is either a higher level entity override or the normal value '%s' will be used.";
                        this.logger.log(Level.WARNING, String.format(msg, names, prefixedKey, iconID), ce);
                    }
                    catch (IllegalArgumentException iae) {
                        msg = "Could not parse the (UUID) value for overriding the icon ID of activity '%s' although the corresponding key '%s' exists in the configuration. Please verify that the string is a valid UUID. Overriding does not apply, that is the normal value '%s' will be used.";
                        this.logger.log(Level.WARNING, String.format(msg, names, prefixedKey, iconID), iae);
                    }
                }
            }
            ++n4;
        }
        return factory.createActivityInstance(activity.getID(), activity.getProcessTemplateName(), activity.getProcessInstanceName(), activity.getProcessInstanceLogID(), names.ecName, names.operationName, names.confName, names.activityName, activity.getName(), activity.getDescription(), implementationClass, classPath, isSingleton, systemComponent, guiContextID, ecp, supportsViewOnly, iconID, attributeOrigins, activity.getConfiguration(), activity.getParameters(ActivityConstants.AccessType.READ), activity.getParameters(ActivityConstants.AccessType.WRITE), activity.getAttachedDataContext(), activity, activity.getUserAttributes());
    }

    private ActivityInstance getTestActivityInstance(ActivityInstance wrapped) {
        ExecutionFactory factory;
        try {
            factory = this.registry.getModelFactory("ExecutionFactory", ExecutionFactory.class);
        }
        catch (ServiceNotKnownException snke) {
            this.logger.log(Level.SEVERE, "Could not retrieve the execution factory. This is a severe problem since it could be retrieved before.", snke);
            return null;
        }
        String name = String.format("TEST: %s", wrapped.getName());
        String desc = String.format("TEST: %s", wrapped.getDescription());
        ExecutionControlProperties waECP = wrapped.getExecutionControlProperties();
        ExecutionControlProperties ecp = new ExecutionControlProperties(waECP.isSuspensible() && this.testEcp.isSuspensible(), waECP.isResettable() && this.testEcp.isResettable(), waECP.isClosable() && this.testEcp.isClosable());
        boolean supportsViewOnly = wrapped.supportsViewOnly() && this.testSupportsViewOnly;
        return factory.createActivityInstance(this.testID, wrapped.getProcessTemplateName(), wrapped.getProcessInstanceName(), wrapped.getProcessInstanceLogID(), wrapped.getExecutableComponentName(), wrapped.getOperationName(), wrapped.getConfigurationName(), wrapped.getActivityName(), name, desc, this.testImplementationClass, this.testClassPath, this.testSingleton, this.testSystemComponent, this.testGuiContextID, ecp, supportsViewOnly, this.testIconID, null, this.testEnvConfiguration, wrapped.getParameters(ActivityConstants.AccessType.READ), wrapped.getParameters(ActivityConstants.AccessType.WRITE), wrapped.getAttachedDataContext(), wrapped, wrapped.getUserAttributes());
    }

    private ExecutableComponent loadComponent(ActivityInstance activity, RichAgent richAgent) throws ConfigurationException {
        return this.loadComponent(activity, null, this.isSystemEnvironment(activity), richAgent);
    }

    private ExecutableComponent loadWrappingComponent(ActivityInstance[] activities, RichAgent richAgent) throws ConfigurationException {
        ExecutableComponent[] wrappeds = new ExecutableComponent[activities.length];
        boolean systemEnvironment = this.containsSystemEnvironment(activities);
        int i = 0;
        while (i < activities.length) {
            wrappeds[i] = this.loadComponent(activities[i], null, systemEnvironment, richAgent);
            ++i;
        }
        return wrappeds[wrappeds.length - 1];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ExecutableComponent loadComponent(ActivityInstance activity, ExecutableComponent[] wrappedComponents, boolean systemEnvironment, RichAgent richAgent) throws ConfigurationException {
        Object[] parameterValues;
        Class[] parameterTypes;
        Class<?> implementationClass;
        ClassLoader classLoader;
        ReentrantLock singletonLock;
        ActivityName name;
        block45: {
            Map<ActivityName, ThreadLock> map;
            ExecutableComponent executableComponent;
            block46: {
                name = new ActivityName(activity);
                singletonLock = null;
                if (activity.isSingleton()) {
                    Map<ActivityName, ThreadLock> map2 = this.singletonCreationLock;
                    synchronized (map2) {
                        if (this.singletons.containsKey(name)) {
                            return this.singletons.get(name);
                        }
                        singletonLock = this.singletonCreationLock.get(name);
                        if (singletonLock == null) {
                            try {
                                singletonLock = new ThreadLock(true);
                            }
                            catch (InstantiationException e) {
                                throw new ConfigurationException("Error instantiating the lock count manager", e);
                            }
                            catch (IllegalAccessException e) {
                                throw new ConfigurationException("Error accessing the lock count manager", e);
                            }
                            this.singletonCreationLock.put(name, (ThreadLock)singletonLock);
                        }
                        if (!this.singletonCreationLockWaiters.containsKey(name)) {
                            this.singletonCreationLockWaiters.put(name, new AtomicInteger(0));
                        }
                        this.singletonCreationLockWaiters.get(name).incrementAndGet();
                    }
                }
                if (singletonLock != null) {
                    try {
                        singletonLock.writeLock().lock(Thread.currentThread());
                    }
                    catch (InterruptedException e) {
                        throw new ConfigurationException("InterruptedException while waiting for a lock on a singleton activity", e);
                    }
                }
                try {
                    if (!activity.isSingleton()) break block45;
                    Map<ActivityName, ThreadLock> e = this.singletonCreationLock;
                    synchronized (e) {
                        this.singletonCreationLockWaiters.get(name).decrementAndGet();
                        if (this.singletons.containsKey(name)) {
                            executableComponent = this.singletons.get(name);
                            // MONITOREXIT @DISABLED, blocks:[3, 4, 44, 13] lbl46 : MonitorExitStatement: MONITOREXIT : e
                            if (singletonLock == null) return executableComponent;
                            if (singletonLock.writeLock().unlock(Thread.currentThread())) return executableComponent;
                            map = this.singletonCreationLock;
                            break block46;
                        }
                        break block45;
                    }
                }
                catch (Throwable throwable) {
                    if (singletonLock == null) throw throwable;
                    if (singletonLock.writeLock().unlock(Thread.currentThread())) throw throwable;
                    Map<ActivityName, ThreadLock> map3 = this.singletonCreationLock;
                    synchronized (map3) {
                        if (this.singletonCreationLockWaiters.get(name).get() != 0) throw throwable;
                        this.singletonCreationLock.remove(name);
                        throw throwable;
                    }
                }
            }
            synchronized (map) {
                if (this.singletonCreationLockWaiters.get(name).get() != 0) return executableComponent;
                this.singletonCreationLock.remove(name);
                return executableComponent;
            }
        }
        if (wrappedComponents != null) {
            classLoader = DoPrivileged.getClassLoader(wrappedComponents[0].getClass());
            if (classLoader instanceof URLClassLoader) {
                ((URLClassLoader)classLoader).addURLs(this.pathPropertyToURLs(activity.getClassPath()));
            }
        } else {
            classLoader = this.getClassLoader(name, activity.getClassPath(), systemEnvironment);
        }
        try {
            String msg = "Trying to load the implementation class '%s' for activity '%s'.";
            this.logger.finest(String.format(msg, activity.getImplementationClass(), activity.getActivityName()));
            implementationClass = classLoader.loadClass(activity.getImplementationClass());
            msg = "Loaded implementation class '%s' for activity '%s'.";
            this.logger.finest(String.format(msg, activity.getImplementationClass(), activity.getActivityName()));
        }
        catch (ClassNotFoundException cnfe) {
            String msg = String.format("Could not retrieve implementation class '%s' for activity '%s'. Please check the classpath: '%s'.", activity.getImplementationClass(), name, activity.getClassPath());
            throw new ConfigurationException(msg, cnfe);
        }
        if (systemEnvironment) {
            if (wrappedComponents != null) {
                parameterTypes = new Class[3];
                parameterValues = new Object[3];
                parameterTypes[2] = ExecutableComponent[].class;
                parameterValues[2] = wrappedComponents;
            } else {
                parameterTypes = new Class[2];
                parameterValues = new Object[2];
            }
            parameterTypes[1] = Registry.class;
            parameterValues[1] = this.registry;
        } else if (wrappedComponents != null) {
            parameterTypes = new Class[2];
            parameterValues = new Object[2];
            parameterTypes[1] = ExecutableComponent[].class;
            parameterValues[1] = wrappedComponents;
        } else {
            parameterTypes = new Class[1];
            parameterValues = new Object[1];
        }
        parameterTypes[0] = ActivityInstance.class;
        parameterValues[0] = richAgent != null ? LocalisationResolver.createLocalisedView(ActivityInstance.class, activity, richAgent.getLocale()) : activity;
        String msg = "Trying to create instance of implementation class '%s' for activity '%s'.";
        this.logger.finest(String.format(msg, activity.getImplementationClass(), activity.getActivityName()));
        ExecutableComponent ret = this.createInstanceOfComponent(implementationClass, parameterTypes, parameterValues);
        msg = "Created instance of implementation class '%s' for activity '%s'.";
        this.logger.finest(String.format(msg, activity.getImplementationClass(), activity.getActivityName()));
        if (activity.isSingleton()) {
            Map<ActivityName, ThreadLock> map = this.singletonCreationLock;
            synchronized (map) {
                this.singletons.put(name, ret);
            }
        }
        ExecutableComponent executableComponent = ret;
        if (singletonLock == null) return executableComponent;
        if (singletonLock.writeLock().unlock(Thread.currentThread())) return executableComponent;
        Map<ActivityName, ThreadLock> map = this.singletonCreationLock;
        synchronized (map) {
            if (this.singletonCreationLockWaiters.get(name).get() != 0) return executableComponent;
            this.singletonCreationLock.remove(name);
            return executableComponent;
        }
    }

    private boolean containsSystemEnvironment(ActivityInstance[] activities) throws ConfigurationException {
        boolean ret = false;
        ActivityInstance[] activityInstanceArray = activities;
        int n = activities.length;
        int n2 = 0;
        while (n2 < n) {
            ActivityInstance activity = activityInstanceArray[n2];
            if (ret |= this.isSystemEnvironment(activity)) break;
            ++n2;
        }
        return ret;
    }

    private boolean isSystemEnvironment(ActivityInstance activity) throws ConfigurationException {
        ClassLoader classLoader = this.getClassLoader(new ActivityName(activity), activity.getClassPath(), true);
        String className = activity.getImplementationClass();
        try {
            Class<?> implementationClass = classLoader.loadClass(className);
            return this.isSystemEnvironment(activity, implementationClass);
        }
        catch (ClassNotFoundException cnfe) {
            String msg = String.format("Could not retrieve implementation class '%s' for activity '%s'. Please check the classpath: '%s'.", activity.getImplementationClass(), new ActivityName(activity), activity.getClassPath());
            throw new ConfigurationException(msg, cnfe);
        }
        catch (NoClassDefFoundError ncdfe) {
            String msg = String.format("Could not retrieve implementation class '%s' or one of its members for activity '%s'. Please check the classpath: '%s'.", activity.getImplementationClass(), new ActivityName(activity), activity.getClassPath());
            throw new ConfigurationException(msg, ncdfe);
        }
    }

    private boolean isSystemEnvironment(ActivityInstance activity, Class<? extends ExecutableComponent> implementationClass) {
        return activity.getSystemComponent() != null;
    }

    protected ClassLoader getClassLoader(ActivityName activity, List<String> classpaths, boolean systemEnvironment) {
        URLClassLoader ret;
        ArrayList<String> classpathsCopy = new ArrayList<String>(classpaths);
        File ecLibDir = new File(SystemProperties.getLibDir(), activity.ecName);
        File[] files = ecLibDir.listFiles(CLASS_PATH_ENTRY_FILTER);
        boolean found = false;
        try {
            if (ecLibDir.exists() && ecLibDir.isDirectory() && files != null) {
                File[] fileArray = files;
                int n = files.length;
                int n2 = 0;
                while (n2 < n) {
                    File file = fileArray[n2];
                    if (file.isDirectory()) {
                        classpathsCopy.add(String.valueOf(file.getAbsolutePath()) + File.separator);
                    } else {
                        classpathsCopy.add(file.getAbsolutePath());
                    }
                    ++n2;
                }
                found = true;
            }
        }
        catch (SecurityException securityException) {
            found = false;
        }
        if (!found) {
            this.logger.info(String.format("The components private lib dir '%s' was not found, is not a directory or cannot be accessed, ignoring.", ecLibDir));
        }
        Object[] urlClassPaths = this.pathPropertyToURLs(classpathsCopy);
        if (systemEnvironment) {
            this.logger.info(String.format("Created system classloader for activity '%s' with classpaths '%s'", activity, Arrays.toString(urlClassPaths)));
            ret = DoPrivileged.getURLClassloader((URL[])urlClassPaths);
        } else {
            ret = DoPrivileged.getComponentClassloader((URL[])urlClassPaths, this.classloaderForbiddenPackages, this.classloaderSharedPackages, this.classloaderSharedClasses, this.classloaderSharedAdeptClassesExceptions);
            this.logger.info(String.format("Created classloader for activity '%s' with classpaths '%s'.", activity, Arrays.toString(urlClassPaths)));
        }
        return ret;
    }

    private ExecutableComponent createInstanceOfComponent(Class<? extends ExecutableComponent> implementationClass, Class<?>[] parameterTypes, Object[] parameterValues) throws ConfigurationException {
        ExecutableComponent instance;
        Constructor<? extends ExecutableComponent> constructor;
        assert (parameterTypes.length == parameterValues.length);
        String messageTemplate = String.format(" while trying to get the required constructor '%s' for '%s'.", AbstractRegistry.getFormattedSignature(parameterTypes), implementationClass.getName());
        try {
            constructor = implementationClass.getConstructor(parameterTypes);
        }
        catch (SecurityException se) {
            this.logger.log(Level.SEVERE, "SecurityException" + messageTemplate, se);
            throw new ConfigurationException("SecurityException" + messageTemplate, se);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            String message = String.format("Public constructor '%1$s%2$s' not found.", implementationClass.getName(), AbstractRegistry.getFormattedSignature(parameterTypes));
            this.logger.severe(message);
            throw new ConfigurationException(message);
        }
        try {
            instance = constructor.newInstance(parameterValues);
        }
        catch (IllegalAccessException iae) {
            String message = String.format("An IllegalAccessException occurred while trying to instantiate implementation '%1$s'!\n The constructor '%1$s%2$s' needs public access.", implementationClass.getName(), AbstractRegistry.getFormattedSignature(parameterTypes));
            this.logger.log(Level.SEVERE, message, iae);
            throw new ConfigurationException(message, iae);
        }
        catch (IllegalArgumentException iae) {
            String message = String.format("An IllegalArgumentException occurred while calling the constructor '%1$s%2$s'!\nPlease refer to http://java.sun.com/j2se/1.5.0/docs/api/java/lang/reflect/Constructor.html#newInstance(java.lang.Object...) for further information.", implementationClass.getName(), AbstractRegistry.getFormattedSignature(parameterTypes));
            this.logger.log(Level.SEVERE, message, iae);
            throw new ConfigurationException(message, iae);
        }
        catch (InstantiationException ie) {
            String message = String.format("InstantiationException while trying to instantiate implementation '%1$s'! Is it an interface or an abstract class? Does it contain compile errors? Is the constructor usable?", implementationClass.getName());
            this.logger.log(Level.SEVERE, message, ie);
            throw new ConfigurationException(message, ie);
        }
        catch (InvocationTargetException ite) {
            Throwable wrappedException = ite.getCause();
            if (wrappedException instanceof ConfigurationException) {
                throw (ConfigurationException)wrappedException;
            }
            if (wrappedException instanceof IllegalConfigurationDescriptionException) {
                throw (IllegalConfigurationDescriptionException)wrappedException;
            }
            String message = String.format("An exception occurred while calling the constructor '%1$s%2$s'.", implementationClass.getName(), AbstractRegistry.getFormattedSignature(parameterTypes));
            this.logger.log(Level.SEVERE, message, wrappedException);
            throw new ConfigurationException(message, wrappedException);
        }
        return (ExecutableComponent)ExecutableComponent.class.cast(instance);
    }

    private URL[] pathPropertyToURLs(List<String> classPaths) {
        if (classPaths == null || classPaths.size() == 0) {
            return new URL[0];
        }
        URL[] ret = new URL[classPaths.size()];
        int i = 0;
        for (String classPath : classPaths) {
            if (classPath == null) {
                this.logger.warning("Can not transform '" + null + "' to a valid URI. " + "Continue adding further classpaths.");
                continue;
            }
            try {
                URL urlPath;
                try {
                    urlPath = new URL(classPath);
                }
                catch (MalformedURLException malformedURLException) {
                    urlPath = null;
                }
                if (urlPath == null) {
                    urlPath = new File(classPath).getCanonicalFile().toURL();
                }
                ret[i++] = urlPath;
            }
            catch (IOException ioe) {
                String msg = "Can not transform '%s' to a valid URL/file. Ignoring it and continuing adding further classpaths.";
                this.logger.log(Level.WARNING, String.format(msg, classPath), ioe);
            }
        }
        return ret;
    }

    protected static class ActivityName {
        final String confName;
        final String confNamePrfx;
        final String ecName;
        final String confECPrfx;
        final String[] ovrdECPrfxs;
        final String ovrdECPrfx;
        final String operationName;
        final String confOpPrfx;
        final String[] ovrdOpPrfxs;
        final String ovrdOpPrfx;
        final String activityName;
        final String confActPrfx;
        final String[] ovrdActPrfxs;
        final String ovrdActPrfx;

        ActivityName(ActivityInstance activity) {
            String confName;
            this.confName = activity.getConfigurationName();
            this.ecName = activity.getExecutableComponentName();
            this.operationName = activity.getOperationName();
            this.activityName = activity.getActivityName();
            if (this.confName != null) {
                confName = this.confName;
                this.confNamePrfx = String.format("%1$s%2$c", this.confName, Character.valueOf('#'));
            } else {
                confName = "";
                this.confNamePrfx = null;
            }
            this.confECPrfx = String.format("%1$s%3$c%2$s%4$c", confName, this.ecName, Character.valueOf('$'), Character.valueOf('#'));
            this.confOpPrfx = String.format("%1$s%4$c%2$s%4$c%3$s%5$c", confName, this.ecName, this.operationName, Character.valueOf('$'), Character.valueOf('#'));
            this.confActPrfx = String.format("%1$s%5$c%2$s%5$c%3$s%5$c%4$s%6$c", confName, this.ecName, this.operationName, this.activityName, Character.valueOf('$'), Character.valueOf('#'));
            this.ovrdECPrfx = String.format("%1$s%2$c", this.ecName, Character.valueOf('#'));
            this.ovrdOpPrfx = String.format("%1$s%3$c%2$s%4$c", this.ecName, this.operationName, Character.valueOf('$'), Character.valueOf('#'));
            this.ovrdActPrfx = String.format("%1$s%4$c%2$s%4$c%3$s%5$c", this.ecName, this.operationName, this.activityName, Character.valueOf('$'), Character.valueOf('#'));
            this.ovrdECPrfxs = new String[]{this.ovrdECPrfx};
            this.ovrdOpPrfxs = new String[]{this.ovrdOpPrfx, this.ovrdECPrfx};
            this.ovrdActPrfxs = new String[]{this.ovrdActPrfx, this.ovrdOpPrfx, this.ovrdECPrfx};
        }

        ActivityConstants.ActivityModelEntityType getOverridingType(String overridePrefix) {
            if (this.ovrdECPrfx.equals(overridePrefix)) {
                return ActivityConstants.ActivityModelEntityType.ECD;
            }
            if (this.ovrdOpPrfx.equals(overridePrefix)) {
                return ActivityConstants.ActivityModelEntityType.OPERATION;
            }
            if (this.ovrdActPrfx.equals(overridePrefix)) {
                return ActivityConstants.ActivityModelEntityType.ATD;
            }
            return null;
        }

        public boolean equals(Object other) {
            boolean ret = false;
            if (other instanceof ActivityName) {
                ActivityName otherName = (ActivityName)other;
                ret = this.ecName.equals(otherName.ecName) && this.operationName.equals(otherName.operationName) && this.activityName.equals(otherName.activityName);
            }
            return ret;
        }

        public int hashCode() {
            return this.ecName.hashCode() ^ this.operationName.hashCode() ^ this.activityName.hashCode();
        }

        public String toString() {
            return String.format("%s#%s#%s", this.ecName, this.operationName, this.activityName);
        }
    }
}

