/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.core.runtimemanager.commonimplementation;

import de.aristaflow.adept2.base.service.AbstractADEPT2Service;
import de.aristaflow.adept2.base.service.AbstractSubService;
import de.aristaflow.adept2.base.service.ServiceAccessControlException;
import de.aristaflow.adept2.base.sessionmanagement.QualifiedAgent;
import de.aristaflow.adept2.base.sessionmanagement.SecurityTokenIntegrityException;
import de.aristaflow.adept2.base.sessionmanagement.SessionFactory;
import de.aristaflow.adept2.base.sessionmanagement.SessionToken;
import de.aristaflow.adept2.core.runtimemanager.ExecutionControlManager;
import de.aristaflow.adept2.core.runtimemanager.commonimplementation.ActivityComparator;
import de.aristaflow.adept2.core.runtimemanager.commonimplementation.ActivityManager;
import de.aristaflow.adept2.model.common.ExecutionControlProperties;
import de.aristaflow.adept2.model.processmodel.EBPInstanceReference;
import de.aristaflow.adept2.model.runtimeenvironment.ActivityState;
import de.aristaflow.adept2.util.types.Pair;
import java.io.Serializable;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.Set;

public abstract class AbstractExecutionControlManager
extends AbstractSubService
implements ExecutionControlManager {
    protected final ActivityManager activityManager;
    private SessionFactory sessionFactory;

    public AbstractExecutionControlManager(AbstractADEPT2Service service, ActivityManager activityManager) {
        super(service);
        this.activityManager = activityManager;
    }

    public void init(SessionFactory sf) {
        this.sessionFactory = sf;
    }

    public ExecutionControlProperties getExecutionControlProperties(SessionToken session, EBPInstanceReference activity) {
        super.sessionActive(session);
        try {
            ExecutionControlProperties executionControlProperties = this.activityManager.getExecutionControlProperties(session, activity);
            return executionControlProperties;
        }
        finally {
            super.sessionFinished(session);
        }
    }

    @Override
    public void abortActivity(SessionToken session, EBPInstanceReference activity, long timeToRespond) {
        block12: {
            super.sessionActive(session);
            try {
                boolean interrupted;
                block13: {
                    ActivityState state;
                    interrupted = false;
                    if (this.activityManager.interruptRegisteringThread(session, activity)) {
                        try {
                            if (timeToRespond <= 0L) break block12;
                            interrupted = Thread.interrupted();
                            ActivityState state2 = this.waitForTermination(session, activity, timeToRespond);
                            boolean bl = state2 == null || state2.getState() == ActivityState.State.TERMINATED;
                            if (interrupted) {
                                Thread.currentThread().interrupt();
                            }
                            break block12;
                        }
                        catch (InterruptedException interruptedException) {
                            String msg = "Interrupted while waiting for registered activity '%s' to abort its pre-start. Aborting wait. This may lead to an inconsistent state.";
                            this.logger.info(String.format(msg, activity));
                            Thread.currentThread().interrupt();
                        }
                        break block12;
                    }
                    this.sendKillMessage(session, activity);
                    this.logger.info(String.format("Sent kill signal to activity %s.", activity));
                    if (timeToRespond < 0L) break block12;
                    interrupted = Thread.interrupted();
                    if (timeToRespond <= 0L || (state = this.waitForTermination(session, activity, timeToRespond)) != null && state.getState() != ActivityState.State.TERMINATED) break block13;
                    String msg = "Activity '%s' successfully aborted.";
                    this.logger.fine(String.format(msg, activity));
                    return;
                }
                try {
                    if (interrupted) {
                        Thread.currentThread().interrupt();
                    }
                }
                catch (InterruptedException interruptedException) {
                    String msg = "Interrupted while waiting for activity '%s' to abort. Trying to kill the activity.";
                    this.logger.info(String.format(msg, activity));
                    Thread.currentThread().interrupt();
                }
                this.killActivity(session, activity);
            }
            finally {
                super.sessionFinished(session);
            }
        }
    }

    @Override
    public void resetActivity(SessionToken session, EBPInstanceReference activity) {
        super.sessionActive(session);
        try {
            ExecutionControlProperties ecps = this.activityManager.getExecutionControlProperties(session, activity);
            if (ecps == null) {
                ActivityState state = this.activityManager.getActivityState(session, activity);
                String msg = state != null && state.getState() == ActivityState.State.REGISTERED ? String.format("Tried to reset the activity '%s' which is registered but not running yet.", activity) : String.format("Tried to reset the activity '%s' which is not running any more or not yet known.", activity);
                throw new IllegalArgumentException(msg);
            }
            if (!ecps.isResettable()) {
                String msg = String.format("Tried to reset the activity '%s' which is not resettable!", activity);
                throw new IllegalArgumentException(msg);
            }
            this.sendResetMessage(session, activity);
            this.logger.info(String.format("Instructed activity %s to reset.", activity));
        }
        finally {
            super.sessionFinished(session);
        }
    }

    @Override
    public void finishActivity(SessionToken session, EBPInstanceReference activity) {
        super.sessionActive(session);
        try {
            ExecutionControlProperties ecps = this.activityManager.getExecutionControlProperties(session, activity);
            if (ecps == null) {
                ActivityState state = this.activityManager.getActivityState(session, activity);
                String msg = state != null && state.getState() == ActivityState.State.REGISTERED ? String.format("Tried to close the activity '%s' which is registered but not running yet.", activity) : String.format("Tried to close the activity '%s' which is not running any more or not yet known.", activity);
                throw new IllegalArgumentException(msg);
            }
            if (!ecps.isClosable()) {
                String msg = String.format("Tried to close the activity '%s' which is not closable!", activity);
                throw new IllegalArgumentException(msg);
            }
            this.sendCloseMessage(session, activity);
            this.logger.info(String.format("Instructed activity %s to finish.", activity));
        }
        finally {
            super.sessionFinished(session);
        }
    }

    @Override
    public void suspendActivity(SessionToken session, EBPInstanceReference activity) {
        super.sessionActive(session);
        try {
            ExecutionControlProperties ecps = this.activityManager.getExecutionControlProperties(session, activity);
            if (ecps == null) {
                ActivityState state = this.activityManager.getActivityState(session, activity);
                String msg = state != null && state.getState() == ActivityState.State.REGISTERED ? String.format("Tried to suspend the activity '%s' which is registered but not running yet.", activity) : String.format("Tried to suspend the activity '%s' which is not running any more or not yet known.", activity);
                throw new IllegalArgumentException(msg);
            }
            if (!ecps.isSuspensible()) {
                String msg = String.format("Tried to suspend the activity '%s' which is not suspensible!", activity);
                throw new IllegalArgumentException(msg);
            }
            this.sendSuspendMessage(session, activity);
            this.logger.info(String.format("Instructed activity %s to suspend.", activity));
        }
        finally {
            super.sessionFinished(session);
        }
    }

    @Override
    public boolean isRunning(SessionToken session, EBPInstanceReference activity) {
        super.sessionActive(session);
        try {
            ActivityState activityState = this.getActivityState(session, activity);
            boolean bl = activityState != null && activityState.getState() == ActivityState.State.RUNNING;
            return bl;
        }
        finally {
            super.sessionFinished(session);
        }
    }

    public ActivityState getActivityState(SessionToken session, EBPInstanceReference activity) {
        super.sessionActive(session);
        try {
            ActivityState activityState = this.activityManager.getActivityState(session, activity);
            return activityState;
        }
        finally {
            super.sessionFinished(session);
        }
    }

    @Override
    public Set<EBPInstanceReference> getRunningActivities(SessionToken session) {
        super.sessionActive(session);
        try {
            Set<EBPInstanceReference> ret = this.getActivities(session, new ActivityState.State[]{ActivityState.State.RUNNING}).keySet();
            Set<EBPInstanceReference> set = Collections.unmodifiableSet(ret);
            return set;
        }
        finally {
            super.sessionFinished(session);
        }
    }

    public Map<EBPInstanceReference, ActivityState> getActivities(SessionToken session, ActivityState.State[] states) {
        super.sessionActive(session);
        try {
            QualifiedAgent agent = this.sessionFactory.checkAndGetTopLevelAgent(session);
            Map<EBPInstanceReference, ActivityState> map = this.activityManager.getActivities(session, agent, states);
            return map;
        }
        catch (SecurityTokenIntegrityException stie) {
            String msg = "The designated session token for retrieving all activities failed the verification!";
            throw new ServiceAccessControlException(msg, stie);
        }
        finally {
            super.sessionFinished(session);
        }
    }

    @Override
    public void sendSignalToActivity(SessionToken session, EBPInstanceReference activity, int signal) {
        super.sessionActive(session);
        try {
            this.sendSignalMessage(session, activity, signal);
            this.logger.info(String.format("Sent signal %s to activity %s.", signal, activity));
        }
        finally {
            super.sessionFinished(session);
        }
    }

    @Override
    public ActivityState waitForTermination(SessionToken session, EBPInstanceReference activity, long timeToRespond) throws InterruptedException {
        super.sessionActive(session);
        try {
            ActivityState activityState = this.activityManager.waitForTermination(session, activity, timeToRespond);
            return activityState;
        }
        finally {
            super.sessionFinished(session);
        }
    }

    protected abstract void sendSuspendMessage(SessionToken var1, EBPInstanceReference var2);

    protected abstract void sendCloseMessage(SessionToken var1, EBPInstanceReference var2);

    protected abstract void sendResetMessage(SessionToken var1, EBPInstanceReference var2);

    protected abstract void sendKillMessage(SessionToken var1, EBPInstanceReference var2);

    protected abstract void sendSignalMessage(SessionToken var1, EBPInstanceReference var2, int var3);

    protected abstract void killActivity(SessionToken var1, EBPInstanceReference var2);

    protected SessionToken getChildSession(SessionToken parentSession) {
        return this.sessionFactory.getChildSession(parentSession, this.getURIs());
    }

    static final class ActivityPairComparator
    implements Comparator<Pair<EBPInstanceReference, ActivityState>>,
    Serializable {
        private static final long serialVersionUID = -7103135076132193865L;
        private final ActivityComparator actComp = new ActivityComparator();

        ActivityPairComparator() {
        }

        @Override
        public int compare(Pair<EBPInstanceReference, ActivityState> p1, Pair<EBPInstanceReference, ActivityState> p2) {
            return this.actComp.compare(p1.getFirst(), p2.getFirst());
        }

        @Override
        public boolean equals(Object other) {
            return other != null && this.getClass().equals(other.getClass());
        }

        public int hashCode() {
            return this.getClass().hashCode();
        }
    }
}

