/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.core.runtimemanager.commonimplementation;

import de.aristaflow.adept2.base.service.AbstractADEPT2Service;
import de.aristaflow.adept2.base.service.AbstractSubService;
import de.aristaflow.adept2.base.sessionmanagement.QualifiedAgent;
import de.aristaflow.adept2.base.sessionmanagement.SessionToken;
import de.aristaflow.adept2.core.client.ClientQA;
import de.aristaflow.adept2.core.runtimemanager.commonimplementation.ActivityContext;
import de.aristaflow.adept2.core.runtimemanager.commonimplementation.TerminationWaiter;
import de.aristaflow.adept2.model.common.ExecutionControlProperties;
import de.aristaflow.adept2.model.execution.ExecutionContext;
import de.aristaflow.adept2.model.processmodel.EBPInstanceReference;
import de.aristaflow.adept2.model.runtimeenvironment.ActivityState;
import de.aristaflow.adept2.model.runtimeenvironment.GUIContext;
import de.aristaflow.adept2.model.runtimeenvironment.TerminatedActivityState;
import de.aristaflow.adept2.util.ArgChecks;
import de.aristaflow.adept2.util.types.Pair;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class ActivityManager
extends AbstractSubService {
    protected final ReadWriteLock rwLock = new ReentrantReadWriteLock(true);
    protected final Map<EBPInstanceReference, TerminationWaiter> terminationWaiters = new HashMap<EBPInstanceReference, TerminationWaiter>();
    protected final Map<EBPInstanceReference, ActivityState> allActivities = new HashMap<EBPInstanceReference, ActivityState>();
    protected final Map<EBPInstanceReference, Pair<Thread, ExecutionContext>> registeredActivities = new HashMap<EBPInstanceReference, Pair<Thread, ExecutionContext>>();
    protected final Map<EBPInstanceReference, ActivityContext> activityDetails = new HashMap<EBPInstanceReference, ActivityContext>();

    public ActivityManager(AbstractADEPT2Service service) {
        super(service);
    }

    public boolean registerNewActivity(SessionToken session, EBPInstanceReference activity, ExecutionContext execContext) {
        ArgChecks.checkForNull(session, "session");
        ArgChecks.checkForNull(activity, "activity");
        ArgChecks.checkForNull(execContext, "execContext");
        super.sessionActive(session);
        try {
            Lock writeLock = this.rwLock.writeLock();
            writeLock.lock();
            try {
                boolean ret;
                if (this.allActivities.containsKey(activity)) {
                    ret = false;
                } else {
                    this.allActivities.put(activity, new ActivityState(ActivityState.State.REGISTERED));
                    this.registeredActivities.put(activity, new Pair<Thread, ExecutionContext>(Thread.currentThread(), execContext));
                    ret = true;
                }
                boolean bl = ret;
                writeLock.unlock();
                return bl;
            }
            catch (Throwable throwable) {
                writeLock.unlock();
                throw throwable;
            }
        }
        finally {
            super.sessionFinished(session);
        }
    }

    public void activityInitialising(SessionToken session, EBPInstanceReference activity, String sessionID, GUIContext guiContext) {
        ArgChecks.checkForNull(session, "session");
        ArgChecks.checkForNull(activity, "activity");
        ArgChecks.checkForBlank(sessionID, "sessionID");
        ArgChecks.checkForNull(guiContext, "guiContext");
        super.sessionActive(session);
        try {
            Lock writeLock = this.rwLock.writeLock();
            writeLock.lock();
            try {
                this.allActivities.put(activity, new ActivityState(ActivityState.State.INITIALISING));
                Pair<Thread, ExecutionContext> context = this.registeredActivities.remove(activity);
                ActivityContext actContext = new ActivityContext(sessionID, activity, context.getSecond(), guiContext);
                this.activityDetails.put(activity, actContext);
            }
            finally {
                writeLock.unlock();
            }
        }
        finally {
            super.sessionFinished(session);
        }
    }

    public void activityRunning(SessionToken session, EBPInstanceReference activity, boolean resumed) {
        ArgChecks.checkForNull(activity, "activity");
        super.sessionActive(session);
        try {
            Lock writeLock = this.rwLock.writeLock();
            writeLock.lock();
            try {
                this.allActivities.put(activity, new ActivityState(ActivityState.State.RUNNING));
                this.activityDetails.get(activity).getSessionID();
            }
            finally {
                writeLock.unlock();
            }
        }
        finally {
            super.sessionFinished(session);
        }
    }

    public void activitySignalled(SessionToken session, String sessionID, int signal) {
        ArgChecks.checkForNull(session, "session");
        ArgChecks.checkForBlank(sessionID, "sessionID");
        super.sessionActive(session);
        try {
            EBPInstanceReference activity = null;
            Lock writeLock = this.rwLock.writeLock();
            writeLock.lock();
            try {
                for (Map.Entry<EBPInstanceReference, ActivityContext> actDetails : this.activityDetails.entrySet()) {
                    if (!actDetails.getValue().getSessionID().equals(sessionID)) continue;
                    activity = actDetails.getKey();
                }
                if (this.allActivities.get(activity).getState() == ActivityState.State.RUNNING) {
                    this.allActivities.put(activity, new ActivityState(signal));
                }
            }
            finally {
                writeLock.unlock();
            }
        }
        finally {
            super.sessionFinished(session);
        }
    }

    public ActivityContext activityTerminating(SessionToken session, String sessionID) {
        ArgChecks.checkForNull(session, "session");
        ArgChecks.checkForBlank(sessionID, "sessionID");
        super.sessionActive(session);
        try {
            EBPInstanceReference activity = null;
            Lock writeLock = this.rwLock.writeLock();
            writeLock.lock();
            try {
                for (Map.Entry<EBPInstanceReference, ActivityContext> actDetails : this.activityDetails.entrySet()) {
                    if (!actDetails.getValue().getSessionID().equals(sessionID)) continue;
                    activity = actDetails.getKey();
                }
                ActivityContext activityContext = this.activityTerminating(session, activity);
                writeLock.unlock();
                return activityContext;
            }
            catch (Throwable throwable) {
                writeLock.unlock();
                throw throwable;
            }
        }
        finally {
            super.sessionFinished(session);
        }
    }

    public ActivityContext activityTerminating(SessionToken session, EBPInstanceReference activity) {
        ArgChecks.checkForNull(session, "session");
        super.sessionActive(session);
        try {
            Lock writeLock = this.rwLock.writeLock();
            writeLock.lock();
            try {
                ActivityContext ret = this.activityDetails.get(activity);
                if (ret != null) {
                    this.allActivities.put(activity, new ActivityState(ActivityState.State.TERMINATING));
                }
                ActivityContext activityContext = ret;
                writeLock.unlock();
                return activityContext;
            }
            catch (Throwable throwable) {
                writeLock.unlock();
                throw throwable;
            }
        }
        finally {
            super.sessionFinished(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void activityTerminated(SessionToken session, EBPInstanceReference activity, TerminatedActivityState terminatedState) {
        ArgChecks.checkForNull(session, "session");
        super.sessionActive(session);
        try {
            Lock writeLock = this.rwLock.writeLock();
            writeLock.lock();
            try {
                this.allActivities.remove(activity);
                this.activityDetails.remove(activity);
                this.registeredActivities.remove(activity);
                Map<EBPInstanceReference, TerminationWaiter> map = this.terminationWaiters;
                synchronized (map) {
                    TerminationWaiter waiter = this.terminationWaiters.get(activity);
                    if (waiter != null) {
                        waiter.signalTermination(terminatedState);
                    }
                }
            }
            finally {
                writeLock.unlock();
            }
        }
        finally {
            super.sessionFinished(session);
        }
    }

    public ActivityState getActivityState(SessionToken session, EBPInstanceReference activity) {
        ArgChecks.checkForNull(session, "session");
        super.sessionActive(session);
        try {
            Lock readLock = this.rwLock.readLock();
            readLock.lock();
            try {
                ActivityState activityState = this.allActivities.get(activity);
                readLock.unlock();
                return activityState;
            }
            catch (Throwable throwable) {
                readLock.unlock();
                throw throwable;
            }
        }
        finally {
            super.sessionFinished(session);
        }
    }

    public Map<EBPInstanceReference, ActivityState> getActivities(SessionToken session, ActivityState.State[] states) {
        ArgChecks.checkForNull(session, "session");
        ArgChecks.checkForNull(states, "states");
        super.sessionActive(session);
        try {
            HashMap<EBPInstanceReference, ActivityState> ret = new HashMap<EBPInstanceReference, ActivityState>();
            Lock readLock = this.rwLock.readLock();
            readLock.lock();
            try {
                for (Map.Entry<EBPInstanceReference, ActivityState> activity : this.allActivities.entrySet()) {
                    ActivityState.State[] stateArray = states;
                    int n = states.length;
                    int n2 = 0;
                    while (n2 < n) {
                        ActivityState.State state = stateArray[n2];
                        if (activity.getValue().getState() == state) {
                            ret.put(activity.getKey(), activity.getValue());
                        }
                        ++n2;
                    }
                }
                Map<EBPInstanceReference, ActivityState> map = Collections.unmodifiableMap(ret);
                readLock.unlock();
                return map;
            }
            catch (Throwable throwable) {
                readLock.unlock();
                throw throwable;
            }
        }
        finally {
            super.sessionFinished(session);
        }
    }

    public Map<EBPInstanceReference, ActivityState> getAllActivities(SessionToken session, QualifiedAgent agent) {
        ArgChecks.checkForNull(session, "session");
        ArgChecks.checkForNull(agent, "agent");
        super.sessionActive(session);
        try {
            ClientQA clientQA = new ClientQA(agent);
            HashMap<EBPInstanceReference, ActivityState> ret = new HashMap<EBPInstanceReference, ActivityState>();
            Lock readLock = this.rwLock.readLock();
            readLock.lock();
            try {
                for (Map.Entry<EBPInstanceReference, ActivityContext> entry : this.activityDetails.entrySet()) {
                    if (!clientQA.getAgent().equals(entry.getValue().getExecutionContext().getAgent())) continue;
                    ret.put(entry.getKey(), this.allActivities.get(entry.getKey()));
                }
                for (Map.Entry<EBPInstanceReference, Object> entry : this.registeredActivities.entrySet()) {
                    if (!clientQA.getAgent().equals(((ExecutionContext)((Pair)entry.getValue()).getSecond()).getAgent())) continue;
                    ret.put(entry.getKey(), this.allActivities.get(entry.getKey()));
                }
                Map<EBPInstanceReference, ActivityState> map = Collections.unmodifiableMap(ret);
                readLock.unlock();
                return map;
            }
            catch (Throwable throwable) {
                readLock.unlock();
                throw throwable;
            }
        }
        finally {
            super.sessionFinished(session);
        }
    }

    public Map<EBPInstanceReference, ActivityState> getActivities(SessionToken session, QualifiedAgent agent, ActivityState.State[] states) {
        ArgChecks.checkForNull(session, "session");
        ArgChecks.checkForNull(agent, "agent");
        ArgChecks.checkForNull(states, "states");
        super.sessionActive(session);
        try {
            Lock readLock = this.rwLock.readLock();
            readLock.lock();
            try {
                Map<EBPInstanceReference, ActivityState> allAct = this.getAllActivities(session, agent);
                HashMap<EBPInstanceReference, ActivityState> ret = new HashMap<EBPInstanceReference, ActivityState>(allAct.size());
                for (Map.Entry<EBPInstanceReference, ActivityState> activity : allAct.entrySet()) {
                    ActivityState.State[] stateArray = states;
                    int n = states.length;
                    int n2 = 0;
                    while (n2 < n) {
                        ActivityState.State state = stateArray[n2];
                        if (activity.getValue().getState() == state) {
                            ret.put(activity.getKey(), activity.getValue());
                        }
                        ++n2;
                    }
                }
                Map<EBPInstanceReference, ActivityState> map = Collections.unmodifiableMap(ret);
                readLock.unlock();
                return map;
            }
            catch (Throwable throwable) {
                readLock.unlock();
                throw throwable;
            }
        }
        finally {
            super.sessionFinished(session);
        }
    }

    public ExecutionControlProperties getExecutionControlProperties(SessionToken session, EBPInstanceReference activity) {
        ArgChecks.checkForNull(session, "session");
        super.sessionActive(session);
        try {
            Lock readLock = this.rwLock.readLock();
            readLock.lock();
            try {
                ActivityContext ret = this.activityDetails.get(activity);
                ExecutionControlProperties executionControlProperties = ret != null ? ret.getExecutionContext().getEBPInstance().getExecutionControlProperties() : null;
                readLock.unlock();
                return executionControlProperties;
            }
            catch (Throwable throwable) {
                readLock.unlock();
                throw throwable;
            }
        }
        finally {
            super.sessionFinished(session);
        }
    }

    public String getSessionID(SessionToken session, EBPInstanceReference activity) {
        ArgChecks.checkForNull(session, "session");
        super.sessionActive(session);
        try {
            Lock readLock = this.rwLock.readLock();
            readLock.lock();
            try {
                ActivityContext ret = this.activityDetails.get(activity);
                String string = ret != null ? ret.getSessionID() : null;
                readLock.unlock();
                return string;
            }
            catch (Throwable throwable) {
                readLock.unlock();
                throw throwable;
            }
        }
        finally {
            super.sessionFinished(session);
        }
    }

    public boolean interruptRegisteringThread(SessionToken session, EBPInstanceReference activity) {
        ArgChecks.checkForNull(session, "session");
        super.sessionActive(session);
        try {
            Lock readLock = this.rwLock.readLock();
            readLock.lock();
            try {
                boolean ret = false;
                Pair<Thread, ExecutionContext> actContext = this.registeredActivities.get(activity);
                if (actContext != null) {
                    actContext.getFirst().interrupt();
                    ret = true;
                }
                boolean bl = ret;
                readLock.unlock();
                return bl;
            }
            catch (Throwable throwable) {
                readLock.unlock();
                throw throwable;
            }
        }
        finally {
            super.sessionFinished(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ActivityState waitForTermination(SessionToken session, EBPInstanceReference activity, long timeout) throws InterruptedException {
        ArgChecks.checkForNull(session, "session");
        super.sessionActive(session);
        try {
            TerminationWaiter waiter;
            Lock readLock;
            ActivityState ret;
            block20: {
                ret = null;
                readLock = this.rwLock.readLock();
                readLock.lock();
                try {
                    if (this.allActivities.containsKey(activity)) {
                        Map<EBPInstanceReference, TerminationWaiter> map = this.terminationWaiters;
                        synchronized (map) {
                            waiter = this.terminationWaiters.containsKey(activity) ? this.terminationWaiters.get(activity) : new TerminationWaiter();
                            break block20;
                        }
                    }
                    waiter = null;
                }
                finally {
                    readLock.unlock();
                }
            }
            if (waiter != null) {
                int remWaiters = waiter.await(timeout, TimeUnit.MILLISECONDS);
                Map<EBPInstanceReference, TerminationWaiter> map = this.terminationWaiters;
                synchronized (map) {
                    if (remWaiters < 1) {
                        this.terminationWaiters.remove(activity);
                    } else {
                        ret = waiter.getFinalState();
                    }
                }
                if (ret == null) {
                    readLock.lock();
                    try {
                        ret = this.allActivities.get(activity);
                    }
                    finally {
                        readLock.unlock();
                    }
                }
            }
            TerminatedActivityState terminatedActivityState = ret;
            return terminatedActivityState;
        }
        finally {
            super.sessionFinished(session);
        }
    }
}

