/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.core.runtimemanager.commonimplementation;

import de.aristaflow.adept2.base.configuration.AbortServiceException;
import de.aristaflow.adept2.base.configuration.ConfigurationException;
import de.aristaflow.adept2.base.service.AbstractADEPT2Service;
import de.aristaflow.adept2.base.service.AbstractSubService;
import de.aristaflow.adept2.base.service.Registry;
import de.aristaflow.adept2.base.sessionmanagement.SessionFactory;
import de.aristaflow.adept2.base.sessionmanagement.SessionToken;
import de.aristaflow.adept2.core.client.implementation.PersistingActivityTermination;
import de.aristaflow.adept2.core.runtimemanager.ResumingRuntimeManager;
import de.aristaflow.adept2.core.runtimemanager.commonimplementation.ActivityContext;
import de.aristaflow.adept2.core.runtimemanager.commonimplementation.ActivityManager;
import de.aristaflow.adept2.core.runtimemanager.commonimplementation.ApplicationSignalling;
import de.aristaflow.adept2.model.execution.InvalidActivityStateException;
import de.aristaflow.adept2.model.globals.ProcessConstants;
import de.aristaflow.adept2.model.processmodel.EBPInstanceReference;
import de.aristaflow.adept2.model.runtimeenvironment.TerminatedActivityState;
import de.aristaflow.adept2.util.Adept2ThreadFactory;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;

public class SimpleApplicationSignalling
extends AbstractSubService
implements ApplicationSignalling {
    protected final ActivityManager activityManager;
    protected final Set<ResumingRuntimeManager.AutomaticResumer> automaticResumer;
    protected final ExecutorService resumeNotification;
    protected final PersistingActivityTermination activityTermination;

    public SimpleApplicationSignalling(AbstractADEPT2Service service, Registry registry, ActivityManager activityManager, boolean persisting) throws ConfigurationException {
        super(service);
        this.activityTermination = new PersistingActivityTermination(service, registry, persisting);
        this.activityManager = activityManager;
        this.resumeNotification = Executors.newSingleThreadExecutor(new Adept2ThreadFactory("ApplicationSignalling_ResumeNotification", this.logger));
        this.automaticResumer = Collections.synchronizedSet(new HashSet());
    }

    public void init(SessionFactory sessionFactory) {
        this.activityTermination.init(sessionFactory);
    }

    @Override
    public void start() throws AbortServiceException {
        this.activityTermination.start();
    }

    @Override
    public void shutdown() {
        this.logger.info("Shutting down ApplicationSignalling...");
        this.activityTermination.shutdown();
        this.terminateResumeNotification(false);
        this.terminateActivityTermination(false);
        this.logger.info("done.");
    }

    @Override
    public void emergencyShutdown() {
        this.logger.info("Emergency shut down ApplicationSignalling...");
        this.activityTermination.emergencyShutdown();
        this.terminateResumeNotification(true);
        this.terminateActivityTermination(true);
        this.logger.info("done.");
    }

    protected void terminateResumeNotification(boolean emergency) {
        long timeToWait;
        if (emergency) {
            this.resumeNotification.shutdownNow();
            timeToWait = 5L;
        } else {
            this.resumeNotification.shutdown();
            timeToWait = 10L;
        }
        try {
            if (!this.resumeNotification.awaitTermination(timeToWait, TimeUnit.SECONDS)) {
                String msg = String.format("Thread pool of ApplicationSignalling did not %sshut down in time! Continuing service shutdown.", emergency ? "urgently " : "");
                this.logger.warning(msg);
            }
        }
        catch (InterruptedException interruptedException) {}
    }

    protected void terminateActivityTermination(boolean emergency) {
        if (emergency) {
            this.activityTermination.emergencyShutdown();
        } else {
            this.activityTermination.shutdown();
        }
    }

    @Override
    public void applicationClosed(SessionToken session, String sessionID) {
        super.sessionActive(session);
        try {
            String msg = "Application closed - SID '%s'.";
            this.logger.info(String.format(msg, sessionID));
            ActivityContext context = this.activityManager.activityTerminating(session, sessionID);
            if (context == null) {
                msg = "Could not signal the closing of the activity with session ID '%s' since the corresponding activity does not seem to run any more. However, check the activity in the process instance for an inconsistent state.";
                this.logger.warning(String.format(msg, sessionID));
                return;
            }
            EBPInstanceReference activity = context.getActivity();
            try {
                try {
                    context.getGUIContext().close();
                    if (!context.getExecutionContext().getExecutionMode().equals((Object)ProcessConstants.ExecutionMode.VIEW_ONLY)) {
                        this.activityTermination.activityFinished(session, activity, context.getExecutionContext().getDataContainer());
                        msg = "Informed the executionManager %s about the finish of the activity %s.";
                        msg = String.format(msg, Arrays.toString(activity.getExecutionManagerURIs()), activity);
                        this.logger.info(msg);
                    }
                }
                catch (InvalidActivityStateException e) {
                    msg = "Couldn't set activity %s to finished.";
                    this.logger.log(Level.SEVERE, String.format(msg, activity), e);
                    TerminatedActivityState state = new TerminatedActivityState(TerminatedActivityState.TerminatedState.CLOSED);
                    this.activityManager.activityTerminated(session, activity, state);
                }
            }
            finally {
                TerminatedActivityState state = new TerminatedActivityState(TerminatedActivityState.TerminatedState.CLOSED);
                this.activityManager.activityTerminated(session, activity, state);
            }
        }
        finally {
            super.sessionFinished(session);
        }
    }

    @Override
    public void applicationSuspended(SessionToken session, String sessionID) {
        super.sessionActive(session);
        try {
            TerminatedActivityState state = new TerminatedActivityState(TerminatedActivityState.TerminatedState.SUSPENDED);
            this.applicationSuspended(session, sessionID, state);
        }
        finally {
            super.sessionFinished(session);
        }
    }

    protected void applicationSuspended(SessionToken session, String sessionID, TerminatedActivityState state) {
        String msg = "Application suspended - SID '%s'.";
        this.logger.info(String.format(msg, sessionID));
        ActivityContext context = this.activityManager.activityTerminating(session, sessionID);
        if (context == null) {
            msg = "Could not signal the suspension of the activity with session ID '%s' since the corresponding activity does not seem to run any more. However, check the activity in the process instance for an inconsistent state.";
            this.logger.warning(String.format(msg, sessionID));
            return;
        }
        EBPInstanceReference activity = context.getActivity();
        try {
            try {
                context.getGUIContext().close();
                if (!context.getExecutionContext().getExecutionMode().equals((Object)ProcessConstants.ExecutionMode.VIEW_ONLY)) {
                    this.activityTermination.activitySuspended(session, activity, context.getExecutionContext().getDataContainer());
                    msg = "Informed the executionManager %s about the suspension of the activity %s.";
                    msg = String.format(msg, Arrays.toString(activity.getExecutionManagerURIs()), activity);
                    this.logger.info(msg);
                }
            }
            catch (InvalidActivityStateException e) {
                msg = "Couldn't set activity %s to suspended.";
                this.logger.log(Level.SEVERE, String.format(msg, activity), e);
                this.activityManager.activityTerminated(session, activity, state);
            }
        }
        finally {
            this.activityManager.activityTerminated(session, activity, state);
        }
    }

    @Override
    public void applicationSuspended(SessionToken session, String sessionID, final long timeout) {
        super.sessionActive(session);
        try {
            String msg = "Application suspended for resuming in '%s' ms - SID '%s'.";
            this.logger.info(String.format(msg, timeout, sessionID));
            ActivityContext context = this.activityManager.activityTerminating(session, sessionID);
            if (context == null) {
                msg = "Could not signal the suspension of the activity with session ID '%s' since the corresponding activity does not seem to run any more. However, check the activity in the process instance for an inconsistent state.";
                this.logger.warning(String.format(msg, sessionID));
                return;
            }
            final EBPInstanceReference activity = context.getActivity();
            TerminatedActivityState state = new TerminatedActivityState(timeout);
            this.applicationSuspended(session, sessionID, state);
            if (!context.getExecutionContext().getExecutionMode().equals((Object)ProcessConstants.ExecutionMode.VIEW_ONLY)) {
                if (this.resumeNotification.isShutdown()) {
                    this.logger.info("The executor service that notifies the automatic resumer(s) is shut down, therefore no update will be sent. The activity must be resumed manually!");
                } else {
                    this.resumeNotification.execute(new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            for (ResumingRuntimeManager.AutomaticResumer resumer : new HashSet<ResumingRuntimeManager.AutomaticResumer>(SimpleApplicationSignalling.this.automaticResumer)) {
                                Set<ResumingRuntimeManager.AutomaticResumer> set = SimpleApplicationSignalling.this.automaticResumer;
                                synchronized (set) {
                                    if (SimpleApplicationSignalling.this.automaticResumer.contains(resumer)) {
                                        resumer.resumeActivity(activity, timeout);
                                    }
                                }
                            }
                        }
                    });
                }
            }
        }
        finally {
            super.sessionFinished(session);
        }
    }

    @Override
    public void applicationReset(SessionToken session, String sessionID) {
        super.sessionActive(session);
        try {
            String msg = "Application reset - SID '%s'.";
            this.logger.info(String.format(msg, sessionID));
            ActivityContext context = this.activityManager.activityTerminating(session, sessionID);
            if (context == null) {
                msg = "Could not signal the reset of the activity with session ID '%s' since the corresponding activity does not seem to run any more. However, check the activity in the process instance for an inconsistent state.";
                this.logger.warning(String.format(msg, sessionID));
                return;
            }
            EBPInstanceReference activity = context.getActivity();
            try {
                try {
                    context.getGUIContext().close();
                    if (!context.getExecutionContext().getExecutionMode().equals((Object)ProcessConstants.ExecutionMode.VIEW_ONLY)) {
                        this.activityTermination.activityReset(session, activity);
                        msg = "Informed the executionManager %s about the reset of the activity %s.";
                        msg = String.format(msg, Arrays.toString(activity.getExecutionManagerURIs()), activity);
                        this.logger.info(msg);
                    }
                }
                catch (InvalidActivityStateException e) {
                    msg = "Couldn't set activity %s to reset.";
                    this.logger.log(Level.SEVERE, String.format(msg, activity), e);
                    TerminatedActivityState state = new TerminatedActivityState(TerminatedActivityState.TerminatedState.RESET);
                    this.activityManager.activityTerminated(session, activity, state);
                }
            }
            finally {
                TerminatedActivityState state = new TerminatedActivityState(TerminatedActivityState.TerminatedState.RESET);
                this.activityManager.activityTerminated(session, activity, state);
            }
        }
        finally {
            super.sessionFinished(session);
        }
    }

    @Override
    public void applicationFailed(SessionToken session, String sessionID, String errorMessage, String errorState, long errorCode) {
        super.sessionActive(session);
        try {
            String msg = "Application failed - SID '%s'.";
            this.logger.info(String.format(msg, sessionID));
            ActivityContext context = this.activityManager.activityTerminating(session, sessionID);
            if (context == null) {
                msg = "Could not signal the failing of the activity with session ID '%s' since the corresponding activity does not seem to run any more. However, check the activity in the process instance for an inconsistent state.";
                this.logger.warning(String.format(msg, sessionID));
                return;
            }
            EBPInstanceReference activity = context.getActivity();
            try {
                try {
                    context.getGUIContext().close();
                    if (!context.getExecutionContext().getExecutionMode().equals((Object)ProcessConstants.ExecutionMode.VIEW_ONLY)) {
                        this.activityTermination.activityFailed(session, activity, context.getExecutionContext().getDataContainer(), errorMessage, errorState, errorCode);
                        this.logger.info(String.format("Failed activity %s!", activity));
                    }
                }
                catch (InvalidActivityStateException e) {
                    msg = "Couldn't set activity %s to failed.";
                    this.logger.log(Level.SEVERE, String.format(msg, activity), e);
                    TerminatedActivityState state = new TerminatedActivityState(errorMessage, errorState, errorCode);
                    this.activityManager.activityTerminated(session, activity, state);
                }
            }
            finally {
                TerminatedActivityState state = new TerminatedActivityState(errorMessage, errorState, errorCode);
                this.activityManager.activityTerminated(session, activity, state);
            }
        }
        finally {
            super.sessionFinished(session);
        }
    }

    @Override
    public void applicationSignaled(SessionToken session, String sessionID, int signal) {
        super.sessionActive(session);
        try {
            this.logger.info(String.format("Application signaled %d in session %s!", signal, sessionID));
            this.activityManager.activitySignalled(session, sessionID, signal);
        }
        finally {
            super.sessionFinished(session);
        }
    }

    public void deregisterAutomaticResumer(ResumingRuntimeManager.AutomaticResumer automaticResumer) {
        this.automaticResumer.remove(automaticResumer);
    }

    public void registerAutomaticResumer(ResumingRuntimeManager.AutomaticResumer automaticResumer) {
        this.automaticResumer.add(automaticResumer);
    }
}

