/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.core.runtimemanager.commonimplementation;

import de.aristaflow.adept2.base.sessionmanagement.SessionFactory;
import de.aristaflow.adept2.base.sessionmanagement.SessionToken;
import de.aristaflow.adept2.core.runtimemanager.ExecutionControlManager;
import de.aristaflow.adept2.core.runtimemanager.commonimplementation.AbstractExecutionControlManager;
import de.aristaflow.adept2.model.common.ExecutionControlProperties;
import de.aristaflow.adept2.model.globals.ProcessConstants;
import de.aristaflow.adept2.model.processmodel.EBPInstanceReference;
import de.aristaflow.adept2.model.runtimeenvironment.ActivityState;
import de.aristaflow.adept2.util.LoggerTools;
import java.net.URI;
import java.util.concurrent.Callable;
import java.util.logging.Logger;

public class TerminationExecutor
implements Callable<ProcessConstants.NodeState> {
    protected final Logger logger = LoggerTools.getLogger(this);
    protected final ExecutionControlManager controlMgr;
    protected final EBPInstanceReference activity;
    protected final ExecutionControlProperties execContProps;
    protected final SessionToken baseSession;
    protected final SessionFactory sessionFactory;
    protected final URI[] rtURIs;
    protected final long escalationTime;
    protected final boolean forceTermination;

    public TerminationExecutor(SessionToken baseSession, SessionFactory sessionFactory, URI[] rtURIs, EBPInstanceReference activity, ExecutionControlProperties execContProps, long escalationTime, boolean forceTermination, ExecutionControlManager controlMgr) {
        this.baseSession = baseSession;
        if (sessionFactory != null && rtURIs != null) {
            this.sessionFactory = sessionFactory;
            this.rtURIs = (URI[])rtURIs.clone();
        } else {
            this.sessionFactory = null;
            this.rtURIs = null;
        }
        this.activity = activity;
        this.execContProps = execContProps;
        this.forceTermination = forceTermination;
        this.escalationTime = escalationTime;
        this.controlMgr = controlMgr;
    }

    protected SessionToken getSessionToken() {
        SessionToken ret = this.sessionFactory != null ? this.sessionFactory.getChildSession(this.baseSession, this.rtURIs) : this.baseSession;
        return ret;
    }

    protected boolean activityTerminated(SessionToken session) {
        boolean ret = false;
        try {
            ret = this.controlMgr.waitForTermination(session, this.activity, this.escalationTime).getState() != ActivityState.State.RUNNING;
        }
        catch (InterruptedException interruptedException) {
            this.logger.info(String.format("Interrupted while waiting for the activity '%s' to terminate. Escalating early.", this.activity));
        }
        return ret;
    }

    @Override
    public ProcessConstants.NodeState call() {
        String msg = String.format("Terminating activity '%s'.", this.activity);
        this.logger.fine(msg);
        SessionToken session = this.getSessionToken();
        if (this.controlMgr instanceof AbstractExecutionControlManager) {
            ActivityState state = ((AbstractExecutionControlManager)this.controlMgr).getActivityState(session, this.activity);
            if (state == null || state.getState() == ActivityState.State.TERMINATING) {
                msg = "Activity '%s' is not registered in the activity manager any more. It has already been terminated or is currently terminating.";
                this.logger.fine(String.format(msg, this.activity));
                return null;
            }
        } else if (!this.controlMgr.isRunning(session, this.activity)) {
            msg = "Activity '%s' is not running in the activity manager any more. Expecting it to have terminated, although it may currently be terminating.";
            this.logger.fine(String.format(msg, this.activity));
            return null;
        }
        if (this.execContProps.isSuspensible()) {
            session = this.getSessionToken();
            this.logger.finer(String.format("Trying to suspend activity '%s'.", this.activity));
            try {
                this.controlMgr.suspendActivity(session, this.activity);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                msg = "Activity '%s' is not registered in the activity manager any more. It has already terminated. Aborting suspend.";
                this.logger.fine(String.format(msg, this.activity));
                return null;
            }
            if (this.activityTerminated(session)) {
                msg = "Activity '%s' successfully suspended.";
                this.logger.fine(String.format(msg, this.activity));
                return ProcessConstants.NodeState.NS_SUSPENDED;
            }
        }
        if (!this.forceTermination) {
            msg = "Activity '%s' could not be suspended, since termination is not forced, the activity keeps on running.";
            this.logger.finer(String.format(msg, this.activity));
            return ProcessConstants.NodeState.NS_RUNNING;
        }
        if (this.execContProps.isClosable()) {
            session = this.getSessionToken();
            this.logger.finer(String.format("Trying to close activity '%s'.", this.activity));
            try {
                this.controlMgr.finishActivity(session, this.activity);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                msg = "Activity '%s' is not registered in the activity manager any more. It has already terminated. Aborting closing.";
                this.logger.fine(String.format(msg, this.activity));
                return ProcessConstants.NodeState.NS_SUSPENDED;
            }
            if (this.activityTerminated(session)) {
                this.logger.fine(String.format("Activity '%s' successfully closed.", this.activity));
                return ProcessConstants.NodeState.NS_COMPLETED;
            }
        }
        if (this.execContProps.isResettable()) {
            session = this.getSessionToken();
            this.logger.finer(String.format("Trying to reset activity '%s'.", this.activity));
            try {
                this.controlMgr.resetActivity(session, this.activity);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                msg = "Activity '%s' is not registered in the activity manager any more. It has already terminated. Aborting resetting.";
                this.logger.fine(String.format(msg, this.activity));
                return ProcessConstants.NodeState.NS_COMPLETED;
            }
            if (this.activityTerminated(session)) {
                this.logger.fine(String.format("Activity '%s' successfully resetted.", this.activity));
                return ProcessConstants.NodeState.NS_ACTIVATED;
            }
        }
        this.logger.finer(String.format("Trying to abort activity '%s'.", this.activity));
        try {
            session = this.getSessionToken();
            this.controlMgr.abortActivity(session, this.activity, this.escalationTime);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            msg = "Activity '%s' is not registered in the activity manager any more. It has already terminated. Aborting aborting.";
            this.logger.fine(String.format(msg, this.activity));
            return ProcessConstants.NodeState.NS_ACTIVATED;
        }
        return ProcessConstants.NodeState.NS_FAILED;
    }
}

