/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.core.runtimemanager.commonimplementation;

import de.aristaflow.adept2.model.runtimeenvironment.TerminatedActivityState;
import de.aristaflow.adept2.util.ArgChecks;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public class TerminationWaiter {
    private final CountDownLatch latch = new CountDownLatch(1);
    private final AtomicInteger count = new AtomicInteger(1);
    private TerminatedActivityState finalState = null;

    public int await(long timeout, TimeUnit unit) throws InterruptedException {
        this.count.incrementAndGet();
        this.latch.await(timeout, unit);
        int ret = this.count.decrementAndGet();
        return ret;
    }

    public void signalTermination(TerminatedActivityState finalState) {
        ArgChecks.checkForNull(finalState, "finalState");
        this.finalState = finalState;
        this.latch.countDown();
    }

    public TerminatedActivityState getFinalState() {
        return this.finalState;
    }
}

