/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.core.runtimemanager.defaultimplementation;

import de.aristaflow.adept2.base.sessionmanagement.QualifiedAgent;
import de.aristaflow.adept2.core.client.ClientQA;
import de.aristaflow.adept2.core.runtimemanager.defaultimplementation.MessageReceivingExecutor;
import de.aristaflow.adept2.model.datamanagement.DataContainer;
import de.aristaflow.adept2.model.execution.ExecutionContext;
import de.aristaflow.adept2.model.processmodel.EBPInstanceReference;
import de.aristaflow.adept2.model.runtimeenvironment.GUIContext;
import de.aristaflow.adept2.util.LoggerTools;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Logger;

public class DefaultActivityManager {
    protected final Logger logger = LoggerTools.getLogger(this);
    private final ReadWriteLock rwLock = new ReentrantReadWriteLock(true);
    private final Map<EBPInstanceReference, ActivityContext> runningActivities = new HashMap<EBPInstanceReference, ActivityContext>();
    private final Map<EBPInstanceReference, CountDownLatch> terminationNotify = new HashMap<EBPInstanceReference, CountDownLatch>();

    protected DefaultActivityManager() {
    }

    public void registerNewActivityInstance(String sessionID, EBPInstanceReference ebpInstanceReference, ExecutionContext executionContext, GUIContext guiContext, MessageReceivingExecutor componentThread) {
        ActivityContext activityContext = new ActivityContext(sessionID, ebpInstanceReference, executionContext, guiContext, componentThread);
        Lock writeLock = this.rwLock.writeLock();
        writeLock.lock();
        try {
            if (this.runningActivities.containsKey(ebpInstanceReference)) {
                String message = String.format("There is already an Activity running for the EBPInstanceReference '%s'!", ebpInstanceReference);
                this.logger.severe(message);
                throw new IllegalArgumentException(message);
            }
            this.runningActivities.put(ebpInstanceReference, activityContext);
        }
        finally {
            writeLock.unlock();
        }
    }

    public void unregisterActivityInstance(EBPInstanceReference ebpInstanceReference) {
        Lock writeLock = this.rwLock.writeLock();
        writeLock.lock();
        try {
            if (!this.runningActivities.containsKey(ebpInstanceReference)) {
                String message = String.format("No Running Activity for EBPInstanceReference '%s'!", ebpInstanceReference);
                this.logger.severe(message);
                throw new IllegalArgumentException(message);
            }
            this.runningActivities.put(ebpInstanceReference, null);
        }
        finally {
            writeLock.unlock();
        }
    }

    public void activityTerminationSignalled(EBPInstanceReference ebpInstanceReference) {
        Lock writeLock = this.rwLock.writeLock();
        writeLock.lock();
        try {
            if (!this.runningActivities.containsKey(ebpInstanceReference)) {
                String message = String.format("No Running Activity for EBPInstanceReference '%s'!", ebpInstanceReference);
                this.logger.severe(message);
                throw new IllegalArgumentException(message);
            }
            this.runningActivities.remove(ebpInstanceReference);
            CountDownLatch termNotify = this.terminationNotify.remove(ebpInstanceReference);
            if (termNotify != null) {
                termNotify.countDown();
            }
        }
        finally {
            writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean waitForTermination(EBPInstanceReference ebpInstanceReference, long timeout) throws InterruptedException {
        CountDownLatch latch;
        boolean ret;
        block10: {
            ret = true;
            Lock readLock = this.rwLock.readLock();
            readLock.lock();
            try {
                if (this.runningActivities.containsKey(ebpInstanceReference)) {
                    Map<EBPInstanceReference, CountDownLatch> map = this.terminationNotify;
                    synchronized (map) {
                        if (this.terminationNotify.containsKey(ebpInstanceReference)) {
                            latch = this.terminationNotify.get(ebpInstanceReference);
                        } else {
                            latch = new CountDownLatch(1);
                            this.terminationNotify.put(ebpInstanceReference, latch);
                        }
                        break block10;
                    }
                }
                latch = null;
            }
            finally {
                readLock.unlock();
            }
        }
        if (latch != null) {
            ret = latch.await(timeout, TimeUnit.MILLISECONDS);
        }
        return ret;
    }

    public boolean isActive(EBPInstanceReference ebpInstanceReference) {
        Lock readLock = this.rwLock.readLock();
        readLock.lock();
        try {
            boolean bl = this.runningActivities.containsKey(ebpInstanceReference);
            return bl;
        }
        finally {
            readLock.unlock();
        }
    }

    public boolean isRunning(EBPInstanceReference ebpInstanceReference) {
        boolean isRunning = false;
        Lock readLock = this.rwLock.readLock();
        readLock.lock();
        try {
            ActivityContext activity = this.runningActivities.get(ebpInstanceReference);
            if (activity != null) {
                isRunning = activity.componentThread.isRunning();
            }
        }
        finally {
            readLock.unlock();
        }
        return isRunning;
    }

    public Set<EBPInstanceReference> getRunningActivities(QualifiedAgent agent) {
        ClientQA clientQA = new ClientQA(agent);
        HashSet<EBPInstanceReference> ret = new HashSet<EBPInstanceReference>();
        Lock readLock = this.rwLock.readLock();
        readLock.lock();
        try {
            for (Map.Entry<EBPInstanceReference, ActivityContext> running : this.runningActivities.entrySet()) {
                ActivityContext context = running.getValue();
                if (context == null || !clientQA.equals(context.executionContext.getAgent())) continue;
                ret.add(running.getKey());
            }
        }
        finally {
            readLock.unlock();
        }
        return Collections.unmodifiableSet(ret);
    }

    public EBPInstanceReference getEBPInstanceReference(String sessionID) {
        Lock readLock = this.rwLock.readLock();
        readLock.lock();
        try {
            for (ActivityContext activityContext : this.runningActivities.values()) {
                if (activityContext == null || !activityContext.sessionID.equals(sessionID)) continue;
                EBPInstanceReference eBPInstanceReference = activityContext.ebpInstanceReference;
                return eBPInstanceReference;
            }
        }
        finally {
            readLock.unlock();
        }
        String message = String.format("No Running Activity with sessionID '%s'!", sessionID);
        this.logger.severe(message);
        throw new IllegalArgumentException(message);
    }

    private ActivityContext getActivityContext(EBPInstanceReference ebpInstanceReference) {
        Lock readLock = this.rwLock.readLock();
        readLock.lock();
        try {
            ActivityContext activityContext = this.runningActivities.get(ebpInstanceReference);
            if (activityContext != null) {
                ActivityContext activityContext2 = activityContext;
                return activityContext2;
            }
        }
        finally {
            readLock.unlock();
        }
        String message = String.format("No Running Activity for EBPInstanceReference '%s'!", ebpInstanceReference);
        this.logger.severe(message);
        throw new IllegalArgumentException(message);
    }

    public ExecutionContext getExecutionContext(EBPInstanceReference ebpInstanceReference) {
        return this.getActivityContext((EBPInstanceReference)ebpInstanceReference).executionContext;
    }

    public DataContainer getDataContainer(EBPInstanceReference ebpInstanceReference) {
        return this.getActivityContext((EBPInstanceReference)ebpInstanceReference).executionContext.getDataContainer();
    }

    public GUIContext getGuiContext(EBPInstanceReference ebpInstanceReference) {
        return this.getActivityContext((EBPInstanceReference)ebpInstanceReference).guiContext;
    }

    public MessageReceivingExecutor getMessageReceiver(EBPInstanceReference ebpInstanceReference) {
        return this.getActivityContext((EBPInstanceReference)ebpInstanceReference).componentThread;
    }

    private static class ActivityContext {
        protected final String sessionID;
        protected final EBPInstanceReference ebpInstanceReference;
        protected final ExecutionContext executionContext;
        protected final GUIContext guiContext;
        protected final MessageReceivingExecutor componentThread;

        public ActivityContext(String sessionID, EBPInstanceReference ebpInstanceReference, ExecutionContext executionContext, GUIContext guiContext, MessageReceivingExecutor componentThread) {
            this.sessionID = sessionID;
            this.ebpInstanceReference = ebpInstanceReference;
            this.executionContext = executionContext;
            this.guiContext = guiContext;
            this.componentThread = componentThread;
        }
    }
}

