/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.core.runtimemanager.defaultimplementation;

import de.aristaflow.adept2.base.communication.Message;
import de.aristaflow.adept2.base.communication.MessageReceiver;
import de.aristaflow.adept2.base.sessionmanagement.ClientSessionFactory;
import de.aristaflow.adept2.base.sessionmanagement.SessionToken;
import de.aristaflow.adept2.core.runtimemanager.defaultimplementation.ComponentContext;
import de.aristaflow.adept2.core.runtimemanager.defaultimplementation.MessageReceivingExecutor;
import de.aristaflow.adept2.core.runtimemanager.messages.executor.ApplicationClosedMessage;
import de.aristaflow.adept2.core.runtimemanager.messages.executor.ApplicationFailedMessage;
import de.aristaflow.adept2.core.runtimemanager.messages.executor.ApplicationResetMessage;
import de.aristaflow.adept2.core.runtimemanager.messages.executor.ApplicationSignaledMessage;
import de.aristaflow.adept2.core.runtimemanager.messages.executor.ApplicationSuspendedMessage;
import de.aristaflow.adept2.core.runtimemanager.messages.executor.ApplicationSuspendedTimeoutMessage;
import de.aristaflow.adept2.core.runtimemanager.messages.executor.InternalApplicationSignal;
import de.aristaflow.adept2.core.runtimemanager.messages.runtimemanager.ApplicationMessage;
import de.aristaflow.adept2.model.runtimeenvironment.ApplicationEnvironmentException;
import de.aristaflow.adept2.model.runtimeenvironment.ApplicationFailedException;
import de.aristaflow.adept2.model.runtimeenvironment.InvalidExecutorThreadException;
import de.aristaflow.adept2.model.runtimeenvironment.RuntimeEnvironment;
import de.aristaflow.adept2.model.runtimeenvironment.SessionContext;
import de.aristaflow.adept2.util.LoggerTools;
import de.aristaflow.adept2.util.StackTraceTools;
import java.util.concurrent.CountDownLatch;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DefaultComponentExecutor
extends MessageReceivingExecutor
implements RuntimeEnvironment {
    protected final Logger logger;
    private final MessageReceiver runtimeManager;
    protected ComponentContext currentComponentContext;
    protected boolean componentRunning;
    private final CountDownLatch componentInitialisation;
    private final CountDownLatch componentStart;
    private SessionToken currentSession = null;
    protected InternalApplicationSignal terminationMessage;
    private ClientSessionFactory sessionFactory;

    protected DefaultComponentExecutor(ClientSessionFactory csf, ComponentContext componentContext, MessageReceiver runtimeManager) {
        super(new ThreadGroup(componentContext.name), String.valueOf(componentContext.name) + "-Executor-Thread");
        this.sessionFactory = csf;
        this.runtimeManager = runtimeManager;
        this.currentComponentContext = componentContext;
        this.terminationMessage = null;
        this.logger = LoggerTools.getLogger(this);
        this.componentInitialisation = new CountDownLatch(1);
        this.componentStart = new CountDownLatch(1);
    }

    protected SessionToken getOrCreateSession() {
        SessionToken ret = this.currentSession;
        if (ret == null) {
            ret = this.sessionFactory.getSessionToken();
        }
        return ret;
    }

    @Override
    public byte[] getApplicationState(int savepointID) {
        this.checkValidExecutorThread();
        SessionToken session = this.sessionFactory.getSessionToken();
        return this.currentComponentContext.dataContainer.restoreSessionState(session, savepointID);
    }

    @Override
    public int getLastSavepointID() {
        this.checkValidExecutorThread();
        SessionToken session = this.sessionFactory.getSessionToken();
        return this.currentComponentContext.dataContainer.getLastSavepointID(session);
    }

    @Override
    public void setApplicationState(int savepointID, byte[] applicationState) {
        this.checkValidExecutorThread();
        SessionToken session = this.sessionFactory.getSessionToken();
        this.currentComponentContext.dataContainer.storeSessionState(session, savepointID, applicationState);
    }

    @Override
    public void applicationSuspended() {
        this.checkValidExecutorThread();
        SessionToken session = this.getOrCreateSession();
        this.logger.info("Application '" + this.getName() + "' suspended.");
        this.terminationMessage = new ApplicationSuspendedMessage(session, this.generateMessageID(), this.getSessionID());
    }

    @Override
    public void applicationSuspended(long timeout) {
        this.checkValidExecutorThread();
        SessionToken session = this.getOrCreateSession();
        this.logger.info("Application '" + this.getName() + "' suspended with timeout.");
        this.terminationMessage = new ApplicationSuspendedTimeoutMessage(session, this.generateMessageID(), this.getSessionID(), timeout);
    }

    @Override
    public void applicationReset() {
        this.checkValidExecutorThread();
        SessionToken session = this.getOrCreateSession();
        this.logger.info("Application '" + this.getName() + "' reset.");
        this.terminationMessage = new ApplicationResetMessage(session, this.generateMessageID(), this.getSessionID());
    }

    @Override
    public void applicationClosed() {
        this.checkValidExecutorThread();
        SessionToken session = this.getOrCreateSession();
        this.logger.info("Application '" + this.getName() + "' closed.");
        this.terminationMessage = new ApplicationClosedMessage(session, this.generateMessageID(), this.getSessionID());
    }

    protected void applicationFailed(SessionToken session, String errorMessage, String state, long errorCode) {
        this.checkValidExecutorThread();
        this.logger.info("Application '" + this.getName() + "' failed! Cause: " + errorMessage);
        this.terminationMessage = new ApplicationFailedMessage(session, this.generateMessageID(), this.getSessionID(), errorMessage, state, errorCode);
    }

    @Override
    public void applicationSignalled(int signal) {
        this.checkValidExecutorThread();
        SessionToken session = this.getOrCreateSession();
        this.logger.info("Application '" + this.getName() + "' signaled " + signal);
        this.terminationMessage = new ApplicationSignaledMessage(session, this.generateMessageID(), this.getSessionID(), signal);
    }

    @Override
    public boolean dispatch() {
        this.checkValidExecutorThread();
        boolean isTerminationRequested = false;
        do {
            ApplicationMessage message;
            if ((message = (ApplicationMessage)this.messageQueue.poll()) == null) continue;
            this.currentSession = message.getSession();
            message.setExecutableComponent(this.currentComponentContext.component);
            isTerminationRequested = message.process() || isTerminationRequested;
            Message replyMessage = message.generateReplyMessage(this.generateMessageID());
            if (replyMessage != null) {
                this.runtimeManager.receiveMessage(replyMessage);
            }
            if (isTerminationRequested) break;
        } while (DefaultComponentExecutor.interrupted() || !this.messageQueue.isEmpty());
        return isTerminationRequested;
    }

    @Override
    public boolean isRunning() {
        return this.componentRunning;
    }

    @Override
    public void setSessionContext(String sessionID, SessionContext sessionContext) {
        if (this.componentRunning) {
            throw new IllegalStateException("Tried to set session context for '" + this.getName() + "' while already running.");
        }
        super.setSessionContext(sessionID, sessionContext);
    }

    @Override
    public void awaitComponentInitialisation() throws InterruptedException {
        this.componentInitialisation.await();
    }

    @Override
    public void startExecution() {
        this.componentStart.countDown();
    }

    @Override
    public void run() {
        this.checkValidExecutorThread();
        if (this.sessionContext != null) {
            try {
                this.initialise();
                this.logger.finer(String.format("Awaiting start of component '%s'.", this.currentComponentContext.name));
                this.componentStart.await();
                this.logger.finer(String.format("Executing component '%s'.", this.currentComponentContext.name));
                this.currentComponentContext.component.run();
            }
            catch (InterruptedException interruptedException) {
                SessionToken session = this.getOrCreateSession();
                this.logger.severe(String.format("'%1$s' was interrupted after initialisation but before execution. Failing activity", this.getName()));
                this.applicationFailed(session, String.format("'%1$s' was interrupted after initialisation but before execution.", this.getName()), "ADEPT2:ComponentExecutor:InterruptedAfterInitialisation", -310000L);
            }
            catch (ApplicationEnvironmentException aee) {
                this.logger.log(Level.SEVERE, String.format("ApplicationEnvironmentException occurred at '%1$s'. Setting application failed (%2$s).", this.getName(), aee.getErrorCode()), aee);
                SessionToken session = this.getOrCreateSession();
                this.applicationFailed(session, aee.getCompleteStackTrace(), "ADEPT2:ComponentExecutor:ApplicationEnvironmentException", aee.getErrorCode());
            }
            catch (ApplicationFailedException afe) {
                this.logger.log(Level.SEVERE, String.format("ApplicationFailedException occurred at '%1$s'. Setting application failed (%2$s).", this.getName(), afe.getErrorCode()), afe);
                SessionToken session = this.getOrCreateSession();
                this.applicationFailed(session, String.valueOf(afe.getMessage()) + "\n" + afe.getCompleteStackTrace(), afe.getState(), afe.getErrorCode());
            }
            catch (Throwable tw) {
                String message = String.format("%1$s occurred in thread '%2$s'. Setting application failed (%3$s).\nStack trace:\n%4$s", tw.getClass().getSimpleName(), this.getName(), 1600000L, StackTraceTools.stackTraceToString(tw));
                this.logger.log(Level.SEVERE, message);
                SessionToken session = this.getOrCreateSession();
                this.applicationFailed(session, message, "ADEPT2:ComponentExecutor:RuntimeException:" + tw.getClass().getName(), 1600000L);
            }
        } else {
            SessionToken session = this.getOrCreateSession();
            this.logger.severe(String.format("'%1$s' does not have a valid session context before executing.", this.getName()));
            this.applicationFailed(session, String.format("'%1$s' does not have a valid session context before executing.", this.getName()), "ADEPT2:ComponentExecutor:ApplicationEnvironmentException", -300000L);
        }
        this.terminate();
    }

    private void checkValidExecutorThread() throws InvalidExecutorThreadException {
        if (!Thread.currentThread().equals(this)) {
            InvalidExecutorThreadException iete = new InvalidExecutorThreadException();
            String msg = String.format("Invalid Executor Thread: %s", Thread.currentThread().getName());
            this.logger.log(Level.SEVERE, msg, iete);
            throw iete;
        }
    }

    protected void initialise() {
        this.checkValidExecutorThread();
        try {
            this.componentRunning = true;
            this.setName(this.currentComponentContext.name);
            this.logger.info("Execution of '" + this.currentComponentContext.name + "' initialised.");
            if (this.currentComponentContext.resume) {
                this.logger.info("Restoring application state of '" + this.currentComponentContext.name + "'.");
                this.currentComponentContext.component.initResume(this.currentComponentContext.savePointID, this.sessionContext);
            } else {
                this.currentComponentContext.component.init(this.sessionContext);
            }
        }
        catch (Throwable throwable) {
            this.componentInitialisation.countDown();
            this.logger.finer(String.format("Signalled initialisation of '%s'.", this.currentComponentContext.name));
            throw throwable;
        }
        this.componentInitialisation.countDown();
        this.logger.finer(String.format("Signalled initialisation of '%s'.", this.currentComponentContext.name));
    }

    protected void terminate() {
        this.checkValidExecutorThread();
        this.componentRunning = false;
        this.setName("Idle DefaultComponentExecutorService");
        this.logger.info("Component '" + this.currentComponentContext.name + "' terminated.");
        ComponentContext tempContext = this.currentComponentContext;
        this.currentComponentContext = null;
        this.sessionContext = null;
        this.notifyTermination(tempContext);
    }

    private void notifyTermination(ComponentContext componentContext) {
        if (this.isRunning()) {
            this.checkValidExecutorThread();
        }
        if (this.terminationMessage == null) {
            this.logger.severe(String.format("'%s' has not signalled its termination. Set application failed (%s).", componentContext.name, -9998L));
            this.applicationFailed(this.sessionFactory.getSessionToken(), "Application did not signal termination.", "ADEPT2:ComponentExecutor:TerminationMessageNull", -9998L);
        }
        this.runtimeManager.receiveMessage(this.terminationMessage);
    }
}

