/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.core.runtimemanager.defaultimplementation;

import de.aristaflow.adept2.base.service.AbstractADEPT2Service;
import de.aristaflow.adept2.base.service.AbstractSubService;
import de.aristaflow.adept2.base.service.Registry;
import de.aristaflow.adept2.base.service.ServiceAccessControlException;
import de.aristaflow.adept2.base.service.ServiceNotKnownException;
import de.aristaflow.adept2.base.sessionmanagement.QualifiedAgent;
import de.aristaflow.adept2.base.sessionmanagement.SecurityTokenIntegrityException;
import de.aristaflow.adept2.base.sessionmanagement.SessionFactory;
import de.aristaflow.adept2.base.sessionmanagement.SessionToken;
import de.aristaflow.adept2.core.executionmanager.ActivityTermination;
import de.aristaflow.adept2.core.executionmanager.ExecutionManager;
import de.aristaflow.adept2.core.runtimemanager.ExecutionControlManager;
import de.aristaflow.adept2.core.runtimemanager.defaultimplementation.DefaultActivityManager;
import de.aristaflow.adept2.core.runtimemanager.defaultimplementation.DefaultInternalApplicationSignalling;
import de.aristaflow.adept2.core.runtimemanager.defaultimplementation.MessageReceivingExecutor;
import de.aristaflow.adept2.core.runtimemanager.messages.runtimemanager.CloseMessage;
import de.aristaflow.adept2.core.runtimemanager.messages.runtimemanager.KillMessage;
import de.aristaflow.adept2.core.runtimemanager.messages.runtimemanager.ResetMessage;
import de.aristaflow.adept2.core.runtimemanager.messages.runtimemanager.SignalMessage;
import de.aristaflow.adept2.core.runtimemanager.messages.runtimemanager.SuspendMessage;
import de.aristaflow.adept2.model.common.ExecutionControlProperties;
import de.aristaflow.adept2.model.execution.ExecutableBusinessProcessInstance;
import de.aristaflow.adept2.model.execution.ExecutionContext;
import de.aristaflow.adept2.model.execution.InvalidActivityStateException;
import de.aristaflow.adept2.model.processmodel.EBPInstanceReference;
import de.aristaflow.adept2.model.runtimeenvironment.ActivityState;
import de.aristaflow.adept2.util.StackTraceTools;
import java.util.Set;
import java.util.logging.Level;

public class DefaultExecutionControlManager
extends AbstractSubService
implements ExecutionControlManager {
    protected final Registry registry;
    protected SessionFactory sessionFactory;
    protected final DefaultInternalApplicationSignalling internalApplicationSignalling;
    protected final DefaultActivityManager activityManager;
    protected final long joinTimeout;

    public DefaultExecutionControlManager(AbstractADEPT2Service service, Registry registry, DefaultActivityManager activityManager, DefaultInternalApplicationSignalling internalApplicationSignalling, long joinTimeout) {
        super(service);
        this.registry = registry;
        this.activityManager = activityManager;
        this.internalApplicationSignalling = internalApplicationSignalling;
        this.joinTimeout = joinTimeout;
    }

    public void init(SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    @Override
    public void abortActivity(SessionToken session, EBPInstanceReference ebpInstanceReference, long timeToRespond) {
        super.sessionActive(session);
        try {
            long messageID = this.internalApplicationSignalling.generateMessageID();
            KillMessage message = new KillMessage(messageID, session);
            this.internalApplicationSignalling.sendMessageToComponent(ebpInstanceReference, message);
            this.logger.info(String.format("Send kill signal to activity %s.", ebpInstanceReference));
            if (timeToRespond >= 0L) {
                if (timeToRespond > 0L && this.activityTerminated(ebpInstanceReference, timeToRespond)) {
                    this.logger.fine(String.format("Activity '%s' successfully aborted.", ebpInstanceReference));
                    return;
                }
                this.killActivity(session, ebpInstanceReference);
            }
        }
        finally {
            super.sessionFinished(session);
        }
    }

    @Override
    public void resetActivity(SessionToken session, EBPInstanceReference ebpInstanceReference) {
        super.sessionActive(session);
        try {
            ExecutionContext executionContext = this.activityManager.getExecutionContext(ebpInstanceReference);
            ExecutableBusinessProcessInstance ebpInstance = executionContext.getEBPInstance();
            ExecutionControlProperties executionControlProperties = ebpInstance.getExecutionControlProperties();
            if (!executionControlProperties.isResettable()) {
                throw new IllegalArgumentException("Tried to reset an activity which is not resettable!");
            }
            long messageID = this.internalApplicationSignalling.generateMessageID();
            ResetMessage message = new ResetMessage(messageID, session);
            this.internalApplicationSignalling.sendMessageToComponent(ebpInstanceReference, message);
            this.logger.info(String.format("Instructed activity %s to reset.", ebpInstanceReference));
        }
        finally {
            super.sessionFinished(session);
        }
    }

    @Override
    public void finishActivity(SessionToken session, EBPInstanceReference ebpInstanceReference) {
        super.sessionActive(session);
        try {
            ExecutionContext executionContext = this.activityManager.getExecutionContext(ebpInstanceReference);
            ExecutableBusinessProcessInstance ebpInstance = executionContext.getEBPInstance();
            ExecutionControlProperties executionControlProperties = ebpInstance.getExecutionControlProperties();
            if (!executionControlProperties.isClosable()) {
                throw new IllegalArgumentException("Tried to close an Activity which isn't closable!");
            }
            long messageID = this.internalApplicationSignalling.generateMessageID();
            CloseMessage message = new CloseMessage(messageID, session);
            this.internalApplicationSignalling.sendMessageToComponent(ebpInstanceReference, message);
            this.logger.info(String.format("Instructed activity %s to finish.", ebpInstanceReference));
        }
        finally {
            super.sessionFinished(session);
        }
    }

    @Override
    public boolean isRunning(SessionToken session, EBPInstanceReference ebpInstanceReference) {
        super.sessionActive(session);
        try {
            boolean bl = this.activityManager.isRunning(ebpInstanceReference);
            return bl;
        }
        finally {
            super.sessionFinished(session);
        }
    }

    @Override
    public Set<EBPInstanceReference> getRunningActivities(SessionToken session) {
        super.sessionActive(session);
        try {
            QualifiedAgent agent = this.sessionFactory.checkAndGetTopLevelAgent(session);
            Set<EBPInstanceReference> set = this.activityManager.getRunningActivities(agent);
            return set;
        }
        catch (SecurityTokenIntegrityException stie) {
            String msg = "The designated session token for retrieving all running activities failed the verification!";
            throw new ServiceAccessControlException(msg, stie);
        }
        finally {
            super.sessionFinished(session);
        }
    }

    @Override
    public void sendSignalToActivity(SessionToken session, EBPInstanceReference ebpInstanceReference, int signal) {
        super.sessionActive(session);
        try {
            long messageID = this.internalApplicationSignalling.generateMessageID();
            SignalMessage message = new SignalMessage(messageID, session, signal);
            this.internalApplicationSignalling.sendMessageToComponent(ebpInstanceReference, message);
            this.logger.info(String.format("Send signal %s to activity %s.", signal, ebpInstanceReference));
        }
        finally {
            super.sessionFinished(session);
        }
    }

    @Override
    public void suspendActivity(SessionToken session, EBPInstanceReference ebpInstanceReference) {
        super.sessionActive(session);
        try {
            ExecutionContext executionContext = this.activityManager.getExecutionContext(ebpInstanceReference);
            ExecutableBusinessProcessInstance ebpInstance = executionContext.getEBPInstance();
            ExecutionControlProperties executionControlProperties = ebpInstance.getExecutionControlProperties();
            if (!executionControlProperties.isSuspensible()) {
                throw new IllegalArgumentException("Tried to suspend an Activity which isn't suspensible!");
            }
            long messageID = this.internalApplicationSignalling.generateMessageID();
            SuspendMessage message = new SuspendMessage(messageID, session);
            this.internalApplicationSignalling.sendMessageToComponent(ebpInstanceReference, message);
            this.logger.info(String.format("Instructed activity %s to suspend.", ebpInstanceReference));
        }
        finally {
            super.sessionFinished(session);
        }
    }

    @Override
    public ActivityState waitForTermination(SessionToken session, EBPInstanceReference activity, long timeToRespond) throws InterruptedException {
        super.sessionActive(session);
        try {
            ActivityState ret = null;
            boolean terminated = this.activityManager.waitForTermination(activity, timeToRespond);
            if (terminated) {
                ret = new ActivityState(ActivityState.State.TERMINATED);
            } else if (this.activityManager.isRunning(activity)) {
                ret = new ActivityState(ActivityState.State.RUNNING);
            } else if (this.activityManager.isActive(activity)) {
                ret = new ActivityState(ActivityState.State.TERMINATING);
            }
            ActivityState activityState = ret;
            return activityState;
        }
        finally {
            super.sessionFinished(session);
        }
    }

    protected boolean activityTerminated(EBPInstanceReference ebpInstanceReference, long timeToRespond) {
        boolean ret = false;
        try {
            ret = this.activityManager.waitForTermination(ebpInstanceReference, timeToRespond);
        }
        catch (InterruptedException interruptedException) {
            this.logger.info(String.format("Interrupted while waiting for the activity '%s' to terminate. Escalating early.", ebpInstanceReference));
        }
        return ret;
    }

    protected void killActivity(SessionToken parentSession, EBPInstanceReference ebpInstanceReference) {
        ThreadGroup victim;
        try {
            victim = this.activityManager.getMessageReceiver(ebpInstanceReference).getThreadGroup();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            victim = null;
        }
        if (victim == null) {
            this.logger.fine(String.format("Activity '%s' has terminated while trying to terminate it.", ebpInstanceReference));
            return;
        }
        this.logger.info(String.format("Activity '%s' did not respond. Stopping threads.\nCurrent stack traces:\n%s", ebpInstanceReference, this.getCurrentStackTraces(victim)));
        victim.interrupt();
        victim.stop();
        this.logger.info(String.format("Waiting for stopped threads of activity '%s' to die.", ebpInstanceReference));
        boolean terminatedAll = true;
        boolean interrupted = false;
        Thread[] threadArray = this.getThreads(victim);
        int n = threadArray.length;
        int n2 = 0;
        while (n2 < n) {
            Thread thread = threadArray[n2];
            if (thread != null) {
                try {
                    thread.join(this.joinTimeout);
                    terminatedAll &= !thread.isAlive();
                }
                catch (InterruptedException interruptedException) {
                    interrupted = true;
                    this.logger.info(String.format("Interrupted while waiting for all threads of activity '%s' to die. Continuing waiting.", ebpInstanceReference));
                }
            }
            ++n2;
        }
        if (interrupted) {
            Thread.currentThread().interrupt();
        }
        if (!terminatedAll) {
            String msg = String.format("Not all threads of activity '%s' have been stopped. The corresponding component seems to catch ThreadDeath! It will be stopped by System.exit(). It may be in an inconsistent state afterwards.", ebpInstanceReference);
            this.logger.warning(msg);
            System.out.println(msg);
            MessageReceivingExecutor mainExecutor = this.activityManager.getMessageReceiver(ebpInstanceReference);
            if (mainExecutor.isAlive()) {
                try {
                    SessionToken session = this.sessionFactory.getChildSession(parentSession, this.getURIs());
                    ActivityTermination executionManager = this.registry.getService(session, ebpInstanceReference.getExecutionManagerURIs(), ExecutionManager.class).getActivityTermination();
                    this.activityManager.unregisterActivityInstance(ebpInstanceReference);
                    executionManager.activityFailed(session, ebpInstanceReference, this.activityManager.getDataContainer(ebpInstanceReference), msg, "ADEPT2:RuntimeManager:ComponentStopped", 666666L);
                }
                catch (ServiceNotKnownException snke) {
                    msg = String.format("Could not signal forced fail of activity '%s' to theexecution manager since the manager cannot be retrieved. The activity in the instance '%s' has the wrong state now.", ebpInstanceReference, ebpInstanceReference.getInstanceID());
                    this.logger.log(Level.SEVERE, msg, snke);
                }
                catch (InvalidActivityStateException iase) {
                    msg = String.format("Could not signal forced fail of activity '%s' to theexecution manager. Either the activity itself has reached a stable state meanwhile or we have a major state inconsistency in the corresponding instance %s. Please investigate this.", ebpInstanceReference, ebpInstanceReference.getInstanceID());
                    this.logger.log(Level.SEVERE, msg, iase);
                }
                this.activityManager.activityTerminationSignalled(ebpInstanceReference);
            }
        }
    }

    protected Thread[] getThreads(ThreadGroup group) {
        int activeCount = group.activeCount();
        Thread[] ret = new Thread[activeCount];
        boolean sizeFits = false;
        while (!sizeFits) {
            activeCount = group.enumerate(ret);
            boolean bl = sizeFits = activeCount < ret.length;
            if (sizeFits) continue;
            ret = new Thread[activeCount + 10];
        }
        return ret;
    }

    protected String getCurrentStackTraces(ThreadGroup group) {
        StringBuilder ret = new StringBuilder();
        Thread[] threadArray = this.getThreads(group);
        int n = threadArray.length;
        int n2 = 0;
        while (n2 < n) {
            Thread thread = threadArray[n2];
            if (thread != null) {
                ret.append(thread.getName());
                ret.append(":\n");
                try {
                    ret.append(StackTraceTools.stackTracesToString(thread.getStackTrace()));
                }
                catch (SecurityException securityException) {}
                ret.append("\n");
            }
            ++n2;
        }
        return ret.toString();
    }
}

