/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.core.runtimemanager.defaultimplementation;

import de.aristaflow.adept2.base.communication.Message;
import de.aristaflow.adept2.base.communication.MessageReceiver;
import de.aristaflow.adept2.base.communication.NOPMessage;
import de.aristaflow.adept2.base.communication.ReplyMessage;
import de.aristaflow.adept2.base.configuration.AbortServiceException;
import de.aristaflow.adept2.base.configuration.ConfigurationException;
import de.aristaflow.adept2.base.service.AbstractADEPT2Service;
import de.aristaflow.adept2.base.service.AbstractSubService;
import de.aristaflow.adept2.base.service.Registry;
import de.aristaflow.adept2.base.sessionmanagement.SessionFactory;
import de.aristaflow.adept2.base.sessionmanagement.SessionToken;
import de.aristaflow.adept2.core.client.implementation.PersistingActivityTermination;
import de.aristaflow.adept2.core.runtimemanager.ResumingRuntimeManager;
import de.aristaflow.adept2.core.runtimemanager.defaultimplementation.DefaultActivityManager;
import de.aristaflow.adept2.core.runtimemanager.defaultimplementation.DefaultRuntimeManager;
import de.aristaflow.adept2.core.runtimemanager.defaultimplementation.InternalApplicationSignalling;
import de.aristaflow.adept2.core.runtimemanager.defaultimplementation.MessageReceivingExecutor;
import de.aristaflow.adept2.core.runtimemanager.messages.executor.InternalApplicationSignal;
import de.aristaflow.adept2.model.datamanagement.DataContainer;
import de.aristaflow.adept2.model.execution.ExecutionContext;
import de.aristaflow.adept2.model.execution.InvalidActivityStateException;
import de.aristaflow.adept2.model.globals.ProcessConstants;
import de.aristaflow.adept2.model.processmodel.EBPInstanceReference;
import de.aristaflow.adept2.model.runtimeenvironment.GUIContext;
import de.aristaflow.adept2.util.Adept2ThreadFactory;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;

public class DefaultInternalApplicationSignalling
extends AbstractSubService
implements InternalApplicationSignalling,
MessageReceiver,
Runnable {
    private BlockingQueue<Message> messageQueue;
    private static final int ALIVE = 1;
    private static final int STOPPED = 0;
    private static final int STOPPING = 2;
    private volatile int watchdog = 0;
    private Object isAliveState;
    private final long IS_ALIVE_TIMEOUT;
    private static long lastUsedMessageID = Long.MIN_VALUE;
    private final DefaultActivityManager activityManager;
    private final ConcurrentMap<Long, Message> requestMessages;
    private final Thread workerThread;
    final Set<ResumingRuntimeManager.AutomaticResumer> automaticResumer;
    private final ExecutorService resumeNotification;
    private final PersistingActivityTermination activityTermination;

    public DefaultInternalApplicationSignalling(AbstractADEPT2Service service, Registry registry, DefaultActivityManager activityManager, long aliveTimeout, boolean persisting) throws ConfigurationException {
        super(service);
        this.activityTermination = new PersistingActivityTermination(service, registry, persisting);
        this.activityManager = activityManager;
        this.messageQueue = new LinkedBlockingQueue<Message>();
        this.IS_ALIVE_TIMEOUT = aliveTimeout;
        this.isAliveState = new Object();
        this.requestMessages = new ConcurrentHashMap<Long, Message>();
        this.workerThread = new Thread((Runnable)this, "RuntimeManager-InternalApplicationSignallingThread[for_" + registry.getInstanceName() + "]");
        this.resumeNotification = Executors.newSingleThreadExecutor(new Adept2ThreadFactory("InternalApplicationSignalling_ResumeNotification"));
        this.automaticResumer = Collections.synchronizedSet(new HashSet());
    }

    public void init(SessionFactory sessionFactory) {
        this.activityTermination.init(sessionFactory);
    }

    @Override
    public void start() throws AbortServiceException {
        this.workerThread.start();
        this.activityTermination.start();
    }

    @Override
    public void shutdown() {
        this.logger.info("Shutting down InternalApplicationSignalling...");
        this.terminate(false);
        this.logger.info("done.");
    }

    @Override
    public void emergencyShutdown() {
        this.logger.info("Emergency shut down InternalApplicationSignalling...");
        this.terminate(true);
        this.logger.info("done.");
    }

    protected void terminate(boolean emergency) {
        long timeToWait;
        String msg = "The message queue contains %d entries before termination.";
        msg = String.format(msg, this.messageQueue.size());
        this.logger.finer(msg);
        this.watchdog = 2;
        this.receiveMessage(new NOPMessage(this.generateMessageID()));
        if (emergency) {
            this.resumeNotification.shutdownNow();
            timeToWait = 5L;
        } else {
            this.resumeNotification.shutdown();
            timeToWait = 10L;
        }
        try {
            if (!this.resumeNotification.awaitTermination(timeToWait, TimeUnit.SECONDS)) {
                msg = "Thread pool of InternalApplicationSignalling did not %sshut down in time! Continuing service shutdown.";
                msg = String.format(msg, emergency ? "urgently " : "");
                this.logger.warning(msg);
            }
        }
        catch (InterruptedException interruptedException) {}
        try {
            this.workerThread.join();
        }
        catch (InterruptedException interruptedException) {}
        msg = "The message queue contains %d entries after termination.";
        msg = String.format(msg, this.messageQueue.size());
        this.logger.finer(msg);
        this.logger.info("done.");
        if (emergency) {
            this.activityTermination.emergencyShutdown();
        } else {
            this.activityTermination.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean ping() {
        boolean isAlive = false;
        long messageID = this.generateMessageID();
        Object object = this.isAliveState;
        synchronized (object) {
            block11: {
                if (this.watchdog != 2) break block11;
                return false;
            }
            this.watchdog = 0;
        }
        this.receiveMessage(new NOPMessage(messageID));
        object = this.isAliveState;
        synchronized (object) {
            if (this.watchdog == 0) {
                try {
                    this.isAliveState.wait(this.IS_ALIVE_TIMEOUT);
                }
                catch (InterruptedException ie) {
                    this.logger.warning(String.format("isAlive Request interrupted because of InterruptedException: %s.", ie.getLocalizedMessage()));
                    isAlive = false;
                    Thread.currentThread().interrupt();
                }
            }
            if (this.watchdog == 1) {
                isAlive = true;
            }
        }
        return isAlive;
    }

    @Override
    public void applicationClosed(SessionToken session, String sessionID) {
        super.sessionActive(session);
        try {
            this.logger.info(String.format("Application closed - SID '%s'.", sessionID));
            EBPInstanceReference ebpInstanceReference = this.activityManager.getEBPInstanceReference(sessionID);
            ExecutionContext executionContext = this.activityManager.getExecutionContext(ebpInstanceReference);
            DataContainer dataContainer = this.activityManager.getDataContainer(ebpInstanceReference);
            GUIContext guiContext = this.activityManager.getGuiContext(ebpInstanceReference);
            this.activityManager.unregisterActivityInstance(ebpInstanceReference);
            try {
                try {
                    guiContext.close();
                    if (!executionContext.getExecutionMode().equals((Object)ProcessConstants.ExecutionMode.VIEW_ONLY)) {
                        this.activityTermination.activityFinished(session, ebpInstanceReference, dataContainer);
                        this.logger.info(String.format("Informed the executionManager %s about the finish of the activity %s.", Arrays.toString(ebpInstanceReference.getExecutionManagerURIs()), ebpInstanceReference));
                    }
                }
                catch (InvalidActivityStateException e) {
                    this.logger.severe(String.format("Couldn't set activity %s to finished. Reason: %s", ebpInstanceReference, e.getLocalizedMessage()));
                    this.activityManager.activityTerminationSignalled(ebpInstanceReference);
                }
            }
            finally {
                this.activityManager.activityTerminationSignalled(ebpInstanceReference);
            }
        }
        finally {
            super.sessionFinished(session);
        }
    }

    @Override
    public void applicationSuspended(SessionToken session, String sessionID) {
        super.sessionActive(session);
        try {
            this.logger.info(String.format("Application suspended - SID '%s'.", sessionID));
            EBPInstanceReference ebpInstanceReference = this.activityManager.getEBPInstanceReference(sessionID);
            ExecutionContext executionContext = this.activityManager.getExecutionContext(ebpInstanceReference);
            DataContainer dataContainer = this.activityManager.getDataContainer(ebpInstanceReference);
            GUIContext guiContext = this.activityManager.getGuiContext(ebpInstanceReference);
            this.activityManager.unregisterActivityInstance(ebpInstanceReference);
            try {
                try {
                    guiContext.close();
                    if (!executionContext.getExecutionMode().equals((Object)ProcessConstants.ExecutionMode.VIEW_ONLY)) {
                        this.activityTermination.activitySuspended(session, ebpInstanceReference, dataContainer);
                        this.logger.info(String.format("Informed the executionManager %s about the suspension of the activity %s.", Arrays.toString(ebpInstanceReference.getExecutionManagerURIs()), ebpInstanceReference));
                    }
                }
                catch (InvalidActivityStateException e) {
                    this.logger.severe(String.format("Couldn't set activity %s to suspended. Reason: %s", ebpInstanceReference, e.getLocalizedMessage()));
                    this.activityManager.activityTerminationSignalled(ebpInstanceReference);
                }
            }
            finally {
                this.activityManager.activityTerminationSignalled(ebpInstanceReference);
            }
        }
        finally {
            super.sessionFinished(session);
        }
    }

    @Override
    public void applicationSuspended(SessionToken session, String sessionID, final long timeout) {
        this.logger.info(String.format("Application suspended for resuming in '%s' ms - SID '%s'.", timeout, sessionID));
        final EBPInstanceReference ebpInstanceReference = this.activityManager.getEBPInstanceReference(sessionID);
        ExecutionContext executionContext = this.activityManager.getExecutionContext(ebpInstanceReference);
        this.applicationSuspended(session, sessionID);
        if (!executionContext.getExecutionMode().equals((Object)ProcessConstants.ExecutionMode.VIEW_ONLY)) {
            if (this.resumeNotification.isShutdown()) {
                this.logger.info("The executor service that notifies the automatic resumer(s) is shut down, therefore no update will be sent. The activity must be resumed manually!");
            } else {
                this.resumeNotification.execute(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        for (ResumingRuntimeManager.AutomaticResumer resumer : new HashSet<ResumingRuntimeManager.AutomaticResumer>(DefaultInternalApplicationSignalling.this.automaticResumer)) {
                            Set<ResumingRuntimeManager.AutomaticResumer> set = DefaultInternalApplicationSignalling.this.automaticResumer;
                            synchronized (set) {
                                if (DefaultInternalApplicationSignalling.this.automaticResumer.contains(resumer)) {
                                    resumer.resumeActivity(ebpInstanceReference, timeout);
                                }
                            }
                        }
                    }
                });
            }
        }
    }

    @Override
    public void applicationReset(SessionToken session, String sessionID) {
        super.sessionActive(session);
        try {
            this.logger.info(String.format("Application reset - SID '%s'.", sessionID));
            EBPInstanceReference ebpInstanceReference = this.activityManager.getEBPInstanceReference(sessionID);
            ExecutionContext executionContext = this.activityManager.getExecutionContext(ebpInstanceReference);
            GUIContext guiContext = this.activityManager.getGuiContext(ebpInstanceReference);
            this.activityManager.unregisterActivityInstance(ebpInstanceReference);
            try {
                try {
                    guiContext.close();
                    if (!executionContext.getExecutionMode().equals((Object)ProcessConstants.ExecutionMode.VIEW_ONLY)) {
                        this.activityTermination.activityReset(session, ebpInstanceReference);
                        this.logger.info(String.format("Informed the executionManager %s about the reset of the activity %s.", Arrays.toString(ebpInstanceReference.getExecutionManagerURIs()), ebpInstanceReference));
                    }
                }
                catch (InvalidActivityStateException e) {
                    this.logger.severe(String.format("Couldn't set activity %s to reset. Reason: %s", ebpInstanceReference, e.getLocalizedMessage()));
                    this.activityManager.activityTerminationSignalled(ebpInstanceReference);
                }
            }
            finally {
                this.activityManager.activityTerminationSignalled(ebpInstanceReference);
            }
        }
        finally {
            super.sessionFinished(session);
        }
    }

    @Override
    public void applicationFailed(SessionToken session, String sessionID, String errorMessage, String state, long errorCode) {
        super.sessionActive(session);
        try {
            this.logger.info(String.format("Application failed - SID '%s'.", sessionID));
            EBPInstanceReference ebpInstanceReference = this.activityManager.getEBPInstanceReference(sessionID);
            ExecutionContext executionContext = this.activityManager.getExecutionContext(ebpInstanceReference);
            DataContainer dataContainer = this.activityManager.getDataContainer(ebpInstanceReference);
            GUIContext guiContext = this.activityManager.getGuiContext(ebpInstanceReference);
            this.activityManager.unregisterActivityInstance(ebpInstanceReference);
            try {
                try {
                    guiContext.close();
                    if (!executionContext.getExecutionMode().equals((Object)ProcessConstants.ExecutionMode.VIEW_ONLY)) {
                        this.activityTermination.activityFailed(session, ebpInstanceReference, dataContainer, errorMessage, state, errorCode);
                        this.logger.info(String.format("Failed activity %s!", ebpInstanceReference));
                    }
                }
                catch (InvalidActivityStateException e) {
                    this.logger.severe(String.format("Couldn't set activity %s to failed. Reason: %s", ebpInstanceReference, e.getLocalizedMessage()));
                    this.activityManager.activityTerminationSignalled(ebpInstanceReference);
                }
            }
            finally {
                this.activityManager.activityTerminationSignalled(ebpInstanceReference);
            }
        }
        finally {
            super.sessionFinished(session);
        }
    }

    @Override
    public void applicationSignaled(SessionToken session, String sessionID, int signal) {
        super.sessionActive(session);
        try {
            this.logger.info(String.format("Application signaled %d in session %s!", signal, sessionID));
        }
        finally {
            super.sessionFinished(session);
        }
    }

    @Override
    public void receiveMessage(Message message) {
        this.messageQueue.add(message);
        if (message instanceof ReplyMessage) {
            this.requestMessages.remove(((ReplyMessage)message).getRequestID());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long generateMessageID() {
        Class<DefaultRuntimeManager> clazz = DefaultRuntimeManager.class;
        synchronized (DefaultRuntimeManager.class) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return ++lastUsedMessageID;
        }
    }

    void sendMessageToComponent(EBPInstanceReference ebpInstanceReference, Message message) {
        MessageReceivingExecutor messageReceiver = this.activityManager.getMessageReceiver(ebpInstanceReference);
        if (messageReceiver != null) {
            this.requestMessages.put(message.getMessageID(), message);
            messageReceiver.receiveMessage(message);
        } else {
            this.logger.severe("Couldn't provide a message to the activity " + ebpInstanceReference + " because there is no Message" + " Receiver assigned to the activity");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public void run() {
        while (this.watchdog != 2) {
            message = null;
            try {
                message = this.messageQueue.take();
                var2_2 = this.isAliveState;
                synchronized (var2_2) {
                    if (this.watchdog == 0) {
                        this.watchdog = 1;
                    }
                    this.isAliveState.notifyAll();
                }
                if (!(message instanceof InternalApplicationSignal)) continue;
                ((InternalApplicationSignal)message).setExecutor(this);
                message.process();
            }
            catch (InterruptedException v1) {
                break;
            }
            catch (Exception e) {
                msg = String.format("An exception occurred when processing the application message %s. The application may be in an inconsistent state. Continuing.", new Object[]{message != null ? message : "'unknown'"});
                this.logger.log(Level.SEVERE, msg, e);
            }
        }
        message = this.isAliveState;
        synchronized (message) {
            this.watchdog = 0;
            this.isAliveState.notifyAll();
            // MONITOREXIT @DISABLED, blocks:[2, 3] lbl32 : MonitorExitStatement: MONITOREXIT : message
            if (true) ** GOTO lbl40
        }
        do {
            if (!((message = (Message)this.messageQueue.poll()) instanceof InternalApplicationSignal)) continue;
            ((InternalApplicationSignal)message).setExecutor(this);
            this.logger.info("Try to process " + message);
            message.process();
lbl40:
            // 3 sources

        } while (!this.messageQueue.isEmpty());
        this.logger.info("Shutdown complete.");
    }

    void deregisterAutomaticResumer(ResumingRuntimeManager.AutomaticResumer automaticResumer) {
        this.automaticResumer.remove(automaticResumer);
    }

    void registerAutomaticResumer(ResumingRuntimeManager.AutomaticResumer automaticResumer) {
        this.automaticResumer.add(automaticResumer);
    }
}

