/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.core.runtimemanager.defaultimplementation;

import de.aristaflow.adept2.base.configuration.AbortServiceException;
import de.aristaflow.adept2.base.configuration.ConfigurationDescription;
import de.aristaflow.adept2.base.configuration.ConfigurationException;
import de.aristaflow.adept2.base.configuration.Property;
import de.aristaflow.adept2.base.service.AbstractADEPT2Service;
import de.aristaflow.adept2.base.service.InternalServiceException;
import de.aristaflow.adept2.base.service.InvalidServiceStateException;
import de.aristaflow.adept2.base.service.Registry;
import de.aristaflow.adept2.base.service.ServiceAccessControlException;
import de.aristaflow.adept2.base.service.ServiceNotKnownException;
import de.aristaflow.adept2.base.sessionmanagement.ClientSessionFactory;
import de.aristaflow.adept2.base.sessionmanagement.QualifiedAgent;
import de.aristaflow.adept2.base.sessionmanagement.RichAgent;
import de.aristaflow.adept2.base.sessionmanagement.SecurityTokenIntegrityException;
import de.aristaflow.adept2.base.sessionmanagement.SessionLock;
import de.aristaflow.adept2.base.sessionmanagement.SessionToken;
import de.aristaflow.adept2.base.sessionmanagement.SignedSecurityToken;
import de.aristaflow.adept2.core.client.ClientQA;
import de.aristaflow.adept2.core.executionmanager.ActivityTermination;
import de.aristaflow.adept2.core.executionmanager.ExecutionManager;
import de.aristaflow.adept2.core.runtimemanager.ExecutionControlManager;
import de.aristaflow.adept2.core.runtimemanager.ResumingRuntimeManager;
import de.aristaflow.adept2.core.runtimemanager.RuntimeManager;
import de.aristaflow.adept2.core.runtimemanager.RuntimeRegistry;
import de.aristaflow.adept2.core.runtimemanager.SynchronousActivityStarting;
import de.aristaflow.adept2.core.runtimemanager.defaultimplementation.ComponentContext;
import de.aristaflow.adept2.core.runtimemanager.defaultimplementation.DefaultActivityManager;
import de.aristaflow.adept2.core.runtimemanager.defaultimplementation.DefaultComponentExecutor;
import de.aristaflow.adept2.core.runtimemanager.defaultimplementation.DefaultExecutionControlManager;
import de.aristaflow.adept2.core.runtimemanager.defaultimplementation.DefaultInternalApplicationSignalling;
import de.aristaflow.adept2.core.runtimemanager.defaultimplementation.DefaultSynchronousActivityStarting;
import de.aristaflow.adept2.core.runtimemanager.defaultimplementation.MessageReceivingExecutor;
import de.aristaflow.adept2.core.runtimemanager.gui.GUIContextUnavailableException;
import de.aristaflow.adept2.core.runtimemanager.gui.GUIManager;
import de.aristaflow.adept2.core.runtimemanager.gui.GUIManager2;
import de.aristaflow.adept2.core.runtimemanager.messages.runtimemanager.CommitMessage;
import de.aristaflow.adept2.core.runtimemanager.messages.runtimemanager.RollbackMessage;
import de.aristaflow.adept2.model.common.i18n.LocalisationResolver;
import de.aristaflow.adept2.model.execution.ActivityInstance;
import de.aristaflow.adept2.model.execution.AgentUnknownException;
import de.aristaflow.adept2.model.execution.ExecutionContext;
import de.aristaflow.adept2.model.execution.InvalidActivityStateException;
import de.aristaflow.adept2.model.execution.Vote;
import de.aristaflow.adept2.model.globals.ProcessConstants;
import de.aristaflow.adept2.model.processmodel.EBPInstanceReference;
import de.aristaflow.adept2.model.runtimeenvironment.DataContext;
import de.aristaflow.adept2.model.runtimeenvironment.ExecutableComponent;
import de.aristaflow.adept2.model.runtimeenvironment.GUIContext;
import de.aristaflow.adept2.model.runtimeenvironment.RuntimeEnvironmentFactory;
import de.aristaflow.adept2.model.runtimeenvironment.SessionContext;
import de.aristaflow.adept2.util.Adept2ThreadFactory;
import de.aristaflow.adept2.util.LockException;
import de.aristaflow.adept2.util.StackTraceTools;
import de.aristaflow.adept2.util.locking.ObjectLockManager;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import org.apache.commons.configuration.Configuration;

@ConfigurationDescription(properties={@Property(name="IsAliveTimeout", type=Property.Type.LONG, defaultValue="2000", description="The amount of time in milliseconds to wait for a response to a isAlive-request for the runtime mananger."), @Property(name="IsPersisting", type=Property.Type.BOOLEAN, defaultValue="true", description="Whether the runtime manager will persist activity termination calls."), @Property(name="InitialisationTimeout", type=Property.Type.LONG, defaultValue="10000", description="The amount of time in milliseconds to wait until the component has been initialised."), @Property(name="ShutdownEscalationTime", type=Property.Type.LONG, defaultValue="6000", description="The amount of time in milliseconds to wait until a component terminates after an abort request or a shutdown request. If the component does not terminate, the next escalation level will be reached. For instance not responding to a suspend leads to a close, not responding to an abort leads to stopping the threads.")})
public class DefaultRuntimeManager
extends AbstractADEPT2Service
implements RuntimeManager,
ResumingRuntimeManager {
    public static final String CONFIGURATION_IS_ALIVE_TIMEOUT = "IsAliveTimeout";
    public static final String CONFIGURATION_IS_PERSISTING = "IsPersisting";
    public static final String CONFIGURATION_INITIALISATION_TIMEOUT = "InitialisationTimeout";
    public static final String CONFIGURATION_SHUTDOWN_ESCALATION_TIME = "ShutdownEscalationTime";
    protected static final long LOCK_TIMEOUT = 60000L;
    private long IS_ALIVE_TIMEOUT;
    private boolean IS_PERSISTING;
    private long INITIALISATION_TIMEOUT;
    private long TERMINATE_ESCALATION_TIME;
    private final DefaultExecutionControlManager executionControlManager;
    private final DefaultInternalApplicationSignalling internalApplicationSignalling;
    private final DefaultSynchronousActivityStarting activityStarting;
    private final DefaultActivityManager activityManager;
    private RuntimeEnvironmentFactory runtimeEnvironmentFactory;
    private RuntimeRegistry rtRegistry;
    private GUIManager guiManager;
    protected final Map<ClientQA, ClientSessionFactory> loggedOnAgents;
    protected final ObjectLockManager<ClientQA, SessionToken> logoffLocks;

    public DefaultRuntimeManager(Configuration configuration, Registry registry) throws ConfigurationException {
        super(configuration, registry, new String[]{"RuntimeRegistry", "ExecutionManager", "GUIManager"}, new String[0]);
        this.configure(configuration);
        this.loggedOnAgents = new HashMap<ClientQA, ClientSessionFactory>();
        try {
            this.logoffLocks = new ObjectLockManager(SessionLock.UUIDLockCount.class, SessionLock.class, "runtime manager logoff");
        }
        catch (InvocationTargetException ite) {
            String msg = "Can not instantiate object lock manager for synchronising logging off of agents. There were problems instantiating the lock count manager and/or the session locks.";
            this.logger.log(Level.SEVERE, msg, ite);
            throw new InternalServiceException(msg, ite);
        }
        this.activityManager = new DefaultActivityManager();
        this.internalApplicationSignalling = new DefaultInternalApplicationSignalling(this, registry, this.activityManager, this.IS_ALIVE_TIMEOUT, this.IS_PERSISTING);
        this.executionControlManager = new DefaultExecutionControlManager(this, registry, this.activityManager, this.internalApplicationSignalling, this.TERMINATE_ESCALATION_TIME);
        this.activityStarting = new DefaultSynchronousActivityStarting(this, registry, this.INITIALISATION_TIMEOUT);
    }

    private final void configure(Configuration configuration) throws ConfigurationException {
        String propertyValue = configuration.getString(CONFIGURATION_IS_ALIVE_TIMEOUT);
        try {
            this.IS_ALIVE_TIMEOUT = Long.parseLong(propertyValue);
        }
        catch (NumberFormatException numberFormatException) {
            this.logger.severe("Configuration: Configuration parameter \"IsAliveTimeout\" is not of type long!");
            throw new ConfigurationException("Configuration parameter \"IsAliveTimeout\" is not of type long!");
        }
        propertyValue = configuration.getString(CONFIGURATION_INITIALISATION_TIMEOUT);
        try {
            this.INITIALISATION_TIMEOUT = Long.parseLong(propertyValue);
        }
        catch (NumberFormatException numberFormatException) {
            this.logger.severe("Configuration: Configuration parameter \"InitialisationTimeout\" is not of type long!");
            throw new ConfigurationException("Configuration parameter \"InitialisationTimeout\" is not of type long!");
        }
        propertyValue = configuration.getString(CONFIGURATION_SHUTDOWN_ESCALATION_TIME);
        try {
            this.TERMINATE_ESCALATION_TIME = Long.parseLong(propertyValue);
        }
        catch (NumberFormatException numberFormatException) {
            this.logger.severe("Configuration: Configuration parameter \"ShutdownEscalationTime\" is not of type long!");
            throw new ConfigurationException("Configuration parameter \"ShutdownEscalationTime\" is not of type long!");
        }
        this.IS_PERSISTING = configuration.getBoolean(CONFIGURATION_IS_PERSISTING);
    }

    @Override
    public String[] getStartupRequiredServices() {
        HashSet<String> requiredServices = new HashSet<String>();
        requiredServices.addAll(Arrays.asList(super.getStartupRequiredServices()));
        requiredServices.addAll(Arrays.asList(this.internalApplicationSignalling.getStartupRequiredServices()));
        requiredServices.addAll(Arrays.asList(this.executionControlManager.getStartupRequiredServices()));
        requiredServices.addAll(Arrays.asList(this.activityStarting.getStartupRequiredServices()));
        return requiredServices.toArray(new String[requiredServices.size()]);
    }

    @Override
    public String[] getRuntimeRequiredServices() {
        HashSet<String> requiredServices = new HashSet<String>();
        requiredServices.addAll(Arrays.asList(super.getRuntimeRequiredServices()));
        requiredServices.addAll(Arrays.asList(this.internalApplicationSignalling.getRuntimeRequiredServices()));
        requiredServices.addAll(Arrays.asList(this.executionControlManager.getRuntimeRequiredServices()));
        requiredServices.addAll(Arrays.asList(this.activityStarting.getRuntimeRequiredServices()));
        return requiredServices.toArray(new String[requiredServices.size()]);
    }

    @Override
    public void init(URI[] uris) throws AbortServiceException {
        super.init(uris, -2, -2, "password");
        this.runtimeEnvironmentFactory = this.registry.getModelFactory("RuntimeEnvironmentFactory", RuntimeEnvironmentFactory.class);
        try {
            this.rtRegistry = this.registry.getServiceOfType(this.createSessionToken(), "RuntimeRegistry", RuntimeRegistry.class);
        }
        catch (ServiceNotKnownException snke) {
            String msg = "The runtime registry is unavailable. This is usually caused by a wrong client configuration.";
            throw new InternalServiceException(msg, snke);
        }
        try {
            this.guiManager = this.registry.getServiceOfType(this.createSessionToken(), "GUIManager", GUIManager.class);
        }
        catch (ServiceNotKnownException snke) {
            String msg = "The gui manager is unavailable. This is usually caused by a wrong client configuration.";
            throw new InternalServiceException(msg, snke);
        }
        this.internalApplicationSignalling.init(this.sessionFactory);
        this.executionControlManager.init(this.sessionFactory);
        this.activityStarting.init();
    }

    @Override
    public void start() throws AbortServiceException {
        super.start();
        this.internalApplicationSignalling.start();
        this.executionControlManager.start();
        this.activityStarting.start();
    }

    @Override
    public void shutdown() {
        this.logger.info("Shutting down.");
        this.terminateRunningActivities(false);
        super.shutdown();
        this.activityStarting.shutdown();
        this.executionControlManager.shutdown();
        this.internalApplicationSignalling.shutdown();
        this.sessionFactory = null;
    }

    @Override
    public void emergencyShutdown() {
        this.logger.info("Emergency Shutdown initiated.");
        this.terminateRunningActivities(true);
        super.emergencyShutdown();
        this.activityStarting.emergencyShutdown();
        this.executionControlManager.emergencyShutdown();
        this.internalApplicationSignalling.emergencyShutdown();
        this.sessionFactory = null;
    }

    @Override
    public boolean ping() {
        return this.internalApplicationSignalling.ping();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void logon(SessionToken session, ClientSessionFactory clientSessionFactory) {
        super.sessionActive(session);
        QualifiedAgent csfAgent = clientSessionFactory.getAuthenticatedAgent().getQualifiedAgent();
        try {
            try {
                QualifiedAgent sessionAgent = this.sessionFactory.checkAndGetTopLevelAgent(session);
                this.sessionFactory.checkIntegrity(clientSessionFactory.getSessionToken());
                String msg = String.format("Logging on agent '%s' to the runtime manager'%s'.", sessionAgent, Arrays.toString(this.getURIs()));
                this.logger.fine(msg);
                if (!csfAgent.equals(sessionAgent)) {
                    msg = String.format("The agent '%s' from the session token does not correspond to the agent (%s) of the client session factory.", sessionAgent, csfAgent);
                    throw new IllegalArgumentException(msg);
                }
                Map<ClientQA, ClientSessionFactory> map = this.loggedOnAgents;
                synchronized (map) {
                    this.loggedOnAgents.put(new ClientQA(csfAgent), clientSessionFactory);
                }
            }
            catch (SecurityTokenIntegrityException stie) {
                String msg = String.format("Could not log on agent '%s' to runtime manager '%s' due to invalid session tokens retrieved from the corresponding client session factory. Agent is not logged on.", csfAgent, Arrays.toString(this.getURIs()));
                throw new ServiceAccessControlException(msg, stie);
            }
        }
        finally {
            super.sessionFinished(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<EBPInstanceReference, ProcessConstants.NodeState> logoffAndTerminateActivities(SessionToken session, QualifiedAgent agent, boolean forceTermination) {
        super.sessionActive(session);
        try {
            ClientSessionFactory logoff;
            Map<EBPInstanceReference, ProcessConstants.NodeState> ret = new HashMap<EBPInstanceReference, ProcessConstants.NodeState>();
            this.sessionFactory.checkIntegrity(session);
            boolean locked = false;
            boolean interrupted = false;
            ClientQA sAgent = new ClientQA(agent);
            String msg = String.format("Logging off agent '%s' from the runtime manager '%s'.", agent, Arrays.toString(this.getURIs()));
            this.logger.fine(msg);
            Map<ClientQA, ClientSessionFactory> map = this.loggedOnAgents;
            synchronized (map) {
                logoff = this.loggedOnAgents.remove(sAgent);
            }
            if (logoff != null) {
                while (!locked) {
                    try {
                        msg = String.format("Try to retrieve write lock for logging off agent '%s'.", sAgent);
                        this.logger.finer(msg);
                        this.logoffLocks.getLockForObject(true, session, sAgent, 60000L);
                        locked = true;
                        msg = String.format("Retrieved write lock for logging off agent '%s'.", sAgent);
                        this.logger.finer(msg);
                    }
                    catch (InterruptedException interruptedException) {
                        interrupted = true;
                        msg = String.format("Interrupted while retrieving write lock for logging off agent '%s'. Continuing waiting for the lock.", agent);
                        this.logger.finer(msg);
                    }
                    catch (TimeoutException te) {
                        msg = String.format("Got a timeout while waiting to get a write lock for logging off agent '%s'. This is possibly a deadlock.", agent);
                        throw new InvalidServiceStateException(msg, te);
                    }
                }
                try {
                    ret = this.terminateRunningActivities(logoff, forceTermination);
                }
                catch (Throwable throwable) {
                    try {
                        msg = String.format("Try to unlock write lock for logging off agent '%s'.", sAgent);
                        this.logger.finer(msg);
                        this.logoffLocks.unlockObject(true, session, sAgent);
                        msg = String.format("Unlocked write lock for logging off agent '%s'.", sAgent);
                        this.logger.finer(msg);
                    }
                    catch (LockException le) {
                        msg = String.format("Could not release logoff-write-lock for agent '%s'. This is a serious problem since we have locked it recently. However the logoff was successful.", agent);
                        this.logger.log(Level.SEVERE, msg, le);
                    }
                    throw throwable;
                }
                try {
                    msg = String.format("Try to unlock write lock for logging off agent '%s'.", sAgent);
                    this.logger.finer(msg);
                    this.logoffLocks.unlockObject(true, session, sAgent);
                    msg = String.format("Unlocked write lock for logging off agent '%s'.", sAgent);
                    this.logger.finer(msg);
                }
                catch (LockException le) {
                    msg = String.format("Could not release logoff-write-lock for agent '%s'. This is a serious problem since we have locked it recently. However the logoff was successful.", agent);
                    this.logger.log(Level.SEVERE, msg, le);
                }
            }
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
            HashMap<EBPInstanceReference, ProcessConstants.NodeState> hashMap = ret;
            return hashMap;
        }
        catch (SecurityTokenIntegrityException stie) {
            String msg = String.format("Could not log off agent '%s' from runtime manager '%s' due to invalid session tokens retrieved from the corresponding client session factory. The activities will keep on running.", agent, Arrays.toString(this.getURIs()));
            throw new ServiceAccessControlException(msg, stie);
        }
        finally {
            super.sessionFinished(session);
        }
    }

    @Override
    public void startActivity(SessionToken sessionToken, EBPInstanceReference ebpInstanceReference, ExecutionContext executionContext) throws AgentUnknownException {
        super.sessionActive(sessionToken);
        try {
            try {
                this.startOrResumeActivity(sessionToken, ebpInstanceReference, executionContext, false, 0);
            }
            catch (SecurityTokenIntegrityException stie) {
                String msg = String.format("The designated session token for starting the activity '%s' failed the verification!", ebpInstanceReference);
                throw new ServiceAccessControlException(msg, stie);
            }
        }
        finally {
            super.sessionFinished(sessionToken);
        }
    }

    @Override
    public void resumeActivity(SessionToken sessionToken, EBPInstanceReference ebpInstanceReference, ExecutionContext executionContext, int savePointID) throws AgentUnknownException {
        super.sessionActive(sessionToken);
        try {
            try {
                this.startOrResumeActivity(sessionToken, ebpInstanceReference, executionContext, true, savePointID);
            }
            catch (SecurityTokenIntegrityException stie) {
                String msg = String.format("The designated session token for resuming the activity '%s' failed the verification!", ebpInstanceReference);
                throw new ServiceAccessControlException(msg, stie);
            }
        }
        finally {
            super.sessionFinished(sessionToken);
        }
    }

    @Override
    public Vote prepareCommit(SessionToken session, EBPInstanceReference ebpInstanceReference) {
        super.sessionActive(session);
        try {
            this.logger.severe("prepare Commit not yet implemented");
            return null;
        }
        finally {
            super.sessionFinished(session);
        }
    }

    @Override
    public void commit(SessionToken sessionToken, EBPInstanceReference ebpInstanceReference) {
        super.sessionActive(sessionToken);
        try {
            long messageID = this.internalApplicationSignalling.generateMessageID();
            CommitMessage message = new CommitMessage(messageID, sessionToken);
            this.internalApplicationSignalling.sendMessageToComponent(ebpInstanceReference, message);
            this.logger.info("Sent commit signal to activity " + ebpInstanceReference + ".");
        }
        finally {
            super.sessionFinished(sessionToken);
        }
    }

    @Override
    public void rollbackActivity(SessionToken sessionToken, EBPInstanceReference ebpInstanceReference) {
        super.sessionActive(sessionToken);
        try {
            long messageID = this.internalApplicationSignalling.generateMessageID();
            RollbackMessage message = new RollbackMessage(messageID, sessionToken);
            this.internalApplicationSignalling.sendMessageToComponent(ebpInstanceReference, message);
            this.logger.info("Sent rollback signal to activity " + ebpInstanceReference + ".");
        }
        finally {
            super.sessionFinished(sessionToken);
        }
    }

    @Override
    public ExecutionControlManager getExecutionControlManager() {
        return this.executionControlManager;
    }

    @Override
    public SynchronousActivityStarting getSynchronousActivityStarting() {
        return this.activityStarting;
    }

    @Override
    public void registerAutomaticResumer(ResumingRuntimeManager.AutomaticResumer automaticResumer) {
        this.internalApplicationSignalling.registerAutomaticResumer(automaticResumer);
    }

    @Override
    public void deregisterAutomaticResumer(ResumingRuntimeManager.AutomaticResumer automaticResumer) {
        this.internalApplicationSignalling.deregisterAutomaticResumer(automaticResumer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void startOrResumeActivity(final SessionToken session, final EBPInstanceReference ebpInstanceReference, final ExecutionContext executionContext, boolean resume, int savePointID) throws SecurityTokenIntegrityException, AgentUnknownException {
        this.sessionFactory.checkIntegrity(session);
        QualifiedAgent agent = executionContext.getAgent();
        ClientQA sAgent = new ClientQA(agent);
        boolean syncActStarterSignalled = false;
        try {
            Map<ClientQA, ClientSessionFactory> map = this.loggedOnAgents;
            synchronized (map) {
                if (this.loggedOnAgents.get(sAgent) == null) {
                    throw new AgentUnknownException(agent, this.getURIs());
                }
            }
            if (this.activityManager.isActive(ebpInstanceReference)) {
                String message = String.format("There is already an activity running for the EBPInstanceReference '%s'! Please wait until this has been terminated", ebpInstanceReference);
                this.logger.severe(message);
                throw new IllegalArgumentException(message);
            }
            try {
                String msg = String.format("Try to retrieve write lock for starting/resuming '%s' by agent '%s'.", ebpInstanceReference, sAgent);
                this.logger.finer(msg);
                this.logoffLocks.getLockForObject(false, session, sAgent, 60000L);
                msg = String.format("Retrieved write lock for starting/resuming '%s' by agent '%s'.", ebpInstanceReference, sAgent);
                this.logger.finer(msg);
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
                throw new AgentUnknownException(agent, this.getURIs());
            }
            catch (TimeoutException te) {
                String msg = String.format("Got a timeout while waiting to get a read lock for starting/resuming activity '%s' for agent '%s'. This is possibly a deadlock.", ebpInstanceReference, agent);
                throw new InvalidServiceStateException(msg, te);
            }
            try {
                ClientSessionFactory csf;
                Map<ClientQA, ClientSessionFactory> msg = this.loggedOnAgents;
                synchronized (msg) {
                    csf = this.loggedOnAgents.get(sAgent);
                    if (csf == null) {
                        throw new AgentUnknownException(agent, this.getURIs());
                    }
                }
                try {
                    GUIContext guiContext;
                    RichAgent richAgent = csf.getAuthenticatedAgent();
                    ActivityInstance activity = (ActivityInstance)executionContext.getEBPInstance();
                    String sessionID = this.createSessionID(ebpInstanceReference);
                    activity = this.rtRegistry.getOverridenActivityInstance(session, activity, executionContext.getExecutionMode() == ProcessConstants.ExecutionMode.COMPONENT_TEST);
                    ExecutableComponent componentToExecute = executionContext.getExecutionMode() == ProcessConstants.ExecutionMode.SUBSTITUTED_TEST ? this.rtRegistry.getTestComponent(session, activity, true, richAgent) : this.rtRegistry.getComponent(session, activity, richAgent);
                    ComponentContext componentContext = new ComponentContext(activity.getName(), componentToExecute, executionContext.getDataContainer(), resume, savePointID);
                    DefaultComponentExecutor componentThread = new DefaultComponentExecutor(csf, componentContext, this.internalApplicationSignalling);
                    componentThread.setContextClassLoader(componentToExecute.getClass().getClassLoader());
                    try {
                        ActivityInstance locActivity = LocalisationResolver.createLocalisedView(ActivityInstance.class, activity, richAgent.getLocale());
                        guiContext = this.guiManager instanceof GUIManager2 ? ((GUIManager2)this.guiManager).getGUIContext(session, locActivity, ebpInstanceReference, sessionID, executionContext, resume, savePointID, this.executionControlManager, componentThread) : this.guiManager.getGUIContext(session, locActivity, ebpInstanceReference, sessionID, executionContext, this.executionControlManager, componentThread);
                    }
                    catch (GUIContextUnavailableException gcue) {
                        this.logger.log(Level.SEVERE, "Problems creating the required graphical context.", gcue);
                        throw gcue;
                    }
                    try {
                        DataContext dataContext = this.runtimeEnvironmentFactory.getDataContext(csf, executionContext.getDataContainer(), componentThread);
                        SessionContext sessionContextForComponent = this.runtimeEnvironmentFactory.getInitialSessionContext(csf, sessionID, ebpInstanceReference, dataContext, executionContext, guiContext, componentThread, componentThread);
                        ((MessageReceivingExecutor)componentThread).setSessionContext(sessionID, sessionContextForComponent);
                        this.activityManager.registerNewActivityInstance(sessionID, ebpInstanceReference, executionContext, guiContext, componentThread);
                        this.logger.finer(String.format("Initialising activity '%1$s' in '%2$s'-mode for %3$s.", ebpInstanceReference, executionContext.getExecutionMode().name(), resume ? "Resuming" : "Starting"));
                        componentThread.startInitialisation();
                        this.logger.fine(String.format("Initialised activity '%1$s' in '%2$s'-mode for %3$s.", ebpInstanceReference, executionContext.getExecutionMode().name(), resume ? "Resuming" : "Starting"));
                        try {
                            this.logger.finer(String.format("Awaiting initialisation of activity '%1$s'.", ebpInstanceReference));
                            ((MessageReceivingExecutor)componentThread).awaitComponentInitialisation();
                            this.logger.info(String.format("%3$s activity '%1$s' in '%2$s'-mode.", ebpInstanceReference, executionContext.getExecutionMode().name(), resume ? "Resumed" : "Started"));
                            this.activityStarting.signalActivation(ebpInstanceReference, guiContext);
                            ((MessageReceivingExecutor)componentThread).startExecution();
                        }
                        catch (InterruptedException interruptedException) {
                            componentThread.interrupt();
                            Thread.currentThread().interrupt();
                            this.logger.info(String.format("Interrupted while waiting for initalisation of activity '%s'. The component execution thread will not be started but interrupted.", ebpInstanceReference));
                        }
                    }
                    catch (Throwable t) {
                        guiContext.close();
                        throw t;
                    }
                }
                catch (Throwable t) {
                    this.logger.log(Level.WARNING, String.format("Exception occurred while creating and initialising activity '%1$s'.", ebpInstanceReference), t);
                    this.activityStarting.signalFailing(ebpInstanceReference, t);
                    syncActStarterSignalled = true;
                    SignedSecurityToken starterToken = session.getTopLevelSecurityToken();
                    SessionToken newSession = this.sessionFactory.getSessionToken(this.getURIs());
                    final SessionToken failSession = this.getSessionFactory().getSubstituteSessionToken(newSession, starterToken);
                    Thread failThread = new Thread(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                URI[] emURIs = ebpInstanceReference.getExecutionManagerURIs();
                                ActivityTermination executionManager = DefaultRuntimeManager.this.registry.getService(session, emURIs, ExecutionManager.class).getActivityTermination();
                                executionManager.activityFailed(failSession, ebpInstanceReference, executionContext.getDataContainer(), StackTraceTools.stackTraceToString(t), "ADEPT2:RuntimeManager:ComponentNotLoaded", 200001L);
                                DefaultRuntimeManager.this.logger.log(Level.WARNING, String.format("Failed activity '%1$s' due to configuration or instantiation problems!", ebpInstanceReference), t);
                            }
                            catch (ServiceNotKnownException serviceNotKnownException) {
                                String msg = String.format("Activity '%s' failed due to configuration or instantiation problems and the state could not be set to FAILED since the execution manager was not available.", ebpInstanceReference);
                                DefaultRuntimeManager.this.logger.log(Level.SEVERE, msg, t);
                            }
                            catch (InvalidActivityStateException iase) {
                                String msg = String.format("Activity '%s' failed due to configuration or instantiation problems and the state could not be set to FAILED: %s", ebpInstanceReference, iase.getMessage());
                                DefaultRuntimeManager.this.logger.log(Level.SEVERE, msg, t);
                            }
                        }
                    }, "RuntimeManager.startOrResumeActivity failed due to a Throwable-Thread");
                    if (!executionContext.getExecutionMode().equals((Object)ProcessConstants.ExecutionMode.VIEW_ONLY)) {
                        failThread.start();
                    }
                    if (t instanceof Error) {
                        throw (Error)t;
                    }
                }
            }
            catch (Throwable throwable) {
                try {
                    String msg = String.format("Try to unlock write lock for starting/resuming '%s' by agent '%s'.", ebpInstanceReference, sAgent);
                    this.logger.finer(msg);
                    this.logoffLocks.unlockObject(false, session, sAgent);
                    msg = String.format("Unlocked write lock for starting/resuming '%s' by agent '%s'.", ebpInstanceReference, sAgent);
                    this.logger.finer(msg);
                }
                catch (LockException le) {
                    String msg = String.format("Could not release logoff-read-lock for agent '%s'. This is a serious problem since we have locked it recently. However the start or resume was successful.", agent);
                    this.logger.log(Level.SEVERE, msg, le);
                }
                throw throwable;
            }
            try {
                String msg = String.format("Try to unlock write lock for starting/resuming '%s' by agent '%s'.", ebpInstanceReference, sAgent);
                this.logger.finer(msg);
                this.logoffLocks.unlockObject(false, session, sAgent);
                msg = String.format("Unlocked write lock for starting/resuming '%s' by agent '%s'.", ebpInstanceReference, sAgent);
                this.logger.finer(msg);
            }
            catch (LockException le) {
                String msg = String.format("Could not release logoff-read-lock for agent '%s'. This is a serious problem since we have locked it recently. However the start or resume was successful.", agent);
                this.logger.log(Level.SEVERE, msg, le);
            }
        }
        catch (SecurityTokenIntegrityException stie) {
            if (!syncActStarterSignalled) {
                this.activityStarting.signalFailing(ebpInstanceReference, stie);
            }
            throw stie;
        }
        catch (AgentUnknownException aue) {
            if (!syncActStarterSignalled) {
                this.activityStarting.signalFailing(ebpInstanceReference, aue);
            }
            throw aue;
        }
        catch (RuntimeException rt) {
            if (!syncActStarterSignalled) {
                this.activityStarting.signalFailing(ebpInstanceReference, rt);
            }
            throw rt;
        }
        catch (Error err) {
            if (!syncActStarterSignalled) {
                this.activityStarting.signalFailing(ebpInstanceReference, err);
            }
            throw err;
        }
    }

    protected String createSessionID(EBPInstanceReference ebpInstanceReference) {
        StringBuilder ret = new StringBuilder();
        ret.append(ebpInstanceReference.getExecutionManagerURIs()[0]);
        ret.append('-');
        ret.append(ebpInstanceReference.getInstanceID());
        ret.append('-');
        ret.append(ebpInstanceReference.getNodeID());
        ret.append('-');
        ret.append(ebpInstanceReference.getNodeIteration());
        return ret.toString();
    }

    protected void terminateRunningActivities(final boolean emergency) {
        System.out.println("Terminating all running activities. This may take some time. Please wait...");
        for (final ClientSessionFactory csf : this.loggedOnAgents.values()) {
            ExecutorService terminateExecutors = Executors.newCachedThreadPool(new Adept2ThreadFactory("RuntimeManager-Terminate-Thread (all)"));
            terminateExecutors.execute(new Runnable(){

                @Override
                public void run() {
                    Map<EBPInstanceReference, ProcessConstants.NodeState> running = DefaultRuntimeManager.this.terminateRunningActivities(csf, emergency);
                    String msg = String.format("Shut down %d activities for agent '%s'.", running.size(), csf.getAuthenticatedAgent().getQualifiedAgent());
                    DefaultRuntimeManager.this.logger.info(msg);
                }
            });
            terminateExecutors.shutdown();
            boolean terminated = false;
            while (!terminated) {
                try {
                    terminated = terminateExecutors.awaitTermination(30L, TimeUnit.SECONDS);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        System.out.println("Terminated all running activities successfully.");
    }

    /*
     * Exception decompiling
     */
    protected Map<EBPInstanceReference, ProcessConstants.NodeState> terminateRunningActivities(ClientSessionFactory csf, boolean forceTermination) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [6[UNCONDITIONALDOLOOP]], but top level block is 0[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

