/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.core.runtimemanager.defaultimplementation;

import de.aristaflow.adept2.base.service.AbstractADEPT2Service;
import de.aristaflow.adept2.base.service.AbstractSubService;
import de.aristaflow.adept2.base.service.InternalServiceException;
import de.aristaflow.adept2.base.service.Registry;
import de.aristaflow.adept2.base.service.ServiceNotKnownException;
import de.aristaflow.adept2.base.sessionmanagement.QualifiedAgent;
import de.aristaflow.adept2.base.sessionmanagement.SessionToken;
import de.aristaflow.adept2.core.executionmanager.ActivityStarting;
import de.aristaflow.adept2.core.executionmanager.ExecutionManager;
import de.aristaflow.adept2.core.runtimemanager.SynchronousActivityStarting;
import de.aristaflow.adept2.model.execution.AgentUnknownException;
import de.aristaflow.adept2.model.execution.ExecutionContext;
import de.aristaflow.adept2.model.execution.InvalidActivityStateException;
import de.aristaflow.adept2.model.globals.ProcessConstants;
import de.aristaflow.adept2.model.processmodel.EBPInstanceReference;
import de.aristaflow.adept2.model.processmodel.InvalidInstanceStateException;
import de.aristaflow.adept2.model.runtimeenvironment.GUIContext;
import de.aristaflow.adept2.model.runtimeenvironment.WrongRuntimeManagerException;
import de.aristaflow.adept2.util.time.TimeCalculations;
import de.aristaflow.adept2.util.types.Pair;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;

public class DefaultSynchronousActivityStarting
extends AbstractSubService
implements SynchronousActivityStarting {
    private final Registry registry;
    private final long timeout;
    private final Map<EBPInstanceReference, Pair<GUIContext, Throwable>> guiMap;
    private final Map<EBPInstanceReference, CountDownLatch> latchMap;

    public DefaultSynchronousActivityStarting(AbstractADEPT2Service service, Registry registry, long timeout) {
        super(service);
        this.registry = registry;
        this.timeout = timeout;
        this.guiMap = Collections.synchronizedMap(new HashMap());
        this.latchMap = new HashMap<EBPInstanceReference, CountDownLatch>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GUIContext resumeActivitySynchronously(SessionToken session, EBPInstanceReference activity) throws InvalidActivityStateException, InvalidInstanceStateException, AgentUnknownException, WrongRuntimeManagerException {
        GUIContext gUIContext;
        block14: {
            Map<EBPInstanceReference, Pair<GUIContext, Throwable>> map;
            CountDownLatch latch;
            boolean successful = false;
            Map<EBPInstanceReference, Pair<GUIContext, Throwable>> map2 = this.guiMap;
            synchronized (map2) {
                if (!this.latchMap.containsKey(activity)) {
                    latch = new CountDownLatch(1);
                    this.latchMap.put(activity, latch);
                } else {
                    latch = this.latchMap.get(activity);
                }
            }
            try {
                this.resumeActivity(session, activity);
                GUIContext ret = this.waitForGUIContext(activity, latch);
                successful = true;
                gUIContext = ret;
                if (successful) break block14;
                map = this.guiMap;
            }
            catch (Throwable throwable) {
                if (!successful) {
                    Map<EBPInstanceReference, Pair<GUIContext, Throwable>> map3 = this.guiMap;
                    synchronized (map3) {
                        this.latchMap.remove(activity);
                    }
                }
                throw throwable;
            }
            synchronized (map) {
                this.latchMap.remove(activity);
            }
        }
        return gUIContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GUIContext startActivitySynchronously(SessionToken session, EBPInstanceReference activity, ProcessConstants.ExecutionMode executionMode) throws InvalidActivityStateException, InvalidInstanceStateException, AgentUnknownException, WrongRuntimeManagerException {
        GUIContext gUIContext;
        block14: {
            Map<EBPInstanceReference, Pair<GUIContext, Throwable>> map;
            CountDownLatch latch;
            boolean successful = false;
            Map<EBPInstanceReference, Pair<GUIContext, Throwable>> map2 = this.guiMap;
            synchronized (map2) {
                if (!this.latchMap.containsKey(activity)) {
                    latch = new CountDownLatch(1);
                    this.latchMap.put(activity, latch);
                } else {
                    latch = this.latchMap.get(activity);
                }
            }
            try {
                this.startActivity(session, activity, executionMode);
                GUIContext ret = this.waitForGUIContext(activity, latch);
                successful = true;
                gUIContext = ret;
                if (successful) break block14;
                map = this.guiMap;
            }
            catch (Throwable throwable) {
                if (!successful) {
                    Map<EBPInstanceReference, Pair<GUIContext, Throwable>> map3 = this.guiMap;
                    synchronized (map3) {
                        this.latchMap.remove(activity);
                    }
                }
                throw throwable;
            }
            synchronized (map) {
                this.latchMap.remove(activity);
            }
        }
        return gUIContext;
    }

    @Override
    public void deselectActivity(SessionToken session, EBPInstanceReference activity) throws InvalidActivityStateException, InvalidInstanceStateException {
        try {
            ActivityStarting activityStarting = this.registry.getService(session, activity.getExecutionManagerURIs(), ExecutionManager.class).getActivityStarting();
            activityStarting.deselectActivity(session, activity);
        }
        catch (ServiceNotKnownException snke) {
            String msg = "Could not deselect activity '%s' since the corresponding execution manager could not be retrieved. Ignoring deselect.";
            throw new InternalServiceException(String.format(msg, activity), snke);
        }
    }

    @Override
    public void resumeActivity(SessionToken session, EBPInstanceReference activity) throws InvalidActivityStateException, InvalidInstanceStateException, AgentUnknownException {
        try {
            activity.setRuntimeManagerURIs(this.getURIs());
            ActivityStarting activityStarting = this.registry.getService(session, activity.getExecutionManagerURIs(), ExecutionManager.class).getActivityStarting();
            activityStarting.resumeActivity(session, activity);
        }
        catch (ServiceNotKnownException snke) {
            String msg = "Could not resume activity '%s' since the corresponding execution manager could not be retrieved. Ignoring resume.";
            throw new InternalServiceException(String.format(msg, activity), snke);
        }
    }

    @Override
    public void selectActivity(SessionToken session, EBPInstanceReference activity) throws InvalidActivityStateException, InvalidInstanceStateException {
        try {
            ActivityStarting activityStarting = this.registry.getService(session, activity.getExecutionManagerURIs(), ExecutionManager.class).getActivityStarting();
            activityStarting.selectActivity(session, activity);
        }
        catch (ServiceNotKnownException snke) {
            String msg = "Could not select activity '%s' since the corresponding execution manager could not be retrieved. Ignoring select.";
            throw new InternalServiceException(String.format(msg, activity), snke);
        }
    }

    @Override
    public void startActivity(SessionToken session, EBPInstanceReference activity, ProcessConstants.ExecutionMode executionMode) throws InvalidActivityStateException, InvalidInstanceStateException, AgentUnknownException {
        try {
            activity.setRuntimeManagerURIs(this.getURIs());
            ActivityStarting activityStarting = this.registry.getService(session, activity.getExecutionManagerURIs(), ExecutionManager.class).getActivityStarting();
            activityStarting.startActivity(session, activity, executionMode);
        }
        catch (ServiceNotKnownException snke) {
            String msg = "Could not start activity '%s' since the corresponding execution manager could not be retrieved. Ignoring start.";
            throw new InternalServiceException(String.format(msg, activity), snke);
        }
    }

    @Override
    public Set<QualifiedAgent> getEnquiryRecipients(SessionToken session, EBPInstanceReference activity) {
        try {
            ActivityStarting activityStarting = this.registry.getService(session, activity.getExecutionManagerURIs(), ExecutionManager.class).getActivityStarting();
            return activityStarting.getEnquiryRecipients(session, activity);
        }
        catch (ServiceNotKnownException snke) {
            String msg = "Could get enquiry recipients for activity '%s'. Returning an empty set of recipients.";
            this.logger.log(Level.WARNING, msg, snke);
            return new HashSet<QualifiedAgent>(0);
        }
    }

    @Override
    public void enquireActivity(SessionToken session, EBPInstanceReference activity, Set<QualifiedAgent> recipients, String comment) throws InvalidActivityStateException, InvalidInstanceStateException {
        try {
            ActivityStarting activityStarting = this.registry.getService(session, activity.getExecutionManagerURIs(), ExecutionManager.class).getActivityStarting();
            activityStarting.enquireActivity(session, activity, recipients, comment);
        }
        catch (ServiceNotKnownException snke) {
            String msg = "Could not enquire activity '%s' since the corresponding execution manager could not be retrieved. Ignoring enquiry.";
            throw new InternalServiceException(String.format(msg, activity), snke);
        }
    }

    @Override
    public void replyEnquiry(SessionToken session, EBPInstanceReference activity, String reply) throws InvalidActivityStateException, InvalidInstanceStateException {
        try {
            ActivityStarting activityStarting = this.registry.getService(session, activity.getExecutionManagerURIs(), ExecutionManager.class).getActivityStarting();
            activityStarting.replyEnquiry(session, activity, reply);
        }
        catch (ServiceNotKnownException snke) {
            String msg = "Could not reply enquiry for activity '%s' since the corresponding execution manager could not be retrieved. Ignoring reply.";
            throw new InternalServiceException(String.format(msg, activity), snke);
        }
    }

    @Override
    public ExecutionContext getExecutionContext(SessionToken session, EBPInstanceReference activity) throws InvalidActivityStateException, InvalidInstanceStateException {
        try {
            ActivityStarting activityStarting = this.registry.getService(session, activity.getExecutionManagerURIs(), ExecutionManager.class).getActivityStarting();
            return activityStarting.getExecutionContext(session, activity);
        }
        catch (ServiceNotKnownException snke) {
            String msg = "Could not get execution context for activity '%s' since the corresponding execution manager could not be retrieved. Ignoring request.";
            throw new InternalServiceException(String.format(msg, activity), snke);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void signalActivation(EBPInstanceReference activity, GUIContext guiContext) {
        Map<EBPInstanceReference, Pair<GUIContext, Throwable>> map = this.guiMap;
        synchronized (map) {
            if (this.latchMap.containsKey(activity)) {
                this.guiMap.put(activity, new Pair<GUIContext, Object>(guiContext, null));
                this.latchMap.remove(activity).countDown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void signalFailing(EBPInstanceReference activity, Throwable throwable) {
        Map<EBPInstanceReference, Pair<GUIContext, Throwable>> map = this.guiMap;
        synchronized (map) {
            if (this.latchMap.containsKey(activity)) {
                this.guiMap.put(activity, new Pair<Object, Throwable>(null, throwable));
                this.latchMap.remove(activity).countDown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private GUIContext waitForGUIContext(EBPInstanceReference activity, CountDownLatch latch) throws WrongRuntimeManagerException {
        Pair<GUIContext, Throwable> guiContext = null;
        if (activity.isActivity()) {
            long start = System.nanoTime();
            long timeLeft = TimeCalculations.timeLeft(start, this.timeout, TimeUnit.MILLISECONDS);
            while (!this.guiMap.containsKey(activity) && timeLeft > 0L) {
                try {
                    latch.await(this.timeout, TimeUnit.MILLISECONDS);
                    timeLeft = TimeCalculations.timeLeft(start, this.timeout, TimeUnit.MILLISECONDS);
                }
                catch (InterruptedException ie) {
                    throw new InternalServiceException("Interrupted while trying to wait some time.", ie);
                }
            }
            Map<EBPInstanceReference, Pair<GUIContext, Throwable>> map = this.guiMap;
            synchronized (map) {
                if (!this.guiMap.containsKey(activity)) {
                    throw new WrongRuntimeManagerException(activity.getRuntimeManagerURIs(), activity);
                }
                guiContext = this.guiMap.remove(activity);
                this.latchMap.remove(activity);
            }
        }
        if (guiContext != null && guiContext.getSecond() != null) {
            String msg = "There was a problem starting/resuming the activity. See attached exception.";
            throw new InternalServiceException(msg, (Throwable)guiContext.getSecond());
        }
        return guiContext == null ? null : (GUIContext)guiContext.getFirst();
    }

    @Override
    public void resetActivity(SessionToken session, EBPInstanceReference activity, boolean forceReset) throws InvalidActivityStateException, InvalidInstanceStateException {
        try {
            ActivityStarting activityStarting = this.registry.getService(session, activity.getExecutionManagerURIs(), ExecutionManager.class).getActivityStarting();
            activityStarting.resetActivity(session, activity, forceReset);
        }
        catch (ServiceNotKnownException snke) {
            String msg = "Could not reset activity '%s' since the corresponding execution manager could not be retrieved. Ignoring reset.";
            throw new InternalServiceException(String.format(msg, activity), snke);
        }
    }
}

