/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.core.runtimemanager.defaultimplementation;

import de.aristaflow.adept2.base.communication.Message;
import de.aristaflow.adept2.base.communication.MessageReceiver;
import de.aristaflow.adept2.core.runtimemanager.messages.runtimemanager.ApplicationMessage;
import de.aristaflow.adept2.model.runtimeenvironment.SessionContext;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;

public abstract class MessageReceivingExecutor
extends Thread
implements MessageReceiver {
    protected String sessionID;
    protected SessionContext sessionContext;
    protected Queue<ApplicationMessage> messageQueue = new ConcurrentLinkedQueue<ApplicationMessage>();
    private int lastUsedMessageID = 0;

    protected MessageReceivingExecutor(ThreadGroup group, String name) {
        super(group, name);
    }

    @Override
    public void receiveMessage(Message message) {
        if (!(message instanceof ApplicationMessage)) {
            throw new IllegalArgumentException("An ApplicationMessage was expected here!");
        }
        this.messageQueue.add((ApplicationMessage)message);
        this.interrupt();
    }

    public String getSessionID() {
        return this.sessionID;
    }

    public void setSessionContext(String sessionID, SessionContext sessionContext) {
        this.sessionID = sessionID;
        this.sessionContext = sessionContext;
    }

    public void startInitialisation() {
        this.start();
    }

    public abstract void awaitComponentInitialisation() throws InterruptedException;

    public abstract void startExecution();

    public abstract boolean isRunning();

    protected long generateMessageID() {
        return this.lastUsedMessageID++;
    }
}

