/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.core.runtimemanager.defaultimplementation;

import de.aristaflow.adept2.base.sessionmanagement.ClientSessionFactory;
import de.aristaflow.adept2.base.sessionmanagement.SessionToken;
import de.aristaflow.adept2.core.runtimemanager.ExecutionControlManager;
import de.aristaflow.adept2.core.runtimemanager.defaultimplementation.DefaultActivityManager;
import de.aristaflow.adept2.model.common.ExecutionControlProperties;
import de.aristaflow.adept2.model.execution.ExecutionContext;
import de.aristaflow.adept2.model.globals.ProcessConstants;
import de.aristaflow.adept2.model.processmodel.EBPInstanceReference;
import de.aristaflow.adept2.util.LoggerTools;
import java.util.concurrent.Callable;
import java.util.logging.Logger;

public class TerminationExecutor
implements Callable<ProcessConstants.NodeState> {
    protected final Logger logger = LoggerTools.getLogger(this);
    protected final ExecutionControlManager controlMgr;
    protected final DefaultActivityManager activityMgr;
    protected final EBPInstanceReference activity;
    protected final ClientSessionFactory csf;
    protected final long escalationTime;
    protected final boolean forceTermination;

    public TerminationExecutor(ClientSessionFactory csf, EBPInstanceReference activity, long escalationTime, boolean forceTermination, ExecutionControlManager controlMgr, DefaultActivityManager activityMgr) {
        this.csf = csf;
        this.activity = activity;
        this.forceTermination = forceTermination;
        this.escalationTime = escalationTime;
        this.controlMgr = controlMgr;
        this.activityMgr = activityMgr;
    }

    protected boolean activityTerminated(SessionToken session) {
        boolean ret = false;
        try {
            ret = this.activityMgr.waitForTermination(this.activity, this.escalationTime);
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
            this.logger.info(String.format("Interrupted while waiting for the activity '%s' to terminate. Escalating early.", this.activity));
        }
        return ret;
    }

    @Override
    public ProcessConstants.NodeState call() {
        SessionToken session;
        this.logger.fine(String.format("Terminating activity '%s'.", this.activity));
        ExecutionContext context = this.activityMgr.getExecutionContext(this.activity);
        ExecutionControlProperties ecp = context.getEBPInstance().getExecutionControlProperties();
        if (ecp.isSuspensible()) {
            session = this.csf.getSessionToken();
            this.logger.finer(String.format("Trying to suspend activity '%s'.", this.activity));
            this.controlMgr.suspendActivity(session, this.activity);
            if (this.activityTerminated(session)) {
                this.logger.fine(String.format("Activity '%s' successfully suspended.", this.activity));
                return ProcessConstants.NodeState.NS_SUSPENDED;
            }
        }
        if (!this.forceTermination) {
            this.logger.finer(String.format("Activity '%s' could not be suspended, since termination is not forced, the activity keeps on running.", this.activity));
            return ProcessConstants.NodeState.NS_RUNNING;
        }
        if (ecp.isClosable()) {
            session = this.csf.getSessionToken();
            this.logger.finer(String.format("Trying to close activity '%s'.", this.activity));
            this.controlMgr.finishActivity(session, this.activity);
            if (this.activityTerminated(session)) {
                this.logger.fine(String.format("Activity '%s' successfully closed.", this.activity));
                return ProcessConstants.NodeState.NS_COMPLETED;
            }
        }
        if (ecp.isResettable()) {
            session = this.csf.getSessionToken();
            this.logger.finer(String.format("Trying to reset activity '%s'.", this.activity));
            this.controlMgr.resetActivity(session, this.activity);
            if (this.activityTerminated(session)) {
                this.logger.fine(String.format("Activity '%s' successfully resetted.", this.activity));
                return ProcessConstants.NodeState.NS_ACTIVATED;
            }
        }
        session = this.csf.getSessionToken();
        this.logger.finer(String.format("Trying to abort activity '%s'.", this.activity));
        this.controlMgr.abortActivity(session, this.activity, this.escalationTime);
        return ProcessConstants.NodeState.NS_FAILED;
    }
}

