/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.core.runtimemanager.executionenvironments;

import de.aristaflow.adept2.model.common.ActivityConfiguration;
import de.aristaflow.adept2.model.datamanagement.ADEPT2UDTValue;
import de.aristaflow.adept2.model.datamanagement.InvalidDataTypeException;
import de.aristaflow.adept2.model.datamanagement.NoSuchParameterException;
import de.aristaflow.adept2.model.datamanagement.UDTValue;
import de.aristaflow.adept2.model.execution.ActivityInstance;
import de.aristaflow.adept2.model.execution.Vote;
import de.aristaflow.adept2.model.globals.ActivityConstants;
import de.aristaflow.adept2.model.globals.ProcessConstants;
import de.aristaflow.adept2.model.processmodel.ProcessModelParameter;
import de.aristaflow.adept2.model.runtimeenvironment.ApplicationEnvironmentException;
import de.aristaflow.adept2.model.runtimeenvironment.ApplicationFailedException;
import de.aristaflow.adept2.model.runtimeenvironment.ComponentObjectInputStream;
import de.aristaflow.adept2.model.runtimeenvironment.DataContext;
import de.aristaflow.adept2.model.runtimeenvironment.ExecutableComponent;
import de.aristaflow.adept2.model.runtimeenvironment.IsNotSupportedException;
import de.aristaflow.adept2.model.runtimeenvironment.RuntimeEnvironment;
import de.aristaflow.adept2.model.runtimeenvironment.SessionContext;
import de.aristaflow.adept2.util.LoggerTools;
import de.aristaflow.adept2.util.StreamTools;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.URI;
import java.util.Date;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class ExecutionEnvironment
implements ExecutableComponent {
    protected final Logger logger;
    protected final ActivityInstance activityInstance;
    protected SessionContext sessionContext;

    public ExecutionEnvironment(ActivityInstance activityInstance) {
        this.activityInstance = activityInstance;
        this.logger = LoggerTools.getLogger(this);
    }

    @Override
    public void init(SessionContext sessionContext) {
        this.sessionContext = sessionContext;
    }

    @Override
    public void initResume(int savePointID, SessionContext sessionContext) {
    }

    @Override
    public abstract void run();

    @Override
    public boolean close() {
        return false;
    }

    @Override
    public boolean reset() {
        return false;
    }

    @Override
    public boolean signal(int signal) {
        return false;
    }

    @Override
    public boolean suspend() {
        return false;
    }

    @Override
    public boolean kill() {
        return false;
    }

    @Override
    public Vote prepareCommit() throws IsNotSupportedException {
        throw new IsNotSupportedException("Transaction management is not supported in the abstract execution environment de.aristaflow.adept2.core.runtimeenvironment.executionenvironments.ExecutionEnvironment.");
    }

    @Override
    public void commit() throws IsNotSupportedException {
        throw new IsNotSupportedException("Transaction management is not supported in the abstract execution environment de.aristaflow.adept2.core.runtimeenvironment.executionenvironments.ExecutionEnvironment.");
    }

    @Override
    public boolean rollback() throws IsNotSupportedException {
        throw new IsNotSupportedException("Transaction management is not supported in the abstract execution environment de.aristaflow.adept2.core.runtimeenvironment.executionenvironments.ExecutionEnvironment.");
    }

    protected Class<?>[] getInputParameterTypes() {
        Set<ProcessModelParameter> inputParameters = this.activityInstance.getParameters(ActivityConstants.AccessType.READ);
        Class[] parameterTypes = new Class[inputParameters.size()];
        for (ProcessModelParameter parameter : inputParameters) {
            String pos = parameter.getConfiguration().getString("position");
            if (pos == null) {
                this.logger.info("No position set for parameter " + parameter.getName());
                continue;
            }
            int position = Integer.parseInt(pos);
            if (position > 0 && position <= inputParameters.size()) {
                parameterTypes[position - 1] = this.getCorrespondingJavaClass(parameter, false);
                continue;
            }
            this.logger.warning(String.format("Position of Parameter %s not set correctly!", parameter.getName()));
        }
        return parameterTypes;
    }

    protected Object getInputParameterValue(String parameterName) {
        Object value;
        block13: {
            ProcessModelParameter parameter = this.activityInstance.getParameter(parameterName, ActivityConstants.AccessType.READ);
            ProcessConstants.AdeptDataType type = parameter.getDataType();
            DataContext dataContext = this.sessionContext.getDataContext();
            value = null;
            try {
                if (dataContext.isNull(parameterName)) break block13;
                switch (type) {
                    case BOOLEAN: {
                        value = dataContext.retrieveBooleanParameterValue(parameterName);
                        value = this.booleanToNativeTypedValue((Boolean)value, parameter, false);
                        break;
                    }
                    case INTEGER: {
                        value = dataContext.retrieveIntegerParameterValue(parameterName);
                        value = this.integerToNativeTypedValue((Long)value, parameter, false);
                        break;
                    }
                    case FLOAT: {
                        value = dataContext.retrieveFloatParameterValue(parameterName);
                        value = this.floatToNativeTypedValue((Double)value, parameter, false);
                        break;
                    }
                    case STRING: {
                        value = dataContext.retrieveStringParameterValue(parameterName);
                        value = this.stringToNativeTypedValue((String)value, parameter, false);
                        break;
                    }
                    case DATE: {
                        value = dataContext.retrieveDateParameterValue(parameterName);
                        value = this.dateToNativeTypedValue((Date)value, parameter, false);
                        break;
                    }
                    case USERDEFINED: {
                        value = dataContext.retrieveUDTParameterValue(parameterName);
                        value = this.userdefinedToNativeTypedValue((UDTValue)value, parameter, false);
                        break;
                    }
                    case URI: {
                        value = dataContext.retrieveURIParameterValue(parameterName);
                        value = this.uriToNativeTypedValue((URI)value, parameter, false);
                        break;
                    }
                    default: {
                        assert (false) : String.format("Data type '%1$s' of parameter '%2$s' not supported.", new Object[]{type, parameterName});
                        break;
                    }
                }
            }
            catch (NoSuchParameterException noSuchParameterException) {
                this.logger.warning(String.format("There is no input parameter of name '%1$s' in the data context of activity '%2$s'.", parameterName, this.activityInstance.getName()));
            }
            catch (InvalidDataTypeException idte) {
                this.logger.warning(String.format("The input parameter '%1$s' is of type '%2$s' in the data context of activity '%3$s.", new Object[]{parameterName, idte.getActualDataType(), this.activityInstance.getName()}));
            }
        }
        return value;
    }

    protected Object[] getInputParameterValues() {
        Set<ProcessModelParameter> inputParameters = this.activityInstance.getParameters(ActivityConstants.AccessType.READ);
        Object[] parameterValues = new Object[inputParameters.size()];
        for (ProcessModelParameter parameter : inputParameters) {
            String pos = parameter.getConfiguration().getString("position");
            if (pos == null) {
                this.logger.info("No position set for parameter " + parameter.getName());
                continue;
            }
            int position = Integer.parseInt(pos);
            String parameterName = parameter.getName();
            if (position > 0 && position <= inputParameters.size()) {
                parameterValues[position - 1] = this.getInputParameterValue(parameterName);
                continue;
            }
            this.logger.warning(String.format("Position of Parameter %1$s not set correctly!", parameter.getName()));
        }
        return parameterValues;
    }

    protected <T> T getDualInputParameterValue(String name, ProcessConstants.AdeptDataType type, Class<T> valueType) {
        Object value = null;
        ProcessModelParameter inParam = this.activityInstance.getParameter(name, ActivityConstants.AccessType.READ);
        if (inParam != null) {
            if (inParam.getDataType() != type) {
                String msg = String.format("The input parameter '%s' is not of type %s!", new Object[]{name, type});
                throw new IllegalArgumentException(msg);
            }
            value = valueType.cast(this.getInputParameterValue(name));
        }
        if (value == null) {
            ActivityConfiguration conf = this.activityInstance.getConfiguration();
            String sValue = conf.getString(name);
            switch (type) {
                case BOOLEAN: {
                    value = Boolean.valueOf(sValue);
                    break;
                }
                case DATE: {
                    value = conf.getDate(name);
                    break;
                }
                case INTEGER: {
                    value = Long.valueOf(sValue);
                    break;
                }
                case FLOAT: {
                    value = Double.valueOf(sValue);
                    break;
                }
                case STRING: {
                    value = sValue;
                    break;
                }
                case URI: {
                    value = URI.create(sValue);
                    break;
                }
                case USERDEFINED: {
                    value = conf.getUDT(name);
                    break;
                }
                default: {
                    String message = "Unsupported data type: " + (Object)((Object)type);
                    long code = -401001L;
                    throw new ApplicationEnvironmentException(message, code);
                }
            }
        }
        return valueType.cast(value);
    }

    protected void writeOutputValues(Object returnValue, Object[] outputParameterValues) {
        Set<ProcessModelParameter> outputParameters = this.activityInstance.getParameters(ActivityConstants.AccessType.WRITE);
        DataContext dataContext = this.sessionContext.getDataContext();
        block14: for (ProcessModelParameter parameter : outputParameters) {
            String pos = parameter.getConfiguration().getString("position");
            if (pos == null) {
                this.logger.info("No position set for parameter " + parameter.getName());
                continue;
            }
            int position = Integer.parseInt(pos);
            if (position < 0) continue;
            String parameterName = parameter.getName();
            ProcessConstants.AdeptDataType type = parameter.getDataType();
            Object value = null;
            if (position == 0) {
                value = returnValue;
            } else {
                try {
                    value = outputParameterValues[position - 1];
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    this.logger.warning(String.format("The parameter '%1$s' of activity '%2$s' has the illegal position '%3$s'. Its value is set to NULL.", parameterName, this.activityInstance.getName(), position));
                }
                if (value == null) {
                    this.logger.warning(String.format("The value of the parameter '%1$s' of activity '%2$s' is not provided. It is set to NULL.", parameterName, this.activityInstance.getName()));
                }
            }
            try {
                switch (type) {
                    case BOOLEAN: {
                        value = this.objectToBoolean(value, parameter, true);
                        if (value == null) {
                            dataContext.ignoreValue(parameterName);
                            continue block14;
                        }
                        dataContext.storeBooleanParameterValue(parameterName, (Boolean)value);
                        continue block14;
                    }
                    case INTEGER: {
                        value = this.objectToInteger(value, parameter, true);
                        if (value == null) {
                            dataContext.ignoreValue(parameterName);
                            continue block14;
                        }
                        dataContext.storeIntegerParameterValue(parameterName, (Long)value);
                        continue block14;
                    }
                    case FLOAT: {
                        value = this.objectToFloat(value, parameter, true);
                        if (value == null) {
                            dataContext.ignoreValue(parameterName);
                            continue block14;
                        }
                        dataContext.storeFloatParameterValue(parameterName, (Double)value);
                        continue block14;
                    }
                    case STRING: {
                        value = this.objectToString(value, parameter, true);
                        if (value == null) {
                            dataContext.ignoreValue(parameterName);
                            continue block14;
                        }
                        dataContext.storeStringParameterValue(parameterName, (String)value);
                        continue block14;
                    }
                    case DATE: {
                        value = this.objectToDate(value, parameter, true);
                        if (value == null) {
                            dataContext.ignoreValue(parameterName);
                            continue block14;
                        }
                        dataContext.storeDateParameterValue(parameterName, (Date)value);
                        continue block14;
                    }
                    case USERDEFINED: {
                        value = this.objectToUserdefined(value, parameter, true);
                        if (value == null) {
                            dataContext.ignoreValue(parameterName);
                            continue block14;
                        }
                        dataContext.storeUDTParameterValue(parameterName, (UDTValue)value);
                        continue block14;
                    }
                    case URI: {
                        value = this.objectToUri(value, parameter, true);
                        if (value == null) {
                            dataContext.ignoreValue(parameterName);
                            continue block14;
                        }
                        dataContext.storeURIParameterValue(parameterName, (URI)value);
                        continue block14;
                    }
                    default: {
                        assert (false) : String.format("Data type '%1$s' of parameter '%2$s' not supported.", new Object[]{type, parameterName});
                        continue block14;
                    }
                }
            }
            catch (NoSuchParameterException noSuchParameterException) {
                this.logger.warning(String.format("There is no output parameter of name '%1$s' in the data context of activity '%2$s'.", parameterName, this.activityInstance.getName()));
            }
            catch (InvalidDataTypeException idte) {
                this.logger.warning(String.format("The output parameter '%1$s' is of type '%2$s' in the data context of activity '%3$s'.", new Object[]{parameterName, idte.getActualDataType(), this.activityInstance.getName()}));
            }
        }
    }

    protected Class<?> getCorrespondingJavaClass(ProcessModelParameter parameter, boolean output) {
        Class<Object> correspondingClass = null;
        switch (parameter.getDataType()) {
            case BOOLEAN: {
                correspondingClass = Boolean.TYPE;
                break;
            }
            case INTEGER: {
                correspondingClass = Long.TYPE;
                break;
            }
            case FLOAT: {
                correspondingClass = Double.TYPE;
                break;
            }
            case STRING: {
                correspondingClass = String.class;
                break;
            }
            case DATE: {
                correspondingClass = Date.class;
                break;
            }
            case USERDEFINED: {
                correspondingClass = Object.class;
                break;
            }
            case URI: {
                correspondingClass = URI.class;
                break;
            }
        }
        return correspondingClass;
    }

    protected Object booleanToNativeTypedValue(Boolean value, ProcessModelParameter parameter, boolean output) {
        return value;
    }

    protected Object integerToNativeTypedValue(Long value, ProcessModelParameter parameter, boolean output) {
        return value;
    }

    protected Object floatToNativeTypedValue(Double value, ProcessModelParameter parameter, boolean output) {
        return value;
    }

    protected Object stringToNativeTypedValue(String value, ProcessModelParameter parameter, boolean output) {
        return value;
    }

    protected Object dateToNativeTypedValue(Date value, ProcessModelParameter parameter, boolean output) {
        return value;
    }

    protected Object userdefinedToNativeTypedValue(UDTValue value, ProcessModelParameter parameter, boolean output) {
        Object ret;
        try {
            ComponentObjectInputStream ois = new ComponentObjectInputStream(value.getValueAsStream());
            ret = ois.readObject();
        }
        catch (IOException ioe) {
            String errorMessage = String.format("Problems converting the value of a UDTValue ('%1$s') to an object when reading from the stream.", parameter.getName());
            this.logger.log(Level.SEVERE, errorMessage, ioe);
            throw new ApplicationFailedException(errorMessage, "ADEPT2:ExecEnvironment:UDTObjectConversionFailed", 800000L);
        }
        catch (ClassNotFoundException cnfe) {
            String errorMessage = String.format("Unable to convert the value of a UDTValue ('%1$s') to an object because the corresponding class is not found.", parameter.getName());
            this.logger.log(Level.SEVERE, errorMessage, cnfe);
            throw new ApplicationEnvironmentException(errorMessage, -402200L);
        }
        return ret;
    }

    protected Object uriToNativeTypedValue(URI value, ProcessModelParameter parameter, boolean output) {
        return value;
    }

    protected Boolean objectToBoolean(Object value, ProcessModelParameter parameter, boolean output) {
        return (Boolean)value;
    }

    protected Long objectToInteger(Object value, ProcessModelParameter parameter, boolean output) {
        return (Long)value;
    }

    protected Double objectToFloat(Object value, ProcessModelParameter parameter, boolean output) {
        return (Double)value;
    }

    protected String objectToString(Object value, ProcessModelParameter parameter, boolean output) {
        return (String)value;
    }

    protected Date objectToDate(Object value, ProcessModelParameter parameter, boolean output) {
        return (Date)value;
    }

    protected UDTValue objectToUserdefined(Object value, ProcessModelParameter parameter, boolean output) {
        ADEPT2UDTValue ret = null;
        try {
            String userDefinedType = parameter.getUDTName();
            ByteArrayOutputStream bytesOut = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(bytesOut);
            oos.writeObject(value);
            oos.flush();
            byte[] byteArray = bytesOut.toByteArray();
            ret = new ADEPT2UDTValue(userDefinedType, byteArray);
        }
        catch (IOException ioe) {
            String message = String.format("Problems converting the value of user-defined data type ('%1$s') to a UDTValue when writing to the stream.", parameter.getName());
            this.logger.log(Level.WARNING, message, ioe);
        }
        return ret;
    }

    protected URI objectToUri(Object value, ProcessModelParameter parameter, boolean output) {
        return (URI)value;
    }

    protected Serializable getApplicationState(int savepointID) throws IOException {
        Serializable ret = null;
        RuntimeEnvironment re = this.sessionContext.getRuntimeEnvironment();
        byte[] state = re.getApplicationState(savepointID);
        if (state != null) {
            InputStream close = null;
            try {
                try {
                    close = new ByteArrayInputStream(state);
                    close = new ComponentObjectInputStream(close);
                    ObjectInputStream ois = (ObjectInputStream)close;
                    ret = (Serializable)ois.readObject();
                }
                catch (ClassNotFoundException cnfe) {
                    String msg = "Did not find class of serialised object state";
                    this.logger.log(Level.WARNING, msg, cnfe);
                    msg = "Did not find class of serialised object state: %s.";
                    throw new IOException(String.format(msg, cnfe.getMessage()));
                }
            }
            finally {
                if (close != null) {
                    close.close();
                }
            }
        }
        return ret;
    }

    protected void setApplicationState(int savepointID, Serializable appState) throws IOException {
        byte[] state = null;
        RuntimeEnvironment re = this.sessionContext.getRuntimeEnvironment();
        if (appState != null) {
            state = StreamTools.toByteArray(appState);
        }
        re.setApplicationState(savepointID, state);
    }
}

