/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.core.runtimemanager.executionenvironments;

import de.aristaflow.adept2.core.runtimemanager.executionenvironments.ExecutionEnvironment;
import de.aristaflow.adept2.model.execution.ActivityInstance;
import de.aristaflow.adept2.model.execution.Vote;
import de.aristaflow.adept2.model.runtimeenvironment.ApplicationEnvironmentException;
import de.aristaflow.adept2.model.runtimeenvironment.ApplicationFailedException;
import de.aristaflow.adept2.model.runtimeenvironment.ExecutableComponent;
import de.aristaflow.adept2.model.runtimeenvironment.IsNotSupportedException;
import de.aristaflow.adept2.model.runtimeenvironment.SessionContext;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.logging.Level;

public class IDExecutionEnvironment
extends ExecutionEnvironment {
    protected ExecutableComponent innerComponent;
    protected SessionContext innerSessionContext;
    protected boolean resume = false;
    protected int savePointID;

    public IDExecutionEnvironment(ActivityInstance activityInstance) {
        super(activityInstance);
        this.innerComponent = this.getComponentToExecute(activityInstance);
        this.logger.info(String.format("Inner Component to be executed: %s", this.innerComponent.getClass().getName()));
    }

    protected ExecutableComponent getComponentToExecute(ActivityInstance activityInstance) {
        ExecutableComponent componentToExecute;
        Constructor<?> constructor;
        Class<?> clazz;
        String componentURI = activityInstance.getConfiguration().getString("ComponentURI");
        this.logger.severe("QA Notice: Used ComponentURI which is deprecated.");
        this.logger.info(String.format("Trying to get Instance for Class '%s'", componentURI));
        try {
            clazz = this.getClass().getClassLoader().loadClass(componentURI);
        }
        catch (ClassNotFoundException e) {
            String message = String.format("Could not find the an implementation for the inner Component '%s' (ActivityInstance: '%s').", componentURI, activityInstance.getName());
            this.logger.log(Level.SEVERE, message, e);
            throw new ApplicationEnvironmentException(message, 0L, e);
        }
        if (!ExecutableComponent.class.isAssignableFrom(clazz)) {
            String message = String.format("The configured class ('%s') for the ActivityInstance '%s' does not implement the ExecutableComponent interface!", clazz.getName(), activityInstance.getName());
            this.logger.severe(message);
            throw new ApplicationEnvironmentException(message, 0L);
        }
        try {
            constructor = clazz.getConstructor(new Class[0]);
        }
        catch (SecurityException e) {
            String message = String.format("SecurityException while trying to get the required empty constructor for '%s'.", clazz.getName());
            this.logger.log(Level.SEVERE, message, e);
            throw new ApplicationEnvironmentException(message, 0L, e);
        }
        catch (NoSuchMethodException e) {
            String message = String.format("No empty public constructor found for '%s'.", clazz.getName());
            this.logger.log(Level.SEVERE, message, e);
            throw new ApplicationEnvironmentException(message, 0L, e);
        }
        try {
            componentToExecute = (ExecutableComponent)constructor.newInstance(new Object[0]);
        }
        catch (IllegalAccessException e) {
            String message = String.format("An IllegalAccessException occurred while trying to instantiate '%s'!\nThe empty constructor needs public access.", clazz.getName());
            this.logger.log(Level.SEVERE, message, e);
            throw new ApplicationEnvironmentException(message, 1100002L, e);
        }
        catch (IllegalArgumentException e) {
            String message = String.format("An IllegalArgumentException occurred while calling the empty constructor for class '%s'!", clazz.getName());
            this.logger.log(Level.SEVERE, message, e);
            throw new ApplicationEnvironmentException(message, 1100001L, e);
        }
        catch (InstantiationException e) {
            String message = String.format("InstantiationException while trying to instantiate class '%s'!\nConfigured interface or abstract class? Compile errors? No usable constructor?", clazz.getName());
            this.logger.log(Level.SEVERE, message, e);
            throw new ApplicationEnvironmentException(message, 0L, e);
        }
        catch (InvocationTargetException e) {
            String message = String.format("An exception occurred while calling the empty constructor for class '%s'.", clazz.getName());
            this.logger.log(Level.SEVERE, message, e);
            throw new ApplicationEnvironmentException(message, 1100003L, e);
        }
        return componentToExecute;
    }

    @Override
    public void init(SessionContext sessionContext) {
        this.sessionContext = sessionContext;
        this.innerSessionContext = sessionContext;
    }

    @Override
    public void initResume(int savePointID, SessionContext sessionContext) {
        this.init(sessionContext);
        this.resume = true;
        this.savePointID = savePointID;
    }

    @Override
    public void run() {
        if (this.innerSessionContext != null) {
            this.initialise();
            try {
                this.innerComponent.run();
            }
            catch (ApplicationEnvironmentException aee) {
                this.logger.log(Level.SEVERE, String.format("ApplicationEnvironmentException occurred in inner Component at '%s'. Setting application failed (%s).", this.activityInstance.getName(), aee.getErrorCode()), aee);
                throw aee;
            }
            catch (ApplicationFailedException afe) {
                this.logger.log(Level.SEVERE, String.format("ApplicationFailedException occurred in inner Component at '%s'. Setting application failed (%s).", this.activityInstance.getName(), afe.getErrorCode()), afe);
                throw afe;
            }
            catch (RuntimeException re) {
                this.logger.log(Level.SEVERE, String.format("RuntimeException '%3$s' occurred in inner Component at '%1$s'. Setting application failed (%2$s).", this.activityInstance.getName(), 1600000L, re), re);
                throw re;
            }
        } else {
            String message = String.format("'%s' does not have a valid session context before executing.", this.activityInstance.getName());
            this.logger.severe(message);
            throw new ApplicationFailedException(message, "ADEPT2:ComponentExecutor:ApplicationEnvironmentException", -300000L);
        }
        this.finish();
    }

    @Override
    public boolean close() {
        return this.innerComponent.close();
    }

    @Override
    public boolean reset() {
        return this.innerComponent.reset();
    }

    @Override
    public boolean signal(int signal) {
        return this.innerComponent.signal(signal);
    }

    @Override
    public boolean suspend() {
        return this.innerComponent.suspend();
    }

    @Override
    public boolean kill() {
        return this.innerComponent.kill();
    }

    @Override
    public Vote prepareCommit() throws IsNotSupportedException {
        return this.innerComponent.prepareCommit();
    }

    @Override
    public boolean rollback() throws IsNotSupportedException {
        return this.innerComponent.rollback();
    }

    @Override
    public void commit() throws IsNotSupportedException {
        this.innerComponent.commit();
    }

    protected void initialise() {
        this.logger.info(String.format("Execution of inner Component of ActivityInstance '%s'initialised.", this.activityInstance.getName()));
        if (this.resume) {
            this.logger.info("Restoring application state of '" + this.activityInstance.getName() + "'.");
            this.innerComponent.initResume(this.savePointID, this.innerSessionContext);
        } else {
            this.innerComponent.init(this.innerSessionContext);
        }
    }

    protected void finish() {
        this.logger.info(String.format("Execution of inner Component of ActivityInstance '%s' finished.", this.activityInstance.getName()));
        this.innerSessionContext = null;
    }
}

