/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.core.runtimemanager.gui;

import de.aristaflow.adept2.base.configuration.ConfigurationDescription;
import de.aristaflow.adept2.base.configuration.Property;
import de.aristaflow.adept2.base.service.AbstractADEPT2Service;
import de.aristaflow.adept2.base.service.Registry;
import de.aristaflow.adept2.base.service.ServiceNotKnownException;
import de.aristaflow.adept2.base.sessionmanagement.SessionToken;
import de.aristaflow.adept2.core.runtimemanager.ExecutionControlManager;
import de.aristaflow.adept2.core.runtimemanager.RuntimeManager;
import de.aristaflow.adept2.core.runtimemanager.commonimplementation.TerminationExecutor;
import de.aristaflow.adept2.core.runtimemanager.gui.GUIContextUnavailableException;
import de.aristaflow.adept2.core.runtimemanager.gui.GUIManager2;
import de.aristaflow.adept2.core.runtimemanager.gui.RemoteGUIManager;
import de.aristaflow.adept2.model.common.ExecutionControlProperties;
import de.aristaflow.adept2.model.execution.ActivityInstance;
import de.aristaflow.adept2.model.execution.ExecutionContext;
import de.aristaflow.adept2.model.globals.ProcessConstants;
import de.aristaflow.adept2.model.processmodel.EBPInstanceReference;
import de.aristaflow.adept2.model.runtimeenvironment.GUIContext;
import de.aristaflow.adept2.model.runtimeenvironment.guicontext.GUIContextActivityInstance;
import de.aristaflow.adept2.model.runtimeenvironment.guicontext.TransferableGUIContext;
import de.aristaflow.adept2.util.types.Pair;
import java.net.URI;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.configuration.Configuration;

@ConfigurationDescription(properties={@Property(name="TerminateEscalationTime", type=Property.Type.LONG, defaultValue="6000", description="The amount of time in milliseconds to wait until a component reacts after a termination request. If the component does not terminate, the next escalation level will be reached.For instance not responding to a suspend leads to a close, not responding to an abort leads to stopping the threads.")})
public abstract class AbstractGUIManager
extends AbstractADEPT2Service
implements RemoteGUIManager,
GUIManager2 {
    public static final String CONF_TERMINATE_ESCALATION_TIME = "TerminateEscalationTime";
    protected final long TERMINATE_ESCALATION_TIME;
    protected final Map<Pair<EBPInstanceReference, String>, Pair<GUIContext, TransferableGUIContext>> guiContexts;
    protected final Set<Pair<EBPInstanceReference, String>> earlyTerminates;

    public AbstractGUIManager(Configuration configuration, Registry registry) {
        this(configuration, registry, new String[0], new String[0]);
    }

    public AbstractGUIManager(Configuration configuration, Registry registry, String[] startupRequiredServices, String[] runtimeRequiredServices) {
        super(configuration, registry, startupRequiredServices, runtimeRequiredServices);
        this.TERMINATE_ESCALATION_TIME = configuration.getLong(CONF_TERMINATE_ESCALATION_TIME);
        this.guiContexts = new HashMap<Pair<EBPInstanceReference, String>, Pair<GUIContext, TransferableGUIContext>>();
        this.earlyTerminates = new HashSet<Pair<EBPInstanceReference, String>>();
    }

    @Override
    public GUIContext getGUIContext(SessionToken session, ActivityInstance activityInstance, EBPInstanceReference ebpInstanceReference, String sessionID, ExecutionContext executionContext, boolean resume, int savePointID, ExecutionControlManager executionControlManager, Thread thread) throws GUIContextUnavailableException {
        return this.getGUIContext(session, activityInstance, ebpInstanceReference, sessionID, executionContext, executionControlManager, thread);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final GUIContext getGUIContext(SessionToken session, TransferableGUIContext transfrdCtxt) throws GUIContextUnavailableException {
        ExecutionControlManager ecm;
        EBPInstanceReference activity = transfrdCtxt.getEBPInstanceReference();
        String sessionID = transfrdCtxt.getSessionID();
        Pair<EBPInstanceReference, String> index = new Pair<EBPInstanceReference, String>(activity, sessionID);
        try {
            ecm = this.getExecutionControlManager(session, activity);
        }
        catch (ServiceNotKnownException snke) {
            String msg = "Could not retrieve remote execution control manager for activity '%s'. This prevents communication between the local GUI context and the remote execution of the corresponding activity.";
            throw new GUIContextUnavailableException(this.getClass().getName(), msg, snke);
        }
        GUIContext ret = this.createGUIContext(session, transfrdCtxt, ecm);
        Map<Pair<EBPInstanceReference, String>, Pair<GUIContext, TransferableGUIContext>> map = this.guiContexts;
        synchronized (map) {
            if (this.earlyTerminates.contains(index)) {
                this.earlyTerminates.remove(index);
                String msg = "The termination of activity '%s' (session ID: '%s') has alreadybeen signalled before the GUI context has been created. Aborting.";
                throw new GUIContextUnavailableException(this.getClass().getName(), msg);
            }
            this.guiContexts.put(index, new Pair<GUIContext, TransferableGUIContext>(ret, transfrdCtxt));
        }
        return ret;
    }

    public GUIContext createGUIContext(SessionToken session, TransferableGUIContext trCtxt, ExecutionControlManager ecm) throws GUIContextUnavailableException {
        GUIContextActivityInstance wrapped = new GUIContextActivityInstance(trCtxt.getActivityInstance(), trCtxt.getTransferredGUIContextID());
        return this.getGUIContext(session, wrapped, trCtxt.getEBPInstanceReference(), trCtxt.getSessionID(), trCtxt.getExecutionContext(), ecm, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void closeGUIContext(EBPInstanceReference activity, String sessionID) {
        Pair<EBPInstanceReference, String> pair = new Pair<EBPInstanceReference, String>(activity, sessionID);
        Map<Pair<EBPInstanceReference, String>, Pair<GUIContext, TransferableGUIContext>> map = this.guiContexts;
        synchronized (map) {
            if (this.guiContexts.containsKey(pair)) {
                this.guiContexts.remove(pair).getFirst().close();
            } else {
                this.earlyTerminates.add(pair);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProcessConstants.NodeState terminateRemoteExecution(SessionToken session, EBPInstanceReference activity, String sessionID) throws ServiceNotKnownException {
        Pair<GUIContext, TransferableGUIContext> contexts;
        ProcessConstants.NodeState ret = null;
        Pair<EBPInstanceReference, String> pair = new Pair<EBPInstanceReference, String>(activity, sessionID);
        Map<Pair<EBPInstanceReference, String>, Pair<GUIContext, TransferableGUIContext>> map = this.guiContexts;
        synchronized (map) {
            contexts = this.guiContexts.get(pair);
        }
        if (contexts != null) {
            URI[] rtURIs = activity.getRuntimeManagerURIs();
            ExecutionControlProperties ecp = contexts.getSecond().getActivityInstance().getExecutionControlProperties();
            ExecutionControlManager ecm = this.getExecutionControlManager(session, activity);
            TerminationExecutor termination = new TerminationExecutor(session, null, rtURIs, activity, ecp, this.TERMINATE_ESCALATION_TIME, true, ecm);
            ret = termination.call();
        } else {
            String msg = "Cannot terminate the remote execution of activity '%s' (session ID: '%s') since it is not known by this GUI manager.";
            this.logger.info(String.format(msg, activity, sessionID));
        }
        return ret;
    }

    protected ExecutionControlManager getExecutionControlManager(SessionToken session, EBPInstanceReference activity) throws ServiceNotKnownException {
        RuntimeManager runtimeMgr = this.registry.getService(session, activity.getRuntimeManagerURIs(), RuntimeManager.class);
        return runtimeMgr.getExecutionControlManager();
    }
}

