/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.core.runtimeservice.defaultimplementation;

import de.aristaflow.adept2.base.service.AbstractADEPT2Service;
import de.aristaflow.adept2.base.service.AbstractSubService;
import de.aristaflow.adept2.base.service.InternalServiceException;
import de.aristaflow.adept2.base.service.Registry;
import de.aristaflow.adept2.base.service.ServiceNotKnownException;
import de.aristaflow.adept2.base.sessionmanagement.SessionFactory;
import de.aristaflow.adept2.base.sessionmanagement.SessionToken;
import de.aristaflow.adept2.core.executionmanager.ActivityStarting;
import de.aristaflow.adept2.core.executionmanager.ExecutionManager;
import de.aristaflow.adept2.core.runtimeservice.ExecutionMessageListener;
import de.aristaflow.adept2.core.runtimeservice.ExecutionMessageNotification;
import de.aristaflow.adept2.core.runtimeservice.RemoteActivityStarting;
import de.aristaflow.adept2.model.datamanagement.InvalidDataTypeException;
import de.aristaflow.adept2.model.datamanagement.NoSuchParameterException;
import de.aristaflow.adept2.model.execution.ActivityInstance;
import de.aristaflow.adept2.model.execution.AgentUnknownException;
import de.aristaflow.adept2.model.execution.ExecutionContext;
import de.aristaflow.adept2.model.execution.InvalidActivityStateException;
import de.aristaflow.adept2.model.globals.ProcessConstants;
import de.aristaflow.adept2.model.processmodel.EBPInstanceReference;
import de.aristaflow.adept2.model.processmodel.InvalidInstanceStateException;
import de.aristaflow.adept2.model.runtimeenvironment.RuntimeEnvironmentFactory;
import de.aristaflow.adept2.model.runtimeenvironment.SerialisableDataContext;
import de.aristaflow.adept2.model.runtimeenvironment.SimpleSessionContext;
import de.aristaflow.adept2.util.time.TimeCalculations;
import de.aristaflow.adept2.util.types.Pair;
import java.net.URI;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

public class DefaultRemoteActivityStarting
extends AbstractSubService
implements RemoteActivityStarting {
    protected final Registry registry;
    protected SessionFactory sessionFactory;
    protected Map<EBPInstanceReference, SimpleSessionContext> sessionContexts;
    protected Map<EBPInstanceReference, Pair<CountDownLatch, ExecutionMessageNotification>> latches;
    protected RuntimeEnvironmentFactory rteFactory;

    public DefaultRemoteActivityStarting(AbstractADEPT2Service service, Registry registry) {
        super(service);
        this.registry = registry;
        this.sessionContexts = Collections.synchronizedMap(new HashMap());
        this.latches = new HashMap<EBPInstanceReference, Pair<CountDownLatch, ExecutionMessageNotification>>();
    }

    public void init(SessionFactory sessionFactory, RuntimeEnvironmentFactory rteFactory) {
        this.sessionFactory = sessionFactory;
        this.rteFactory = rteFactory;
    }

    @Override
    public SimpleSessionContext startActivity(SessionToken session, EBPInstanceReference activity, ProcessConstants.ExecutionMode executionMode, URI[] exeMsgListener, long timeout) throws InvalidActivityStateException, InvalidInstanceStateException, InterruptedException {
        super.sessionActive(session);
        try {
            SimpleSessionContext simpleSessionContext = this.startOrResumeActivity(session, activity, executionMode, exeMsgListener, timeout);
            return simpleSessionContext;
        }
        finally {
            super.sessionFinished(session);
        }
    }

    @Override
    public SimpleSessionContext resumeActivity(SessionToken session, EBPInstanceReference activity, URI[] exeMsgListener, long timeout) throws InvalidActivityStateException, InvalidInstanceStateException, InterruptedException {
        super.sessionActive(session);
        try {
            SimpleSessionContext simpleSessionContext = this.startOrResumeActivity(session, activity, null, exeMsgListener, timeout);
            return simpleSessionContext;
        }
        finally {
            super.sessionFinished(session);
        }
    }

    @Override
    public SimpleSessionContext getSimpleSessionContext(SessionToken session, EBPInstanceReference activity, ProcessConstants.ExecutionMode executionMode) throws InvalidActivityStateException, InvalidInstanceStateException {
        super.sessionActive(session);
        try {
            SimpleSessionContext ret;
            activity.setRuntimeManagerURIs(this.getURIs());
            ActivityStarting activityStarting = this.registry.getService(session, activity.getExecutionManagerURIs(), ExecutionManager.class).getActivityStarting();
            ExecutionContext execContext = activityStarting.getExecutionContext(session, activity);
            ActivityInstance actInst = (ActivityInstance)execContext.getEBPInstance();
            SerialisableDataContext dataContext = this.rteFactory.createSerialisableDataContext(session, execContext.getDataContainer(), actInst);
            SimpleSessionContext simpleSessionContext = ret = this.rteFactory.createSimpleSessionContext(null, activity, dataContext, actInst, execContext.getExecutionMode(), execContext.getCurrentEnquiry(), execContext.getRepliedEnquiry(), null);
            return simpleSessionContext;
        }
        catch (ServiceNotKnownException snke) {
            String msg = "Could not get simple session context for activity '%s' since the required services could not be retrieved. Ignoring request. Check the configuration.";
            msg = String.format(msg, activity);
            throw new InternalServiceException(msg, snke);
        }
        catch (NoSuchParameterException nspe) {
            String msg = "Could not create the data context for activity '%s' since not all parameter of the activity instance are in the data container. This seems to be an implementation problem.";
            msg = String.format(msg, activity);
            throw new InternalServiceException(msg, nspe);
        }
        catch (InvalidDataTypeException idte) {
            String msg = "Could not create the data context for activity '%s' since the data types of the parameter of the activity instance differ from the ones in the data container. This seems to be an implementation problem.";
            msg = String.format(msg, activity);
            throw new InternalServiceException(msg, idte);
        }
        finally {
            super.sessionFinished(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ExecutionMessageNotification signalActivation(EBPInstanceReference activity, SimpleSessionContext sessionContext) {
        ExecutionMessageNotification ret = null;
        Map<EBPInstanceReference, SimpleSessionContext> map = this.sessionContexts;
        synchronized (map) {
            if (this.sessionContexts.containsKey(activity)) {
                this.sessionContexts.put(activity, sessionContext);
                Pair<CountDownLatch, ExecutionMessageNotification> pair = this.latches.remove(activity);
                pair.getFirst().countDown();
                ret = pair.getSecond();
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SimpleSessionContext startOrResumeActivity(SessionToken session, EBPInstanceReference activity, ProcessConstants.ExecutionMode executionMode, URI[] exeMsgListener, long timeout) throws InvalidActivityStateException, InvalidInstanceStateException, InterruptedException {
        ActivityStarting activityStarting;
        if (!activity.isActivity()) {
            String msg = "Cannot %s the activity '%s' since it is not appropriate for being executed by a runtime service. Aborting.";
            msg = String.format(msg, executionMode != null ? "start" : "resume", activity);
            throw new IllegalArgumentException(msg);
        }
        ExecutionMessageNotification exeMsgNot = null;
        try {
            activityStarting = this.registry.getService(session, activity.getExecutionManagerURIs(), ExecutionManager.class).getActivityStarting();
            if (exeMsgListener != null) {
                SessionToken privSession = this.sessionFactory.getSessionToken(this.getURIs());
                exeMsgNot = this.resolveExecutionMessageListenerByURI(privSession, exeMsgListener);
            }
        }
        catch (ServiceNotKnownException snke) {
            String msg = "Could not %s activity '%s' since the required services could not be retrieved. Ignoring start. Check the configuration.";
            msg = String.format(msg, executionMode != null ? "start" : "resume", activity);
            throw new InternalServiceException(msg, snke);
        }
        CountDownLatch latch = new CountDownLatch(1);
        Map<EBPInstanceReference, SimpleSessionContext> msg = this.sessionContexts;
        synchronized (msg) {
            this.sessionContexts.put(activity, null);
            this.latches.put(activity, new Pair<CountDownLatch, ExecutionMessageNotification>(latch, exeMsgNot));
        }
        activity.setRuntimeManagerURIs(this.getURIs());
        try {
            if (executionMode != null) {
                activityStarting.startActivity(session, activity, executionMode);
            } else {
                activityStarting.resumeActivity(session, activity);
            }
        }
        catch (AgentUnknownException aue) {
            String msg2 = "%s failed since the activity '%s' is delegated to the wrong runtime manager. This is a programming error since this runtime manager has been set to execute the activity.";
            msg2 = String.format(msg2, executionMode != null ? "Starting" : "Resuming", activity);
            throw new InternalServiceException(msg2, aue);
        }
        return this.waitForSessionContext(activity, latch, timeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SimpleSessionContext waitForSessionContext(EBPInstanceReference activity, CountDownLatch latch, long timeout) throws InterruptedException {
        long start = System.nanoTime();
        long timeLeft = TimeCalculations.timeLeft(start, timeout, TimeUnit.MILLISECONDS);
        while (!this.sessionContexts.containsKey(activity) && timeLeft > 0L) {
            latch.await(timeout, TimeUnit.MILLISECONDS);
            timeLeft = TimeCalculations.timeLeft(start, timeout, TimeUnit.MILLISECONDS);
        }
        Map<EBPInstanceReference, SimpleSessionContext> map = this.sessionContexts;
        synchronized (map) {
            this.latches.remove(activity);
            return this.sessionContexts.remove(activity);
        }
    }

    protected ExecutionMessageNotification resolveExecutionMessageListenerByURI(SessionToken session, URI[] stateListener) throws ServiceNotKnownException {
        ExecutionMessageListener listener = this.registry.getService(session, stateListener, ExecutionMessageListener.class);
        return listener.getExecutionMessageNotification();
    }
}

