/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.core.runtimeservice.defaultimplementation;

import de.aristaflow.adept2.base.service.AbstractADEPT2Service;
import de.aristaflow.adept2.base.sessionmanagement.SessionToken;
import de.aristaflow.adept2.core.runtimemanager.commonimplementation.AbstractExecutionControlManager;
import de.aristaflow.adept2.core.runtimemanager.commonimplementation.ActivityManager;
import de.aristaflow.adept2.core.runtimeservice.RemoteExecutionControlManager;
import de.aristaflow.adept2.core.runtimeservice.defaultimplementation.DefaultRemoteRuntimeEnvironment;
import de.aristaflow.adept2.core.runtimeservice.defaultimplementation.ExecutionMessageReceiver;
import de.aristaflow.adept2.model.processmodel.EBPInstanceReference;
import de.aristaflow.adept2.model.runtimeenvironment.ActivityState;
import de.aristaflow.adept2.model.runtimeenvironment.UnknownSessionException;
import de.aristaflow.adept2.model.runtimeenvironment.messages.execution.BooleanReplyMessage;
import de.aristaflow.adept2.model.runtimeenvironment.messages.execution.CloseMessage;
import de.aristaflow.adept2.model.runtimeenvironment.messages.execution.KillMessage;
import de.aristaflow.adept2.model.runtimeenvironment.messages.execution.ReplyMessage;
import de.aristaflow.adept2.model.runtimeenvironment.messages.execution.ResetMessage;
import de.aristaflow.adept2.model.runtimeenvironment.messages.execution.SignalMessage;
import de.aristaflow.adept2.model.runtimeenvironment.messages.execution.SuspendMessage;
import java.util.logging.Level;

public class DefaultRemoteECM
extends AbstractExecutionControlManager
implements RemoteExecutionControlManager {
    protected final DefaultRemoteRuntimeEnvironment runtimeEnvironments;
    protected final long killTimeout;

    public DefaultRemoteECM(AbstractADEPT2Service service, ActivityManager activityManager, DefaultRemoteRuntimeEnvironment runtimeEnvironments, long killTimeout) {
        super(service, activityManager);
        this.runtimeEnvironments = runtimeEnvironments;
        this.killTimeout = killTimeout;
    }

    @Override
    protected void sendSuspendMessage(SessionToken session, EBPInstanceReference activity) {
        try {
            String sessionID = this.activityManager.getSessionID(session, activity);
            ExecutionMessageReceiver receiver = this.runtimeEnvironments.getMessageReceiver(session, sessionID);
            long messageID = this.runtimeEnvironments.getNextMessageID();
            SuspendMessage message = new SuspendMessage(messageID, sessionID, false);
            receiver.sendMessageToExecution(message);
        }
        catch (UnknownSessionException use) {
            String msg = "Could not send suspend request to the execution of activity '%s'. Probably the activity is not running (any more).";
            msg = String.format(msg, activity);
            throw new IllegalArgumentException(msg, use);
        }
    }

    @Override
    protected void sendCloseMessage(SessionToken session, EBPInstanceReference activity) {
        try {
            String sessionID = this.activityManager.getSessionID(session, activity);
            ExecutionMessageReceiver receiver = this.runtimeEnvironments.getMessageReceiver(session, sessionID);
            long messageID = this.runtimeEnvironments.getNextMessageID();
            CloseMessage message = new CloseMessage(messageID, sessionID, false);
            receiver.sendMessageToExecution(message);
        }
        catch (UnknownSessionException use) {
            String msg = "Could not send close request to the execution of activity '%s'. Probably the activity is not running (any more).";
            msg = String.format(msg, activity);
            throw new IllegalArgumentException(msg, use);
        }
    }

    @Override
    protected void sendResetMessage(SessionToken session, EBPInstanceReference activity) {
        try {
            String sessionID = this.activityManager.getSessionID(session, activity);
            ExecutionMessageReceiver receiver = this.runtimeEnvironments.getMessageReceiver(session, sessionID);
            long messageID = this.runtimeEnvironments.getNextMessageID();
            ResetMessage message = new ResetMessage(messageID, sessionID, false);
            receiver.sendMessageToExecution(message);
        }
        catch (UnknownSessionException use) {
            String msg = "Could not send reset request to the execution of activity '%s'. Probably the activity is not running (any more).";
            msg = String.format(msg, activity);
            throw new IllegalArgumentException(msg, use);
        }
    }

    @Override
    protected void sendKillMessage(SessionToken session, EBPInstanceReference activity) {
        try {
            String sessionID = this.activityManager.getSessionID(session, activity);
            ExecutionMessageReceiver receiver = this.runtimeEnvironments.getMessageReceiver(session, sessionID);
            long messageID = this.runtimeEnvironments.getNextMessageID();
            KillMessage message = new KillMessage(messageID, sessionID, false);
            receiver.sendMessageToExecution(message);
        }
        catch (UnknownSessionException use) {
            String msg = "Could not send abort request to the execution of activity '%s'. Probably the activity is not running (any more).";
            msg = String.format(msg, activity);
            throw new IllegalArgumentException(msg, use);
        }
    }

    @Override
    protected void sendSignalMessage(SessionToken session, EBPInstanceReference activity, int signal) {
        try {
            String sessionID = this.activityManager.getSessionID(session, activity);
            ExecutionMessageReceiver receiver = this.runtimeEnvironments.getMessageReceiver(session, sessionID);
            long messageID = this.runtimeEnvironments.getNextMessageID();
            SignalMessage message = new SignalMessage(signal, messageID, sessionID, false);
            receiver.sendMessageToExecution(message);
        }
        catch (UnknownSessionException use) {
            String msg = "Could not send signal '%d' to the execution of activity '%s'. Probably the activity is not running (any more).";
            msg = String.format(msg, signal, activity);
            throw new IllegalArgumentException(msg, use);
        }
    }

    @Override
    public boolean suspendActivity(SessionToken session, EBPInstanceReference activity, long timeout) throws InterruptedException {
        try {
            Boolean replied;
            String sessionID = this.activityManager.getSessionID(session, activity);
            ExecutionMessageReceiver receiver = this.runtimeEnvironments.getMessageReceiver(session, sessionID);
            long messageID = this.runtimeEnvironments.getNextMessageID();
            SuspendMessage message = new SuspendMessage(messageID, sessionID, true);
            ReplyMessage<?> reply = receiver.sendMessageToExecution(message, timeout);
            boolean ret = false;
            if (reply instanceof BooleanReplyMessage && (replied = (Boolean)((BooleanReplyMessage)reply).getReply()) != null) {
                ret = replied;
            }
            return ret;
        }
        catch (UnknownSessionException use) {
            String msg = "Could not send suspend request to the execution of activity '%s'. Probably the activity is not running (any more).";
            msg = String.format(msg, activity);
            throw new IllegalArgumentException(msg, use);
        }
    }

    @Override
    public boolean finishActivity(SessionToken session, EBPInstanceReference activity, long timeout) throws InterruptedException {
        try {
            Boolean replied;
            String sessionID = this.activityManager.getSessionID(session, activity);
            ExecutionMessageReceiver receiver = this.runtimeEnvironments.getMessageReceiver(session, sessionID);
            long messageID = this.runtimeEnvironments.getNextMessageID();
            CloseMessage message = new CloseMessage(messageID, sessionID, true);
            ReplyMessage<?> reply = receiver.sendMessageToExecution(message, timeout);
            boolean ret = false;
            if (reply instanceof BooleanReplyMessage && (replied = (Boolean)((BooleanReplyMessage)reply).getReply()) != null) {
                ret = replied;
            }
            return ret;
        }
        catch (UnknownSessionException use) {
            String msg = "Could not send close request to the execution of activity '%s'. Probably the activity is not running (any more).";
            msg = String.format(msg, activity);
            throw new IllegalArgumentException(msg, use);
        }
    }

    @Override
    public boolean resetActivity(SessionToken session, EBPInstanceReference activity, long timeout) throws InterruptedException {
        try {
            Boolean replied;
            String sessionID = this.activityManager.getSessionID(session, activity);
            ExecutionMessageReceiver receiver = this.runtimeEnvironments.getMessageReceiver(session, sessionID);
            long messageID = this.runtimeEnvironments.getNextMessageID();
            ResetMessage message = new ResetMessage(messageID, sessionID, true);
            ReplyMessage<?> reply = receiver.sendMessageToExecution(message, timeout);
            boolean ret = false;
            if (reply instanceof BooleanReplyMessage && (replied = (Boolean)((BooleanReplyMessage)reply).getReply()) != null) {
                ret = replied;
            }
            return ret;
        }
        catch (UnknownSessionException use) {
            String msg = "Could not send reset request to the execution of activity '%s'. Probably the activity is not running (any more).";
            msg = String.format(msg, activity);
            throw new IllegalArgumentException(msg, use);
        }
    }

    @Override
    public boolean sendSignalToActivity(SessionToken session, EBPInstanceReference activity, int signal, long timeout) throws InterruptedException {
        try {
            Boolean replied;
            String sessionID = this.activityManager.getSessionID(session, activity);
            ExecutionMessageReceiver receiver = this.runtimeEnvironments.getMessageReceiver(session, sessionID);
            long messageID = this.runtimeEnvironments.getNextMessageID();
            SignalMessage message = new SignalMessage(signal, messageID, sessionID, true);
            ReplyMessage<?> reply = receiver.sendMessageToExecution(message, timeout);
            boolean ret = false;
            if (reply instanceof BooleanReplyMessage && (replied = (Boolean)((BooleanReplyMessage)reply).getReply()) != null) {
                ret = replied;
            }
            return ret;
        }
        catch (UnknownSessionException use) {
            String msg = "Could not send signal '%d' to the execution of activity '%s'. Probably the activity is not running (any more).";
            msg = String.format(msg, signal, activity);
            throw new IllegalArgumentException(msg, use);
        }
    }

    @Override
    protected void killActivity(SessionToken parentSession, EBPInstanceReference activity) {
        String sessionID;
        String msg;
        boolean terminated = false;
        try {
            ActivityState state = this.activityManager.waitForTermination(parentSession, activity, this.killTimeout);
            terminated = state == null || state.getState() == ActivityState.State.TERMINATING || state.getState() == ActivityState.State.TERMINATED;
        }
        catch (InterruptedException interruptedException) {
            msg = String.format("Interrupted while waiting for activity '%s'. Abortingthe activity immediately without waiting", activity);
            this.logger.info(msg);
            Thread.currentThread().interrupt();
        }
        if (!terminated && (sessionID = this.activityManager.getSessionID(parentSession, activity)) != null) {
            SessionToken session = this.getChildSession(parentSession);
            msg = String.format("The execution of activity '%s' did not respond to an abort. The activity will be set to failed.", activity);
            this.logger.info(msg);
            try {
                this.runtimeEnvironments.uncheckedApplicationFailed(session, sessionID, msg, "ADEPT2:RuntimeManager:ComponentStopped", 666666L, null);
            }
            catch (UnknownSessionException use) {
                msg = String.format("The session ID '%s' of activity '%s' did not exist any more when trying to fail it after it did not respond to an abort request. Obviously it has terminated finally.", sessionID, activity);
                this.logger.log(Level.INFO, msg, use);
            }
        }
    }
}

