/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.core.runtimeservice.defaultimplementation;

import de.aristaflow.adept2.base.sessionmanagement.SessionToken;
import de.aristaflow.adept2.core.runtimeservice.RemoteProgressMonitor;
import de.aristaflow.adept2.core.runtimeservice.defaultimplementation.SessionChecker;
import de.aristaflow.adept2.model.runtimeenvironment.ProgressMonitor;
import de.aristaflow.adept2.model.runtimeenvironment.TaskState;
import de.aristaflow.adept2.model.runtimeenvironment.UnknownSessionException;
import de.aristaflow.adept2.util.ArgChecks;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class DefaultRemoteProgressMonitor
implements RemoteProgressMonitor {
    protected final ReadWriteLock lock = new ReentrantReadWriteLock();
    protected final Map<String, ProgressMonitor> monitors = new HashMap<String, ProgressMonitor>();
    protected final SessionChecker sessionChecker;

    protected DefaultRemoteProgressMonitor(SessionChecker sessionChecker) {
        this.sessionChecker = sessionChecker;
    }

    protected ProgressMonitor getOrThrowUSE(String sessionID) throws UnknownSessionException {
        ProgressMonitor ret = this.monitors.get(sessionID);
        if (ret == null) {
            String msg = "No progress monitor available for the execution session.";
            throw new UnknownSessionException(sessionID, msg);
        }
        return ret;
    }

    public void add(String sessionID, ProgressMonitor monitor) {
        ArgChecks.checkForEmpty(sessionID, "sessionID");
        ArgChecks.checkForNull(monitor, "monitor");
        this.lock.writeLock().lock();
        try {
            this.monitors.put(sessionID, monitor);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public ProgressMonitor get(String sessionID) throws UnknownSessionException {
        this.lock.readLock().lock();
        try {
            ProgressMonitor progressMonitor = this.getOrThrowUSE(sessionID);
            return progressMonitor;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public void remove(String sessionID) {
        this.lock.writeLock().lock();
        try {
            this.monitors.remove(sessionID);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public void beginTask(SessionToken token, String sessionID) throws UnknownSessionException {
        this.sessionChecker.checkSessions(token, sessionID);
        this.lock.readLock().lock();
        try {
            this.getOrThrowUSE(sessionID).beginTask();
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public void beginTask(SessionToken token, String sessionID, int overallWorkUnits) throws UnknownSessionException {
        this.sessionChecker.checkSessions(token, sessionID);
        this.lock.readLock().lock();
        try {
            this.getOrThrowUSE(sessionID).beginTask(overallWorkUnits);
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public void progress(SessionToken token, String sessionID) throws UnknownSessionException {
        this.sessionChecker.checkSessions(token, sessionID);
        this.lock.readLock().lock();
        try {
            this.getOrThrowUSE(sessionID).progress();
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public void endTask(SessionToken token, String sessionID) throws UnknownSessionException {
        this.sessionChecker.checkSessions(token, sessionID);
        this.lock.readLock().lock();
        try {
            this.getOrThrowUSE(sessionID).endTask();
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public void setTaskState(SessionToken token, String sessionID, TaskState taskState) throws UnknownSessionException {
        this.sessionChecker.checkSessions(token, sessionID);
        this.lock.readLock().lock();
        try {
            this.getOrThrowUSE(sessionID).setTaskState(taskState);
        }
        finally {
            this.lock.readLock().unlock();
        }
    }
}

