/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.core.runtimeservice.defaultimplementation;

import de.aristaflow.adept2.base.sessionmanagement.SessionToken;
import de.aristaflow.adept2.core.runtimemanager.commonimplementation.ApplicationSignalling;
import de.aristaflow.adept2.core.runtimeservice.ExecutionMessageNotification;
import de.aristaflow.adept2.core.runtimeservice.RemoteRuntimeEnvironment;
import de.aristaflow.adept2.core.runtimeservice.defaultimplementation.ExecutionMessageReceiver;
import de.aristaflow.adept2.core.runtimeservice.defaultimplementation.PullMessageExchange;
import de.aristaflow.adept2.core.runtimeservice.defaultimplementation.PushMessageExchange;
import de.aristaflow.adept2.core.runtimeservice.defaultimplementation.SessionChecker;
import de.aristaflow.adept2.model.datamanagement.DataContainer;
import de.aristaflow.adept2.model.datamanagement.InvalidDataTypeException;
import de.aristaflow.adept2.model.datamanagement.NoSuchParameterException;
import de.aristaflow.adept2.model.globals.ProcessConstants;
import de.aristaflow.adept2.model.runtimeenvironment.ApplicationEnvironmentException;
import de.aristaflow.adept2.model.runtimeenvironment.ApplicationFailedException;
import de.aristaflow.adept2.model.runtimeenvironment.SerialisableDataContext;
import de.aristaflow.adept2.model.runtimeenvironment.UnknownSessionException;
import de.aristaflow.adept2.model.runtimeenvironment.messages.execution.ExecutionMessage;
import de.aristaflow.adept2.model.runtimeenvironment.messages.execution.ReplyMessage;
import de.aristaflow.adept2.util.ArgChecks;
import de.aristaflow.adept2.util.LoggerTools;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DefaultRemoteRuntimeEnvironment
implements RemoteRuntimeEnvironment {
    private static AtomicLong lastUsedMessageID = new AtomicLong();
    protected final Logger logger = LoggerTools.getLogger(this);
    protected final ReentrantReadWriteLock containerLock = new ReentrantReadWriteLock();
    protected final Map<String, DataContainer> dataContainers = new HashMap<String, DataContainer>();
    protected final ReadWriteLock exchangeLock = new ReentrantReadWriteLock();
    protected final Map<String, ExecutionMessageReceiver> messageExchange = new HashMap<String, ExecutionMessageReceiver>();
    protected final SessionChecker sessionChecker;
    protected final ExecutorService notifiers;
    protected final ApplicationSignalling signalling;

    protected DefaultRemoteRuntimeEnvironment(SessionChecker sessionChecker, ExecutorService notifiers, ApplicationSignalling signalling) {
        this.sessionChecker = sessionChecker;
        this.notifiers = notifiers;
        this.signalling = signalling;
    }

    public long getNextMessageID() {
        return lastUsedMessageID.getAndIncrement();
    }

    protected ExecutionMessageReceiver getMessageReceiverOrThrowUSE(String sessionID) throws UnknownSessionException {
        ExecutionMessageReceiver ret = this.messageExchange.get(sessionID);
        if (ret == null) {
            String msg = "No message receiver available for the execution session '%s'.";
            throw new UnknownSessionException(sessionID, String.format(msg, sessionID));
        }
        return ret;
    }

    protected DataContainer getDataContainerOrThrowUSE(String sessionID) throws UnknownSessionException {
        DataContainer ret = this.dataContainers.get(sessionID);
        if (ret == null) {
            String msg = "No data container available for the execution session '%s'.";
            throw new UnknownSessionException(sessionID, String.format(msg, sessionID));
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void storeOutputParameters(SessionToken token, String sessionID, SerialisableDataContext context, DataContainer container) {
        String nspeMsg = "Could not store the output parameter '%s' of the execution session '%s'. It is in the data context provided by the execution session but not in the corresponding data container. Ignoring parameter but this may lead to inconsistent data when validating the written values.";
        String idteMsg = "Could not store the output parameter '%s' of the execution session '%s'. It is of type '%s' in the data context provided by the execution session but of type '%s' in the corresponding data container. Ignoring parameter but this may lead to inconsistent data when validating the written values.";
        if (context != null) {
            DataContainer dataContainer = container;
            synchronized (dataContainer) {
                block15: for (Map.Entry<String, ProcessConstants.AdeptDataType> type : context.getOutputParameters().entrySet()) {
                    String name = type.getKey();
                    try {
                        switch (type.getValue()) {
                            case INTEGER: {
                                if (context.ignoredValue(name)) {
                                    container.ignoreValue(token, name);
                                    continue block15;
                                }
                                container.storeInteger(token, name, context.storedIntegerParameterValue(name));
                                continue block15;
                            }
                            case FLOAT: {
                                if (context.ignoredValue(name)) {
                                    container.ignoreValue(token, name);
                                    continue block15;
                                }
                                container.storeFloat(token, name, context.storedFloatParameterValue(name));
                                continue block15;
                            }
                            case STRING: {
                                if (context.ignoredValue(name)) {
                                    container.ignoreValue(token, name);
                                    continue block15;
                                }
                                container.storeString(token, name, context.storedStringParameterValue(name));
                                continue block15;
                            }
                            case BOOLEAN: {
                                if (context.ignoredValue(name)) {
                                    container.ignoreValue(token, name);
                                    continue block15;
                                }
                                container.storeBoolean(token, name, context.storedBooleanParameterValue(name));
                                continue block15;
                            }
                            case DATE: {
                                if (context.ignoredValue(name)) {
                                    container.ignoreValue(token, name);
                                    continue block15;
                                }
                                container.storeDate(token, name, context.storedDateParameterValue(name));
                                continue block15;
                            }
                            case URI: {
                                if (context.ignoredValue(name)) {
                                    container.ignoreValue(token, name);
                                    continue block15;
                                }
                                container.storeURI(token, name, context.storedURIParameterValue(name));
                                continue block15;
                            }
                            case USERDEFINED: {
                                if (context.ignoredValue(name)) {
                                    container.ignoreValue(token, name);
                                    continue block15;
                                }
                                container.storeUDT(token, name, context.storedUDTParameterValue(name));
                                continue block15;
                            }
                            default: {
                                throw new InvalidDataTypeException(name, null, type.getValue());
                            }
                        }
                    }
                    catch (NoSuchParameterException nspe) {
                        nspeMsg = String.format(nspeMsg, name, sessionID);
                        this.logger.log(Level.WARNING, nspeMsg, nspe);
                    }
                    catch (InvalidDataTypeException idte) {
                        idteMsg = String.format(idteMsg, new Object[]{name, sessionID, idte.getExpectedDataType(), idte.getActualDataType()});
                        this.logger.log(Level.WARNING, idteMsg, idte);
                    }
                }
            }
        }
    }

    public void add(String sessionID, DataContainer container, ExecutionMessageNotification listener) {
        ArgChecks.checkForEmpty(sessionID, "sessionID");
        ArgChecks.checkForNull(container, "container");
        ExecutionMessageReceiver receiver = listener != null ? new PushMessageExchange(listener, this.notifiers) : new PullMessageExchange();
        this.containerLock.writeLock().lock();
        try {
            this.exchangeLock.writeLock().lock();
            try {
                this.dataContainers.put(sessionID, container);
                this.messageExchange.put(sessionID, receiver);
            }
            finally {
                this.exchangeLock.writeLock().unlock();
            }
        }
        finally {
            this.containerLock.writeLock().unlock();
        }
    }

    public void remove(String sessionID) {
        this.containerLock.writeLock().lock();
        try {
            this.exchangeLock.writeLock().lock();
            try {
                this.dataContainers.remove(sessionID);
                this.messageExchange.remove(sessionID);
            }
            finally {
                this.exchangeLock.writeLock().unlock();
            }
        }
        finally {
            this.containerLock.writeLock().unlock();
        }
    }

    public ExecutionMessageReceiver getMessageReceiver(SessionToken token, String sessionID) throws UnknownSessionException {
        this.exchangeLock.readLock().lock();
        try {
            ExecutionMessageReceiver executionMessageReceiver = this.getMessageReceiverOrThrowUSE(sessionID);
            return executionMessageReceiver;
        }
        finally {
            this.exchangeLock.readLock().unlock();
        }
    }

    @Override
    public List<ExecutionMessage> getUnrepliedRequests(SessionToken token, String sessionID) throws UnknownSessionException {
        this.sessionChecker.checkSessions(token, sessionID);
        this.exchangeLock.readLock().lock();
        try {
            List<ExecutionMessage> ret = null;
            ExecutionMessageReceiver receiver = this.getMessageReceiverOrThrowUSE(sessionID);
            if (receiver instanceof PullMessageExchange) {
                ret = ((PullMessageExchange)receiver).getUnrepliedRequests();
            }
            List<ExecutionMessage> list = ret;
            return list;
        }
        finally {
            this.exchangeLock.readLock().unlock();
        }
    }

    @Override
    public boolean replyMessage(SessionToken token, ReplyMessage<?> reply) throws UnknownSessionException {
        this.sessionChecker.checkSessions(token, reply.getSessionID());
        this.exchangeLock.readLock().lock();
        try {
            boolean ret = false;
            ExecutionMessageReceiver receiver = this.getMessageReceiverOrThrowUSE(reply.getSessionID());
            if (receiver instanceof PullMessageExchange) {
                ret = ((PullMessageExchange)receiver).replyMessage(reply);
            }
            boolean bl = ret;
            return bl;
        }
        finally {
            this.exchangeLock.readLock().unlock();
        }
    }

    @Override
    public byte[] getApplicationState(SessionToken token, String sessionID, int savepointID) throws UnknownSessionException {
        this.sessionChecker.checkSessions(token, sessionID);
        this.containerLock.readLock().lock();
        try {
            byte[] byArray = this.getDataContainerOrThrowUSE(sessionID).restoreSessionState(token, savepointID);
            return byArray;
        }
        finally {
            this.containerLock.readLock().unlock();
        }
    }

    @Override
    public int getLastSavepointID(SessionToken token, String sessionID) throws UnknownSessionException {
        this.sessionChecker.checkSessions(token, sessionID);
        this.containerLock.readLock().lock();
        try {
            int n = this.getDataContainerOrThrowUSE(sessionID).getLastSavepointID(token);
            return n;
        }
        finally {
            this.containerLock.readLock().unlock();
        }
    }

    @Override
    public void setApplicationState(SessionToken token, String sessionID, int savepointID, byte[] applicationState) throws UnknownSessionException {
        this.sessionChecker.checkSessions(token, sessionID);
        this.containerLock.readLock().lock();
        try {
            this.getDataContainerOrThrowUSE(sessionID).storeSessionState(token, savepointID, applicationState);
        }
        finally {
            this.containerLock.readLock().unlock();
        }
    }

    @Override
    public void applicationSuspended(SessionToken token, String sessionID, SerialisableDataContext context) throws UnknownSessionException {
        this.sessionChecker.checkSessions(token, sessionID);
        this.containerLock.writeLock().lock();
        try {
            this.signalling.applicationSuspended(token, sessionID);
        }
        finally {
            this.containerLock.writeLock().unlock();
        }
    }

    @Override
    public void applicationReset(SessionToken token, String sessionID, SerialisableDataContext context) throws UnknownSessionException {
        this.sessionChecker.checkSessions(token, sessionID);
        this.containerLock.writeLock().lock();
        try {
            this.signalling.applicationReset(token, sessionID);
        }
        finally {
            this.containerLock.writeLock().unlock();
        }
    }

    @Override
    public void applicationClosed(SessionToken token, String sessionID, SerialisableDataContext context) throws UnknownSessionException {
        ArgChecks.checkForNull(context, "context");
        this.sessionChecker.checkSessions(token, sessionID);
        this.containerLock.writeLock().lock();
        try {
            DataContainer container = this.getDataContainerOrThrowUSE(sessionID);
            this.storeOutputParameters(token, sessionID, context, container);
            this.signalling.applicationClosed(token, sessionID);
        }
        finally {
            this.containerLock.writeLock().unlock();
        }
    }

    @Override
    public void applicationFailed(SessionToken token, String sessionID, String errorMessage, String state, long errorCode, SerialisableDataContext context) throws UnknownSessionException {
        this.sessionChecker.checkSessions(token, sessionID);
        this.uncheckedApplicationFailed(token, sessionID, errorMessage, state, errorCode, context);
    }

    @Override
    public void applicationFailed(SessionToken token, String sessionID, ApplicationFailedException excpt, SerialisableDataContext dataContext) throws UnknownSessionException {
        String msg = "The execution session '%s' signalled failed with an ApplicationFailedException.";
        msg = String.format(msg, sessionID);
        this.logger.log(Level.INFO, msg, excpt);
        this.applicationFailed(token, sessionID, excpt.getCompleteStackTrace(), excpt.getState(), excpt.getErrorCode(), dataContext);
    }

    @Override
    public void applicationFailed(SessionToken token, String sessionID, ApplicationEnvironmentException excpt, SerialisableDataContext dataContext) throws UnknownSessionException {
        String msg = "The execution session '%s' signalled failed with an ApplicationEnvironmentException.";
        msg = String.format(msg, sessionID);
        this.logger.log(Level.INFO, msg, excpt);
        this.applicationFailed(token, sessionID, excpt.getCompleteStackTrace(), "ADEPT2:RuntimeService:ApplicationEnvironmentException", excpt.getErrorCode(), dataContext);
    }

    protected void uncheckedApplicationFailed(SessionToken token, String sessionID, String errorMessage, String state, long errorCode, SerialisableDataContext context) throws UnknownSessionException {
        this.containerLock.writeLock().lock();
        try {
            DataContainer container = this.getDataContainerOrThrowUSE(sessionID);
            this.storeOutputParameters(token, sessionID, context, container);
            this.signalling.applicationFailed(token, sessionID, errorMessage, state, errorCode);
        }
        finally {
            this.containerLock.writeLock().unlock();
        }
    }
}

