/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.core.runtimeservice.defaultimplementation;

import de.aristaflow.adept2.base.configuration.AbortServiceException;
import de.aristaflow.adept2.base.configuration.ConfigurationDescription;
import de.aristaflow.adept2.base.configuration.ConfigurationException;
import de.aristaflow.adept2.base.configuration.Property;
import de.aristaflow.adept2.base.service.AbortTransactionException;
import de.aristaflow.adept2.base.service.AbstractAuthenticatedService;
import de.aristaflow.adept2.base.service.InternalServiceException;
import de.aristaflow.adept2.base.service.Registry;
import de.aristaflow.adept2.base.service.ServiceAccessControlException;
import de.aristaflow.adept2.base.service.ServiceNotKnownException;
import de.aristaflow.adept2.base.sessionmanagement.ClientSessionFactory;
import de.aristaflow.adept2.base.sessionmanagement.QualifiedAgent;
import de.aristaflow.adept2.base.sessionmanagement.SecurityTokenIntegrityException;
import de.aristaflow.adept2.base.sessionmanagement.SessionToken;
import de.aristaflow.adept2.base.sessionmanagement.SignedSecurityToken;
import de.aristaflow.adept2.core.executionmanager.ActivityTermination;
import de.aristaflow.adept2.core.executionmanager.ExecutionManager;
import de.aristaflow.adept2.core.runtimemanager.SynchronousActivityStarting;
import de.aristaflow.adept2.core.runtimemanager.commonimplementation.SimpleApplicationSignalling;
import de.aristaflow.adept2.core.runtimemanager.commonimplementation.TerminationTools;
import de.aristaflow.adept2.core.runtimeservice.ExecutionMessageNotification;
import de.aristaflow.adept2.core.runtimeservice.RemoteActivityStarting;
import de.aristaflow.adept2.core.runtimeservice.RemoteExecutionControlManager;
import de.aristaflow.adept2.core.runtimeservice.RemoteProgressMonitor;
import de.aristaflow.adept2.core.runtimeservice.RemoteRuntimeEnvironment;
import de.aristaflow.adept2.core.runtimeservice.RuntimeService;
import de.aristaflow.adept2.core.runtimeservice.defaultimplementation.DefaultRemoteActivityStarting;
import de.aristaflow.adept2.core.runtimeservice.defaultimplementation.DefaultRemoteECM;
import de.aristaflow.adept2.core.runtimeservice.defaultimplementation.DefaultRemoteProgressMonitor;
import de.aristaflow.adept2.core.runtimeservice.defaultimplementation.DefaultRemoteRuntimeEnvironment;
import de.aristaflow.adept2.core.runtimeservice.defaultimplementation.ExecutionMessageReceiver;
import de.aristaflow.adept2.core.runtimeservice.defaultimplementation.RTServiceActivityManager;
import de.aristaflow.adept2.core.runtimeservice.defaultimplementation.SimpleSessionGUIContext;
import de.aristaflow.adept2.model.execution.ActivityInstance;
import de.aristaflow.adept2.model.execution.AgentUnknownException;
import de.aristaflow.adept2.model.execution.ExecutionContext;
import de.aristaflow.adept2.model.execution.InvalidActivityStateException;
import de.aristaflow.adept2.model.execution.Vote;
import de.aristaflow.adept2.model.globals.EBPType;
import de.aristaflow.adept2.model.globals.ProcessConstants;
import de.aristaflow.adept2.model.processmodel.EBPInstanceReference;
import de.aristaflow.adept2.model.runtimeenvironment.ProgressMonitor;
import de.aristaflow.adept2.model.runtimeenvironment.RuntimeEnvironmentFactory;
import de.aristaflow.adept2.model.runtimeenvironment.SerialisableDataContext;
import de.aristaflow.adept2.model.runtimeenvironment.SimpleSessionContext;
import de.aristaflow.adept2.model.runtimeenvironment.TerminatedActivityState;
import de.aristaflow.adept2.model.runtimeenvironment.UnknownSessionException;
import de.aristaflow.adept2.model.runtimeenvironment.messages.execution.CommitMessage;
import de.aristaflow.adept2.model.runtimeenvironment.messages.execution.RollbackMessage;
import de.aristaflow.adept2.util.Adept2ThreadFactory;
import de.aristaflow.adept2.util.StackTraceTools;
import de.aristaflow.adept2.util.UUIDTools;
import java.net.URI;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import org.apache.commons.configuration.Configuration;

@ConfigurationDescription(properties={@Property(name="IsPersisting", type=Property.Type.BOOLEAN, defaultValue="false", description="Whether the runtime service will persist activity termination calls."), @Property(name="TerminationEscalationTime", type=Property.Type.LONG, defaultValue="5000", description="The amount of time in milliseconds to wait until an execution terminates after an abort request. If it does not respond in time, the corresponding activity will be failed.")})
public class DefaultRuntimeService
extends AbstractAuthenticatedService
implements RuntimeService {
    protected static final String CONF_IS_PERSISTING = "IsPersisting";
    protected static final String CONF_TERMINATION_ESCALATION_TIME = "TerminationEscalationTime";
    protected final boolean IS_PERSISTING;
    protected final long TERMINATION_ESCALATION_TIME;
    private DefaultRemoteActivityStarting activityStarting;
    private RTServiceActivityManager activityManager;
    private SimpleApplicationSignalling applicationSignalling;
    private DefaultRemoteRuntimeEnvironment runtimeEnvironments;
    private DefaultRemoteProgressMonitor progressMonitors;
    private final ExecutorService pushNotifier;
    private DefaultRemoteECM execControlManager;
    private RuntimeEnvironmentFactory rteFactory;

    public DefaultRuntimeService(Configuration configuration, Registry registry) throws ConfigurationException {
        super(configuration, registry, new String[]{"ExecutionManager"}, new String[0]);
        this.IS_PERSISTING = configuration.getBoolean(CONF_IS_PERSISTING);
        this.TERMINATION_ESCALATION_TIME = configuration.getLong(CONF_TERMINATION_ESCALATION_TIME);
        this.pushNotifier = Executors.newCachedThreadPool(new Adept2ThreadFactory("RuntimeService-Notification", this.logger));
    }

    @Override
    public void init(URI[] serviceURIs) throws AbortServiceException {
        super.init(serviceURIs);
        this.activityStarting = new DefaultRemoteActivityStarting(this, this.registry);
        this.activityManager = new RTServiceActivityManager(this, this.getSessionFactory());
        this.applicationSignalling = new SimpleApplicationSignalling(this, this.registry, this.activityManager, this.IS_PERSISTING);
        this.runtimeEnvironments = new DefaultRemoteRuntimeEnvironment(this.activityManager, this.pushNotifier, this.applicationSignalling);
        this.progressMonitors = new DefaultRemoteProgressMonitor(this.activityManager);
        this.execControlManager = new DefaultRemoteECM(this, this.activityManager, this.runtimeEnvironments, this.TERMINATION_ESCALATION_TIME);
        this.activityManager.addForTerminationNotification(this.runtimeEnvironments, this.progressMonitors);
        this.rteFactory = this.registry.getModelFactory("RuntimeEnvironmentFactory", RuntimeEnvironmentFactory.class);
        this.activityStarting.init(this.getSessionFactory(), this.rteFactory);
        this.activityManager.init();
        this.applicationSignalling.init(this.getSessionFactory());
        this.execControlManager.init(this.getSessionFactory());
    }

    @Override
    public void start() throws AbortServiceException {
        super.start();
        this.activityManager.start();
        this.activityStarting.start();
        this.applicationSignalling.start();
        this.execControlManager.start();
    }

    @Override
    public void shutdown() {
        this.logger.info("Shutting down.");
        this.awaitActiveSessions(false);
        this.activityStarting.shutdown();
        this.terminateRunningActivities(false);
        this.terminate(false);
        this.execControlManager.shutdown();
        this.applicationSignalling.shutdown();
        this.activityManager.shutdown();
        super.shutdown();
    }

    @Override
    public void emergencyShutdown() {
        this.logger.info("Emergency Shutdown initiated.");
        this.awaitActiveSessions(true);
        this.activityStarting.emergencyShutdown();
        this.terminateRunningActivities(true);
        this.terminate(true);
        this.execControlManager.emergencyShutdown();
        this.applicationSignalling.emergencyShutdown();
        this.activityManager.emergencyShutdown();
        super.emergencyShutdown();
    }

    protected void terminate(boolean emergency) {
        long timeToWait;
        if (emergency) {
            this.pushNotifier.shutdownNow();
            timeToWait = 5L;
        } else {
            this.pushNotifier.shutdown();
            timeToWait = 10L;
        }
        try {
            if (!this.pushNotifier.awaitTermination(timeToWait, TimeUnit.SECONDS)) {
                String msg = "Thread pool of runtime service message notifier did not %sshut down in time! Continuing service shutdown.";
                msg = String.format(msg, emergency ? "urgently " : "");
                this.logger.warning(msg);
            }
        }
        catch (InterruptedException interruptedException) {}
    }

    @Override
    public void logon(SessionToken session, ClientSessionFactory csf) {
    }

    @Override
    public Map<EBPInstanceReference, ProcessConstants.NodeState> logoffAndTerminateActivities(SessionToken session, QualifiedAgent agent, boolean forceTermination) {
        this.sessionActive(session);
        try {
            Map<EBPInstanceReference, ProcessConstants.NodeState> ret;
            Map<EBPInstanceReference, ProcessConstants.NodeState> map = ret = TerminationTools.terminateRunningActivities(session, this.getSessionFactory(), this.getURIs(), this.activityManager, this.execControlManager, this.TERMINATION_ESCALATION_TIME, forceTermination, this.logger);
            return map;
        }
        finally {
            this.sessionFinished(session);
        }
    }

    @Override
    public void startActivity(SessionToken session, EBPInstanceReference ebpIR, ExecutionContext execContext) throws AgentUnknownException {
        super.sessionActive(session);
        try {
            try {
                this.startOrResumeActivity(session, ebpIR, execContext, false, Integer.MIN_VALUE);
            }
            catch (SecurityTokenIntegrityException stie) {
                String msg = String.format("The designated session token for starting the activity '%s' failed the verification!", ebpIR);
                throw new ServiceAccessControlException(msg, stie);
            }
        }
        finally {
            super.sessionFinished(session);
        }
    }

    @Override
    public void resumeActivity(SessionToken session, EBPInstanceReference ebpIR, ExecutionContext execContext, int savePointID) throws AgentUnknownException {
        super.sessionActive(session);
        try {
            try {
                this.startOrResumeActivity(session, ebpIR, execContext, true, savePointID);
            }
            catch (SecurityTokenIntegrityException stie) {
                String msg = String.format("The designated session token for resuming the activity '%s' failed the verification!", ebpIR);
                throw new ServiceAccessControlException(msg, stie);
            }
        }
        finally {
            super.sessionFinished(session);
        }
    }

    @Override
    public Vote prepareCommit(SessionToken session, EBPInstanceReference ebpIR) {
        super.sessionActive(session);
        try {
            this.logger.severe("prepare Commit not yet implemented");
            return null;
        }
        finally {
            super.sessionFinished(session);
        }
    }

    @Override
    public void commit(SessionToken session, EBPInstanceReference ebpIR) {
        super.sessionActive(session);
        try {
            String sessionID = this.activityManager.getSessionID(session, ebpIR);
            CommitMessage exMsg = new CommitMessage(this.runtimeEnvironments.getNextMessageID(), sessionID);
            try {
                ExecutionMessageReceiver receiver = this.runtimeEnvironments.getMessageReceiver(session, sessionID);
                receiver.sendMessageToExecution(exMsg);
                String msg = "Sent commit signal to activity '%s' (sessionID: '%s').";
                this.logger.info(String.format(msg, ebpIR, sessionID));
            }
            catch (UnknownSessionException use) {
                String msg = "Could not retrieve receiver for activity '%s' (sessionID: '%s'). Commit not possible. Make sure the activity is executed by this runtime service.";
                msg = String.format(msg, ebpIR, sessionID);
                throw new InternalServiceException(msg, use);
            }
        }
        finally {
            super.sessionFinished(session);
        }
    }

    @Override
    public void rollbackActivity(SessionToken session, EBPInstanceReference ebpIR) {
        super.sessionActive(session);
        try {
            String sessionID = this.activityManager.getSessionID(session, ebpIR);
            RollbackMessage exMsg = new RollbackMessage(this.runtimeEnvironments.getNextMessageID(), sessionID, false);
            try {
                ExecutionMessageReceiver receiver = this.runtimeEnvironments.getMessageReceiver(session, sessionID);
                receiver.sendMessageToExecution(exMsg);
                String msg = "Sent rollback signal to activity '%s' (sessionID: '%s').";
                this.logger.info(String.format(msg, ebpIR, sessionID));
            }
            catch (UnknownSessionException use) {
                String msg = "Could not retrieve receiver for activity '%s' (sessionID: '%s'). Rollback not possible. Make sure the activity is executed by this runtime service.";
                msg = String.format(msg, ebpIR, sessionID);
                throw new InternalServiceException(msg, use);
            }
        }
        finally {
            super.sessionFinished(session);
        }
    }

    @Override
    public RemoteExecutionControlManager getExecutionControlManager() {
        return this.execControlManager;
    }

    @Override
    public SynchronousActivityStarting getSynchronousActivityStarting() {
        return null;
    }

    @Override
    public RemoteActivityStarting getRemoteActivityStarting() {
        return this.activityStarting;
    }

    @Override
    public RemoteRuntimeEnvironment getRuntimeEnvironment() {
        return this.runtimeEnvironments;
    }

    @Override
    public RemoteProgressMonitor getProgressMonitor() {
        return this.progressMonitors;
    }

    @Override
    public ProgressMonitor getProgressMonitor(SessionToken session, String sessionID) throws UnknownSessionException {
        super.sessionActive(session);
        try {
            ProgressMonitor progressMonitor = this.progressMonitors.get(sessionID);
            return progressMonitor;
        }
        finally {
            super.sessionFinished(session);
        }
    }

    protected void startOrResumeActivity(final SessionToken session, final EBPInstanceReference ebpIR, final ExecutionContext execContext, boolean resume, int savepointID) throws SecurityTokenIntegrityException {
        this.getSessionFactory().checkIntegrity(session);
        if (!ebpIR.isActivity() && ebpIR.getType() != EBPType.ACTIVITY) {
            String msg = "Cannot %s the activity '%s' since it is not appropriate for being executed by a runtime service. Aborting.";
            msg = String.format(msg, resume ? "resume" : "start", ebpIR);
            throw new IllegalArgumentException(msg);
        }
        if (!this.activityManager.registerNewActivity(session, ebpIR, execContext)) {
            String message = String.format("There is already an activity running for the EBPInstanceReference '%s'! Please wait until this has been terminated", ebpIR);
            this.logger.severe(message);
            throw new IllegalArgumentException(message);
        }
        boolean successfullyStarted = false;
        String sessionID = this.createSessionID(ebpIR);
        try {
            SimpleSessionContext sessionContext;
            ActivityInstance activity = (ActivityInstance)execContext.getEBPInstance();
            try {
                if (Thread.interrupted()) {
                    String msg = "Could not start/resume activity '%s'. The activity has been aborted while initialising.";
                    throw new AbortTransactionException(session, String.format(msg, ebpIR));
                }
                SerialisableDataContext dataContext = this.rteFactory.createSerialisableDataContext(session, execContext.getDataContainer(), activity);
                sessionContext = !resume ? this.rteFactory.createSimpleSessionContext(sessionID, ebpIR, dataContext, activity, execContext.getExecutionMode(), execContext.getCurrentEnquiry(), execContext.getRepliedEnquiry(), null) : this.rteFactory.createSimpleSessionContext(sessionID, savepointID, ebpIR, dataContext, activity, execContext.getExecutionMode(), execContext.getCurrentEnquiry(), execContext.getRepliedEnquiry(), null);
                SimpleSessionGUIContext guiContext = new SimpleSessionGUIContext(sessionContext);
                ProgressMonitor progressMonitor = this.rteFactory.createSimpleProgressMonitor();
                this.progressMonitors.add(sessionID, progressMonitor);
                this.activityManager.activityInitialising(session, ebpIR, sessionID, guiContext);
                if (Thread.interrupted()) {
                    String msg = "Could not start/resume activity '%s'. The activity has been aborted while initialising.";
                    throw new AbortTransactionException(session, String.format(msg, ebpIR));
                }
                this.logger.fine(String.format("Created contexts for activity '%1$s' in '%2$s'-mode for %3$s, session ID: '%4$s'.", ebpIR, execContext.getExecutionMode().name(), resume ? "resuming" : "starting", sessionID));
            }
            catch (Throwable t) {
                this.logger.log(Level.WARNING, String.format("Exception occurred while creating and initialising activity '%1$s'.", ebpIR), t);
                SignedSecurityToken starterToken = session.getTopLevelSecurityToken();
                final SessionToken failSession = this.getSessionFactory().getSubstituteSessionToken(this.createSession(), starterToken);
                Thread failThread = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            URI[] emURIs = ebpIR.getExecutionManagerURIs();
                            ActivityTermination executionManager = DefaultRuntimeService.this.registry.getService(session, emURIs, ExecutionManager.class).getActivityTermination();
                            executionManager.activityFailed(failSession, ebpIR, execContext.getDataContainer(), String.valueOf(t.getMessage()) + "\n" + StackTraceTools.stackTraceToString(t), "ADEPT2:RuntimeManager:ComponentNotLoaded", 200001L);
                            DefaultRuntimeService.this.logger.log(Level.WARNING, String.format("Failed activity '%1$s' due to configuration or instantiation problems!", ebpIR), t);
                        }
                        catch (ServiceNotKnownException serviceNotKnownException) {
                            String iMsg = String.format("Activity '%s' failed due to configuration or instantiation problems and the state could not be set to FAILED since the execution manager was not available.", ebpIR);
                            DefaultRuntimeService.this.logger.log(Level.SEVERE, iMsg, t);
                        }
                        catch (InvalidActivityStateException iase) {
                            String iMsg = String.format("Activity '%s' failed due to configuration or instantiation problems and the state could not be set to FAILED: %s", ebpIR, iase.getMessage());
                            DefaultRuntimeService.this.logger.log(Level.SEVERE, iMsg, t);
                        }
                    }
                }, "RuntimeManager.startOrResumeActivity failed due to a Throwable-Thread");
                if (!execContext.getExecutionMode().equals((Object)ProcessConstants.ExecutionMode.VIEW_ONLY)) {
                    failThread.start();
                }
                if (t instanceof Error) {
                    throw (Error)t;
                }
                if (!successfullyStarted) {
                    TerminatedActivityState state = new TerminatedActivityState(TerminatedActivityState.TerminatedState.FAILED);
                    this.activityManager.activityTerminated(session, ebpIR, state);
                }
                return;
            }
            Thread.interrupted();
            this.logger.info(String.format("%3$s activity '%1$s' in '%2$s'-mode, execution session ID '%4$s'.", ebpIR, execContext.getExecutionMode().name(), resume ? "Resumed" : "Started", sessionID));
            ExecutionMessageNotification notification = this.activityStarting.signalActivation(ebpIR, sessionContext);
            this.runtimeEnvironments.add(sessionID, execContext.getDataContainer(), notification);
            this.activityManager.activityRunning(session, ebpIR, resume);
            successfullyStarted = true;
        }
        finally {
            if (!successfullyStarted) {
                TerminatedActivityState state = new TerminatedActivityState(TerminatedActivityState.TerminatedState.FAILED);
                this.activityManager.activityTerminated(session, ebpIR, state);
            }
        }
    }

    protected String createSessionID(EBPInstanceReference ebpInstanceReference) {
        StringBuilder ret = new StringBuilder();
        ret.append(ebpInstanceReference.getInstanceID());
        ret.append('-');
        ret.append(ebpInstanceReference.getNodeID());
        ret.append('-');
        ret.append(ebpInstanceReference.getNodeIteration());
        ret.append('-');
        ret.append(UUIDTools.createRandomUUID().toString());
        return ret.toString();
    }

    protected void terminateRunningActivities(boolean emergency) {
        this.logger.info("Terminating all running activities. This may take some time. Please wait ...");
        final long escalationTime = emergency ? this.TERMINATION_ESCALATION_TIME / 3L : this.TERMINATION_ESCALATION_TIME;
        ExecutorService terminateExecutors = Executors.newCachedThreadPool(new Adept2ThreadFactory("RuntimeService-Terminate-Thread (all)", this.logger));
        for (Map.Entry<String, SessionToken> currSession : this.activityManager.sessions.entrySet()) {
            final String sessionID = currSession.getKey();
            final SessionToken session = currSession.getValue();
            terminateExecutors.execute(new Runnable(){

                @Override
                public void run() {
                    TerminationTools.terminateRunningActivities(session, DefaultRuntimeService.this.getSessionFactory(), DefaultRuntimeService.this.getURIs(), DefaultRuntimeService.this.activityManager, DefaultRuntimeService.this.execControlManager, escalationTime, true, DefaultRuntimeService.this.logger);
                    String msg = String.format("Shut down activity for execution session '%s'.", sessionID);
                    DefaultRuntimeService.this.logger.info(msg);
                }
            });
        }
        terminateExecutors.shutdown();
        boolean terminated = false;
        while (!terminated) {
            try {
                terminated = terminateExecutors.awaitTermination(30L, TimeUnit.SECONDS);
            }
            catch (InterruptedException interruptedException) {}
        }
        this.logger.info("Terminated all running activities successfully.");
    }
}

