/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.core.runtimeservice.defaultimplementation;

import de.aristaflow.adept2.core.runtimeservice.defaultimplementation.ExecutionMessageReceiver;
import de.aristaflow.adept2.model.runtimeenvironment.messages.execution.ExecutionMessage;
import de.aristaflow.adept2.model.runtimeenvironment.messages.execution.ReplyMessage;
import de.aristaflow.adept2.util.Pair;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class PullMessageExchange
implements ExecutionMessageReceiver {
    protected final Lock lock = new ReentrantLock(true);
    protected final List<ExecutionMessage> requests = new ArrayList<ExecutionMessage>();
    protected final Map<ExecutionMessage, Pair<Condition, Thread>> requestSenders = new HashMap<ExecutionMessage, Pair<Condition, Thread>>();
    protected final Map<Long, ReplyMessage<?>> replies = new HashMap();
    protected volatile boolean terminated = false;

    @Override
    public void sendMessageToExecution(ExecutionMessage msg) {
        if (!this.terminated) {
            this.lock.lock();
            try {
                this.requests.add(msg);
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    @Override
    public ReplyMessage<?> sendMessageToExecution(ReplyMessage<?> msg, long timeout) throws InterruptedException {
        this.lock.lock();
        try {
            if (this.terminated) {
                throw new InterruptedException("The message exchange has been closed.");
            }
            Condition reply = this.lock.newCondition();
            this.requests.add(msg);
            this.requestSenders.put(msg, new Pair<Condition, Thread>(reply, Thread.currentThread()));
            if (timeout > 0L) {
                reply.await(timeout, TimeUnit.MILLISECONDS);
            } else {
                reply.await();
            }
            ReplyMessage<?> ret = this.replies.remove(msg.getMessageID());
            if (ret == null) {
                this.requests.remove(msg);
                this.requestSenders.remove(msg);
            }
            ReplyMessage<?> replyMessage = ret;
            return replyMessage;
        }
        finally {
            this.lock.unlock();
        }
    }

    public List<ExecutionMessage> getUnrepliedRequests() {
        this.lock.lock();
        try {
            ArrayList<ExecutionMessage> ret = new ArrayList<ExecutionMessage>(this.requests);
            Iterator<ExecutionMessage> iterator = this.requests.iterator();
            while (iterator.hasNext()) {
                ExecutionMessage current = iterator.next();
                if (this.requestSenders.containsKey(current)) continue;
                iterator.remove();
            }
            ArrayList<ExecutionMessage> arrayList = ret;
            return arrayList;
        }
        finally {
            this.lock.unlock();
        }
    }

    public boolean replyMessage(ReplyMessage<?> reply) {
        this.lock.lock();
        try {
            Pair<Condition, Thread> requestor = null;
            Iterator<ExecutionMessage> iterator = this.requests.iterator();
            while (iterator.hasNext()) {
                ExecutionMessage current = iterator.next();
                if (!this.requestSenders.containsKey(current)) continue;
                iterator.remove();
                requestor = this.requestSenders.remove(current);
                break;
            }
            if (requestor != null) {
                this.replies.put(reply.getMessageID(), reply);
                ((Condition)requestor.getFirst()).signalAll();
            }
            boolean bl = requestor != null;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void sessionTerminated() {
        this.lock.lock();
        try {
            this.terminated = true;
            for (Pair<Condition, Thread> sender : this.requestSenders.values()) {
                sender.getSecond().interrupt();
            }
            this.requestSenders.clear();
        }
        finally {
            this.lock.unlock();
        }
    }
}

