/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.core.runtimeservice.defaultimplementation;

import de.aristaflow.adept2.base.service.InternalServiceException;
import de.aristaflow.adept2.core.runtimeservice.ExecutionMessageNotification;
import de.aristaflow.adept2.core.runtimeservice.defaultimplementation.ExecutionMessageReceiver;
import de.aristaflow.adept2.model.runtimeenvironment.messages.execution.ExecutionMessage;
import de.aristaflow.adept2.model.runtimeenvironment.messages.execution.ReplyMessage;
import java.util.Collection;
import java.util.HashSet;
import java.util.concurrent.ExecutorService;

public class PushMessageExchange
implements ExecutionMessageReceiver {
    protected final ExecutionMessageNotification notification;
    protected final ExecutorService executors;
    protected final Collection<Thread> waiters;
    protected volatile boolean terminated;

    public PushMessageExchange(ExecutionMessageNotification notification, ExecutorService executors) {
        this.notification = notification;
        this.executors = executors;
        this.waiters = new HashSet<Thread>();
        this.terminated = false;
    }

    @Override
    public void sendMessageToExecution(final ExecutionMessage msg) {
        this.executors.execute(new Runnable(){

            @Override
            public void run() {
                PushMessageExchange.this.notification.dispatch(msg);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ReplyMessage<?> sendMessageToExecution(final ReplyMessage<?> repMsg, long timeout) throws InterruptedException {
        Object lock;
        final ExecutionMessage[] ret = new ExecutionMessage[1];
        Object object = lock = new Object();
        synchronized (object) {
            this.executors.execute(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    if (!PushMessageExchange.this.terminated) {
                        ReplyMessage<?> reply = PushMessageExchange.this.notification.dispatch(repMsg);
                        Object object = lock;
                        synchronized (object) {
                            ret[0] = reply;
                            lock.notifyAll();
                        }
                    }
                }
            });
            Collection<Thread> collection = this.waiters;
            synchronized (collection) {
                if (this.terminated) {
                    throw new InterruptedException("The message exchange has been closed.");
                }
                this.waiters.add(Thread.currentThread());
            }
            try {
                lock.wait(timeout);
            }
            catch (Throwable throwable) {
                Collection<Thread> collection2 = this.waiters;
                synchronized (collection2) {
                    if (this.terminated) {
                        throw new InterruptedException();
                    }
                    this.waiters.remove(Thread.currentThread());
                }
                throw throwable;
            }
            Collection<Thread> collection3 = this.waiters;
            synchronized (collection3) {
                if (this.terminated) {
                    throw new InterruptedException();
                }
                this.waiters.remove(Thread.currentThread());
            }
            if (ret[0] != null && !(ret[0] instanceof ReplyMessage)) {
                String msg = "The execution of session '%s' did not reply with a ReplyMessage<?> although this is expected and had been sent. The client seems to implement ExecutionMessageNotification wrongly.";
                throw new InternalServiceException(String.format(msg, repMsg.getSessionID()));
            }
            return (ReplyMessage)ret[0];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sessionTerminated() {
        Collection<Thread> collection = this.waiters;
        synchronized (collection) {
            this.terminated = true;
            for (Thread thread : this.waiters) {
                thread.interrupt();
            }
        }
    }
}

