/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.core.runtimeservice.defaultimplementation;

import de.aristaflow.adept2.base.service.AbstractADEPT2Service;
import de.aristaflow.adept2.base.service.ServiceAccessControlException;
import de.aristaflow.adept2.base.sessionmanagement.QualifiedAgent;
import de.aristaflow.adept2.base.sessionmanagement.SecurityTokenIntegrityException;
import de.aristaflow.adept2.base.sessionmanagement.SessionFactory;
import de.aristaflow.adept2.base.sessionmanagement.SessionToken;
import de.aristaflow.adept2.core.runtimemanager.commonimplementation.ActivityManager;
import de.aristaflow.adept2.core.runtimeservice.defaultimplementation.DefaultRemoteProgressMonitor;
import de.aristaflow.adept2.core.runtimeservice.defaultimplementation.DefaultRemoteRuntimeEnvironment;
import de.aristaflow.adept2.core.runtimeservice.defaultimplementation.ExecutionMessageReceiver;
import de.aristaflow.adept2.core.runtimeservice.defaultimplementation.SessionChecker;
import de.aristaflow.adept2.model.processmodel.EBPInstanceReference;
import de.aristaflow.adept2.model.runtimeenvironment.GUIContext;
import de.aristaflow.adept2.model.runtimeenvironment.TerminatedActivityState;
import de.aristaflow.adept2.model.runtimeenvironment.UnknownSessionException;
import de.aristaflow.adept2.util.ArgChecks;
import java.net.URI;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.logging.Level;

public class RTServiceActivityManager
extends ActivityManager
implements SessionChecker {
    protected final SessionFactory sessionFactory;
    protected final URI[] rsURIs;
    protected final Map<String, SessionToken> sessions;
    protected DefaultRemoteRuntimeEnvironment runtimeEnvironments;
    protected DefaultRemoteProgressMonitor monitors;

    protected RTServiceActivityManager(AbstractADEPT2Service service, SessionFactory sessionFactory) {
        super(service);
        this.sessionFactory = sessionFactory;
        this.rsURIs = service.getURIs();
        this.sessions = new HashMap<String, SessionToken>();
    }

    public void addForTerminationNotification(DefaultRemoteRuntimeEnvironment runtimeEnvironments, DefaultRemoteProgressMonitor monitors) {
        this.runtimeEnvironments = runtimeEnvironments;
        this.monitors = monitors;
    }

    @Override
    public void activityInitialising(SessionToken session, EBPInstanceReference activity, String sessionID, GUIContext guiContext) {
        ArgChecks.checkForNull(session, "session");
        Lock writeLock = this.rwLock.writeLock();
        writeLock.lock();
        try {
            this.sessions.put(sessionID, session);
            super.activityInitialising(session, activity, sessionID, guiContext);
        }
        finally {
            writeLock.unlock();
        }
    }

    @Override
    public void activityTerminated(SessionToken session, EBPInstanceReference activity, TerminatedActivityState terminatedState) {
        block8: {
            Lock writeLock = this.rwLock.writeLock();
            writeLock.lock();
            try {
                String sessionID = this.getSessionID(session, activity);
                super.activityTerminated(session, activity, terminatedState);
                if (sessionID != null) {
                    try {
                        SessionToken token = this.sessionFactory.getSessionToken(this.rsURIs);
                        this.sessions.remove(sessionID);
                        if (this.monitors != null) {
                            this.monitors.remove(sessionID);
                        }
                        if (this.runtimeEnvironments != null) {
                            ExecutionMessageReceiver receiver = this.runtimeEnvironments.getMessageReceiver(token, sessionID);
                            receiver.sessionTerminated();
                            this.runtimeEnvironments.remove(sessionID);
                        }
                        break block8;
                    }
                    catch (UnknownSessionException use) {
                        String msg = "Could not remove message exchange and runtime environment for execution session '%s' of activity '%s'. Ignoring and continuing with its termination.";
                        this.logger.log(Level.INFO, String.format(msg, sessionID, activity), use);
                    }
                    break block8;
                }
                String msg = "Could not remove data structures for execution session of activity '%s'. Ignoring and continuing with its termination.";
                this.logger.info(String.format(msg, activity));
            }
            finally {
                writeLock.unlock();
            }
        }
    }

    @Override
    public void checkSessions(SessionToken token, String sessionID) throws UnknownSessionException {
        Lock readLock = this.rwLock.readLock();
        readLock.lock();
        try {
            try {
                QualifiedAgent tlAgent = this.sessionFactory.checkAndGetTopLevelAgent(token);
                SessionToken startToken = this.sessions.get(sessionID);
                if (startToken == null) {
                    throw new UnknownSessionException(sessionID);
                }
                QualifiedAgent startTLAgent = this.sessionFactory.checkAndGetTopLevelAgent(startToken);
                if (!(tlAgent.equals(startTLAgent) && token.getSessionID().equals(startToken.getSessionID()) && Arrays.equals(token.getCallingComponent(), startToken.getCallingComponent()))) {
                    String msg = "The designated session token '%s' is not valid for the execution session '%s'.";
                    msg = String.format(msg, token, sessionID);
                    throw new ServiceAccessControlException(msg);
                }
            }
            catch (SecurityTokenIntegrityException stie) {
                String msg = "The session token '%s' is not valid. Access denied.";
                throw new ServiceAccessControlException(String.format(msg, token), stie);
            }
        }
        finally {
            readLock.unlock();
        }
    }
}

