/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.core.sessionmanager.defaultimplementation;

import de.aristaflow.adept2.base.configuration.AbortServiceException;
import de.aristaflow.adept2.base.configuration.ConfigurationDescription;
import de.aristaflow.adept2.base.configuration.Property;
import de.aristaflow.adept2.base.security.AuthenticationException;
import de.aristaflow.adept2.base.security.SecurityManager;
import de.aristaflow.adept2.base.service.AbstractADEPT2Service;
import de.aristaflow.adept2.base.service.Registry;
import de.aristaflow.adept2.base.sessionmanagement.ClientSessionFactory;
import de.aristaflow.adept2.base.sessionmanagement.QualifiedAgent;
import de.aristaflow.adept2.base.sessionmanagement.SessionToken;
import de.aristaflow.adept2.core.sessionmanager.SessionManager;
import de.aristaflow.adept2.util.DataSourceException;
import de.aristaflow.adept2.util.UUIDTools;
import java.net.URI;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.commons.configuration.Configuration;

@ConfigurationDescription(properties={@Property(name="Timeout", type=Property.Type.LONG, defaultValue="1800000", description="The amount of time until a session factory will be invalidated.")})
public class DefaultSessionManager
extends AbstractADEPT2Service
implements SessionManager {
    protected static final String TIMEOUT = "Timeout";
    private SecurityManager securityManager;
    private Map<String, ClientSessionFactory> csfMap = new HashMap<String, ClientSessionFactory>();
    Map<String, Long> validMap = new HashMap<String, Long>();
    private final long timeout;

    public DefaultSessionManager(Configuration configuration, Registry registry) {
        super(configuration, registry);
        this.timeout = Long.valueOf(configuration.getString(TIMEOUT));
    }

    @Override
    public List<QualifiedAgent> authenticate(int agentID, String password) throws AuthenticationException, DataSourceException {
        return this.securityManager.authenticate(agentID, password);
    }

    @Override
    public List<QualifiedAgent> authenticate(String agentName, String password) throws AuthenticationException, DataSourceException {
        return this.securityManager.authenticate(agentName, password);
    }

    @Override
    public String authenticate(String agentID, int orgPositionID, String password) throws AuthenticationException, DataSourceException {
        ClientSessionFactory csf = this.securityManager.authenticate(agentID, (long)orgPositionID, password);
        String sessionFactory = UUIDTools.createRandomUUID().toString();
        this.csfMap.put(sessionFactory, csf);
        this.validMap.put(sessionFactory, System.currentTimeMillis() + this.timeout);
        return sessionFactory;
    }

    @Override
    public String authenticate(int agentID, int orgPositionID, String password) throws AuthenticationException, DataSourceException {
        ClientSessionFactory csf = this.securityManager.authenticate(agentID, (long)orgPositionID, password);
        String sessionFactory = UUIDTools.createRandomUUID().toString();
        this.csfMap.put(sessionFactory, csf);
        this.validMap.put(sessionFactory, System.currentTimeMillis() + this.timeout);
        return sessionFactory;
    }

    @Override
    public SessionToken getSessionToken(String session) throws AuthenticationException {
        if (System.currentTimeMillis() > this.validMap.get(session)) {
            this.validMap.remove(session);
            throw new AuthenticationException();
        }
        this.validMap.put(session, System.currentTimeMillis() + this.timeout);
        return this.csfMap.get(session).getSessionToken(this.getURIs());
    }

    @Override
    public void logoff(String session) {
        this.csfMap.remove(session);
        this.validMap.remove(session);
    }

    @Override
    public void init(URI[] exportedURIs) throws AbortServiceException {
        super.init(exportedURIs);
        this.securityManager = this.registry.getSecurityManager();
        Timer timer = new Timer("SessionManagerTimeout");
        SessionManagerTimerTask task = new SessionManagerTimerTask();
        timer.schedule((TimerTask)task, this.timeout);
    }

    @Override
    public void emergencyShutdown() {
        super.emergencyShutdown();
        this.csfMap.clear();
        this.validMap.clear();
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.csfMap.clear();
        this.validMap.clear();
    }

    private class SessionManagerTimerTask
    extends TimerTask {
        SessionManagerTimerTask() {
        }

        @Override
        public void run() {
            for (Map.Entry<String, Long> entry : DefaultSessionManager.this.validMap.entrySet()) {
                if (System.currentTimeMillis() <= entry.getValue()) continue;
                DefaultSessionManager.this.validMap.remove(entry.getKey());
            }
        }
    }
}

